/*
=============================================================================
 Copyright   : (c) 2008 semantics GmbH. All Rights Reserved.
 Rep./File   : $URL$
 Date        : $Date$
 Author      : Christian Heimes
 License     : FreeImage Public License (FIPL)
               GNU General Public License (GPL)
 Worker      : $Author$
 Revision    : $Rev$
 Purpose     : Simpe C module to expose FI constants and enums
=============================================================================

 COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN "AS IS" BASIS, WITHOUT
 WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, WARRANTIES THAT THE COVERED CODE IS FREE OF DEFECTS, MERCHANTABLE,
 FIT FOR A PARTICULAR PURPOSE OR NON-INFRINGING. THE ENTIRE RISK AS TO THE
 QUALITY AND PERFORMANCE OF THE COVERED CODE IS WITH YOU. SHOULD ANY COVERED
 CODE PROVE DEFECTIVE IN ANY RESPECT, YOU (NOT THE INITIAL DEVELOPER OR ANY
 OTHER CONTRIBUTOR) ASSUME THE COST OF ANY NECESSARY SERVICING, REPAIR OR
 CORRECTION. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL PART OF
 THIS LICENSE. NO USE OF ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER
 THIS DISCLAIMER.
*/

#include "Python.h"
#include "smc_fi.h"
#include "lcms2.h"

static PyMethodDef lcmsconstants_methods[] = {
    {NULL, NULL}    /* sentinel */
};

PyDoc_STRVAR(module_doc,
"LCMS constants.\n\
\n\
This module exposes all LCMS integer constants.");

#if PY_MAJOR_VERSION >= 3


static struct PyModuleDef moduledef = {
        PyModuleDef_HEAD_INIT,
        "lcmsconstants",
        module_doc,
        -1,
        lcmsconstants_methods,
        NULL,
        NULL,
        NULL,
        NULL
};

#define INITERROR return NULL

PyObject *
PyInit_lcmsconstants(void)

#else
#define INITERROR return

PyMODINIT_FUNC
initlcmsconstants(void)
#endif
{
    PyObject *m;
#if PY_MAJOR_VERSION >= 3
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule3("lcmsconstants", lcmsconstants_methods, module_doc);
#endif
    if (m == NULL)
        INITERROR;

    /* MARKER, the rest of the file is autogenerated! */
    PyModule_AddIntConstant(m, "lcmsSignature", lcmsSignature);
    PyModule_AddIntConstant(m, "TYPE_GRAY_8", TYPE_GRAY_8);
    PyModule_AddIntConstant(m, "TYPE_GRAY_8_REV", TYPE_GRAY_8_REV);
    PyModule_AddIntConstant(m, "TYPE_GRAY_16", TYPE_GRAY_16);
    PyModule_AddIntConstant(m, "TYPE_GRAY_16_REV", TYPE_GRAY_16_REV);
    PyModule_AddIntConstant(m, "TYPE_GRAY_16_SE", TYPE_GRAY_16_SE);
    PyModule_AddIntConstant(m, "TYPE_GRAYA_8", TYPE_GRAYA_8);
    PyModule_AddIntConstant(m, "TYPE_GRAYA_16", TYPE_GRAYA_16);
    PyModule_AddIntConstant(m, "TYPE_GRAYA_16_SE", TYPE_GRAYA_16_SE);
    PyModule_AddIntConstant(m, "TYPE_GRAYA_8_PLANAR", TYPE_GRAYA_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_GRAYA_16_PLANAR", TYPE_GRAYA_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_RGB_8", TYPE_RGB_8);
    PyModule_AddIntConstant(m, "TYPE_RGB_8_PLANAR", TYPE_RGB_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_BGR_8", TYPE_BGR_8);
    PyModule_AddIntConstant(m, "TYPE_BGR_8_PLANAR", TYPE_BGR_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_RGB_16", TYPE_RGB_16);
    PyModule_AddIntConstant(m, "TYPE_RGB_16_PLANAR", TYPE_RGB_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_RGB_16_SE", TYPE_RGB_16_SE);
    PyModule_AddIntConstant(m, "TYPE_BGR_16", TYPE_BGR_16);
    PyModule_AddIntConstant(m, "TYPE_BGR_16_PLANAR", TYPE_BGR_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_BGR_16_SE", TYPE_BGR_16_SE);
    PyModule_AddIntConstant(m, "TYPE_RGBA_8", TYPE_RGBA_8);
    PyModule_AddIntConstant(m, "TYPE_RGBA_8_PLANAR", TYPE_RGBA_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_RGBA_16", TYPE_RGBA_16);
    PyModule_AddIntConstant(m, "TYPE_RGBA_16_PLANAR", TYPE_RGBA_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_RGBA_16_SE", TYPE_RGBA_16_SE);
    PyModule_AddIntConstant(m, "TYPE_ARGB_8", TYPE_ARGB_8);
    PyModule_AddIntConstant(m, "TYPE_ARGB_16", TYPE_ARGB_16);
    PyModule_AddIntConstant(m, "TYPE_ABGR_8", TYPE_ABGR_8);
    PyModule_AddIntConstant(m, "TYPE_ABGR_16", TYPE_ABGR_16);
    PyModule_AddIntConstant(m, "TYPE_ABGR_16_PLANAR", TYPE_ABGR_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_ABGR_16_SE", TYPE_ABGR_16_SE);
    PyModule_AddIntConstant(m, "TYPE_BGRA_8", TYPE_BGRA_8);
    PyModule_AddIntConstant(m, "TYPE_BGRA_16", TYPE_BGRA_16);
    PyModule_AddIntConstant(m, "TYPE_BGRA_16_SE", TYPE_BGRA_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMY_8", TYPE_CMY_8);
    PyModule_AddIntConstant(m, "TYPE_CMY_8_PLANAR", TYPE_CMY_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_CMY_16", TYPE_CMY_16);
    PyModule_AddIntConstant(m, "TYPE_CMY_16_PLANAR", TYPE_CMY_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_CMY_16_SE", TYPE_CMY_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK_8", TYPE_CMYK_8);
    PyModule_AddIntConstant(m, "TYPE_CMYKA_8", TYPE_CMYKA_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK_8_REV", TYPE_CMYK_8_REV);
    PyModule_AddIntConstant(m, "TYPE_YUVK_8", TYPE_YUVK_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK_8_PLANAR", TYPE_CMYK_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_CMYK_16", TYPE_CMYK_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK_16_REV", TYPE_CMYK_16_REV);
    PyModule_AddIntConstant(m, "TYPE_YUVK_16", TYPE_YUVK_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK_16_PLANAR", TYPE_CMYK_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_CMYK_16_SE", TYPE_CMYK_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC_8", TYPE_KYMC_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC_16", TYPE_KYMC_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC_16_SE", TYPE_KYMC_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KCMY_8", TYPE_KCMY_8);
    PyModule_AddIntConstant(m, "TYPE_KCMY_8_REV", TYPE_KCMY_8_REV);
    PyModule_AddIntConstant(m, "TYPE_KCMY_16", TYPE_KCMY_16);
    PyModule_AddIntConstant(m, "TYPE_KCMY_16_REV", TYPE_KCMY_16_REV);
    PyModule_AddIntConstant(m, "TYPE_KCMY_16_SE", TYPE_KCMY_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK5_8", TYPE_CMYK5_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK5_16", TYPE_CMYK5_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK5_16_SE", TYPE_CMYK5_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC5_8", TYPE_KYMC5_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC5_16", TYPE_KYMC5_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC5_16_SE", TYPE_KYMC5_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK6_8", TYPE_CMYK6_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK6_8_PLANAR", TYPE_CMYK6_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_CMYK6_16", TYPE_CMYK6_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK6_16_PLANAR", TYPE_CMYK6_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_CMYK6_16_SE", TYPE_CMYK6_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK7_8", TYPE_CMYK7_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK7_16", TYPE_CMYK7_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK7_16_SE", TYPE_CMYK7_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC7_8", TYPE_KYMC7_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC7_16", TYPE_KYMC7_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC7_16_SE", TYPE_KYMC7_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK8_8", TYPE_CMYK8_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK8_16", TYPE_CMYK8_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK8_16_SE", TYPE_CMYK8_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC8_8", TYPE_KYMC8_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC8_16", TYPE_KYMC8_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC8_16_SE", TYPE_KYMC8_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK9_8", TYPE_CMYK9_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK9_16", TYPE_CMYK9_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK9_16_SE", TYPE_CMYK9_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC9_8", TYPE_KYMC9_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC9_16", TYPE_KYMC9_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC9_16_SE", TYPE_KYMC9_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK10_8", TYPE_CMYK10_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK10_16", TYPE_CMYK10_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK10_16_SE", TYPE_CMYK10_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC10_8", TYPE_KYMC10_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC10_16", TYPE_KYMC10_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC10_16_SE", TYPE_KYMC10_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK11_8", TYPE_CMYK11_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK11_16", TYPE_CMYK11_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK11_16_SE", TYPE_CMYK11_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC11_8", TYPE_KYMC11_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC11_16", TYPE_KYMC11_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC11_16_SE", TYPE_KYMC11_16_SE);
    PyModule_AddIntConstant(m, "TYPE_CMYK12_8", TYPE_CMYK12_8);
    PyModule_AddIntConstant(m, "TYPE_CMYK12_16", TYPE_CMYK12_16);
    PyModule_AddIntConstant(m, "TYPE_CMYK12_16_SE", TYPE_CMYK12_16_SE);
    PyModule_AddIntConstant(m, "TYPE_KYMC12_8", TYPE_KYMC12_8);
    PyModule_AddIntConstant(m, "TYPE_KYMC12_16", TYPE_KYMC12_16);
    PyModule_AddIntConstant(m, "TYPE_KYMC12_16_SE", TYPE_KYMC12_16_SE);
    PyModule_AddIntConstant(m, "TYPE_XYZ_16", TYPE_XYZ_16);
    PyModule_AddIntConstant(m, "TYPE_Lab_8", TYPE_Lab_8);
    PyModule_AddIntConstant(m, "TYPE_LabV2_8", TYPE_LabV2_8);
    PyModule_AddIntConstant(m, "TYPE_ALab_8", TYPE_ALab_8);
    PyModule_AddIntConstant(m, "TYPE_ALabV2_8", TYPE_ALabV2_8);
    PyModule_AddIntConstant(m, "TYPE_Lab_16", TYPE_Lab_16);
    PyModule_AddIntConstant(m, "TYPE_LabV2_16", TYPE_LabV2_16);
    PyModule_AddIntConstant(m, "TYPE_Yxy_16", TYPE_Yxy_16);
    PyModule_AddIntConstant(m, "TYPE_YCbCr_8", TYPE_YCbCr_8);
    PyModule_AddIntConstant(m, "TYPE_YCbCr_8_PLANAR", TYPE_YCbCr_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_YCbCr_16", TYPE_YCbCr_16);
    PyModule_AddIntConstant(m, "TYPE_YCbCr_16_PLANAR", TYPE_YCbCr_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_YCbCr_16_SE", TYPE_YCbCr_16_SE);
    PyModule_AddIntConstant(m, "TYPE_YUV_8", TYPE_YUV_8);
    PyModule_AddIntConstant(m, "TYPE_YUV_8_PLANAR", TYPE_YUV_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_YUV_16", TYPE_YUV_16);
    PyModule_AddIntConstant(m, "TYPE_YUV_16_PLANAR", TYPE_YUV_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_YUV_16_SE", TYPE_YUV_16_SE);
    PyModule_AddIntConstant(m, "TYPE_HLS_8", TYPE_HLS_8);
    PyModule_AddIntConstant(m, "TYPE_HLS_8_PLANAR", TYPE_HLS_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_HLS_16", TYPE_HLS_16);
    PyModule_AddIntConstant(m, "TYPE_HLS_16_PLANAR", TYPE_HLS_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_HLS_16_SE", TYPE_HLS_16_SE);
    PyModule_AddIntConstant(m, "TYPE_HSV_8", TYPE_HSV_8);
    PyModule_AddIntConstant(m, "TYPE_HSV_8_PLANAR", TYPE_HSV_8_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_HSV_16", TYPE_HSV_16);
    PyModule_AddIntConstant(m, "TYPE_HSV_16_PLANAR", TYPE_HSV_16_PLANAR);
    PyModule_AddIntConstant(m, "TYPE_HSV_16_SE", TYPE_HSV_16_SE);
    PyModule_AddIntConstant(m, "TYPE_NAMED_COLOR_INDEX", TYPE_NAMED_COLOR_INDEX);
    PyModule_AddIntConstant(m, "TYPE_XYZ_FLT", TYPE_XYZ_FLT);
    PyModule_AddIntConstant(m, "TYPE_XYZA_FLT", TYPE_XYZA_FLT);
    PyModule_AddIntConstant(m, "TYPE_Lab_FLT", TYPE_Lab_FLT);
    PyModule_AddIntConstant(m, "TYPE_LabA_FLT", TYPE_LabA_FLT);
    PyModule_AddIntConstant(m, "TYPE_GRAY_FLT", TYPE_GRAY_FLT);
    PyModule_AddIntConstant(m, "TYPE_RGB_FLT", TYPE_RGB_FLT);
    PyModule_AddIntConstant(m, "TYPE_RGBA_FLT", TYPE_RGBA_FLT);
    PyModule_AddIntConstant(m, "TYPE_CMYK_FLT", TYPE_CMYK_FLT);
    PyModule_AddIntConstant(m, "TYPE_XYZ_DBL", TYPE_XYZ_DBL);
    PyModule_AddIntConstant(m, "TYPE_Lab_DBL", TYPE_Lab_DBL);
    PyModule_AddIntConstant(m, "TYPE_GRAY_DBL", TYPE_GRAY_DBL);
    PyModule_AddIntConstant(m, "TYPE_RGB_DBL", TYPE_RGB_DBL);
    PyModule_AddIntConstant(m, "TYPE_CMYK_DBL", TYPE_CMYK_DBL);
    PyModule_AddIntConstant(m, "cmsERROR_UNDEFINED", cmsERROR_UNDEFINED);
    PyModule_AddIntConstant(m, "cmsERROR_FILE", cmsERROR_FILE);
    PyModule_AddIntConstant(m, "cmsERROR_RANGE", cmsERROR_RANGE);
    PyModule_AddIntConstant(m, "cmsERROR_INTERNAL", cmsERROR_INTERNAL);
    PyModule_AddIntConstant(m, "cmsERROR_NULL", cmsERROR_NULL);
    PyModule_AddIntConstant(m, "cmsERROR_READ", cmsERROR_READ);
    PyModule_AddIntConstant(m, "cmsERROR_SEEK", cmsERROR_SEEK);
    PyModule_AddIntConstant(m, "cmsERROR_WRITE", cmsERROR_WRITE);
    PyModule_AddIntConstant(m, "cmsERROR_UNKNOWN_EXTENSION", cmsERROR_UNKNOWN_EXTENSION);
    PyModule_AddIntConstant(m, "cmsERROR_COLORSPACE_CHECK", cmsERROR_COLORSPACE_CHECK);
    PyModule_AddIntConstant(m, "cmsERROR_ALREADY_DEFINED", cmsERROR_ALREADY_DEFINED);
    PyModule_AddIntConstant(m, "cmsERROR_BAD_SIGNATURE", cmsERROR_BAD_SIGNATURE);
    PyModule_AddIntConstant(m, "cmsERROR_CORRUPTION_DETECTED", cmsERROR_CORRUPTION_DETECTED);
    PyModule_AddIntConstant(m, "cmsERROR_NOT_SUITABLE", cmsERROR_NOT_SUITABLE);
    PyModule_AddIntConstant(m, "LCMS_USED_AS_INPUT", LCMS_USED_AS_INPUT);
    PyModule_AddIntConstant(m, "LCMS_USED_AS_OUTPUT", LCMS_USED_AS_OUTPUT);
    PyModule_AddIntConstant(m, "LCMS_USED_AS_PROOF", LCMS_USED_AS_PROOF);
    PyModule_AddIntConstant(m, "INTENT_PERCEPTUAL", INTENT_PERCEPTUAL);
    PyModule_AddIntConstant(m, "INTENT_RELATIVE_COLORIMETRIC", INTENT_RELATIVE_COLORIMETRIC);
    PyModule_AddIntConstant(m, "INTENT_SATURATION", INTENT_SATURATION);
    PyModule_AddIntConstant(m, "INTENT_ABSOLUTE_COLORIMETRIC", INTENT_ABSOLUTE_COLORIMETRIC);
    PyModule_AddIntConstant(m, "INTENT_PRESERVE_K_ONLY_PERCEPTUAL", INTENT_PRESERVE_K_ONLY_PERCEPTUAL);
    PyModule_AddIntConstant(m, "INTENT_PRESERVE_K_ONLY_RELATIVE_COLORIMETRIC", INTENT_PRESERVE_K_ONLY_RELATIVE_COLORIMETRIC);
    PyModule_AddIntConstant(m, "INTENT_PRESERVE_K_ONLY_SATURATION", INTENT_PRESERVE_K_ONLY_SATURATION);
    PyModule_AddIntConstant(m, "INTENT_PRESERVE_K_PLANE_PERCEPTUAL", INTENT_PRESERVE_K_PLANE_PERCEPTUAL);
    PyModule_AddIntConstant(m, "INTENT_PRESERVE_K_PLANE_RELATIVE_COLORIMETRIC", INTENT_PRESERVE_K_PLANE_RELATIVE_COLORIMETRIC);
    PyModule_AddIntConstant(m, "INTENT_PRESERVE_K_PLANE_SATURATION", INTENT_PRESERVE_K_PLANE_SATURATION);
    PyModule_AddIntConstant(m, "cmsFLAGS_NOCACHE", cmsFLAGS_NOCACHE);
    PyModule_AddIntConstant(m, "cmsFLAGS_NOOPTIMIZE", cmsFLAGS_NOOPTIMIZE);
    PyModule_AddIntConstant(m, "cmsFLAGS_NULLTRANSFORM", cmsFLAGS_NULLTRANSFORM);
    PyModule_AddIntConstant(m, "cmsFLAGS_GAMUTCHECK", cmsFLAGS_GAMUTCHECK);
    PyModule_AddIntConstant(m, "cmsFLAGS_SOFTPROOFING", cmsFLAGS_SOFTPROOFING);
    PyModule_AddIntConstant(m, "cmsFLAGS_BLACKPOINTCOMPENSATION", cmsFLAGS_BLACKPOINTCOMPENSATION);
    PyModule_AddIntConstant(m, "cmsFLAGS_NOWHITEONWHITEFIXUP", cmsFLAGS_NOWHITEONWHITEFIXUP);
    PyModule_AddIntConstant(m, "cmsFLAGS_HIGHRESPRECALC", cmsFLAGS_HIGHRESPRECALC);
    PyModule_AddIntConstant(m, "cmsFLAGS_LOWRESPRECALC", cmsFLAGS_LOWRESPRECALC);
    PyModule_AddIntConstant(m, "cmsFLAGS_8BITS_DEVICELINK", cmsFLAGS_8BITS_DEVICELINK);
    PyModule_AddIntConstant(m, "cmsFLAGS_GUESSDEVICECLASS", cmsFLAGS_GUESSDEVICECLASS);
    PyModule_AddIntConstant(m, "cmsFLAGS_KEEP_SEQUENCE", cmsFLAGS_KEEP_SEQUENCE);
    PyModule_AddIntConstant(m, "cmsFLAGS_FORCE_CLUT", cmsFLAGS_FORCE_CLUT);
    PyModule_AddIntConstant(m, "cmsFLAGS_CLUT_POST_LINEARIZATION", cmsFLAGS_CLUT_POST_LINEARIZATION);
    PyModule_AddIntConstant(m, "cmsFLAGS_CLUT_PRE_LINEARIZATION", cmsFLAGS_CLUT_PRE_LINEARIZATION);
    PyModule_AddIntConstant(m, "cmsFLAGS_NODEFAULTRESOURCEDEF", cmsFLAGS_NODEFAULTRESOURCEDEF);
    PyModule_AddIntConstant(m, "cmsSigInputClass", cmsSigInputClass);
    PyModule_AddIntConstant(m, "cmsSigDisplayClass", cmsSigDisplayClass);
    PyModule_AddIntConstant(m, "cmsSigOutputClass", cmsSigOutputClass);
    PyModule_AddIntConstant(m, "cmsSigLinkClass", cmsSigLinkClass);
    PyModule_AddIntConstant(m, "cmsSigAbstractClass", cmsSigAbstractClass);
    PyModule_AddIntConstant(m, "cmsSigColorSpaceClass", cmsSigColorSpaceClass);
    PyModule_AddIntConstant(m, "cmsSigNamedColorClass", cmsSigNamedColorClass);
    PyModule_AddIntConstant(m, "cmsSigXYZData", cmsSigXYZData);
    PyModule_AddIntConstant(m, "cmsSigLabData", cmsSigLabData);
    PyModule_AddIntConstant(m, "cmsSigLuvData", cmsSigLuvData);
    PyModule_AddIntConstant(m, "cmsSigYCbCrData", cmsSigYCbCrData);
    PyModule_AddIntConstant(m, "cmsSigYxyData", cmsSigYxyData);
    PyModule_AddIntConstant(m, "cmsSigRgbData", cmsSigRgbData);
    PyModule_AddIntConstant(m, "cmsSigGrayData", cmsSigGrayData);
    PyModule_AddIntConstant(m, "cmsSigHsvData", cmsSigHsvData);
    PyModule_AddIntConstant(m, "cmsSigHlsData", cmsSigHlsData);
    PyModule_AddIntConstant(m, "cmsSigCmykData", cmsSigCmykData);
    PyModule_AddIntConstant(m, "cmsSigCmyData", cmsSigCmyData);
    PyModule_AddIntConstant(m, "cmsSigMCH1Data", cmsSigMCH1Data);
    PyModule_AddIntConstant(m, "cmsSigMCH2Data", cmsSigMCH2Data);
    PyModule_AddIntConstant(m, "cmsSigMCH3Data", cmsSigMCH3Data);
    PyModule_AddIntConstant(m, "cmsSigMCH4Data", cmsSigMCH4Data);
    PyModule_AddIntConstant(m, "cmsSigMCH5Data", cmsSigMCH5Data);
    PyModule_AddIntConstant(m, "cmsSigMCH6Data", cmsSigMCH6Data);
    PyModule_AddIntConstant(m, "cmsSigMCH7Data", cmsSigMCH7Data);
    PyModule_AddIntConstant(m, "cmsSigMCH8Data", cmsSigMCH8Data);
    PyModule_AddIntConstant(m, "cmsSigMCH9Data", cmsSigMCH9Data);
    PyModule_AddIntConstant(m, "cmsSigMCHAData", cmsSigMCHAData);
    PyModule_AddIntConstant(m, "cmsSigMCHBData", cmsSigMCHBData);
    PyModule_AddIntConstant(m, "cmsSigMCHCData", cmsSigMCHCData);
    PyModule_AddIntConstant(m, "cmsSigMCHDData", cmsSigMCHDData);
    PyModule_AddIntConstant(m, "cmsSigMCHEData", cmsSigMCHEData);
    PyModule_AddIntConstant(m, "cmsSigMCHFData", cmsSigMCHFData);
    PyModule_AddIntConstant(m, "cmsSigNamedData", cmsSigNamedData);
    PyModule_AddIntConstant(m, "cmsSig1colorData", cmsSig1colorData);
    PyModule_AddIntConstant(m, "cmsSig2colorData", cmsSig2colorData);
    PyModule_AddIntConstant(m, "cmsSig3colorData", cmsSig3colorData);
    PyModule_AddIntConstant(m, "cmsSig4colorData", cmsSig4colorData);
    PyModule_AddIntConstant(m, "cmsSig5colorData", cmsSig5colorData);
    PyModule_AddIntConstant(m, "cmsSig6colorData", cmsSig6colorData);
    PyModule_AddIntConstant(m, "cmsSig7colorData", cmsSig7colorData);
    PyModule_AddIntConstant(m, "cmsSig8colorData", cmsSig8colorData);
    PyModule_AddIntConstant(m, "cmsSig9colorData", cmsSig9colorData);
    PyModule_AddIntConstant(m, "cmsSig10colorData", cmsSig10colorData);
    PyModule_AddIntConstant(m, "cmsSig11colorData", cmsSig11colorData);
    PyModule_AddIntConstant(m, "cmsSig12colorData", cmsSig12colorData);
    PyModule_AddIntConstant(m, "cmsSig13colorData", cmsSig13colorData);
    PyModule_AddIntConstant(m, "cmsSig14colorData", cmsSig14colorData);
    PyModule_AddIntConstant(m, "cmsSig15colorData", cmsSig15colorData);
    PyModule_AddIntConstant(m, "cmsSigLuvKData", cmsSigLuvKData);
    PyModule_AddIntConstant(m, "cmsSigChromaticityType", cmsSigChromaticityType);
    PyModule_AddIntConstant(m, "cmsSigColorantOrderType", cmsSigColorantOrderType);
    PyModule_AddIntConstant(m, "cmsSigColorantTableType", cmsSigColorantTableType);
    PyModule_AddIntConstant(m, "cmsSigCrdInfoType", cmsSigCrdInfoType);
    PyModule_AddIntConstant(m, "cmsSigCurveType", cmsSigCurveType);
    PyModule_AddIntConstant(m, "cmsSigDataType", cmsSigDataType);
    PyModule_AddIntConstant(m, "cmsSigDictType", cmsSigDictType);
    PyModule_AddIntConstant(m, "cmsSigDateTimeType", cmsSigDateTimeType);
    PyModule_AddIntConstant(m, "cmsSigDeviceSettingsType", cmsSigDeviceSettingsType);
    PyModule_AddIntConstant(m, "cmsSigLut16Type", cmsSigLut16Type);
    PyModule_AddIntConstant(m, "cmsSigLut8Type", cmsSigLut8Type);
    PyModule_AddIntConstant(m, "cmsSigLutAtoBType", cmsSigLutAtoBType);
    PyModule_AddIntConstant(m, "cmsSigLutBtoAType", cmsSigLutBtoAType);
    PyModule_AddIntConstant(m, "cmsSigMeasurementType", cmsSigMeasurementType);
    PyModule_AddIntConstant(m, "cmsSigMultiLocalizedUnicodeType", cmsSigMultiLocalizedUnicodeType);
    PyModule_AddIntConstant(m, "cmsSigMultiProcessElementType", cmsSigMultiProcessElementType);
    PyModule_AddIntConstant(m, "cmsSigNamedColorType", cmsSigNamedColorType);
    PyModule_AddIntConstant(m, "cmsSigNamedColor2Type", cmsSigNamedColor2Type);
    PyModule_AddIntConstant(m, "cmsSigParametricCurveType", cmsSigParametricCurveType);
    PyModule_AddIntConstant(m, "cmsSigProfileSequenceDescType", cmsSigProfileSequenceDescType);
    PyModule_AddIntConstant(m, "cmsSigProfileSequenceIdType", cmsSigProfileSequenceIdType);
    PyModule_AddIntConstant(m, "cmsSigResponseCurveSet16Type", cmsSigResponseCurveSet16Type);
    PyModule_AddIntConstant(m, "cmsSigS15Fixed16ArrayType", cmsSigS15Fixed16ArrayType);
    PyModule_AddIntConstant(m, "cmsSigScreeningType", cmsSigScreeningType);
    PyModule_AddIntConstant(m, "cmsSigSignatureType", cmsSigSignatureType);
    PyModule_AddIntConstant(m, "cmsSigTextType", cmsSigTextType);
    PyModule_AddIntConstant(m, "cmsSigTextDescriptionType", cmsSigTextDescriptionType);
    PyModule_AddIntConstant(m, "cmsSigU16Fixed16ArrayType", cmsSigU16Fixed16ArrayType);
    PyModule_AddIntConstant(m, "cmsSigUcrBgType", cmsSigUcrBgType);
    PyModule_AddIntConstant(m, "cmsSigUInt16ArrayType", cmsSigUInt16ArrayType);
    PyModule_AddIntConstant(m, "cmsSigUInt32ArrayType", cmsSigUInt32ArrayType);
    PyModule_AddIntConstant(m, "cmsSigUInt64ArrayType", cmsSigUInt64ArrayType);
    PyModule_AddIntConstant(m, "cmsSigUInt8ArrayType", cmsSigUInt8ArrayType);
    PyModule_AddIntConstant(m, "cmsSigVcgtType", cmsSigVcgtType);
    PyModule_AddIntConstant(m, "cmsSigViewingConditionsType", cmsSigViewingConditionsType);
    PyModule_AddIntConstant(m, "cmsSigXYZType", cmsSigXYZType);
    PyModule_AddIntConstant(m, "cmsSigAToB0Tag", cmsSigAToB0Tag);
    PyModule_AddIntConstant(m, "cmsSigAToB1Tag", cmsSigAToB1Tag);
    PyModule_AddIntConstant(m, "cmsSigAToB2Tag", cmsSigAToB2Tag);
    PyModule_AddIntConstant(m, "cmsSigBlueColorantTag", cmsSigBlueColorantTag);
    PyModule_AddIntConstant(m, "cmsSigBlueMatrixColumnTag", cmsSigBlueMatrixColumnTag);
    PyModule_AddIntConstant(m, "cmsSigBlueTRCTag", cmsSigBlueTRCTag);
    PyModule_AddIntConstant(m, "cmsSigBToA0Tag", cmsSigBToA0Tag);
    PyModule_AddIntConstant(m, "cmsSigBToA1Tag", cmsSigBToA1Tag);
    PyModule_AddIntConstant(m, "cmsSigBToA2Tag", cmsSigBToA2Tag);
    PyModule_AddIntConstant(m, "cmsSigCalibrationDateTimeTag", cmsSigCalibrationDateTimeTag);
    PyModule_AddIntConstant(m, "cmsSigCharTargetTag", cmsSigCharTargetTag);
    PyModule_AddIntConstant(m, "cmsSigChromaticAdaptationTag", cmsSigChromaticAdaptationTag);
    PyModule_AddIntConstant(m, "cmsSigChromaticityTag", cmsSigChromaticityTag);
    PyModule_AddIntConstant(m, "cmsSigColorantOrderTag", cmsSigColorantOrderTag);
    PyModule_AddIntConstant(m, "cmsSigColorantTableTag", cmsSigColorantTableTag);
    PyModule_AddIntConstant(m, "cmsSigColorantTableOutTag", cmsSigColorantTableOutTag);
    PyModule_AddIntConstant(m, "cmsSigColorimetricIntentImageStateTag", cmsSigColorimetricIntentImageStateTag);
    PyModule_AddIntConstant(m, "cmsSigCopyrightTag", cmsSigCopyrightTag);
    PyModule_AddIntConstant(m, "cmsSigCrdInfoTag", cmsSigCrdInfoTag);
    PyModule_AddIntConstant(m, "cmsSigDataTag", cmsSigDataTag);
    PyModule_AddIntConstant(m, "cmsSigDateTimeTag", cmsSigDateTimeTag);
    PyModule_AddIntConstant(m, "cmsSigDeviceMfgDescTag", cmsSigDeviceMfgDescTag);
    PyModule_AddIntConstant(m, "cmsSigDeviceModelDescTag", cmsSigDeviceModelDescTag);
    PyModule_AddIntConstant(m, "cmsSigDeviceSettingsTag", cmsSigDeviceSettingsTag);
    PyModule_AddIntConstant(m, "cmsSigDToB0Tag", cmsSigDToB0Tag);
    PyModule_AddIntConstant(m, "cmsSigDToB1Tag", cmsSigDToB1Tag);
    PyModule_AddIntConstant(m, "cmsSigDToB2Tag", cmsSigDToB2Tag);
    PyModule_AddIntConstant(m, "cmsSigDToB3Tag", cmsSigDToB3Tag);
    PyModule_AddIntConstant(m, "cmsSigBToD0Tag", cmsSigBToD0Tag);
    PyModule_AddIntConstant(m, "cmsSigBToD1Tag", cmsSigBToD1Tag);
    PyModule_AddIntConstant(m, "cmsSigBToD2Tag", cmsSigBToD2Tag);
    PyModule_AddIntConstant(m, "cmsSigBToD3Tag", cmsSigBToD3Tag);
    PyModule_AddIntConstant(m, "cmsSigGamutTag", cmsSigGamutTag);
    PyModule_AddIntConstant(m, "cmsSigGrayTRCTag", cmsSigGrayTRCTag);
    PyModule_AddIntConstant(m, "cmsSigGreenColorantTag", cmsSigGreenColorantTag);
    PyModule_AddIntConstant(m, "cmsSigGreenMatrixColumnTag", cmsSigGreenMatrixColumnTag);
    PyModule_AddIntConstant(m, "cmsSigGreenTRCTag", cmsSigGreenTRCTag);
    PyModule_AddIntConstant(m, "cmsSigLuminanceTag", cmsSigLuminanceTag);
    PyModule_AddIntConstant(m, "cmsSigMeasurementTag", cmsSigMeasurementTag);
    PyModule_AddIntConstant(m, "cmsSigMediaBlackPointTag", cmsSigMediaBlackPointTag);
    PyModule_AddIntConstant(m, "cmsSigMediaWhitePointTag", cmsSigMediaWhitePointTag);
    PyModule_AddIntConstant(m, "cmsSigNamedColorTag", cmsSigNamedColorTag);
    PyModule_AddIntConstant(m, "cmsSigNamedColor2Tag", cmsSigNamedColor2Tag);
    PyModule_AddIntConstant(m, "cmsSigOutputResponseTag", cmsSigOutputResponseTag);
    PyModule_AddIntConstant(m, "cmsSigPerceptualRenderingIntentGamutTag", cmsSigPerceptualRenderingIntentGamutTag);
    PyModule_AddIntConstant(m, "cmsSigPreview0Tag", cmsSigPreview0Tag);
    PyModule_AddIntConstant(m, "cmsSigPreview1Tag", cmsSigPreview1Tag);
    PyModule_AddIntConstant(m, "cmsSigPreview2Tag", cmsSigPreview2Tag);
    PyModule_AddIntConstant(m, "cmsSigProfileDescriptionTag", cmsSigProfileDescriptionTag);
    PyModule_AddIntConstant(m, "cmsSigProfileSequenceDescTag", cmsSigProfileSequenceDescTag);
    PyModule_AddIntConstant(m, "cmsSigProfileSequenceIdTag", cmsSigProfileSequenceIdTag);
    PyModule_AddIntConstant(m, "cmsSigPs2CRD0Tag", cmsSigPs2CRD0Tag);
    PyModule_AddIntConstant(m, "cmsSigPs2CRD1Tag", cmsSigPs2CRD1Tag);
    PyModule_AddIntConstant(m, "cmsSigPs2CRD2Tag", cmsSigPs2CRD2Tag);
    PyModule_AddIntConstant(m, "cmsSigPs2CRD3Tag", cmsSigPs2CRD3Tag);
    PyModule_AddIntConstant(m, "cmsSigPs2CSATag", cmsSigPs2CSATag);
    PyModule_AddIntConstant(m, "cmsSigPs2RenderingIntentTag", cmsSigPs2RenderingIntentTag);
    PyModule_AddIntConstant(m, "cmsSigRedColorantTag", cmsSigRedColorantTag);
    PyModule_AddIntConstant(m, "cmsSigRedMatrixColumnTag", cmsSigRedMatrixColumnTag);
    PyModule_AddIntConstant(m, "cmsSigRedTRCTag", cmsSigRedTRCTag);
    PyModule_AddIntConstant(m, "cmsSigSaturationRenderingIntentGamutTag", cmsSigSaturationRenderingIntentGamutTag);
    PyModule_AddIntConstant(m, "cmsSigScreeningDescTag", cmsSigScreeningDescTag);
    PyModule_AddIntConstant(m, "cmsSigScreeningTag", cmsSigScreeningTag);
    PyModule_AddIntConstant(m, "cmsSigTechnologyTag", cmsSigTechnologyTag);
    PyModule_AddIntConstant(m, "cmsSigUcrBgTag", cmsSigUcrBgTag);
    PyModule_AddIntConstant(m, "cmsSigViewingCondDescTag", cmsSigViewingCondDescTag);
    PyModule_AddIntConstant(m, "cmsSigViewingConditionsTag", cmsSigViewingConditionsTag);
    PyModule_AddIntConstant(m, "cmsSigVcgtTag", cmsSigVcgtTag);
    PyModule_AddIntConstant(m, "cmsSigMetaTag", cmsSigMetaTag);
    PyModule_AddIntConstant(m, "cmsSigDigitalCamera", cmsSigDigitalCamera);
    PyModule_AddIntConstant(m, "cmsSigFilmScanner", cmsSigFilmScanner);
    PyModule_AddIntConstant(m, "cmsSigReflectiveScanner", cmsSigReflectiveScanner);
    PyModule_AddIntConstant(m, "cmsSigInkJetPrinter", cmsSigInkJetPrinter);
    PyModule_AddIntConstant(m, "cmsSigThermalWaxPrinter", cmsSigThermalWaxPrinter);
    PyModule_AddIntConstant(m, "cmsSigElectrophotographicPrinter", cmsSigElectrophotographicPrinter);
    PyModule_AddIntConstant(m, "cmsSigElectrostaticPrinter", cmsSigElectrostaticPrinter);
    PyModule_AddIntConstant(m, "cmsSigDyeSublimationPrinter", cmsSigDyeSublimationPrinter);
    PyModule_AddIntConstant(m, "cmsSigPhotographicPaperPrinter", cmsSigPhotographicPaperPrinter);
    PyModule_AddIntConstant(m, "cmsSigFilmWriter", cmsSigFilmWriter);
    PyModule_AddIntConstant(m, "cmsSigVideoMonitor", cmsSigVideoMonitor);
    PyModule_AddIntConstant(m, "cmsSigVideoCamera", cmsSigVideoCamera);
    PyModule_AddIntConstant(m, "cmsSigProjectionTelevision", cmsSigProjectionTelevision);
    PyModule_AddIntConstant(m, "cmsSigCRTDisplay", cmsSigCRTDisplay);
    PyModule_AddIntConstant(m, "cmsSigPMDisplay", cmsSigPMDisplay);
    PyModule_AddIntConstant(m, "cmsSigAMDisplay", cmsSigAMDisplay);
    PyModule_AddIntConstant(m, "cmsSigPhotoCD", cmsSigPhotoCD);
    PyModule_AddIntConstant(m, "cmsSigPhotoImageSetter", cmsSigPhotoImageSetter);
    PyModule_AddIntConstant(m, "cmsSigGravure", cmsSigGravure);
    PyModule_AddIntConstant(m, "cmsSigOffsetLithography", cmsSigOffsetLithography);
    PyModule_AddIntConstant(m, "cmsSigSilkscreen", cmsSigSilkscreen);
    PyModule_AddIntConstant(m, "cmsSigFlexography", cmsSigFlexography);
    PyModule_AddIntConstant(m, "cmsSigMotionPictureFilmScanner", cmsSigMotionPictureFilmScanner);
    PyModule_AddIntConstant(m, "cmsSigMotionPictureFilmRecorder", cmsSigMotionPictureFilmRecorder);
    PyModule_AddIntConstant(m, "cmsSigDigitalMotionPictureCamera", cmsSigDigitalMotionPictureCamera);
    PyModule_AddIntConstant(m, "cmsSigDigitalCinemaProjector", cmsSigDigitalCinemaProjector);
    PyModule_AddIntConstant(m, "cmsSigMacintosh", cmsSigMacintosh);
    PyModule_AddIntConstant(m, "cmsSigMicrosoft", cmsSigMicrosoft);
    PyModule_AddIntConstant(m, "cmsSigSolaris", cmsSigSolaris);
    PyModule_AddIntConstant(m, "cmsSigSGI", cmsSigSGI);
    PyModule_AddIntConstant(m, "cmsSigTaligent", cmsSigTaligent);
    PyModule_AddIntConstant(m, "cmsSigUnices", cmsSigUnices);
    PyModule_AddIntConstant(m, "cmsSigCurveSetElemType", cmsSigCurveSetElemType);
    PyModule_AddIntConstant(m, "cmsSigMatrixElemType", cmsSigMatrixElemType);
    PyModule_AddIntConstant(m, "cmsSigCLutElemType", cmsSigCLutElemType);
    PyModule_AddIntConstant(m, "cmsSigBAcsElemType", cmsSigBAcsElemType);
    PyModule_AddIntConstant(m, "cmsSigEAcsElemType", cmsSigEAcsElemType);
    PyModule_AddIntConstant(m, "cmsSigXYZ2LabElemType", cmsSigXYZ2LabElemType);
    PyModule_AddIntConstant(m, "cmsSigLab2XYZElemType", cmsSigLab2XYZElemType);
    PyModule_AddIntConstant(m, "cmsSigNamedColorElemType", cmsSigNamedColorElemType);
    PyModule_AddIntConstant(m, "cmsSigLabV2toV4", cmsSigLabV2toV4);
    PyModule_AddIntConstant(m, "cmsSigLabV4toV2", cmsSigLabV4toV2);
    PyModule_AddIntConstant(m, "cmsSigIdentityElemType", cmsSigIdentityElemType);
    PyModule_AddIntConstant(m, "cmsSigFormulaCurveSeg", cmsSigFormulaCurveSeg);
    PyModule_AddIntConstant(m, "cmsSigSampledCurveSeg", cmsSigSampledCurveSeg);
    PyModule_AddIntConstant(m, "cmsSigSegmentedCurve", cmsSigSegmentedCurve);
    PyModule_AddIntConstant(m, "cmsInfoDescription", cmsInfoDescription);
    PyModule_AddIntConstant(m, "cmsInfoManufacturer", cmsInfoManufacturer);
    PyModule_AddIntConstant(m, "cmsInfoModel", cmsInfoModel);
    PyModule_AddIntConstant(m, "cmsInfoCopyright", cmsInfoCopyright);
#if PY_MAJOR_VERSION >= 3
    return m;
#endif
}
