/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.FileLockStrategyFactory;
import org.apache.commons.vfs2.provider.FileSystemKey;

public class LockByFileSystemStrategyFactory<AFS extends AbstractFileSystem>
implements FileLockStrategyFactory {
    private static final ConcurrentMap<FileSystemKey, Lock> locksByKey = new ConcurrentHashMap<FileSystemKey, Lock>();
    private static final ConcurrentMap<AbstractFileSystem, Lock> locksByObject = new ConcurrentHashMap<AbstractFileSystem, Lock>();
    private final Lock lock;

    public LockByFileSystemStrategyFactory(AFS fileSystem) {
        Lock oldLock;
        FileSystemKey cacheKey = ((AbstractFileSystem)fileSystem).getCacheKey();
        ReentrantLock newLock = new ReentrantLock();
        this.lock = cacheKey != null ? ((oldLock = locksByKey.putIfAbsent(cacheKey, newLock)) != null ? oldLock : newLock) : ((oldLock = locksByObject.putIfAbsent((AbstractFileSystem)fileSystem, newLock)) != null ? oldLock : newLock);
    }

    @Override
    public Lock createLock() {
        return this.lock;
    }
}

