# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImportSource(Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: The resource identifier of the source Azure Container
     Registry.
    :type resource_id: str
    :param registry_uri: The address of the source registry.
    :type registry_uri: str
    :param source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest'
     tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest
     ('hello-world@sha256:abc123').
    :type source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.registry_uri = kwargs.get('registry_uri', None)
        self.source_image = kwargs.get('source_image', None)
