# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WorkloadProtectableItem(Model):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    :param backup_management_type: Type of backup managemenent to backup an
     item.
    :type backup_management_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected'
    :type protection_state: str or :class:`ProtectionStatus
     <azure.mgmt.recoveryservicesbackup.models.ProtectionStatus>`
    :param protectable_item_type: Polymorphic Discriminator
    :type protectable_item_type: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_item_type': {'IaaSVMProtectableItem': 'IaaSVMProtectableItem'}
    }

    def __init__(self, backup_management_type=None, friendly_name=None, protection_state=None):
        self.backup_management_type = backup_management_type
        self.friendly_name = friendly_name
        self.protection_state = protection_state
        self.protectable_item_type = None
