/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import org.apache.log4j.Logger;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;

public class JobValidatorRegistry {
    private static final Logger logger = Logger.getLogger(JobValidatorRegistry.class);
    protected static ImmutableMap<String, JobValidatorService> jobValidators;

    private JobValidatorRegistry() {
        this.load();
    }

    public void load() {
        Iterator<JobValidatorService> loadedFactories = ServiceRegistry.lookupProviders(JobValidatorService.class);
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        while (loadedFactories.hasNext()) {
            try {
                JobValidatorService validator = loadedFactories.next();
                String validatorID = validator.getClass().getCanonicalName();
                logger.debug((Object)("Job Validator Factory provider <" + validatorID + "> found"));
                mapBuilder.put((Object)validatorID, (Object)validator);
            }
            catch (Exception err) {
                logger.error((Object)("Failed to load job validator factory: " + err));
            }
        }
        jobValidators = mapBuilder.build();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[JobValidatorRegistry] job validators registered : " + jobValidators.keySet()));
        }
    }

    public static synchronized JobValidatorRegistry getInstance() {
        return LazyHolder.INSTANCE;
    }

    public ImmutableMap<String, JobValidatorService> getRegisteredFactories() throws IllegalAccessException, InstantiationException {
        return jobValidators;
    }

    private static class LazyHolder {
        private static final JobValidatorRegistry INSTANCE = new JobValidatorRegistry();

        private LazyHolder() {
        }
    }
}

