from setuptools import setup, find_packages

version = '0.2'

long_description = (
    open('README.txt').read()
    + '\n' +
    'Contributors\n'
    '============\n'
    + '\n' +
    open('CONTRIBUTORS.txt').read()
    + '\n' +
    open('CHANGES.txt').read()
    + '\n')


setup(name='zope.schemaevent',
      version=version,
      description="Event subscribers for zope.schema",
      long_description=long_description,
      classifiers=[
          "Programming Language :: Python",
      ],
      keywords='zope schema event',
      author='Jean-Francois Roche',
      author_email='jfroche@affinitic.be',
      url='https://github.com/zopefoundation/zope.schemaevent',
      license='gpl',
      packages=find_packages('src'),
      package_dir={'': 'src'},
      namespace_packages=['zope'],
      include_package_data=True,
      zip_safe=False,
      install_requires=[
          'setuptools',
          'zope.component',
          'zope.schema'
      ],
      extras_require={'test': ['zope.testing',
                               'plone.testing [zca]']})
