# Copyright 2010-2011 Isotoma Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from yaml.reader import Reader
from yaml.scanner import Scanner
from yaml.parser import Parser

from yay.openers import Openers
from yay.composer import Composer

class Loader(Reader, Scanner, Parser, Composer):

    def __init__(self, stream, name="<Unknown>", special_term='yay', secret=False, openers=None):
        self.name = name
        self.special_term = special_term
        self.openers = openers

        Reader.__init__(self, stream)
        Scanner.__init__(self)
        Parser.__init__(self)
        Composer.__init__(self, secret=secret)

