/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Dimension;
import java.awt.Point;
import org.sikuli.guide.LinearStepper;
import org.sikuli.guide.NewAnimator;
import org.sikuli.guide.Visual;

class CenteredResizeToAnimator
extends NewAnimator {
    LinearStepper widthStepper;
    LinearStepper heightStepper;
    Dimension currentSize;
    Dimension targetSize;
    Point centerLocation;

    CenteredResizeToAnimator(Visual sklComponent, Dimension targetSize) {
        super(sklComponent);
        this.targetSize = targetSize;
    }

    @Override
    protected void init() {
        this.centerLocation = this.sklComponent.getCenter();
        this.widthStepper = new LinearStepper(this.sklComponent.getActualWidth(), this.targetSize.width, 10);
        this.heightStepper = new LinearStepper(this.sklComponent.getActualHeight(), this.targetSize.height, 10);
    }

    @Override
    protected boolean isRunning() {
        return this.widthStepper.hasNext();
    }

    @Override
    protected void animate() {
        float width = this.widthStepper.next();
        float height = this.heightStepper.next();
        Point newLocation = new Point(this.centerLocation);
        newLocation.x = (int)((float)newLocation.x - width / 2.0f);
        newLocation.y = (int)((float)newLocation.y - height / 2.0f);
        this.sklComponent.setActualSize(new Dimension((int)width, (int)height));
        this.sklComponent.setActualLocation(newLocation);
    }
}

