/*
 * Decompiled with CFR 0.152.
 */
package com.github.rainmanwy.robotframework.sikulilib.keywords;

import com.github.rainmanwy.robotframework.sikulilib.exceptions.ScreenOperationException;
import com.github.rainmanwy.robotframework.sikulilib.exceptions.TimeoutException;
import com.github.rainmanwy.robotframework.sikulilib.utils.CaptureFolder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.sikuli.script.Button;
import org.sikuli.script.FindFailed;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Key;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

@RobotKeywords
public class ScreenKeywords {
    private static double DEFAULT_TIMEOUT = 3.0;
    private final Screen screen = new Screen();
    private double timeout;
    private Map<String, Match> highlightMap = new HashMap<String, Match>();

    public ScreenKeywords() {
        this.timeout = DEFAULT_TIMEOUT;
    }

    @RobotKeyword(value="Set Sikuli timeout(seconds)")
    @ArgumentNames(value={"timeout"})
    public String setTimeout(String timeout) {
        double oldTimeout = this.timeout;
        this.timeout = Double.parseDouble(timeout);
        return Double.toString(oldTimeout);
    }

    @RobotKeyword(value="Add image path")
    @ArgumentNames(value={"path"})
    public boolean addImagePath(String path) {
        return ImagePath.add(path);
    }

    @RobotKeyword(value="Set folder for captured images")
    @ArgumentNames(value={"path"})
    public void setCaptureFolder(String path) {
        CaptureFolder.getInstance().setCaptureFolder(path);
    }

    @RobotKeyword(value="Click image")
    @ArgumentNames(value={"image"})
    public void click(String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        try {
            this.screen.click(image);
        }
        catch (FindFailed e) {
            this.capture();
            throw new ScreenOperationException("Click " + image + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="Double click image")
    @ArgumentNames(value={"image"})
    public void doubleClick(String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        try {
            this.screen.doubleClick(image);
        }
        catch (FindFailed e) {
            throw new ScreenOperationException("Click " + image + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="Right click image")
    @ArgumentNames(value={"image"})
    public void rightClick(String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        try {
            this.screen.rightClick(image);
        }
        catch (FindFailed e) {
            throw new ScreenOperationException("Click " + image + " failed" + e.getMessage(), e);
        }
    }

    private Match wait(String image, String timeout) throws TimeoutException {
        try {
            Match match = this.screen.wait(image, Double.parseDouble(timeout));
            this.capture(match);
            return match;
        }
        catch (FindFailed e) {
            this.capture();
            throw new TimeoutException("Timeout happend, could not find " + image, e);
        }
    }

    private Match find(String image) {
        try {
            Match match = this.screen.find(image);
            this.capture(match);
            return match;
        }
        catch (FindFailed e) {
            System.out.println("Could not find " + image);
            return null;
        }
    }

    @RobotKeyword(value="Wait until image shown in screen")
    @ArgumentNames(value={"image", "timeout"})
    public void waitUntilScreenContain(String image, String timeout) throws TimeoutException {
        this.wait(image, timeout);
    }

    @RobotKeyword(value="Wait until image not in screen")
    @ArgumentNames(value={"image", "timeout"})
    public void waitUntilScreenNotContain(String image, String timeout) throws TimeoutException {
        boolean result = this.screen.waitVanish(image, Double.parseDouble(timeout));
        this.capture();
        if (!result) {
            throw new TimeoutException(image + " is still in screen");
        }
    }

    @RobotKeyword(value="Screen should contain image")
    @ArgumentNames(value={"image"})
    public void screenShouldContain(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match == null) {
            this.capture();
            throw new ScreenOperationException("Screen should contain " + image);
        }
    }

    @RobotKeyword(value="Screen should not contain image")
    @ArgumentNames(value={"image"})
    public void screenShouldNotContain(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match != null) {
            this.capture();
            throw new ScreenOperationException("Screen should not contain " + image);
        }
    }

    @RobotKeyword(value="Input text. Image could be empty")
    @ArgumentNames(value={"image", "text"})
    public void inputText(String image, String text) throws Exception {
        int result;
        System.out.println("Input Text:");
        System.out.println(text);
        if (!"".equals(image)) {
            this.click(image);
        }
        if ((result = this.screen.type(text)) == 0) {
            throw new ScreenOperationException("Input text failed");
        }
    }

    @RobotKeyword(value="Paste text. Image could be empty")
    @ArgumentNames(value={"image", "text"})
    public void pasteText(String image, String text) throws Exception {
        int result;
        System.out.println("Paste Text:");
        System.out.println(text);
        if (!"".equals(image)) {
            this.click(image);
        }
        if ((result = this.screen.paste(text)) == 0) {
            throw new ScreenOperationException("Paste text failed");
        }
    }

    @RobotKeyword(value="Click in. \nClick target image in area image.")
    @ArgumentNames(value={"areaImage", "targetImage"})
    public void clickIn(String areaImage, String targetImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.click(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeyword(value="Double click in. \nDouble click target image in area image.")
    @ArgumentNames(value={"areaImage", "targetImage"})
    public void doubleClickIn(String areaImage, String targetImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.doubleClick(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeyword(value="Right click in. \nRight click target image in area image.")
    @ArgumentNames(value={"areaImage", "targetImage"})
    public void rightClickIn(String areaImage, String targetImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.rightClick(targetImage);
        this.capture(match.find(targetImage));
    }

    private void capture() {
        ScreenImage image = this.screen.capture();
        String imagePath = image.save(CaptureFolder.getInstance().getCaptureFolder());
        System.out.println("*DEBUG* Saved path: " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        System.out.println("*HTML* <img src='" + CaptureFolder.getInstance().getSubFolder() + "/" + fileName + "'/>");
    }

    private void capture(Region region) {
        ScreenImage image = this.screen.capture(region);
        String imagePath = image.save(CaptureFolder.getInstance().getCaptureFolder());
        System.out.println("*DEBUG* Saved path: " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        System.out.println("*HTML* <img src='" + CaptureFolder.getInstance().getSubFolder() + "/" + fileName + "'/>");
    }

    @RobotKeyword(value="Capture whole screen")
    @ArgumentNames(value={})
    public void captureScreen() {
        this.capture();
    }

    @RobotKeyword(value="Highlight matched image")
    @ArgumentNames(value={"image"})
    public void highlight(String image) throws Exception {
        Match match = null;
        if (!this.highlightMap.containsKey(image)) {
            match = this.screen.find(image);
            this.highlightMap.put(image, match);
            match.highlight();
            this.capture();
        } else {
            System.out.println("*WARN* " + image + " was already highlighted");
        }
    }

    @RobotKeyword(value="Clear highlight from screen")
    @ArgumentNames(value={"image"})
    public void clearHighlight(String image) {
        if (this.highlightMap.containsKey(image)) {
            Match match = this.highlightMap.get(image);
            match.highlight();
            this.highlightMap.remove(image);
        } else {
            System.out.println("*WARN* " + image + " was not highlighted before");
        }
    }

    @RobotKeyword(value="Clear all highlights from screen")
    @ArgumentNames(value={})
    public void clearAllHighlights() {
        for (Match match : this.highlightMap.values()) {
            match.highlight();
        }
        this.highlightMap.clear();
    }

    @RobotKeyword(value="Drag the source image to target image.\nIf source image is empty, drag the last match and drop at given target")
    @ArgumentNames(value={"srcImage", "targetImage"})
    public void dragAndDrop(String srcImage, String targetImage) throws Exception {
        int result = 0;
        if ("".equals(srcImage)) {
            result = this.screen.dragDrop(targetImage);
            this.wait(targetImage, Double.toString(this.timeout));
        } else {
            Match srcMatch = this.wait(srcImage, Double.toString(this.timeout));
            Match targetMatch = this.wait(targetImage, Double.toString(this.timeout));
            result = this.screen.dragDrop(srcMatch, targetMatch);
        }
        if (result == 0) {
            this.capture();
            throw new ScreenOperationException("Failed to drag " + srcImage + " to " + targetImage);
        }
    }

    @RobotKeyword(value="Tries to find the image on the screen, returns accuracy score (0-1)\n Example Usage:\n | ${score} = | Get Match Score |  somethingThatMayExist.png |\n | Run Keyword if | ${score} > 0.95 | keyword1 | ELSE | keyword2 |")
    @ArgumentNames(value={"image"})
    public Double getMatchScore(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match == null) {
            return 0.0;
        }
        return match.getScore();
    }

    @RobotKeyword(value="Presses a special keyboard key.\n\n For a list of possible Keys view docs for org.sikuli.script.Key .\n\n Example Usage:\n | Double Click | textFieldWithDefaultText.png | \n | Press Special Key | DELETE | ")
    @ArgumentNames(value={"keyConstant"})
    public void pressSpecialKey(String specialCharName) throws ScreenOperationException {
        try {
            Object key = Key.class.getField(specialCharName).get(null);
            this.screen.type(key.toString());
        }
        catch (ReflectiveOperationException e) {
            throw new ScreenOperationException("No " + specialCharName.toString() + " in class org.sikuli.script.Key ");
        }
    }

    @RobotKeyword(value="Move the mouse pointer to the target\n\n @image: if image is empty, will move mouse to the last matched.\n\n Example Usage:\n | Mouse Move              | test.png | \n | Screen Should Contain   | test.png | \n | Mouse Move |")
    @ArgumentNames(value={"image"})
    public void mouseMove(String image) throws Exception {
        Match match = this.wait(image, Double.toString(this.timeout));
        int result = match.mouseMove(image);
        if (result == 0) {
            throw new ScreenOperationException("Failed to move mouse to " + image);
        }
    }

    @RobotKeywordOverload
    public void mouseMove() throws Exception {
        int result = this.screen.mouseMove();
        if (result == 0) {
            throw new ScreenOperationException("Failed to move mouse to last matched image");
        }
    }

    @RobotKeyword(value="Press and hold the specified buttons\n\n @mouseButtons: Could be LEFT, MIDDLE, RIGHT\n\n Example Usage:\n | Mouse Move   | test.png | \n | Mouse Down   | LEFT     | RIGHT |\n | Mouse Up     |")
    @ArgumentNames(value={"**mouseButtons"})
    public void mouseDown(String[] mouseButtons) throws Exception {
        String currentButton = "";
        try {
            int sum = 0;
            String[] stringArray = mouseButtons;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String button;
                currentButton = button = stringArray[i];
                int buttonValue = (Integer)Button.class.getField(button).get(null);
                sum += buttonValue;
            }
            this.screen.mouseDown(sum);
        }
        catch (ReflectiveOperationException e) {
            throw new ScreenOperationException("No " + currentButton + " in class org.sikuli.script.Button ");
        }
    }

    @RobotKeyword(value="release the specified mouse buttons\n\n @mouseButtons: Could be LEFT, MIDDLE, RIGHT. If empty, all currently held buttons are released\n\n Example Usage:\n | Mouse Move   | test.png | \n | Mouse Down   | LEFT     | RIGHT |\n | Mouse Up     | LEFT     | RIGHT |")
    @ArgumentNames(value={"**mouseButtons"})
    public void mouseUp(String[] mouseButtons) throws Exception {
        String currentButton = "";
        try {
            int sum = 0;
            String[] stringArray = mouseButtons;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String button;
                currentButton = button = stringArray[i];
                int buttonValue = (Integer)Button.class.getField(button).get(null);
                sum += buttonValue;
            }
            this.screen.mouseUp(sum);
        }
        catch (ReflectiveOperationException e) {
            throw new ScreenOperationException("No " + currentButton + " in class org.sikuli.script.Button ");
        }
    }

    @RobotKeywordOverload
    public void mouseUp() throws Exception {
        this.screen.mouseUp();
    }

    @RobotKeyword(value="Move mouse to the target, and wheel up with give steps\n\n Example Usage:\n | Wheel Up     | 5   | \n | Wheel Up     | 5   |  test.png   |")
    @ArgumentNames(value={"steps", "image="})
    public void wheelUp(int steps, String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        this.screen.wheel(image, Button.WHEEL_UP, steps);
    }

    @RobotKeywordOverload
    public void wheelUp(int steps) throws Exception {
        this.screen.wheel(Button.WHEEL_UP, steps);
    }

    @RobotKeyword(value="Move mouse to the target, and wheel down with give steps\n\n Example Usage:\n | Wheel Down     | 5   | \n | Wheel Down     | 5   |  test.png   |")
    @ArgumentNames(value={"steps", "image="})
    public void wheelDown(int steps, String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        this.screen.wheel(image, Button.WHEEL_DOWN, steps);
    }

    @RobotKeywordOverload
    public void wheelDown(int steps) throws Exception {
        this.screen.wheel(Button.WHEEL_DOWN, steps);
    }
}

