/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.decoder;

import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;

public class PaddingAndHeartbeatDecoder
implements Decoder<String, Decoder.Decoded<String>> {
    private final int paddingSize;
    private final String heartbeatChar;

    public PaddingAndHeartbeatDecoder() {
        this(4098, "X");
    }

    public PaddingAndHeartbeatDecoder(int paddingSize, String heartbeatChar) {
        this.paddingSize = paddingSize;
        this.heartbeatChar = heartbeatChar;
    }

    @Override
    public Decoder.Decoded<String> decode(Event type, String message) {
        if (type.equals((Object)Event.MESSAGE)) {
            if (message.equalsIgnoreCase(this.heartbeatChar)) {
                return new Decoder.Decoded<String>(message, Decoder.Decoded.ACTION.ABORT);
            }
            if ((message = this.ltrim(message)) == null) {
                return new Decoder.Decoded<String>(message, Decoder.Decoded.ACTION.ABORT);
            }
        }
        return new Decoder.Decoded<String>(message);
    }

    private String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return i == this.paddingSize ? (s.trim().length() == 0 ? null : s.substring(i)) : s;
    }
}

