/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.objectweb.proactive.utils.PrefixPrintStream;
import org.objectweb.proactive.utils.PrefixPrintWriter;

public class AggregateException
extends Exception {
    List<Throwable> causes = new ArrayList<Throwable>();
    static final String CAUSE_CAPTION = "Caused by: ";
    private static final long serialVersionUID = 1L;

    public AggregateException() {
    }

    public AggregateException(List<Throwable> causes) {
        this.causes = causes;
    }

    public AggregateException(String message) {
        super(message);
    }

    public AggregateException(String message, List<Throwable> causes) {
        super(message);
        this.causes = causes;
    }

    public void addCause(Throwable cause) {
        this.causes.add(cause);
    }

    public synchronized List<Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter s) {
        Set dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(this);
        Object object = s.lock();
        synchronized (object) {
            StackTraceElement[] trace;
            s.println(this);
            for (StackTraceElement traceElement : trace = this.getStackTrace()) {
                s.println("\tat " + traceElement);
            }
            List<Throwable> ourCauses = this.getCauses();
            AggregateException.printTheCauses(s, this.causes);
        }
    }

    static void printTheCauses(PrintStreamOrWriter s, List<Throwable> causes) {
        s.println(CAUSE_CAPTION);
        int index = 1;
        for (Throwable cause : causes) {
            if (cause == null) continue;
            s.println("\t[" + index + "]:");
            if (s.getPrintStream() != null) {
                cause.printStackTrace(new PrefixPrintStream((OutputStream)s.getPrintStream(), "\t"));
            } else {
                cause.printStackTrace(new PrefixPrintWriter((Writer)s.getPrintWriter(), "\t"));
            }
            ++index;
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new WrappedPrintWriter(s));
    }

    static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        Object lock() {
            return this.printWriter;
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }

        @Override
        PrintStream getPrintStream() {
            return null;
        }

        @Override
        PrintWriter getPrintWriter() {
            return this.printWriter;
        }
    }

    static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        Object lock() {
            return this.printStream;
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }

        @Override
        PrintStream getPrintStream() {
            return this.printStream;
        }

        @Override
        PrintWriter getPrintWriter() {
            return null;
        }
    }

    static abstract class PrintStreamOrWriter {
        PrintStreamOrWriter() {
        }

        abstract Object lock();

        abstract void println(Object var1);

        abstract PrintStream getPrintStream();

        abstract PrintWriter getPrintWriter();
    }
}

