/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scripting;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.script.Bindings;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.ScriptResult;

@PublicAPI
public class SelectionScript
extends Script<Boolean> {
    public static final Logger logger = Logger.getLogger(SelectionScript.class);
    public static final String RESULT_VARIABLE = "selected";
    private boolean dynamic = true;
    protected byte[] id_;
    private static final long serialVersionUID = 101L;

    public SelectionScript() {
    }

    @Override
    protected String getDefaultScriptName() {
        return "SelectionScript";
    }

    public SelectionScript(String script, String engineName) throws InvalidScriptException {
        super(script, engineName, "SelectionScript");
        this.buildSelectionScriptId();
    }

    public SelectionScript(String script, String engineName, boolean dynamic) throws InvalidScriptException {
        super(script, engineName, "SelectionScript");
        this.dynamic = dynamic;
        this.buildSelectionScriptId();
    }

    public SelectionScript(String script, String engineName, Serializable[] parameters, boolean dynamic) throws InvalidScriptException {
        super(script, engineName, parameters, "SelectionScript");
        this.dynamic = dynamic;
        this.buildSelectionScriptId();
    }

    public SelectionScript(File file, Serializable[] parameters) throws InvalidScriptException {
        super(file, parameters);
        this.buildSelectionScriptId();
    }

    public SelectionScript(File file, Serializable[] parameters, boolean dynamic) throws InvalidScriptException {
        super(file, parameters);
        this.dynamic = dynamic;
        this.buildSelectionScriptId();
    }

    public SelectionScript(URL url) throws InvalidScriptException {
        this(url, true);
    }

    public SelectionScript(URL url, boolean dynamic) throws InvalidScriptException {
        this(url, (String)null, dynamic);
    }

    public SelectionScript(URL url, String engineName) throws InvalidScriptException {
        this(url, engineName, true);
    }

    public SelectionScript(URL url, String engineName, boolean dynamic) throws InvalidScriptException {
        this(url, engineName, null, dynamic);
    }

    public SelectionScript(URL url, Serializable[] parameters) throws InvalidScriptException {
        this(url, parameters, true);
    }

    public SelectionScript(URL url, Serializable[] parameters, boolean dynamic) throws InvalidScriptException {
        this(url, null, parameters, dynamic);
    }

    public SelectionScript(URL url, String engineName, Serializable[] parameters) throws InvalidScriptException {
        this(url, engineName, parameters, true);
    }

    public SelectionScript(URL url, String engineName, Serializable[] parameters, boolean dynamic) throws InvalidScriptException {
        super(url, engineName, parameters, true);
        this.dynamic = dynamic;
        this.buildSelectionScriptId();
    }

    public SelectionScript(Script<?> script, boolean dynamic) throws InvalidScriptException {
        super(script);
        try {
            this.fetchUrlIfNeeded();
        }
        catch (IOException e) {
            throw new InvalidScriptException(e);
        }
        this.dynamic = dynamic;
        this.buildSelectionScriptId();
    }

    public void buildSelectionScriptId() {
        String stringId = this.script;
        stringId = stringId + this.dynamic;
        if (this.parameters != null) {
            for (Serializable param : this.parameters) {
                stringId = stringId + param;
            }
        }
        try {
            this.id_ = MessageDigest.getInstance("SHA-1").digest(stringId.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"", (Throwable)e);
            this.id_ = stringId.getBytes();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected Reader getReader() {
        return new StringReader(this.script);
    }

    @Override
    protected ScriptResult<Boolean> getResult(Object evalResult, Bindings bindings) {
        if (bindings.containsKey(RESULT_VARIABLE)) {
            Object result = bindings.get(RESULT_VARIABLE);
            if (result instanceof Boolean) {
                return new ScriptResult<Boolean>((Boolean)result);
            }
            if (result instanceof Integer) {
                return new ScriptResult<Boolean>((Integer)result != 0);
            }
            if (result instanceof CharSequence) {
                return new ScriptResult<Boolean>(!result.equals("false") && !result.equals("False"));
            }
            return new ScriptResult<Boolean>(new Exception("Bad result format : awaited Boolean (or Integer when not existing), found " + result.getClass().getName()));
        }
        String msg = "No binding for key : selected\na Selection script must define a variable named 'selected' set to true or false";
        logger.error((Object)msg);
        return new ScriptResult<Boolean>(new Exception(msg));
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    protected void prepareSpecialBindings(Bindings bindings) {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SelectionScript) {
            return this.compareByteArray(this.id_, ((SelectionScript)o).id_);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new String(this.id_).hashCode();
    }

    public byte[] digest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5").digest(this.id_);
    }

    public boolean compareByteArray(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeFromList(List<SelectionScript> selScriptsList) {
        if (selScriptsList == null || selScriptsList.size() == 0) {
            return 0;
        }
        int toReturn = 0;
        for (SelectionScript ss : selScriptsList) {
            toReturn += ss.hashCode();
        }
        return toReturn;
    }

    @Override
    public String toString() {
        return this.hashCode() + "\n" + this.script;
    }
}

