##*DxfStructure Steel help*

---
###*Available functions*

|Name|Description|
|-------|----------|
|`(1)Check`| Checks the drawing|
|`(2)Check and save`| Checks the drawing and draws warnings in modelspace on `DS_TMPCHECK` layer|
|`(3)Show dependencies and save`| Shows profile annotation dependencies and draws them as line in modelspace on `DS_TMPCHECK` layer
|`(4)Process data and save`| Updates quantities and marks of profiles|
|`(5)Process data with renumerate and save`| Updates quantities and marks of profiles and renumerates profile|
|`(6)Process data with renumerate, schedules and save`| Updates quantities and marks of profiles and renumerates profiles then draws bar schedule in modelspace|
|`(7)Steel Help`| Displays help for steel|
|`(8)Section base profile list `| Displays a list of available profiles in program database|

---
###*Layer system used for steel drawing*

|Name|Description|
|-------|----------|
|`DS_STEXT`| Profile annotation|
|`DS_DEPLINE`|Definition of annotation dependency|
|`DS_ELEMENT`|Definition of element area in model space|
|`DS_SCHEDULE`|Used to create bar schedule|
|`DS_TMPCHECK`|Temporary layer for warning|

---
###*Profile annotation syntax*

|2|x|[|10|]|-|IPE 300|-|1200|-|S355|
|-|-|-|-|-|-|-|-|-|-|-|
|Number|x|[|Mark|]|-|Profile|-|Length|-|Grade|

|Legend:| |
|-------|----------|
|Number|- number of profiles (1,2,4,5..)|
|Mark|- bar mark (auto generated by program)|
|Profile|- profile name|
|Length|- profile length|
|Grade|- profile steel grade|

|Example:|(number)|
|---|---|
|4x[2]-IPE 300-2400-S235|(4)|
|4x[2]-IPE 300-2400|(4)|
|4x[2]-IPE 300|(4)|
|4x[2]|(4)|
|[2]|(0)|
|[2]-IPE 300|(0)|
|[2]-IPE 300-2400|(0)|
|[2]-IPE 300-2400-S235|(0)|
|etc.|

Please not that S235 grade is default if grade not defined in annotation.

---
###*Defining main annotation for profile*
To create main profile annotation it length must be defined.

|Example:|
|---|
|4x[2]-IPE 300-2400-S235|
|4x[2]-IPE 300-2400|
|[2]-IPE 300-2400-S235|
|[2]-IPE 300-2400|

---
###*Profile annotation special colours*
|Color|meaning|
|-------|----------|
|`5` (blue)|- countable|
|`7` (white)|- uncountable|
|any other|- countable|

Use color `5` and `7` to create depended profile annotation.

---
###*Bolt annotation syntax*

|2|x|M12|x|60|-|8.8|
|-|-|-|-|-|-|-|
|Number|x|Type|x|Length|-|Grade|

|Legend:| |
|-------|----------|
|Number|- number of bolts (1,2,4,5..)|
|Type|- type of bolt (M10,M12, HILTI HAS M12, etc.)|
|Length|- bolt length|
|Grade|- bolt grade|

|Example:|(number)|
|---|---|
|5xM16|(5)|
|5xM16x60|(5)|
|5xM16x60-8.8|(5)|
|5xM16-8.8|(5)|
|M16|(1)|
|etc.| |

---
###*Bolt annotation special colours*
|Color|meaning|
|-------|----------|
|`7` (white)|- uncountable depended annotation |
|any other|- countable main annotation|

Use color `7` to create depended bolt annotation.

---
###*Element description syntax*

|`Element`|`_`|`Wall`|`_`|`x`|`_`|`5`|
|-|-|-|-|-|-|-|-|-|-|
|||Element name||||Number|

|Example:||
|---||
|Element Bk-1 x 5||
|Element Slup x 5||

---
##*Use case*
---
##*(1) - profile main annotation*
![](help_steel_usecase_1.png)

---
##*(2) - profile main annotation with dependence annotations*
![](help_steel_usecase_2.png)

---
##*(3) - bolt main annotation*
![](help_steel_usecase_3.png)

---
##*(4) - bolt main annotation with dependence annotations*
![](help_steel_usecase_4.png)

---
##*(5) - element definition*
![](help_steel_usecase_5.png)

---
##*(6)auto generated schedule for 1 - 5 use case in use_case.dxf*
![](help_steel_usecase_schedule.png)

Please find `use_case.dxf` in `../dxfstructure/example` folder. There are a few example dxf files in the same folder too.

