# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CreateComposeDeploymentDescription(Model):
    """Defines description for creating a Service Fabric compose deployment.
    .

    :param deployment_name:
    :type deployment_name: str
    :param compose_file_content: The content of the compose file that
     describes the deployment to create.
    :type compose_file_content: str
    :param registry_credential:
    :type registry_credential: :class:`RegistryCredential
     <azure.servicefabric.models.RegistryCredential>`
    """

    _validation = {
        'deployment_name': {'required': True},
        'compose_file_content': {'required': True},
    }

    _attribute_map = {
        'deployment_name': {'key': 'DeploymentName', 'type': 'str'},
        'compose_file_content': {'key': 'ComposeFileContent', 'type': 'str'},
        'registry_credential': {'key': 'RegistryCredential', 'type': 'RegistryCredential'},
    }

    def __init__(self, deployment_name, compose_file_content, registry_credential=None):
        self.deployment_name = deployment_name
        self.compose_file_content = compose_file_content
        self.registry_credential = registry_credential
