# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterSku(Model):
    """SKU parameters particular to a cluster instance.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of this SKU. Default value: "Dedicated" .
    :vartype name: str
    :param capacity: The quantity of Event Hubs Cluster Capacity Units
     contained in this cluster.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True, 'constant': True},
        'capacity': {'maximum': 32, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    name = "Dedicated"

    def __init__(self, *, capacity: int=None, **kwargs) -> None:
        super(ClusterSku, self).__init__(**kwargs)
        self.capacity = capacity
