/* Generated by re2c 0.13.5 */
#line 1 "mwlib/_uscan.re"
// -*- mode: c++ -*-
// Copyright (c) 2007-2009 PediaPress GmbH
// See README.txt for additional licensing information.

#include <Python.h>

#include <iostream>
#include <assert.h>
#include <vector>
using namespace std;

#define RET(x) {found(x); return x;}

typedef enum {
	t_end,
	t_text,
	t_entity,
	t_special,
	t_magicword,
	t_comment,
	t_2box_open,   // [[
	t_2box_close,  // ]]
	t_http_url,
	t_break,
	t_begin_table,
	t_end_table,
	t_html_tag,
	t_singlequote,
	t_pre,
	t_section,
	t_section_end,
	t_item,
	t_colon,
	t_semicolon,
	t_hrule,
	t_newline,
	t_column,
	t_row,
	t_tablecaption,
	t_urllink,
	t_uniq,

	t_ebad,
} mwtok;

struct Token
{
	int type;
	int start;
	int len;
};

class Scanner
{
public:

	Scanner(Py_UNICODE *_start, Py_UNICODE *_end) {
		source = start = _start;
		end = _end;
		cursor = start;
		line_startswith_section = -1;
		tablemode=0;
		last_ebad = false;
	}

	int found(mwtok val) {
		if (val==t_ebad) {
			last_ebad=true;
			return tokens.size()-1;
		}

		if (val==t_text && tokens.size() && !last_ebad) {
			Token &previous_token (tokens[tokens.size()-1]);
			if (previous_token.type==val) {
				previous_token.len += cursor-start;
				return tokens.size()-1;
			}
		}
		
		last_ebad = false;

		Token t;
		t.type = val;
		t.start = (start-source);
		t.len = cursor-start;			
		tokens.push_back(t);
		return tokens.size()-1;
	}

	bool bol() {
		if ((start==source) || (start[-1]=='\n')) {
			memset(&lineflags, 0, sizeof(lineflags));
			return true;
		} else {
			return false;
		}
	}

	bool eol() const {
		return *cursor=='\n' || *cursor==0;
	}

	void newline() {
		if (line_startswith_section>=0) {
			tokens[line_startswith_section].type = t_text;
		}
		line_startswith_section = -1;
	}

	inline int scan();

	Py_UNICODE *source;

	Py_UNICODE *start;
	Py_UNICODE *cursor;
	Py_UNICODE *end;
	vector<Token> tokens;

	bool last_ebad;
	int line_startswith_section;
	int tablemode;
	struct {
		int rowchar;
	} lineflags;
};


int Scanner::scan()
{
	start=cursor;
	
	Py_UNICODE *marker=cursor;

	Py_UNICODE *save_cursor = cursor;


#define YYCTYPE         Py_UNICODE
#define YYCURSOR        cursor
#define YYMARKER	marker
#define YYLIMIT   (end)
// #define YYFILL(n) return 0;

#line 145 "mwlib/_uscan.re"


/*
  the re2c manpage says:
  "The user must arrange for a sentinel token to appear at the end of input"
  \000 is our sentinel token.
*/

#line 184 "mwlib/_uscan.re"

	if (!bol()) {
		goto not_bol;
	}

#line 161 "mwlib/_uscan.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	yych = *YYCURSOR;
	if (yych <= ',') {
		if (yych <= '!') {
			if (yych <= '\t') {
				if (yych <= 0x0008) goto yy16;
			} else {
				if (yych <= 0x001F) goto yy16;
				if (yych <= ' ') goto yy4;
				goto yy11;
			}
		} else {
			if (yych <= '#') {
				if (yych <= '"') goto yy16;
				goto yy14;
			} else {
				if (yych == '*') goto yy14;
				goto yy16;
			}
		}
	} else {
		if (yych <= '<') {
			if (yych <= '9') {
				if (yych <= '-') goto yy15;
				goto yy16;
			} else {
				if (yych <= ':') goto yy6;
				if (yych <= ';') goto yy14;
				goto yy16;
			}
		} else {
			if (yych <= 'z') {
				if (yych <= '=') goto yy12;
				goto yy16;
			} else {
				if (yych <= '{') goto yy8;
				if (yych <= '|') goto yy9;
				goto yy16;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '!') {
		if (yych == '\t') goto yy44;
		if (yych >= ' ') goto yy44;
	} else {
		if (yych <= ':') {
			if (yych >= ':') goto yy44;
		} else {
			if (yych <= 'z') goto yy3;
			if (yych <= '|') goto yy44;
		}
	}
yy3:
#line 236 "mwlib/_uscan.re"
	{goto not_bol;}
#line 222 "mwlib/_uscan.cc"
yy4:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '!') {
		if (yych == '\t') goto yy44;
		if (yych >= ' ') goto yy44;
	} else {
		if (yych <= ':') {
			if (yych >= ':') goto yy44;
		} else {
			if (yych <= 'z') goto yy5;
			if (yych <= '|') goto yy44;
		}
	}
yy5:
#line 228 "mwlib/_uscan.re"
	{RET(t_pre);}
#line 240 "mwlib/_uscan.cc"
yy6:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy39;
	if (yych == '{') goto yy41;
	goto yy24;
yy7:
#line 233 "mwlib/_uscan.re"
	{RET(t_item);}
#line 250 "mwlib/_uscan.cc"
yy8:
	yych = *++YYCURSOR;
	if (yych == '|') goto yy37;
	goto yy3;
yy9:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= ',') {
		if (yych == '+') goto yy29;
	} else {
		if (yych <= '-') goto yy32;
		if (yych == '}') goto yy35;
	}
yy10:
#line 204 "mwlib/_uscan.re"
	{
		if (tablemode) {
		        lineflags.rowchar=cursor[-1];
			RET(t_column);
		}

		if (*start==' ') {
			cursor = start+1;
			RET(t_pre);
		}
		RET(t_text);
	}
#line 277 "mwlib/_uscan.cc"
yy11:
	yych = *++YYCURSOR;
	goto yy10;
yy12:
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '=') goto yy27;
	goto yy26;
yy13:
#line 229 "mwlib/_uscan.re"
	{
			line_startswith_section = found(t_section);
			return t_section;
		}
#line 291 "mwlib/_uscan.cc"
yy14:
	yych = *++YYCURSOR;
	goto yy24;
yy15:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy17;
	goto yy3;
yy16:
	yych = *++YYCURSOR;
	goto yy3;
yy17:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy19;
yy18:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 1) {
		if (yyaccept <= 0) {
			goto yy3;
		} else {
			goto yy5;
		}
	} else {
		goto yy7;
	}
yy19:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy18;
yy20:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '-') goto yy20;
#line 234 "mwlib/_uscan.re"
	{RET(t_hrule);}
#line 326 "mwlib/_uscan.cc"
yy23:
	++YYCURSOR;
	yych = *YYCURSOR;
yy24:
	if (yych <= ')') {
		if (yych == '#') goto yy23;
		goto yy7;
	} else {
		if (yych <= '*') goto yy23;
		if (yych <= '9') goto yy7;
		if (yych <= ';') goto yy23;
		goto yy7;
	}
yy25:
	++YYCURSOR;
	yych = *YYCURSOR;
yy26:
	if (yych == '\t') goto yy25;
	if (yych == ' ') goto yy25;
	goto yy13;
yy27:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= 0x001F) {
		if (yych == '\t') goto yy25;
		goto yy13;
	} else {
		if (yych <= ' ') goto yy25;
		if (yych == '=') goto yy27;
		goto yy13;
	}
yy29:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '+') goto yy29;
#line 218 "mwlib/_uscan.re"
	{
		if (tablemode) 
			RET(t_tablecaption);
		if (*start==' ') {
			cursor = start+1;
			RET(t_pre);
		}
		RET(t_text);
	}
#line 372 "mwlib/_uscan.cc"
yy32:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '-') goto yy32;
#line 193 "mwlib/_uscan.re"
	{
		if (tablemode) 
			RET(t_row);
		if (*start==' ') {
			cursor = start+1;
			RET(t_pre);
		}
		RET(t_text);
	}
#line 387 "mwlib/_uscan.cc"
yy35:
	++YYCURSOR;
#line 190 "mwlib/_uscan.re"
	{if (--tablemode<0) tablemode=0; RET(t_end_table);}
#line 392 "mwlib/_uscan.cc"
yy37:
	++YYCURSOR;
#line 189 "mwlib/_uscan.re"
	{++tablemode; RET(t_begin_table);}
#line 397 "mwlib/_uscan.cc"
yy39:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '9') {
		if (yych <= '#') {
			if (yych <= '"') goto yy7;
			goto yy23;
		} else {
			if (yych == '*') goto yy23;
			goto yy7;
		}
	} else {
		if (yych <= ';') {
			if (yych <= ':') goto yy39;
			goto yy23;
		} else {
			if (yych != '{') goto yy7;
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych == '|') goto yy37;
	goto yy18;
yy42:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy29;
		goto yy10;
	} else {
		if (yych <= '-') goto yy32;
		if (yych == '}') goto yy35;
		goto yy10;
	}
yy43:
	++YYCURSOR;
	yych = *YYCURSOR;
yy44:
	if (yych <= '!') {
		if (yych <= '\t') {
			if (yych <= 0x0008) goto yy18;
			goto yy43;
		} else {
			if (yych <= 0x001F) goto yy18;
			if (yych <= ' ') goto yy43;
		}
	} else {
		if (yych <= 'z') {
			if (yych == ':') goto yy46;
			goto yy18;
		} else {
			if (yych <= '{') goto yy41;
			if (yych <= '|') goto yy42;
			goto yy18;
		}
	}
	yych = *++YYCURSOR;
	goto yy10;
yy46:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == ':') goto yy46;
	if (yych == '{') goto yy41;
	goto yy18;
}
#line 237 "mwlib/_uscan.re"



not_bol:
	cursor = save_cursor;
	marker = cursor;


#line 472 "mwlib/_uscan.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	yych = *YYCURSOR;
	if (yych <= ']') {
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= 0x0000) goto yy76;
				if (yych == '\n') goto yy68;
				goto yy78;
			} else {
				if (yych <= '%') {
					if (yych <= '!') goto yy71;
					goto yy78;
				} else {
					if (yych <= '&') goto yy75;
					if (yych <= '\'') goto yy73;
					goto yy78;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '9') goto yy64;
					goto yy72;
				} else {
					if (yych <= ';') goto yy78;
					if (yych <= '<') goto yy74;
					goto yy66;
				}
			} else {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy78;
					goto yy64;
				} else {
					if (yych <= '[') goto yy52;
					if (yych <= '\\') goto yy78;
					goto yy65;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych == '_') goto yy60;
				if (yych <= '`') goto yy78;
				goto yy64;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy58;
					goto yy64;
				} else {
					if (yych <= 'h') goto yy59;
					if (yych <= 'i') goto yy56;
					goto yy64;
				}
			}
		} else {
			if (yych <= '|') {
				if (yych <= 'n') {
					if (yych <= 'm') goto yy54;
					goto yy57;
				} else {
					if (yych <= 'z') goto yy64;
					if (yych <= '{') goto yy78;
					goto yy70;
				}
			} else {
				if (yych <= 0x007F) {
					if (yych <= '~') goto yy78;
					goto yy62;
				} else {
					if (yych != 0xEBAD) goto yy78;
				}
			}
		}
	}
	++YYCURSOR;
#line 245 "mwlib/_uscan.re"
	{RET(t_ebad);}
#line 553 "mwlib/_uscan.cc"
yy52:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '[':	goto yy333;
	case 'f':	goto yy336;
	case 'h':	goto yy335;
	case 'i':	goto yy338;
	case 'm':	goto yy339;
	case 'n':	goto yy337;
	default:	goto yy53;
	}
yy53:
#line 303 "mwlib/_uscan.re"
	{RET(t_special);}
#line 569 "mwlib/_uscan.cc"
yy54:
	++YYCURSOR;
	if ((yych = *YYCURSOR) == 'a') goto yy321;
	goto yy125;
yy55:
#line 259 "mwlib/_uscan.re"
	{RET(t_text);}
#line 577 "mwlib/_uscan.cc"
yy56:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy313;
	goto yy125;
yy57:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy306;
	goto yy125;
yy58:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy298;
	goto yy125;
yy59:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy288;
	goto yy125;
yy60:
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '_') goto yy146;
yy61:
#line 260 "mwlib/_uscan.re"
	{RET(t_text);}
#line 600 "mwlib/_uscan.cc"
yy62:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy126;
yy63:
#line 313 "mwlib/_uscan.re"
	{RET(t_text);}
#line 608 "mwlib/_uscan.cc"
yy64:
	yych = *++YYCURSOR;
	goto yy125;
yy65:
	yych = *++YYCURSOR;
	if (yych == ']') goto yy122;
	goto yy53;
yy66:
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '=') goto yy120;
	goto yy119;
yy67:
#line 263 "mwlib/_uscan.re"
	{
			if (eol()) {
			        if (line_startswith_section>=0) {
				     line_startswith_section=-1;
				     RET(t_section_end);
                                } else {
				     RET(t_text);
                                }
			} else {
				RET(t_text);
			}
		    }
#line 634 "mwlib/_uscan.cc"
yy68:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy113;
	if (yych == ' ') goto yy116;
yy69:
#line 285 "mwlib/_uscan.re"
	{newline(); RET(t_newline);}
#line 643 "mwlib/_uscan.cc"
yy70:
	yych = *++YYCURSOR;
	if (yych <= '*') {
		if (yych == '!') goto yy109;
		goto yy53;
	} else {
		if (yych <= '+') goto yy111;
		if (yych == '|') goto yy109;
		goto yy53;
	}
yy71:
	yych = *++YYCURSOR;
	if (yych == '!') goto yy109;
	goto yy63;
yy72:
	yych = *++YYCURSOR;
	goto yy53;
yy73:
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy106;
	goto yy63;
yy74:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '!') goto yy90;
		if (yych <= '.') goto yy63;
		goto yy91;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy63;
			goto yy92;
		} else {
			if (yych <= '`') goto yy63;
			if (yych <= 'z') goto yy92;
			goto yy63;
		}
	}
yy75:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych == '#') goto yy79;
		if (yych <= '/') goto yy63;
		goto yy81;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy63;
			goto yy81;
		} else {
			if (yych <= '`') goto yy63;
			if (yych <= 'z') goto yy81;
			goto yy63;
		}
	}
yy76:
	++YYCURSOR;
#line 312 "mwlib/_uscan.re"
	{newline(); return t_end;}
#line 703 "mwlib/_uscan.cc"
yy78:
	yych = *++YYCURSOR;
	goto yy63;
yy79:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= '/') goto yy80;
		if (yych <= '9') goto yy86;
	} else {
		if (yych <= 'X') goto yy85;
		if (yych == 'x') goto yy85;
	}
yy80:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy53;
			} else {
				goto yy63;
			}
		} else {
			goto yy69;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept <= 3) {
				goto yy115;
			} else {
				goto yy61;
			}
		} else {
			goto yy55;
		}
	}
yy81:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= '/') goto yy80;
		if (yych <= '9') goto yy81;
		if (yych <= ':') goto yy80;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy80;
			goto yy81;
		} else {
			if (yych <= '`') goto yy80;
			if (yych <= 'z') goto yy81;
			goto yy80;
		}
	}
yy83:
	++YYCURSOR;
#line 310 "mwlib/_uscan.re"
	{RET(t_entity);}
#line 760 "mwlib/_uscan.cc"
yy85:
	yych = *++YYCURSOR;
	if (yych == ';') goto yy80;
	goto yy89;
yy86:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '/') goto yy80;
	if (yych <= '9') goto yy86;
	if (yych == ';') goto yy83;
	goto yy80;
yy88:
	++YYCURSOR;
	yych = *YYCURSOR;
yy89:
	if (yych <= ';') {
		if (yych <= '/') goto yy80;
		if (yych <= '9') goto yy88;
		if (yych <= ':') goto yy80;
		goto yy83;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy80;
			goto yy88;
		} else {
			if (yych <= '`') goto yy80;
			if (yych <= 'f') goto yy88;
			goto yy80;
		}
	}
yy90:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy98;
	goto yy80;
yy91:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy80;
	if (yych <= 'Z') goto yy92;
	if (yych <= '`') goto yy80;
	if (yych >= '{') goto yy80;
yy92:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= ';') {
			if (yych <= 0x0000) goto yy80;
		} else {
			if (yych <= '<') goto yy80;
			if (yych >= '>') goto yy96;
		}
	} else {
		if (yych <= 'Z') {
			if (yych >= 'A') goto yy92;
		} else {
			if (yych <= '`') goto yy94;
			if (yych <= 'z') goto yy92;
		}
	}
yy94:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '<') {
		if (yych <= 0x0000) goto yy80;
		if (yych <= ';') goto yy94;
		goto yy80;
	} else {
		if (yych != '>') goto yy94;
	}
yy96:
	++YYCURSOR;
#line 306 "mwlib/_uscan.re"
	{RET(t_html_tag);}
#line 833 "mwlib/_uscan.cc"
yy98:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy80;
yy99:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy80;
		if (yych != '-') goto yy99;
	} else {
		if (yych == '=') goto yy99;
		if (yych <= '>') goto yy80;
		goto yy99;
	}
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy80;
		if (yych != '-') goto yy99;
	} else {
		if (yych == '=') goto yy99;
		if (yych <= '>') goto yy80;
		goto yy99;
	}
yy102:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy80;
		if (yych == '-') goto yy102;
		goto yy99;
	} else {
		if (yych <= '<') goto yy80;
		if (yych != '>') goto yy99;
	}
	++YYCURSOR;
#line 309 "mwlib/_uscan.re"
	{RET(t_comment);}
#line 872 "mwlib/_uscan.cc"
yy106:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\'') goto yy106;
#line 304 "mwlib/_uscan.re"
	{RET(t_singlequote);}
#line 879 "mwlib/_uscan.cc"
yy109:
	++YYCURSOR;
#line 287 "mwlib/_uscan.re"
	{
		if (tablemode) {
		        if (cursor[-2]!='!' || cursor[-2]==lineflags.rowchar) {
			       RET(t_column);
			}
		}
		cursor = start+1;
		RET(t_special);
	}
#line 892 "mwlib/_uscan.cc"
yy111:
	++YYCURSOR;
#line 297 "mwlib/_uscan.re"
	{
		if (tablemode) 
			RET(t_tablecaption);
		cursor = start+1;
		RET(t_special);
	}
#line 902 "mwlib/_uscan.cc"
yy113:
	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\n') goto yy113;
	if (yych == ' ') goto yy116;
yy115:
#line 276 "mwlib/_uscan.re"
	{newline();
		 Py_UNICODE *tmp = cursor;

		 cursor = start+1;
		 found(t_newline);
		 start += 1;
		 cursor = tmp;  
		 RET(t_break);
		}
#line 920 "mwlib/_uscan.cc"
yy116:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\n') goto yy113;
	if (yych == ' ') goto yy116;
	goto yy80;
yy118:
	++YYCURSOR;
	yych = *YYCURSOR;
yy119:
	if (yych == '\t') goto yy118;
	if (yych == ' ') goto yy118;
	goto yy67;
yy120:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= 0x001F) {
		if (yych == '\t') goto yy118;
		goto yy67;
	} else {
		if (yych <= ' ') goto yy118;
		if (yych == '=') goto yy120;
		goto yy67;
	}
yy122:
	++YYCURSOR;
#line 262 "mwlib/_uscan.re"
	{RET(t_2box_close);}
#line 949 "mwlib/_uscan.cc"
yy124:
	++YYCURSOR;
	yych = *YYCURSOR;
yy125:
	if (yych <= '@') {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy124;
		goto yy55;
	} else {
		if (yych <= 'Z') goto yy124;
		if (yych <= '`') goto yy55;
		if (yych <= 'z') goto yy124;
		goto yy55;
	}
yy126:
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'Q') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '-') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '-') goto yy80;
	goto yy132;
yy131:
	++YYCURSOR;
	yych = *YYCURSOR;
yy132:
	if (yych <= '/') {
		if (yych != '-') goto yy80;
	} else {
		if (yych <= '9') goto yy131;
		if (yych <= '`') goto yy80;
		if (yych <= 'z') goto yy131;
		goto yy80;
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy80;
	if (yych >= ':') goto yy80;
yy134:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '-') goto yy136;
	if (yych <= '/') goto yy80;
	if (yych <= '9') goto yy134;
	goto yy80;
yy136:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy80;
	goto yy138;
yy137:
	++YYCURSOR;
	yych = *YYCURSOR;
yy138:
	if (yych <= '/') {
		if (yych != '-') goto yy80;
	} else {
		if (yych <= '9') goto yy137;
		if (yych <= '`') goto yy80;
		if (yych <= 'f') goto yy137;
		goto yy80;
	}
	yych = *++YYCURSOR;
	if (yych != 'Q') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'U') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 0x007F) goto yy80;
	++YYCURSOR;
#line 257 "mwlib/_uscan.re"
	{RET(t_uniq);}
#line 1027 "mwlib/_uscan.cc"
yy146:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'E':	goto yy150;
	case 'F':	goto yy149;
	case 'N':	goto yy148;
	case 'S':	goto yy151;
	case 'T':	goto yy147;
	default:	goto yy153;
	}
yy147:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy285;
	goto yy80;
yy148:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'E') goto yy174;
		goto yy80;
	} else {
		if (yych <= 'O') goto yy172;
		if (yych == 'U') goto yy173;
		goto yy80;
	}
yy149:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy164;
	goto yy80;
yy150:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy161;
	goto yy80;
yy151:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy154;
	goto yy80;
yy152:
	++YYCURSOR;
	yych = *YYCURSOR;
yy153:
	if (yych == '_') goto yy152;
	goto yy61;
yy154:
	yych = *++YYCURSOR;
	if (yych != 'A') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
yy159:
	++YYCURSOR;
#line 256 "mwlib/_uscan.re"
	{RET(t_magicword);}
#line 1086 "mwlib/_uscan.cc"
yy161:
	yych = *++YYCURSOR;
	if (yych != 'D') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy164:
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'O') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy172:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':	goto yy206;
	case 'E':	goto yy205;
	case 'G':	goto yy207;
	case 'I':	goto yy204;
	case 'N':	goto yy208;
	case 'T':	goto yy203;
	default:	goto yy80;
	}
yy173:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy188;
	goto yy80;
yy174:
	yych = *++YYCURSOR;
	if (yych != 'W') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'S') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'O') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'L') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'K') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy188:
	yych = *++YYCURSOR;
	if (yych != 'B') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'D') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'H') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'A') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'D') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'G') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'S') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy203:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych == 'C') goto yy265;
		goto yy80;
	} else {
		if (yych <= 'I') goto yy266;
		if (yych == 'O') goto yy264;
		goto yy80;
	}
yy204:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy259;
	goto yy80;
yy205:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy248;
	goto yy80;
yy206:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy232;
	if (yych == 'O') goto yy233;
	goto yy80;
yy207:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy225;
	goto yy80;
yy208:
	yych = *++YYCURSOR;
	if (yych != 'U') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'M') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'B') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'D') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'H') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'A') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'D') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'G') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'S') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy225:
	yych = *++YYCURSOR;
	if (yych != 'L') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'L') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'Y') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy232:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy247;
	goto yy80;
yy233:
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'O') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'V') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy247:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy248:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'S') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'O') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy259:
	yych = *++YYCURSOR;
	if (yych != 'D') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'X') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy264:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy279;
	goto yy80;
yy265:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy278;
	goto yy80;
yy266:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'L') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'O') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'N') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'V') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'E') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'R') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy278:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy279:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy280;
	if (yych == '_') goto yy281;
	goto yy80;
yy280:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy282;
	goto yy80;
yy281:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy282:
	yych = *++YYCURSOR;
	if (yych != 'M') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy285:
	yych = *++YYCURSOR;
	if (yych != 'C') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '_') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '_') goto yy159;
	goto yy80;
yy288:
	yych = *++YYCURSOR;
	if (yych != 't') goto yy125;
	yych = *++YYCURSOR;
	if (yych != 'p') goto yy125;
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy292;
	if (yych != 's') goto yy125;
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy125;
yy292:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych != '!') goto yy80;
		} else {
			if (yych == '<') goto yy80;
			if (yych >= '>') goto yy80;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy80;
		} else {
			if (yych <= ']') goto yy80;
			if (yych == 0x007F) goto yy80;
		}
	}
yy295:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy295;
		} else {
			if (yych == '<') goto yy297;
			if (yych <= '=') goto yy295;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy295;
		} else {
			if (yych <= ']') goto yy297;
			if (yych != 0x007F) goto yy295;
		}
	}
yy297:
#line 255 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1464 "mwlib/_uscan.cc"
yy298:
	yych = *++YYCURSOR;
	if (yych != 'p') goto yy125;
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy125;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy80;
			if (yych >= '%') goto yy80;
		} else {
			if (yych <= ':') goto yy303;
			if (yych != '=') goto yy80;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy303;
			if (yych != '_') goto yy80;
		} else {
			if (yych == '|') goto yy80;
			if (yych >= 0x007F) goto yy80;
		}
	}
yy303:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy305;
			if (yych <= '$') goto yy303;
		} else {
			if (yych <= ':') goto yy303;
			if (yych == '=') goto yy303;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy303;
			if (yych == '_') goto yy303;
		} else {
			if (yych == '|') goto yy305;
			if (yych <= '~') goto yy303;
		}
	}
yy305:
#line 253 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1516 "mwlib/_uscan.cc"
yy306:
	yych = *++YYCURSOR;
	if (yych != 'w') goto yy125;
	yych = *++YYCURSOR;
	if (yych != 's') goto yy125;
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy125;
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych != '.') goto yy80;
	} else {
		if (yych <= '9') goto yy310;
		if (yych <= '@') goto yy80;
		if (yych >= 'b') goto yy80;
	}
yy310:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy310;
	} else {
		if (yych <= '9') goto yy310;
		if (yych <= '@') goto yy312;
		if (yych <= 'a') goto yy310;
	}
yy312:
#line 251 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1546 "mwlib/_uscan.cc"
yy313:
	yych = *++YYCURSOR;
	if (yych != 'c') goto yy125;
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy125;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy80;
		if (yych >= ':') goto yy80;
	} else {
		if (yych <= 'Z') goto yy318;
		if (yych <= '`') goto yy80;
		if (yych >= '{') goto yy80;
	}
yy318:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy320;
		if (yych <= '9') goto yy318;
	} else {
		if (yych <= 'Z') goto yy318;
		if (yych <= '`') goto yy320;
		if (yych <= 'z') goto yy318;
	}
yy320:
#line 249 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1580 "mwlib/_uscan.cc"
yy321:
	yych = *++YYCURSOR;
	if (yych != 'i') goto yy125;
	yych = *++YYCURSOR;
	if (yych != 'l') goto yy125;
	yych = *++YYCURSOR;
	if (yych != 't') goto yy125;
	yych = *++YYCURSOR;
	if (yych != 'o') goto yy125;
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy125;
	yych = *++YYCURSOR;
	if (yych == '@') goto yy80;
	goto yy328;
yy327:
	++YYCURSOR;
	yych = *YYCURSOR;
yy328:
	if (yych <= '9') {
		if (yych <= '\'') {
			if (yych == '!') goto yy327;
			if (yych <= '"') goto yy80;
			goto yy327;
		} else {
			if (yych <= ')') goto yy80;
			if (yych == ',') goto yy80;
			goto yy327;
		}
	} else {
		if (yych <= '?') {
			if (yych == '=') goto yy327;
			if (yych <= '>') goto yy80;
			goto yy327;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'A') goto yy327;
			} else {
				if (yych <= ']') goto yy80;
				if (yych <= '~') goto yy327;
				goto yy80;
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych <= ',') goto yy80;
		} else {
			if (yych <= '/') goto yy80;
			if (yych >= ':') goto yy80;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy330;
			if (yych <= '^') goto yy80;
		} else {
			if (yych <= '`') goto yy80;
			if (yych >= '{') goto yy80;
		}
	}
yy330:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych >= '-') goto yy330;
		} else {
			if (yych <= '/') goto yy332;
			if (yych <= '9') goto yy330;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy330;
			if (yych >= '_') goto yy330;
		} else {
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy330;
		}
	}
yy332:
#line 247 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1664 "mwlib/_uscan.cc"
yy333:
	++YYCURSOR;
#line 261 "mwlib/_uscan.re"
	{RET(t_2box_open);}
#line 1669 "mwlib/_uscan.cc"
yy335:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy375;
	goto yy80;
yy336:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy367;
	goto yy80;
yy337:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy360;
	goto yy80;
yy338:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy352;
	goto yy80;
yy339:
	yych = *++YYCURSOR;
	if (yych != 'a') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'i') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'l') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 't') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'o') goto yy80;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy80;
	yych = *++YYCURSOR;
	if (yych == '@') goto yy80;
	goto yy347;
yy346:
	++YYCURSOR;
	yych = *YYCURSOR;
yy347:
	if (yych <= '9') {
		if (yych <= '\'') {
			if (yych == '!') goto yy346;
			if (yych <= '"') goto yy80;
			goto yy346;
		} else {
			if (yych <= ')') goto yy80;
			if (yych == ',') goto yy80;
			goto yy346;
		}
	} else {
		if (yych <= '?') {
			if (yych == '=') goto yy346;
			if (yych <= '>') goto yy80;
			goto yy346;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'A') goto yy346;
			} else {
				if (yych <= ']') goto yy80;
				if (yych <= '~') goto yy346;
				goto yy80;
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych <= ',') goto yy80;
		} else {
			if (yych <= '/') goto yy80;
			if (yych >= ':') goto yy80;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy349;
			if (yych <= '^') goto yy80;
		} else {
			if (yych <= '`') goto yy80;
			if (yych >= '{') goto yy80;
		}
	}
yy349:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych >= '-') goto yy349;
		} else {
			if (yych <= '/') goto yy351;
			if (yych <= '9') goto yy349;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy349;
			if (yych >= '_') goto yy349;
		} else {
			if (yych <= '`') goto yy351;
			if (yych <= 'z') goto yy349;
		}
	}
yy351:
#line 246 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1770 "mwlib/_uscan.cc"
yy352:
	yych = *++YYCURSOR;
	if (yych != 'c') goto yy80;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy80;
		if (yych >= ':') goto yy80;
	} else {
		if (yych <= 'Z') goto yy357;
		if (yych <= '`') goto yy80;
		if (yych >= '{') goto yy80;
	}
yy357:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy359;
		if (yych <= '9') goto yy357;
	} else {
		if (yych <= 'Z') goto yy357;
		if (yych <= '`') goto yy359;
		if (yych <= 'z') goto yy357;
	}
yy359:
#line 248 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1803 "mwlib/_uscan.cc"
yy360:
	yych = *++YYCURSOR;
	if (yych != 'w') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 's') goto yy80;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych != '.') goto yy80;
	} else {
		if (yych <= '9') goto yy364;
		if (yych <= '@') goto yy80;
		if (yych >= 'b') goto yy80;
	}
yy364:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy364;
	} else {
		if (yych <= '9') goto yy364;
		if (yych <= '@') goto yy366;
		if (yych <= 'a') goto yy364;
	}
yy366:
#line 250 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1832 "mwlib/_uscan.cc"
yy367:
	yych = *++YYCURSOR;
	if (yych != 'p') goto yy80;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy80;
			if (yych >= '%') goto yy80;
		} else {
			if (yych <= ':') goto yy372;
			if (yych != '=') goto yy80;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy372;
			if (yych != '_') goto yy80;
		} else {
			if (yych == '|') goto yy80;
			if (yych >= 0x007F) goto yy80;
		}
	}
yy372:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy374;
			if (yych <= '$') goto yy372;
		} else {
			if (yych <= ':') goto yy372;
			if (yych == '=') goto yy372;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy372;
			if (yych == '_') goto yy372;
		} else {
			if (yych == '|') goto yy374;
			if (yych <= '~') goto yy372;
		}
	}
yy374:
#line 252 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1883 "mwlib/_uscan.cc"
yy375:
	yych = *++YYCURSOR;
	if (yych != 't') goto yy80;
	yych = *++YYCURSOR;
	if (yych != 'p') goto yy80;
	yych = *++YYCURSOR;
	if (yych == ':') goto yy379;
	if (yych != 's') goto yy80;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy80;
yy379:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych != '/') goto yy80;
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych != '!') goto yy80;
		} else {
			if (yych == '<') goto yy80;
			if (yych >= '>') goto yy80;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy80;
		} else {
			if (yych <= ']') goto yy80;
			if (yych == 0x007F) goto yy80;
		}
	}
yy382:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy382;
		} else {
			if (yych == '<') goto yy384;
			if (yych <= '=') goto yy382;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy382;
		} else {
			if (yych <= ']') goto yy384;
			if (yych != 0x007F) goto yy382;
		}
	}
yy384:
#line 254 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1936 "mwlib/_uscan.cc"
}
#line 314 "mwlib/_uscan.re"

}


PyObject *py_scan(PyObject *self, PyObject *args) 
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O:mwscan.scan", &arg1)) {
		return 0;
	}
	PyUnicodeObject *unistr = (PyUnicodeObject*)PyUnicode_FromObject(arg1);
	if (unistr == NULL) {
		PyErr_SetString(PyExc_TypeError,
				"parameter cannot be converted to unicode in mwscan.scan");
		return 0;
	}

	Py_UNICODE *start = unistr->str;
	Py_UNICODE *end = start+unistr->length;
	

	Scanner scanner (start, end);
	Py_BEGIN_ALLOW_THREADS
	while (scanner.scan()) {
	}
	Py_END_ALLOW_THREADS
	Py_XDECREF(unistr);
	
	// return PyList_New(0); // uncomment to see timings for scanning

	int size = scanner.tokens.size();
	PyObject *result = PyList_New(size);
	if (!result) {
		return 0;
	}
	
	for (int i=0; i<size; i++) {
		Token t = scanner.tokens[i];
		PyList_SET_ITEM(result, i, Py_BuildValue("iii", t.type, t.start, t.len));
	}
	
	return result;
}



static PyMethodDef module_functions[] = {
	{"scan", (PyCFunction)py_scan, METH_VARARGS, "scan(text)"},
	{0, 0},
};



extern "C" {
	DL_EXPORT(void) init_uscan();
}

DL_EXPORT(void) init_uscan()
{
	/*PyObject *m =*/ Py_InitModule("_uscan", module_functions);
}
