# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeStateCounts(Model):
    """Counts of various compute node states on the cluster.

    All required parameters must be populated in order to send to Azure.

    :param idle_node_count: Required. Number of compute nodes in idle state.
    :type idle_node_count: int
    :param running_node_count: Required. Number of compute nodes which are
     running jobs.
    :type running_node_count: int
    :param preparing_node_count: Required. Number of compute nodes which are
     being prepared.
    :type preparing_node_count: int
    :param unusable_node_count: Required. Number of compute nodes which are
     unusable.
    :type unusable_node_count: int
    :param leaving_node_count: Required. Number of compute nodes which are
     leaving the cluster.
    :type leaving_node_count: int
    """

    _validation = {
        'idle_node_count': {'required': True},
        'running_node_count': {'required': True},
        'preparing_node_count': {'required': True},
        'unusable_node_count': {'required': True},
        'leaving_node_count': {'required': True},
    }

    _attribute_map = {
        'idle_node_count': {'key': 'idleNodeCount', 'type': 'int'},
        'running_node_count': {'key': 'runningNodeCount', 'type': 'int'},
        'preparing_node_count': {'key': 'preparingNodeCount', 'type': 'int'},
        'unusable_node_count': {'key': 'unusableNodeCount', 'type': 'int'},
        'leaving_node_count': {'key': 'leavingNodeCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(NodeStateCounts, self).__init__(**kwargs)
        self.idle_node_count = kwargs.get('idle_node_count', None)
        self.running_node_count = kwargs.get('running_node_count', None)
        self.preparing_node_count = kwargs.get('preparing_node_count', None)
        self.unusable_node_count = kwargs.get('unusable_node_count', None)
        self.leaving_node_count = kwargs.get('leaving_node_count', None)
