/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;
import py4j.AbstractCommand;
import py4j.Protocol;
import py4j.Py4JException;
import py4j.ReturnObject;

public class MemoryCommand
extends AbstractCommand {
    private final Logger logger = Logger.getLogger(MemoryCommand.class.getName());
    public static final String MEMORY_COMMAND_NAME = "m";
    public static final String MEMORY_DEL_SUB_COMMAND_NAME = "d";
    public static final String MEMORY_ATTACH_SUB_COMMAND_NAME = "a";

    @Override
    public void execute(String commandName, BufferedReader reader, BufferedWriter writer) throws Py4JException, IOException {
        String returnCommand = null;
        String subCommand = reader.readLine();
        returnCommand = subCommand.equals(MEMORY_DEL_SUB_COMMAND_NAME) ? this.deleteObject(reader) : this.attachObject(reader);
        this.logger.info("Returning command: " + returnCommand);
        writer.write(returnCommand);
        writer.flush();
    }

    private String attachObject(BufferedReader reader) throws IOException {
        String objectId = reader.readLine();
        reader.readLine();
        String returnCommand = Protocol.getOutputErrorCommand();
        try {
            ReturnObject rObject = this.gateway.attachObject(objectId);
            returnCommand = Protocol.getOutputCommand(rObject);
        }
        catch (Exception e) {
            // empty catch block
        }
        return returnCommand;
    }

    private String deleteObject(BufferedReader reader) throws IOException {
        String objectId = reader.readLine();
        reader.readLine();
        this.gateway.deleteObject(objectId);
        return Protocol.getOutputVoidCommand();
    }
}

