"""
0;276;0csetup
=====
"""

from setuptools import setup, find_packages
from setuptools.extension import Extension

try:
    from Cython.Build import cythonize
except ImportError:
    extensions = [Extension("astarlib", sources=["astarlib.c"])]
else:
    extensions = cythonize(
        "astarlib.pyx",
        compiler_directives={
            "language_level": 3,
            "cdivision": True,
            "infer_types": True,
            "overflowcheck": True,
        }
    )


setup(
    name="astarlib",
    description="A* search algorithm implemented in Cython",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/initbar/astarlib",
    author="Herbert Shin",
    author_email="h@init.bar",
    version="1.0.0",
    license="MIT",
    setup_requires=[
        "Cython==0.29.4"
    ],
    python_requires=">=2.7",
    packages=find_packages(exclude=["docs", "tests"]),
    ext_modules=extensions,
    include_package_data=True,
    zip_safe=False,
    classifiers=[
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
    ],
)
