[![Build Status](https://travis-ci.org/initbar/astarlib.svg?branch=master)](https://travis-ci.org/initbar/astarlib)

# astarlib

**astarlib** is a [Cython ("C-Extensions for Python")](https://cython.org) implementation of the [A\* search algorithm](https://en.wikipedia.org/wiki/A*_search_algorithm) on a [graph](https://en.wikipedia.org/wiki/Graph_(discrete_mathematics)) or a [2-dimensional polygon space](https://en.wikipedia.org/wiki/Polygon) packaged into a reusable library. It was originally implemented as custom bot component for [battlesnake.io](https://battlesnake.io) competitions.

## Documentations

See [documentations](./docs).

## Example

To find A\* paths in a 2D polygon, you need to initialize an [aStar()](https://github.com/initbar/astarlib/blob/master/astarlib/algorithm.pyx) object with a "map" of the traversing space.

```python
>> from astarlib import aStar
>> area = aStar(array=[
  [True, True, True, True, True, True],  # see `normalization`
  [False, 1, False, 1, 1, 1],
  [0, 0, 0, 0, 0, True],
  [1, 1, 1, 1, 1, 1],
  [0, 1, 0, 1, 0, 1],
  [0, 0, 1, 1, 1, 1],
])
```

And simply set the origin/destination positions to find a valid path and distance.

```python
>> area.find_path(start=(0, 0), end=(area.height-1, area.width-1))
(
  ((0, 0), (0, 1), (0, 2), (0, 3), (0, 4), (0, 5), (1, 5), (2, 5), (3, 5), (4, 5), (5, 5)),
  11
)
>> area.find_path(start=(0, 0), end=(0, 1))
(
  ((0, 0), (0, 1)),
  2
)
>> area.find_path(start=(0, 0), end=(1, 0))  # `PathNotFoundException`
```

For more example, see [examples](./docs/examples).

## Build

Local build for development requires [some dependencies](./requirements.txt) to compile C extensions.

```bash
~$ pip install -r requirements.txt
~$ python setup.py build_ext --inplace  # `make build`
```

## Installation

For `stable` channel:

```bash
~$ pip install astarlib
```

For `edge` channel:

```bash
~$ pip install -r https://raw.githubusercontent.com/initbar/astarlib/master/requirements.txt
~$ pip install git+https://github.com/initbar/astarlib.git
```

## License

**astarlib** is licensed under [MIT License](./LICENSE).
