# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class VulnerabilityAssessmentScanRecord(ProxyResource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Possible values include:
     'OnDemand', 'Recurring'
    :vartype trigger_type: str or
     ~azure.mgmt.sql.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Possible values include: 'Passed', 'Failed',
     'FailedToRun', 'InProgress'
    :vartype state: str or
     ~azure.mgmt.sql.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: datetime
    :ivar errors: The scan errors.
    :vartype errors:
     list[~azure.mgmt.sql.models.VulnerabilityAssessmentScanError]
    :ivar storage_container_path: The scan results storage container path.
    :vartype storage_container_path: str
    :ivar number_of_failed_security_checks: The number of failed security
     checks.
    :vartype number_of_failed_security_checks: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scan_id': {'readonly': True},
        'trigger_type': {'readonly': True},
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'readonly': True},
        'storage_container_path': {'readonly': True},
        'number_of_failed_security_checks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scan_id': {'key': 'properties.scanId', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'errors': {'key': 'properties.errors', 'type': '[VulnerabilityAssessmentScanError]'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'number_of_failed_security_checks': {'key': 'properties.numberOfFailedSecurityChecks', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanRecord, self).__init__(**kwargs)
        self.scan_id = None
        self.trigger_type = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.storage_container_path = None
        self.number_of_failed_security_checks = None
