# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource_py3 import TrackedResource


class VirtualCluster(TrackedResource):
    """An Azure SQL virtual cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar subnet_id: Subnet resource ID for the virtual cluster.
    :vartype subnet_id: str
    :param family: If the service has different generations of hardware, for
     the same SKU, then that can be captured here.
    :type family: str
    :ivar child_resources: List of resources in this virtual cluster.
    :vartype child_resources: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'subnet_id': {'readonly': True},
        'child_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'family': {'key': 'properties.family', 'type': 'str'},
        'child_resources': {'key': 'properties.childResources', 'type': '[str]'},
    }

    def __init__(self, *, location: str, tags=None, family: str=None, **kwargs) -> None:
        super(VirtualCluster, self).__init__(location=location, tags=tags, **kwargs)
        self.subnet_id = None
        self.family = family
        self.child_resources = None
