import numpy as np
import pylab as pl

def str_num(string): 
    array = [float(x) for x in string.split()]
    return array 
'''
# thermal expansion
T, °C 20 50 100 150 200 250 300 400 450 500 550 600
am, 10-6/°C 16.7 17.0 17.3 17.5 17.7 17.8 18.0 18.1 18.2 18.4 18.5 18.6
ai, 10-6/°C 16.7 17.2 17.6 18.0 18.4 18.6 18.6

# Youngs Modulus (20-700) E[GPa] T[C]
E = 128- 2.59x10-2 T - 4.87x10-5 T2

# Poisson's ratio
v = 0.33

# density rho[Kgm^3] (20-700)
r = 8900*(1 - 3 x10-6 (7.20 x10-9 T3 - 9.05x10-6T2 + 6.24 x10-3T + 16.6)x(T - 20))

# conductivity (20-700) k[W/mK] T[C]
l = 2.11x10-7 T3 - 2.83x10-4 T2 - 1.38x10-1 T + 323

# specific heat (20-700) Cp[KJ/KgK] T[C]
T = [20,50,100,150,200,250,300,350,400,450,500,550,600,650,700]
Cp = [390,393,398,402,407,412,417,422,427,432,437,442,447,452,458]

'''
class stress_strain(object):
    
    def __init__(self):
        self.T = []
        self.stress = []
        self.strain = []
    
    def add_T(self,T):
        self.T.append(T)
        
    def add_stress(self,stress):
        self.stress.append(str_num(stress))
        
    def add_strain(self,strain):
        self.strain.append(str_num(strain))
        
class yeald_strength(object):
    def add(self, T, Sy, irr, ave):
        T = str_num(T)
        Sy = str_num(Sy)
        val = {'T':T, 'Sy':Sy}
        setattr(self, 'Sy_'+irr+'_'+ave, val)
        
class tensile_strength(object):
    def add(self, T, Su, irr, ave):
        T = str_num(T)
        Su = str_num(Su)
        val = {'T':T, 'Su':Su}
        setattr(self, 'Su_'+irr+'_'+ave, val)
        
class uniform_elongation(object):
    def add(self, T, eu, irr, ave):
        T = str_num(T)
        eu = str_num(eu)
        val = {'T':T, 'eu':eu}
        setattr(self, 'eu_'+irr+'_'+ave, val)
        
class total_elongation(object):
    def add(self, T, et, irr, ave):
        T = str_num(T)
        et = str_num(et)
        val = {'T':T, 'et':et}
        setattr(self, 'et_'+irr+'_'+ave, val)

# stress-strain treatment B
ssB = stress_strain()
ssB.add_T(20)
ssB.add_strain('0	0.007968	0.039833	0.07965	0.095572	0.111492	0.127416\
	0.143459	0.161122	0.173579	0.19558	0.245168	0.370801	0.495814	0.696923\
	1.018539	1.528756	2.330388	3.575737	5.484939')
ssB.add_stress('0	10.0008	50.01992	100.0797	120.1147	140.1562	160.204\
	180.2584	200.3225	210.3648	220.4307	230.5646	240.8916	246.2178	251.7484\
	257.6105	264.0053	271.248	279.8292	290.5049') 
ssB.add_T(50)
ssB.add_strain('0	0.007874	0.039362	0.078709	0.094444	0.110176	0.125917\
	0.141861	0.160543	0.176007	0.20759	0.285751	0.49221	0.700235	1.036217\
	1.574239	2.427008	3.762555	5.824885')
ssB.add_stress('0	10.00079	50.01969	100.0787	120.1134	140.1543	160.2016\
	180.2555	200.3213	210.3699	220.4572	230.6582	241.1842	246.7216	252.604\
	259.0461	266.3874	275.1607	286.1943')
ssB.add_T(100)
ssB.add_strain('0	0.008	0.039992	0.079968	0.095954	0.111938	0.127947\
	0.144438	0.167418	0.193407	0.257557	0.431869	0.908865	1.393533	2.176731\
	3.426796	5.393175')
ssB.add_stress('0	10.0008	50.02	100.08	120.1152	140.1568	160.2048\
	180.2602	200.3351	210.4065	220.5674	230.9954	242.1912	248.4381	255.5015\
	263.8898	274.4073')
ssB.add_T(150)
ssB.add_strain('0	0.00813	0.040642	0.081268	0.097513	0.11376	0.130084\
	0.147897	0.185623	0.248963	0.429235	0.946011	2.379172	3.829749')
ssB.add_stress('0	10.00081	50.02033	100.0813	120.1171	140.1594	160.2083\
	180.2664	200.3716	210.5235	220.9463	232.1861	245.7785	254.5649')
ssB.add_T(200)
ssB.add_strain('0	0.008264	0.041314	0.08261	0.099125	0.115646	0.132427\
	0.154028	0.240024	0.426698	0.633195	0.98976	1.598741	2.625016	4.327302')
ssB.add_stress('0	10.00083	50.02066	100.0826	120.119	140.162	160.212\
	180.2775	200.4806	210.898	216.3657	222.1883	228.6261	236.1175	245.3924')
ssB.add_T(250)
ssB.add_strain('0	0.008474	0.042364	0.08471	0.101644	0.118613	0.136602\
	0.173342	0.460257	1.159445	1.942862	3.293457	5.577651')
ssB.add_stress('0	10.00085	50.02119	100.0847	120.122	140.1662	160.2187\
	180.3123	200.9226	212.449	219.218	227.3662	237.9063')
ssB.add_T(300)
ssB.add_strain('0	0.00862	0.043094	0.08617	0.103399	0.120805	0.143134\
	0.255666	1.564498	4.818794')
ssB.add_stress('0	10.00086	50.02155	100.0862	120.1241	140.1692	160.2292\
	180.4608	203.1536	220.3673')
 
ssC = stress_strain()
ssC.add_T(20)
ssC.add_strain('0	0.007968	0.039833	0.079788	0.097053	0.122474	0.189697\
	0.224296	0.272293	0.338867	0.430951	0.557729	0.731263	0.96724	1.285875\
	1.712947	2.280981	3.030524	4.011445	5.284144')
ssC.add_stress('0	10.0008	50.01992	100.0798	120.1165	140.1716	160.3038\
	165.3705	170.4635	175.594	180.7774	186.0347	191.3945	196.8953	202.5884\
	208.5418	214.8451	221.6154	229.0046	237.2091')
ssC.add_T(50)
ssC.add_strain('0	0.007874	0.039362	0.078882	0.096298	0.123926	0.203889\
	0.246152	0.305181	0.387456	0.501635	0.659187	0.875151	1.169058	1.56601\
	2.097922	2.804883	3.736582	4.953664')
ssC.add_stress('0	10.00079	50.01969	100.0789	120.1156	140.1736	160.3266\
	165.4067	170.5196	175.6794	180.9052	186.2235	191.6701	197.293	203.1567\
	209.3462	215.9736	223.1856	231.1725')
ssC.add_T(100)
ssC.add_strain('0	0.008	0.039992	0.080243	0.098895	0.133752	0.251616\
	0.31639	0.407727	0.535863	0.714459	0.961558	1.300739	1.762466	2.385632\
	3.219222	4.324002')
ssC.add_stress('0	10.0008	50.02	100.0803	120.1187	140.1874	160.4031\
	165.5229	170.6946	175.9403	181.2906	186.7875	192.4875	198.4673	204.8286\
	211.7068	219.2796')
ssC.add_T(150)
ssC.add_strain('0	0.00813	0.040642	0.081677	0.101891	0.14622	0.314027\
	0.408471	0.542367	0.730872	0.994162	1.358793	1.859306	2.540038	3.457081\
	4.680224')
ssC.add_stress('0	10.00081	50.02033	100.0817	120.1223	140.2049	160.5032\
	165.6754	170.9245	176.2837	181.7984	187.5309	193.5657	200.0165	207.0351\
	214.8225')
ssC.add_T(200)
ssC.add_strain('0	0.008264	0.041314	0.083281	0.106296	0.168818	0.433479\
	0.585473	0.801862	1.107228	1.534138	2.125184	2.935247	4.033885')
ssC.add_stress('0	10.00083	50.02066	100.0833	120.1276	140.2365	160.6951\
	165.9689	171.3686	176.9484	182.7827	188.9737	195.6596	203.0269')
ssC.add_T(250)
ssC.add_strain('0	0.008474	0.042364	0.085737	0.112627	0.20001	0.596621\
	0.826857	1.15521	1.618805	2.266526	3.161723	4.385013')
ssC.add_stress('0	10.00085	50.02119	100.0858	120.1352	140.2803	160.9574\
	166.37	171.9752	177.856	184.1263	190.9426	198.5169')
ssC.add_T(300)
ssC.add_strain('0	0.00862	0.043094	0.087915	0.122067	0.259024	0.920505\
	1.307496	1.859582	2.638145	3.72298	5.215648')
ssC.add_stress('0	10.00086	50.02155	100.088	120.1466	140.3631	161.4796\
	167.1715	173.1909	179.6782	186.8277	194.905')
 
SyA = yeald_strength()
SyA.add('20	50	100	150	200	250	300	350	400	450	500',
        '407	397	381	365	348	331	313	294	275	254	233',
        'uni','min')
SyA.add('150	200	250	300	350	400',
        '365	348	331	313	294	275',
        'irr','min')
SyB = yeald_strength()
SyB.add('20	50	80	100	150	200	250	300	350	400	450	500',
        '287	283	278	275	266	256	244	231	217	201	184	166',
        'uni','ave')
SyB.add('20	50	80	100	150	200	250	300	350	400	450	500',
        '241	237	232	229	220	210	198	185	171	155	138	120',
        'uni','min')
SyB.add('80	100	150	200	250	300',
        '402	389	358	341	280	218',
        'irr','min')
SyC = yeald_strength()
SyC.add('20	50	100	150	200	250	300	350	400	450	500',
        '175	172	166	161	155	150	144	139	133	127	121',
        'uni','min')
        
SyA = tensile_strength()
SyA.add('20	50	100	150	200	250	300	350	400	450	500',
        '452	432	405	381	361	342	325	307	287	264	238',
        'uni','min')
SyA.add('150	200	250	300	350	400',
        '490	367	400	283	217	64',
        'irr','min')
        
SyB = tensile_strength()
SyB.add('20	50	80	100	150	200	250	300	350	400	450	500',
        '405	392	384	372	353	334	315	295	274	253	229	203',
        'uni','ave')
SyB.add('20	50	80	100	150	200	250	300	350	400	450	500',
        '369	356	348	336	317	297	278	259	238	216	193	167',
        'uni','min')
SyB.add('80	100	150	200	250	300',
        '448	433	396	379	346	312',
        'irr','ave')
SyB.add('80	100	150	200	250	300',
        '406	396	371	356	313	270',
        'irr','min')
        
SyC = tensile_strength()
SyC.add('20	50	100	150	200	250	300	350	400	450	500',
        '280	272	259	246	233	220	207	194	181	170	160',
        'uni','min')
SyC.add('100	150	200	250	300',
        '319	300	292	255	218',
        'irr','min')

euA = uniform_elongation()
euA.add('20	50	100	150	200	250	300	350	400	450	500',
        '7.2	6.4	5.2	4.1	3.2	2.4	1.8	1.3	1	0.8	0.7',
        'uni','ave')
euA.add('20	50	100	150	200	250	300	350	400	450	500',
        '5.9	5.1	3.9	2.8	1.9	1.1	0.5	0	0	0	0',
        'uni','min')
euA.add('150	200	250	300	350	400',
        '0.2	0.7	4.4	1.5	10	18.5',
        'irr','ave')
euA.add('150	200	250	300	350	400',
        '0.1	0.3	3.9	0.9	6.7	12.5',
        'irr','min')
        
euB = uniform_elongation()
euB.add('20	50	100	150	200	250	300	350	400	450	500',
        '18.4	17.5	16.2	15.1	14.3	13.7	13.3	13.2	13.3	13.7	14.3',
        'uni','ave')
euB.add('20	50	100	150	200	250	300	350	400	450	500',
        '10.9	10	8.7	7.6	6.8	6.2	5.8	5.7	5.8	6.2	6.8',
        'uni','min')
euB.add('100	150	200	250	300	350',
        '0.67	0.77	2.14	5.3	9.57	14.44',
        'irr','ave')
euB.add('100	150	200	250	300	350',
        '0	0	0.17	3.16	7.35	11.28',
        'irr','min')

euC = euB  # no data supplied - recomended to used B treatment in-place

etA = total_elongation()
etA.add('20	50	100	150	200	250	300	350	400	450	500',
        '20.3	18.7	16.3	14.3	12.7	11.4	10.5	9.9	9.8	9.9	10.4',
        'uni','ave')
etA.add('20	50	100	150	200	250	300	350	400	450	500',
        '10	8.4	6	4	2.4	1.1	0.2	0	0	0	0.1',
        'uni','min')
etA.add('150	200	250	300	350	400',
        '8.9	10.3	12.7	11.3	21	31',
        'irr','ave')
etA.add('150	200	250	300	350	400',
        '8.7	9	11.1	10.2	14	18',
        'irr','min')
        
etB = total_elongation()
etB.add('20	50	100	150	200	250	300	350	400	450	500',
        '27	25	23	21	21	21	21	23	26	29	33',
        'uni','ave')
etB.add('20	50	100	150	200	250	300	350	400	450	500',
        '17	15	12	11	10	10	11	12	15	18	22',
        'uni','min')
etB.add('100	150	200	250	300',
        '2	15	14	15.5	17',
        'irr','ave')
etB.add('100	150	200	250	300',
        '2	8	5	9	13',
        'irr','min')

etC = etB  # no data supplied - recomended to used B treatment in-place
