# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class SyncAgentLinkedDatabase(ProxyResource):
    """An Azure SQL Database sync agent linked database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_type: Type of the sync agent linked database. Possible
     values include: 'AzureSqlDatabase', 'SqlServerDatabase'
    :vartype database_type: str or ~azure.mgmt.sql.models.SyncMemberDbType
    :ivar database_id: Id of the sync agent linked database.
    :vartype database_id: str
    :ivar description: Description of the sync agent linked database.
    :vartype description: str
    :ivar server_name: Server name of the sync agent linked database.
    :vartype server_name: str
    :ivar database_name: Database name of the sync agent linked database.
    :vartype database_name: str
    :ivar user_name: User name of the sync agent linked database.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_type': {'readonly': True},
        'database_id': {'readonly': True},
        'description': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_type': {'key': 'properties.databaseType', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(SyncAgentLinkedDatabase, self).__init__(**kwargs)
        self.database_type = None
        self.database_id = None
        self.description = None
        self.server_name = None
        self.database_name = None
        self.user_name = None
