# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Database(Model):
    """Information about a single database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Unique identifier for the database
    :vartype id: str
    :ivar name: Name of the database
    :vartype name: str
    :ivar compatibility_level: SQL Server compatibility level of database.
     Possible values include: 'CompatLevel80', 'CompatLevel90',
     'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130',
     'CompatLevel140'
    :vartype compatibility_level: str or
     ~azure.mgmt.datamigration.models.DatabaseCompatLevel
    :ivar collation: Collation name of the database
    :vartype collation: str
    :ivar server_name: Name of the server
    :vartype server_name: str
    :ivar fqdn: Fully qualified name
    :vartype fqdn: str
    :ivar install_id: Install id of the database
    :vartype install_id: str
    :ivar server_version: Version of the server
    :vartype server_version: str
    :ivar server_edition: Edition of the server
    :vartype server_edition: str
    :ivar server_level: Product level of the server (RTM, SP, CTP).
    :vartype server_level: str
    :ivar server_default_data_path: Default path of the data files
    :vartype server_default_data_path: str
    :ivar server_default_log_path: Default path of the log files
    :vartype server_default_log_path: str
    :ivar server_default_backup_path: Default path of the backup folder
    :vartype server_default_backup_path: str
    :ivar server_core_count: Number of cores on the server
    :vartype server_core_count: int
    :ivar server_visible_online_core_count: Number of cores on the server that
     have VISIBLE ONLINE status
    :vartype server_visible_online_core_count: int
    :ivar database_state: State of the database. Possible values include:
     'Online', 'Restoring', 'Recovering', 'RecoveryPending', 'Suspect',
     'Emergency', 'Offline', 'Copying', 'OfflineSecondary'
    :vartype database_state: str or
     ~azure.mgmt.datamigration.models.DatabaseState
    :ivar server_id: The unique Server Id
    :vartype server_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'compatibility_level': {'readonly': True},
        'collation': {'readonly': True},
        'server_name': {'readonly': True},
        'fqdn': {'readonly': True},
        'install_id': {'readonly': True},
        'server_version': {'readonly': True},
        'server_edition': {'readonly': True},
        'server_level': {'readonly': True},
        'server_default_data_path': {'readonly': True},
        'server_default_log_path': {'readonly': True},
        'server_default_backup_path': {'readonly': True},
        'server_core_count': {'readonly': True},
        'server_visible_online_core_count': {'readonly': True},
        'database_state': {'readonly': True},
        'server_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str'},
        'collation': {'key': 'collation', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'install_id': {'key': 'installId', 'type': 'str'},
        'server_version': {'key': 'serverVersion', 'type': 'str'},
        'server_edition': {'key': 'serverEdition', 'type': 'str'},
        'server_level': {'key': 'serverLevel', 'type': 'str'},
        'server_default_data_path': {'key': 'serverDefaultDataPath', 'type': 'str'},
        'server_default_log_path': {'key': 'serverDefaultLogPath', 'type': 'str'},
        'server_default_backup_path': {'key': 'serverDefaultBackupPath', 'type': 'str'},
        'server_core_count': {'key': 'serverCoreCount', 'type': 'int'},
        'server_visible_online_core_count': {'key': 'serverVisibleOnlineCoreCount', 'type': 'int'},
        'database_state': {'key': 'databaseState', 'type': 'str'},
        'server_id': {'key': 'serverId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Database, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.compatibility_level = None
        self.collation = None
        self.server_name = None
        self.fqdn = None
        self.install_id = None
        self.server_version = None
        self.server_edition = None
        self.server_level = None
        self.server_default_data_path = None
        self.server_default_log_path = None
        self.server_default_backup_path = None
        self.server_core_count = None
        self.server_visible_online_core_count = None
        self.database_state = None
        self.server_id = None
