# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DatabasePrincipal(Model):
    """DatabasePrincipal.

    All required parameters must be populated in order to send to Azure.

    :param role: Required. Database principal role. Possible values include:
     'Admin', 'Ingestor', 'Monitor', 'User', 'UnrestrictedViewers', 'Viewer'
    :type role: str or ~azure.mgmt.kusto.models.DatabasePrincipalRole
    :param name: Required. Database principal name.
    :type name: str
    :param type: Required. Database principal type. Possible values include:
     'App', 'Group', 'User'
    :type type: str or ~azure.mgmt.kusto.models.DatabasePrincipalType
    :param fqn: Database principal fully qualified name.
    :type fqn: str
    :param email: Database principal email if exists.
    :type email: str
    :param app_id: Application id - relevant only for application principal
     type.
    :type app_id: str
    """

    _validation = {
        'role': {'required': True},
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'role': {'key': 'role', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'fqn': {'key': 'fqn', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabasePrincipal, self).__init__(**kwargs)
        self.role = kwargs.get('role', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.fqn = kwargs.get('fqn', None)
        self.email = kwargs.get('email', None)
        self.app_id = kwargs.get('app_id', None)
