# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureCapacity(Model):
    """AzureCapacity.

    All required parameters must be populated in order to send to Azure.

    :param scale_type: Required. Scale type. Possible values include:
     'automatic', 'manual', 'none'
    :type scale_type: str or ~azure.mgmt.kusto.models.AzureScaleType
    :param minimum: Required. Minimum allowed capacity.
    :type minimum: int
    :param maximum: Required. Maximum allowed capacity.
    :type maximum: int
    :param default: Required. The default capacity that would be used.
    :type default: int
    """

    _validation = {
        'scale_type': {'required': True},
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureCapacity, self).__init__(**kwargs)
        self.scale_type = kwargs.get('scale_type', None)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)
        self.default = kwargs.get('default', None)
