import pandas as pd 
from sqlalchemy import create_engine,types
from sqlalchemy.dialects.postgresql import TEXT 
import pymssql
import cx_Oracle
import psycopg2 
import MySQLdb
import datetime
import re
import sqlite3
import os 
from lmf.dbv2 import db_write,db_query


#postgresql 查询结果输出csv文件
def pg2csv(sql,conp,path,chunksize,f=None,**krg):
    #sql="select * from hefei.gg limit 100"
    #conp=["postgres",'since2015','192.168.4.175','anhui','hefei']
    #path="d:\\test.csv"
    con=create_engine("postgresql://%s:%s@%s/%s"%(conp[0],conp[1],conp[2],conp[3]),encoding='utf-8',execution_options=dict(stream_results=True))
    dfs=pd.read_sql(sql,con,chunksize=chunksize)

    count=1
    for df in dfs:

        total=count*chunksize
        print('第%d行写入中'%total)
        if f is not None:
            df=f(df)
        if count==1:
            df.to_csv(path,index=False,**krg)
        else:
            krg['header']=False
            df.to_csv(path,mode='a+',index=False,**krg)
        count+=1
    if count==1:
        print("df为空")
        df=db_query(sql,dbtype="postgresql",conp=conp)
        df.to_csv(path,index=False,**krg)



def pg2pg(sql,tb,conp1,conp2,chunksize=100,f=None,if_exists='replace',datadict='postgresql-text'):
    conp=conp1
    con=create_engine("postgresql://%s:%s@%s/%s"%(conp[0],conp[1],conp[2],conp[3]),encoding='utf-8',execution_options=dict(stream_results=True))
    dfs=pd.read_sql(sql,con,chunksize=chunksize)
    count=1
    for df in dfs:
        total=count*chunksize
        print('第%d行写入中'%total)
        if f is not None:
            df=f(df)
        if count==1:
            db_write(df,tb,dbtype="postgresql",conp=conp2,if_exists=if_exists,datadict='postgresql-text')
        else:
            #krg['header']=False
            db_write(df,tb,dbtype="postgresql",conp=conp2,if_exists='append',datadict='postgresql-text')
        count+=1

# sql="select * from hefei.gg limit 100"
# conp=["postgres",'since2015','192.168.4.175','anhui','hefei']
# path="d:\\test.csv"

# def f1(df):
#     df['name']='xx'
#     return df 
# pg2csv(sql,conp,path,10,f1,sep='\001')
# def f1(df):
#     df['name']='xx'
#     return df 

# conp1=["postgres",'since2015','192.168.4.175','anhui','hefei']

# conp2=["postgres",'since2015','192.168.4.175','mine','hunan']

# pg2pg("select * from hefei.gg limit 1000",'test',conp1,conp2,f=f1)
# path="D:/webroot/bstdata/base_20190421.csv"
# conp=["gpadmin","since2015",'192.168.4.179',"base_db","v2"]
# sql="select distinct on(html_key) * from v2.t_gg where ggstart_time>='2019-04-21' and ggstart_time<'2020-05-20' and html_key>7923769 "
# dfs=pg2csv(sql,conp,path,10,sep='\001')