import csv
import json
import datetime


"""
Criação de módulo que calcula as compensações de continuidade à consumidores.
"""


class CompensationContinuityConsumer:
    __code_consumer = ""
    __year = 0
    __type_tension = "BT"
    __type_area = "URB"
    __type_system = "INT"
    __code_conjunt = 0
    __dic_monthly_h = [0.0] * 12
    __dic_quartely_h = [0.0] * 4
    __proportion_dic_quartely = [0.0] * 4
    __paid_monthly_dic_quartely_rs = [0.0] * 4
    __dic_yearly_h = [0.0] * 1
    __proportion_dic_yearly = [0.0] * 1
    __paid_monthly_dic_yearly_rs = [0.0] * 1
    __fic_monthly = [0.0] * 12
    __fic_quartely = [0.0] * 4
    __proportion_fic_quartely = [0.0] * 4
    __paid_monthly_fic_quartely_rs = [0.0] * 4
    __fic_yearly = [0.0] * 1
    __proportion_fic_yearly = [0.0] * 1
    __paid_monthly_fic_yearly_rs = [0.0] * 1
    __dmic_monthly_h = [0.0] * 12
    __eusd_monthly_rs = [0.0] * 12
    __eusd_quartely_rs = [0.0] * 4
    __eusd_yearly_rs = [0.0] * 1
    __kei = 0
    __limit_dec_yearly_h = 0
    __limit_fec_yearly = 0
    __limit_dic_monthly_h = 0
    __limit_fic_monthly = 0
    __limit_dmic_monthly_h = 0
    __limit_dic_quartely_h = 0
    __limit_fic_quartely = 0
    __limit_dic_yearly_h = 0
    __limit_fic_yearly = 0
    __monthly_value_compensation = [0.0] * 12
    __monthly_indicator_compensation = ["NA"] * 12
    __quartely_value_compensation = [0.0] * 4
    __quartely_indicator_compensation = ["NA"] * 4
    __yearly_value_compensation = [0.0] * 1
    __yearly_indicator_compensation = ["NA"] * 1

    def set_features(self, code_consumer, year, type_tension, type_area, type_system, code_conjunt, dic_h, fic, dmic_h,
                     eusd_rs):
        self.__code_consumer = code_consumer
        self.__year = year
        self.__type_tension = type_tension
        self.__type_area = type_area
        self.__type_system = type_system
        self.__code_conjunt = code_conjunt
        self.__dic_monthly_h = dic_h
        self.__fic_monthly = fic
        self.__dmic_monthly_h = dmic_h
        self.__eusd_monthly_rs = eusd_rs
        self.calculate_compensation()

    @classmethod
    def get_kei(cls, type_tension):
        if type_tension == "BT":
            return 15
        elif type_tension == "MT":
            return 20
        elif type_tension == "AT":
            return 27

    def __set_kei(self):
        self.__kei = CompensationContinuityConsumer.get_kei(self.__type_tension)

    @classmethod
    def get_dec_fec_limits(cls, code_conjunt, year):
        dec_fec_limits = [0.0] * 2
        # Each register must follow the pattern
        # [year1, [[codeConjunt1, yearlyDech, yearlyFec], [codeConjunt2, yearlyDech, yearlyFec]]]
        limits_table_dech_fec = [
            [1996, [[6000, 30, 45], [6001, 30, 45], [6003, 30, 45], [6004, 30, 45], [6005, 30, 45], [6006, 30, 45],
                    [6007, 30, 45], [6008, 30, 45], [6009, 30, 45], [6010, 30, 45], [6011, 30, 45], [6012, 30, 45],
                    [6013, 30, 45], [6014, 30, 45], [6015, 30, 45], [6016, 30, 45], [6018, 30, 45], [6019, 30, 45],
                    [6020, 30, 45], [6021, 30, 45], [6022, 30, 45], [6023, 30, 45], [6024, 30, 45], [6025, 30, 45],
                    [6026, 30, 45], [6027, 30, 45], [6028, 30, 45], [6031, 30, 45], [6032, 30, 45], [6034, 30, 45],
                    [6035, 30, 45], [6036, 30, 45], [6037, 30, 45], [6038, 30, 45], [6039, 30, 45], [6040, 30, 45],
                    [6041, 30, 45], [6042, 30, 45]]],
            [1997, [[1, 50, 60], [2, 120, 90], [3, 70, 70], [4, 120, 90], [5, 120, 90], [6, 120, 90], [7, 120, 90],
                    [8, 70, 70], [13, 120, 90], [14, 120, 90], [15, 70, 70], [16, 70, 70], [17, 120, 90], [18, 70, 70],
                    [19, 70, 70], [20, 120, 90], [21, 70, 70], [22, 120, 90], [23, 120, 90], [24, 120, 90],
                    [25, 13.55, 9.36], [26, 70, 70], [27, 120, 90], [28, 50, 60], [29, 120, 90], [30, 31.41, 21.15],
                    [32, 120, 90], [33, 70, 70], [34, 120, 90], [35, 120, 90], [37, 120, 90], [38, 120, 90],
                    [39, 30, 45], [40, 70, 70], [41, 120, 90], [42, 70, 70], [43, 120, 90], [44, 120, 90], [45, 70, 70],
                    [46, 120, 90], [47, 70, 70], [48, 70, 70], [49, 50, 60], [50, 120, 90], [51, 120, 90], [53, 40, 50],
                    [54, 120, 90], [55, 50, 60], [56, 120, 90], [57, 120, 90], [59, 70, 70], [60, 120, 90],
                    [61, 70, 70], [62, 120, 90], [63, 70, 70], [64, 30, 45], [65, 50, 60], [66, 20, 25], [68, 70, 70],
                    [69, 70, 70], [70, 50, 60], [71, 50, 60], [72, 120, 90], [73, 120, 90], [75, 50, 60], [76, 120, 90],
                    [77, 35.02, 25.49], [78, 120, 90], [81, 70, 70], [82, 70, 70], [83, 40, 50], [84, 120, 90],
                    [87, 120, 90], [88, 15.28, 7.56], [89, 32.24, 21.39], [90, 120, 90], [91, 40, 50], [94, 120, 90],
                    [95, 120, 90], [96, 70, 70], [97, 120, 90], [98, 120, 90], [99, 70, 70], [101, 70, 70],
                    [103, 120, 90], [104, 50, 60], [105, 40, 50], [106, 70, 70], [107, 50, 60], [108, 50, 60],
                    [109, 40, 50], [110, 120, 90], [111, 70, 70], [113, 70, 70], [115, 120, 90], [116, 70, 70],
                    [117, 70, 70], [119, 70, 70], [120, 120, 90], [121, 17.05, 9.84], [122, 120, 90], [123, 120, 90],
                    [124, 70, 70], [125, 120, 90], [128, 70, 70], [129, 120, 90], [130, 30, 45], [131, 120, 90],
                    [133, 35.02, 25.49], [134, 120, 90], [135, 120, 90], [136, 120, 90], [137, 120, 90], [138, 120, 90],
                    [139, 120, 90], [140, 50, 60], [141, 70, 70], [142, 70, 70], [143, 120, 90], [144, 50, 60],
                    [146, 35.02, 25.49], [147, 32.24, 21.39], [149, 50, 60], [150, 50, 60], [152, 120, 90],
                    [153, 30, 45], [154, 120, 90], [155, 120, 90], [156, 120, 90], [157, 120, 90], [158, 35.02, 25.49],
                    [160, 120, 90], [161, 50, 60], [162, 17.62, 13.77], [163, 70, 70], [164, 120, 90], [165, 120, 90],
                    [166, 120, 90], [167, 120, 90], [168, 50, 60], [169, 70, 70], [170, 120, 90], [171, 70, 70],
                    [173, 30, 45], [174, 70, 70], [175, 120, 90], [176, 70, 70], [177, 70, 70], [178, 120, 90],
                    [181, 120, 90], [182, 120, 90], [183, 70, 70], [184, 120, 90], [185, 120, 90], [186, 120, 90],
                    [187, 50, 60], [189, 120, 90], [190, 70, 70], [191, 120, 90], [192, 70, 70], [193, 50, 60],
                    [194, 120, 90], [195, 70, 70], [197, 120, 90], [198, 120, 90], [199, 120, 90], [200, 50, 60],
                    [201, 120, 90], [203, 70, 70], [204, 70, 70], [205, 50, 60], [206, 120, 90], [207, 120, 90],
                    [208, 120, 90], [209, 120, 90], [210, 120, 90], [211, 120, 90], [212, 70, 70], [213, 120, 90],
                    [214, 120, 90], [215, 50, 60], [216, 120, 90], [217, 120, 90], [218, 70, 70], [219, 50, 60],
                    [220, 70, 70], [221, 70, 70], [225, 50, 60], [226, 70, 70], [227, 120, 90], [228, 50, 60],
                    [229, 70, 70], [230, 40, 50], [231, 70, 70], [232, 70, 70], [233, 70, 70], [234, 50, 60],
                    [235, 70, 70], [236, 70, 70], [237, 10.83, 7.57], [239, 120, 90], [240, 120, 90], [241, 70, 70],
                    [242, 120, 90], [243, 120, 90], [244, 120, 90], [245, 120, 90], [246, 120, 90], [247, 120, 90],
                    [248, 120, 90], [249, 120, 90], [250, 50, 60], [252, 120, 90], [253, 120, 90], [254, 120, 90],
                    [256, 50, 60], [257, 120, 90], [258, 120, 90], [259, 70, 70], [260, 70, 70], [261, 15, 25],
                    [262, 70, 70], [264, 70, 70], [265, 120, 90], [267, 120, 90], [268, 35.02, 25.49], [269, 120, 90],
                    [270, 120, 90], [271, 120, 90], [272, 120, 90], [273, 30, 45], [274, 120, 90], [275, 40, 50],
                    [277, 70, 70], [278, 120, 90], [279, 120, 90], [280, 50, 60], [282, 70, 70], [283, 35.02, 25.49],
                    [284, 70, 70], [285, 120, 90], [286, 120, 90], [287, 40, 50], [288, 120, 90], [289, 120, 90],
                    [291, 70, 70], [292, 50, 60], [293, 120, 90], [295, 120, 90], [296, 70, 70], [297, 35.02, 25.49],
                    [298, 50, 60], [299, 120, 90], [300, 120, 90], [302, 120, 90], [305, 120, 90], [306, 120, 90],
                    [307, 120, 90], [308, 50, 60], [309, 35.02, 25.49], [310, 70, 70], [311, 70, 70], [312, 120, 90],
                    [313, 120, 90], [314, 70, 70], [315, 120, 90], [316, 120, 90], [317, 120, 90], [318, 120, 90],
                    [319, 40, 50], [320, 120, 90], [321, 120, 90], [322, 120, 90], [323, 120, 90], [324, 40, 50],
                    [325, 120, 90], [326, 50, 60], [327, 120, 90], [328, 120, 90], [329, 70, 70], [330, 120, 90],
                    [331, 70, 70], [332, 120, 90], [333, 120, 90], [334, 120, 90], [335, 120, 90], [336, 120, 90],
                    [337, 120, 90], [339, 120, 90], [340, 120, 90], [342, 70, 70], [343, 120, 90], [344, 120, 90],
                    [345, 120, 90], [346, 120, 90], [347, 120, 90], [348, 120, 90], [350, 70, 70], [351, 120, 90],
                    [352, 120, 90], [353, 20.67, 13.88], [354, 50, 60], [355, 70, 70], [356, 120, 90], [357, 120, 90],
                    [358, 32.24, 21.39], [360, 120, 90], [361, 70, 70], [362, 50, 60], [363, 70, 70], [364, 120, 90],
                    [365, 120, 90], [366, 70, 70], [367, 50, 60], [368, 120, 90], [369, 6.34, 5.27], [370, 70, 70],
                    [371, 120, 90], [373, 40, 50], [374, 50, 60], [375, 120, 90], [377, 40, 50], [378, 120, 90],
                    [379, 70, 70], [380, 70, 70], [381, 120, 90], [382, 120, 90], [383, 70, 70], [384, 120, 90],
                    [385, 120, 90], [386, 50, 60], [387, 70, 70], [389, 50, 60], [390, 120, 90], [391, 70, 70],
                    [392, 120, 90], [393, 50, 60], [394, 50, 60], [395, 120, 90], [396, 120, 90], [397, 120, 90],
                    [398, 70, 70], [399, 70, 70], [400, 120, 90], [401, 120, 90], [402, 120, 90], [403, 120, 90],
                    [404, 40, 50], [405, 70, 70], [406, 120, 90], [407, 120, 90], [409, 50, 60], [410, 70, 70],
                    [411, 120, 90], [412, 120, 90], [413, 30, 45], [415, 120, 90], [416, 50, 60], [417, 120, 90],
                    [418, 120, 90], [419, 120, 90], [421, 70, 70], [422, 35.02, 25.49], [424, 120, 90], [425, 70, 70],
                    [426, 35.02, 25.49], [427, 40, 50], [428, 70, 70], [429, 70, 70], [430, 70, 70], [432, 70, 70],
                    [433, 120, 90], [434, 70, 70], [436, 70, 70], [437, 50, 60], [438, 70, 70], [439, 70, 70],
                    [440, 120, 90], [441, 70, 70], [442, 50, 60], [443, 120, 90], [444, 20.67, 13.88], [445, 120, 90],
                    [446, 120, 90], [447, 70, 70], [448, 120, 90], [449, 70, 70], [450, 120, 90], [451, 120, 90],
                    [452, 120, 90], [453, 70, 70], [454, 120, 90], [455, 120, 90], [456, 120, 90], [457, 50, 60],
                    [458, 70, 70], [459, 120, 90], [460, 70, 70], [461, 50, 60], [462, 120, 90], [465, 120, 90],
                    [466, 120, 90], [467, 35.02, 25.49], [468, 120, 90], [469, 120, 90], [470, 35.02, 25.49],
                    [471, 70, 70], [472, 120, 90], [473, 120, 90], [474, 70, 70], [475, 120, 90], [476, 120, 90],
                    [477, 120, 90], [478, 120, 90], [479, 70, 70], [480, 70, 70], [481, 70, 70], [482, 70, 70],
                    [483, 120, 90], [484, 70, 70], [485, 120, 90], [486, 50, 60], [487, 30, 45], [488, 120, 90],
                    [490, 120, 90], [491, 70, 70], [493, 120, 90], [494, 120, 90], [495, 120, 90], [496, 70, 70],
                    [497, 70, 70], [498, 70, 70], [499, 120, 90], [500, 120, 90], [501, 70, 70], [502, 120, 90],
                    [503, 70, 70], [504, 40, 50], [505, 50, 60], [507, 120, 90], [508, 70, 70], [509, 5.13, 4.64],
                    [510, 50, 60], [512, 40, 50], [513, 70, 70], [514, 120, 90], [515, 120, 90], [516, 120, 90],
                    [517, 120, 90], [518, 120, 90], [519, 70, 70], [520, 120, 90], [521, 120, 90], [522, 70, 70],
                    [523, 120, 90], [524, 70, 70], [525, 120, 90], [526, 70, 70], [527, 70, 70], [528, 50, 60],
                    [529, 70, 70], [530, 70, 70], [531, 10.37, 9.91], [532, 50, 60], [533, 70, 70], [534, 50, 60],
                    [535, 120, 90], [536, 40, 50], [537, 70, 70], [538, 120, 90], [539, 70, 70], [540, 70, 70],
                    [541, 70, 70], [542, 120, 90], [543, 120, 90], [545, 120, 90], [546, 120, 90], [547, 15, 25],
                    [548, 120, 90], [549, 120, 90], [550, 70, 70], [551, 120, 90], [552, 120, 90], [553, 120, 90],
                    [554, 15, 25], [555, 120, 90], [556, 120, 90], [557, 40, 50], [558, 120, 90], [559, 70, 70],
                    [561, 120, 90], [562, 120, 90], [563, 70, 70], [564, 12.02, 6.99], [565, 30, 45], [566, 120, 90],
                    [567, 70, 70], [568, 70, 70], [569, 70, 70], [570, 120, 90], [571, 70, 70], [572, 40, 50],
                    [573, 120, 90], [574, 70, 70], [575, 120, 90], [576, 120, 90], [577, 120, 90], [578, 120, 90],
                    [579, 40, 50], [580, 120, 90], [581, 30, 45], [582, 70, 70], [583, 70, 70], [584, 21.39, 10.39],
                    [585, 70, 70], [586, 50, 60], [587, 120, 90], [588, 70, 70], [589, 120, 90], [590, 70, 70],
                    [591, 120, 90], [592, 120, 90], [593, 70, 70], [594, 32.24, 21.39], [595, 50, 60], [596, 50, 60],
                    [597, 70, 70], [599, 120, 90], [600, 120, 90], [601, 120, 90], [602, 70, 70], [603, 120, 90],
                    [604, 120, 90], [605, 70, 70], [606, 120, 90], [607, 50, 60], [608, 70, 70], [609, 40, 50],
                    [610, 50, 60], [611, 120, 90], [612, 70, 70], [614, 70, 70], [615, 120, 90], [616, 120, 90],
                    [618, 40, 50], [619, 120, 90], [621, 120, 90], [623, 8.39, 6.11], [625, 120, 90], [626, 40, 50],
                    [627, 50, 60], [628, 70, 70], [629, 120, 90], [630, 120, 90], [631, 120, 90], [632, 30, 45],
                    [633, 120, 90], [635, 70, 70], [636, 70, 70], [637, 7.01, 5.35], [638, 120, 90], [639, 70, 70],
                    [640, 70, 70], [641, 120, 90], [642, 120, 90], [643, 120, 90], [644, 120, 90], [645, 50, 60],
                    [646, 120, 90], [647, 70, 70], [648, 70, 70], [649, 70, 70], [650, 120, 90], [651, 120, 90],
                    [652, 70, 70], [653, 70, 70], [654, 120, 90], [656, 120, 90], [657, 120, 90], [658, 120, 90],
                    [660, 50, 60], [661, 70, 70], [662, 120, 90], [663, 120, 90], [664, 70, 70], [665, 120, 90],
                    [666, 120, 90], [667, 120, 90], [668, 120, 90], [669, 50, 60], [670, 70, 70], [672, 70, 70],
                    [673, 120, 90], [674, 70, 70], [675, 70, 70], [676, 120, 90], [677, 120, 90], [678, 70, 70],
                    [679, 120, 90], [681, 32.24, 21.39], [682, 8.1, 6.18], [685, 70, 70], [686, 50, 60], [687, 120, 90],
                    [688, 120, 90], [689, 120, 90], [690, 50, 60], [691, 120, 90], [692, 32.24, 21.39], [693, 70, 70],
                    [694, 50, 60], [695, 120, 90], [697, 120, 90], [698, 70, 70], [699, 30, 45], [700, 70, 70],
                    [701, 120, 90], [702, 70, 70], [703, 70, 70], [704, 120, 90], [705, 40, 50], [706, 70, 70],
                    [707, 120, 90], [708, 70, 70], [709, 120, 90], [710, 120, 90], [711, 50, 60], [712, 120, 90],
                    [713, 120, 90], [714, 50, 60], [715, 120, 90], [716, 70, 70], [717, 70, 70], [718, 50, 60],
                    [719, 120, 90], [720, 120, 90], [721, 50, 60], [722, 120, 90], [723, 120, 90], [724, 120, 90],
                    [726, 120, 90], [727, 50, 60], [730, 35.02, 25.49], [731, 50, 60], [732, 120, 90], [733, 120, 90],
                    [734, 30, 45], [735, 120, 90], [736, 70, 70], [737, 70, 70], [738, 120, 90], [739, 70, 70],
                    [740, 120, 90], [741, 120, 90], [742, 40, 50], [744, 120, 90], [745, 120, 90], [746, 40, 50],
                    [747, 50, 60], [748, 70, 70], [749, 50, 60], [750, 120, 90], [751, 50, 60], [752, 120, 90],
                    [753, 50, 60], [754, 70, 70], [755, 120, 90], [756, 70, 70], [757, 120, 90], [758, 70, 70],
                    [759, 70, 70], [761, 120, 90], [762, 70, 70], [763, 70, 70], [765, 120, 90], [766, 120, 90],
                    [767, 70, 70], [768, 120, 90], [769, 120, 90], [771, 120, 90], [772, 70, 70], [773, 120, 90],
                    [774, 120, 90], [775, 70, 70], [776, 120, 90], [777, 70, 70], [778, 120, 90], [779, 50, 60],
                    [781, 120, 90], [782, 120, 90], [783, 50, 60], [784, 50, 60], [785, 120, 90], [786, 120, 90],
                    [787, 70, 70], [788, 50, 60], [789, 120, 90], [790, 120, 90], [791, 120, 90], [792, 40, 50],
                    [793, 120, 90], [794, 120, 90], [795, 120, 90], [796, 70, 70], [797, 120, 90], [799, 50, 60],
                    [801, 70, 70], [802, 120, 90], [803, 120, 90], [804, 120, 90], [805, 70, 70], [806, 120, 90],
                    [807, 30, 45], [809, 120, 90], [810, 120, 90], [811, 120, 90], [812, 50, 60], [814, 120, 90],
                    [815, 120, 90], [817, 70, 70], [818, 120, 90], [819, 120, 90], [820, 120, 90], [821, 120, 90],
                    [822, 40, 50], [823, 120, 90], [824, 120, 90], [825, 70, 70], [826, 120, 90], [827, 70, 70],
                    [830, 120, 90], [831, 120, 90], [832, 120, 90], [833, 120, 90], [834, 70, 70], [835, 70, 70],
                    [836, 120, 90], [837, 70, 70], [838, 120, 90], [839, 70, 70], [840, 70, 70], [841, 120, 90],
                    [842, 50, 60], [843, 120, 90], [844, 120, 90], [845, 70, 70], [846, 120, 90], [847, 32.24, 21.39],
                    [848, 120, 90], [850, 40, 50], [852, 70, 70], [853, 120, 90], [854, 120, 90], [855, 9.81, 9.88],
                    [856, 120, 90], [857, 120, 90], [858, 120, 90], [859, 120, 90], [860, 70, 70], [861, 120, 90],
                    [863, 40, 50], [865, 70, 70], [867, 120, 90], [868, 70, 70], [869, 70, 70], [870, 120, 90],
                    [871, 120, 90], [872, 70, 70], [873, 70, 70], [874, 50, 60], [875, 120, 90], [876, 120, 90],
                    [877, 120, 90], [878, 5.59, 4.6], [879, 120, 90], [880, 120, 90], [881, 35.02, 25.49],
                    [882, 50, 60], [883, 120, 90], [884, 50, 60], [885, 70, 70], [886, 120, 90], [887, 50, 60],
                    [888, 120, 90], [890, 120, 90], [891, 120, 90], [892, 120, 90], [894, 120, 90], [895, 120, 90],
                    [896, 120, 90], [897, 30, 45], [898, 120, 90], [899, 120, 90], [900, 6.81, 4.72], [901, 120, 90],
                    [902, 70, 70], [903, 70, 70], [904, 120, 90], [905, 120, 90], [906, 70, 70], [907, 120, 90],
                    [908, 50, 60], [910, 17.59, 7.29], [911, 50, 60], [912, 40, 50], [913, 40, 50], [914, 120, 90],
                    [915, 120, 90], [916, 50, 60], [917, 30, 45], [918, 120, 90], [919, 120, 90], [920, 40, 50],
                    [921, 120, 90], [922, 40, 50], [924, 11.58, 10.56], [926, 120, 90], [927, 70, 70], [928, 120, 90],
                    [929, 120, 90], [930, 120, 90], [931, 120, 90], [932, 70, 70], [933, 70, 70], [934, 50, 60],
                    [935, 120, 90], [936, 50, 60], [937, 120, 90], [938, 70, 70], [939, 70, 70], [940, 70, 70],
                    [941, 70, 70], [942, 120, 90], [943, 120, 90], [944, 120, 90], [945, 50, 60], [946, 50, 60],
                    [947, 120, 90], [948, 70, 70], [949, 120, 90], [950, 70, 70], [951, 120, 90], [953, 70, 70],
                    [954, 120, 90], [955, 120, 90], [957, 120, 90], [958, 50, 60], [960, 50, 60], [961, 120, 90],
                    [963, 32.24, 21.39], [964, 50, 60], [965, 50, 60], [967, 120, 90], [968, 120, 90], [969, 70, 70],
                    [970, 20.67, 13.88], [971, 50, 60], [972, 120, 90], [973, 70, 70], [974, 30, 45], [975, 70, 70],
                    [978, 70, 70], [979, 70, 70], [980, 70, 70], [981, 120, 90], [982, 120, 90], [984, 120, 90],
                    [985, 70, 70], [987, 35.02, 25.49], [988, 6.14, 5.32], [989, 120, 90], [990, 120, 90],
                    [991, 120, 90], [992, 120, 90], [993, 120, 90], [994, 120, 90], [995, 120, 90], [996, 120, 90],
                    [997, 120, 90], [998, 70, 70], [999, 120, 90], [1000, 120, 90], [1001, 120, 90], [1003, 8.24, 5.82],
                    [1004, 70, 70], [1005, 17.62, 13.77], [1006, 120, 90], [1007, 40, 50], [1008, 50, 60],
                    [1009, 120, 90], [1010, 50, 60], [1011, 120, 90], [1012, 120, 90], [1013, 120, 90], [1014, 70, 70],
                    [1015, 120, 90], [1016, 50, 60], [1017, 70, 70], [1018, 120, 90], [1019, 70, 70],
                    [1020, 32.24, 21.39], [1021, 70, 70], [1022, 120, 90], [1023, 50, 60], [1025, 120, 90],
                    [1026, 30, 45], [1027, 120, 90], [1029, 32.24, 21.39], [1030, 40, 50], [1031, 120, 90],
                    [1033, 120, 90], [1034, 120, 90], [1035, 30, 45], [1036, 70, 70], [1037, 120, 90], [1038, 70, 70],
                    [1039, 120, 90], [1040, 15, 20], [1041, 120, 90], [1043, 120, 90], [1044, 120, 90], [1045, 120, 90],
                    [1046, 50, 60], [1047, 70, 70], [1048, 70, 70], [1050, 70, 70], [1051, 120, 90], [1052, 50, 60],
                    [1053, 70, 70], [1054, 120, 90], [1055, 120, 90], [1056, 70, 70], [1057, 50, 60], [1058, 70, 70],
                    [1059, 70, 70], [1061, 70, 70], [1062, 70, 70], [1063, 120, 90], [1064, 20.67, 13.88],
                    [1065, 120, 90], [1066, 50, 60], [1067, 120, 90], [1069, 50, 60], [1070, 50, 60], [1071, 70, 70],
                    [1073, 120, 90], [1074, 120, 90], [1076, 70, 70], [1077, 120, 90], [1078, 120, 90], [1079, 120, 90],
                    [1080, 120, 90], [1081, 70, 70], [1082, 120, 90], [1083, 40, 50], [1084, 120, 90], [1085, 120, 90],
                    [1086, 120, 90], [1087, 70, 70], [1088, 120, 90], [1089, 50, 60], [1090, 120, 90], [1091, 120, 90],
                    [1092, 15, 25], [1093, 50, 60], [1094, 120, 90], [1095, 120, 90], [1096, 120, 90], [1097, 70, 70],
                    [1098, 120, 90], [1100, 120, 90], [1102, 120, 90], [1104, 70, 70], [1105, 120, 90], [1106, 120, 90],
                    [1108, 120, 90], [1109, 120, 90], [1110, 120, 90], [1111, 120, 90], [1112, 120, 90],
                    [1113, 120, 90], [1114, 120, 90], [1115, 120, 90], [1116, 120, 90], [1117, 70, 70], [1118, 50, 60],
                    [1119, 50, 60], [1120, 120, 90], [1121, 120, 90], [1122, 35.02, 25.49], [1123, 70, 70],
                    [1124, 70, 70], [1125, 120, 90], [1126, 70, 70], [1127, 35.02, 25.49], [1128, 70, 70],
                    [1129, 20.67, 13.88], [1130, 120, 90], [1131, 40, 50], [1132, 50, 60], [1133, 70, 70],
                    [1134, 120, 90], [1135, 50, 60], [1136, 70, 70], [1137, 120, 90], [1138, 120, 90], [1139, 70, 70],
                    [1140, 50, 60], [1141, 120, 90], [1142, 70, 70], [1143, 70, 70], [1144, 120, 90], [1145, 120, 90],
                    [1148, 120, 90], [1149, 50, 60], [1150, 70, 70], [1151, 70, 70], [1153, 120, 90], [1154, 120, 90],
                    [1155, 120, 90], [1156, 50, 60], [1157, 120, 90], [1158, 50, 60], [1159, 70, 70], [1160, 120, 90],
                    [1161, 120, 90], [1162, 120, 90], [1163, 70, 70], [1164, 120, 90], [1165, 120, 90], [1166, 120, 90],
                    [1167, 70, 70], [1168, 120, 90], [1169, 120, 90], [1170, 120, 90], [1171, 70, 70], [1172, 70, 70],
                    [1173, 50, 60], [1174, 70, 70], [1175, 120, 90], [1176, 120, 90], [1177, 70, 70], [1179, 120, 90],
                    [1181, 120, 90], [1183, 70, 70], [1185, 120, 90], [1186, 70, 70], [1187, 120, 90], [1188, 40, 50],
                    [1189, 120, 90], [1190, 50, 60], [1191, 50, 60], [1192, 70, 70], [1193, 120, 90], [1194, 120, 90],
                    [1195, 120, 90], [1196, 120, 90], [1197, 120, 90], [1198, 120, 90], [1199, 40, 50], [1200, 120, 90],
                    [1201, 70, 70], [1202, 30, 45], [1203, 15, 25], [1204, 70, 70], [1205, 120, 90], [1206, 120, 90],
                    [1207, 30, 45], [1208, 120, 90], [1209, 40, 50], [1210, 40, 50], [1211, 50, 60], [1212, 120, 90],
                    [1213, 40, 50], [1214, 50, 60], [1215, 120, 90], [1216, 50, 60], [1217, 120, 90], [1219, 120, 90],
                    [1220, 120, 90], [1221, 50, 60], [1223, 70, 70], [1224, 120, 90], [1225, 70, 70], [1226, 70, 70],
                    [1227, 120, 90], [1228, 120, 90], [1230, 50, 60], [1232, 30, 45], [1233, 50, 60], [1234, 70, 70],
                    [1235, 50, 60], [1236, 70, 70], [1237, 50, 60], [1238, 70, 70], [1239, 120, 90], [1240, 120, 90],
                    [1241, 70, 70], [1242, 120, 90], [1243, 120, 90], [1244, 70, 70], [1245, 120, 90], [1246, 70, 70],
                    [1247, 70, 70], [1248, 70, 70], [1249, 70, 70], [1250, 40, 50], [1251, 70, 70], [1252, 120, 90],
                    [1253, 50, 60], [1254, 70, 70], [1255, 120, 90], [1257, 50, 60], [1258, 70, 70], [1260, 120, 90],
                    [1261, 50, 60], [1262, 120, 90], [1263, 120, 90], [1264, 120, 90], [1266, 35.02, 25.49],
                    [1267, 120, 90], [1268, 70, 70], [1269, 50, 60], [1270, 120, 90], [1271, 70, 70], [1272, 70, 70],
                    [1273, 120, 90], [1274, 120, 90], [1275, 50, 60], [1276, 32.24, 21.39], [1278, 70, 70],
                    [1280, 14.3, 8.12], [1281, 50, 60], [1282, 50, 60], [1283, 120, 90], [1286, 120, 90],
                    [1287, 70, 70], [1288, 70, 70], [1289, 70, 70], [1290, 120, 90], [1291, 70, 70], [1292, 70, 70],
                    [1293, 20, 25], [1294, 120, 90], [1295, 70, 70], [1296, 50, 60], [1297, 70, 70], [1298, 120, 90],
                    [1299, 120, 90], [1300, 50, 60], [1301, 70, 70], [1302, 30, 45], [1303, 70, 70], [1304, 70, 70],
                    [1305, 120, 90], [1306, 50, 60], [1307, 120, 90], [1308, 120, 90], [1309, 70, 70], [1311, 30, 45],
                    [1312, 26.57, 15.77], [1313, 120, 90], [1314, 50, 60], [1315, 120, 90], [1317, 120, 90],
                    [1318, 120, 90], [1319, 120, 90], [1320, 120, 90], [1322, 50, 60], [1323, 120, 90], [1324, 120, 90],
                    [1325, 120, 90], [1326, 70, 70], [1327, 120, 90], [1328, 70, 70], [1329, 70, 70], [1330, 120, 90],
                    [1331, 120, 90], [1333, 120, 90], [1334, 120, 90], [1335, 70, 70], [1336, 120, 90],
                    [1337, 5.66, 6.03], [1338, 120, 90], [1339, 11.12, 9.1], [1340, 50, 60], [1341, 35.02, 25.49],
                    [1342, 120, 90], [1343, 70, 70], [1344, 120, 90], [1345, 120, 90], [1346, 20.67, 13.88],
                    [1347, 120, 90], [1348, 40, 50], [1349, 70, 70], [1350, 70, 70], [1351, 70, 70],
                    [1352, 35.02, 25.49], [1353, 50, 60], [1355, 120, 90], [1357, 70, 70], [1358, 120, 90],
                    [1359, 120, 90], [1360, 120, 90], [1361, 120, 90], [1362, 70, 70], [1363, 70, 70], [1364, 120, 90],
                    [1365, 40, 50], [1367, 120, 90], [1369, 70, 70], [1370, 120, 90], [1371, 70, 70], [1372, 120, 90],
                    [1373, 70, 70], [1374, 120, 90], [1375, 120, 90], [1376, 40, 50], [1377, 120, 90], [1378, 50, 60],
                    [1379, 120, 90], [1380, 70, 70], [1381, 120, 90], [1382, 50, 60], [1384, 120, 90],
                    [1385, 32.24, 21.39], [1387, 50, 60], [1388, 120, 90], [1390, 120, 90], [1391, 120, 90],
                    [1392, 35.02, 25.49], [1393, 120, 90], [1394, 120, 90], [1395, 70, 70], [1396, 70, 70],
                    [1398, 50, 60], [1400, 120, 90], [1401, 70, 70], [1402, 70, 70], [1403, 120, 90], [1404, 40, 50],
                    [1405, 120, 90], [1409, 120, 90], [1410, 70, 70], [1411, 20.67, 13.88], [1412, 70, 70],
                    [1414, 70, 70], [1415, 70, 70], [1416, 70, 70], [1417, 120, 90], [1418, 70, 70], [1419, 120, 90],
                    [1420, 50, 60], [1421, 120, 90], [1422, 120, 90], [1423, 120, 90], [1424, 50, 60], [1425, 120, 90],
                    [1426, 8.57, 6.77], [1427, 30, 45], [1428, 10.79, 6.72], [1430, 70, 70], [1431, 120, 90],
                    [1432, 6.73, 7.01], [1433, 70, 70], [1434, 70, 70], [1435, 120, 90], [1436, 70, 70],
                    [1437, 120, 90], [1438, 120, 90], [1439, 120, 90], [1440, 120, 90], [1441, 120, 90],
                    [1442, 120, 90], [1443, 50, 60], [1444, 120, 90], [1445, 120, 90], [1447, 120, 90], [1448, 70, 70],
                    [1449, 120, 90], [1450, 120, 90], [1451, 35.02, 25.49], [1452, 70, 70], [1453, 120, 90],
                    [1454, 120, 90], [1455, 120, 90], [1456, 70, 70], [1457, 120, 90], [1458, 40, 50], [1459, 120, 90],
                    [1460, 120, 90], [1461, 6.14, 6.98], [1463, 70, 70], [1464, 50, 60], [1465, 70, 70], [1466, 50, 60],
                    [1467, 70, 70], [1468, 120, 90], [1469, 120, 90], [1470, 30, 45], [1471, 120, 90], [1472, 120, 90],
                    [1473, 50, 60], [1474, 70, 70], [1475, 70, 70], [1476, 70, 70], [1477, 120, 90],
                    [1478, 17.41, 11.68], [1479, 120, 90], [1481, 50, 60], [1482, 70, 70], [1483, 70, 70],
                    [1484, 70, 70], [1485, 120, 90], [1486, 120, 90], [1487, 120, 90], [1488, 120, 90], [1489, 120, 90],
                    [1490, 120, 90], [1491, 13.55, 10.7], [1492, 70, 70], [1493, 120, 90], [1495, 120, 90],
                    [1496, 50, 60], [1497, 120, 90], [1498, 30, 45], [1499, 30, 45], [1500, 120, 90], [1502, 120, 90],
                    [1503, 120, 90], [1505, 120, 90], [1506, 120, 90], [1507, 70, 70], [1508, 120, 90], [1509, 120, 90],
                    [1510, 120, 90], [1511, 50, 60], [1512, 50, 60], [1513, 32.24, 21.39], [1514, 70, 70],
                    [1515, 30, 45], [1516, 70, 70], [1517, 120, 90], [1518, 120, 90], [1519, 120, 90], [1520, 70, 70],
                    [1521, 120, 90], [1522, 120, 90], [1523, 120, 90], [1524, 120, 90], [1525, 40, 50], [1526, 50, 60],
                    [1527, 120, 90], [1528, 70, 70], [1529, 40, 50], [1530, 120, 90], [1531, 120, 90], [1533, 120, 90],
                    [1535, 70, 70], [1536, 70, 70], [1537, 70, 70], [1538, 120, 90], [1539, 40, 50], [1540, 50, 60],
                    [1541, 70, 70], [1542, 50, 60], [1543, 70, 70], [1544, 120, 90], [1545, 120, 90], [1546, 70, 70],
                    [1547, 70, 70], [1548, 120, 90], [1549, 70, 70], [1550, 120, 90], [1551, 120, 90], [1552, 40, 50],
                    [1553, 120, 90], [1554, 70, 70], [1555, 40, 50], [1556, 70, 70], [1557, 120, 90], [1558, 50, 60],
                    [1559, 50, 60], [1560, 70, 70], [1561, 120, 90], [1562, 120, 90], [1563, 30, 45], [1565, 120, 90],
                    [1567, 120, 90], [1568, 70, 70], [1569, 120, 90], [1571, 120, 90], [1572, 120, 90], [1573, 70, 70],
                    [1574, 50, 60], [1575, 120, 90], [1576, 50, 60], [1577, 50, 60], [1578, 120, 90], [1579, 120, 90],
                    [1580, 50, 60], [1581, 19.75, 12.12], [1582, 70, 70], [1583, 120, 90], [1584, 120, 90],
                    [1585, 70, 70], [1586, 120, 90], [1587, 70, 70], [1588, 40, 50], [1589, 70, 70], [1590, 70, 70],
                    [1591, 70, 70], [1592, 32.24, 21.39], [1593, 30, 45], [1595, 70, 70], [1596, 120, 90],
                    [1597, 70, 70], [1599, 120, 90], [1600, 120, 90], [1601, 70, 70], [1602, 120, 90], [1603, 40, 50],
                    [1605, 120, 90], [1606, 120, 90], [1607, 70, 70], [1608, 120, 90], [1609, 120, 90], [1610, 70, 70],
                    [1611, 120, 90], [1612, 120, 90], [1613, 120, 90], [1614, 70, 70], [1615, 120, 90], [1616, 120, 90],
                    [1617, 120, 90], [1619, 120, 90], [1620, 120, 90], [1621, 120, 90], [1622, 70, 70], [1623, 50, 60],
                    [1624, 35.02, 25.49], [1625, 70, 70], [1626, 70, 70], [1627, 70, 70], [1628, 50, 60],
                    [1629, 40, 50], [1630, 70, 70], [1631, 70, 70], [1633, 120, 90], [1634, 70, 70], [1635, 70, 70],
                    [1636, 120, 90], [1637, 120, 90], [1638, 70, 70], [1639, 70, 70], [1640, 70, 70], [1641, 70, 70],
                    [1642, 120, 90], [1644, 50, 60], [1645, 70, 70], [1647, 70, 70], [1648, 120, 90], [1649, 120, 90],
                    [1650, 70, 70], [1651, 120, 90], [1652, 70, 70], [1653, 120, 90], [1654, 70, 70], [1655, 120, 90],
                    [1657, 70, 70], [1658, 120, 90], [1659, 70, 70], [1660, 120, 90], [1661, 32.24, 21.39],
                    [1662, 70, 70], [1663, 70, 70], [1664, 70, 70], [1665, 50, 60], [1666, 6.17, 5.14], [1667, 120, 90],
                    [1668, 70, 70], [1669, 120, 90], [1670, 120, 90], [1671, 120, 90], [1672, 120, 90], [1673, 70, 70],
                    [1674, 70, 70], [1675, 11.86, 16.02], [1676, 70, 70], [1677, 70, 70], [1678, 120, 90],
                    [1679, 40, 50], [1680, 120, 90], [1681, 120, 90], [1682, 120, 90], [1683, 120, 90], [1684, 120, 90],
                    [1685, 50, 60], [1687, 120, 90], [1688, 30, 45], [1689, 120, 90], [1690, 120, 90], [1691, 120, 90],
                    [1692, 120, 90], [1693, 120, 90], [1694, 120, 90], [1695, 120, 90], [1696, 120, 90], [1697, 70, 70],
                    [1698, 120, 90], [1699, 70, 70], [1700, 120, 90], [1701, 120, 90], [1702, 70, 70], [1704, 50, 60],
                    [1705, 70, 70], [1706, 120, 90], [1707, 120, 90], [1708, 120, 90], [1709, 30, 45], [1710, 50, 60],
                    [1711, 70, 70], [1712, 120, 90], [1713, 50, 60], [1714, 120, 90], [1715, 120, 90], [1716, 70, 70],
                    [1717, 70, 70], [1719, 70, 70], [1720, 4.58, 3.57], [1721, 120, 90], [1722, 120, 90],
                    [1723, 70, 70], [1724, 120, 90], [1725, 70, 70], [1726, 120, 90], [1727, 120, 90], [1728, 120, 90],
                    [1730, 70, 70], [1732, 120, 90], [1735, 120, 90], [1736, 120, 90], [1737, 70, 70], [1738, 120, 90],
                    [1739, 32.24, 21.39], [1740, 50, 60], [1741, 70, 70], [1742, 120, 90], [1743, 120, 90],
                    [1744, 120, 90], [1746, 70, 70], [1748, 70, 70], [1749, 50, 60], [1750, 70, 70], [1752, 120, 90],
                    [1754, 120, 90], [1755, 50, 60], [1756, 120, 90], [1757, 120, 90], [1758, 32.24, 21.39],
                    [1759, 120, 90], [1760, 70, 70], [1762, 120, 90], [1763, 120, 90], [1764, 70, 70], [1765, 120, 90],
                    [1766, 120, 90], [1767, 120, 90], [1769, 70, 70], [1770, 70, 70], [1771, 120, 90], [1772, 40, 50],
                    [1773, 50, 60], [1774, 70, 70], [1775, 70, 70], [1776, 120, 90], [1777, 120, 90], [1778, 120, 90],
                    [1779, 70, 70], [1780, 70, 70], [1781, 120, 90], [1782, 120, 90], [1783, 120, 90], [1784, 70, 70],
                    [1785, 120, 90], [1786, 120, 90], [1787, 120, 90], [1788, 120, 90], [1789, 120, 90],
                    [1790, 120, 90], [1791, 120, 90], [1792, 120, 90], [1793, 70, 70], [1794, 70, 70],
                    [1795, 9.04, 6.4], [1796, 50, 60], [1797, 70, 70], [1798, 70, 70], [1801, 70, 70], [1802, 120, 90],
                    [1803, 120, 90], [1804, 120, 90], [1805, 50, 60], [1806, 120, 90], [1807, 70, 70], [1808, 70, 70],
                    [1809, 120, 90], [1810, 120, 90], [1811, 120, 90], [1812, 120, 90], [1813, 70, 70], [1814, 40, 50],
                    [1815, 17.45, 9.13], [1816, 120, 90], [1817, 70, 70], [1818, 120, 90], [1819, 120, 90],
                    [1820, 120, 90], [1821, 40, 50], [1822, 70, 70], [1823, 120, 90], [1824, 70, 70], [1825, 70, 70],
                    [1826, 120, 90], [1827, 70, 70], [1829, 120, 90], [1830, 50, 60], [1831, 50, 60], [1832, 70, 70],
                    [1833, 120, 90], [1834, 120, 90], [1837, 120, 90], [1839, 120, 90], [1840, 120, 90], [1841, 70, 70],
                    [1842, 120, 90], [1844, 30, 45], [1845, 40, 50], [1846, 120, 90], [1847, 50, 60], [1848, 70, 70],
                    [1849, 120, 90], [1850, 8.32, 6.64], [1851, 120, 90], [1852, 70, 70], [1853, 120, 90],
                    [1854, 120, 90], [1855, 120, 90], [1856, 30, 45], [1857, 70, 70], [1859, 120, 90], [1860, 120, 90],
                    [1861, 120, 90], [1863, 18.35, 13.66], [1864, 120, 90], [1865, 120, 90], [1866, 70, 70],
                    [1868, 35.02, 25.49], [1869, 40, 50], [1870, 32.24, 21.39], [1871, 120, 90], [1872, 50, 60],
                    [1873, 70, 70], [1874, 70, 70], [1875, 120, 90], [1876, 70, 70], [1877, 120, 90], [1878, 120, 90],
                    [1879, 120, 90], [1881, 50, 60], [1882, 70, 70], [1883, 120, 90], [1884, 50, 60], [1885, 70, 70],
                    [1886, 120, 90], [1887, 70, 70], [1888, 120, 90], [1889, 120, 90], [1890, 120, 90], [1891, 50, 60],
                    [1892, 70, 70], [1893, 120, 90], [1894, 50, 60], [1895, 70, 70], [1896, 120, 90],
                    [1898, 12.47, 7.24], [1899, 70, 70], [1900, 30, 45], [1901, 120, 90], [1902, 120, 90],
                    [1903, 70, 70], [1904, 120, 90], [1905, 120, 90], [1906, 20.9, 12.43], [1907, 70, 70],
                    [1909, 120, 90], [1910, 120, 90], [1911, 70, 70], [1912, 70, 70], [1913, 120, 90], [1914, 120, 90],
                    [1915, 120, 90], [1916, 120, 90], [1917, 120, 90], [1918, 120, 90], [1919, 120, 90], [1920, 70, 70],
                    [1921, 30, 45], [1922, 120, 90], [1923, 40, 50], [1924, 120, 90], [1925, 120, 90], [1926, 120, 90],
                    [1928, 120, 90], [1929, 6.5, 4.93], [1930, 10.76, 8.15], [1933, 70, 70], [1934, 120, 90],
                    [1935, 120, 90], [1936, 70, 70], [1937, 70, 70], [1938, 120, 90], [1939, 120, 90], [1940, 120, 90],
                    [1941, 120, 90], [1942, 120, 90], [1944, 120, 90], [1945, 120, 90], [1946, 70, 70], [1947, 120, 90],
                    [1948, 120, 90], [1949, 120, 90], [1950, 120, 90], [1951, 50, 60], [1952, 120, 90], [1953, 120, 90],
                    [1954, 120, 90], [1955, 70, 70], [1956, 40, 50], [1957, 70, 70], [1959, 120, 90], [1961, 120, 90],
                    [1962, 40, 50], [1963, 7.89, 5.56], [1964, 50, 60], [1965, 50, 60], [1966, 120, 90],
                    [1967, 32.24, 21.39], [1969, 70, 70], [1971, 120, 90], [1972, 11.39, 7.39], [1973, 70, 70],
                    [1974, 70, 70], [1975, 120, 90], [1976, 14.59, 10.01], [1977, 70, 70], [1978, 120, 90],
                    [1979, 50, 60], [1980, 120, 90], [1981, 70, 70], [1982, 70, 70], [1983, 120, 90], [1984, 120, 90],
                    [1985, 70, 70], [1986, 120, 90], [1987, 120, 90], [1988, 70, 70], [1989, 50, 60], [1990, 70, 70],
                    [1992, 50, 60], [1994, 120, 90], [1995, 70, 70], [1996, 120, 90], [1997, 70, 70],
                    [1998, 8.45, 8.42], [1999, 120, 90], [2000, 70, 70], [2001, 120, 90], [2002, 50, 60],
                    [2003, 120, 90], [2005, 50, 60], [2006, 70, 70], [2007, 120, 90], [2008, 70, 70], [2009, 120, 90],
                    [2010, 120, 90], [2011, 120, 90], [2012, 70, 70], [2014, 120, 90], [2015, 50, 60], [2016, 70, 70],
                    [2017, 40, 50], [2018, 120, 90], [2019, 120, 90], [2020, 32.24, 21.39], [2021, 120, 90],
                    [2022, 120, 90], [2023, 50, 60], [2024, 50, 60], [2025, 120, 90], [2026, 120, 90], [2027, 120, 90],
                    [2028, 120, 90], [2029, 50, 60], [2030, 50, 60], [2031, 6.44, 5.98], [2032, 120, 90],
                    [2033, 70, 70], [2034, 120, 90], [2035, 70, 70], [2036, 70, 70], [2037, 120, 90], [2038, 120, 90],
                    [2040, 120, 90], [2041, 120, 90], [2042, 120, 90], [2043, 70, 70], [2044, 120, 90], [2045, 120, 90],
                    [2046, 50, 60], [2048, 70, 70], [2049, 70, 70], [2050, 70, 70], [2051, 120, 90], [2052, 120, 90],
                    [2053, 70, 70], [2054, 40, 50], [2055, 70, 70], [2056, 50, 60], [2057, 120, 90],
                    [2059, 14.88, 8.19], [2060, 70, 70], [2061, 70, 70], [2062, 120, 90], [2063, 70, 70],
                    [2064, 70, 70], [2066, 120, 90], [2067, 70, 70], [2068, 70, 70], [2069, 120, 90], [2071, 120, 90],
                    [2072, 120, 90], [2073, 120, 90], [2074, 70, 70], [2075, 70, 70], [2076, 70, 70], [2077, 120, 90],
                    [2078, 50, 60], [2079, 120, 90], [2080, 120, 90], [2081, 120, 90], [2082, 120, 90], [2083, 120, 90],
                    [2084, 120, 90], [2086, 40, 50], [2087, 120, 90], [2089, 0, 0], [2090, 120, 90], [2091, 120, 90],
                    [2092, 120, 90], [2095, 120, 90], [2096, 120, 90], [2097, 50, 60], [2098, 40, 50], [2099, 120, 90],
                    [2100, 70, 70], [2101, 70, 70], [2102, 120, 90], [2103, 12.45, 12.74], [2104, 120, 90],
                    [2105, 120, 90], [2106, 50, 60], [2107, 70, 70], [2108, 120, 90], [2109, 120, 90], [2110, 40, 50],
                    [2111, 70, 70], [2112, 70, 70], [2113, 120, 90], [2114, 120, 90], [2115, 70, 70], [2116, 70, 70],
                    [2118, 120, 90], [2119, 16.05, 9.74], [2121, 120, 90], [2122, 120, 90], [2123, 70, 70],
                    [2124, 70, 70], [2125, 120, 90], [2126, 50, 60], [2127, 50, 60], [2128, 70, 70], [2129, 120, 90],
                    [2130, 120, 90], [2131, 120, 90], [2133, 70, 70], [2134, 120, 90], [2135, 50, 60], [2136, 120, 90],
                    [2137, 70, 70], [2138, 70, 70], [2139, 120, 90], [2140, 120, 90], [2141, 120, 90], [2142, 70, 70],
                    [2143, 120, 90], [2144, 120, 90], [2146, 70, 70], [2147, 120, 90], [2148, 70, 70], [2149, 120, 90],
                    [2150, 120, 90], [2152, 120, 90], [2154, 120, 90], [2155, 120, 90], [2156, 70, 70], [2157, 120, 90],
                    [2158, 50, 60], [2159, 120, 90], [2160, 120, 90], [2161, 70, 70], [2162, 120, 90], [2163, 120, 90],
                    [2164, 50, 60], [2165, 50, 60], [2166, 35.02, 25.49], [2169, 120, 90], [2170, 120, 90],
                    [2171, 120, 90], [2172, 120, 90], [2174, 70, 70], [2175, 120, 90], [2178, 70, 70], [2179, 50, 60],
                    [2180, 70, 70], [2181, 70, 70], [2182, 120, 90], [2183, 40, 50], [2184, 40, 50], [2185, 70, 70],
                    [2186, 120, 90], [2187, 120, 90], [2188, 120, 90], [2189, 70, 70], [2190, 70, 70], [2191, 120, 90],
                    [2192, 120, 90], [2193, 70, 70], [2194, 120, 90], [2195, 50, 60], [2196, 70, 70], [2197, 120, 90],
                    [2198, 40, 50], [2199, 120, 90], [2200, 70, 70], [2201, 120, 90], [2202, 120, 90],
                    [2203, 12.12, 8.84], [2204, 14.98, 8.4], [2205, 120, 90], [2206, 50, 60], [2207, 70, 70],
                    [2208, 120, 90], [2210, 120, 90], [2211, 50, 60], [2212, 70, 70], [2213, 50, 60], [2214, 20, 25],
                    [2215, 70, 70], [2216, 120, 90], [2217, 120, 90], [2219, 120, 90], [2220, 120, 90], [2221, 120, 90],
                    [2223, 40, 50], [2224, 70, 70], [2225, 40, 50], [2226, 120, 90], [2227, 50, 60], [2228, 50, 60],
                    [2229, 120, 90], [2230, 120, 90], [2231, 120, 90], [2232, 50, 60], [2234, 70, 70], [2235, 50, 60],
                    [2236, 120, 90], [2237, 120, 90], [2238, 70, 70], [2239, 120, 90], [2240, 120, 90],
                    [2241, 14.63, 9.52], [2242, 70, 70], [2243, 120, 90], [2244, 120, 90], [2245, 70, 70],
                    [2246, 50, 60], [2247, 120, 90], [2248, 40, 50], [2249, 120, 90], [2250, 50, 60], [2251, 120, 90],
                    [2252, 70, 70], [2253, 14.51, 10.23], [2254, 70, 70], [2255, 70, 70], [2256, 120, 90],
                    [2258, 50, 60], [2259, 15, 20], [2260, 70, 70], [2262, 120, 90], [2263, 70, 70], [2264, 120, 90],
                    [2265, 120, 90], [2267, 10.9, 7.43], [2268, 120, 90], [2269, 70, 70], [2270, 120, 90],
                    [2271, 9.23, 6.76], [2272, 50, 60], [2273, 70, 70], [2274, 70, 70], [2275, 120, 90],
                    [2276, 120, 90], [2277, 50, 60], [2278, 40, 50], [2279, 120, 90], [2280, 8.57, 5.83],
                    [2281, 120, 90], [2282, 70, 70], [2283, 120, 90], [2284, 70, 70], [2285, 40, 50], [2286, 70, 70],
                    [2288, 70, 70], [2289, 120, 90], [2290, 120, 90], [2291, 120, 90], [2292, 120, 90], [2293, 120, 90],
                    [2294, 50, 60], [2295, 120, 90], [2296, 70, 70], [2297, 120, 90], [2298, 120, 90], [2300, 50, 60],
                    [2301, 70, 70], [2302, 120, 90], [2303, 120, 90], [2304, 70, 70], [2305, 120, 90], [2306, 120, 90],
                    [2307, 70, 70], [2311, 70, 70], [2312, 120, 90], [2313, 40, 50], [2314, 120, 90], [2316, 120, 90],
                    [2317, 120, 90], [2319, 50, 60], [2321, 120, 90], [2323, 70, 70], [2324, 120, 90], [2325, 120, 90],
                    [2326, 120, 90], [2327, 120, 90], [2328, 120, 90], [2329, 70, 70], [2330, 120, 90], [2331, 40, 50],
                    [2332, 120, 90], [2333, 70, 70], [2335, 120, 90], [2336, 120, 90], [2337, 120, 90],
                    [2338, 32.24, 21.39], [2339, 120, 90], [2340, 120, 90], [2341, 70, 70], [2342, 70, 70],
                    [2343, 70, 70], [2344, 120, 90], [2345, 40, 50], [2346, 70, 70], [2347, 120, 90], [2348, 70, 70],
                    [2349, 70, 70], [2350, 120, 90], [2352, 50, 60], [2353, 120, 90], [2354, 40, 50], [2355, 120, 90],
                    [2356, 120, 90], [2357, 120, 90], [2358, 50, 60], [2359, 50, 60], [2360, 120, 90], [2361, 50, 60],
                    [2362, 70, 70], [2363, 70, 70], [2364, 32.24, 21.39], [2365, 120, 90], [2366, 50, 60],
                    [2367, 120, 90], [2368, 70, 70], [2369, 70, 70], [2371, 70, 70], [2372, 30, 45], [2373, 120, 90],
                    [2374, 14.36, 11.08], [2375, 120, 90], [2376, 120, 90], [2379, 120, 90], [2380, 30, 45],
                    [2381, 40, 50], [2382, 120, 90], [2383, 120, 90], [2384, 40, 50], [2385, 70, 70], [2387, 40, 50],
                    [2388, 120, 90], [2389, 70, 70], [2390, 120, 90], [2391, 70, 70], [2393, 70, 70], [2394, 120, 90],
                    [2395, 120, 90], [2396, 120, 90], [2397, 120, 90], [2398, 120, 90], [2399, 120, 90],
                    [2400, 120, 90], [2401, 9.42, 9.69], [2402, 70, 70], [2403, 120, 90], [2404, 120, 90],
                    [2405, 70, 70], [2406, 120, 90], [2407, 120, 90], [2408, 50, 60], [2409, 50, 60], [2410, 70, 70],
                    [2411, 9.59, 8.49], [2412, 6.63, 7.08], [2413, 120, 90], [2414, 8.64, 7.09], [2416, 120, 90],
                    [2417, 120, 90], [2418, 120, 90], [2420, 120, 90], [2421, 120, 90], [2422, 120, 90], [2423, 70, 70],
                    [2424, 120, 90], [2425, 70, 70], [2426, 120, 90], [2428, 120, 90], [2429, 70, 70], [2430, 120, 90],
                    [2431, 30, 45], [2432, 120, 90], [2433, 70, 70], [2434, 120, 90], [2435, 40, 50], [2436, 70, 70],
                    [2437, 16.17, 13.35], [2438, 120, 90], [2439, 70, 70], [2440, 5.64, 5.78], [2441, 120, 90],
                    [2442, 120, 90], [2443, 70, 70], [2444, 120, 90], [2445, 120, 90], [2447, 120, 90], [2448, 120, 90],
                    [2449, 35.02, 25.49], [2450, 120, 90], [2452, 120, 90], [2454, 120, 90], [2455, 70, 70],
                    [2456, 70, 70], [2458, 50, 60], [2459, 70, 70], [2460, 70, 70], [2461, 120, 90], [2462, 120, 90],
                    [2463, 120, 90], [2464, 120, 90], [2465, 120, 90], [2466, 120, 90], [2467, 70, 70], [2468, 40, 50],
                    [2469, 30, 45], [2470, 120, 90], [2471, 120, 90], [2472, 120, 90], [2473, 120, 90], [2474, 120, 90],
                    [2475, 70, 70], [2476, 120, 90], [2477, 70, 70], [2478, 120, 90], [2479, 120, 90], [2481, 50, 60],
                    [2482, 120, 90], [2483, 120, 90], [2484, 120, 90], [2485, 50, 60], [2486, 70, 70], [2487, 70, 70],
                    [2488, 70, 70], [2489, 30, 45], [2490, 70, 70], [2491, 120, 90], [2492, 50, 60], [2493, 120, 90],
                    [2494, 70, 70], [2495, 40, 50], [2496, 120, 90], [2497, 120, 90], [2498, 120, 90],
                    [2499, 17.64, 11.45], [2500, 40, 50], [2501, 70, 70], [2502, 50, 60], [2504, 120, 90],
                    [2505, 70, 70], [2506, 120, 90], [2507, 120, 90], [2508, 70, 70], [2509, 70, 70], [2510, 70, 70],
                    [2511, 35.02, 25.49], [2512, 120, 90], [2513, 120, 90], [2515, 50, 60], [2516, 120, 90],
                    [2517, 120, 90], [2518, 120, 90], [2519, 35.02, 25.49], [2520, 70, 70], [2521, 50, 60],
                    [2522, 120, 90], [2523, 120, 90], [2524, 50, 60], [2525, 70, 70], [2526, 120, 90], [2527, 120, 90],
                    [2528, 120, 90], [2529, 70, 70], [2530, 70, 70], [2531, 70, 70], [2532, 70, 70], [2533, 70, 70],
                    [2534, 120, 90], [2535, 5.8, 6.5], [2537, 120, 90], [2538, 120, 90], [2539, 70, 70],
                    [2540, 120, 90], [2541, 70, 70], [2543, 40, 50], [2544, 120, 90], [2545, 120, 90], [2546, 120, 90],
                    [2547, 70, 70], [2548, 70, 70], [2549, 70, 70], [2550, 120, 90], [2551, 120, 90], [2552, 120, 90],
                    [2553, 70, 70], [2554, 70, 70], [2555, 70, 70], [2556, 120, 90], [2558, 40, 50], [2560, 120, 90],
                    [2561, 120, 90], [2562, 120, 90], [2563, 70, 70], [2564, 120, 90], [2565, 40, 50], [2567, 120, 90],
                    [2568, 50, 60], [2569, 50, 60], [2570, 120, 90], [2571, 50, 60], [2572, 120, 90], [2573, 120, 90],
                    [2574, 120, 90], [2575, 70, 70], [2576, 70, 70], [2578, 70, 70], [2579, 120, 90], [2580, 120, 90],
                    [2581, 120, 90], [2582, 70, 70], [2584, 120, 90], [2585, 70, 70], [2586, 120, 90], [2587, 120, 90],
                    [2588, 70, 70], [2589, 70, 70], [2590, 120, 90], [2591, 120, 90], [2592, 120, 90], [2593, 120, 90],
                    [2594, 40, 50], [2595, 70, 70], [2596, 120, 90], [2597, 40, 50], [2598, 70, 70], [2599, 40, 50],
                    [2600, 50, 60], [2601, 70, 70], [2602, 120, 90], [2603, 120, 90], [2604, 70, 70], [2606, 70, 70],
                    [2607, 120, 90], [2608, 70, 70], [2609, 120, 90], [2610, 70, 70], [2612, 30, 45],
                    [2613, 35.02, 25.49], [2614, 120, 90], [2615, 120, 90], [2616, 120, 90], [2617, 120, 90],
                    [2618, 120, 90], [2619, 120, 90], [2620, 50, 60], [2621, 120, 90], [2622, 120, 90], [2623, 70, 70],
                    [2624, 35.02, 25.49], [2625, 120, 90], [2626, 30, 45], [2627, 70, 70], [2628, 120, 90],
                    [2629, 120, 90], [2630, 70, 70], [2631, 70, 70], [2632, 120, 90], [2633, 120, 90], [2634, 120, 90],
                    [2635, 70, 70], [2636, 70, 70], [2637, 120, 90], [2638, 70, 70], [2642, 120, 90], [2644, 120, 90],
                    [2645, 120, 90], [2646, 30, 45], [2647, 120, 90], [2649, 50, 60], [2650, 120, 90], [2651, 40, 50],
                    [2652, 50, 60], [2653, 70, 70], [2654, 70, 70], [2655, 120, 90], [2656, 120, 90], [2657, 120, 90],
                    [2658, 70, 70], [2659, 70, 70], [2660, 40, 50], [2661, 70, 70], [2662, 120, 90], [2663, 50, 60],
                    [2664, 120, 90], [2665, 70, 70], [2666, 120, 90], [2667, 120, 90], [2668, 120, 90], [2669, 120, 90],
                    [2670, 70, 70], [2671, 50, 60], [2672, 70, 70], [2673, 120, 90], [2675, 120, 90], [2676, 70, 70],
                    [2677, 70, 70], [2678, 70, 70], [2679, 120, 90], [2680, 120, 90], [2681, 70, 70], [2682, 120, 90],
                    [2683, 11.9, 7.65], [2684, 70, 70], [2685, 120, 90], [2687, 120, 90], [2688, 70, 70],
                    [2690, 120, 90], [2691, 70, 70], [2692, 70, 70], [2693, 120, 90], [2694, 35.02, 25.49],
                    [2695, 70, 70], [2696, 32.24, 21.39], [2697, 120, 90], [2698, 70, 70], [2699, 40, 50],
                    [2702, 120, 90], [2703, 70, 70], [2706, 120, 90], [2707, 70, 70], [2709, 120, 90], [2711, 50, 60],
                    [2712, 70, 70], [2713, 70, 70], [2714, 50, 60], [2715, 120, 90], [2716, 70, 70], [2717, 120, 90],
                    [2718, 120, 90], [2719, 70, 70], [2720, 120, 90], [2721, 70, 70], [2722, 120, 90], [2723, 70, 70],
                    [2724, 70, 70], [2725, 120, 90], [2726, 70, 70], [2727, 120, 90], [2728, 35.02, 25.49],
                    [2730, 50, 60], [2731, 120, 90], [2732, 70, 70], [2733, 120, 90], [2734, 50, 60], [2736, 30, 45],
                    [2737, 40, 50], [2738, 40, 50], [2739, 50, 60], [2740, 120, 90], [2741, 120, 90], [2742, 70, 70],
                    [2743, 70, 70], [2745, 70, 70], [2746, 32.24, 21.39], [2747, 120, 90], [2748, 120, 90],
                    [2749, 120, 90], [2750, 30, 45], [2751, 120, 90], [2752, 70, 70], [2753, 50, 60], [2754, 70, 70],
                    [2755, 120, 90], [2756, 70, 70], [2757, 120, 90], [2758, 70, 70], [2759, 120, 90], [2760, 120, 90],
                    [2761, 120, 90], [2762, 120, 90], [2763, 120, 90], [2764, 120, 90], [2765, 120, 90],
                    [2766, 5.69, 6.72], [2767, 120, 90], [2768, 120, 90], [2769, 120, 90], [2770, 120, 90],
                    [2772, 70, 70], [2773, 50, 60], [2774, 120, 90], [2775, 70, 70], [2776, 120, 90], [2777, 120, 90],
                    [2778, 70, 70], [2779, 120, 90], [2780, 70, 70], [2782, 50, 60], [2783, 70, 70], [2784, 70, 70],
                    [2785, 40, 50], [2786, 70, 70], [2787, 120, 90], [2788, 120, 90], [2789, 30, 45], [2790, 70, 70],
                    [2791, 40, 50], [2792, 120, 90], [2793, 40, 50], [2794, 70, 70], [2795, 32.24, 21.39],
                    [2796, 70, 70], [2797, 120, 90], [2798, 70, 70], [2799, 50, 60], [2800, 70, 70], [2801, 120, 90],
                    [2802, 70, 70], [2803, 120, 90], [2804, 20.57, 14.3], [2805, 120, 90], [2806, 70, 70],
                    [2808, 50, 60], [2809, 120, 90], [2810, 50, 60], [2811, 50, 60], [2812, 120, 90], [2813, 70, 70],
                    [2814, 120, 90], [2818, 30, 45], [2819, 11.84, 8.58], [2820, 120, 90], [2821, 70, 70],
                    [2822, 50, 60], [2823, 70, 70], [2824, 120, 90], [2825, 120, 90], [2826, 40, 50], [2827, 50, 60],
                    [2829, 40, 50], [2830, 70, 70], [2831, 120, 90], [2832, 70, 70], [2833, 120, 90], [2834, 50, 60],
                    [2835, 50, 60], [2836, 70, 70], [2837, 120, 90], [2838, 120, 90], [2839, 120, 90], [2840, 70, 70],
                    [2841, 120, 90], [2842, 120, 90], [2843, 120, 90], [2844, 70, 70], [2845, 120, 90], [2846, 120, 90],
                    [2847, 30, 45], [2850, 20.67, 13.88], [2851, 120, 90], [2852, 50, 60], [2853, 70, 70],
                    [2854, 120, 90], [2855, 50, 60], [2856, 70, 70], [2857, 35.02, 25.49], [2858, 120, 90],
                    [2860, 120, 90], [2861, 70, 70], [2862, 70, 70], [2863, 70, 70], [2864, 120, 90], [2865, 120, 90],
                    [2866, 50, 60], [2868, 70, 70], [2869, 5.93, 4.86], [2871, 120, 90], [2872, 70, 70],
                    [2873, 120, 90], [2874, 120, 90], [2875, 120, 90], [2876, 120, 90], [2877, 120, 90],
                    [2878, 120, 90], [2879, 50, 60], [2880, 70, 70], [2881, 70, 70], [2882, 120, 90], [2883, 70, 70],
                    [2884, 120, 90], [2885, 70, 70], [2886, 70, 70], [2887, 120, 90], [2888, 120, 90], [2889, 120, 90],
                    [2890, 70, 70], [2891, 120, 90], [2892, 120, 90], [2893, 120, 90], [2894, 120, 90], [2896, 30, 45],
                    [2897, 120, 90], [2898, 70, 70], [2899, 70, 70], [2900, 20.67, 13.88], [2901, 120, 90],
                    [2902, 120, 90], [2903, 120, 90], [2904, 120, 90], [2905, 50, 60], [2906, 70, 70],
                    [2907, 16.83, 17.5], [2908, 50, 60], [2909, 70, 70], [2910, 120, 90], [2911, 120, 90],
                    [2912, 50, 60], [2913, 70, 70], [2914, 120, 90], [2916, 120, 90], [2917, 20.67, 13.88],
                    [2918, 120, 90], [2919, 70, 70], [2920, 120, 90], [2921, 120, 90], [2922, 50, 60], [2923, 70, 70],
                    [2924, 120, 90], [2925, 120, 90], [2926, 120, 90], [2927, 120, 90], [2928, 120, 90], [2929, 70, 70],
                    [2930, 120, 90], [2931, 120, 90], [2932, 120, 90], [2933, 70, 70], [2934, 70, 70], [2935, 120, 90],
                    [2936, 120, 90], [2937, 120, 90], [2939, 50, 60], [2940, 120, 90], [2942, 70, 70], [2943, 120, 90],
                    [2944, 70, 70], [2945, 70, 70], [2946, 120, 90], [2947, 70, 70], [2948, 50, 60], [2949, 50, 60],
                    [2950, 70, 70], [2951, 120, 90], [2952, 120, 90], [2953, 120, 90], [2954, 70, 70], [2955, 120, 90],
                    [2956, 70, 70], [2957, 70, 70], [2958, 70, 70], [2959, 70, 70], [2960, 50, 60], [2961, 70, 70],
                    [2962, 40, 50], [2963, 120, 90], [2964, 50, 60], [2965, 120, 90], [2967, 40, 50], [2968, 120, 90],
                    [2969, 120, 90], [2970, 120, 90], [2971, 70, 70], [2972, 120, 90], [2973, 120, 90], [2974, 120, 90],
                    [2975, 70, 70], [2976, 120, 90], [2978, 120, 90], [2979, 70, 70], [2980, 120, 90], [2981, 120, 90],
                    [2982, 120, 90], [2984, 15.43, 13.81], [2985, 50, 60], [2986, 35.02, 25.49], [2987, 120, 90],
                    [2988, 120, 90], [2989, 50, 60], [2990, 50, 60], [2991, 50, 60], [2992, 120, 90], [2993, 120, 90],
                    [2994, 120, 90], [2995, 120, 90], [2996, 120, 90], [2998, 70, 70], [3000, 50, 60], [3001, 70, 70],
                    [3002, 120, 90], [3003, 120, 90], [3004, 120, 90], [3005, 50, 60], [3006, 120, 90], [3007, 120, 90],
                    [3008, 70, 70], [3009, 50, 60], [3010, 40, 50], [3011, 70, 70], [3012, 120, 90], [3013, 40, 50],
                    [3014, 120, 90], [3015, 40, 50], [3016, 50, 60], [3017, 120, 90], [3018, 70, 70], [3019, 50, 60],
                    [3021, 120, 90], [3022, 120, 90], [3023, 120, 90], [3024, 70, 70], [3025, 120, 90], [3027, 120, 90],
                    [3028, 50, 60], [3029, 70, 70], [3030, 120, 90], [3031, 20.67, 13.88], [3032, 120, 90],
                    [3033, 120, 90], [3034, 120, 90], [3035, 70, 70], [3036, 120, 90], [3037, 70, 70], [3039, 120, 90],
                    [3040, 120, 90], [3041, 70, 70], [3042, 10.27, 8.48], [3043, 70, 70], [3044, 120, 90],
                    [3045, 120, 90], [3046, 120, 90], [3047, 120, 90], [3048, 120, 90], [3049, 120, 90],
                    [3050, 120, 90], [3051, 120, 90], [3052, 70, 70], [3053, 70, 70], [3054, 120, 90], [3055, 120, 90],
                    [3057, 70, 70], [3058, 70, 70], [3059, 120, 90], [3060, 70, 70], [3061, 120, 90], [3062, 120, 90],
                    [3063, 70, 70], [3064, 70, 70], [3065, 120, 90], [3066, 50, 60], [3069, 35.02, 25.49],
                    [3070, 120, 90], [3071, 70, 70], [3072, 120, 90], [3073, 120, 90], [3074, 120, 90], [3076, 120, 90],
                    [3077, 120, 90], [3078, 120, 90], [3079, 70, 70], [3081, 120, 90], [3083, 70, 70], [3084, 70, 70],
                    [3085, 70, 70], [3086, 70, 70], [3087, 70, 70], [3088, 70, 70], [3090, 50, 60], [3091, 40, 50],
                    [3092, 70, 70], [3094, 120, 90], [3095, 120, 90], [3096, 70, 70], [3097, 120, 90], [3098, 120, 90],
                    [3100, 120, 90], [3101, 120, 90], [3102, 120, 90], [3103, 70, 70], [3104, 7.73, 6.59],
                    [3105, 120, 90], [3106, 70, 70], [3107, 120, 90], [3108, 120, 90], [3109, 120, 90], [3110, 120, 90],
                    [3111, 70, 70], [3112, 70, 70], [3113, 120, 90], [3115, 120, 90], [3116, 120, 90], [3117, 70, 70],
                    [3118, 120, 90], [3119, 40, 50], [3120, 70, 70], [3121, 120, 90], [3122, 120, 90], [3124, 120, 90],
                    [3125, 120, 90], [3126, 70, 70], [3127, 9.37, 9.65], [3128, 120, 90], [3129, 120, 90],
                    [3130, 40, 50], [3131, 8.89, 9.07], [3132, 120, 90], [3133, 120, 90], [3134, 50, 60],
                    [3135, 120, 90], [3136, 40, 50], [3137, 70, 70], [3138, 120, 90], [3139, 10.29, 7.91],
                    [3140, 120, 90], [3141, 120, 90], [3142, 40, 50], [3143, 70, 70], [3144, 120, 90], [3145, 120, 90],
                    [3148, 120, 90], [3149, 120, 90], [3150, 70, 70], [3151, 120, 90], [3152, 120, 90], [3153, 70, 70],
                    [3154, 120, 90], [3155, 120, 90], [3156, 120, 90], [3157, 120, 90], [3158, 120, 90],
                    [3159, 120, 90], [3160, 120, 90], [3161, 70, 70], [3162, 120, 90], [3163, 120, 90], [3164, 70, 70],
                    [3166, 15, 20], [3167, 70, 70], [3168, 120, 90], [3169, 70, 70], [3170, 120, 90], [3171, 50, 60],
                    [3172, 120, 90], [3175, 120, 90], [3176, 120, 90], [3177, 50, 60], [3178, 120, 90], [3179, 120, 90],
                    [3182, 50, 60], [3183, 40, 50], [3184, 70, 70], [3186, 40, 50], [3187, 120, 90], [3188, 120, 90],
                    [3189, 70, 70], [3190, 40, 50], [3191, 70, 70], [3192, 120, 90], [3193, 50, 60], [3194, 70, 70],
                    [3195, 120, 90], [3196, 70, 70], [3197, 70, 70], [3198, 50, 60], [3199, 70, 70], [3200, 40, 50],
                    [3201, 120, 90], [3202, 50, 60], [3203, 12.22, 11.28], [3206, 70, 70], [3207, 70, 70],
                    [3208, 120, 90], [3210, 30, 45], [3211, 50, 60], [3212, 120, 90], [3213, 70, 70], [3214, 120, 90],
                    [3215, 70, 70], [3216, 120, 90], [3217, 120, 90], [3218, 50, 60], [3219, 10.87, 12.56],
                    [3220, 120, 90], [3221, 70, 70], [3222, 70, 70], [3224, 120, 90], [3225, 8.05, 7.89],
                    [3226, 50, 60], [3227, 70, 70], [3228, 40, 50], [3229, 35.02, 25.49], [3230, 50, 60],
                    [3231, 120, 90], [3232, 70, 70], [3234, 70, 70], [3235, 120, 90], [3237, 120, 90], [3238, 120, 90],
                    [3239, 120, 90], [3240, 120, 90], [3241, 40, 50], [3242, 120, 90], [3243, 12.14, 9.5],
                    [3244, 120, 90], [3245, 120, 90], [3246, 120, 90], [3247, 120, 90], [3248, 50, 60], [3249, 120, 90],
                    [3250, 70, 70], [3251, 40, 50], [3252, 50, 60], [3253, 70, 70], [3254, 50, 60], [3255, 70, 70],
                    [3256, 120, 90], [3257, 50, 60], [3258, 70, 70], [3259, 50, 60], [3260, 20, 25], [3261, 120, 90],
                    [3262, 70, 70], [3263, 120, 90], [3264, 40, 50], [3265, 120, 90], [3266, 70, 70], [3267, 50, 60],
                    [3268, 120, 90], [3269, 120, 90], [3271, 35.02, 25.49], [3272, 120, 90], [3273, 120, 90],
                    [3274, 50, 60], [3275, 120, 90], [3276, 35.02, 25.49], [3277, 120, 90], [3278, 70, 70],
                    [3279, 32.24, 21.39], [3280, 120, 90], [3281, 120, 90], [3282, 120, 90], [3284, 120, 90],
                    [3285, 120, 90], [3286, 15.7, 9.65], [3287, 50, 60], [3288, 50, 60], [3289, 120, 90],
                    [3290, 70, 70], [3291, 120, 90], [3292, 120, 90], [3293, 70, 70], [3294, 20.67, 13.88],
                    [3295, 120, 90], [3296, 30, 45], [3297, 120, 90], [3299, 40, 50], [3300, 70, 70], [3301, 70, 70],
                    [3302, 70, 70], [3303, 120, 90], [3305, 120, 90], [3306, 70, 70], [3308, 70, 70], [3309, 50, 60],
                    [3310, 50, 60], [3311, 70, 70], [3312, 70, 70], [3313, 120, 90], [3314, 50, 60], [3315, 120, 90],
                    [3316, 120, 90], [3317, 120, 90], [3318, 70, 70], [3319, 70, 70], [3320, 120, 90], [3321, 50, 60],
                    [3322, 120, 90], [3323, 120, 90], [3324, 70, 70], [3325, 40, 50], [3326, 120, 90], [3327, 120, 90],
                    [3328, 120, 90], [3329, 8.87, 8.14], [3330, 120, 90], [3331, 120, 90], [3332, 120, 90],
                    [3333, 120, 90], [3335, 70, 70], [3336, 120, 90], [3337, 120, 90], [3338, 70, 70], [3339, 70, 70],
                    [3340, 70, 70], [3341, 24.19, 14.72], [3342, 32.24, 21.39], [3343, 120, 90], [3344, 120, 90],
                    [3345, 70, 70], [3346, 120, 90], [3347, 120, 90], [3348, 70, 70], [3350, 35.02, 25.49],
                    [3351, 35.02, 25.49], [3352, 120, 90], [3353, 120, 90], [3354, 50, 60], [3356, 120, 90],
                    [3357, 120, 90], [3358, 120, 90], [3359, 120, 90], [3360, 50, 60], [3361, 120, 90], [3362, 120, 90],
                    [3363, 120, 90], [3364, 70, 70], [3365, 70, 70], [3366, 120, 90], [3367, 50, 60], [3368, 120, 90],
                    [3369, 120, 90], [3370, 70, 70], [3371, 70, 70], [3372, 70, 70], [3373, 30, 45], [3375, 120, 90],
                    [3376, 35.02, 25.49], [3377, 70, 70], [3378, 9.02, 8.54], [3379, 120, 90], [3380, 120, 90],
                    [3381, 120, 90], [3382, 70, 70], [3384, 120, 90], [3385, 70, 70], [3386, 120, 90], [3387, 70, 70],
                    [3388, 120, 90], [3389, 70, 70], [3390, 120, 90], [3391, 120, 90], [3392, 120, 90], [3393, 120, 90],
                    [3394, 120, 90], [3397, 70, 70], [3398, 120, 90], [3399, 70, 70], [3400, 40, 50], [3401, 30, 45],
                    [3402, 120, 90], [3404, 120, 90], [3407, 120, 90], [3408, 35.02, 25.49], [3409, 120, 90],
                    [3410, 50, 60], [3411, 70, 70], [3412, 50, 60], [3414, 50, 60], [3415, 40, 50], [3416, 40, 50],
                    [3417, 70, 70], [3418, 120, 90], [3419, 70, 70], [3420, 70, 70], [3422, 120, 90], [3423, 120, 90],
                    [3424, 50, 60], [3425, 70, 70], [3426, 120, 90], [3427, 70, 70], [3428, 70, 70], [3429, 120, 90],
                    [3430, 120, 90], [3431, 120, 90], [3432, 120, 90], [3433, 70, 70], [3434, 6.86, 5.46],
                    [3435, 120, 90], [3436, 120, 90], [3437, 70, 70], [3439, 70, 70], [3440, 120, 90], [3441, 120, 90],
                    [3442, 120, 90], [3444, 30, 45], [3445, 70, 70], [3446, 70, 70], [3447, 120, 90],
                    [3448, 5.56, 6.38], [3449, 70, 70], [3450, 120, 90], [3451, 120, 90], [3452, 120, 90],
                    [3453, 120, 90], [3454, 40, 50], [3456, 120, 90], [3458, 120, 90], [3459, 120, 90], [3460, 120, 90],
                    [3461, 70, 70], [3462, 70, 24.96], [3463, 120, 90], [3464, 120, 90], [3466, 120, 90],
                    [3467, 70, 70], [3468, 120, 90], [3469, 120, 90], [3470, 120, 90], [3471, 70, 70], [3472, 120, 90],
                    [3473, 22.49, 13.06], [3474, 70, 70], [3475, 50, 60], [3476, 40, 50], [3477, 120, 90],
                    [3478, 120, 90], [3480, 120, 90], [3481, 70, 70], [3482, 32.24, 21.39], [3483, 70, 70],
                    [3484, 120, 90], [3485, 50, 60], [3486, 70, 70], [3487, 20.67, 13.88], [3488, 50, 60],
                    [3489, 50, 60], [3490, 120, 90], [3491, 120, 90], [3492, 120, 90], [3493, 70, 70], [3494, 40, 50],
                    [3495, 120, 90], [3496, 120, 90], [3497, 120, 90], [3498, 40, 50], [3499, 120, 90], [3500, 120, 90],
                    [3501, 120, 90], [3503, 120, 90], [3504, 70, 70], [3505, 120, 90], [3506, 120, 90], [3508, 120, 90],
                    [3509, 50, 60], [3510, 120, 90], [3511, 70, 70], [3514, 50, 60], [3515, 70, 70], [3516, 120, 90],
                    [3517, 70, 70], [3518, 120, 90], [3519, 50, 60], [3520, 120, 90], [3521, 120, 90], [3522, 70, 70],
                    [3523, 35.02, 25.49], [3524, 70, 70], [3525, 120, 90], [3527, 120, 90], [3528, 70, 70],
                    [3529, 70, 70], [3530, 70, 70], [3531, 120, 90], [3533, 70, 70], [3534, 50, 60], [3535, 30, 45],
                    [3536, 70, 70], [3537, 120, 90], [3538, 70, 70], [3539, 120, 90], [3540, 120, 90], [3541, 120, 90],
                    [3542, 70, 70], [3543, 120, 90], [3544, 120, 90], [3545, 120, 90], [3546, 35.02, 25.49],
                    [3547, 120, 90], [3548, 120, 90], [3549, 30, 45], [3550, 50, 60], [3551, 120, 90], [3552, 40, 50],
                    [3553, 70, 70], [3554, 50, 60], [3555, 40, 50], [3557, 50, 60], [3558, 70, 70], [3559, 50, 60],
                    [3560, 120, 90], [3561, 120, 90], [3562, 120, 90], [3563, 120, 90], [3564, 120, 90],
                    [3566, 120, 90], [3568, 12.22, 9.98], [3569, 50, 60], [3570, 70, 70], [3571, 70, 70],
                    [3572, 120, 90], [3573, 120, 90], [3575, 120, 90], [3576, 120, 90], [3577, 120, 90], [3578, 70, 70],
                    [3579, 40, 50], [3580, 70, 70], [3581, 120, 90], [3583, 120, 90], [3584, 70, 70], [3585, 70, 70],
                    [3586, 70, 70], [3587, 70, 70], [3588, 120, 90], [3589, 70, 70], [3590, 40, 50], [3592, 70, 70],
                    [3593, 70, 70], [3594, 120, 90], [3595, 120, 90], [3596, 35.02, 25.49], [3597, 70, 70],
                    [3598, 120, 90], [3599, 120, 90], [3600, 70, 70], [3601, 40, 50], [3602, 120, 90], [3603, 30, 45],
                    [3604, 120, 90], [3606, 40, 50], [3607, 70, 70], [3608, 120, 90], [3609, 120, 90], [3610, 50, 60],
                    [3611, 70, 70], [3612, 70, 70], [3613, 40, 50], [3615, 70, 70], [3616, 70, 70], [3617, 120, 90],
                    [3619, 70, 70], [3620, 50, 60], [3621, 50, 60], [3622, 120, 90], [3623, 120, 90], [3625, 120, 90],
                    [3626, 120, 90], [3627, 120, 90], [3628, 30, 45], [3629, 32.24, 21.39], [3630, 50, 60],
                    [3631, 70, 70], [3632, 120, 90], [3633, 70, 70], [3635, 50, 60], [3636, 70, 70], [3637, 40, 50],
                    [3638, 120, 90], [3639, 120, 90], [3640, 120, 90], [3641, 40, 50], [3642, 70, 70], [3643, 70, 70],
                    [3644, 70, 70], [3646, 70, 70], [3647, 120, 90], [3648, 70, 70], [3649, 120, 90], [3650, 120, 90],
                    [3651, 40, 50], [3652, 40, 50], [3653, 120, 90], [3654, 120, 90], [3655, 120, 90], [3656, 70, 70],
                    [3657, 120, 90], [3658, 120, 90], [3659, 120, 90], [3660, 120, 90], [3661, 120, 90], [3662, 30, 45],
                    [3663, 120, 90], [3664, 120, 90], [3665, 120, 90], [3666, 35.02, 25.49], [3667, 120, 90],
                    [3668, 120, 90], [3669, 50, 60], [3670, 70, 70], [3671, 120, 90], [3672, 40, 50], [3673, 120, 90],
                    [3674, 70, 70], [3675, 120, 90], [3676, 120, 90], [3677, 50, 60], [3678, 6.48, 4.68],
                    [3679, 50, 60], [3680, 120, 90], [3681, 70, 70], [3682, 120, 90], [3683, 70, 70], [3684, 120, 90],
                    [3685, 120, 90], [3686, 35.02, 25.49], [3687, 70, 70], [3688, 120, 90], [3689, 120, 90],
                    [3690, 120, 90], [3691, 14.78, 14.29], [3692, 50, 60], [3693, 120, 90], [3694, 70, 70],
                    [3695, 35.02, 25.49], [3696, 70, 70], [3697, 50, 60], [3698, 120, 90], [3699, 120, 90],
                    [3700, 50, 60], [3701, 40, 50], [3702, 18.29, 11.85], [3703, 120, 90], [3704, 70, 70],
                    [3705, 14.08, 13.22], [3706, 120, 90], [3707, 70, 70], [3708, 70, 70], [3710, 50, 60],
                    [3712, 120, 90], [3713, 70, 70], [3714, 120, 90], [3715, 120, 90], [3716, 120, 90], [3718, 70, 70],
                    [3719, 35.02, 25.49], [3720, 50, 60], [3721, 120, 90], [3722, 40, 50], [3723, 40, 50],
                    [3725, 70, 70], [3726, 70, 70], [3727, 50, 60], [3728, 120, 90], [3729, 120, 90], [3730, 30, 45],
                    [3731, 120, 90], [3733, 120, 90], [3736, 120, 90], [3737, 70, 70], [3738, 30, 45], [3739, 70, 70],
                    [3741, 120, 90], [3742, 120, 90], [3743, 30, 45], [3744, 120, 90], [3745, 120, 90], [3746, 120, 90],
                    [3747, 120, 90], [3748, 120, 90], [3749, 35.02, 25.49], [3750, 120, 90], [3751, 120, 90],
                    [3752, 120, 90], [3753, 50, 60], [3754, 120, 90], [3755, 50, 60], [3756, 120, 90], [3757, 70, 70],
                    [3758, 50, 60], [3759, 70, 70], [3760, 40, 50], [3761, 120, 90], [3762, 50, 60], [3763, 70, 70],
                    [3764, 50, 60], [3765, 70, 70], [3766, 50, 60], [3767, 50, 60], [3768, 70, 70], [3769, 120, 90],
                    [3770, 30, 45], [3772, 120, 90], [3773, 70, 70], [3775, 50, 60], [3776, 120, 90], [3777, 120, 90],
                    [3778, 30, 45], [3779, 120, 90], [3780, 70, 70], [3781, 120, 90], [3782, 120, 90], [3783, 70, 70],
                    [3785, 35.02, 25.49], [3786, 50, 60], [3787, 70, 70], [3789, 70, 70], [3791, 120, 90],
                    [3793, 70, 70], [3794, 30, 45], [3795, 120, 90], [3796, 120, 90], [3797, 70, 70], [3798, 120, 90],
                    [3799, 50, 60], [3800, 70, 70], [3801, 120, 90], [3802, 40, 50], [3804, 70, 70], [3806, 120, 90],
                    [3807, 120, 90], [3809, 120, 90], [3810, 30, 45], [3811, 120, 90], [3812, 120, 90], [3813, 120, 90],
                    [3814, 70, 70], [3816, 120, 90], [3817, 70, 70], [3818, 40, 50], [3819, 120, 90], [3820, 50, 60],
                    [3821, 120, 90], [3822, 120, 90], [3824, 120, 90], [3825, 120, 90], [3826, 70, 70], [3827, 120, 90],
                    [3828, 120, 90], [3829, 70, 70], [3831, 120, 90], [3832, 120, 90], [3833, 30, 45], [3834, 120, 90],
                    [3835, 70, 70], [3836, 50, 60], [3837, 70, 70], [3838, 120, 90], [3839, 120, 90], [3840, 120, 90],
                    [3841, 120, 90], [3842, 50, 60], [3843, 120, 90], [3844, 120, 90], [3845, 40, 50], [3846, 70, 70],
                    [3847, 50, 60], [3849, 32.24, 21.39], [3850, 120, 90], [3851, 120, 90], [3852, 120, 90],
                    [3853, 35.02, 25.49], [3854, 120, 90], [3855, 120, 90], [3856, 120, 90], [3857, 70, 70],
                    [3858, 120, 90], [3859, 70, 70], [3862, 70, 70], [3863, 50, 60], [3864, 70, 70], [3865, 120, 90],
                    [3867, 35.02, 25.49], [3868, 120, 90], [3869, 40, 50], [3870, 120, 90], [3871, 70, 70],
                    [3872, 120, 90], [3873, 120, 90], [3874, 120, 90], [3875, 70, 70], [3877, 70, 70], [3878, 70, 70],
                    [3879, 70, 70], [3881, 120, 90], [3882, 120, 90], [3883, 120, 90], [3884, 70, 70], [3885, 70, 70],
                    [3886, 120, 90], [3887, 120, 90], [3888, 120, 90], [3889, 70, 70], [3891, 70, 70], [3892, 120, 90],
                    [3893, 70, 70], [3894, 120, 90], [3895, 120, 90], [3896, 70, 70], [3897, 120, 90], [3898, 120, 90],
                    [3899, 120, 90], [3900, 120, 90], [3901, 120, 90], [3902, 120, 90], [3903, 70, 70], [3905, 120, 90],
                    [3906, 70, 70], [3907, 120, 90], [3908, 120, 90], [3909, 120, 90], [3910, 32.24, 21.39],
                    [3912, 70, 70], [3913, 120, 90], [3914, 70, 70], [3915, 30, 45], [3916, 120, 90], [3917, 70, 70],
                    [3918, 8.88, 7.78], [3919, 120, 90], [3920, 70, 70], [3921, 120, 90], [3922, 120, 90],
                    [3923, 70, 70], [3925, 120, 90], [3926, 120, 90], [3927, 70, 70], [3929, 120, 90], [3930, 70, 70],
                    [3931, 120, 90], [3932, 70, 70], [3933, 120, 90], [3934, 120, 90], [3935, 120, 90], [3936, 120, 90],
                    [3937, 70, 70], [3938, 40, 50], [3939, 120, 90], [3940, 50, 60], [3941, 120, 90], [3942, 120, 90],
                    [3943, 70, 70], [3944, 35.02, 25.49], [3945, 120, 90], [3946, 13.42, 11.21], [3947, 120, 90],
                    [3948, 30, 45], [3949, 120, 90], [3950, 120, 90], [3951, 120, 90], [3952, 120, 90], [3953, 120, 90],
                    [3954, 120, 90], [3955, 120, 90], [3956, 50, 60], [3958, 13.07, 12.08], [3959, 120, 90],
                    [3960, 50, 60], [3961, 10.48, 9.83], [3962, 120, 90], [3963, 50, 60], [3964, 120, 90],
                    [3965, 70, 70], [3966, 70, 70], [3968, 40, 50], [3969, 70, 70], [3970, 120, 90], [3971, 120, 90],
                    [3972, 120, 90], [3973, 120, 90], [3974, 120, 90], [3975, 120, 90], [3976, 70, 70], [3978, 70, 70],
                    [3979, 70, 70], [3980, 120, 90], [3981, 70, 70], [3982, 120, 90], [3983, 30, 45], [3984, 120, 90],
                    [3985, 70, 70], [3986, 120, 90], [3988, 120, 90], [3990, 70, 70], [3991, 120, 90], [3992, 70, 70],
                    [3993, 70, 70], [3994, 120, 90], [3995, 120, 90], [3996, 70, 70], [3997, 120, 90], [3998, 120, 90],
                    [3999, 70, 70], [4001, 120, 90], [4002, 120, 90], [4003, 70, 70], [4004, 70, 70], [4005, 40, 50],
                    [4006, 120, 90], [4007, 120, 90], [4008, 70, 70], [4009, 120, 90], [4010, 30, 45], [4011, 120, 90],
                    [4012, 120, 90], [4013, 120, 90], [4014, 120, 90], [4015, 120, 90], [4016, 30, 45], [4017, 70, 70],
                    [4018, 70, 70], [4019, 120, 90], [4020, 70, 70], [4021, 70, 70], [4022, 70, 70], [4023, 50, 60],
                    [4024, 120, 90], [4025, 70, 70], [4026, 70, 70], [4027, 120, 90], [4028, 70, 70], [4029, 120, 90],
                    [4031, 50, 60], [4032, 120, 90], [4033, 70, 70], [4035, 120, 90], [4036, 120, 90], [4037, 70, 70],
                    [4038, 120, 90], [4039, 120, 90], [4040, 120, 90], [4041, 120, 90], [4042, 120, 90], [4043, 70, 70],
                    [4044, 120, 90], [4045, 10.74, 9.07], [4046, 120, 90], [4047, 120, 90], [4048, 50, 60],
                    [4049, 70, 70], [4050, 120, 90], [4051, 120, 90], [4053, 70, 70], [4056, 70, 70], [4057, 50, 60],
                    [4059, 70, 70], [4060, 120, 90], [4062, 70, 70], [4063, 50, 60], [4064, 30, 45], [4065, 70, 70],
                    [4066, 70, 70], [4067, 70, 70], [4068, 120, 90], [4069, 50, 60], [4070, 120, 90], [4071, 70, 70],
                    [4072, 120, 90], [4073, 30, 45], [4074, 70, 70], [4075, 120, 90], [4076, 120, 90], [4077, 120, 90],
                    [4078, 120, 90], [4079, 120, 90], [4080, 120, 90], [4081, 120, 90], [4082, 120, 90],
                    [4083, 120, 90], [4084, 120, 90], [4085, 70, 70], [4086, 120, 90], [4087, 120, 90], [4088, 120, 90],
                    [4089, 120, 90], [4090, 120, 90], [4091, 70, 70], [4092, 70, 70], [4093, 120, 90],
                    [4094, 32.24, 21.39], [4095, 70, 70], [4096, 70, 70], [4097, 120, 90], [4098, 50, 60],
                    [4100, 50, 60], [4101, 120, 90], [4102, 70, 70], [4103, 70, 70], [4104, 70, 70], [4105, 120, 90],
                    [4106, 70, 70], [4107, 120, 90], [4108, 120, 90], [4109, 120, 90], [4110, 70, 70], [4111, 70, 70],
                    [4112, 40, 50], [4113, 120, 90], [4115, 120, 90], [4116, 120, 90], [4117, 50, 60], [4118, 120, 90],
                    [4119, 35.02, 25.49], [4120, 70, 70], [4121, 70, 70], [4122, 120, 90], [4123, 70, 70],
                    [4124, 30, 45], [4125, 70, 70], [4126, 120, 90], [4127, 120, 90], [4128, 70, 70],
                    [4131, 16.41, 11.51], [4132, 120, 90], [4133, 70, 70], [4134, 120, 90], [4135, 120, 90],
                    [4136, 50, 60], [4137, 120, 90], [4138, 11.77, 6.96], [4139, 30, 45], [4140, 70, 70],
                    [4141, 120, 90], [4142, 120, 90], [4143, 50, 60], [4144, 120, 90], [4145, 120, 90], [4147, 120, 90],
                    [4148, 120, 90], [4149, 120, 90], [4150, 70, 70], [4151, 120, 90], [4152, 120, 90], [4153, 120, 90],
                    [4154, 120, 90], [4155, 70, 70], [4156, 120, 90], [4157, 70, 70], [4158, 120, 90], [4159, 6.8, 6.9],
                    [4160, 120, 90], [4161, 120, 90], [4162, 120, 90], [4163, 120, 90], [4164, 120, 90],
                    [4165, 120, 90], [4166, 30, 45], [4167, 120, 90], [4168, 50, 60], [4169, 70, 70], [4170, 70, 70],
                    [4171, 120, 90], [4172, 120, 90], [4173, 70, 70], [4174, 70, 70], [4175, 40, 50], [4176, 50, 60],
                    [4177, 120, 90], [4178, 120, 90], [4181, 70, 70], [4182, 120, 90], [4184, 120, 90], [4185, 70, 70],
                    [4186, 120, 90], [4187, 120, 90], [4188, 120, 90], [4189, 50, 60], [4190, 120, 90], [4192, 50, 60],
                    [4193, 120, 90], [4194, 120, 90], [4195, 120, 90], [4196, 120, 90], [4197, 120, 90],
                    [4198, 120, 90], [4199, 70, 70], [4200, 13.33, 9.28], [4201, 70, 70], [4202, 70, 70],
                    [4203, 120, 90], [4204, 50, 60], [4205, 120, 90], [4206, 40, 50], [4207, 50, 60], [4208, 120, 90],
                    [4209, 120, 90], [4210, 40, 50], [4211, 120, 90], [4212, 30, 45], [4213, 70, 70], [4214, 120, 90],
                    [4215, 35.02, 25.49], [4216, 120, 90], [4218, 70, 70], [4219, 30, 45], [4220, 120, 90],
                    [4221, 32.24, 21.39], [4222, 120, 90], [4224, 70, 70], [4225, 120, 90], [4226, 70, 70],
                    [4228, 120, 90], [4229, 120, 90], [4230, 70, 70], [4231, 70, 70], [4232, 50, 60], [4233, 40, 50],
                    [4234, 50, 60], [4235, 13.03, 13.29], [4236, 70, 70], [4237, 120, 90], [4238, 120, 90],
                    [4239, 120, 90], [4240, 15, 25], [4241, 120, 90], [4242, 120, 90], [4244, 30, 45], [4245, 50, 60],
                    [4246, 50, 60], [4247, 120, 90], [4248, 120, 90], [4249, 120, 90], [4250, 120, 90], [4251, 120, 90],
                    [4252, 11.19, 9.3], [4253, 120, 90], [4255, 120, 90], [4256, 50, 60], [4257, 40, 50],
                    [4258, 50, 60], [4260, 120, 90], [4261, 50, 60], [4262, 70, 70], [4263, 120, 90],
                    [4264, 13.05, 10.17], [4265, 70, 70], [4266, 120, 90], [4267, 120, 90], [4268, 120, 90],
                    [4269, 120, 90], [4270, 120, 90], [4271, 70, 70], [4272, 120, 90], [4273, 120, 90], [4274, 120, 90],
                    [4275, 70, 70], [4276, 120, 90], [4277, 120, 90], [4278, 120, 90], [4279, 120, 90], [4280, 120, 90],
                    [4281, 70, 70], [4282, 50, 60], [4283, 120, 90], [4284, 120, 90], [4285, 50, 60], [4286, 120, 90],
                    [4287, 25.96, 16.87], [4288, 120, 90], [4290, 50, 60], [4291, 120, 90], [4292, 120, 90],
                    [4293, 9.17, 7.22], [4294, 120, 90], [4295, 120, 90], [4296, 120, 90], [4297, 70, 70],
                    [4298, 120, 90], [4299, 70, 70], [4300, 50, 60], [4301, 70, 70], [4302, 120, 90], [4304, 120, 90],
                    [4305, 70, 70], [4306, 70, 70], [4307, 120, 90], [4308, 120, 90], [4309, 50, 60], [4310, 50, 60],
                    [4311, 120, 90], [4312, 70, 70], [4313, 120, 90], [4314, 70, 70], [4315, 120, 90], [4316, 30, 45],
                    [4317, 50, 60], [4318, 120, 90], [4319, 120, 90], [4320, 70, 70], [4321, 120, 90], [4322, 70, 70],
                    [4323, 30, 45], [4325, 70, 70], [4326, 40, 50], [4328, 70, 70], [4329, 120, 90], [4330, 120, 90],
                    [4333, 120, 90], [4334, 120, 90], [4335, 70, 70], [4336, 50, 60], [4337, 40, 50], [4338, 70, 70],
                    [4339, 30, 45], [4340, 120, 90], [4341, 120, 90], [4342, 120, 90], [4343, 120, 90], [4345, 120, 90],
                    [4346, 50, 60], [4347, 120, 90], [4348, 70, 70], [4349, 120, 90], [4350, 120, 90], [4352, 120, 90],
                    [4353, 70, 70], [4355, 120, 90], [4356, 40, 50], [4357, 120, 90], [4358, 70, 70], [4360, 70, 70],
                    [4362, 70, 70], [4363, 120, 90], [4364, 120, 90], [4365, 120, 90], [4366, 120, 90], [4367, 120, 90],
                    [4368, 120, 90], [4370, 70, 70], [4371, 120, 90], [4372, 70, 70], [4373, 30, 45], [4374, 40, 50],
                    [4375, 120, 90], [4376, 120, 90], [4377, 70, 70], [4378, 70, 70], [4379, 120, 90], [4380, 70, 70],
                    [4381, 120, 90], [4382, 70, 70], [4383, 70, 70], [4384, 120, 90], [4385, 120, 90], [4386, 70, 70],
                    [4387, 120, 90], [4389, 120, 90], [4390, 35.02, 25.49], [4391, 120, 90], [4392, 120, 90],
                    [4393, 120, 90], [4394, 70, 70], [4395, 120, 90], [4396, 120, 90], [4398, 70, 70], [4399, 70, 70],
                    [4400, 120, 90], [4401, 70, 70], [4404, 120, 90], [4405, 6.35, 4.6], [4406, 120, 90],
                    [4407, 70, 70], [4408, 120, 90], [4409, 120, 90], [4410, 70, 70], [4411, 120, 90], [4412, 120, 90],
                    [4413, 50, 60], [4414, 70, 70], [4415, 120, 90], [4416, 120, 90], [4417, 50, 60], [4418, 70, 70],
                    [4419, 120, 90], [4420, 7.46, 6.7], [4421, 120, 90], [4422, 120, 90], [4423, 120, 90],
                    [4426, 70, 70], [4427, 40, 50], [4428, 32.24, 21.39], [4430, 50, 60], [4431, 70, 70],
                    [4432, 32.24, 21.39], [4433, 120, 90], [4435, 120, 90], [4436, 40, 50], [4437, 120, 90],
                    [4438, 50, 60], [4439, 40, 50], [4440, 70, 70], [4441, 120, 90], [4442, 70, 70], [4443, 70, 70],
                    [4444, 120, 90], [4445, 120, 90], [4446, 120, 90], [4447, 120, 90], [4448, 70, 70], [4450, 120, 90],
                    [4451, 40, 50], [4453, 70, 70], [4454, 70, 70], [4455, 70, 70], [4456, 70, 70], [4457, 40, 50],
                    [4459, 120, 90], [4460, 120, 90], [4461, 70, 70], [4463, 50, 60], [4464, 70, 70], [4465, 70, 70],
                    [4466, 120, 90], [4467, 120, 90], [4468, 70, 70], [4470, 50, 60], [4471, 120, 90], [4472, 70, 70],
                    [4473, 32.24, 21.39], [4474, 120, 90], [4475, 120, 90], [4476, 120, 90], [4477, 50, 60],
                    [4478, 120, 90], [4479, 120, 90], [4481, 120, 90], [4482, 120, 90], [4483, 120, 90],
                    [4484, 120, 90], [4485, 120, 90], [4486, 120, 90], [4487, 50, 60], [4488, 70, 70],
                    [4489, 11.71, 6.08], [4490, 120, 90], [4491, 70, 70], [4492, 120, 90], [4493, 70, 70],
                    [4494, 120, 90], [4495, 120, 90], [4496, 70, 70], [4497, 120, 90], [4498, 120, 90], [4500, 120, 90],
                    [4501, 120, 90], [4502, 120, 90], [4504, 70, 70], [4505, 70, 70], [4506, 70, 70], [4508, 120, 90],
                    [4509, 120, 90], [4510, 120, 90], [4511, 70, 70], [4512, 12.38, 7.83], [4513, 120, 90],
                    [4514, 120, 90], [4515, 70, 70], [4516, 120, 90], [4517, 50, 60], [4518, 70, 70], [4519, 70, 70],
                    [4520, 50, 60], [4521, 120, 90], [4523, 50, 60], [4524, 70, 70], [4525, 70, 70], [4526, 9.64, 9.7],
                    [4527, 120, 90], [4528, 120, 90], [4529, 120, 90], [4531, 120, 90], [4532, 70, 70], [4533, 70, 70],
                    [4534, 70, 70], [4535, 120, 90], [4536, 70, 70], [4537, 120, 90], [4538, 70, 70], [4539, 50, 60],
                    [4541, 120, 90], [4542, 70, 70], [4543, 50, 60], [4544, 70, 70], [4545, 70, 70], [4546, 120, 90],
                    [4547, 50, 60], [4548, 20.54, 15.72], [4549, 40, 50], [4550, 120, 90], [4551, 120, 90],
                    [4552, 120, 90], [4553, 120, 90], [4554, 70, 70], [4555, 70, 70], [4556, 120, 90], [4557, 120, 90],
                    [4558, 120, 90], [4559, 120, 90], [4560, 120, 90], [4561, 70, 70], [4562, 70, 70], [4563, 120, 90],
                    [4565, 70, 70], [4566, 70, 70], [4568, 70, 70], [4569, 120, 90], [4571, 70, 70], [4572, 120, 90],
                    [4574, 50, 60], [4575, 70, 70], [4576, 120, 90], [4578, 70, 70], [4579, 9.23, 6.62], [4580, 50, 60],
                    [4581, 120, 90], [4582, 70, 70], [4584, 40, 50], [4585, 70, 70], [4587, 120, 90], [4588, 120, 90],
                    [4590, 70, 70], [4591, 120, 90], [4592, 70, 70], [4595, 120, 90], [4596, 70, 70], [4597, 120, 90],
                    [4598, 120, 90], [4599, 35.02, 25.49], [4600, 120, 90], [4601, 120, 90], [4602, 120, 90],
                    [4603, 120, 90], [4604, 120, 90], [4605, 50, 60], [4606, 120, 90], [4607, 120, 90], [4608, 50, 60],
                    [4610, 70, 70], [4611, 120, 90], [4612, 120, 90], [4613, 120, 90], [4614, 70, 70], [4615, 120, 90],
                    [4616, 120, 90], [4617, 70, 70], [4618, 70, 70], [4619, 70, 70], [4620, 70, 70], [4621, 120, 90],
                    [4622, 120, 90], [4623, 70, 70], [4624, 120, 90], [4625, 120, 90], [4626, 40, 50], [4627, 120, 90],
                    [4628, 120, 90], [4629, 70, 70], [4630, 120, 90], [4631, 40, 50], [4633, 120, 90], [4634, 70, 70],
                    [4635, 40, 50], [4636, 120, 90], [4637, 70, 70], [4638, 70, 70], [4640, 120, 90],
                    [4641, 15.54, 8.85], [4643, 120, 90], [4644, 70, 70], [4645, 32.24, 21.39], [4646, 70, 70],
                    [4647, 50, 60], [4648, 70, 70], [4649, 50, 60], [4651, 70, 70], [4652, 70, 70], [4653, 120, 90],
                    [4654, 70, 70], [4655, 120, 90], [4657, 120, 90], [4658, 70, 70], [4659, 70, 70], [4660, 70, 70],
                    [4661, 32.24, 21.39], [4662, 70, 70], [4663, 30, 45], [4664, 10.86, 8.78], [4665, 120, 90],
                    [4666, 120, 90], [4667, 120, 90], [4668, 70, 70], [4669, 120, 90], [4670, 70, 70], [4671, 120, 90],
                    [4673, 50, 60], [4674, 15, 20], [4675, 50, 60], [4676, 70, 70], [4677, 70, 70], [4679, 120, 90],
                    [4680, 120, 90], [4682, 120, 90], [4683, 50, 60], [4684, 120, 90], [4686, 70, 70], [4687, 120, 90],
                    [4689, 50, 60], [4690, 32.24, 21.39], [4691, 40, 50], [4692, 70, 70], [4693, 120, 90],
                    [4694, 120, 90], [4695, 70, 70], [4696, 120, 90], [4697, 120, 90], [4698, 70, 70], [4699, 120, 90],
                    [4701, 120, 90], [4702, 120, 90], [4703, 50, 60], [4704, 120, 90], [4705, 120, 90], [4706, 120, 90],
                    [4707, 70, 70], [4708, 70, 70], [4709, 120, 90], [4711, 120, 90], [4712, 120, 90], [4713, 70, 70],
                    [4714, 70, 70], [4715, 40, 50], [4716, 35.02, 25.49], [4717, 70, 70], [4718, 120, 90],
                    [4720, 50, 60], [4722, 120, 90], [4723, 70, 70], [4724, 50, 60], [4725, 8.65, 7.78],
                    [4726, 120, 90], [4728, 120, 90], [4729, 120, 90], [4730, 70, 70], [4731, 4.74, 5.56],
                    [4732, 50, 60], [4733, 70, 70], [4734, 40, 50], [4735, 120, 90], [4736, 32.24, 21.39],
                    [4737, 120, 90], [4738, 120, 90], [4739, 120, 90], [4740, 70, 70], [4741, 70, 70], [4742, 120, 90],
                    [4743, 32.24, 21.39], [4744, 40, 50], [4745, 40, 50], [4747, 120, 90], [4749, 70, 70],
                    [4750, 9.46, 11.76], [4751, 50, 60], [4752, 120, 90], [4753, 120, 90], [4754, 120, 90],
                    [4756, 40, 50], [4757, 120, 90], [4758, 120, 90], [4760, 120, 90], [4761, 22.44, 14.33],
                    [4762, 70, 70], [4763, 120, 90], [4764, 120, 90], [4765, 50, 60], [4766, 120, 90], [4767, 120, 90],
                    [4770, 120, 90], [4771, 120, 90], [4772, 70, 70], [4773, 70, 70], [4774, 120, 90],
                    [4775, 32.24, 21.39], [4776, 50, 60], [4777, 70, 70], [4778, 50, 60], [4779, 70, 70],
                    [4780, 120, 90], [4781, 40, 50], [4782, 70, 70], [4783, 70, 70], [4784, 120, 90], [4785, 120, 90],
                    [4786, 120, 90], [4788, 50, 60], [4789, 70, 70], [4790, 120, 90], [4791, 70, 70], [4792, 70, 70],
                    [4793, 120, 90], [4794, 70, 70], [4795, 70, 70], [4796, 120, 90], [4797, 50, 60], [4798, 70, 70],
                    [4799, 70, 70], [4800, 120, 90], [4801, 70, 70], [4802, 120, 90], [4803, 70, 70], [4804, 120, 90],
                    [4805, 70, 70], [4806, 120, 90], [4807, 50, 60], [4808, 120, 90], [4809, 120, 90], [4810, 120, 90],
                    [4811, 50, 60], [4812, 120, 90], [4814, 120, 90], [4815, 70, 70], [4816, 120, 90], [4817, 120, 90],
                    [4818, 120, 90], [4819, 120, 90], [4820, 70, 70], [4821, 120, 90], [4823, 70, 70], [4825, 120, 90],
                    [4826, 120, 90], [4827, 120, 90], [4828, 70, 70], [4829, 120, 90], [4830, 120, 90],
                    [4831, 9.72, 8.44], [4832, 70, 70], [4833, 70, 70], [4834, 120, 90], [4835, 120, 90],
                    [4836, 30, 45], [4837, 120, 90], [4838, 40, 50], [4839, 120, 90], [4840, 70, 70], [4841, 120, 90],
                    [4842, 120, 90], [4843, 120, 90], [4844, 120, 90], [4845, 120, 90], [4846, 120, 90],
                    [4847, 120, 90], [4848, 120, 90], [4849, 40, 50], [4850, 30, 45], [4851, 120, 90], [4852, 120, 90],
                    [4853, 70, 70], [4854, 120, 90], [4855, 120, 90], [4856, 120, 90], [4857, 120, 90], [4858, 120, 90],
                    [4860, 120, 90], [4862, 40, 50], [4863, 70, 70], [4864, 120, 90], [4865, 40, 50], [4866, 15, 25],
                    [4867, 120, 90], [4868, 70, 70], [4869, 120, 90], [4871, 50, 60], [4872, 40, 50], [4874, 120, 90],
                    [4875, 70, 70], [4876, 40, 50], [4877, 120, 90], [4878, 50, 60], [4879, 120, 90], [4880, 70, 70],
                    [4881, 70, 70], [4882, 120, 90], [4883, 120, 90], [4885, 120, 90], [4886, 30, 45], [4887, 120, 90],
                    [4888, 70, 70], [4890, 70, 70], [4891, 120, 90], [4892, 120, 90], [4893, 50, 60], [4894, 70, 70],
                    [4895, 120, 90], [4896, 70, 70], [4897, 50, 60], [4898, 120, 90], [4899, 120, 90], [4900, 70, 70],
                    [4901, 70, 70], [4902, 70, 70], [4903, 120, 90], [4904, 120, 90], [4905, 40, 50], [4906, 120, 90],
                    [4907, 70, 70], [4908, 50, 60], [4909, 40, 50], [4910, 70, 70], [4911, 11.82, 7.07], [4912, 50, 60],
                    [4914, 70, 70], [4915, 120, 90], [4916, 70, 70], [4917, 70, 70], [4918, 50, 60], [4919, 120, 90],
                    [4920, 120, 90], [4922, 120, 90], [4923, 120, 90], [4924, 120, 90], [4925, 120, 90],
                    [4926, 120, 90], [4927, 120, 90], [4928, 70, 70], [4929, 70, 70], [4930, 70, 70], [4931, 70, 70],
                    [4932, 120, 90], [4934, 70, 70], [4935, 30, 45], [4936, 120, 90], [4937, 70, 70], [4938, 120, 90],
                    [4939, 70, 70], [4940, 120, 90], [4941, 120, 90], [4942, 50, 60], [4944, 70, 70], [4945, 120, 90],
                    [4946, 120, 90], [4947, 70, 70], [4948, 70, 70], [4949, 120, 90], [4950, 70, 70], [4951, 70, 70],
                    [4952, 50, 60], [4953, 35.02, 25.49], [4954, 70, 70], [4955, 70, 70], [4956, 32.24, 21.39],
                    [4957, 120, 90], [4958, 120, 90], [4959, 120, 90], [4960, 120, 90], [4961, 70, 70], [4962, 70, 70],
                    [4963, 70, 70], [4964, 7.37, 6.44], [4965, 50, 60], [4966, 70, 70], [4968, 120, 90],
                    [4969, 120, 90], [4970, 70, 70], [4971, 32.24, 21.39], [4972, 35.02, 25.49], [4973, 70, 70],
                    [4974, 70, 70], [4975, 120, 90], [4976, 40, 50], [4977, 120, 90], [4978, 120, 90], [4979, 120, 90],
                    [4980, 70, 70], [4981, 50, 60], [4982, 70, 70], [4983, 50, 60], [4984, 40, 50], [4987, 120, 90],
                    [4988, 70, 70], [4989, 120, 90], [4990, 120, 90], [4992, 70, 70], [4993, 120, 90], [4994, 120, 90],
                    [4995, 120, 90], [4996, 120, 90], [4997, 120, 90], [4998, 70, 70], [5000, 13.36, 12.29],
                    [5001, 70, 70], [5002, 120, 90], [5003, 120, 90], [5004, 120, 90], [5005, 70, 70], [5006, 120, 90],
                    [5007, 120, 90], [5008, 70, 70], [5009, 120, 90], [5010, 8.39, 5.61], [5011, 50, 60],
                    [5012, 120, 90], [5013, 70, 70], [5014, 70, 70], [5015, 50, 60], [5017, 70, 70], [5018, 30, 45],
                    [5019, 70, 70], [5020, 40, 50], [5021, 120, 90], [5022, 120, 90], [5023, 70, 70], [5024, 120, 90],
                    [5025, 120, 90], [5026, 120, 90], [5027, 120, 90], [5028, 120, 90], [5029, 120, 90],
                    [5030, 120, 90], [5031, 40, 50], [5032, 120, 90], [5033, 120, 90], [5034, 120, 90], [5035, 50, 60],
                    [5036, 120, 90], [5037, 120, 90], [5038, 70, 70], [5039, 70, 70], [5040, 120, 90], [5041, 120, 90],
                    [5042, 120, 90], [5043, 50, 60], [5044, 70, 70], [5045, 120, 90], [5046, 50, 60], [5047, 30, 45],
                    [5048, 70, 70], [5049, 120, 90], [5050, 50, 60], [5051, 70, 70], [5052, 120, 90], [5053, 120, 90],
                    [5054, 120, 90], [5056, 120, 90], [5057, 120, 90], [5058, 120, 90], [5059, 120, 90],
                    [5060, 120, 90], [5061, 120, 90], [5062, 70, 70], [5063, 40, 50], [5064, 120, 90], [5065, 120, 90],
                    [5066, 120, 90], [5068, 120, 90], [5069, 120, 90], [5070, 120, 90], [5071, 50, 60], [5072, 120, 90],
                    [5073, 50, 60], [5075, 120, 90], [5076, 30, 45], [5077, 40, 50], [5078, 120, 90], [5079, 70, 70],
                    [5080, 70, 70], [5081, 120, 90], [5082, 12.57, 13.41], [5084, 50, 60], [5085, 50, 60],
                    [5086, 70, 70], [5087, 120, 90], [5088, 120, 90], [5089, 120, 90], [5091, 120, 90], [5092, 50, 60],
                    [5093, 120, 90], [5094, 40, 50], [5095, 50, 60], [5097, 120, 90], [5098, 120, 90], [5099, 70, 70],
                    [5100, 120, 90], [5101, 5.93, 6.65], [5102, 120, 90], [5103, 120, 90], [5104, 120, 90],
                    [5105, 120, 90], [5106, 50, 60], [5107, 120, 90], [5108, 70, 70], [5109, 120, 90], [5110, 120, 90],
                    [5111, 35.02, 25.49], [5114, 4.87, 4], [5115, 120, 90], [5116, 70, 70], [5117, 40, 50],
                    [5118, 70, 70], [5119, 120, 90], [5120, 50, 60], [5121, 120, 90], [5122, 120, 90], [5124, 70, 70],
                    [5125, 50, 60], [5126, 120, 90], [5127, 70, 70], [5128, 32.24, 21.39], [5129, 70, 70],
                    [5130, 70, 70], [5131, 120, 90], [5132, 120, 90], [5135, 50, 60], [5137, 120, 90], [5138, 120, 90],
                    [5139, 70, 70], [5140, 70, 70], [5141, 50, 60], [5142, 120, 90], [5143, 70, 70], [5144, 70, 70],
                    [5145, 35.02, 25.49], [5148, 120, 90], [5149, 120, 90], [5150, 120, 90], [5151, 70, 70],
                    [5152, 120, 90], [5153, 120, 90], [5154, 120, 90], [5155, 70, 70], [5156, 120, 90], [5157, 50, 60],
                    [5158, 40, 50], [5159, 70, 70], [5160, 120, 90], [5161, 50, 60], [5162, 120, 90], [5163, 120, 90],
                    [5164, 120, 90], [5165, 70, 70], [5166, 50, 60], [5167, 120, 90], [5168, 70, 70], [5169, 120, 90],
                    [5170, 120, 90], [5171, 70, 70], [5172, 70, 70], [5173, 120, 90], [5174, 70, 70], [5175, 120, 90],
                    [5177, 120, 90], [5178, 120, 90], [5179, 120, 90], [5180, 120, 90], [5181, 120, 90],
                    [5182, 120, 90], [5183, 120, 90], [5189, 40, 50], [5271, 70, 70], [5627, 70, 70], [5632, 120, 90],
                    [5999, 50, 60], [6000, 30, 45], [6001, 30, 45], [6002, 30, 45], [6003, 30, 45], [6004, 30, 45],
                    [6005, 30, 45], [6006, 30, 45], [6007, 30, 45], [6008, 30, 45], [6011, 30, 45], [6012, 30, 45],
                    [6013, 30, 45], [6014, 30, 45], [6015, 30, 45], [6016, 30, 45], [6020, 30, 45], [6021, 30, 45],
                    [6022, 30, 45], [6023, 30, 45], [6024, 30, 45], [6028, 30, 45], [6031, 30, 45], [6032, 30, 45],
                    [6034, 30, 45], [6035, 30, 45], [6036, 30, 45], [6037, 30, 45], [6038, 30, 45], [6040, 30, 45],
                    [6041, 30, 45], [6042, 30, 45], [6043, 30, 45], [6044, 30, 45], [6045, 30, 45], [6046, 30, 45],
                    [6047, 30, 45], [6048, 30, 45], [6050, 70, 70], [6051, 70, 70], [6052, 120, 90], [6053, 120, 90],
                    [6248, 30, 45], [6252, 50, 60], [6253, 120, 90], [6255, 70, 70], [6256, 50, 60], [6258, 50, 60],
                    [6259, 120, 90], [6260, 120, 90], [6261, 70, 70], [6262, 70, 70], [6263, 120, 90], [6264, 70, 70],
                    [6265, 70, 70], [6266, 50, 60], [6267, 50, 60], [6268, 70, 70], [6269, 50, 60], [6270, 50, 60],
                    [6271, 70, 70], [6272, 40, 50], [6274, 70, 70], [6275, 70, 70], [6276, 50, 60], [6277, 120, 90],
                    [6279, 70, 70], [6280, 70, 70], [6281, 70, 70], [6282, 50, 60], [6283, 70, 70], [6284, 50, 60],
                    [6286, 70, 70], [6287, 50, 60], [6288, 70, 70], [6289, 50, 60], [6290, 120, 90], [6292, 70, 70],
                    [6293, 70, 70], [6294, 120, 90], [6295, 120, 90], [6296, 70, 70], [6297, 120, 90], [6299, 70, 70],
                    [6300, 70, 70], [6301, 70, 70], [6302, 70, 70], [6303, 70, 70], [6305, 120, 90], [6306, 70, 70],
                    [6307, 120, 90], [6308, 120, 90], [6309, 70, 70], [6310, 50, 60], [6312, 120, 90], [6313, 70, 70],
                    [6314, 120, 90], [6315, 70, 70], [6316, 70, 70], [6317, 70, 70], [6319, 50, 60], [6320, 70, 70],
                    [6321, 70, 70], [6326, 70, 70], [6328, 120, 90], [6330, 120, 90]]],
            [1998,
             [[1, 50, 60], [2, 120, 90], [3, 70, 70], [7, 35.26, 21.02], [9, 120, 90], [13, 120, 90], [14, 70, 70],
              [15, 70, 70], [16, 70, 70], [17, 120, 90], [18, 70, 70], [19, 70, 70], [20, 120, 90], [21, 70, 70],
              [22, 120, 90], [23, 120, 90], [25, 13.55, 9.36], [26, 70, 70], [27, 120, 90], [28, 50, 60], [29, 120, 90],
              [30, 31.41, 21.15], [31, 11.48, 9.38], [32, 120, 90], [33, 70, 70], [35, 120, 90], [37, 120, 90],
              [38, 120, 90], [40, 70, 70], [42, 70, 70], [43, 120, 90], [44, 120, 90], [46, 120, 90], [47, 70, 70],
              [48, 70, 70], [49, 37.5, 45], [50, 120, 90], [51, 15.57, 18.15], [53, 40, 50], [56, 120, 90],
              [57, 120, 90], [58, 61.93, 51.53], [61, 70, 70], [62, 120, 90], [63, 70, 70], [64, 30, 45], [65, 50, 60],
              [66, 20, 25], [68, 70, 70], [69, 70, 70], [70, 50, 60], [71, 120, 90], [72, 120, 90], [73, 120, 90],
              [75, 50, 60], [77, 35.02, 25.49], [78, 59.13, 56.03], [81, 70, 70], [82, 70, 70], [83, 40, 37.5],
              [84, 120, 90], [87, 140.68, 39.98], [88, 15.28, 7.56], [89, 32.24, 21.39], [91, 40, 50],
              [93, 10.29, 11.63], [94, 120, 90], [96, 120, 90], [98, 120, 90], [99, 15.91, 13.12], [100, 13.94, 11.33],
              [101, 70, 70], [103, 120, 90], [105, 40, 50], [106, 70, 70], [109, 40, 50], [110, 120, 90], [113, 50, 60],
              [119, 70, 70], [121, 17.05, 9.84], [122, 42.72, 53.2], [123, 120, 90], [125, 24.22, 37.94], [128, 70, 70],
              [133, 35.02, 25.49], [135, 24.22, 25.06], [136, 120, 90], [138, 83.99, 31.46], [140, 50, 60],
              [141, 70, 70], [142, 70, 70], [144, 50, 60], [145, 10.42, 10.42], [146, 35.02, 25.49],
              [147, 32.24, 21.39], [149, 70, 70], [150, 50, 60], [151, 47.1, 33.3], [153, 12, 18], [156, 120, 90],
              [157, 120, 90], [158, 35.02, 25.49], [160, 120, 90], [161, 50, 60], [162, 17.62, 13.77], [163, 70, 70],
              [164, 120, 90], [165, 70, 70], [166, 31.35, 44.44], [169, 97.7, 41.85], [170, 120, 90], [171, 70, 70],
              [175, 70, 70], [177, 70, 70], [181, 120, 90], [182, 120, 90], [183, 70, 70], [184, 120, 90],
              [186, 42.55, 28.63], [187, 50, 60], [188, 50.99, 26.41], [189, 120, 90], [190, 41.9, 24.53],
              [192, 70, 70], [193, 50, 60], [194, 120, 90], [195, 70, 70], [196, 9.99, 9.76], [197, 120, 90],
              [198, 120, 90], [199, 120, 90], [200, 50, 60], [203, 70, 70], [204, 70, 70], [206, 120, 90],
              [207, 50, 60], [210, 120, 90], [211, 120, 90], [212, 70, 70], [213, 70, 70], [214, 120, 90],
              [215, 39.31, 26.34], [216, 72.31, 55.31], [217, 120, 90], [218, 53.89, 34.22], [219, 50, 60],
              [220, 23.35, 19.12], [222, 13.4, 9.72], [225, 37.5, 45], [226, 13.66, 15.31], [227, 120, 90],
              [228, 50, 60], [230, 30, 37.5], [231, 70, 70], [232, 70, 70], [233, 70, 70], [234, 50, 60], [235, 70, 70],
              [236, 70, 70], [237, 10.83, 7.57], [239, 57.35, 74.71], [240, 120, 90], [241, 70, 70],
              [242, 164.4, 59.03], [243, 118.04, 58], [244, 120, 90], [245, 120, 90], [246, 60.21, 33.65],
              [247, 120, 90], [248, 60.9, 49.22], [249, 70, 70], [250, 50, 60], [253, 120, 90], [256, 50, 60],
              [257, 120, 90], [260, 70, 70], [264, 50, 60], [265, 120, 90], [267, 120, 90], [268, 35.02, 25.49],
              [269, 120, 90], [270, 102.9, 57.89], [272, 120, 90], [273, 30, 45], [275, 40, 50], [282, 70, 70],
              [283, 35.02, 25.49], [284, 70, 70], [285, 62.31, 50.39], [286, 33.37, 83.43], [287, 40, 37.5],
              [289, 120, 90], [291, 70, 70], [292, 50, 60], [294, 118.68, 38.52], [295, 120, 90], [296, 70, 70],
              [297, 35.02, 25.49], [298, 70, 70], [299, 56.16, 71.39], [302, 120, 90], [303, 60.81, 38.31],
              [305, 21.98, 26], [306, 53.16, 39.53], [307, 120, 90], [308, 22.69, 32.81], [309, 35.02, 25.49],
              [310, 20.76, 23.58], [311, 70, 70], [312, 98.14, 57.65], [313, 50, 60], [314, 28.98, 30.23],
              [315, 120, 90], [317, 34.9, 28.91], [320, 120, 90], [321, 120, 90], [322, 120, 90], [324, 37.5, 45],
              [325, 120, 90], [326, 28.63, 19.82], [327, 120, 90], [328, 70, 70], [329, 70, 70], [330, 24.63, 27.62],
              [332, 101.6, 71.83], [333, 120, 90], [334, 14.71, 16.26], [337, 19.61, 30.02], [339, 74, 62.86],
              [340, 120, 90], [342, 70, 70], [343, 120, 90], [344, 89.38, 44.91], [346, 120, 90], [347, 120, 90],
              [348, 120, 90], [350, 70, 70], [351, 70, 70], [353, 20.67, 13.88], [354, 37.5, 45], [355, 70, 70],
              [356, 120, 90], [358, 32.24, 21.39], [361, 41.38, 37.74], [362, 50, 60], [365, 120, 90], [367, 50, 60],
              [368, 50, 60], [369, 6.34, 5.27], [370, 70, 70], [371, 120, 90], [372, 25.28, 18], [374, 50, 60],
              [376, 22.12, 15.98], [377, 40, 50], [378, 31.66, 30.53], [379, 11.67, 16.73], [382, 120, 90],
              [383, 70, 70], [385, 120, 90], [386, 50, 60], [387, 50, 60], [389, 37.5, 45], [390, 70, 70],
              [391, 70, 70], [392, 72.06, 47.49], [394, 50, 60], [396, 120, 90], [398, 70, 70], [399, 70, 70],
              [400, 50, 60], [401, 70, 70], [402, 120, 90], [403, 25.72, 27.84], [405, 70, 70], [406, 120, 90],
              [407, 50, 60], [409, 50, 60], [411, 120, 90], [412, 120, 90], [413, 30, 45], [415, 120, 90],
              [416, 50, 60], [418, 37.33, 36.38], [419, 120, 90], [422, 35.02, 25.49], [424, 32.02, 28.67],
              [425, 12.16, 14.12], [426, 35.02, 25.49], [427, 16, 20], [428, 13.52, 12.14], [429, 70, 70],
              [430, 50, 60], [432, 60.55, 31.38], [434, 70, 70], [436, 70, 70], [437, 16, 20], [439, 70, 70],
              [443, 120, 90], [444, 20.67, 13.88], [445, 120, 90], [446, 70, 70], [450, 120, 90], [451, 50, 60],
              [452, 120, 90], [453, 70, 70], [454, 120, 90], [455, 71.93, 65.93], [457, 50, 60], [458, 70, 70],
              [459, 120, 90], [460, 50, 60], [461, 50, 60], [463, 14.85, 9.88], [464, 21.08, 14.31], [465, 50, 60],
              [466, 120, 90], [467, 35.02, 25.49], [468, 120, 90], [469, 120, 90], [470, 35.02, 25.49],
              [471, 29.42, 44.44], [473, 120, 90], [474, 70, 70], [476, 120, 90], [477, 120, 90], [478, 120, 90],
              [479, 70, 70], [480, 70, 70], [481, 70, 70], [482, 70, 70], [484, 70, 70], [485, 120, 90], [486, 50, 60],
              [487, 22.74, 35.74], [488, 70, 70], [490, 70, 70], [493, 120, 90], [494, 120, 90], [495, 120, 90],
              [496, 70, 70], [497, 20.34, 27.7], [498, 50, 60], [500, 70, 70], [501, 70, 70], [503, 70, 70],
              [504, 14.4, 17.19], [505, 24.91, 27.22], [507, 120, 90], [508, 70, 70], [509, 5.13, 4.64], [510, 50, 60],
              [512, 40, 50], [513, 70, 70], [515, 120, 90], [518, 120, 90], [519, 26.44, 21.57], [520, 120, 90],
              [521, 120, 90], [522, 70, 70], [523, 120, 90], [524, 70, 70], [525, 120, 90], [526, 50, 60],
              [527, 70, 70], [528, 50, 60], [531, 10.37, 9.91], [532, 50, 60], [534, 50, 60], [535, 40, 50],
              [536, 18.74, 29.58], [537, 70, 70], [540, 70, 70], [541, 61.04, 50.11], [543, 120, 90],
              [545, 35.62, 43.31], [547, 15, 25], [548, 120, 90], [549, 120, 90], [550, 70, 70], [551, 120, 90],
              [553, 120, 90], [554, 15, 25], [555, 120, 90], [556, 120, 90], [557, 40, 50], [558, 120, 90],
              [559, 70, 70], [561, 120, 90], [563, 70, 70], [564, 12.02, 6.99], [565, 30, 45], [568, 44.41, 35.25],
              [569, 106.46, 58.13], [570, 77.63, 49.89], [571, 70, 70], [572, 30, 45], [573, 34.75, 26.58],
              [574, 70, 70], [577, 32.7, 38.7], [579, 40, 50], [581, 30, 45], [582, 120, 90], [583, 70, 70],
              [584, 21.39, 10.39], [585, 70, 70], [586, 50, 60], [588, 70, 70], [589, 120, 90], [590, 70, 70],
              [591, 120, 90], [593, 70, 70], [594, 32.24, 21.39], [595, 62.54, 30.08], [596, 50, 60], [597, 70, 70],
              [599, 37.1, 32.34], [600, 120, 90], [601, 70, 70], [604, 120, 90], [606, 120, 90], [607, 50, 60],
              [608, 54.37, 25.93], [610, 50, 60], [611, 50, 60], [612, 70, 70], [614, 28.93, 29.68], [615, 120, 90],
              [616, 120, 90], [618, 30, 37.5], [619, 120, 90], [621, 120, 90], [623, 8.39, 6.11], [625, 51.68, 25.98],
              [626, 40, 50], [627, 50, 60], [628, 20.36, 23.58], [629, 120, 90], [630, 70, 70], [631, 43.54, 34.8],
              [633, 120, 90], [635, 120, 90], [636, 70, 70], [637, 7.01, 5.35], [639, 70, 70], [641, 120, 90],
              [645, 50, 60], [647, 70, 70], [648, 70, 70], [649, 70, 70], [650, 120, 90], [651, 120, 90], [652, 70, 70],
              [653, 70, 70], [654, 120, 90], [656, 120, 90], [657, 120, 90], [659, 9.95, 8.02], [660, 24.24, 22.96],
              [662, 120, 90], [663, 120, 90], [664, 70, 70], [665, 120, 90], [666, 120, 90], [669, 50, 60],
              [670, 70, 70], [672, 70, 70], [673, 120, 90], [675, 70, 70], [678, 47.55, 39.99], [679, 120, 90],
              [680, 11.71, 8.44], [681, 32.24, 21.39], [682, 8.1, 6.18], [683, 16.28, 9.76], [686, 50, 60],
              [687, 120, 90], [688, 120, 90], [690, 50, 60], [691, 18.17, 15.1], [692, 32.24, 21.39], [693, 70, 70],
              [694, 50, 60], [695, 74.53, 49.3], [697, 120, 90], [698, 70, 70], [700, 70, 70], [701, 120, 90],
              [702, 70, 70], [703, 70, 70], [704, 55.7, 36.5], [705, 40, 50], [706, 70, 70], [708, 70, 70],
              [709, 32.88, 46.39], [710, 120, 90], [711, 50, 60], [712, 120, 90], [714, 50, 60], [715, 120, 90],
              [716, 70, 70], [717, 36.27, 32.74], [718, 70, 70], [719, 120, 90], [720, 87.15, 35.16], [721, 50, 60],
              [722, 120, 90], [723, 50, 60], [724, 29.85, 64.97], [727, 50, 45], [730, 35.02, 25.49], [731, 50, 60],
              [732, 120, 90], [734, 30, 45], [736, 70, 70], [737, 70, 70], [738, 120, 90], [740, 120, 90],
              [741, 120, 90], [742, 40, 50], [745, 120, 90], [746, 40, 50], [747, 50, 60], [748, 70, 70], [749, 50, 60],
              [750, 133.42, 46.75], [751, 50, 60], [753, 50, 60], [754, 36.5, 31.71], [756, 70, 70], [759, 70, 70],
              [762, 70, 70], [763, 70, 70], [766, 120, 90], [767, 70, 70], [769, 120, 90], [771, 120, 90],
              [772, 70, 70], [773, 64.93, 30.4], [774, 120, 90], [775, 70, 70], [776, 120, 90], [778, 120, 90],
              [779, 50, 60], [781, 71.84, 33.52], [782, 120, 90], [783, 50, 45], [784, 50, 60], [785, 120, 90],
              [787, 70, 70], [789, 70, 70], [790, 120, 90], [795, 120, 90], [796, 70, 70], [799, 50, 60],
              [801, 35.37, 49.96], [802, 120, 90], [803, 70, 70], [804, 120, 90], [805, 13.65, 18.71], [806, 120, 90],
              [807, 30, 45], [811, 120, 90], [812, 50, 60], [813, 15.18, 11.6], [814, 120, 90], [815, 120, 90],
              [818, 70, 70], [819, 120, 90], [820, 120, 90], [821, 24.1, 26.31], [822, 40, 50], [823, 120, 90],
              [824, 120, 90], [825, 70, 70], [826, 17.52, 8.25], [827, 70, 70], [829, 11.79, 8.2], [830, 120, 90],
              [831, 120, 90], [833, 120, 90], [834, 70, 70], [835, 69.3, 61.77], [836, 120, 90], [837, 70, 70],
              [840, 70, 70], [842, 50, 60], [843, 50.2, 42.1], [844, 117.83, 54.95], [845, 79.17, 68.36],
              [846, 120, 90], [847, 32.24, 21.39], [848, 9.12, 11.53], [850, 40, 50], [851, 18.96, 12.46],
              [852, 70, 70], [855, 9.81, 9.88], [857, 120, 90], [860, 70, 70], [863, 40, 50], [865, 70, 70],
              [867, 120, 90], [869, 70, 70], [871, 16.44, 22.77], [872, 70, 70], [873, 70, 70], [875, 120, 90],
              [876, 120, 90], [877, 120, 90], [878, 5.59, 4.6], [881, 35.02, 25.49], [882, 50, 60], [883, 120, 90],
              [884, 70, 70], [885, 70, 70], [886, 120, 90], [889, 11.95, 11.69], [890, 62.93, 34.45], [891, 120, 90],
              [892, 120, 90], [894, 23.13, 17.71], [895, 120, 90], [896, 70, 70], [897, 13.97, 22.37], [899, 120, 90],
              [900, 6.81, 4.72], [901, 120, 90], [905, 120, 90], [909, 120, 90], [910, 17.59, 7.29], [913, 40, 50],
              [914, 120, 90], [915, 38.46, 49.72], [916, 40, 50], [917, 30, 45], [918, 120, 90], [919, 120, 90],
              [922, 16, 20], [924, 11.58, 10.56], [926, 40.84, 38.58], [927, 70, 70], [928, 120, 90], [929, 120, 90],
              [930, 50, 60], [931, 70, 70], [934, 37.5, 45], [935, 120, 90], [936, 50, 60], [937, 120, 90],
              [938, 70, 70], [940, 70, 70], [941, 70, 70], [942, 70, 70], [944, 96.61, 70.21], [945, 50, 60],
              [946, 50, 60], [948, 70, 70], [949, 79.45, 48.51], [950, 13.52, 21.99], [952, 16.43, 13.85],
              [953, 50, 60], [954, 120, 90], [955, 120, 90], [957, 120, 90], [958, 50, 60], [960, 50, 60],
              [961, 120, 90], [963, 32.24, 21.39], [964, 50, 60], [965, 50, 60], [966, 7.47, 7.71], [969, 70, 70],
              [970, 20.67, 13.88], [971, 35.72, 14.91], [972, 35.77, 19.67], [974, 30, 45], [976, 8.35, 13.66],
              [977, 17.03, 11.19], [978, 70, 70], [979, 36.64, 34.46], [980, 70, 70], [981, 120, 90], [982, 120, 90],
              [983, 71.83, 43.14], [985, 194.37, 75.01], [986, 12.4, 12.01], [987, 35.02, 25.49], [988, 6.14, 5.32],
              [990, 71.86, 39.63], [991, 120, 90], [993, 120, 90], [994, 40, 50], [997, 120, 90], [998, 70, 70],
              [999, 120, 90], [1000, 50, 60], [1003, 8.24, 5.82], [1004, 70, 70], [1005, 17.62, 13.77], [1006, 120, 90],
              [1007, 40, 50], [1008, 37.5, 45], [1009, 120, 90], [1013, 120, 90], [1015, 70, 70], [1016, 14.94, 23.74],
              [1017, 50, 60], [1018, 120, 90], [1020, 32.24, 21.39], [1021, 70, 70], [1022, 120, 90], [1023, 50, 60],
              [1025, 120, 90], [1027, 120, 90], [1028, 50, 60], [1029, 32.24, 21.39], [1030, 40, 50],
              [1032, 35.33, 27.71], [1033, 27.47, 30.75], [1034, 70, 70], [1036, 70, 70], [1038, 70, 70],
              [1039, 120, 90], [1042, 120, 90], [1043, 120, 90], [1044, 120, 90], [1045, 120, 90], [1046, 50, 60],
              [1047, 70, 70], [1048, 70, 70], [1050, 70, 70], [1051, 92.72, 35.97], [1052, 50, 60], [1053, 50, 60],
              [1054, 70, 70], [1056, 70, 70], [1057, 50, 60], [1058, 70, 70], [1059, 70, 70], [1061, 70, 70],
              [1062, 70, 70], [1063, 120, 90], [1064, 20.67, 13.88], [1065, 120, 90], [1067, 120, 90], [1069, 50, 60],
              [1070, 50, 60], [1071, 125.97, 49.26], [1073, 84.92, 72.24], [1075, 9.34, 8.91], [1077, 120, 90],
              [1078, 120, 90], [1080, 120, 90], [1081, 70, 70], [1082, 120, 90], [1084, 160.19, 70.76], [1087, 70, 70],
              [1090, 120, 90], [1091, 40, 50], [1092, 15, 25], [1093, 50, 60], [1094, 23.66, 23.15],
              [1095, 34.76, 26.62], [1096, 120, 90], [1097, 8.07, 10.33], [1099, 20.2, 20.63], [1100, 55.33, 47.25],
              [1102, 120, 90], [1104, 70, 70], [1106, 120, 90], [1108, 120, 90], [1109, 71.26, 34.85], [1110, 120, 90],
              [1111, 120, 90], [1113, 120, 90], [1114, 120, 90], [1117, 50, 60], [1118, 50, 60], [1119, 50, 60],
              [1120, 120, 90], [1121, 120, 90], [1122, 35.02, 25.49], [1124, 33.6, 22.42], [1125, 120, 90],
              [1126, 70, 70], [1127, 35.02, 25.49], [1128, 70, 70], [1129, 20.67, 13.88], [1130, 120, 90],
              [1131, 19.62, 27.9], [1132, 50, 60], [1136, 70, 70], [1137, 120, 90], [1138, 120, 90], [1139, 120, 90],
              [1140, 50, 45], [1141, 151.96, 55.04], [1142, 87.4, 44.91], [1144, 70.4, 75.66], [1145, 120, 90],
              [1147, 22.6, 14.7], [1149, 50, 60], [1150, 50, 60], [1152, 70, 70], [1153, 120, 90], [1154, 120, 90],
              [1155, 12.52, 12.5], [1156, 50, 60], [1157, 120, 90], [1158, 50, 60], [1159, 70, 70], [1161, 120, 90],
              [1163, 70, 70], [1164, 120, 90], [1165, 120, 90], [1167, 85.7, 63.16], [1168, 120, 90],
              [1169, 34.55, 69.22], [1170, 70, 70], [1171, 120, 90], [1172, 70, 70], [1173, 50, 60], [1174, 70, 70],
              [1175, 28.04, 39.32], [1176, 120, 90], [1177, 70, 70], [1178, 9.93, 8.3], [1180, 20.27, 16.1],
              [1181, 120, 90], [1186, 70, 70], [1187, 120, 90], [1188, 40, 50], [1189, 120, 90], [1190, 70, 70],
              [1191, 70, 70], [1194, 82.38, 42.91], [1195, 120, 90], [1198, 120, 90], [1199, 40, 50],
              [1200, 27.2, 13.54], [1202, 30, 45], [1203, 120, 90], [1204, 70, 70], [1205, 85.87, 50.11],
              [1206, 120, 90], [1207, 30, 45], [1209, 40, 50], [1210, 40, 37.5], [1211, 53.75, 32.19], [1212, 120, 90],
              [1213, 40, 50], [1214, 70, 70], [1216, 50, 60], [1217, 90.55, 46.37], [1219, 116.48, 55.12],
              [1221, 22.66, 24.86], [1223, 70, 70], [1224, 49.77, 79.26], [1225, 70, 70], [1226, 70, 70],
              [1227, 120, 90], [1228, 57.49, 37.38], [1230, 50, 60], [1233, 50, 60], [1234, 70, 70], [1235, 50, 60],
              [1236, 70, 70], [1237, 37.5, 45], [1238, 70, 70], [1239, 120, 90], [1240, 120, 90], [1244, 70, 70],
              [1245, 120, 90], [1246, 70, 70], [1247, 70, 70], [1250, 70, 70], [1251, 70, 70], [1253, 50, 60],
              [1254, 70, 70], [1255, 120, 90], [1257, 50, 60], [1259, 105.06, 30.34], [1260, 50, 60],
              [1262, 110.05, 49.65], [1263, 120, 90], [1264, 120, 90], [1265, 13.84, 11.71], [1266, 35.02, 25.49],
              [1268, 30.72, 32.5], [1269, 50, 60], [1271, 85.26, 44.5], [1272, 70, 70], [1275, 50, 60],
              [1276, 32.24, 21.39], [1278, 70, 70], [1280, 14.3, 8.12], [1281, 21.65, 27], [1282, 50, 60],
              [1286, 120, 90], [1287, 70, 70], [1288, 70, 70], [1290, 120, 90], [1291, 70, 70], [1292, 70, 70],
              [1293, 20, 25], [1295, 70, 70], [1298, 50, 60], [1299, 70, 70], [1300, 50, 60], [1301, 70, 70],
              [1302, 30, 45], [1303, 70, 70], [1305, 17.46, 22.11], [1306, 50, 60], [1308, 120, 90],
              [1312, 26.57, 15.77], [1313, 120, 90], [1314, 40, 50], [1315, 120, 90], [1317, 70, 70], [1318, 120, 90],
              [1319, 46.62, 28.16], [1320, 120, 90], [1321, 48.13, 28.8], [1323, 75.54, 72.3], [1324, 120, 90],
              [1325, 120, 90], [1326, 70, 70], [1327, 120, 90], [1328, 70, 70], [1329, 70, 70], [1331, 120, 90],
              [1332, 10.21, 7.08], [1333, 120, 90], [1334, 87.72, 70.36], [1335, 70, 70], [1337, 5.66, 6.03],
              [1338, 120, 90], [1339, 11.12, 9.1], [1340, 50, 60], [1341, 35.02, 25.49], [1342, 70, 70], [1345, 40, 50],
              [1346, 20.67, 13.88], [1349, 70, 70], [1350, 70, 70], [1351, 70, 70], [1352, 35.02, 25.49],
              [1353, 120, 90], [1355, 120, 90], [1357, 70, 70], [1358, 120, 90], [1359, 67.94, 52.51], [1360, 120, 90],
              [1361, 77.94, 60.66], [1363, 83.47, 31.82], [1367, 53.29, 36.48], [1370, 17.21, 28.49], [1371, 70, 70],
              [1372, 120, 90], [1375, 22.3, 23.87], [1376, 30, 37.5], [1378, 70, 70], [1379, 120, 90], [1380, 70, 70],
              [1381, 120, 90], [1382, 50, 60], [1383, 8.95, 7.72], [1385, 32.24, 21.39], [1387, 50, 60],
              [1388, 120, 90], [1391, 120, 90], [1392, 35.02, 25.49], [1393, 120, 90], [1395, 70, 70], [1396, 70, 70],
              [1398, 50, 60], [1399, 9.27, 9.03], [1402, 70, 70], [1404, 40, 50], [1405, 120, 90], [1406, 6.5, 5.37],
              [1410, 70, 70], [1411, 20.67, 13.88], [1415, 70, 70], [1417, 120, 90], [1420, 20, 24], [1421, 120, 90],
              [1422, 120, 90], [1424, 50, 60], [1425, 70, 70], [1426, 8.57, 6.77], [1427, 30, 45], [1428, 10.79, 6.72],
              [1431, 120, 90], [1432, 6.73, 7.01], [1434, 70, 70], [1436, 70, 70], [1438, 70, 70], [1439, 120, 90],
              [1440, 70, 70], [1441, 120, 90], [1442, 70, 70], [1443, 50, 60], [1444, 120, 90], [1445, 120, 90],
              [1448, 70, 70], [1449, 40, 50], [1450, 120, 90], [1451, 35.02, 25.49], [1453, 70, 70],
              [1454, 20.61, 20.28], [1456, 70, 70], [1459, 120, 90], [1460, 120, 90], [1461, 6.14, 6.98],
              [1464, 50, 60], [1465, 70, 70], [1466, 50, 60], [1467, 70, 70], [1469, 70, 70], [1470, 30, 45],
              [1471, 58.78, 40.42], [1472, 120, 90], [1473, 11.99, 10.02], [1474, 70, 70], [1475, 93.38, 40.44],
              [1476, 39.76, 77.7], [1477, 104.5, 55.33], [1478, 17.41, 11.68], [1479, 40, 50], [1481, 70, 70],
              [1482, 70, 70], [1483, 70, 70], [1484, 24.92, 66.54], [1485, 120, 90], [1486, 73.81, 56.6],
              [1487, 120, 90], [1488, 120, 90], [1490, 35.69, 22.38], [1491, 13.55, 10.7], [1493, 40.01, 20.74],
              [1503, 120, 90], [1505, 120, 90], [1506, 120, 90], [1507, 70, 70], [1508, 21.47, 18.5], [1509, 120, 90],
              [1510, 31.13, 26.62], [1511, 21.14, 10.89], [1512, 20, 24], [1513, 32.24, 21.39], [1514, 70, 70],
              [1515, 30, 45], [1516, 70, 70], [1517, 120, 90], [1518, 120, 90], [1519, 120, 90], [1520, 70, 70],
              [1521, 120, 90], [1522, 35.03, 33.83], [1523, 120, 90], [1524, 120, 90], [1525, 30, 37.5], [1526, 70, 70],
              [1527, 17.34, 33.26], [1530, 70, 70], [1533, 70, 70], [1534, 10.96, 7.99], [1536, 30.57, 20.35],
              [1537, 35.55, 43.28], [1538, 120, 90], [1539, 40, 50], [1540, 40, 50], [1541, 70, 70], [1542, 50, 60],
              [1544, 120, 90], [1546, 70, 70], [1547, 70, 70], [1548, 120, 90], [1549, 70, 70], [1550, 120, 90],
              [1552, 30, 45], [1553, 70.57, 50.89], [1555, 30, 37.5], [1556, 27.63, 11.76], [1557, 70, 70],
              [1559, 50, 60], [1560, 70, 70], [1561, 30.82, 30.34], [1562, 97.79, 51.18], [1565, 120, 90],
              [1567, 120, 90], [1568, 17.56, 11.49], [1571, 70, 70], [1572, 120, 90], [1574, 50, 60],
              [1575, 124.82, 81.48], [1576, 50, 60], [1577, 50, 60], [1578, 120, 90], [1580, 50, 60],
              [1581, 19.75, 12.12], [1582, 22.41, 22.97], [1583, 120, 90], [1585, 70, 70], [1587, 70, 70],
              [1589, 70, 70], [1590, 70, 70], [1591, 70, 70], [1592, 32.24, 21.39], [1593, 25.91, 24.87],
              [1595, 70, 70], [1596, 120, 90], [1597, 50, 60], [1598, 19.88, 13.26], [1600, 120, 90], [1601, 70, 70],
              [1602, 120, 90], [1603, 50, 60], [1605, 50, 60], [1606, 120, 90], [1607, 70, 70], [1609, 120, 90],
              [1610, 18.25, 11.14], [1612, 40, 50], [1614, 70, 70], [1615, 120, 90], [1617, 120, 90], [1619, 120, 90],
              [1620, 50, 60], [1621, 70, 70], [1623, 50, 60], [1624, 35.02, 25.49], [1625, 70, 70], [1626, 70, 70],
              [1627, 70, 70], [1628, 50, 60], [1629, 16, 20], [1630, 70, 70], [1632, 13.48, 10.49], [1634, 70, 70],
              [1635, 16.96, 17.21], [1637, 120, 90], [1638, 70, 70], [1639, 70, 70], [1640, 70, 70], [1641, 70, 70],
              [1643, 18.14, 22.93], [1644, 48.21, 38.33], [1645, 70, 70], [1647, 70, 70], [1648, 120, 90],
              [1649, 120, 90], [1650, 70, 70], [1651, 120, 90], [1652, 70, 70], [1653, 120, 90], [1654, 70, 70],
              [1656, 8.81, 6.01], [1657, 70, 70], [1658, 120, 90], [1659, 38.85, 38.2], [1660, 134.83, 48.67],
              [1661, 32.24, 21.39], [1662, 70, 70], [1663, 28.45, 30.94], [1664, 70, 70], [1665, 50, 60],
              [1666, 6.17, 5.14], [1667, 120, 90], [1668, 50, 60], [1669, 120, 90], [1671, 120, 90],
              [1672, 20.29, 61.88], [1673, 40.58, 28.22], [1674, 70, 70], [1675, 11.86, 16.02], [1679, 40, 50],
              [1680, 55.76, 53.89], [1681, 120, 90], [1684, 120, 90], [1685, 37.5, 45], [1686, 120, 90],
              [1688, 25.71, 34.65], [1689, 120, 90], [1690, 120, 90], [1692, 120, 90], [1694, 120, 90], [1695, 120, 90],
              [1697, 70, 70], [1701, 70, 70], [1702, 70, 70], [1704, 50, 60], [1705, 70, 70], [1706, 50, 60],
              [1707, 120, 90], [1709, 30, 45], [1711, 70, 70], [1713, 50, 60], [1715, 120, 90], [1717, 70, 70],
              [1720, 4.58, 3.57], [1722, 120, 90], [1724, 31.04, 29.1], [1726, 120, 90], [1728, 120, 90],
              [1729, 36.89, 30.28], [1730, 70, 70], [1734, 22.97, 21.82], [1737, 70, 70], [1739, 32.24, 21.39],
              [1740, 50, 60], [1741, 70, 70], [1742, 120, 90], [1743, 70, 70], [1744, 48.44, 41.98],
              [1745, 55.29, 18.61], [1746, 70, 70], [1748, 109.42, 45.47], [1749, 50, 60], [1750, 70, 70],
              [1752, 120, 90], [1753, 25.17, 15.07], [1754, 120, 90], [1756, 47.81, 29.86], [1757, 70, 70],
              [1758, 32.24, 21.39], [1760, 70, 70], [1763, 43.44, 47.84], [1764, 70, 70], [1765, 50, 60],
              [1766, 120, 90], [1767, 120, 90], [1769, 70, 70], [1770, 70, 70], [1771, 19.39, 23.78],
              [1772, 25.48, 41.18], [1773, 50, 60], [1774, 17.87, 21.37], [1775, 70, 70], [1776, 35.63, 37.22],
              [1778, 120, 90], [1779, 70, 70], [1780, 37.79, 33.06], [1781, 113.83, 52.58], [1783, 120, 90],
              [1784, 70, 70], [1785, 120, 90], [1786, 120, 90], [1787, 120, 90], [1788, 120, 90], [1789, 120, 90],
              [1790, 48.09, 38.27], [1792, 25.36, 24.69], [1793, 70, 70], [1794, 70, 70], [1795, 9.04, 6.4],
              [1796, 50, 60], [1797, 70, 70], [1798, 70, 70], [1799, 4.8, 5.01], [1800, 15.42, 8.83], [1801, 70, 70],
              [1802, 120, 90], [1803, 120, 90], [1804, 105.47, 52.76], [1805, 50, 60], [1806, 120, 90], [1808, 70, 70],
              [1809, 120, 90], [1810, 50, 60], [1811, 120, 90], [1812, 43.07, 42.87], [1814, 40, 50],
              [1815, 17.45, 9.13], [1816, 83.79, 61.8], [1817, 70, 70], [1818, 27.25, 18.05], [1819, 70, 70],
              [1822, 70, 70], [1824, 70, 70], [1825, 50.4, 52.17], [1827, 70, 70], [1829, 120, 90], [1832, 70, 70],
              [1833, 120, 90], [1834, 120, 90], [1837, 120, 90], [1839, 70, 70], [1841, 70, 70], [1843, 14.6, 13.38],
              [1844, 30, 45], [1845, 20.52, 19.97], [1846, 120, 90], [1847, 50, 60], [1848, 66.18, 60.25],
              [1849, 120, 90], [1850, 8.32, 6.64], [1851, 120, 90], [1852, 70, 70], [1853, 120, 90], [1855, 120, 90],
              [1856, 30, 45], [1857, 70, 70], [1859, 120, 90], [1860, 120, 90], [1863, 18.35, 13.66], [1864, 120, 90],
              [1866, 70, 70], [1868, 35.02, 25.49], [1869, 40, 37.5], [1870, 32.24, 21.39], [1873, 70, 70],
              [1875, 50, 60], [1876, 35.35, 35.59], [1877, 120, 90], [1879, 43.02, 40.39], [1881, 50, 60],
              [1882, 104.15, 43.17], [1883, 120, 90], [1884, 50, 60], [1885, 70, 70], [1886, 50, 60], [1887, 70, 70],
              [1888, 120, 90], [1889, 70, 70], [1890, 120, 90], [1891, 50, 60], [1892, 70, 70], [1894, 50, 60],
              [1895, 50, 60], [1896, 120, 90], [1897, 18.91, 17.19], [1898, 12.47, 7.24], [1899, 70, 70],
              [1900, 20, 25], [1901, 27.52, 29.78], [1903, 70, 70], [1904, 120, 90], [1906, 20.9, 12.43],
              [1909, 120, 90], [1910, 120, 90], [1912, 70, 70], [1914, 120, 90], [1915, 120, 90], [1916, 120, 90],
              [1917, 120, 90], [1919, 120, 90], [1920, 70, 70], [1921, 30, 45], [1924, 120, 90], [1925, 59.83, 43.65],
              [1928, 120, 90], [1929, 6.5, 4.93], [1930, 10.76, 8.15], [1933, 12.42, 12.39], [1937, 70, 70],
              [1938, 120, 90], [1940, 120, 90], [1941, 120, 90], [1945, 45.16, 27.63], [1946, 70, 70], [1948, 120, 90],
              [1949, 120, 90], [1950, 120, 90], [1952, 92.32, 71.14], [1955, 70, 70], [1956, 40, 50], [1957, 70, 70],
              [1959, 120, 90], [1961, 120, 90], [1962, 40, 50], [1963, 7.89, 5.56], [1964, 50, 60], [1965, 50, 60],
              [1967, 32.24, 21.39], [1969, 70, 70], [1972, 11.39, 7.39], [1974, 70, 70], [1976, 14.59, 10.01],
              [1978, 120, 90], [1979, 50, 60], [1980, 120, 90], [1981, 70, 70], [1982, 70, 70], [1984, 70, 70],
              [1986, 120, 90], [1989, 50, 60], [1991, 18.88, 13.68], [1992, 50, 60], [1995, 39.6, 34.17],
              [1996, 120, 90], [1997, 120, 90], [1998, 8.45, 8.42], [2000, 32.3, 7.9], [2001, 120, 90], [2002, 50, 60],
              [2004, 8.73, 6.08], [2005, 50, 60], [2006, 34.13, 29.15], [2007, 70, 70], [2008, 70, 70], [2009, 120, 90],
              [2011, 120, 90], [2012, 70, 70], [2013, 70, 70], [2015, 50, 60], [2016, 50, 60], [2017, 40, 37.5],
              [2018, 70, 70], [2020, 32.24, 21.39], [2021, 91.08, 54.55], [2022, 120, 90], [2023, 12.93, 13.98],
              [2025, 47.08, 35.03], [2026, 122.65, 67.48], [2027, 120, 90], [2028, 120, 90], [2029, 30.65, 35.97],
              [2030, 50, 60], [2031, 6.44, 5.98], [2032, 120, 90], [2034, 120, 90], [2035, 70, 70], [2038, 120, 90],
              [2040, 120, 90], [2041, 120, 90], [2042, 25.88, 9.57], [2043, 70, 70], [2044, 120, 90], [2046, 50, 60],
              [2048, 70, 70], [2049, 70, 70], [2050, 70, 70], [2051, 120, 90], [2052, 120, 90], [2053, 70, 70],
              [2054, 40, 50], [2055, 70, 70], [2056, 50, 60], [2057, 120, 90], [2058, 9.96, 8.92], [2059, 14.88, 8.19],
              [2060, 70, 70], [2061, 70, 70], [2062, 120, 90], [2063, 50, 60], [2064, 61.23, 37.87], [2066, 120, 90],
              [2068, 70, 70], [2070, 21.34, 9.3], [2071, 120, 90], [2072, 120, 90], [2073, 120, 90], [2074, 70, 70],
              [2075, 70, 70], [2076, 70, 70], [2077, 120, 90], [2081, 57.1, 44.75], [2083, 120, 90],
              [2084, 23.59, 36.63], [2085, 9.03, 8.79], [2086, 40, 50], [2087, 70, 70], [2089, 0, 0], [2090, 120, 90],
              [2091, 120, 90], [2095, 70, 70], [2096, 120, 90], [2097, 50, 60], [2098, 40, 50], [2099, 89.29, 46.57],
              [2100, 70, 70], [2101, 70, 70], [2103, 12.45, 12.74], [2104, 111.3, 45.15], [2105, 120, 90],
              [2106, 50, 60], [2107, 120, 90], [2109, 120, 90], [2110, 40, 50], [2112, 70, 70], [2115, 70, 70],
              [2116, 50, 60], [2118, 120, 90], [2119, 16.05, 9.74], [2121, 120, 90], [2122, 70, 70], [2125, 120, 90],
              [2126, 50, 60], [2127, 44.84, 32.36], [2128, 29.14, 12.62], [2130, 120, 90], [2131, 120, 90],
              [2132, 19.44, 13.59], [2134, 70, 70], [2135, 50, 60], [2136, 70, 70], [2137, 70, 70],
              [2138, 38.63, 26.61], [2139, 70, 70], [2140, 50, 60], [2142, 70, 70], [2144, 120, 90], [2146, 70, 70],
              [2147, 120, 90], [2148, 70, 70], [2149, 120, 90], [2150, 120, 90], [2151, 62.81, 37.98], [2152, 120, 90],
              [2154, 120, 90], [2155, 120, 90], [2156, 70, 70], [2159, 120, 90], [2161, 50, 60], [2162, 34.02, 34.24],
              [2163, 120, 90], [2164, 50, 60], [2165, 50, 60], [2166, 35.02, 25.49], [2167, 10.33, 10.88],
              [2169, 70, 70], [2170, 50.17, 28.05], [2171, 120, 90], [2174, 40.28, 40.83], [2177, 8.15, 8.97],
              [2178, 70, 70], [2179, 70, 70], [2180, 14.38, 10.62], [2181, 58.9, 76.35], [2182, 120, 90],
              [2184, 40, 50], [2186, 50, 60], [2187, 120, 90], [2190, 70, 70], [2191, 120, 90], [2197, 120, 90],
              [2198, 40, 50], [2199, 120, 90], [2200, 70, 70], [2201, 23.77, 27.53], [2203, 12.12, 8.84],
              [2204, 14.98, 8.4], [2205, 120, 90], [2208, 81.25, 48.76], [2212, 70, 70], [2213, 50, 60], [2214, 20, 25],
              [2216, 34.36, 17.02], [2217, 120, 90], [2219, 120, 90], [2220, 37.11, 22.57], [2223, 40, 50],
              [2224, 29.41, 34.07], [2225, 50, 60], [2226, 120, 90], [2227, 39.22, 33.66], [2228, 50, 60],
              [2230, 120, 90], [2231, 120, 90], [2232, 17.94, 39.15], [2233, 34.95, 29.11], [2235, 50, 60],
              [2236, 26.79, 29.04], [2237, 120, 90], [2238, 26.85, 29.25], [2239, 21.85, 11.47], [2240, 120, 90],
              [2241, 14.63, 9.52], [2242, 70, 70], [2243, 120, 90], [2244, 70, 70], [2245, 70, 70], [2247, 50, 60],
              [2248, 16, 20], [2249, 120, 90], [2250, 50, 60], [2252, 70, 70], [2253, 14.51, 10.23], [2254, 70, 70],
              [2255, 22.3, 61.32], [2256, 70, 70], [2258, 42.22, 34.38], [2259, 2, 2], [2260, 70, 70], [2262, 70, 70],
              [2265, 120, 90], [2267, 10.9, 7.43], [2268, 120, 90], [2269, 70, 70], [2270, 120, 90], [2271, 9.23, 6.76],
              [2273, 70, 70], [2274, 70, 70], [2277, 50, 60], [2280, 8.57, 5.83], [2281, 120, 90], [2282, 70, 70],
              [2283, 120, 90], [2284, 70, 70], [2285, 40, 50], [2286, 70, 70], [2289, 120, 90], [2290, 120, 90],
              [2292, 120, 90], [2293, 109.99, 52.3], [2294, 50, 60], [2295, 120, 90], [2297, 153.15, 64.3],
              [2300, 50, 60], [2301, 70, 70], [2302, 120, 90], [2303, 56.37, 41.39], [2304, 70, 70], [2305, 120, 90],
              [2306, 50, 60], [2307, 70, 70], [2311, 70, 70], [2312, 33.27, 33.84], [2314, 120, 90], [2316, 70, 70],
              [2317, 120, 90], [2319, 50, 60], [2320, 8.59, 9.12], [2321, 120, 90], [2323, 70, 70], [2325, 120, 90],
              [2326, 120, 90], [2327, 120, 90], [2328, 70, 70], [2332, 120, 90], [2335, 85.28, 79.59], [2336, 120, 90],
              [2337, 120, 90], [2338, 32.24, 21.39], [2339, 120, 90], [2340, 120, 90], [2341, 70, 70], [2342, 70, 70],
              [2343, 70, 70], [2345, 40, 50], [2346, 70, 70], [2347, 120, 90], [2348, 70, 70], [2349, 70, 70],
              [2352, 50, 60], [2356, 226.56, 56.42], [2359, 50, 60], [2363, 50, 60], [2364, 32.24, 21.39],
              [2366, 50, 60], [2367, 59.45, 50.23], [2368, 70, 70], [2371, 70, 70], [2372, 30, 45], [2373, 70, 70],
              [2374, 14.36, 11.08], [2375, 120, 90], [2378, 47.63, 26.72], [2382, 70, 70], [2383, 96.19, 48.48],
              [2384, 30, 45], [2385, 70, 70], [2387, 40, 50], [2388, 70, 70], [2390, 120, 90], [2391, 70, 70],
              [2392, 8.47, 8.48], [2394, 50, 60], [2396, 120, 90], [2397, 120, 90], [2398, 120, 90], [2399, 120, 90],
              [2401, 9.42, 9.69], [2402, 70, 70], [2404, 120, 90], [2405, 22.61, 36.11], [2406, 120, 90],
              [2407, 120, 90], [2408, 50, 60], [2409, 50, 60], [2410, 70, 70], [2411, 9.59, 8.49], [2412, 6.63, 7.08],
              [2413, 120, 90], [2414, 8.64, 7.09], [2416, 120, 90], [2420, 120, 90], [2423, 70, 70], [2424, 120, 90],
              [2425, 70, 70], [2428, 10.11, 12.8], [2429, 70, 70], [2430, 70, 70], [2433, 70, 70], [2434, 120, 90],
              [2435, 40, 50], [2436, 70, 70], [2437, 16.17, 13.35], [2438, 120, 90], [2439, 70, 70], [2440, 5.64, 5.78],
              [2441, 120, 90], [2442, 120, 90], [2443, 70, 70], [2444, 120, 90], [2447, 25.21, 17.4], [2448, 120, 90],
              [2449, 35.02, 25.49], [2452, 70, 70], [2454, 120, 90], [2456, 70, 70], [2458, 50, 60],
              [2459, 32.63, 40.69], [2460, 70, 70], [2462, 120, 90], [2463, 40, 50], [2465, 120, 90], [2466, 120, 90],
              [2467, 70, 70], [2468, 40, 50], [2470, 120, 90], [2471, 120, 90], [2472, 78.4, 34.97], [2473, 120, 90],
              [2474, 120, 90], [2475, 70, 70], [2476, 120, 90], [2477, 70, 70], [2478, 120, 90], [2479, 50, 60],
              [2480, 33.47, 21.67], [2481, 50, 60], [2482, 120, 90], [2483, 120, 90], [2484, 120, 90], [2485, 50, 60],
              [2486, 70, 70], [2487, 70, 70], [2488, 53.21, 52.23], [2490, 70, 70], [2493, 104.76, 45.88],
              [2494, 57.1, 29.4], [2495, 40, 50], [2496, 120, 90], [2497, 40.2, 11.31], [2499, 17.64, 11.45],
              [2500, 14.55, 14.52], [2501, 70, 70], [2502, 50, 60], [2503, 50, 60], [2504, 120, 90], [2505, 70, 70],
              [2507, 120, 90], [2508, 70, 70], [2509, 70, 70], [2510, 70, 70], [2511, 35.02, 25.49], [2512, 120, 90],
              [2513, 120, 90], [2514, 120, 90], [2515, 50, 60], [2516, 40.7, 39.93], [2518, 74.82, 43.44],
              [2519, 35.02, 25.49], [2520, 70, 70], [2521, 50, 60], [2524, 50, 60], [2525, 70, 70], [2526, 70, 70],
              [2527, 49.14, 44.47], [2528, 120, 90], [2529, 70, 70], [2530, 70, 70], [2532, 70, 70],
              [2533, 23.69, 46.33], [2534, 120, 90], [2535, 5.8, 6.5], [2536, 6.37, 5.06], [2537, 120, 90],
              [2539, 70, 70], [2540, 40.04, 38.42], [2542, 34.79, 22.79], [2543, 40, 50], [2545, 40, 50],
              [2546, 70, 70], [2547, 70, 70], [2548, 70, 70], [2549, 70, 70], [2551, 71.76, 36.27], [2553, 70, 70],
              [2554, 70, 70], [2555, 52.5, 52.5], [2558, 40, 50], [2562, 111.85, 42.43], [2563, 70, 70],
              [2564, 40.56, 78.59], [2565, 40, 50], [2566, 10.44, 11.25], [2568, 50, 60], [2569, 50, 60],
              [2571, 50, 60], [2572, 120, 90], [2574, 107.79, 57.67], [2575, 70, 70], [2576, 70, 70],
              [2577, 30.15, 21.64], [2578, 70, 70], [2580, 120, 90], [2582, 70, 70], [2584, 120, 90], [2585, 70, 70],
              [2587, 66.78, 50.99], [2589, 70, 70], [2590, 120, 90], [2591, 120, 90], [2592, 120, 90],
              [2593, 109.49, 44.64], [2595, 70, 70], [2596, 120, 90], [2597, 40, 50], [2598, 70, 70], [2600, 50, 60],
              [2601, 70, 70], [2603, 120, 90], [2604, 14.91, 16.67], [2606, 18.48, 15.38], [2607, 14.85, 16.55],
              [2608, 70, 70], [2610, 70, 70], [2612, 19.02, 24.51], [2613, 35.02, 25.49], [2615, 80.55, 54.14],
              [2617, 17.59, 35.03], [2619, 57.48, 50.98], [2620, 50, 60], [2621, 120, 90], [2622, 22.29, 20.66],
              [2623, 36.98, 28.35], [2624, 35.02, 25.49], [2627, 70, 70], [2628, 47.2, 82.28], [2630, 120, 90],
              [2631, 70, 70], [2632, 22.83, 26.19], [2633, 36.95, 67.11], [2634, 120, 90], [2635, 70, 70],
              [2636, 70, 70], [2638, 70, 70], [2639, 10.59, 10.5], [2642, 120, 90], [2644, 71.93, 71.93],
              [2646, 30, 45], [2647, 51.91, 54.1], [2649, 50, 60], [2650, 120, 90], [2651, 40, 50], [2652, 37.5, 45],
              [2653, 70, 70], [2655, 40, 50], [2656, 69.06, 43.42], [2658, 40.97, 26.68], [2660, 40, 50],
              [2661, 70, 70], [2663, 50, 60], [2664, 120, 90], [2665, 70, 70], [2667, 63.81, 52.19],
              [2668, 39.53, 31.14], [2669, 120, 90], [2670, 70, 70], [2671, 50, 45], [2672, 70, 70], [2677, 70, 70],
              [2681, 70, 70], [2682, 120, 90], [2683, 11.9, 7.65], [2684, 70.83, 69.48], [2685, 50, 60],
              [2686, 9.12, 8.59], [2687, 94.14, 34.56], [2691, 50, 60], [2692, 70, 70], [2694, 35.02, 25.49],
              [2695, 70, 70], [2696, 32.24, 21.39], [2697, 120, 90], [2698, 70, 70], [2703, 50, 60],
              [2704, 15.95, 11.19], [2706, 120, 90], [2707, 70, 70], [2708, 120, 90], [2710, 22.67, 16.2],
              [2711, 50, 60], [2712, 70, 70], [2713, 70, 70], [2714, 50, 60], [2716, 70, 70], [2719, 70, 70],
              [2720, 120, 90], [2722, 120, 90], [2723, 70, 70], [2725, 70, 70], [2726, 70, 70], [2728, 35.02, 25.49],
              [2730, 50, 60], [2731, 120, 90], [2734, 50, 60], [2735, 8.55, 9.81], [2736, 30, 45], [2737, 40, 50],
              [2738, 40, 37.5], [2739, 50, 60], [2740, 120, 90], [2741, 120, 90], [2742, 70, 70], [2743, 30.71, 32.21],
              [2746, 32.24, 21.39], [2747, 63.12, 31.83], [2748, 123.58, 59.04], [2750, 30, 45], [2752, 70, 70],
              [2753, 50, 60], [2755, 120, 90], [2756, 70, 70], [2757, 120, 90], [2758, 36.94, 36.69], [2759, 120, 90],
              [2760, 120, 90], [2762, 120, 90], [2763, 120, 90], [2764, 70, 70], [2765, 120, 90], [2766, 5.69, 6.72],
              [2767, 120, 90], [2768, 120, 90], [2770, 120, 90], [2772, 70, 70], [2773, 50, 60], [2774, 120, 90],
              [2775, 70, 70], [2778, 70, 70], [2781, 9.91, 6.13], [2782, 50, 60], [2783, 70, 70], [2784, 70, 70],
              [2785, 5.56, 14], [2786, 70, 70], [2787, 64.37, 35.05], [2788, 96.68, 56.26], [2791, 30, 37.5],
              [2792, 120, 90], [2793, 16, 20], [2795, 32.24, 21.39], [2796, 70, 70], [2797, 120, 90], [2798, 70, 70],
              [2800, 70, 70], [2801, 120, 90], [2804, 20.57, 14.3], [2806, 70, 70], [2807, 36.77, 11.92],
              [2808, 50, 60], [2809, 120, 90], [2811, 50, 60], [2813, 34.06, 29.31], [2814, 120, 90], [2818, 30, 45],
              [2819, 11.84, 8.58], [2820, 120, 90], [2821, 70, 70], [2822, 40, 50], [2823, 59.27, 44.08],
              [2826, 40, 50], [2827, 21.89, 30.71], [2831, 120, 90], [2832, 70, 70], [2833, 120, 90], [2834, 50, 60],
              [2835, 37.5, 45], [2836, 36.81, 31.39], [2837, 120, 90], [2838, 120, 90], [2839, 120, 90],
              [2841, 120, 90], [2844, 70, 70], [2845, 120, 90], [2846, 120, 90], [2847, 30, 45], [2850, 20.67, 13.88],
              [2851, 75.14, 53.01], [2852, 37.5, 45], [2853, 70, 70], [2854, 25.17, 19.72], [2856, 124.74, 77.59],
              [2857, 35.02, 25.49], [2861, 70, 70], [2862, 70, 70], [2863, 70, 70], [2864, 120, 90], [2865, 120, 90],
              [2866, 50, 60], [2867, 120, 90], [2869, 5.93, 4.86], [2871, 120, 90], [2872, 31.07, 14.75],
              [2876, 101.18, 75.84], [2877, 120, 90], [2878, 120, 90], [2879, 50, 60], [2880, 39, 52.5],
              [2882, 120, 90], [2883, 70, 70], [2884, 70.14, 48.85], [2885, 70, 70], [2886, 70, 70], [2887, 70, 70],
              [2889, 70, 70], [2890, 120, 90], [2891, 120, 90], [2893, 120, 90], [2894, 120, 90], [2897, 120, 90],
              [2899, 70, 70], [2900, 20.67, 13.88], [2901, 120, 90], [2902, 120, 90], [2903, 120, 90], [2904, 120, 90],
              [2905, 50, 60], [2906, 120, 90], [2907, 16.83, 17.5], [2908, 50, 60], [2910, 49.02, 40.47],
              [2911, 120, 90], [2914, 70, 70], [2916, 70, 70], [2917, 20.67, 13.88], [2918, 17.8, 10.33],
              [2919, 120, 90], [2921, 120, 90], [2922, 50, 60], [2923, 26.73, 30.82], [2924, 120, 90], [2925, 120, 90],
              [2928, 70, 70], [2929, 50.7, 47.79], [2930, 120, 90], [2931, 70, 70], [2932, 120, 90], [2933, 70, 70],
              [2934, 85.78, 39.36], [2935, 120, 90], [2936, 90.08, 68.66], [2937, 120, 90], [2940, 120, 90],
              [2942, 70, 70], [2943, 120, 90], [2944, 50, 60], [2946, 117.5, 74.87], [2948, 50, 60],
              [2950, 110.01, 49.26], [2951, 120, 90], [2952, 120, 90], [2955, 70, 70], [2956, 70, 70], [2957, 120, 90],
              [2958, 50, 60], [2960, 50, 60], [2961, 50, 60], [2962, 40, 50], [2963, 120, 90], [2964, 50, 60],
              [2965, 120, 90], [2969, 15.24, 25.59], [2971, 70, 70], [2972, 120, 90], [2973, 120, 90],
              [2974, 22.89, 34.75], [2975, 70, 70], [2976, 120, 90], [2978, 24.61, 18.48], [2979, 70, 70],
              [2980, 120, 90], [2982, 40, 50], [2984, 15.43, 13.81], [2985, 50, 60], [2986, 35.02, 25.49],
              [2988, 120, 90], [2989, 50, 60], [2991, 50, 60], [2995, 36.26, 41.54], [2997, 12.34, 10.34],
              [2998, 70, 70], [2999, 7.91, 8.83], [3000, 50, 60], [3001, 70, 70], [3002, 120, 90], [3003, 120, 90],
              [3004, 120, 90], [3006, 70, 70], [3008, 70, 70], [3009, 50, 60], [3011, 13.6, 28.86], [3012, 70, 70],
              [3014, 120, 90], [3015, 30, 37.5], [3016, 22.14, 18.78], [3017, 120, 90], [3019, 50, 60], [3022, 120, 90],
              [3024, 70, 70], [3025, 70, 70], [3026, 21.48, 22.87], [3027, 22, 43.41], [3031, 20.67, 13.88],
              [3033, 120, 90], [3035, 29.76, 27.35], [3037, 50, 60], [3041, 52.5, 52.5], [3042, 10.27, 8.48],
              [3043, 70, 70], [3044, 70, 70], [3045, 120, 90], [3046, 120, 90], [3047, 50, 60], [3048, 101.09, 97.17],
              [3049, 120, 90], [3050, 27.97, 29.63], [3051, 120, 90], [3052, 70, 70], [3053, 70, 70], [3054, 50, 60],
              [3055, 120, 90], [3056, 15.98, 17.91], [3057, 70, 70], [3058, 70, 70], [3059, 120, 90], [3060, 70, 70],
              [3061, 128.24, 46.52], [3063, 70, 70], [3064, 70, 70], [3066, 50, 60], [3069, 35.02, 25.49],
              [3070, 56.43, 49.17], [3073, 120, 90], [3076, 120, 90], [3077, 39.42, 34.65], [3078, 70, 70],
              [3079, 70, 70], [3083, 70, 70], [3084, 70, 70], [3085, 50, 60], [3086, 97.92, 38.7], [3087, 70, 70],
              [3089, 43.11, 25.75], [3090, 50, 60], [3091, 19.67, 20.1], [3092, 70, 70], [3095, 120, 90],
              [3098, 20.76, 58.98], [3100, 120, 90], [3101, 120, 90], [3102, 120, 90], [3104, 7.73, 6.59],
              [3105, 70, 70], [3106, 70, 70], [3107, 120, 90], [3109, 50, 60], [3112, 79.98, 40.43], [3113, 70, 70],
              [3114, 120, 90], [3115, 120, 90], [3117, 50, 60], [3118, 120, 90], [3119, 40, 50], [3121, 69.55, 32.33],
              [3122, 63.25, 33.78], [3123, 120, 90], [3125, 120, 90], [3126, 70, 70], [3127, 9.37, 9.65],
              [3128, 120, 90], [3129, 37.84, 31.71], [3130, 40, 50], [3131, 8.89, 9.07], [3132, 120, 90],
              [3133, 72.02, 36.75], [3134, 50, 45], [3135, 120, 90], [3136, 40, 50], [3137, 12.56, 13.35],
              [3138, 120, 90], [3139, 10.29, 7.91], [3140, 70, 70], [3141, 50, 60], [3142, 40, 50], [3143, 70, 70],
              [3144, 120, 90], [3148, 33.08, 29.22], [3149, 120, 90], [3151, 120, 90], [3152, 50, 60], [3153, 70, 70],
              [3154, 87.45, 60.56], [3155, 98.27, 51.32], [3158, 120, 90], [3160, 37.27, 60.05], [3161, 20.3, 19.5],
              [3163, 70, 70], [3164, 70, 70], [3165, 70, 54.11], [3166, 15, 20], [3167, 69.49, 38], [3168, 120, 90],
              [3171, 50, 60], [3172, 120, 90], [3175, 73.26, 36.41], [3177, 37.5, 45], [3181, 8.14, 6.4],
              [3182, 22.27, 15.36], [3183, 40, 50], [3184, 70, 70], [3186, 40, 50], [3187, 120, 90],
              [3188, 14.43, 16.56], [3189, 192.54, 70.66], [3190, 40, 50], [3191, 70, 70], [3192, 120, 90],
              [3195, 22.52, 19.08], [3196, 70, 70], [3197, 99.63, 37.69], [3198, 50, 60], [3199, 70, 70],
              [3200, 40, 50], [3203, 12.22, 11.28], [3206, 36.81, 46.42], [3207, 50, 60], [3208, 120, 90],
              [3211, 50, 60], [3212, 120, 90], [3214, 70, 70], [3216, 120, 90], [3217, 34.82, 34.71],
              [3219, 10.87, 12.56], [3220, 120, 90], [3221, 70, 70], [3225, 8.05, 7.89], [3227, 70, 70],
              [3228, 34.26, 35.61], [3229, 35.02, 25.49], [3231, 26.42, 28.94], [3234, 37.45, 21.3], [3239, 120, 90],
              [3240, 120, 90], [3241, 50, 60], [3242, 70, 70], [3243, 12.14, 9.5], [3244, 120, 90],
              [3246, 65.38, 60.87], [3247, 120, 90], [3248, 50, 60], [3249, 120, 90], [3251, 40, 50], [3252, 50, 60],
              [3253, 70, 70], [3254, 50, 60], [3255, 70, 70], [3256, 30.27, 22.34], [3257, 50, 60], [3258, 70, 70],
              [3259, 50, 60], [3260, 20, 25], [3262, 70, 70], [3263, 120, 90], [3264, 13.13, 23.21], [3265, 120, 90],
              [3266, 70, 70], [3267, 50, 60], [3268, 59.2, 40.69], [3270, 21.48, 22.87], [3271, 35.02, 25.49],
              [3272, 106.83, 78.93], [3273, 120, 90], [3274, 50, 60], [3275, 120, 90], [3276, 35.02, 25.49],
              [3277, 91.74, 42.99], [3278, 70, 70], [3279, 32.24, 21.39], [3280, 59.87, 41.55], [3283, 12.69, 12.13],
              [3284, 42.57, 30.98], [3286, 15.7, 9.65], [3287, 50, 60], [3288, 50, 60], [3289, 120, 90], [3290, 70, 70],
              [3292, 120, 90], [3293, 70, 70], [3294, 20.67, 13.88], [3295, 120, 90], [3296, 30, 45], [3300, 70, 70],
              [3301, 70, 70], [3302, 70, 70], [3303, 70, 70], [3305, 120, 90], [3306, 32.44, 29.79], [3308, 70, 70],
              [3309, 50, 45], [3312, 70, 70], [3313, 120, 90], [3314, 50, 60], [3315, 120, 90], [3316, 120, 90],
              [3318, 70, 70], [3319, 70, 70], [3320, 120, 90], [3321, 50, 60], [3322, 120, 90], [3323, 40, 50],
              [3324, 70, 70], [3325, 40, 50], [3326, 51.15, 39.66], [3327, 120, 90], [3328, 120, 90],
              [3329, 8.87, 8.14], [3331, 108.09, 47.79], [3332, 120, 90], [3333, 120, 90], [3334, 14.53, 16.63],
              [3335, 70, 70], [3336, 46.22, 26.88], [3338, 70, 70], [3340, 50, 60], [3341, 24.19, 14.72],
              [3342, 32.24, 21.39], [3343, 120, 90], [3344, 99.81, 58.02], [3346, 62.21, 43.82], [3347, 120, 90],
              [3348, 70, 70], [3350, 35.02, 25.49], [3351, 35.02, 25.49], [3353, 120, 90], [3354, 50, 60],
              [3357, 12.58, 12.94], [3358, 19.2, 17.45], [3359, 120, 90], [3361, 120, 90], [3363, 14.08, 11.88],
              [3364, 70, 70], [3366, 120, 90], [3367, 50, 60], [3369, 120, 90], [3370, 70, 70], [3371, 70, 70],
              [3372, 70, 70], [3376, 35.02, 25.49], [3378, 9.02, 8.54], [3380, 120, 90], [3381, 120, 90],
              [3382, 23.2, 25.03], [3384, 120, 90], [3386, 120, 90], [3387, 70, 70], [3388, 120, 90], [3389, 70, 70],
              [3390, 120, 90], [3391, 120, 90], [3392, 120, 90], [3393, 120, 90], [3394, 120, 90], [3396, 31.22, 33.2],
              [3399, 70, 70], [3400, 40, 50], [3402, 120, 90], [3403, 16.87, 10.26], [3404, 41.37, 52.15],
              [3407, 59.05, 33.48], [3408, 35.02, 25.49], [3411, 70, 70], [3414, 50, 60], [3415, 40, 50],
              [3416, 40, 50], [3417, 70, 70], [3418, 120, 90], [3419, 70, 70], [3420, 70, 70], [3422, 50.99, 25.75],
              [3423, 120, 90], [3424, 37.5, 45], [3426, 120, 90], [3428, 70, 70], [3429, 46.45, 44.76], [3431, 120, 90],
              [3432, 70, 70], [3433, 70, 70], [3434, 6.86, 5.46], [3436, 50, 60], [3437, 70, 70], [3438, 70, 70],
              [3439, 60.72, 58.05], [3440, 50, 60], [3441, 59.78, 46.81], [3442, 42.15, 37.9], [3444, 30, 45],
              [3445, 70, 70], [3448, 5.56, 6.38], [3449, 70, 70], [3450, 70, 70], [3451, 120, 90], [3452, 120, 90],
              [3453, 15.33, 23.54], [3454, 18.63, 15.82], [3456, 120, 90], [3457, 120, 90], [3459, 120, 90],
              [3461, 70, 70], [3462, 70, 24.96], [3463, 120, 90], [3464, 120, 90], [3468, 73.94, 42.49],
              [3469, 34.89, 19.21], [3471, 70, 70], [3473, 22.49, 13.06], [3474, 70, 70], [3476, 40, 50],
              [3480, 120, 90], [3481, 70, 70], [3482, 32.24, 21.39], [3483, 70, 70], [3484, 120, 90], [3485, 50, 60],
              [3487, 20.67, 13.88], [3488, 50, 60], [3489, 40, 50], [3492, 120, 90], [3493, 70, 70], [3494, 40, 50],
              [3496, 120, 90], [3497, 120, 90], [3498, 40, 50], [3499, 120, 90], [3501, 120, 90], [3503, 120, 90],
              [3504, 70, 70], [3505, 120, 90], [3508, 120, 90], [3509, 50, 60], [3510, 120, 90], [3511, 70, 70],
              [3514, 50, 60], [3515, 70, 70], [3516, 120, 90], [3517, 70, 70], [3518, 120, 90], [3519, 50, 60],
              [3520, 120, 90], [3521, 120, 90], [3523, 35.02, 25.49], [3525, 120, 90], [3527, 120, 90], [3530, 70, 70],
              [3531, 70.97, 39.98], [3534, 70, 70], [3535, 30, 45], [3537, 120, 90], [3539, 120, 90],
              [3541, 42.81, 43.65], [3543, 120, 90], [3545, 120, 90], [3546, 35.02, 25.49], [3549, 22.69, 14.46],
              [3551, 120, 90], [3553, 70, 70], [3554, 50, 60], [3555, 40, 50], [3557, 16.81, 25.35], [3558, 70, 70],
              [3559, 50, 60], [3560, 120, 90], [3561, 120, 90], [3564, 120, 90], [3566, 17.61, 17.41],
              [3568, 12.22, 9.98], [3569, 50, 60], [3570, 70, 70], [3571, 70, 70], [3572, 120, 90], [3573, 120, 90],
              [3575, 120, 90], [3576, 120, 90], [3577, 120, 90], [3579, 40, 50], [3580, 70, 70], [3581, 120, 90],
              [3582, 4.45, 5.68], [3583, 120, 90], [3585, 70, 70], [3586, 70, 70], [3587, 70, 70], [3588, 120, 90],
              [3589, 70, 70], [3590, 40, 50], [3592, 70, 70], [3593, 70, 70], [3594, 120, 90], [3595, 120, 90],
              [3596, 35.02, 25.49], [3597, 70, 70], [3598, 22.96, 24.32], [3599, 120, 90], [3600, 70, 70],
              [3601, 40, 50], [3602, 51.79, 46.05], [3606, 40, 50], [3607, 70, 70], [3608, 33.57, 26.7],
              [3609, 120, 90], [3610, 50, 60], [3611, 70, 70], [3612, 70, 70], [3613, 40, 50], [3614, 9.76, 9.91],
              [3615, 70, 70], [3617, 70, 70], [3619, 70, 70], [3620, 50, 60], [3621, 50, 60], [3622, 120, 90],
              [3623, 120, 90], [3624, 18.29, 11.74], [3626, 120, 90], [3627, 120, 90], [3628, 30, 45],
              [3629, 32.24, 21.39], [3631, 70, 70], [3632, 47.16, 37.74], [3633, 70, 70], [3634, 24.1, 17.24],
              [3635, 50, 60], [3636, 70, 70], [3637, 40, 50], [3639, 120, 90], [3641, 40, 50], [3642, 58.18, 27.21],
              [3643, 70, 70], [3644, 36.34, 36.78], [3647, 120, 90], [3648, 70, 70], [3649, 120, 90],
              [3650, 93.96, 49.61], [3651, 40, 50], [3652, 40, 50], [3653, 52.81, 42.1], [3656, 16.63, 13.83],
              [3657, 40, 50], [3659, 120, 90], [3661, 49.38, 28.07], [3662, 30, 45], [3663, 120, 90], [3665, 120, 90],
              [3666, 35.02, 25.49], [3667, 30.55, 36.38], [3668, 120, 90], [3669, 50, 60], [3670, 91.39, 52.48],
              [3671, 120, 90], [3674, 70, 70], [3675, 120, 90], [3676, 120, 90], [3677, 50, 60], [3678, 6.48, 4.68],
              [3679, 29.5, 43.67], [3681, 70, 70], [3683, 70, 70], [3685, 120, 90], [3686, 35.02, 25.49],
              [3687, 70, 70], [3688, 120, 90], [3690, 120, 90], [3691, 14.78, 14.29], [3692, 50, 60], [3694, 70, 70],
              [3695, 35.02, 25.49], [3696, 70, 70], [3697, 20, 24], [3698, 120, 90], [3700, 25.38, 59.21],
              [3701, 40, 50], [3702, 18.29, 11.85], [3703, 175.88, 66.13], [3705, 14.08, 13.22], [3707, 70, 70],
              [3708, 70, 70], [3710, 50, 60], [3711, 15.93, 11.6], [3713, 70, 70], [3714, 120, 90], [3716, 120, 90],
              [3718, 70, 70], [3719, 35.02, 25.49], [3720, 50, 60], [3722, 40, 50], [3723, 30, 45],
              [3724, 12.29, 14.45], [3726, 70, 70], [3728, 120, 90], [3729, 120, 90], [3731, 120, 90], [3733, 120, 90],
              [3738, 30, 45], [3741, 120, 90], [3744, 120, 90], [3745, 120, 90], [3747, 33.24, 30.21], [3748, 120, 90],
              [3749, 35.02, 25.49], [3751, 27.22, 22.15], [3752, 120, 90], [3753, 50, 60], [3754, 120, 90],
              [3755, 31.04, 34.22], [3756, 120, 90], [3757, 70, 70], [3758, 120, 90], [3759, 120, 90],
              [3761, 36.17, 17.01], [3762, 50, 60], [3763, 70, 70], [3764, 50, 60], [3765, 36.87, 29.24],
              [3766, 50, 60], [3768, 70, 70], [3769, 120, 90], [3775, 50, 60], [3776, 120, 90], [3777, 64.75, 33.71],
              [3780, 70, 70], [3781, 120, 90], [3782, 33.84, 17.76], [3783, 70, 70], [3785, 35.02, 25.49],
              [3786, 50, 60], [3791, 120, 90], [3792, 120, 90], [3793, 70, 70], [3795, 28.93, 71.01],
              [3796, 34.35, 19.61], [3797, 120, 90], [3799, 50, 60], [3800, 70, 70], [3801, 120, 90], [3802, 50, 60],
              [3804, 70, 70], [3807, 23.88, 19.39], [3811, 50, 60], [3812, 120, 90], [3814, 70, 70],
              [3815, 11.6, 10.05], [3816, 120, 90], [3818, 40, 50], [3820, 50, 60], [3821, 120, 90], [3822, 120, 90],
              [3824, 70, 70], [3826, 70, 70], [3827, 104.49, 49.9], [3828, 48.71, 27.21], [3830, 8.66, 6.14],
              [3832, 58.73, 69.61], [3833, 30, 45], [3834, 82.66, 53.29], [3837, 70, 70], [3839, 120, 90],
              [3840, 120, 90], [3841, 115.85, 58.55], [3842, 50, 60], [3843, 120, 90], [3845, 16.28, 21.19],
              [3846, 70, 70], [3849, 32.24, 21.39], [3850, 120, 90], [3851, 120, 90], [3853, 35.02, 25.49],
              [3854, 20.59, 23], [3855, 120, 90], [3856, 120, 90], [3858, 120, 90], [3859, 70, 70], [3862, 70, 70],
              [3863, 50, 60], [3865, 120, 90], [3866, 15.15, 16.66], [3867, 35.02, 25.49], [3868, 120, 90],
              [3869, 16, 20], [3870, 113.75, 53.42], [3871, 46.79, 28.4], [3873, 120, 90], [3874, 41.13, 34.16],
              [3877, 40, 50], [3879, 120, 90], [3880, 19.75, 22.98], [3881, 50, 60], [3882, 120, 90],
              [3883, 57.22, 73.4], [3884, 70, 70], [3886, 70, 70], [3887, 120, 90], [3889, 70, 70], [3890, 10.56, 9.77],
              [3891, 70, 70], [3892, 70, 70], [3896, 70, 70], [3897, 46.88, 27.21], [3898, 120, 90], [3899, 120, 90],
              [3900, 50.61, 29.08], [3901, 70, 70], [3903, 50, 60], [3905, 90.98, 55.27], [3906, 70, 70],
              [3909, 120, 90], [3910, 32.24, 21.39], [3915, 30, 45], [3916, 120, 90], [3918, 8.88, 7.78],
              [3919, 120, 90], [3921, 34.37, 32.04], [3922, 120, 90], [3923, 70, 70], [3924, 14.82, 9.49],
              [3925, 120, 90], [3927, 70, 70], [3928, 19.06, 19.47], [3929, 120, 90], [3930, 70, 70], [3931, 70, 70],
              [3932, 32.72, 42.52], [3933, 120, 90], [3935, 120, 90], [3936, 120, 90], [3937, 70, 70], [3938, 50, 60],
              [3939, 50, 60], [3940, 50, 60], [3941, 120, 90], [3942, 32.24, 20.58], [3943, 16.04, 19.53],
              [3944, 35.02, 25.49], [3946, 13.42, 11.21], [3947, 120, 90], [3950, 120, 90], [3951, 120, 90],
              [3952, 120, 90], [3953, 130.15, 56.8], [3954, 120, 90], [3956, 50, 60], [3958, 13.07, 12.08],
              [3959, 107.55, 47.75], [3960, 26.79, 20.82], [3961, 10.48, 9.83], [3963, 24.93, 29.76], [3964, 70, 70],
              [3966, 70, 70], [3968, 40, 50], [3969, 73.5, 49.04], [3970, 22.45, 62.54], [3971, 120, 90],
              [3972, 120, 90], [3976, 70, 70], [3978, 70, 70], [3979, 70, 70], [3980, 50, 60], [3981, 70, 70],
              [3982, 120, 90], [3983, 30, 45], [3985, 70, 70], [3988, 120, 90], [3990, 70, 70], [3991, 120, 90],
              [3992, 53.73, 58.98], [3993, 70, 70], [3994, 120, 90], [3996, 70, 70], [3997, 120, 90], [3998, 120, 90],
              [3999, 29.09, 38.47], [4001, 120, 90], [4002, 120, 90], [4003, 70, 70], [4004, 70, 70], [4005, 40, 50],
              [4007, 120, 90], [4008, 70, 70], [4009, 40, 50], [4010, 50, 60], [4012, 120, 90], [4013, 120, 90],
              [4014, 120, 90], [4015, 120, 90], [4016, 21, 33], [4017, 70, 70], [4018, 70, 70], [4019, 40, 50],
              [4021, 70, 70], [4022, 70, 70], [4023, 27.39, 27.85], [4024, 120, 90], [4025, 70, 70], [4026, 70, 70],
              [4027, 120, 90], [4028, 70, 70], [4031, 28.52, 48.27], [4033, 70, 70], [4034, 120, 90],
              [4035, 17.68, 13.86], [4038, 120, 90], [4040, 85.79, 70.07], [4041, 120, 90], [4043, 70, 70],
              [4045, 10.74, 9.07], [4047, 44.52, 35.91], [4048, 50, 60], [4049, 70, 70], [4051, 120, 90],
              [4053, 70, 70], [4057, 50, 60], [4059, 70, 70], [4062, 70, 70], [4063, 50, 60], [4065, 50, 60],
              [4066, 70, 70], [4067, 70, 70], [4068, 120, 90], [4069, 50, 60], [4070, 70, 70], [4071, 70, 70],
              [4072, 120, 90], [4073, 30, 45], [4074, 70, 70], [4076, 120, 90], [4080, 120, 90], [4081, 120, 90],
              [4082, 120, 90], [4083, 120, 90], [4084, 14, 13.72], [4085, 70, 70], [4087, 120, 90], [4088, 120, 90],
              [4089, 120, 90], [4090, 120, 90], [4091, 70, 70], [4092, 70, 70], [4093, 120, 90], [4094, 32.24, 21.39],
              [4095, 37.45, 42.54], [4096, 37.85, 49.46], [4097, 120, 90], [4100, 50, 60], [4101, 120, 90],
              [4102, 70, 70], [4103, 70, 70], [4104, 70, 70], [4105, 120, 90], [4106, 12.41, 18.24], [4107, 120, 90],
              [4108, 120, 90], [4109, 11.09, 23.39], [4110, 70, 70], [4111, 53.38, 47.38], [4112, 40, 50],
              [4115, 120, 90], [4116, 31.55, 32.55], [4117, 50, 60], [4118, 41.47, 35.71], [4119, 35.02, 25.49],
              [4120, 27.58, 30.03], [4121, 70, 70], [4122, 120, 90], [4124, 46.81, 38.06], [4125, 70, 70],
              [4128, 70, 70], [4129, 14.49, 12.39], [4131, 16.41, 11.51], [4133, 70, 70], [4134, 79.03, 44.3],
              [4136, 50, 60], [4137, 120, 90], [4138, 11.77, 6.96], [4139, 30, 45], [4140, 70, 70], [4142, 70, 70],
              [4143, 50, 60], [4145, 120, 90], [4146, 6.49, 5.75], [4147, 120, 90], [4149, 50, 60], [4150, 70, 70],
              [4152, 106.07, 54.99], [4154, 120, 90], [4155, 70, 70], [4156, 76.31, 53.54], [4157, 70, 70],
              [4158, 120, 90], [4159, 6.8, 6.9], [4162, 120, 90], [4164, 20.48, 22.01], [4165, 120, 90], [4166, 30, 45],
              [4167, 70, 70], [4168, 37.5, 45], [4169, 35.25, 45.76], [4173, 50, 60], [4175, 40, 50], [4176, 50, 60],
              [4177, 40.07, 56.69], [4178, 120, 90], [4179, 23.41, 16.69], [4180, 14.1, 9.29], [4181, 70, 70],
              [4182, 76.84, 36.41], [4185, 27.78, 27.06], [4186, 50, 60], [4188, 120, 90], [4189, 50, 60],
              [4190, 120, 90], [4192, 50, 60], [4193, 120, 90], [4194, 120, 90], [4197, 50, 60], [4199, 78.4, 74.93],
              [4200, 13.33, 9.28], [4203, 62.98, 58.18], [4204, 50, 60], [4205, 120, 90], [4206, 40, 50],
              [4207, 50, 60], [4208, 120, 90], [4209, 120, 90], [4210, 40, 50], [4211, 120, 90], [4213, 70, 70],
              [4215, 35.02, 25.49], [4216, 120, 90], [4219, 30, 45], [4220, 120, 90], [4221, 32.24, 21.39],
              [4222, 120, 90], [4223, 9.96, 8.54], [4224, 70, 70], [4225, 120, 90], [4226, 73.7, 42.65],
              [4229, 36.01, 22.9], [4230, 70, 70], [4231, 70, 70], [4232, 40, 50], [4233, 40, 50], [4234, 50, 60],
              [4235, 13.03, 13.29], [4236, 70, 70], [4237, 120, 90], [4238, 120, 90], [4239, 120, 90], [4241, 120, 90],
              [4242, 46.74, 74.49], [4244, 11.58, 16.71], [4245, 50, 60], [4246, 23.77, 36.35], [4248, 70, 70],
              [4249, 120, 90], [4250, 120, 90], [4251, 120, 90], [4252, 11.19, 9.3], [4256, 50, 60], [4257, 40, 50],
              [4258, 50, 60], [4259, 12.25, 12.29], [4260, 120, 90], [4261, 20, 24], [4264, 13.05, 10.17],
              [4265, 70, 70], [4266, 120, 90], [4269, 120, 90], [4270, 120, 90], [4272, 98.28, 54.81], [4273, 120, 90],
              [4274, 120, 90], [4275, 70, 70], [4279, 25.11, 25.86], [4281, 70, 70], [4282, 50, 60],
              [4283, 19.15, 24.03], [4284, 120, 90], [4285, 50, 60], [4286, 120, 90], [4287, 25.96, 16.87],
              [4288, 120, 90], [4289, 64.74, 40.71], [4290, 50, 60], [4291, 50, 60], [4293, 9.17, 7.22],
              [4294, 120, 90], [4295, 120, 90], [4296, 120, 90], [4297, 70, 70], [4298, 120, 90], [4299, 70, 70],
              [4301, 70, 70], [4302, 26.64, 23.08], [4305, 70, 70], [4307, 120, 90], [4308, 120, 90], [4309, 50, 60],
              [4310, 50, 60], [4312, 70, 70], [4313, 120, 90], [4317, 50, 60], [4318, 44.5, 31.24], [4320, 70, 70],
              [4323, 30, 45], [4325, 29.6, 19.97], [4326, 40, 50], [4328, 70, 70], [4329, 24.49, 21.37], [4330, 70, 70],
              [4333, 17.64, 32.54], [4334, 120, 90], [4337, 40, 50], [4338, 19.83, 26.04], [4339, 30, 45],
              [4340, 120, 90], [4341, 120, 90], [4343, 120, 90], [4345, 64.97, 47.25], [4346, 70, 70], [4347, 120, 90],
              [4349, 19.92, 20.51], [4350, 45.83, 36.77], [4352, 27.75, 35.04], [4353, 40.7, 33.52], [4355, 120, 90],
              [4356, 40, 50], [4358, 23.24, 26.31], [4360, 70, 70], [4362, 57.64, 39.46], [4363, 70, 70],
              [4364, 60.02, 38.25], [4365, 120, 90], [4366, 70, 70], [4367, 120, 90], [4372, 70, 70], [4374, 40, 50],
              [4375, 70, 70], [4376, 120, 90], [4377, 70, 70], [4378, 70, 70], [4380, 70, 70], [4382, 70, 70],
              [4383, 70, 70], [4384, 41.7, 25.8], [4386, 70, 70], [4387, 120, 90], [4389, 70, 70], [4390, 35.02, 25.49],
              [4391, 21.62, 31.72], [4392, 70, 70], [4394, 70, 70], [4395, 70, 70], [4396, 70, 70], [4397, 10.73, 9.29],
              [4398, 70, 70], [4399, 50, 60], [4400, 120, 90], [4402, 40, 50], [4404, 120, 90], [4405, 6.35, 4.6],
              [4406, 63.31, 68.07], [4407, 70, 70], [4408, 120, 90], [4409, 120, 90], [4410, 70, 70], [4411, 120, 90],
              [4412, 120, 90], [4413, 50, 60], [4414, 70, 70], [4415, 126.64, 97.53], [4416, 70, 70], [4417, 50, 60],
              [4418, 70, 70], [4419, 70, 70], [4420, 7.46, 6.7], [4421, 76.43, 44.44], [4426, 70, 70], [4427, 40, 50],
              [4428, 32.24, 21.39], [4432, 32.24, 21.39], [4433, 120, 90], [4436, 40, 50], [4438, 50, 60],
              [4439, 40, 50], [4440, 70, 70], [4441, 120, 90], [4442, 70, 70], [4443, 70, 70], [4444, 120, 90],
              [4445, 70, 70], [4446, 34.09, 21.45], [4448, 70, 70], [4450, 120, 90], [4453, 70, 70],
              [4454, 25.13, 30.27], [4455, 70, 70], [4456, 70, 70], [4457, 40, 50], [4460, 120, 90],
              [4461, 25.09, 25.72], [4463, 50, 60], [4464, 44.69, 25.78], [4465, 70, 70], [4466, 70, 70],
              [4467, 120, 90], [4468, 70, 70], [4470, 50, 60], [4471, 135.92, 55.65], [4473, 32.24, 21.39],
              [4477, 37.5, 45], [4479, 120, 90], [4481, 120, 90], [4482, 120, 90], [4483, 120, 90], [4484, 120, 90],
              [4486, 120, 90], [4487, 50, 60], [4488, 70, 70], [4489, 11.71, 6.08], [4490, 120, 90], [4491, 70, 70],
              [4493, 70, 70], [4494, 120, 90], [4495, 82.86, 52.5], [4497, 50, 60], [4498, 70, 70],
              [4500, 17.11, 23.93], [4501, 120, 90], [4502, 50, 60], [4504, 29.9, 16.62], [4505, 70, 70],
              [4506, 32.1, 29.68], [4508, 120, 90], [4509, 120, 90], [4510, 33.56, 26.64], [4511, 70, 70],
              [4512, 12.38, 7.83], [4513, 120, 90], [4514, 120, 90], [4515, 33.39, 72.42], [4517, 50, 60],
              [4518, 72.62, 43.09], [4520, 50, 60], [4521, 115.81, 56], [4523, 50, 60], [4524, 25.93, 22.72],
              [4525, 50, 60], [4526, 9.64, 9.7], [4527, 120, 90], [4530, 13.96, 9.89], [4531, 120, 90],
              [4532, 66.87, 50.91], [4533, 70, 70], [4534, 70, 70], [4535, 120, 90], [4536, 70, 70], [4538, 70, 70],
              [4539, 40, 50], [4540, 10.59, 6.68], [4541, 120, 90], [4542, 70, 70], [4543, 37.5, 45], [4545, 70, 70],
              [4546, 120, 90], [4548, 20.54, 15.72], [4549, 40, 50], [4550, 65.66, 48.34], [4551, 120, 90],
              [4552, 55.6, 45.56], [4553, 120, 90], [4555, 120, 90], [4556, 120, 90], [4558, 120, 90], [4560, 120, 90],
              [4563, 53.86, 28.78], [4565, 70, 70], [4566, 70, 70], [4568, 70, 70], [4569, 70, 70], [4571, 70, 70],
              [4572, 105.72, 48.73], [4576, 120, 90], [4577, 16.43, 13.85], [4578, 70, 70], [4579, 9.23, 6.62],
              [4580, 50, 60], [4582, 70, 70], [4584, 40, 50], [4585, 70, 70], [4587, 120, 90], [4590, 70, 70],
              [4591, 38.76, 40.37], [4593, 7.89, 6.27], [4597, 120, 90], [4598, 120, 90], [4599, 35.02, 25.49],
              [4600, 50, 60], [4601, 33.72, 42.28], [4602, 36.28, 36.4], [4603, 120, 90], [4604, 120, 90],
              [4605, 50, 60], [4606, 35.1, 31.57], [4607, 120, 90], [4608, 50, 60], [4610, 70, 70],
              [4611, 62.95, 50.94], [4612, 120, 90], [4613, 70, 70], [4614, 70, 70], [4615, 120, 90],
              [4616, 27.98, 41.56], [4617, 95.75, 69.39], [4618, 70, 70], [4619, 70, 70], [4620, 70, 70],
              [4621, 50, 60], [4622, 120, 90], [4623, 70, 70], [4626, 40, 50], [4627, 70, 70], [4628, 120, 90],
              [4629, 70, 70], [4630, 120, 90], [4631, 20.43, 22.07], [4633, 28.23, 35.68], [4634, 70, 70],
              [4635, 16.11, 11.7], [4636, 120, 90], [4637, 70, 70], [4638, 54.7, 34.62], [4641, 15.54, 8.85],
              [4643, 120, 90], [4644, 70, 70], [4645, 32.24, 21.39], [4648, 50, 60], [4649, 50, 60], [4651, 70, 70],
              [4652, 50, 60], [4653, 120, 90], [4655, 120, 90], [4657, 120, 90], [4658, 70, 70], [4660, 70, 70],
              [4661, 32.24, 21.39], [4662, 70, 70], [4664, 10.86, 8.78], [4665, 120, 90], [4666, 120, 90],
              [4667, 70, 70], [4668, 62.61, 42.44], [4670, 70, 70], [4671, 120, 90], [4674, 15, 20], [4675, 50, 60],
              [4676, 13.79, 18.19], [4677, 70, 70], [4679, 120, 90], [4680, 120, 90], [4682, 120, 90],
              [4684, 39.81, 23.32], [4685, 61.3, 38.03], [4687, 120, 90], [4688, 17.49, 12.85], [4689, 70, 70],
              [4690, 32.24, 21.39], [4691, 40, 50], [4692, 70, 70], [4693, 119.12, 52.9], [4694, 58.28, 38.29],
              [4695, 70, 70], [4696, 120, 90], [4697, 120, 90], [4698, 70, 70], [4699, 120, 90], [4701, 70, 70],
              [4702, 120, 90], [4703, 23.69, 36.87], [4704, 120, 90], [4705, 120, 90], [4708, 70, 70], [4709, 120, 90],
              [4710, 10.6, 9.61], [4711, 120, 90], [4712, 50.55, 38.31], [4713, 50, 60], [4716, 35.02, 25.49],
              [4717, 29.78, 34.18], [4718, 120, 90], [4720, 50, 60], [4722, 120, 90], [4724, 50, 60],
              [4725, 8.65, 7.78], [4726, 120, 90], [4728, 25.36, 23.41], [4729, 68.67, 36.75], [4731, 4.74, 5.56],
              [4732, 50, 60], [4733, 70, 70], [4734, 40, 50], [4736, 32.24, 21.39], [4737, 120, 90], [4738, 120, 90],
              [4740, 70, 70], [4741, 70, 70], [4742, 120, 90], [4743, 32.24, 21.39], [4744, 40, 50], [4745, 40, 50],
              [4747, 55.87, 35.31], [4749, 70, 70], [4750, 9.46, 11.76], [4751, 50, 60], [4752, 70, 70],
              [4753, 88.11, 37.86], [4754, 120, 90], [4755, 14.14, 10.28], [4756, 40, 50], [4757, 120, 90],
              [4760, 120, 90], [4761, 22.44, 14.33], [4762, 52.5, 52.5], [4764, 120, 90], [4765, 50, 60],
              [4771, 70, 70], [4772, 70, 70], [4775, 32.24, 21.39], [4776, 37.5, 45], [4777, 24.04, 33.32],
              [4778, 50, 60], [4779, 70, 70], [4780, 110.99, 50.6], [4781, 30, 37.5], [4782, 70, 70], [4784, 120, 90],
              [4785, 120, 90], [4786, 120, 90], [4788, 50, 60], [4789, 70, 70], [4790, 70, 70], [4791, 48.77, 79.01],
              [4792, 70, 70], [4793, 120, 90], [4794, 70, 70], [4797, 50, 60], [4799, 70, 70], [4800, 17.87, 23.42],
              [4801, 70, 70], [4802, 128.4, 56.12], [4803, 70, 70], [4805, 70, 70], [4806, 70, 70], [4807, 50, 60],
              [4809, 120, 90], [4810, 120, 90], [4811, 50, 60], [4812, 120, 90], [4813, 50, 60], [4814, 120, 90],
              [4815, 39.69, 32.93], [4816, 70, 70], [4818, 120, 90], [4819, 57.44, 40.47], [4820, 70, 70],
              [4821, 120, 90], [4825, 120, 90], [4826, 28.39, 26.06], [4828, 70, 70], [4829, 45.03, 39.57],
              [4831, 9.72, 8.44], [4832, 70, 70], [4834, 120, 90], [4835, 51.6, 40.69], [4838, 40, 50],
              [4839, 37.82, 38.91], [4840, 70, 70], [4841, 120, 90], [4842, 120, 90], [4844, 49.21, 40.22],
              [4846, 120, 90], [4848, 120, 90], [4849, 40, 50], [4851, 120, 90], [4852, 70, 70], [4853, 70, 70],
              [4854, 120, 90], [4856, 120, 90], [4863, 70, 70], [4864, 8.85, 15.97], [4865, 40, 50], [4866, 15, 25],
              [4867, 120, 90], [4869, 120, 90], [4871, 21.01, 27.1], [4872, 26.5, 30.18], [4875, 70, 70],
              [4876, 40, 50], [4877, 18.65, 29.18], [4878, 50, 60], [4879, 120, 90], [4880, 70, 70],
              [4881, 32.11, 49.85], [4882, 120, 90], [4885, 120, 90], [4887, 120, 90], [4888, 70, 70], [4893, 50, 60],
              [4894, 50, 60], [4895, 120, 90], [4896, 70, 70], [4897, 22.65, 32.49], [4902, 70, 70], [4905, 40, 50],
              [4906, 40, 50], [4907, 70, 70], [4909, 40, 50], [4910, 16.17, 15.54], [4911, 11.82, 7.07],
              [4912, 12.39, 15.28], [4914, 120, 90], [4915, 12.81, 25.88], [4916, 70, 70], [4918, 29.8, 29.23],
              [4920, 50, 60], [4922, 68.28, 37.1], [4923, 120, 90], [4926, 120, 90], [4927, 28.01, 18.8],
              [4928, 70, 70], [4929, 70, 70], [4930, 70, 70], [4931, 34.13, 33.6], [4934, 70, 70], [4936, 120, 90],
              [4939, 28.05, 30.31], [4940, 95.48, 82.93], [4942, 50, 60], [4944, 70, 70], [4945, 120, 90],
              [4946, 120, 90], [4949, 50, 60], [4950, 70.53, 51.44], [4951, 70, 70], [4953, 35.02, 25.49],
              [4954, 70, 70], [4955, 25.46, 23.67], [4956, 32.24, 21.39], [4957, 64.8, 59.23], [4958, 120, 90],
              [4960, 101.39, 50.61], [4962, 70, 70], [4963, 70, 70], [4964, 7.37, 6.44], [4965, 50, 60], [4966, 70, 70],
              [4968, 120, 90], [4971, 32.24, 21.39], [4972, 35.02, 25.49], [4973, 70, 70], [4974, 50, 60],
              [4975, 49.84, 42.61], [4976, 40, 50], [4977, 120, 90], [4978, 120, 90], [4979, 56.77, 40.85],
              [4981, 50, 60], [4983, 29.76, 20.92], [4984, 40, 50], [4985, 6.45, 5.95], [4987, 55.01, 32.18],
              [4988, 70, 70], [4989, 120, 90], [4990, 106.41, 53.31], [4992, 45.11, 33.84], [4994, 120, 90],
              [4995, 23.94, 28.78], [4996, 16.69, 30.91], [4997, 78.17, 40.51], [4998, 49.03, 43.06],
              [5000, 13.36, 12.29], [5001, 70, 70], [5002, 120, 90], [5003, 120, 90], [5005, 18.06, 19.95],
              [5006, 120, 90], [5007, 120, 90], [5008, 126.38, 53.28], [5009, 18.59, 27.74], [5010, 8.39, 5.61],
              [5011, 15.78, 16.19], [5012, 39.94, 45.98], [5013, 46.69, 34.25], [5014, 70, 70], [5017, 9.26, 20.62],
              [5019, 70, 70], [5020, 40, 50], [5022, 137.19, 88.29], [5023, 70, 70], [5025, 120, 90], [5026, 120, 90],
              [5027, 32.18, 30.47], [5031, 40, 50], [5032, 26.02, 40.08], [5033, 73.53, 35.42], [5034, 120, 90],
              [5035, 32.19, 33.94], [5036, 120, 90], [5037, 91.49, 46.75], [5038, 70, 70], [5041, 120, 90],
              [5043, 50, 60], [5044, 70, 70], [5046, 29.35, 32.47], [5048, 70, 70], [5049, 120, 90], [5050, 50, 60],
              [5051, 50, 60], [5053, 77.54, 45.07], [5054, 120, 90], [5056, 120, 90], [5057, 120, 90],
              [5058, 48.62, 42.89], [5060, 120, 90], [5061, 120, 90], [5062, 70, 70], [5063, 40, 50],
              [5064, 20.75, 20.03], [5065, 100.18, 69.74], [5066, 120, 90], [5068, 164.36, 62.76],
              [5069, 149.63, 54.69], [5070, 15.65, 30], [5071, 33.7, 31.78], [5072, 120, 90], [5073, 50, 60],
              [5075, 21.04, 24.86], [5077, 40, 50], [5079, 61.44, 42.57], [5081, 120, 90], [5082, 12.57, 13.41],
              [5083, 6.36, 5.53], [5084, 50, 60], [5085, 50, 60], [5087, 120, 90], [5088, 120, 90], [5091, 120, 90],
              [5092, 50, 60], [5093, 50, 60], [5094, 40, 50], [5095, 50, 60], [5097, 120, 90], [5098, 47.1, 29.63],
              [5099, 70, 70], [5100, 120, 90], [5101, 5.93, 6.65], [5102, 120, 90], [5103, 89.21, 43], [5104, 120, 90],
              [5107, 120, 90], [5108, 70, 70], [5109, 93.01, 45.96], [5111, 35.02, 25.49], [5114, 4.87, 4],
              [5115, 120, 90], [5116, 22.23, 21.49], [5117, 40, 50], [5119, 120, 90], [5121, 30.65, 46.26],
              [5122, 21.51, 31.21], [5123, 15.99, 15.06], [5124, 70, 70], [5126, 26.81, 24.11], [5127, 32.57, 20.36],
              [5128, 32.24, 21.39], [5130, 50, 60], [5132, 120, 90], [5135, 50, 60], [5136, 11.5, 8.4], [5137, 120, 90],
              [5138, 120, 90], [5141, 50, 60], [5143, 70, 70], [5145, 35.02, 25.49], [5149, 120, 90],
              [5150, 52.83, 33.37], [5153, 179.52, 59.91], [5154, 120, 90], [5155, 70, 70], [5156, 40, 50],
              [5157, 50, 60], [5159, 52.86, 48.43], [5160, 120, 90], [5161, 50, 60], [5162, 65.6, 46.34],
              [5163, 120, 90], [5164, 120, 90], [5165, 70, 70], [5166, 50, 60], [5167, 120, 90], [5169, 120, 90],
              [5171, 120, 90], [5172, 70, 70], [5173, 46.38, 41.15], [5174, 70, 70], [5178, 120, 90],
              [5180, 86.39, 54.81], [5181, 120, 90], [5182, 16.01, 20.04], [5183, 30.09, 35.52], [5184, 120, 90],
              [5185, 70, 70], [5186, 70, 70], [5187, 70, 70], [5188, 70, 70], [5189, 40, 50], [5191, 70, 70],
              [5192, 15, 25], [5193, 15, 25], [5194, 15, 25], [5195, 15, 25], [5196, 15, 25], [5197, 15, 25],
              [5198, 15, 25], [5199, 15, 25], [5200, 15, 25], [5201, 15, 25], [5202, 15, 25], [5203, 15, 25],
              [5204, 40, 50], [5205, 15, 25], [5206, 15, 25], [5207, 15, 25], [5208, 15, 25], [5209, 15, 25],
              [5210, 15, 25], [5211, 15, 25], [5212, 15, 25], [5213, 15, 25], [5214, 15, 25], [5215, 15, 25],
              [5216, 15, 25], [5217, 70, 70], [5219, 70, 70], [5220, 70, 70], [5221, 40, 50], [5222, 120, 90],
              [5223, 70, 70], [5224, 120, 90], [5225, 70, 70], [5226, 70, 70], [5227, 70, 70], [5228, 120, 90],
              [5229, 70, 70], [5230, 70, 70], [5231, 50, 60], [5232, 70, 70], [5233, 120, 90], [5234, 40, 50],
              [5235, 70, 70], [5236, 50, 60], [5237, 70, 70], [5238, 50, 60], [5239, 70, 70], [5240, 120, 90],
              [5241, 70, 70], [5242, 50, 60], [5243, 70, 70], [5244, 120, 90], [5245, 70, 70], [5249, 19.35, 11.59],
              [5250, 20.93, 10.99], [5251, 14.65, 13.08], [5252, 30, 16.56], [5253, 17.35, 10.66], [5254, 25.65, 16.32],
              [5255, 24.23, 14.71], [5256, 24.56, 17.38], [5257, 15.4, 13.96], [5258, 23.85, 19.14], [5259, 10.2, 9.75],
              [5260, 14.55, 9.36], [5261, 26.17, 17.95], [5263, 19.45, 15.67], [5264, 70, 50.86], [5265, 9.6, 16.73],
              [5266, 29.56, 17.86], [5267, 21.83, 15.71], [5268, 15.77, 15], [5269, 14.5, 9.26], [5270, 18.93, 17.93],
              [5271, 70, 70], [5272, 49.88, 21.16], [5273, 70, 70], [5274, 70, 70], [5275, 70, 70], [5276, 70, 70],
              [5277, 50, 60], [5278, 70, 70], [5279, 70, 70], [5280, 70, 70], [5281, 50, 60], [5282, 70, 70],
              [5283, 70, 70], [5284, 70, 70], [5285, 50, 60], [5286, 70, 70], [5287, 40, 50], [5288, 40, 50],
              [5289, 50, 60], [5290, 70, 70], [5291, 40, 50], [5292, 120, 90], [5293, 50, 60], [5294, 50, 60],
              [5295, 50, 60], [5296, 120, 90], [5297, 70, 70], [5298, 50, 60], [5299, 50, 60], [5300, 70, 70],
              [5301, 70, 70], [5302, 70, 70], [5303, 70, 70], [5304, 70, 70], [5305, 70, 70], [5306, 70, 70],
              [5307, 70, 70], [5308, 120, 90], [5309, 70, 70], [5310, 70, 70], [5311, 120, 90], [5312, 50, 60],
              [5313, 50, 60], [5314, 70, 70], [5315, 70, 70], [5316, 70, 70], [5317, 70, 70], [5318, 70, 70],
              [5319, 40, 50], [5320, 70, 70], [5321, 70, 70], [5322, 50, 60], [5323, 70, 70], [5324, 50, 60],
              [5325, 70, 70], [5326, 70, 70], [5327, 30, 45], [5328, 40, 50], [5329, 70, 70], [5330, 70, 70],
              [5331, 70, 70], [5332, 50, 60], [5333, 40, 50], [5334, 70, 70], [5335, 50, 60], [5336, 50, 60],
              [5337, 50, 60], [5338, 70, 70], [5339, 120, 90], [5340, 70, 70], [5341, 70, 70], [5342, 120, 90],
              [5343, 50, 60], [5344, 70, 70], [5345, 50, 60], [5346, 30, 45], [5347, 70, 70], [5348, 50, 60],
              [5349, 70, 70], [5350, 70, 70], [5351, 70, 70], [5352, 70, 70], [5353, 50, 60], [5354, 120, 90],
              [5355, 50, 60], [5356, 70, 70], [5357, 50, 60], [5358, 70, 70], [5359, 70, 70], [5360, 70, 70],
              [5361, 120, 90], [5362, 70, 70], [5363, 30, 45], [5364, 70, 70], [5365, 40, 50], [5366, 70, 70],
              [5367, 50, 60], [5368, 70, 70], [5369, 50, 60], [5370, 70, 70], [5371, 70, 70], [5372, 70, 70],
              [5373, 70, 70], [5374, 120, 90], [5375, 50, 60], [5376, 120, 90], [5377, 50, 60], [5378, 70, 70],
              [5379, 40, 50], [5380, 70, 70], [5381, 70, 70], [5382, 70, 70], [5383, 50, 60], [5384, 70, 70],
              [5385, 70, 70], [5386, 70, 70], [5387, 40, 50], [5388, 70, 70], [5389, 70, 70], [5390, 70, 70],
              [5391, 70, 70], [5392, 70, 70], [5393, 70, 70], [5394, 120, 90], [5395, 120, 90], [5396, 40, 50],
              [5397, 70, 70], [5398, 70, 70], [5399, 50, 60], [5400, 50, 60], [5401, 70, 70], [5402, 70, 70],
              [5403, 70, 70], [5404, 70, 70], [5405, 50, 60], [5406, 120, 90], [5407, 70, 70], [5408, 70, 70],
              [5409, 70, 70], [5410, 70, 70], [5411, 50, 60], [5412, 50, 60], [5413, 70, 70], [5414, 50, 60],
              [5415, 70, 70], [5416, 30, 45], [5417, 70, 70], [5418, 70, 70], [5419, 50, 60], [5420, 50, 60],
              [5421, 50, 60], [5422, 70, 70], [5423, 70, 70], [5424, 50, 60], [5425, 70, 70], [5426, 50, 60],
              [5427, 70, 70], [5428, 70, 70], [5429, 30, 45], [5430, 120, 90], [5431, 70, 70], [5432, 70, 70],
              [5433, 70, 70], [5434, 40, 50], [5435, 70, 70], [5436, 40, 50], [5437, 70, 70], [5438, 70, 70],
              [5439, 70, 70], [5440, 70, 70], [5441, 70, 70], [5442, 70, 70], [5443, 70, 70], [5444, 70, 70],
              [5445, 50, 60], [5446, 70, 70], [5447, 50, 60], [5448, 70, 70], [5449, 70, 70], [5450, 70, 70],
              [5451, 70, 70], [5452, 70, 70], [5453, 70, 70], [5454, 50, 60], [5455, 50, 60], [5456, 70, 70],
              [5457, 50, 60], [5458, 70, 70], [5459, 70, 70], [5460, 40, 50], [5461, 40, 50], [5462, 70, 70],
              [5463, 40, 50], [5464, 70, 70], [5465, 70, 70], [5466, 70, 70], [5467, 70, 70], [5468, 70, 70],
              [5469, 70, 70], [5470, 70, 70], [5471, 50, 60], [5472, 50, 60], [5473, 50, 60], [5474, 120, 90],
              [5475, 70, 70], [5476, 70, 70], [5477, 30, 45], [5478, 70, 70], [5479, 70, 70], [5480, 70, 70],
              [5481, 50, 60], [5482, 70, 70], [5483, 50, 60], [5484, 70, 70], [5485, 50, 60], [5486, 70, 70],
              [5487, 50, 60], [5488, 70, 70], [5489, 70, 70], [5490, 70, 70], [5491, 50, 60], [5492, 70, 70],
              [5493, 50, 60], [5494, 70, 70], [5495, 50, 60], [5496, 70, 70], [5497, 50, 60], [5498, 70, 70],
              [5499, 70, 70], [5500, 70, 70], [5501, 70, 70], [5502, 70, 70], [5503, 70, 70], [5504, 70, 70],
              [5505, 70, 70], [5506, 70, 70], [5507, 70, 70], [5508, 70, 70], [5509, 70, 70], [5510, 70, 70],
              [5511, 50, 60], [5512, 50, 60], [5513, 70, 70], [5514, 70, 70], [5515, 70, 70], [5516, 70, 70],
              [5517, 70, 70], [5518, 50, 60], [5519, 70, 70], [5520, 70, 70], [5521, 70, 70], [5522, 40, 50],
              [5523, 50, 60], [5524, 50, 60], [5525, 70, 70], [5526, 70, 70], [5527, 70, 70], [5528, 40, 50],
              [5529, 120, 90], [5530, 70, 70], [5531, 70, 70], [5532, 70, 70], [5533, 70, 70], [5534, 50, 60],
              [5535, 70, 70], [5536, 15, 20], [5537, 120, 90], [5538, 70, 70], [5539, 70, 70], [5540, 70, 70],
              [5541, 70, 70], [5542, 40, 50], [5543, 40, 50], [5544, 70, 70], [5545, 70, 70], [5546, 70, 70],
              [5547, 70, 70], [5548, 70, 70], [5549, 40, 50], [5550, 70, 70], [5551, 70, 70], [5552, 70, 70],
              [5553, 70, 70], [5554, 70, 70], [5555, 70, 70], [5556, 50, 60], [5557, 40, 50], [5558, 40, 50],
              [5559, 70, 70], [5560, 120, 90], [5561, 120, 90], [5562, 120, 90], [5563, 70, 70], [5564, 70, 70],
              [5565, 70, 70], [5566, 70, 70], [5567, 70, 70], [5568, 120, 90], [5569, 70, 70], [5570, 120, 90],
              [5571, 50, 60], [5572, 70, 70], [5573, 0, 0], [5590, 70, 70], [5600, 120, 90], [5618, 120, 90],
              [5621, 120, 90], [5624, 120, 90], [5625, 120, 90], [5627, 70, 70], [5632, 120, 90], [5636, 120, 90],
              [5638, 50, 60], [5646, 120, 90], [5648, 120, 90], [5649, 70, 70], [5659, 7.31, 6.79], [5660, 9.41, 9.76],
              [5661, 70, 70], [5663, 120, 90], [5666, 120, 90], [5672, 70, 70], [5675, 50, 60], [5677, 120, 90],
              [5681, 70, 70], [5683, 120, 90], [5689, 120, 90], [5706, 120, 90], [5715, 70, 70], [5717, 120, 90],
              [5720, 70, 70], [5726, 120, 90], [5728, 120, 90], [5737, 120, 90], [5738, 120, 90], [5745, 70, 70],
              [5747, 120, 90], [5757, 40, 50], [5758, 70, 70], [5764, 50, 60], [5768, 70, 70], [5777, 120, 90],
              [5789, 40, 50], [5796, 120, 90], [5805, 120, 90], [5808, 70, 70], [5811, 120, 90], [5819, 120, 90],
              [5824, 70, 70], [5830, 70, 70], [5833, 120, 90], [5840, 120, 90], [5841, 120, 90], [5846, 120, 90],
              [5848, 120, 90], [5851, 120, 90], [5855, 50, 60], [5856, 40, 50], [5861, 120, 90], [5868, 120, 90],
              [5869, 120, 90], [5876, 120, 90], [5877, 120, 90], [5880, 50, 60], [5881, 70, 70], [5882, 70, 70],
              [5884, 120, 90], [5887, 70, 70], [5889, 70, 70], [5898, 120, 90], [5903, 70, 70], [5911, 120, 90],
              [5917, 120, 90], [5918, 120, 90], [5919, 70, 70], [5931, 70, 70], [5933, 40, 50], [5936, 70, 70],
              [5939, 120, 90], [5940, 120, 90], [5941, 120, 90], [5942, 120, 90], [5943, 120, 90], [5944, 40, 50],
              [5945, 40, 50], [5946, 40, 50], [5947, 120, 90], [5948, 40, 50], [5949, 120, 90], [5950, 120, 90],
              [5951, 120, 90], [5953, 40, 50], [5954, 120, 90], [5955, 120, 90], [5956, 120, 90], [5957, 120, 90],
              [5958, 50, 60], [5959, 50, 60], [5960, 120, 90], [5961, 40, 50], [5964, 120, 90], [5965, 120, 90],
              [5966, 50, 60], [5967, 70, 70], [5968, 120, 90], [5969, 70, 70], [5970, 70, 70], [5985, 15, 25],
              [5986, 50, 60], [5987, 15, 25], [5988, 21, 33], [5994, 50, 60], [5995, 70, 70], [5996, 70, 70],
              [5997, 70, 70], [5998, 120, 90], [5999, 50, 60], [6049, 120, 90], [6050, 70, 70], [6051, 70, 70],
              [6052, 120, 90], [6053, 120, 90], [6054, 120, 90], [6068, 120, 90], [6069, 70, 70], [6070, 70, 70],
              [6071, 70, 70], [6072, 40, 50], [6073, 70, 70], [6074, 70, 70], [6075, 70, 70], [6076, 50, 60],
              [6077, 70, 70], [6078, 50, 60], [6079, 70, 70], [6080, 70, 70], [6081, 50, 60], [6082, 70, 70],
              [6083, 120, 90], [6084, 120, 90], [6085, 120, 90], [6086, 70, 70], [6087, 70, 70], [6088, 70, 70],
              [6089, 70, 70], [6090, 120, 90], [6091, 70, 70], [6092, 70, 70], [6093, 120, 90], [6094, 70, 70],
              [6095, 50, 60], [6096, 120, 90], [6097, 120, 90], [6098, 120, 90], [6099, 120, 90], [6100, 70, 70],
              [6101, 70, 70], [6102, 70, 70], [6103, 70, 70], [6104, 120, 90], [6105, 120, 90], [6106, 70, 70],
              [6107, 70, 70], [6108, 70, 70], [6109, 50, 60], [6110, 70, 70], [6111, 30, 45], [6112, 70, 70],
              [6113, 70, 70], [6114, 50, 60], [6115, 50, 60], [6116, 70, 70], [6117, 70, 70], [6118, 70, 70],
              [6119, 70, 70], [6120, 40, 50], [6121, 70, 70], [6122, 70, 70], [6123, 70, 70], [6124, 70, 70],
              [6125, 70, 70], [6126, 70, 70], [6127, 70, 70], [6128, 70, 70], [6129, 40, 50], [6130, 70, 70],
              [6131, 70, 70], [6132, 70, 70], [6133, 70, 70], [6134, 70, 70], [6135, 70, 70], [6136, 70, 70],
              [6137, 40, 50], [6138, 50, 60], [6139, 70, 70], [6140, 40, 50], [6141, 50, 60], [6142, 50, 60],
              [6143, 70, 70], [6144, 70, 70], [6145, 70, 70], [6146, 30, 45], [6147, 40, 50], [6148, 40, 50],
              [6149, 70, 70], [6150, 50, 60], [6151, 70, 70], [6152, 40, 50], [6153, 50, 60], [6154, 70, 70],
              [6155, 40, 50], [6156, 50, 60], [6157, 50, 60], [6158, 50, 60], [6159, 70, 70], [6160, 70, 70],
              [6161, 40, 50], [6162, 50, 60], [6163, 50, 60], [6164, 70, 70], [6165, 70, 70], [6166, 70, 70],
              [6167, 70, 70], [6168, 30, 45], [6169, 30, 45], [6170, 30, 45], [6248, 30, 45], [6252, 50, 60],
              [6253, 120, 90], [6255, 70, 70], [6256, 50, 60], [6258, 50, 60], [6259, 120, 90], [6260, 120, 90],
              [6261, 70, 70], [6262, 70, 70], [6263, 120, 90], [6264, 70, 70], [6265, 70, 70], [6266, 50, 60],
              [6267, 50, 60], [6268, 70, 70], [6269, 50, 60], [6270, 50, 60], [6271, 70, 70], [6272, 40, 50],
              [6274, 70, 70], [6275, 70, 70], [6276, 50, 60], [6277, 120, 90], [6278, 70, 70], [6279, 70, 70],
              [6280, 70, 70], [6281, 70, 70], [6282, 50, 60], [6283, 70, 70], [6284, 50, 60], [6286, 70, 70],
              [6287, 50, 60], [6288, 70, 70], [6289, 50, 60], [6290, 120, 90], [6292, 70, 70], [6293, 70, 70],
              [6294, 120, 90], [6295, 120, 90], [6296, 70, 70], [6297, 120, 90], [6299, 70, 70], [6300, 70, 70],
              [6301, 70, 70], [6302, 70, 70], [6303, 70, 70], [6305, 120, 90], [6306, 70, 70], [6307, 120, 90],
              [6308, 120, 90], [6309, 70, 70], [6310, 50, 60], [6312, 120, 90], [6313, 70, 70], [6314, 120, 90],
              [6315, 70, 70], [6316, 70, 70], [6317, 70, 70], [6319, 50, 60], [6320, 70, 70], [6321, 70, 70],
              [6323, 50, 60], [6324, 50, 60], [6325, 120, 90], [6326, 70, 70], [6327, 50, 60], [6328, 120, 90],
              [6330, 120, 90], [6331, 50, 60], [6333, 120, 90], [6334, 27.92, 22.8], [6335, 36.36, 27.35],
              [6336, 50, 35.7], [6337, 28.8, 13.04], [6338, 50, 33.77], [6339, 20.96, 16.45], [6340, 50, 36.94],
              [6341, 40, 23.08], [6342, 23.49, 10.98], [6343, 22.07, 18.41], [6344, 19.93, 9.57], [6345, 50, 21.26],
              [6346, 40, 25.58], [6347, 30.77, 13.81], [6348, 40, 23.23], [6349, 26.83, 18.14], [6350, 30.1, 29.64],
              [6351, 37.29, 18.38]]],
            [1999,
             [[1, 50, 60], [2, 120, 90], [3, 70, 70], [7, 35.26, 21.02], [13, 120, 90], [14, 120, 90], [15, 70, 70],
              [16, 70, 70], [17, 120, 90], [18, 70, 70], [19, 70, 70], [20, 120, 90], [21, 70, 70], [22, 3.02, 9.75],
              [23, 120, 90], [25, 13.55, 9.36], [26, 70, 70], [27, 120, 90], [28, 50, 60], [29, 120, 90],
              [30, 26.05, 16.78], [31, 11.48, 9.38], [32, 120, 90], [33, 60.79, 35], [35, 120, 90], [37, 70, 70],
              [38, 120, 90], [40, 70, 133], [42, 49.3, 31.8], [43, 120, 90], [44, 120, 90], [47, 50, 60], [48, 70, 70],
              [49, 37.5, 45], [50, 120, 90], [51, 15.57, 18.15], [53, 40, 50], [56, 120, 90], [57, 120, 90],
              [58, 61.93, 49.09], [61, 70, 70], [62, 27.9, 27.4], [63, 70, 70], [64, 29.97, 42.64], [65, 50, 42.55],
              [66, 20, 25], [68, 70, 70], [69, 70, 70], [70, 50, 60], [71, 120, 90], [72, 120, 90], [73, 120, 90],
              [75, 50, 60], [77, 120, 90], [78, 59.13, 56.03], [81, 70, 70], [82, 12, 28.91], [83, 40, 37.5],
              [84, 120, 90], [87, 140.68, 39.98], [88, 10.85, 7.56], [89, 70, 70], [91, 40, 50], [93, 8.27, 9.25],
              [94, 120, 90], [96, 17.85, 27], [99, 15.91, 13.12], [100, 8.29, 8.86], [101, 70, 70], [103, 120, 90],
              [105, 40, 50], [106, 70, 70], [109, 40, 50], [110, 120, 90], [113, 86.12, 35.5], [119, 70, 70],
              [121, 13.82, 8.38], [122, 42.72, 53.2], [123, 120, 90], [125, 24.22, 37.94], [128, 70, 70],
              [133, 120, 90], [135, 24.22, 25.06], [136, 120, 90], [138, 83.99, 31.46], [140, 50, 60], [141, 5, 5.95],
              [142, 114, 273], [144, 50, 60], [145, 10.42, 7.09], [146, 120, 90], [147, 70, 70], [149, 50, 33.8],
              [150, 50, 60], [151, 47.04, 30.27], [153, 30, 45], [156, 120, 90], [157, 120, 90], [158, 120, 90],
              [160, 120, 90], [161, 47.65, 26.01], [162, 40, 50], [163, 32.08, 38.15], [164, 120, 90], [165, 70, 70],
              [166, 31.35, 44.44], [169, 97.7, 41.85], [170, 120, 90], [171, 35.55, 35], [175, 70, 70], [177, 70, 70],
              [181, 120, 90], [182, 120, 90], [183, 70, 70], [184, 120, 90], [186, 42.55, 28.63], [187, 50, 60],
              [188, 34.84, 17.18], [189, 120, 90], [190, 41.9, 24.53], [192, 12, 18], [194, 36.1, 33],
              [195, 25.2, 22.5], [196, 8.64, 9.03], [197, 120, 90], [199, 120, 90], [200, 50, 60], [203, 70, 70],
              [204, 16.64, 27], [206, 120, 90], [207, 50, 60], [210, 120, 90], [211, 42.5, 64.2], [212, 70, 70],
              [213, 70, 70], [214, 120, 90], [215, 39.31, 26.34], [216, 72.31, 55.31], [217, 120, 90],
              [218, 53.89, 34.22], [220, 23.35, 19.12], [222, 9.57, 9.57], [225, 37.5, 45], [226, 13.66, 15.31],
              [227, 120, 90], [228, 18.5, 27.7], [230, 30, 37.5], [231, 70, 70], [233, 22.4, 15.4], [234, 12, 19.36],
              [235, 34.93, 21.66], [236, 70, 70], [237, 10.83, 7.57], [239, 57.35, 74.71], [240, 35.9, 29.8],
              [241, 46.4, 41.28], [242, 164.4, 59.03], [243, 118.04, 58], [244, 120, 90], [245, 120, 90],
              [246, 60.21, 33.65], [247, 120, 90], [248, 60.9, 49.22], [249, 70, 70], [250, 50, 60], [253, 120, 90],
              [256, 50, 60], [257, 120, 90], [260, 70, 70], [264, 50, 60], [265, 120, 90], [267, 120, 90],
              [268, 120, 90], [269, 120, 90], [270, 102.9, 57.89], [272, 120, 90], [273, 25.7, 35.52], [282, 70, 70],
              [283, 120, 90], [284, 70, 70], [285, 62.31, 50.39], [286, 33.37, 83.43], [287, 40, 37.5], [289, 120, 90],
              [291, 70, 70], [292, 50, 60], [294, 96.24, 38.52], [295, 120, 90], [296, 36.57, 16.84], [297, 120, 90],
              [298, 70, 70], [299, 56.16, 71.39], [302, 120, 90], [303, 60.81, 32.84], [305, 21.98, 26],
              [306, 53.16, 39.53], [307, 70, 70], [308, 22.69, 32.81], [309, 120, 90], [310, 20.76, 23.58],
              [311, 70, 70], [312, 98.14, 57.65], [313, 50, 60], [314, 28.98, 30.23], [315, 120, 90],
              [317, 34.9, 28.91], [320, 40.8, 42.3], [321, 120, 90], [322, 120, 90], [324, 37.5, 45], [325, 120, 90],
              [326, 28.63, 19.82], [327, 52.96, 62.65], [328, 70, 70], [329, 70, 70], [330, 24.63, 27.62],
              [332, 101.6, 71.83], [333, 120, 90], [334, 14.71, 16.26], [337, 19.61, 30.02], [339, 74, 62.86],
              [340, 120, 90], [342, 70, 70], [343, 120, 90], [344, 89.38, 44.91], [346, 56.18, 44.76], [347, 70, 70],
              [348, 120, 90], [350, 70, 70], [351, 70, 70], [353, 50, 60], [354, 37.5, 45], [355, 70, 70],
              [356, 120, 90], [358, 70, 70], [361, 41.38, 37.74], [362, 50, 60], [365, 120, 90], [367, 60, 167],
              [368, 50, 60], [369, 5.88, 5.27], [370, 70, 70], [371, 72.52, 67.5], [372, 16.36, 13.13], [374, 50, 60],
              [376, 22.12, 15.96], [377, 25.09, 17.45], [378, 31.66, 30.53], [379, 11.67, 16.73], [382, 70, 70],
              [383, 25.5, 21.6], [385, 120, 90], [386, 50, 60], [387, 70, 70], [389, 37.5, 45], [390, 70, 70],
              [391, 70, 70], [392, 72.06, 47.49], [394, 50, 60], [396, 120, 90], [398, 70, 70], [399, 70, 70],
              [400, 50, 60], [401, 70, 70], [402, 120, 90], [403, 25.72, 27.84], [405, 70, 70], [406, 120, 90],
              [409, 50, 60], [411, 120, 90], [412, 120, 90], [413, 30, 45], [415, 120, 90], [416, 50, 60],
              [418, 37.33, 36.38], [419, 120, 90], [422, 120, 90], [424, 32.02, 28.67], [425, 12.16, 14.12],
              [426, 120, 90], [427, 40, 50], [428, 13.52, 12.14], [429, 70, 70], [430, 27, 24], [432, 60.55, 31.38],
              [434, 70, 70], [436, 20.72, 16.74], [437, 40, 50], [439, 70, 70], [443, 120, 90], [444, 50, 60],
              [445, 120, 90], [446, 70, 70], [450, 120, 90], [451, 50, 60], [452, 120, 90], [453, 70, 70],
              [454, 120, 90], [455, 71.93, 65.93], [457, 40, 50], [458, 70, 70], [459, 120, 90], [460, 70, 70],
              [461, 50, 60], [463, 10.14, 8.58], [464, 21.08, 14.31], [465, 50, 60], [466, 120, 90], [467, 120, 90],
              [468, 120, 90], [469, 120, 90], [470, 120, 90], [471, 29.42, 44.44], [473, 120, 90], [474, 70, 70],
              [476, 120, 90], [477, 120, 90], [478, 120, 90], [479, 70, 70], [480, 70, 70], [481, 70, 70],
              [482, 70, 70], [484, 70, 70], [485, 120, 90], [486, 50, 60], [487, 22.74, 35.74], [488, 70, 70],
              [490, 70, 70], [493, 120, 90], [494, 16.23, 19.49], [495, 120, 90], [496, 77, 84], [497, 20.34, 27.7],
              [498, 50, 60], [500, 70, 70], [501, 70, 70], [503, 70, 24.56], [504, 14.4, 17.19], [505, 24.91, 27.22],
              [507, 120, 90], [508, 70, 70], [509, 5.13, 4.64], [510, 40, 50], [512, 30, 40], [513, 70, 70],
              [515, 75, 45], [518, 120, 90], [519, 26.44, 21.57], [520, 120, 90], [521, 120, 90], [522, 70, 70],
              [523, 120, 90], [524, 70, 70], [525, 31.78, 60.44], [526, 70.03, 60], [527, 82, 95], [528, 50, 60],
              [531, 10.37, 9.91], [532, 85.36, 50.72], [534, 41.02, 29.31], [535, 40, 50], [536, 18.74, 29.58],
              [540, 70, 70], [541, 61.04, 50.11], [543, 120, 90], [545, 35.62, 43.31], [547, 12, 18], [548, 120, 90],
              [549, 45, 24.58], [550, 70, 70], [551, 120, 90], [553, 120, 90], [554, 15, 25], [555, 120, 90],
              [556, 120, 90], [557, 40, 50], [558, 120, 90], [559, 70, 70], [561, 120, 90], [563, 70, 70],
              [564, 12.02, 6.99], [565, 24.89, 19.74], [568, 44.41, 35.25], [569, 106.46, 58.13], [570, 77.63, 49.89],
              [571, 70, 70], [572, 30, 45], [573, 34.75, 26.58], [574, 70, 70], [577, 32.7, 38.7], [579, 40, 50],
              [581, 30, 45], [582, 120, 90], [583, 70, 70], [584, 21.39, 10.39], [585, 70, 70], [586, 50, 60],
              [588, 12, 22.5], [589, 120, 90], [590, 53.52, 61.02], [591, 120, 90], [593, 65, 51.92], [594, 70, 70],
              [595, 62.54, 30.08], [596, 8.9, 17.2], [597, 40.93, 18.93], [599, 37.1, 32.34], [600, 120, 90],
              [601, 70, 70], [604, 77.66, 49.79], [606, 70, 70], [607, 50, 60], [608, 54.37, 25.93], [610, 50, 60],
              [611, 50, 60], [612, 45.76, 60.33], [614, 28.93, 29.68], [615, 120, 90], [616, 120, 90], [618, 30, 37.5],
              [619, 120, 90], [621, 120, 90], [623, 8.39, 6.11], [625, 51.68, 25.98], [626, 40, 50], [627, 50, 60],
              [628, 20.36, 23.58], [629, 18.8, 33.4], [630, 70, 70], [631, 43.54, 34.8], [633, 120, 90], [635, 70, 70],
              [636, 21.1, 50.2], [637, 7.79, 7.02], [639, 70, 70], [641, 120, 90], [645, 97.67, 37.44], [647, 70, 70],
              [648, 70, 70], [649, 70, 70], [650, 120, 90], [651, 120, 90], [653, 70, 70], [654, 12.52, 17.79],
              [656, 120, 90], [657, 120, 90], [659, 7.56, 7.64], [660, 24.24, 22.96], [662, 120, 90],
              [663, 69.14, 36.97], [664, 70, 70], [665, 120, 90], [666, 120, 90], [669, 50, 30.85], [670, 70, 70],
              [672, 70, 70], [673, 120, 90], [675, 70, 70], [678, 47.55, 39.99], [679, 120, 90], [680, 10.1, 8.13],
              [681, 70, 70], [682, 8.1, 6.18], [683, 9.08, 9.76], [686, 16.9, 21.27], [687, 120, 90], [688, 120, 90],
              [690, 40, 50], [691, 18.17, 15.1], [692, 70, 70], [693, 70, 70], [694, 50, 42.14], [695, 74.53, 49.3],
              [697, 120, 90], [698, 70, 70], [700, 70, 70], [701, 120, 90], [702, 70, 70], [703, 12, 18],
              [704, 55.7, 36.5], [705, 30, 45], [706, 70, 70], [708, 70, 70], [709, 32.88, 46.39], [710, 120, 90],
              [711, 50, 60], [714, 50, 60], [715, 120, 90], [716, 70, 70], [717, 36.27, 32.74], [718, 50, 60],
              [719, 120, 90], [720, 87.15, 35.16], [721, 50, 60], [722, 120, 90], [723, 50, 60], [724, 29.85, 64.97],
              [727, 50, 45], [730, 120, 90], [731, 41.75, 21.4], [734, 18.45, 34.92], [737, 10.58, 13.69],
              [738, 120, 90], [740, 18, 27], [741, 120, 90], [742, 25, 15.29], [745, 120, 90], [746, 40, 50],
              [747, 85.74, 47.21], [748, 70, 70], [749, 50, 60], [750, 133.42, 46.75], [751, 70, 70], [753, 50, 60],
              [754, 36.5, 31.71], [756, 83, 140], [759, 70, 70], [762, 70, 70], [763, 70, 70], [766, 100.6, 37.63],
              [767, 70, 70], [769, 37.94, 60], [771, 120, 90], [772, 70, 70], [773, 64.93, 30.4], [775, 70, 70],
              [776, 120, 90], [778, 120, 90], [779, 50, 60], [781, 71.84, 33.52], [782, 120, 90], [783, 50, 45],
              [784, 33.43, 46.1], [785, 120, 90], [787, 18, 23.03], [789, 70, 70], [790, 60.28, 19.43], [795, 120, 90],
              [796, 70, 70], [799, 50, 60], [801, 35.37, 49.96], [802, 120, 90], [803, 42.57, 40], [804, 120, 90],
              [805, 13.65, 18.71], [806, 120, 90], [807, 9.12, 12.1], [811, 120, 90], [812, 50, 60], [813, 8.07, 6.92],
              [814, 120, 90], [815, 30.9, 14.34], [818, 70, 70], [819, 120, 90], [820, 50, 65], [821, 24.1, 26.31],
              [822, 18.48, 22.65], [823, 120, 90], [824, 120, 90], [825, 70, 70], [826, 17.52, 8.25], [827, 12, 18],
              [829, 8.45, 6.52], [830, 120, 90], [831, 120, 90], [833, 120, 90], [835, 69.3, 61.77], [836, 120, 90],
              [837, 70, 70], [840, 120, 90], [842, 50, 60], [843, 50.2, 42.1], [844, 117.83, 54.95],
              [845, 79.17, 68.36], [846, 120, 90], [847, 70, 70], [848, 9.12, 11.53], [850, 40, 50],
              [851, 18.96, 12.46], [852, 70, 70], [855, 6.73, 7.13], [857, 120, 90], [860, 70, 70], [863, 13.7, 17.4],
              [865, 70, 42.13], [867, 120, 90], [869, 70, 70], [871, 16.44, 22.77], [872, 70, 70], [873, 51, 70],
              [875, 120, 90], [876, 120, 90], [877, 120, 90], [878, 5.59, 4.6], [881, 120, 90], [882, 50, 60],
              [883, 120, 90], [884, 70, 70], [885, 70, 70], [886, 120, 90], [889, 11.95, 11.28], [890, 62.93, 34.45],
              [891, 120, 90], [892, 120, 90], [894, 23.13, 17.71], [895, 120, 90], [896, 70, 70], [897, 13.97, 22.37],
              [899, 120, 90], [900, 6.81, 4.72], [901, 120, 90], [905, 120, 90], [909, 120, 90], [910, 11.75, 7.29],
              [913, 21.73, 18.25], [914, 120, 90], [915, 38.46, 49.72], [916, 40, 50], [917, 30, 45], [918, 62, 50],
              [919, 120, 90], [922, 50, 60], [924, 8.93, 9.74], [926, 40.84, 38.58], [927, 70, 70], [928, 120, 90],
              [929, 120, 90], [930, 50, 60], [931, 70, 70], [934, 37.5, 45], [935, 120, 90], [936, 50, 60],
              [937, 120, 90], [938, 12, 18], [940, 12, 18], [941, 70, 70], [942, 70, 70], [944, 96.61, 70.21],
              [945, 50, 60], [946, 50, 60], [948, 31.14, 15], [949, 79.45, 48.51], [950, 13.52, 21.99],
              [952, 12.6, 9.35], [953, 70, 70], [954, 120, 90], [955, 120, 90], [957, 120, 90], [958, 59.87, 32.44],
              [960, 50, 60], [961, 120, 90], [963, 70, 70], [964, 12, 15], [965, 50.79, 35], [966, 4.52, 4.32],
              [969, 52.88, 45.27], [970, 50, 60], [971, 35.72, 14.91], [972, 35.77, 19.67], [974, 30, 45],
              [976, 8.35, 13.15], [977, 12.22, 8.58], [978, 70, 48.36], [979, 36.64, 34.46], [980, 70, 70],
              [982, 120, 90], [983, 71.83, 30.1], [985, 194.37, 75.01], [986, 7.84, 7.68], [987, 120, 90],
              [988, 6.14, 5.32], [990, 71.86, 39.63], [991, 120, 90], [993, 89.04, 64.77], [994, 40, 50],
              [997, 120, 90], [998, 70, 70], [999, 120, 90], [1000, 40, 50], [1003, 7.76, 5.82], [1004, 70, 70],
              [1005, 40, 50], [1006, 120, 90], [1007, 28.86, 20.82], [1008, 37.5, 45], [1009, 120, 90], [1013, 70, 70],
              [1015, 70, 70], [1016, 14.94, 23.74], [1017, 50, 60], [1018, 120, 90], [1020, 70, 70], [1021, 70, 70],
              [1022, 120, 90], [1023, 13.9, 28.3], [1025, 120, 90], [1027, 120, 90], [1028, 50, 60], [1029, 70, 70],
              [1030, 7, 9.5], [1032, 23, 23.89], [1033, 27.47, 30.75], [1034, 70, 70], [1036, 6.74, 8.62],
              [1038, 70, 70], [1039, 120, 90], [1042, 120, 90], [1043, 12.3, 25.3], [1044, 120, 90], [1045, 120, 90],
              [1046, 50, 60], [1047, 70, 70], [1048, 70, 70], [1050, 70, 70], [1051, 92.72, 35.97], [1052, 50, 60],
              [1053, 50, 60], [1054, 70, 70], [1056, 22.3, 25.8], [1057, 50, 60], [1058, 70, 70], [1059, 65.53, 68.84],
              [1061, 70, 70], [1062, 7.92, 8.74], [1063, 120, 90], [1064, 50, 60], [1065, 120, 90], [1066, 50, 60],
              [1067, 120, 90], [1069, 50, 60], [1070, 20.5, 19], [1071, 125.97, 49.26], [1073, 84.92, 72.24],
              [1075, 6.43, 6.35], [1077, 120, 90], [1078, 120, 90], [1080, 120, 90], [1081, 53.54, 36.15],
              [1082, 75, 64.64], [1084, 160.19, 70.76], [1087, 130.51, 58.25], [1090, 120, 90], [1091, 40, 50],
              [1092, 12, 18], [1093, 50, 60], [1094, 23.66, 23.15], [1095, 34.76, 26.62], [1096, 120, 90],
              [1097, 8.07, 10.33], [1099, 13.78, 13.14], [1100, 55.33, 47.25], [1102, 20.14, 33.65], [1104, 70, 70],
              [1106, 70, 70], [1108, 120, 90], [1109, 71.26, 34.85], [1110, 120, 90], [1111, 68.1, 60.82],
              [1113, 120, 90], [1114, 120, 90], [1117, 50, 60], [1118, 50, 60], [1119, 50, 60], [1120, 120, 90],
              [1121, 120, 90], [1122, 120, 90], [1124, 33.6, 22.42], [1125, 120, 90], [1126, 70, 70], [1127, 120, 90],
              [1128, 70, 70], [1129, 50, 60], [1130, 120, 90], [1131, 19.62, 27.9], [1132, 12, 18],
              [1136, 64.79, 64.92], [1137, 120, 90], [1138, 166, 148], [1139, 70, 70], [1140, 50, 45],
              [1141, 151.96, 55.04], [1142, 87.4, 44.91], [1144, 70.4, 75.66], [1145, 120, 90], [1147, 12.27, 6.99],
              [1149, 53.28, 35.03], [1150, 50, 60], [1152, 36.81, 97.97], [1153, 120, 90], [1154, 120, 90],
              [1155, 12.52, 12.5], [1156, 50, 60], [1157, 40.32, 25.17], [1158, 50, 60], [1159, 70, 60],
              [1161, 120, 90], [1163, 19.1, 28.7], [1164, 120, 90], [1165, 120, 90], [1167, 85.7, 63.16],
              [1168, 120, 90], [1169, 34.55, 69.22], [1170, 70, 70], [1171, 70, 70], [1172, 70, 70], [1173, 50, 60],
              [1174, 37.2, 58.3], [1175, 28.04, 39.32], [1176, 120, 90], [1177, 70, 70], [1178, 8.86, 7.64],
              [1180, 15.85, 14.23], [1181, 120, 90], [1186, 15.33, 18], [1187, 120, 90], [1188, 40, 50],
              [1189, 120, 90], [1190, 70, 70], [1191, 67.28, 35], [1194, 82.38, 42.91], [1195, 120, 90],
              [1198, 120, 90], [1199, 40, 50], [1200, 27.2, 13.54], [1202, 30, 45], [1203, 15, 25], [1204, 70, 70],
              [1205, 85.87, 50.11], [1206, 120, 90], [1207, 30, 45], [1209, 40, 50], [1210, 40, 37.5],
              [1211, 53.75, 32.19], [1212, 70, 70], [1213, 40, 50], [1214, 70, 70], [1216, 50, 60],
              [1217, 90.55, 46.37], [1219, 116.48, 55.12], [1221, 22.66, 24.86], [1223, 70, 70], [1224, 49.77, 79.26],
              [1225, 50, 60], [1226, 25.67, 16.67], [1227, 120, 90], [1228, 57.49, 37.38], [1230, 50, 60],
              [1233, 50, 60], [1234, 12, 18], [1235, 50, 60], [1236, 70, 70], [1237, 37.5, 45], [1238, 14.2, 20.8],
              [1239, 120, 90], [1240, 120, 90], [1244, 70, 70], [1245, 120, 90], [1246, 70, 70], [1247, 70, 70],
              [1250, 70, 70], [1251, 70, 70], [1253, 50, 60], [1254, 70, 70], [1255, 120, 90], [1257, 40, 50],
              [1259, 105.06, 30.34], [1260, 50, 60], [1262, 110.05, 49.65], [1263, 120, 90], [1264, 120, 90],
              [1265, 13.11, 9.3], [1266, 120, 90], [1268, 30.72, 32.5], [1269, 50, 60], [1271, 85.26, 44.5],
              [1272, 70, 70], [1275, 36.46, 15.29], [1276, 70, 70], [1278, 18.5, 14.7], [1280, 11.06, 6.23],
              [1281, 21.65, 27], [1282, 50, 60], [1286, 120, 90], [1287, 70, 70], [1288, 70, 70], [1290, 120, 90],
              [1292, 70, 70], [1293, 4.01, 4.97], [1295, 70, 70], [1298, 50, 60], [1299, 70, 70], [1301, 70, 70],
              [1302, 30, 45], [1303, 70, 70], [1305, 17.46, 22.11], [1306, 12.9, 26.6], [1312, 26.57, 15.77],
              [1313, 120, 90], [1314, 23.54, 16.63], [1315, 120, 90], [1317, 70, 70], [1318, 120, 90],
              [1319, 46.62, 28.16], [1320, 120, 90], [1321, 48.13, 28.8], [1323, 75.54, 72.3], [1324, 120, 90],
              [1325, 120, 90], [1326, 70, 70], [1327, 70, 70], [1328, 69.9, 51.49], [1331, 120, 90], [1332, 5.42, 3.32],
              [1333, 120, 90], [1334, 87.72, 70.36], [1335, 22.9, 24.9], [1337, 5.66, 6.03], [1338, 120, 90],
              [1339, 11.12, 8.5], [1340, 53.22, 39.25], [1341, 120, 90], [1342, 70, 70], [1345, 40, 50], [1346, 50, 60],
              [1349, 97, 131], [1350, 70, 70], [1351, 70, 70], [1352, 120, 90], [1353, 70, 70], [1355, 120, 90],
              [1357, 70, 70], [1358, 120, 90], [1359, 67.94, 52.51], [1360, 18, 27], [1361, 77.94, 60.66],
              [1363, 83.47, 31.82], [1367, 53.29, 36.48], [1370, 17.21, 28.49], [1371, 70, 70], [1372, 120, 90],
              [1375, 22.3, 23.87], [1376, 30, 37.5], [1378, 70, 70], [1379, 120, 90], [1380, 70, 70], [1381, 120, 90],
              [1382, 26.47, 36.84], [1383, 8.45, 7.72], [1385, 70, 70], [1387, 40, 50], [1388, 120, 90],
              [1391, 120, 90], [1392, 120, 90], [1393, 70, 70], [1395, 70, 70], [1396, 12, 24.84], [1398, 40, 50],
              [1399, 7.42, 6.96], [1402, 70, 70], [1404, 40, 50], [1405, 120, 90], [1406, 4.67, 5.31], [1410, 70, 70],
              [1411, 50, 60], [1415, 70, 70], [1417, 120, 90], [1420, 50, 60], [1421, 120, 90], [1422, 120, 90],
              [1424, 50, 60], [1426, 12.76, 9.29], [1427, 23.02, 15.67], [1428, 8.98, 6.72], [1431, 120, 90],
              [1432, 6.73, 6.53], [1434, 53.67, 36.6], [1436, 70, 70], [1438, 70, 70], [1439, 120, 90], [1440, 70, 70],
              [1441, 120, 90], [1442, 70, 70], [1443, 57.46, 26.71], [1444, 120, 90], [1445, 85.92, 19.7],
              [1448, 70, 70], [1449, 120, 90], [1450, 120, 90], [1451, 120, 90], [1453, 70, 70], [1454, 20.61, 20.28],
              [1456, 70, 70], [1459, 120, 90], [1460, 78, 74], [1461, 6.14, 6.98], [1464, 50, 60], [1465, 30.3, 26.6],
              [1466, 50, 60], [1467, 70, 70], [1469, 70, 70], [1470, 35, 45], [1471, 58.78, 40.42], [1472, 120, 90],
              [1473, 11.99, 10.02], [1474, 18, 27], [1475, 93.38, 40.44], [1476, 39.76, 77.7], [1477, 104.5, 55.33],
              [1478, 14.96, 11.47], [1479, 40, 50], [1481, 70, 70], [1482, 12.31, 14.89], [1483, 70, 70],
              [1484, 24.92, 66.54], [1485, 120, 90], [1486, 73.81, 56.6], [1487, 120, 90], [1488, 120, 90],
              [1490, 35.69, 22.38], [1491, 11.32, 8.34], [1493, 40.01, 20.74], [1503, 120, 90], [1505, 120, 90],
              [1506, 120, 90], [1507, 70, 70], [1508, 21.47, 18.5], [1509, 120, 90], [1510, 31.13, 26.62],
              [1511, 21.14, 10.89], [1512, 50, 60], [1513, 70, 70], [1514, 75, 105], [1515, 30, 45], [1516, 70, 70],
              [1518, 120, 90], [1519, 120, 90], [1520, 70, 70], [1521, 120, 90], [1522, 35.03, 33.83], [1523, 120, 90],
              [1524, 120, 90], [1525, 30, 37.5], [1526, 19.7, 33.1], [1527, 17.34, 33.26], [1530, 97.88, 79.23],
              [1533, 70, 70], [1534, 10.96, 7.99], [1536, 30.57, 20.35], [1537, 35.55, 43.28], [1538, 120, 90],
              [1539, 20, 15], [1540, 40, 50], [1541, 70, 70], [1542, 50, 60], [1544, 120, 90], [1546, 70, 70],
              [1547, 70, 70], [1548, 120, 90], [1549, 233, 267], [1550, 120, 90], [1552, 30, 45], [1553, 70.57, 50.89],
              [1555, 30, 37.5], [1556, 27.63, 11.76], [1557, 59.6, 36.82], [1559, 50, 60], [1561, 30.82, 30.34],
              [1562, 97.79, 51.18], [1565, 120, 90], [1568, 17.56, 11.49], [1571, 70, 70], [1572, 120, 90],
              [1574, 50, 60], [1575, 124.82, 81.48], [1576, 50, 60], [1577, 50, 60], [1578, 120, 90], [1580, 50, 60],
              [1581, 17.87, 10.61], [1582, 22.41, 22.97], [1585, 70, 70], [1587, 18, 27], [1589, 70, 70],
              [1590, 70, 70], [1591, 12.9, 21.1], [1592, 70, 70], [1593, 25.91, 24.87], [1595, 70, 70], [1596, 120, 90],
              [1597, 70, 70], [1598, 15.38, 8.13], [1600, 120, 90], [1601, 70, 70], [1602, 120, 90], [1603, 50, 60],
              [1605, 50, 60], [1607, 70, 70], [1609, 120, 90], [1610, 18.25, 11.14], [1612, 120, 90], [1615, 120, 90],
              [1617, 120, 90], [1619, 8.99, 11.56], [1620, 40, 50], [1621, 70, 70], [1623, 50, 114], [1624, 120, 90],
              [1625, 70, 70], [1626, 70, 70], [1627, 70, 70], [1628, 50, 60], [1629, 40, 50], [1630, 70.01, 36.62],
              [1632, 8.5, 7.41], [1634, 70, 70], [1635, 16.96, 17.21], [1637, 120, 90], [1638, 52.95, 70],
              [1639, 70, 70], [1640, 70, 70], [1641, 50.33, 45.33], [1643, 18.14, 18.53], [1644, 48.21, 38.33],
              [1645, 70, 70], [1647, 70, 70], [1648, 120, 90], [1649, 120, 90], [1650, 70, 70], [1651, 120, 90],
              [1652, 57.04, 46.09], [1653, 35, 26.28], [1654, 50, 60], [1656, 8.28, 5.7], [1657, 70, 70],
              [1658, 120, 90], [1659, 38.85, 38.2], [1660, 134.83, 48.67], [1661, 70, 70], [1662, 20.69, 28.99],
              [1663, 28.45, 30.94], [1664, 22.26, 19.82], [1665, 28.19, 19.28], [1666, 6.17, 5.14], [1667, 120, 90],
              [1668, 70, 70], [1669, 120, 90], [1671, 120, 90], [1672, 20.29, 61.88], [1673, 40.58, 28.22],
              [1674, 70, 70], [1675, 9.08, 16.02], [1679, 33.66, 20.7], [1680, 55.76, 53.89], [1681, 120, 90],
              [1684, 120, 90], [1685, 37.5, 45], [1686, 120, 90], [1688, 25.71, 34.65], [1689, 120, 90],
              [1690, 120, 90], [1692, 120, 90], [1694, 120, 90], [1695, 120, 90], [1697, 70, 70], [1701, 70, 70],
              [1702, 70, 70], [1704, 32.73, 29.33], [1705, 70, 70], [1706, 40, 50], [1707, 30, 17.24],
              [1709, 16, 15.44], [1711, 70, 70], [1713, 50, 60], [1715, 120, 90], [1717, 70, 70], [1720, 4.58, 3.57],
              [1722, 120, 90], [1724, 31.04, 29.1], [1726, 120, 90], [1728, 120, 90], [1729, 36.89, 30.28],
              [1730, 12, 18], [1734, 17.03, 13.98], [1737, 70, 70], [1739, 70, 70], [1740, 50, 60], [1741, 70, 70],
              [1742, 120, 90], [1743, 70, 70], [1744, 48.44, 41.98], [1745, 34.11, 14.96], [1746, 70, 70],
              [1748, 109.42, 45.47], [1749, 50, 60], [1750, 70, 70], [1752, 120, 90], [1753, 25.17, 15.07],
              [1754, 120, 90], [1756, 47.81, 29.86], [1757, 70, 70], [1758, 70, 70], [1760, 12.98, 21.4],
              [1763, 43.44, 47.84], [1764, 131, 250], [1765, 50, 60], [1766, 120, 90], [1767, 120, 88.81],
              [1769, 70, 60.5], [1770, 80, 70], [1771, 19.39, 23.78], [1772, 25.48, 41.18], [1773, 50, 60],
              [1774, 17.87, 21.37], [1775, 70, 70], [1776, 35.63, 37.22], [1778, 120, 90], [1779, 38.19, 95.28],
              [1780, 37.79, 33.06], [1781, 113.83, 52.58], [1783, 12.6, 22.4], [1784, 70, 70], [1785, 120, 90],
              [1786, 40.8, 58.18], [1787, 120, 90], [1788, 120, 90], [1789, 120, 90], [1790, 48.09, 38.27],
              [1792, 25.36, 24.69], [1793, 70, 70], [1794, 42.48, 37.47], [1795, 13.2, 9.9], [1796, 50, 60],
              [1797, 70, 70], [1798, 70, 70], [1799, 4.8, 5.01], [1800, 9.59, 5.61], [1801, 70, 70], [1802, 120, 90],
              [1803, 120, 90], [1804, 105.47, 52.76], [1806, 120, 90], [1809, 120, 90], [1811, 120, 90],
              [1812, 43.07, 42.87], [1814, 40, 50], [1815, 15.67, 9.13], [1816, 83.79, 61.8], [1817, 90.35, 31.74],
              [1818, 27.25, 18.05], [1819, 70, 70], [1822, 70, 70], [1824, 50, 65], [1825, 50.4, 52.17], [1827, 70, 70],
              [1829, 23.1, 41.1], [1832, 70, 70], [1833, 120, 90], [1834, 120, 90], [1837, 120, 90], [1839, 70, 70],
              [1841, 70, 70], [1843, 14.6, 12.44], [1844, 30, 45], [1845, 20.52, 19.97], [1846, 120, 90],
              [1847, 50, 60], [1848, 66.18, 60.25], [1849, 120, 90], [1850, 7.35, 6.92], [1851, 7.82, 10.41],
              [1852, 40.34, 32.16], [1853, 120, 90], [1855, 120, 90], [1856, 30, 45], [1857, 70, 70], [1859, 120, 90],
              [1860, 120, 90], [1863, 16.62, 11.53], [1864, 94.1, 90], [1866, 70, 70], [1868, 120, 90],
              [1869, 40, 37.5], [1870, 70, 70], [1873, 70, 70], [1875, 40, 50], [1876, 35.35, 35.59], [1877, 120, 90],
              [1879, 43.02, 40.39], [1881, 55.94, 67.39], [1882, 104.15, 43.17], [1883, 120, 90], [1884, 50, 60],
              [1885, 70, 70], [1886, 50, 60], [1887, 70, 70], [1888, 120, 90], [1889, 70, 70], [1890, 120, 90],
              [1891, 33.58, 60], [1892, 70, 70], [1894, 50, 60], [1895, 79.91, 49.67], [1896, 120, 90],
              [1897, 13.67, 11.12], [1898, 8.67, 4.23], [1899, 70, 70], [1900, 30, 45], [1901, 27.52, 29.78],
              [1903, 70, 70], [1904, 120, 90], [1906, 19.49, 10.43], [1909, 120, 90], [1910, 120, 90], [1912, 70, 70],
              [1914, 120, 90], [1915, 57.34, 41.55], [1916, 120, 90], [1917, 120, 90], [1919, 120, 90], [1920, 70, 70],
              [1921, 28.17, 26.56], [1924, 120, 90], [1925, 59.83, 43.65], [1928, 120, 90], [1929, 6.5, 4.93],
              [1930, 10.76, 8.15], [1933, 12.42, 12.39], [1937, 70, 70], [1938, 120, 90], [1940, 151, 263],
              [1941, 120, 90], [1945, 45.16, 27.63], [1946, 70, 70], [1948, 26.6, 21.6], [1949, 120, 90],
              [1950, 42.96, 58.04], [1952, 92.32, 71.14], [1955, 50, 60], [1956, 40, 50], [1957, 70, 70],
              [1959, 120, 90], [1961, 120, 90], [1962, 15.89, 20.58], [1963, 7.89, 5.56], [1964, 79.54, 41.58],
              [1965, 50, 59.43], [1967, 70, 70], [1969, 70, 70], [1972, 8.68, 7.21], [1974, 70, 70], [1976, 9.37, 9.9],
              [1978, 70, 70], [1979, 50, 60], [1980, 120, 90], [1981, 70, 70], [1982, 70, 70], [1984, 70, 70],
              [1986, 120, 90], [1989, 63, 120], [1991, 11.55, 8.24], [1992, 50.97, 29.55], [1995, 39.6, 34.17],
              [1996, 120, 90], [1997, 120, 90], [1998, 7.33, 8.42], [2000, 32.3, 7.9], [2001, 63.05, 65.31],
              [2002, 50, 60], [2004, 8.73, 6.08], [2005, 117.44, 37.08], [2006, 34.13, 29.15], [2007, 70, 70],
              [2008, 70, 70], [2009, 67, 176], [2011, 12, 18], [2012, 70, 70], [2013, 38.69, 111.03],
              [2015, 20.41, 16.91], [2016, 50, 60], [2017, 40, 37.5], [2018, 12, 18], [2020, 70, 70],
              [2021, 91.08, 54.55], [2022, 120, 90], [2023, 12.93, 13.98], [2025, 47.08, 35.03], [2026, 122.65, 67.48],
              [2027, 120, 90], [2028, 120, 90], [2029, 30.65, 35.97], [2030, 50, 60], [2031, 6.44, 5.6],
              [2032, 29.96, 39.24], [2034, 120, 90], [2035, 70, 70], [2038, 120, 90], [2040, 120, 90], [2041, 120, 90],
              [2042, 25.88, 9.57], [2043, 16.14, 25.13], [2044, 120, 90], [2046, 50, 60], [2048, 13.1, 28.8],
              [2049, 70, 70], [2050, 11, 25], [2051, 120, 90], [2052, 120, 90], [2053, 70, 70], [2054, 21.44, 20.37],
              [2055, 70, 70], [2056, 50, 60], [2057, 120, 90], [2058, 7.15, 5.43], [2059, 11.86, 8.19], [2060, 70, 70],
              [2061, 70, 70], [2062, 120, 90], [2063, 70, 70], [2064, 61.23, 37.87], [2066, 120, 90], [2068, 70, 70],
              [2070, 19.34, 6.55], [2071, 120, 90], [2072, 120, 90], [2073, 120, 90], [2074, 70, 70], [2075, 45, 70],
              [2076, 70, 70], [2077, 120, 90], [2081, 57.1, 44.75], [2083, 120, 90], [2084, 23.59, 36.63],
              [2085, 9.03, 8.79], [2087, 70, 70], [2089, 50, 60], [2090, 120, 90], [2091, 120, 90], [2095, 70, 70],
              [2096, 120, 90], [2097, 50, 60], [2098, 40, 50], [2099, 89.29, 46.57], [2100, 71.04, 24.35],
              [2101, 30.58, 16.13], [2103, 11.08, 12.74], [2104, 111.3, 45.15], [2105, 120, 90], [2106, 40.17, 51.44],
              [2107, 120, 90], [2110, 40, 50], [2112, 70, 70], [2115, 70, 70], [2116, 50, 60], [2119, 7.29, 9.02],
              [2121, 28, 32.4], [2122, 70, 70], [2125, 120, 90], [2126, 50, 60], [2127, 44.84, 32.36],
              [2128, 29.14, 12.62], [2130, 120, 90], [2131, 65.5, 56.7], [2132, 19.44, 12.24], [2134, 70, 70],
              [2135, 22.3, 28.8], [2136, 70, 70], [2137, 70, 70], [2138, 38.63, 26.61], [2139, 70, 70], [2140, 40, 50],
              [2142, 5.59, 1.96], [2144, 37.3, 75.7], [2146, 70, 70], [2147, 120, 90], [2148, 70, 70], [2149, 120, 90],
              [2150, 120, 90], [2151, 40.63, 26.2], [2152, 120, 90], [2154, 120, 90], [2155, 120, 90],
              [2156, 43.59, 31.42], [2159, 120, 90], [2161, 50, 60], [2162, 34.02, 34.24], [2163, 120, 90],
              [2164, 22, 26.1], [2166, 120, 90], [2167, 10.33, 10.88], [2169, 70, 70], [2170, 50.17, 28.05],
              [2171, 120, 90], [2174, 40.28, 40.83], [2177, 8.15, 8.97], [2178, 16.1, 27], [2179, 26, 37.8],
              [2180, 14.38, 10.62], [2181, 58.9, 76.35], [2182, 120, 90], [2184, 40, 50], [2186, 50, 60],
              [2187, 120, 90], [2190, 70, 70], [2191, 120, 90], [2197, 120, 90], [2198, 40, 50], [2199, 120, 90],
              [2200, 70, 70], [2201, 23.77, 27.53], [2203, 11.11, 8.84], [2204, 14.98, 8.4], [2205, 120, 90],
              [2208, 81.25, 48.76], [2212, 70, 70], [2213, 50, 60], [2214, 1.27, 0.88], [2216, 34.36, 17.02],
              [2217, 120, 90], [2219, 120, 90], [2220, 37.11, 22.57], [2223, 40, 50], [2224, 29.41, 34.07],
              [2225, 50, 60], [2226, 120, 90], [2227, 39.22, 33.66], [2228, 50, 101], [2230, 120, 90], [2231, 120, 90],
              [2232, 17.94, 39.15], [2233, 22.35, 13.45], [2235, 50, 60], [2236, 26.79, 29.04], [2237, 120, 90],
              [2238, 26.85, 29.25], [2239, 21.85, 11.47], [2240, 120, 90], [2241, 14.63, 9.52], [2242, 70, 70],
              [2243, 120, 90], [2244, 38, 31.98], [2245, 70, 70], [2247, 50, 60], [2248, 40, 50], [2249, 120, 90],
              [2250, 50, 60], [2252, 50, 60], [2253, 14.51, 10.23], [2254, 70, 70], [2255, 22.3, 61.32], [2256, 70, 70],
              [2258, 42.22, 34.38], [2259, 2, 1], [2260, 70, 70], [2262, 70, 70], [2265, 120, 90], [2267, 7.26, 3.97],
              [2268, 120, 90], [2269, 70, 70], [2270, 120, 90], [2271, 6.34, 5.21], [2273, 70, 70], [2274, 70, 70],
              [2277, 50, 33.82], [2280, 8.57, 5.83], [2281, 120, 90], [2282, 34.6, 40.1], [2283, 120, 90],
              [2284, 70, 70], [2285, 40, 50], [2286, 70, 70], [2289, 120, 90], [2290, 120, 90], [2292, 120, 90],
              [2293, 109.99, 52.3], [2294, 50, 60], [2295, 120, 90], [2297, 153.15, 64.3], [2300, 50, 60],
              [2301, 70, 70], [2302, 120, 90], [2303, 56.37, 41.39], [2304, 70, 70], [2305, 120, 90], [2306, 50, 60],
              [2311, 45, 45], [2312, 33.27, 33.84], [2314, 120, 90], [2316, 70, 70], [2317, 120, 90], [2319, 50, 60],
              [2320, 8.59, 8.74], [2321, 120, 90], [2323, 70, 70], [2325, 120, 90], [2326, 120, 90], [2327, 120, 90],
              [2328, 70, 70], [2332, 30.96, 25.63], [2335, 85.28, 79.59], [2336, 120, 90], [2337, 120, 90],
              [2338, 70, 70], [2339, 120, 90], [2340, 120, 90], [2341, 73, 177], [2342, 70, 70], [2343, 57.74, 26.83],
              [2346, 70, 70], [2347, 120, 90], [2349, 70, 70], [2352, 50, 60], [2356, 226.56, 56.42], [2359, 50, 60],
              [2363, 30.54, 20.65], [2364, 70, 70], [2366, 16.78, 17.31], [2367, 59.45, 50.23], [2368, 70, 70],
              [2371, 70, 70], [2372, 30, 45], [2373, 70, 70], [2374, 12.45, 9.91], [2375, 120, 90],
              [2378, 20.26, 18.12], [2382, 70, 70], [2383, 96.19, 48.48], [2384, 30, 45], [2385, 70, 70],
              [2387, 40, 50], [2388, 70, 70], [2390, 121, 178], [2391, 70, 70], [2392, 7.85, 7.64], [2394, 50, 60],
              [2396, 120, 90], [2397, 120, 90], [2398, 120, 90], [2399, 120, 90], [2401, 9.42, 9.69], [2402, 70, 70],
              [2404, 120, 90], [2405, 22.61, 36.11], [2406, 120, 90], [2407, 120, 90], [2408, 50, 60],
              [2409, 9.5, 15.2], [2410, 70, 70], [2411, 9.59, 8.49], [2412, 6.63, 7.08], [2413, 120, 90],
              [2414, 8.64, 7.09], [2416, 120, 90], [2420, 120, 90], [2423, 70, 70], [2424, 120, 90], [2425, 52.54, 35],
              [2428, 10.11, 12.8], [2429, 12, 18], [2430, 70, 70], [2433, 70, 70], [2434, 134, 205],
              [2435, 22.35, 18.73], [2436, 17.93, 15], [2437, 9.73, 8.67], [2438, 120, 90], [2439, 70, 70],
              [2440, 5.64, 5.78], [2441, 120, 90], [2442, 12, 18], [2443, 70, 70], [2444, 120, 90], [2447, 25.21, 17.4],
              [2448, 120, 90], [2449, 120, 90], [2452, 70, 70], [2454, 120, 90], [2456, 70, 70], [2458, 42.99, 19.09],
              [2459, 32.63, 40.69], [2462, 120, 90], [2465, 120, 90], [2466, 120, 90], [2467, 12, 21.72],
              [2468, 40, 50], [2470, 120, 90], [2471, 120, 90], [2472, 78.4, 34.97], [2473, 120, 90], [2474, 120, 90],
              [2475, 70, 70], [2476, 120, 90], [2477, 70, 70], [2478, 120, 90], [2479, 50, 60], [2480, 25.72, 16.26],
              [2481, 50, 60], [2482, 120, 90], [2483, 120, 90], [2484, 120, 90], [2485, 26.73, 30.59], [2486, 70, 70],
              [2487, 70, 70], [2488, 53.21, 52.23], [2490, 70, 70], [2493, 104.76, 45.88], [2494, 57.1, 29.4],
              [2495, 40, 50], [2496, 120, 90], [2497, 40.2, 11.31], [2499, 13.19, 8.58], [2500, 14.55, 14.52],
              [2501, 70, 70], [2504, 120, 90], [2505, 70, 70], [2507, 120, 90], [2508, 70, 70], [2509, 21.55, 18.6],
              [2510, 70, 70], [2511, 120, 90], [2512, 120, 90], [2513, 7, 18.7], [2514, 120, 90], [2515, 50, 60],
              [2516, 40.7, 39.93], [2518, 74.82, 43.44], [2519, 120, 90], [2520, 104, 174], [2521, 50, 60],
              [2524, 10.39, 13.16], [2525, 70, 70], [2526, 70, 70], [2527, 49.14, 44.47], [2528, 120, 90],
              [2529, 43.73, 38.98], [2530, 70, 70], [2532, 70, 70], [2533, 23.69, 46.33], [2534, 120, 90],
              [2535, 5.38, 6.5], [2536, 5.45, 5.06], [2537, 120, 90], [2539, 70, 30.72], [2540, 40.04, 38.42],
              [2542, 34.79, 22.79], [2543, 27.67, 25], [2545, 40, 50], [2546, 70, 70], [2547, 17.63, 16.94],
              [2548, 70, 70], [2549, 70, 70], [2551, 71.76, 36.27], [2553, 70, 70], [2554, 16.72, 26.29],
              [2555, 52.5, 52.5], [2558, 40, 50], [2562, 111.85, 42.43], [2563, 61.13, 37.95], [2564, 40.56, 78.59],
              [2565, 40, 50], [2566, 10.13, 8.41], [2568, 70, 70], [2569, 34.08, 20.39], [2571, 50, 60],
              [2572, 120, 90], [2574, 107.79, 57.67], [2575, 70, 70], [2576, 70, 70], [2577, 16.06, 11.33],
              [2578, 70, 70], [2580, 120, 90], [2582, 70, 70], [2584, 120, 90], [2585, 70, 58.43], [2587, 66.78, 50.99],
              [2589, 70, 70], [2590, 120, 90], [2591, 120, 90], [2592, 120, 105], [2593, 109.49, 44.64], [2595, 70, 70],
              [2596, 120, 90], [2597, 40, 50], [2598, 70, 70], [2600, 50, 60], [2601, 70, 70], [2603, 120, 90],
              [2604, 14.91, 16.67], [2606, 18.48, 15.38], [2607, 14.85, 16.55], [2608, 70, 70], [2610, 70, 70],
              [2612, 19.02, 24.51], [2613, 120, 90], [2615, 80.55, 54.14], [2617, 17.59, 35.03], [2619, 57.48, 50.98],
              [2620, 60, 60], [2621, 120, 90], [2622, 22.29, 20.66], [2623, 36.98, 28.35], [2624, 120, 90],
              [2627, 70, 70], [2628, 47.2, 82.28], [2630, 120, 90], [2631, 70, 70], [2632, 22.83, 26.19],
              [2633, 36.95, 67.11], [2634, 120, 90], [2635, 12, 22.39], [2636, 70, 70], [2638, 70, 70],
              [2639, 9.66, 9.9], [2642, 120, 90], [2644, 71.93, 71.93], [2646, 30, 45], [2647, 51.91, 54.1],
              [2649, 50, 60], [2650, 120, 90], [2651, 32.4, 19.95], [2652, 37.5, 45], [2653, 70, 70], [2655, 40, 50],
              [2656, 69.06, 43.42], [2658, 40.97, 26.68], [2660, 40, 50], [2661, 70, 70], [2663, 50, 60],
              [2664, 11, 16.7], [2665, 70, 70], [2667, 63.81, 52.19], [2668, 39.53, 31.14], [2669, 75, 64.66],
              [2670, 70, 70], [2671, 50, 45], [2672, 13.43, 14.62], [2677, 70, 70], [2681, 70, 70], [2682, 178, 216],
              [2683, 9.17, 6.35], [2684, 70.83, 69.48], [2685, 50, 60], [2686, 9.12, 8.12], [2687, 94.14, 34.56],
              [2691, 50, 60], [2692, 70, 70], [2694, 120, 90], [2695, 12, 18], [2696, 70, 70], [2697, 120, 90],
              [2703, 50, 60], [2704, 10.96, 9.94], [2706, 120, 90], [2707, 70, 70], [2710, 18.57, 12.32],
              [2711, 50, 60], [2712, 70, 70], [2714, 50, 60], [2716, 70, 70], [2719, 70, 70], [2720, 46, 38.9],
              [2722, 120, 90], [2723, 70, 70], [2725, 70, 70], [2726, 120.52, 25.63], [2728, 120, 90], [2730, 50, 60],
              [2731, 120, 90], [2734, 50, 60], [2735, 6.21, 6.8], [2736, 30, 45], [2737, 40, 50], [2738, 40, 37.5],
              [2739, 50, 60], [2740, 120, 90], [2741, 88, 114], [2743, 30.71, 32.21], [2746, 70, 70],
              [2747, 63.12, 31.83], [2748, 123.58, 59.04], [2750, 30, 45], [2752, 70, 70], [2753, 50, 60],
              [2755, 120, 90], [2756, 77, 96], [2757, 120, 90], [2758, 36.94, 36.69], [2759, 120, 90], [2760, 120, 90],
              [2762, 120, 90], [2763, 120, 90], [2764, 70, 70], [2765, 120, 90], [2766, 8.32, 6.64], [2767, 120, 90],
              [2768, 120, 90], [2770, 120, 90], [2772, 70, 70], [2773, 50, 60], [2774, 120, 90], [2775, 70, 70],
              [2778, 70, 70], [2781, 9.91, 6.13], [2782, 50, 60], [2783, 70, 70], [2784, 70, 70], [2785, 5.56, 14],
              [2786, 70, 70], [2787, 64.37, 35.05], [2788, 96.68, 56.26], [2791, 30, 37.5], [2792, 120, 90],
              [2793, 40, 50], [2795, 70, 70], [2796, 70, 70], [2797, 38.38, 16.45], [2798, 12, 21.53], [2800, 70, 70],
              [2801, 120, 90], [2804, 16.93, 11.94], [2806, 70, 70], [2807, 36.77, 11.92], [2808, 50, 60],
              [2809, 120, 90], [2811, 34.31, 28.04], [2813, 34.06, 29.31], [2814, 120, 90], [2818, 9.74, 14.61],
              [2819, 11.84, 8.58], [2820, 70, 70], [2821, 70, 70], [2822, 40, 50], [2823, 59.27, 44.08], [2826, 40, 50],
              [2827, 21.89, 30.71], [2831, 120, 90], [2832, 23.2, 22.2], [2833, 65.79, 46.49], [2834, 50, 60],
              [2835, 37.5, 45], [2836, 36.81, 31.39], [2837, 120, 90], [2838, 120, 90], [2839, 120, 90],
              [2841, 120, 90], [2844, 70, 70], [2845, 120, 90], [2846, 40, 23.06], [2847, 30, 45], [2850, 50, 60],
              [2851, 75.14, 53.01], [2852, 37.5, 45], [2853, 70, 70], [2854, 25.17, 19.72], [2856, 124.74, 77.59],
              [2857, 120, 90], [2861, 50, 60], [2862, 70, 70], [2863, 25.3, 31], [2864, 120, 90], [2865, 120, 90],
              [2866, 50, 60], [2867, 120, 90], [2869, 5.93, 4.86], [2871, 120, 90], [2872, 31.07, 14.75],
              [2876, 101.18, 75.84], [2877, 120, 90], [2878, 120, 90], [2879, 50, 60], [2880, 39, 52.5],
              [2882, 120, 90], [2883, 48.97, 31.48], [2884, 70.14, 48.85], [2885, 70, 70], [2886, 70, 70],
              [2887, 70, 70], [2889, 70, 70], [2890, 70, 70], [2891, 120, 90], [2893, 120, 90], [2894, 120, 90],
              [2897, 120, 90], [2899, 70, 70], [2900, 50, 60], [2901, 107.65, 88.66], [2902, 120, 90], [2903, 120, 90],
              [2904, 65, 40.54], [2905, 50, 60], [2906, 120, 90], [2907, 11.65, 11.52], [2908, 70, 70],
              [2910, 49.02, 40.47], [2911, 120, 90], [2914, 70, 70], [2916, 70, 70], [2917, 50, 60],
              [2918, 17.8, 10.33], [2919, 120, 90], [2921, 120, 90], [2922, 16, 18], [2923, 26.73, 30.82],
              [2924, 120, 90], [2925, 120, 90], [2928, 70, 70], [2929, 50.7, 47.79], [2930, 155, 210], [2931, 70, 70],
              [2932, 30, 24.3], [2933, 70, 70], [2934, 85.78, 39.36], [2935, 120, 90], [2936, 90.08, 68.66],
              [2937, 120, 90], [2940, 120, 90], [2942, 70, 70], [2943, 120, 90], [2944, 50, 60], [2946, 117.5, 74.87],
              [2948, 50, 60], [2950, 110.01, 49.26], [2951, 120, 90], [2952, 70, 70], [2955, 70, 70],
              [2956, 30.2, 34.9], [2957, 120, 90], [2958, 70, 70], [2960, 50, 60], [2961, 70, 70], [2962, 40, 50],
              [2963, 120, 90], [2964, 50, 60], [2965, 120, 90], [2969, 15.24, 25.59], [2971, 70, 70], [2972, 120, 90],
              [2973, 70, 65], [2974, 22.89, 34.75], [2975, 70, 70], [2976, 120, 90], [2978, 24.61, 18.48],
              [2979, 27.1, 18.5], [2980, 21.22, 18.94], [2982, 40, 50], [2984, 13.6, 13.23], [2985, 50, 60],
              [2986, 120, 90], [2988, 120, 90], [2989, 50, 60], [2991, 50, 60], [2995, 36.26, 41.54],
              [2997, 11.88, 8.2], [2999, 6.02, 5.8], [3000, 50, 60], [3001, 56.14, 45.79], [3002, 70, 70],
              [3003, 120, 90], [3004, 48.58, 95.54], [3006, 70, 70], [3008, 28.3, 32.4], [3009, 50, 60],
              [3011, 13.6, 28.86], [3012, 70, 70], [3014, 120, 90], [3015, 30, 37.5], [3016, 22.14, 18.78],
              [3017, 120, 90], [3019, 50, 60], [3022, 120, 90], [3024, 70, 70], [3025, 70, 70], [3026, 12.16, 8.01],
              [3027, 22, 43.41], [3031, 50, 60], [3033, 120, 90], [3035, 29.76, 27.35], [3037, 50, 60],
              [3041, 52.5, 52.5], [3042, 5.83, 5.64], [3043, 70, 70], [3044, 70, 70], [3045, 120, 90],
              [3046, 50.66, 21.51], [3047, 50, 60], [3048, 101.09, 97.17], [3049, 120, 90], [3050, 27.97, 29.63],
              [3051, 120, 90], [3052, 50, 60], [3053, 70, 70], [3054, 50, 60], [3055, 120, 90], [3056, 15.98, 16.7],
              [3057, 70, 70], [3058, 70, 70], [3059, 120, 90], [3060, 70, 70], [3061, 128.24, 46.52], [3063, 70, 70],
              [3064, 121, 253], [3066, 70, 70], [3069, 120, 90], [3070, 56.43, 49.17], [3073, 120, 90], [3076, 120, 90],
              [3077, 39.42, 34.65], [3078, 70, 70], [3079, 70, 70], [3084, 70, 70], [3085, 50, 60], [3086, 97.92, 38.7],
              [3087, 70, 70], [3089, 38.17, 24], [3090, 50, 60], [3091, 19.67, 20.1], [3092, 70, 70], [3095, 120, 90],
              [3098, 20.76, 58.98], [3100, 120, 90], [3101, 120, 90], [3104, 7.73, 6.59], [3105, 70, 70],
              [3106, 34.5, 25.1], [3107, 120, 90], [3109, 50, 60], [3112, 79.98, 40.43], [3113, 50, 60],
              [3114, 120, 90], [3115, 120, 90], [3117, 50, 60], [3118, 120, 90], [3119, 12.2, 16.8],
              [3121, 69.55, 32.33], [3122, 63.25, 33.78], [3123, 120, 90], [3126, 70, 70], [3127, 9.37, 9.65],
              [3128, 62, 50], [3129, 37.84, 31.71], [3130, 12, 10], [3131, 8.27, 8.03], [3132, 120, 90],
              [3133, 72.02, 36.75], [3134, 50, 45], [3135, 120, 90], [3136, 40, 50], [3137, 12.56, 13.35],
              [3138, 120, 90], [3139, 5.88, 5.48], [3140, 70, 70], [3141, 50, 60], [3142, 40, 50], [3143, 70, 70],
              [3144, 120, 90], [3148, 33.08, 29.22], [3149, 120, 90], [3151, 120, 90], [3152, 50, 60],
              [3154, 87.45, 60.56], [3155, 98.27, 51.32], [3158, 18, 18], [3160, 37.27, 60.05], [3161, 20.3, 19.5],
              [3163, 70, 70], [3164, 70, 70], [3165, 70, 45.26], [3166, 0.17, 0.59], [3167, 69.49, 38], [3168, 120, 90],
              [3171, 40, 50], [3172, 120, 90], [3175, 73.26, 36.41], [3177, 37.5, 45], [3181, 8.14, 6.4],
              [3182, 22.27, 15.36], [3183, 51.17, 40.2], [3184, 70, 70], [3187, 24.7, 20.1], [3188, 14.43, 16.56],
              [3189, 192.54, 70.66], [3190, 26.99, 20.03], [3191, 70, 70], [3192, 120, 90], [3195, 22.52, 19.08],
              [3196, 70, 70], [3197, 99.63, 37.69], [3198, 9.06, 10.25], [3199, 70, 70], [3200, 40, 50],
              [3203, 12.22, 10.64], [3206, 36.81, 46.42], [3207, 50, 60], [3208, 120, 90], [3211, 70, 70],
              [3212, 120, 90], [3214, 70, 70], [3216, 120, 90], [3217, 34.82, 34.71], [3219, 10.36, 9.85],
              [3220, 120, 90], [3221, 70, 70], [3225, 6.02, 7.89], [3227, 25, 20], [3228, 34.26, 35.61],
              [3229, 120, 90], [3231, 26.42, 28.94], [3234, 37.45, 21.3], [3239, 120, 90], [3240, 120, 90],
              [3241, 50, 60], [3242, 70, 70], [3243, 12.14, 9.5], [3244, 120, 90], [3246, 65.38, 60.87],
              [3247, 120, 90], [3248, 40, 17.83], [3249, 120, 90], [3251, 40, 50], [3252, 50, 60], [3253, 70, 70],
              [3254, 40.73, 38.06], [3255, 70, 70], [3256, 30.27, 22.34], [3257, 50, 60], [3258, 70, 70],
              [3259, 50, 60], [3260, 10, 13.06], [3262, 70, 70], [3263, 120, 90], [3264, 13.13, 23.21], [3265, 120, 90],
              [3266, 70, 70], [3267, 50, 60], [3268, 59.2, 40.69], [3270, 17.3, 14.21], [3271, 120, 90],
              [3272, 106.83, 78.93], [3273, 120, 90], [3274, 45, 32.77], [3275, 120, 90], [3276, 120, 90],
              [3277, 91.74, 42.99], [3278, 63.11, 20.86], [3279, 70, 70], [3280, 59.87, 41.55], [3283, 12.69, 12.13],
              [3284, 42.57, 30.98], [3286, 15.7, 9.65], [3287, 50, 60], [3288, 30.42, 23.34], [3289, 85, 70],
              [3290, 21.59, 14.57], [3292, 120, 90], [3293, 70, 70], [3294, 50, 60], [3295, 120, 90], [3296, 30, 45],
              [3300, 70, 70], [3301, 70, 70], [3302, 40, 50], [3303, 70, 70], [3305, 120, 90], [3306, 32.44, 29.79],
              [3308, 70, 70], [3309, 50, 45], [3312, 70, 70], [3313, 120, 90], [3314, 50, 60], [3315, 120, 90],
              [3316, 120, 90], [3318, 70, 70], [3319, 70, 70], [3320, 120, 90], [3321, 50, 60], [3322, 120, 90],
              [3324, 9.8, 13.83], [3325, 38.61, 28.27], [3326, 51.15, 39.66], [3327, 98.77, 87.26], [3328, 120, 90],
              [3329, 8.87, 8.14], [3331, 108.09, 47.79], [3332, 120, 90], [3333, 120, 90], [3334, 8.78, 7.44],
              [3335, 70, 70], [3336, 46.22, 26.88], [3338, 70, 70], [3340, 50, 60], [3341, 24.19, 12.04],
              [3342, 70, 70], [3343, 120, 90], [3344, 99.81, 58.02], [3346, 62.21, 43.82], [3347, 120, 90],
              [3348, 70, 70], [3350, 120, 90], [3351, 120, 90], [3353, 120, 90], [3357, 12.58, 12.94],
              [3358, 19.2, 17.45], [3359, 120, 90], [3361, 120, 90], [3363, 14.08, 11.88], [3364, 12, 21.69],
              [3366, 120, 90], [3367, 50, 60], [3369, 120, 90], [3370, 47.38, 71.88], [3371, 70, 60], [3372, 70, 70],
              [3376, 120, 90], [3378, 9.02, 8.54], [3380, 120, 90], [3381, 120, 90], [3382, 23.2, 25.03],
              [3384, 70, 70], [3386, 120, 90], [3387, 70, 70], [3388, 120, 90], [3389, 31.29, 20.21], [3390, 120, 90],
              [3391, 120, 90], [3392, 120, 90], [3393, 120, 90], [3394, 120, 90], [3396, 21.88, 28.51], [3399, 70, 70],
              [3400, 50, 60], [3402, 120, 90], [3403, 16.87, 10.26], [3404, 41.37, 52.15], [3407, 59.05, 33.48],
              [3408, 120, 90], [3411, 70, 70], [3414, 50, 60], [3415, 40, 50], [3416, 40, 50], [3417, 70, 70],
              [3418, 120, 90], [3419, 70, 70], [3420, 70, 70], [3422, 50.99, 25.75], [3423, 120, 90], [3424, 37.5, 45],
              [3426, 120, 90], [3428, 70, 70], [3429, 46.45, 44.76], [3431, 120, 90], [3432, 70, 70],
              [3433, 19.6, 20.1], [3434, 6.86, 5.46], [3436, 50, 60], [3437, 70, 70], [3438, 70, 70],
              [3439, 60.72, 58.05], [3440, 50, 60], [3441, 59.78, 46.81], [3442, 42.15, 37.9], [3444, 17.9, 15.29],
              [3445, 70, 70], [3448, 5.56, 6.38], [3449, 70, 70], [3450, 70, 70], [3451, 71.38, 68.39], [3452, 120, 90],
              [3453, 15.33, 23.54], [3454, 18.63, 15.82], [3456, 120, 90], [3457, 120, 90], [3459, 72.5, 55.8],
              [3461, 68.26, 26.15], [3462, 55.41, 24.77], [3463, 120, 90], [3464, 120, 90], [3468, 73.94, 42.49],
              [3469, 34.89, 19.21], [3471, 70, 70], [3472, 120, 90], [3473, 12.27, 10.63], [3474, 70, 70],
              [3476, 40, 50], [3480, 120, 90], [3481, 120, 206], [3482, 70, 70], [3483, 70, 70], [3484, 120, 90],
              [3485, 52.28, 52.85], [3487, 50, 60], [3488, 23, 23], [3489, 40, 50], [3492, 120, 90], [3493, 70, 70],
              [3494, 12, 18], [3496, 120, 90], [3497, 120, 90], [3498, 38.68, 34.83], [3499, 120, 90], [3501, 120, 90],
              [3503, 120, 90], [3504, 70, 70], [3505, 120, 90], [3508, 120, 90], [3509, 40, 60], [3510, 120, 90],
              [3511, 70, 70], [3514, 18.7, 27], [3515, 70, 70], [3516, 120, 90], [3517, 70, 70], [3518, 120, 90],
              [3519, 50, 60], [3520, 120, 90], [3521, 120, 90], [3523, 120, 90], [3525, 120, 90], [3527, 120, 90],
              [3530, 52.8, 38.6], [3531, 70.97, 39.98], [3534, 70, 70], [3535, 30, 45], [3537, 120, 90],
              [3539, 120, 90], [3541, 42.81, 43.65], [3543, 120, 90], [3545, 120, 90], [3546, 120, 90],
              [3549, 22.69, 14.17], [3551, 120, 90], [3553, 70, 70], [3554, 50, 60], [3555, 40, 50],
              [3557, 16.81, 25.35], [3558, 70, 70], [3559, 50, 60], [3560, 120, 90], [3561, 120, 90], [3564, 120, 90],
              [3566, 17.61, 17.41], [3568, 12.22, 9.98], [3569, 50, 60], [3570, 70, 70], [3571, 70, 70],
              [3572, 120, 90], [3573, 120, 90], [3575, 120, 90], [3576, 120, 90], [3577, 70, 70], [3579, 22.92, 33.97],
              [3580, 70, 70], [3581, 120, 90], [3582, 4.45, 5.68], [3585, 70, 70], [3586, 70, 70], [3587, 70, 70],
              [3588, 120, 90], [3589, 12, 18], [3590, 40, 43.95], [3592, 70, 70], [3593, 35.78, 25.31], [3594, 120, 90],
              [3595, 120, 90], [3596, 120, 90], [3597, 70, 70], [3598, 22.96, 24.32], [3599, 120, 90],
              [3600, 49.66, 38.48], [3601, 40, 50], [3602, 51.79, 46.05], [3606, 40, 50], [3607, 12.7, 15.8],
              [3608, 33.57, 26.7], [3609, 120, 90], [3610, 50, 71], [3611, 156, 211], [3612, 70, 70], [3613, 40, 50],
              [3614, 9.76, 7.31], [3615, 70, 70], [3617, 70, 70], [3619, 70, 70], [3620, 50, 60], [3621, 50, 60],
              [3622, 120, 90], [3623, 120, 90], [3624, 16.21, 10.44], [3626, 120, 90], [3627, 120, 90], [3628, 30, 45],
              [3629, 70, 70], [3631, 70, 70], [3632, 47.16, 37.74], [3633, 70, 70], [3634, 24.1, 17.22], [3635, 50, 60],
              [3636, 70, 70], [3637, 40, 50], [3639, 120, 90], [3641, 40, 50], [3642, 58.18, 27.21], [3643, 70, 70],
              [3644, 36.34, 36.78], [3647, 70, 70], [3648, 70, 70], [3649, 120, 90], [3650, 93.96, 49.61],
              [3651, 40, 50], [3652, 40, 50], [3653, 52.81, 42.1], [3656, 16.63, 13.83], [3657, 40, 50],
              [3659, 45.77, 17.29], [3661, 49.38, 28.07], [3662, 30, 45], [3663, 120, 90], [3665, 120, 90],
              [3666, 120, 90], [3667, 30.55, 36.38], [3668, 120, 90], [3669, 12, 25.38], [3670, 91.39, 52.48],
              [3671, 120, 90], [3675, 120, 90], [3676, 120, 90], [3677, 50, 60], [3678, 11.23, 7.28],
              [3679, 29.5, 43.67], [3681, 70, 70], [3683, 7.87, 11.07], [3685, 120, 90], [3686, 120, 90],
              [3687, 70, 70], [3688, 120, 90], [3690, 120, 90], [3691, 13.11, 11.71], [3692, 50, 60], [3694, 70, 70],
              [3695, 120, 90], [3696, 70, 70], [3698, 120, 90], [3700, 25.38, 59.21], [3701, 29.01, 18.72],
              [3702, 16.7, 11.85], [3703, 175.88, 66.13], [3705, 30, 45], [3707, 70, 70], [3708, 70, 70],
              [3710, 50, 60], [3711, 9.31, 9.41], [3713, 70, 70], [3714, 120, 90], [3716, 120, 90], [3718, 70, 70],
              [3719, 120, 90], [3720, 95.89, 30.16], [3722, 40, 50], [3723, 30, 45], [3724, 12.29, 10.32],
              [3726, 12, 18], [3728, 120, 90], [3729, 120, 90], [3731, 40, 25.08], [3733, 120, 90], [3738, 30, 45],
              [3741, 120, 90], [3745, 120, 90], [3747, 33.24, 30.21], [3748, 120, 90], [3749, 120, 90],
              [3751, 27.22, 22.15], [3752, 120, 90], [3753, 50, 60], [3755, 31.04, 34.22], [3756, 120, 90],
              [3758, 50, 60], [3759, 70, 70], [3761, 36.17, 17.01], [3762, 49.07, 30.08], [3763, 70, 70],
              [3764, 56.14, 29.13], [3765, 36.87, 29.24], [3766, 50, 60], [3768, 70, 70], [3769, 120, 90],
              [3775, 16.7, 21.1], [3776, 120, 90], [3777, 64.75, 33.71], [3780, 70, 70], [3781, 120, 90],
              [3782, 33.84, 17.76], [3783, 70, 70], [3785, 120, 90], [3786, 10.14, 9.72], [3791, 120, 90],
              [3793, 70, 70], [3795, 28.93, 71.01], [3796, 34.35, 19.61], [3797, 50, 60], [3799, 50, 60],
              [3800, 70, 70], [3801, 120, 90], [3802, 50, 60], [3804, 70, 70], [3807, 23.88, 19.39], [3811, 50, 60],
              [3812, 120, 90], [3814, 121, 70], [3815, 8.38, 6.36], [3816, 120, 90], [3820, 50, 60], [3821, 18.9, 24.5],
              [3822, 120, 90], [3824, 70, 70], [3826, 70, 70], [3827, 104.49, 49.9], [3828, 48.71, 27.21],
              [3830, 6.73, 6.06], [3832, 58.73, 69.61], [3833, 30, 45], [3834, 82.66, 53.29], [3837, 70, 70],
              [3839, 120, 90], [3840, 120, 90], [3841, 115.85, 58.55], [3842, 70, 70], [3843, 4.12, 8.93],
              [3845, 16.28, 21.19], [3846, 70, 70], [3849, 70, 70], [3850, 28.31, 33.02], [3851, 120, 90],
              [3853, 120, 90], [3854, 20.59, 23], [3855, 120, 90], [3856, 16.7, 22.9], [3858, 120, 90],
              [3859, 12, 23.21], [3862, 70, 70], [3863, 50, 60], [3865, 120, 90], [3866, 14.49, 13.27], [3867, 120, 90],
              [3868, 120, 90], [3869, 50, 60], [3870, 113.75, 53.42], [3871, 46.79, 28.4], [3873, 120, 90],
              [3874, 41.13, 34.16], [3877, 70, 70], [3879, 120, 90], [3880, 15.73, 17.34], [3881, 50, 60],
              [3882, 120, 90], [3883, 57.22, 73.4], [3884, 50, 60], [3886, 70, 70], [3887, 120, 90], [3889, 70, 70],
              [3890, 10.56, 9.46], [3891, 17.06, 21.5], [3892, 70, 70], [3896, 70, 70], [3897, 46.88, 27.21],
              [3898, 120, 90], [3899, 120, 90], [3900, 50.61, 29.08], [3901, 70, 70], [3903, 50, 60],
              [3905, 90.98, 55.27], [3906, 70, 70], [3909, 120, 90], [3910, 70, 70], [3915, 30, 45], [3916, 120, 90],
              [3918, 8.88, 7.78], [3919, 120, 90], [3921, 34.37, 32.04], [3922, 120, 90], [3923, 70, 70],
              [3924, 11.01, 5.63], [3925, 87.13, 64.34], [3927, 70, 70], [3928, 15.78, 11.76], [3929, 120, 90],
              [3930, 70, 70], [3931, 70, 70], [3932, 32.72, 42.52], [3933, 70, 70], [3935, 120, 90], [3936, 70, 70],
              [3937, 50, 60], [3938, 50, 60], [3939, 40, 50], [3940, 53.79, 32.63], [3941, 120, 90],
              [3942, 32.24, 20.58], [3943, 16.04, 19.53], [3944, 120, 90], [3946, 9.98, 9.98], [3947, 120, 90],
              [3950, 120, 90], [3951, 120, 90], [3952, 120, 90], [3953, 130.15, 56.8], [3954, 120, 90],
              [3956, 56.24, 62.52], [3958, 13.07, 12.08], [3959, 107.55, 47.75], [3960, 26.79, 20.82],
              [3961, 8.09, 5.91], [3963, 24.93, 29.76], [3964, 70, 70], [3966, 70, 70], [3968, 26.82, 32.61],
              [3969, 73.5, 49.04], [3970, 22.45, 62.54], [3971, 120, 90], [3972, 120, 86], [3976, 12, 24.6],
              [3978, 70, 70], [3979, 70, 70], [3980, 50, 60], [3981, 70, 70], [3982, 120, 90], [3983, 30, 45],
              [3985, 36, 28], [3988, 33.8, 45.99], [3990, 70, 70], [3991, 120, 90], [3992, 53.73, 58.98],
              [3993, 12, 18], [3994, 120, 90], [3996, 70, 95], [3997, 120, 90], [3998, 120, 90], [3999, 29.09, 38.47],
              [4001, 120, 90], [4002, 120, 90], [4003, 70, 70], [4004, 70, 70], [4005, 51.86, 17.81], [4007, 120, 90],
              [4008, 70, 70], [4010, 8.6, 12.5], [4012, 120, 90], [4013, 120, 90], [4014, 120, 90], [4015, 120, 90],
              [4016, 21, 33], [4017, 84.3, 28.73], [4018, 50, 60], [4019, 40, 50], [4021, 70, 70], [4022, 70, 70],
              [4023, 27.39, 27.85], [4024, 120, 90], [4026, 36.65, 22.13], [4027, 120, 90], [4028, 70, 70],
              [4031, 28.52, 48.27], [4034, 120, 90], [4035, 17.68, 13.86], [4038, 120, 90], [4040, 85.79, 70.07],
              [4041, 120, 90], [4043, 20, 20], [4045, 10.39, 9.07], [4047, 44.52, 35.91], [4048, 14.6, 19.7],
              [4049, 70, 70], [4051, 120, 90], [4053, 64.92, 33.42], [4057, 50, 60], [4059, 70, 70], [4062, 70, 70],
              [4063, 50, 60], [4065, 70, 70], [4066, 70, 70], [4067, 102.05, 42.28], [4068, 169, 150],
              [4069, 58.37, 31.62], [4070, 70, 70], [4071, 70, 70], [4072, 120, 90], [4073, 30, 45], [4074, 70, 70],
              [4076, 120, 90], [4080, 120, 90], [4081, 120, 90], [4082, 120, 90], [4083, 120, 90], [4084, 14, 13.72],
              [4085, 70, 70], [4087, 120, 90], [4088, 120, 90], [4089, 39.55, 33.1], [4090, 120, 90], [4091, 70, 70],
              [4092, 70, 70], [4093, 120, 90], [4094, 50, 60], [4095, 37.45, 42.54], [4096, 37.85, 49.46],
              [4097, 120, 90], [4100, 50, 60], [4102, 70, 70], [4103, 70, 70], [4104, 70, 70], [4105, 120, 90],
              [4106, 12.41, 18.24], [4107, 120, 90], [4109, 11.09, 23.39], [4110, 70, 70], [4111, 53.38, 47.38],
              [4112, 40, 50], [4115, 120, 90], [4116, 31.55, 32.55], [4117, 50, 60], [4118, 41.47, 35.71],
              [4119, 120, 90], [4120, 27.58, 30.03], [4121, 70, 70], [4122, 103.31, 86.3], [4124, 46.81, 38.06],
              [4125, 12, 18], [4128, 28, 24.17], [4129, 14.06, 10.13], [4131, 16.41, 11.2], [4133, 70, 70],
              [4134, 79.03, 44.3], [4136, 50, 60], [4137, 120, 90], [4138, 11.77, 6.96], [4139, 30, 45],
              [4140, 49.79, 34.67], [4142, 70, 70], [4143, 50, 60], [4145, 120, 90], [4146, 6.49, 5.75],
              [4147, 120, 90], [4149, 50, 60], [4150, 70, 70], [4152, 106.07, 54.99], [4154, 120, 90], [4155, 70, 70],
              [4156, 76.31, 53.54], [4157, 70, 70], [4158, 120, 90], [4159, 6.8, 6.65], [4162, 120, 90],
              [4164, 20.48, 22.01], [4165, 120, 90], [4166, 30, 45], [4167, 70, 70], [4168, 37.5, 45],
              [4169, 35.25, 45.76], [4173, 12, 24.28], [4175, 51.01, 25.06], [4176, 12, 18], [4177, 40.07, 56.69],
              [4178, 120, 90], [4179, 23.41, 16.69], [4180, 14.1, 8.76], [4181, 70, 70], [4182, 76.84, 36.41],
              [4185, 27.78, 27.06], [4186, 50, 60], [4188, 120, 90], [4189, 24.6, 36], [4190, 120, 90], [4192, 50, 60],
              [4193, 120, 90], [4194, 120, 90], [4197, 50, 60], [4199, 78.4, 74.93], [4200, 12.14, 9.28],
              [4203, 62.98, 58.18], [4205, 120, 90], [4206, 12.5, 12], [4207, 60.24, 34.36], [4208, 120, 90],
              [4209, 22.23, 20.17], [4210, 56.87, 36.84], [4211, 120, 90], [4213, 40.9, 35.4], [4215, 120, 90],
              [4216, 120, 90], [4219, 30, 45], [4220, 101, 196], [4221, 70, 70], [4222, 120, 90], [4223, 5.37, 4.59],
              [4224, 42.19, 39.65], [4225, 120, 90], [4226, 73.7, 42.65], [4229, 36.01, 22.9], [4230, 70, 70],
              [4231, 70, 70], [4232, 40, 50], [4233, 40, 50], [4234, 70, 70], [4235, 6.53, 5.13], [4236, 139, 137],
              [4237, 120, 90], [4238, 120, 90], [4239, 120, 90], [4241, 120, 90], [4242, 46.74, 74.49],
              [4244, 11.58, 16.71], [4245, 64, 70], [4246, 23.77, 36.35], [4248, 70, 70], [4249, 120, 90],
              [4250, 120, 90], [4251, 120, 90], [4252, 7.87, 9.28], [4256, 50, 60], [4257, 40, 50], [4258, 17, 38.5],
              [4259, 12.25, 12.29], [4260, 120, 90], [4261, 50, 60], [4264, 8.46, 8.46], [4265, 70, 70],
              [4266, 120, 90], [4269, 120, 90], [4270, 120, 90], [4272, 98.28, 54.81], [4273, 120, 90], [4274, 120, 90],
              [4275, 70, 70], [4279, 25.11, 25.86], [4281, 70, 70], [4282, 50, 60], [4283, 19.15, 24.03],
              [4284, 120, 90], [4285, 36.64, 28.69], [4286, 120, 90], [4287, 14.84, 10.96], [4288, 120, 90],
              [4289, 43.54, 28.73], [4291, 50, 60], [4293, 7.15, 6.68], [4294, 79.07, 70], [4295, 70, 70],
              [4296, 120, 90], [4297, 70, 70], [4298, 120, 85], [4299, 70, 48.52], [4301, 60.86, 37.6],
              [4302, 26.64, 23.08], [4305, 70, 70], [4307, 120, 90], [4308, 120, 90], [4309, 11.7, 18], [4310, 50, 60],
              [4312, 70, 70], [4313, 120, 90], [4317, 50, 60], [4318, 44.5, 31.24], [4320, 46.9, 37],
              [4323, 24.53, 33.29], [4325, 29.6, 19.97], [4326, 11.3, 11.2], [4328, 70, 70], [4329, 24.49, 21.37],
              [4330, 70, 70], [4333, 17.64, 32.54], [4334, 120, 90], [4337, 30.93, 37.77], [4338, 19.83, 26.04],
              [4339, 21.74, 15.6], [4340, 13.6, 21.8], [4341, 120, 90], [4343, 120, 90], [4345, 64.97, 47.25],
              [4346, 50, 60], [4347, 120, 90], [4349, 19.92, 20.51], [4350, 45.83, 36.77], [4352, 27.75, 35.04],
              [4353, 40.7, 33.52], [4355, 120, 90], [4356, 12.68, 15.44], [4358, 23.24, 26.31], [4360, 70, 70],
              [4362, 57.64, 39.46], [4363, 70, 70], [4364, 60.02, 38.25], [4365, 120, 90], [4366, 70, 70],
              [4367, 120, 90], [4372, 70, 70], [4374, 52, 51], [4375, 70, 70], [4376, 120, 90], [4377, 70, 70],
              [4378, 70, 70], [4380, 66.47, 40.12], [4382, 70, 65], [4383, 70, 70], [4384, 41.7, 25.8],
              [4386, 16.95, 21.6], [4387, 120, 90], [4389, 70, 70], [4390, 120, 90], [4391, 21.62, 31.72],
              [4392, 70, 70], [4394, 70, 70], [4395, 70, 70], [4396, 70, 70], [4397, 7.76, 8.86], [4398, 70, 70],
              [4399, 50, 60], [4400, 120, 90], [4402, 40, 50], [4404, 120, 90], [4405, 6.29, 4.6], [4406, 63.31, 68.07],
              [4407, 70, 70], [4408, 18, 27], [4409, 120, 90], [4410, 70, 70], [4411, 120, 90], [4412, 120, 90],
              [4413, 26.66, 14.26], [4414, 18.02, 27], [4415, 126.64, 97.53], [4416, 70, 70], [4417, 50, 60],
              [4418, 70, 70], [4419, 70, 70], [4420, 5.73, 6.7], [4421, 76.43, 44.44], [4426, 12, 18], [4427, 40, 50],
              [4428, 70, 70], [4432, 70, 70], [4433, 120, 90], [4436, 40, 50], [4438, 50, 50], [4439, 40, 50],
              [4440, 70, 70], [4441, 16.95, 12.33], [4442, 18, 27], [4443, 41.1, 27.5], [4444, 70, 70], [4445, 70, 70],
              [4446, 34.09, 21.45], [4448, 70, 70], [4450, 120, 90], [4453, 50, 60], [4454, 25.13, 30.27],
              [4455, 70, 70], [4456, 15.9, 14.4], [4457, 40, 50], [4460, 70, 70], [4461, 25.09, 25.72],
              [4463, 38.22, 20.51], [4464, 44.69, 25.78], [4465, 70, 70], [4466, 70, 70], [4467, 120, 90],
              [4468, 70, 70], [4470, 50, 60], [4471, 135.92, 55.65], [4473, 70, 70], [4477, 37.5, 45], [4479, 120, 90],
              [4481, 120, 90], [4482, 120, 90], [4484, 120, 90], [4486, 120, 90], [4487, 44.33, 51.92], [4488, 70, 70],
              [4489, 11.71, 6.08], [4490, 120, 90], [4491, 70, 70], [4493, 35.69, 81.75], [4494, 19.4, 18.2],
              [4495, 82.86, 52.5], [4498, 70, 70], [4500, 17.11, 23.93], [4501, 120, 90], [4502, 50, 60],
              [4504, 29.9, 16.62], [4505, 70, 70], [4506, 32.1, 29.68], [4508, 43.63, 35.85], [4509, 120, 90],
              [4510, 33.56, 26.64], [4511, 70, 70], [4512, 12.38, 7.83], [4513, 40, 50], [4514, 120, 90],
              [4515, 33.39, 72.42], [4517, 29.39, 25.61], [4518, 72.62, 43.09], [4520, 22.49, 21.03],
              [4521, 115.81, 56], [4523, 50, 60], [4524, 25.93, 22.72], [4525, 50, 60], [4526, 7.23, 8.94],
              [4527, 120, 90], [4530, 13.96, 9.89], [4531, 120, 90], [4532, 66.87, 50.91], [4533, 70, 70],
              [4534, 70, 70], [4535, 70, 70], [4536, 7.2, 20.3], [4538, 18, 18], [4539, 78.64, 44.85],
              [4540, 10.59, 6.68], [4541, 120, 90], [4542, 65, 35], [4543, 37.5, 45], [4545, 70, 70],
              [4546, 16.6, 24.9], [4548, 20.54, 15.72], [4549, 23.8, 26.7], [4550, 65.66, 48.34], [4551, 70, 70],
              [4552, 55.6, 45.56], [4553, 120, 90], [4555, 11.6, 15.4], [4556, 120, 90], [4558, 90.79, 78.09],
              [4560, 120, 90], [4563, 53.86, 28.78], [4566, 70, 70], [4568, 50, 60], [4569, 70, 70], [4571, 70, 70],
              [4572, 105.72, 48.73], [4576, 28.7, 23.7], [4577, 13.21, 11.61], [4578, 70, 70], [4579, 8.36, 6.62],
              [4580, 50, 60], [4582, 70, 70], [4584, 40, 50], [4585, 70, 70], [4587, 120, 90], [4590, 70, 70],
              [4591, 38.76, 40.37], [4593, 6.78, 5.29], [4597, 120, 90], [4598, 120, 90], [4599, 120, 90],
              [4600, 50, 60], [4601, 33.72, 42.28], [4602, 36.28, 36.4], [4603, 120, 90], [4604, 120, 90],
              [4605, 9.5, 15.6], [4606, 35.1, 31.57], [4607, 120, 90], [4608, 38.4, 32.2], [4610, 70, 70],
              [4611, 62.95, 50.94], [4612, 105, 166], [4613, 120, 77.8], [4614, 70, 70], [4615, 120, 90],
              [4616, 27.98, 41.56], [4617, 95.75, 69.39], [4618, 70, 70], [4619, 70, 70], [4620, 70, 70],
              [4621, 40, 50], [4622, 120, 90], [4623, 18, 27], [4626, 40, 50], [4627, 70, 70], [4628, 120, 90],
              [4629, 70, 70], [4630, 120, 90], [4631, 20.43, 22.07], [4633, 28.23, 35.68], [4634, 34.71, 35.52],
              [4635, 16.11, 11.7], [4636, 120, 90], [4637, 70, 70], [4638, 54.7, 34.62], [4641, 15.53, 8.78],
              [4643, 120, 90], [4644, 15.8, 15.4], [4645, 50, 60], [4648, 50, 60], [4649, 50, 60], [4651, 70, 70],
              [4652, 50, 60], [4653, 120, 90], [4655, 120, 90], [4657, 120, 90], [4658, 70, 70], [4660, 70, 70],
              [4661, 70, 70], [4662, 70, 70], [4664, 10.86, 8.78], [4665, 120, 90], [4666, 120, 90], [4667, 70, 70],
              [4668, 62.61, 42.44], [4670, 70, 70], [4671, 120, 90], [4674, 15, 20], [4675, 19.2, 19.5],
              [4676, 13.79, 18.19], [4677, 70, 70], [4679, 120, 90], [4682, 120, 90], [4684, 39.81, 23.32],
              [4685, 60.96, 34.44], [4687, 14.2, 21.3], [4688, 17.49, 12.85], [4689, 50, 60], [4690, 70, 70],
              [4691, 27.06, 17.14], [4692, 3.57, 3.82], [4693, 119.12, 52.9], [4694, 58.28, 38.29], [4695, 70, 70],
              [4696, 120, 90], [4697, 120, 90], [4698, 70, 70], [4699, 120, 90], [4701, 70, 70], [4702, 120, 90],
              [4703, 23.69, 36.87], [4704, 120, 90], [4705, 120, 90], [4708, 70, 70], [4709, 120, 90],
              [4710, 8.73, 6.69], [4711, 34.53, 20.2], [4712, 50.55, 38.31], [4713, 50, 60], [4716, 120, 90],
              [4717, 29.78, 34.18], [4718, 120, 90], [4720, 49.72, 35.65], [4722, 120, 90], [4724, 47.15, 28.88],
              [4725, 8.6, 7.78], [4726, 120, 90], [4728, 25.36, 23.41], [4729, 68.67, 36.75], [4731, 4.74, 5.39],
              [4732, 50, 60], [4733, 70, 70], [4734, 20, 20], [4736, 70, 70], [4737, 120, 90], [4738, 50.45, 38.8],
              [4740, 70, 70], [4741, 50, 60], [4742, 120, 90], [4743, 70, 70], [4744, 40, 50], [4745, 40, 50],
              [4747, 55.87, 35.31], [4749, 70, 70], [4750, 9.46, 10.97], [4751, 50, 60], [4752, 70, 70],
              [4753, 88.11, 37.86], [4754, 120, 90], [4755, 13.77, 7.34], [4756, 40, 50], [4757, 120, 90],
              [4760, 120, 90], [4761, 15.75, 12.37], [4762, 52.5, 52.5], [4764, 46.9, 75], [4765, 50, 60],
              [4771, 70, 70], [4772, 70, 70], [4775, 70, 70], [4776, 37.5, 45], [4777, 24.04, 33.32], [4778, 50, 60],
              [4779, 50, 60], [4780, 110.99, 50.6], [4781, 30, 37.5], [4782, 70, 70], [4784, 120, 90], [4785, 120, 90],
              [4786, 120, 90], [4788, 6.3, 12.1], [4789, 70, 70], [4790, 70, 70], [4791, 48.77, 79.01], [4792, 70, 70],
              [4793, 120, 90], [4794, 41.99, 22.03], [4797, 20.25, 21.58], [4799, 70, 70], [4800, 17.87, 23.42],
              [4801, 21, 27], [4802, 128.4, 56.12], [4803, 70, 70], [4805, 16.75, 18], [4806, 70, 70], [4807, 50, 60],
              [4809, 120, 90], [4810, 120, 90], [4811, 50, 60], [4812, 120, 90], [4814, 120, 90], [4815, 39.69, 32.93],
              [4816, 70, 70], [4818, 120, 90], [4819, 57.44, 40.47], [4820, 70, 70], [4821, 120, 90], [4825, 120, 90],
              [4826, 28.39, 26.06], [4828, 47.32, 22.66], [4829, 45.03, 39.57], [4831, 7.24, 8.44], [4832, 12, 18],
              [4834, 120, 90], [4835, 51.6, 40.69], [4838, 39.63, 29.51], [4839, 37.82, 38.91], [4840, 70, 70],
              [4841, 120, 90], [4842, 120, 90], [4844, 49.21, 40.22], [4846, 12.98, 17.47], [4848, 120, 90],
              [4849, 14.83, 14.22], [4851, 120, 90], [4852, 70, 70], [4853, 10.34, 10.99], [4854, 120, 90],
              [4856, 12, 18], [4863, 70, 70], [4864, 8.85, 15.97], [4865, 40, 50], [4866, 12, 18], [4867, 38.67, 22.56],
              [4869, 120, 90], [4871, 21.01, 27.1], [4872, 26.5, 30.18], [4875, 11.1, 18.8], [4876, 40, 50],
              [4877, 18.65, 29.18], [4878, 50, 60], [4879, 120, 90], [4880, 23.1, 15.3], [4881, 32.11, 49.85],
              [4882, 120, 90], [4885, 18, 23.69], [4887, 120, 90], [4888, 70, 70], [4893, 53.46, 31.32], [4894, 50, 60],
              [4895, 120, 90], [4896, 18.2, 35.8], [4897, 22.65, 32.49], [4902, 70, 70], [4905, 44, 67], [4906, 40, 50],
              [4907, 70, 70], [4909, 17.42, 19.96], [4910, 16.17, 15.54], [4911, 11.82, 7.07], [4912, 12.39, 15.28],
              [4914, 120, 90], [4915, 12.81, 25.88], [4916, 70, 70], [4918, 29.8, 29.23], [4920, 40, 50],
              [4922, 68.28, 37.1], [4923, 120, 90], [4926, 55.14, 28.19], [4927, 28.01, 18.8], [4928, 70, 70],
              [4929, 70, 70], [4930, 70, 70], [4931, 34.13, 33.6], [4934, 51.99, 38.18], [4936, 120, 90],
              [4939, 28.05, 30.31], [4940, 95.48, 82.93], [4942, 50, 60], [4944, 18, 18], [4946, 120, 90],
              [4949, 50, 60], [4950, 70.53, 51.44], [4951, 66.71, 36.01], [4953, 120, 90], [4954, 104, 179],
              [4955, 25.46, 23.67], [4956, 70, 70], [4957, 64.8, 59.23], [4958, 120, 90], [4960, 101.39, 50.61],
              [4962, 70, 70], [4963, 50, 66], [4964, 7.37, 6.44], [4965, 42.65, 79.28], [4966, 70, 70], [4968, 120, 90],
              [4971, 70, 70], [4972, 120, 90], [4973, 34.33, 57.8], [4974, 50, 60], [4975, 49.84, 42.61],
              [4976, 12, 22.97], [4977, 120, 90], [4978, 120, 90], [4979, 56.77, 40.85], [4981, 50, 60],
              [4983, 29.76, 20.92], [4984, 20, 13.27], [4985, 6.45, 5.95], [4987, 55.01, 32.18], [4988, 84, 107],
              [4989, 120, 90], [4990, 106.41, 53.31], [4992, 45.11, 33.84], [4994, 120, 90], [4995, 23.94, 28.78],
              [4996, 16.69, 30.91], [4997, 78.17, 40.51], [4998, 49.03, 43.06], [5000, 13.36, 12.29], [5001, 70, 70],
              [5002, 120, 90], [5003, 120, 90], [5005, 18.06, 19.95], [5006, 112, 90], [5007, 120, 90],
              [5008, 126.38, 53.28], [5009, 18.59, 27.74], [5010, 8.39, 5.61], [5011, 15.78, 16.19],
              [5012, 39.94, 45.98], [5013, 46.69, 34.25], [5014, 61.9, 35.6], [5017, 9.26, 20.62], [5019, 70, 45.82],
              [5020, 32.11, 40.08], [5022, 137.19, 88.29], [5023, 70, 70], [5025, 120, 90], [5026, 120, 90],
              [5027, 32.18, 30.47], [5031, 12, 18], [5032, 26.02, 40.08], [5033, 73.53, 35.42], [5035, 32.19, 33.94],
              [5037, 91.49, 46.75], [5038, 18, 27], [5041, 70, 70], [5043, 50, 60], [5044, 70, 70],
              [5046, 29.35, 32.47], [5048, 17.82, 19.75], [5049, 120, 90], [5050, 20.33, 12.35], [5051, 12, 18],
              [5053, 77.54, 45.07], [5054, 45.4, 28.5], [5056, 120, 90], [5057, 120, 90], [5058, 48.62, 42.89],
              [5060, 120, 90], [5061, 120, 90], [5062, 67.65, 70], [5063, 20.35, 50], [5064, 20.75, 20.03],
              [5065, 100.18, 69.74], [5066, 120, 90], [5068, 164.36, 62.76], [5069, 149.63, 54.69], [5070, 15.65, 30],
              [5071, 33.7, 31.78], [5072, 120, 90], [5073, 50, 60], [5075, 21.04, 24.86], [5077, 40, 50],
              [5079, 61.44, 42.57], [5081, 120, 90], [5082, 9.69, 9.33], [5083, 5.36, 5.53], [5084, 50, 60],
              [5085, 41.13, 26.96], [5091, 40.5, 33.65], [5092, 12, 18], [5093, 50, 60], [5094, 36.74, 43],
              [5095, 13.3, 17.3], [5097, 120, 90], [5098, 47.1, 29.63], [5099, 58.83, 35.89], [5100, 120, 90],
              [5101, 5.93, 6.13], [5102, 35.03, 31.53], [5103, 89.21, 43], [5104, 120, 90], [5107, 70, 65],
              [5108, 25, 40], [5109, 93.01, 45.96], [5111, 120, 90], [5114, 4.87, 4], [5115, 12.26, 31.18],
              [5116, 22.23, 21.49], [5117, 40, 50], [5119, 120, 90], [5121, 30.65, 46.26], [5122, 21.51, 31.21],
              [5123, 11.8, 11.02], [5124, 56.09, 43.95], [5126, 26.81, 24.11], [5127, 32.57, 20.36], [5128, 70, 70],
              [5130, 50, 60], [5132, 120, 90], [5135, 68.8, 41.77], [5136, 10.18, 8.06], [5137, 120, 90],
              [5138, 15.14, 13.83], [5141, 24.58, 21.45], [5143, 70, 70], [5145, 120, 90], [5149, 120, 90],
              [5150, 52.83, 33.37], [5153, 179.52, 59.91], [5154, 96, 141], [5155, 70, 70], [5156, 40, 50],
              [5157, 50, 60], [5159, 52.86, 48.43], [5160, 120, 90], [5161, 17.42, 15.54], [5162, 65.6, 46.34],
              [5163, 120, 90], [5164, 120, 90], [5165, 3.38, 5.47], [5166, 33.73, 21.58], [5167, 179, 220],
              [5169, 56.5, 44.9], [5171, 249.75, 64.69], [5172, 70, 70], [5173, 46.38, 41.15], [5174, 143.07, 72.47],
              [5178, 120, 90], [5180, 86.39, 54.81], [5181, 120, 90], [5182, 16.01, 20.04], [5183, 30.09, 35.52],
              [5184, 120, 90], [5185, 70, 70], [5186, 12, 18], [5187, 12, 18], [5188, 12, 18], [5189, 32, 40],
              [5191, 50, 25], [5192, 15, 25], [5193, 15, 25], [5194, 15, 25], [5195, 15, 25], [5196, 15, 25],
              [5197, 15, 25], [5198, 15, 25], [5199, 15, 25], [5200, 15, 25], [5201, 15, 25], [5202, 15, 25],
              [5203, 15, 25], [5204, 40, 50], [5205, 15, 25], [5206, 15, 25], [5207, 15, 25], [5208, 15, 25],
              [5209, 15, 25], [5210, 15, 25], [5211, 15, 25], [5212, 15, 25], [5213, 15, 25], [5214, 15, 25],
              [5215, 15, 25], [5216, 15, 25], [5217, 70, 70], [5218, 50, 60], [5219, 20.7, 31.7], [5220, 12.6, 25.3],
              [5221, 14.8, 27.6], [5222, 23, 18.2], [5223, 10.5, 15.3], [5224, 16.8, 30.5], [5225, 21.5, 24.2],
              [5226, 8.5, 20.2], [5227, 55.9, 46.8], [5228, 18.7, 32.7], [5229, 7, 15.8], [5230, 15.5, 13.1],
              [5231, 15.2, 18.9], [5232, 26.7, 34.4], [5233, 22.9, 36.3], [5234, 10.9, 17.5], [5235, 43.7, 39.9],
              [5236, 15.6, 18.9], [5237, 27.3, 31.4], [5238, 23.1, 25.3], [5239, 23.3, 28.2], [5240, 17, 31.3],
              [5241, 26.1, 21.4], [5242, 25.2, 23.2], [5243, 28.2, 26.9], [5244, 20.5, 30], [5245, 21.3, 30],
              [5247, 80, 60], [5248, 80, 60], [5249, 18.79, 11.59], [5250, 20.93, 10.99], [5251, 9.51, 7.03],
              [5252, 30, 16.56], [5253, 10.32, 10.66], [5254, 24.49, 16.32], [5255, 22.02, 14.56], [5256, 24.56, 17.38],
              [5257, 15.4, 13.96], [5258, 22.79, 18.26], [5259, 10.2, 9.75], [5260, 14.4, 8.76], [5261, 24.99, 12.73],
              [5263, 19.45, 15.67], [5264, 70, 38.11], [5265, 7.43, 6.83], [5266, 23.79, 12.6], [5267, 21.83, 11.15],
              [5268, 15.77, 12.82], [5269, 14.5, 9.26], [5270, 13.02, 16.2], [5271, 70, 70], [5272, 49.88, 21.16],
              [5273, 27.17, 19.34], [5274, 21.56, 23.35], [5275, 21.89, 20.99], [5276, 33.57, 69.59],
              [5277, 33.53, 44.16], [5278, 17.61, 19.46], [5279, 22.19, 26.31], [5280, 54.9, 42.95],
              [5281, 23.97, 21.11], [5282, 18.86, 21.15], [5283, 14.72, 24.85], [5284, 19.82, 21.97],
              [5285, 12.98, 10.05], [5286, 21.47, 25.37], [5287, 12.95, 13.1], [5288, 15.79, 13.5],
              [5289, 14.72, 18.53], [5290, 23.09, 21.92], [5291, 13.74, 15.42], [5292, 27.71, 17.72],
              [5293, 31.42, 28.8], [5294, 27.26, 35.13], [5295, 17.19, 14.3], [5296, 37.77, 51.52],
              [5297, 36.44, 42.37], [5298, 13.26, 13.27], [5299, 18.16, 20.87], [5300, 19.04, 16.88],
              [5301, 42.73, 37.25], [5302, 9.07, 5.65], [5303, 36.15, 21.1], [5304, 19.35, 28.15], [5305, 28.21, 24.21],
              [5306, 30.08, 35.59], [5307, 28.82, 42.89], [5308, 30.68, 46.96], [5309, 22.98, 21.99],
              [5310, 18.38, 19.26], [5311, 14.95, 17.32], [5312, 24.78, 19.47], [5313, 14.05, 18.92],
              [5314, 22.31, 24.96], [5315, 19.95, 27.16], [5316, 34.5, 42.49], [5317, 47.68, 75.34],
              [5318, 30.3, 21.67], [5319, 13.84, 14.27], [5320, 53.44, 55.56], [5321, 21.43, 22.1],
              [5322, 21.86, 31.16], [5323, 13.54, 22.48], [5324, 28.56, 35.07], [5325, 16.07, 19.54],
              [5326, 34.56, 41.14], [5327, 16.58, 21.05], [5328, 21.03, 21.33], [5329, 17.44, 17.44],
              [5330, 28.89, 22.93], [5331, 20.27, 21.28], [5332, 24.04, 29.18], [5333, 13.04, 16.32],
              [5334, 14.81, 13.78], [5335, 19.89, 15.44], [5336, 16.38, 19.14], [5337, 17.09, 17.7],
              [5338, 33.77, 26.64], [5339, 21.48, 24.94], [5340, 31.28, 38.93], [5341, 21.6, 30.78],
              [5342, 67.33, 44.59], [5343, 16.6, 14.81], [5344, 47.23, 50.54], [5345, 17.36, 20.76],
              [5346, 12.53, 15.06], [5347, 20.45, 23.78], [5348, 18.99, 19.54], [5349, 23.6, 27.71],
              [5350, 17.87, 30.23], [5351, 25.6, 34.49], [5352, 12.65, 19.75], [5353, 20.64, 26.6], [5354, 15.47, 9.25],
              [5355, 24.3, 42.86], [5356, 15.64, 19.61], [5357, 30.99, 21.01], [5358, 18.44, 20.69],
              [5359, 17.32, 25.16], [5360, 14.69, 9.66], [5361, 25.44, 28.51], [5362, 22.78, 37.54],
              [5363, 17.15, 20.75], [5364, 27.13, 35.08], [5365, 14.15, 16.33], [5366, 31.71, 24.96],
              [5367, 18.39, 19.03], [5368, 25.49, 33.82], [5369, 17.87, 17.73], [5370, 26.37, 19.9],
              [5371, 34.48, 40.39], [5372, 23.31, 23.21], [5373, 39.81, 52.34], [5374, 38.4, 30.66],
              [5375, 20.13, 18.67], [5376, 39.93, 36.29], [5377, 17.78, 19.64], [5378, 44.16, 54.79], [5379, 17.59, 16],
              [5380, 19.5, 24.07], [5381, 24.54, 27.3], [5382, 27.26, 39.02], [5383, 24.98, 28.96],
              [5384, 32.06, 28.26], [5385, 35.75, 25.11], [5386, 12.39, 14.93], [5387, 16.52, 16.08],
              [5388, 28.27, 31.03], [5389, 21.28, 32.3], [5390, 27.81, 21.8], [5391, 15.92, 17.92], [5392, 18.92, 29.5],
              [5393, 21.42, 30.33], [5394, 25.56, 27.95], [5395, 15.36, 21.7], [5396, 24.37, 24.45],
              [5397, 37.72, 55.15], [5398, 22.54, 21.56], [5399, 30.96, 24.28], [5400, 13.97, 12.67],
              [5401, 27.87, 36.25], [5402, 25.63, 36.95], [5403, 24.28, 25.06], [5404, 24.46, 24.68],
              [5405, 17.96, 16.23], [5406, 26.71, 28.04], [5407, 20.69, 24.62], [5408, 18.11, 22.5],
              [5409, 31.73, 36.57], [5410, 58.51, 46.49], [5411, 27.68, 21.48], [5412, 23.04, 18.15],
              [5413, 23.32, 18.19], [5414, 9.91, 15.09], [5415, 51.57, 56.26], [5416, 12.77, 13.87],
              [5417, 23.61, 19.35], [5418, 28.79, 36.91], [5419, 27.19, 25.1], [5420, 16.27, 16.14],
              [5421, 18.76, 15.11], [5422, 25.14, 34.37], [5423, 35.81, 32.77], [5424, 17.07, 19.91],
              [5425, 16.63, 19.74], [5426, 22.35, 32.83], [5427, 30.13, 36.75], [5428, 18.88, 25.12],
              [5429, 14.33, 16.18], [5430, 35.21, 32.17], [5431, 21.98, 23.51], [5432, 22.49, 30.65],
              [5433, 22.03, 25.8], [5434, 15.65, 16.63], [5435, 28.65, 36.45], [5436, 22.2, 26.91],
              [5437, 28.46, 24.42], [5438, 26.15, 45.07], [5439, 23.1, 32.12], [5440, 42.61, 31.07],
              [5441, 31.6, 43.27], [5442, 27.28, 31.24], [5443, 27.08, 44.53], [5444, 21.92, 35.18],
              [5445, 16.8, 20.91], [5446, 28.06, 29.76], [5447, 20.25, 23.23], [5448, 18.61, 19.97],
              [5449, 26.78, 33.16], [5450, 28.76, 31.21], [5451, 36.55, 47.48], [5452, 22.51, 34.53],
              [5453, 28.94, 32.53], [5454, 12.32, 16.18], [5455, 28.32, 21.25], [5456, 21.35, 24.85],
              [5457, 16.87, 25.48], [5458, 18.67, 22.48], [5459, 25.03, 25.93], [5460, 15.43, 17.97],
              [5461, 18.92, 17.99], [5462, 22.52, 26.38], [5463, 14.28, 17.95], [5464, 18.6, 18.27],
              [5465, 23.82, 23.85], [5466, 18.5, 23.11], [5467, 21.73, 26.16], [5468, 48, 73.78], [5469, 28.95, 22.5],
              [5470, 18.2, 26.19], [5471, 21.88, 24.32], [5472, 24.34, 29.62], [5473, 18.21, 24.01],
              [5474, 15.15, 14.65], [5475, 19.39, 18.75], [5476, 15.52, 20.64], [5477, 11.66, 13.63],
              [5478, 18.69, 21.99], [5479, 20.66, 18.21], [5480, 38.45, 32.17], [5481, 15.98, 18.15],
              [5482, 17.06, 18.76], [5483, 25.35, 27.15], [5484, 22.09, 21.1], [5485, 22.02, 23.57],
              [5486, 22.14, 21.65], [5487, 17.97, 21.38], [5488, 24.02, 25.06], [5489, 34.19, 66.05],
              [5490, 28.94, 32.56], [5491, 15.88, 20.08], [5492, 22.58, 38.47], [5493, 27.68, 21.75],
              [5494, 25.82, 30.23], [5495, 33.94, 27.03], [5496, 74.87, 78.15], [5497, 18.35, 22.55],
              [5498, 27.02, 39.89], [5499, 33.57, 24.3], [5500, 22.47, 23.4], [5501, 27.13, 46.22], [5502, 29.4, 31.24],
              [5503, 25.48, 24.22], [5504, 29.82, 41.45], [5505, 19.44, 30.38], [5506, 19.55, 18.02],
              [5507, 8.92, 15.03], [5508, 25.07, 35.23], [5509, 25.6, 36.32], [5510, 23.88, 39.9], [5511, 27.52, 24.5],
              [5512, 11.13, 11.46], [5513, 20.91, 23.63], [5514, 17.98, 18.09], [5515, 38.99, 31.52],
              [5516, 24.35, 34.55], [5517, 22.32, 28.37], [5518, 19.91, 18.99], [5519, 31.61, 40.04],
              [5520, 22.33, 22.91], [5521, 33.45, 39.31], [5522, 20.71, 22.53], [5523, 26.18, 29.99],
              [5524, 21.48, 50.1], [5525, 22.24, 21.41], [5526, 32.51, 26.74], [5527, 30.84, 34.66],
              [5528, 20.96, 19.72], [5529, 59.13, 37.8], [5530, 19.55, 21.33], [5531, 24.12, 22.95],
              [5532, 25.42, 24.65], [5533, 14.52, 14.84], [5534, 17.4, 14.87], [5535, 15.5, 12.89], [5536, 2, 2],
              [5537, 12.2, 8.94], [5538, 37.26, 35.28], [5539, 14.86, 20], [5540, 23.95, 34.62], [5541, 26.12, 21.77],
              [5542, 12.8, 16.15], [5543, 12.26, 16.58], [5544, 22.77, 32.88], [5545, 16.25, 22.22],
              [5546, 34.03, 40.31], [5547, 26.1, 25.13], [5548, 38.2, 46.39], [5549, 16.23, 22.79],
              [5550, 16.66, 17.46], [5551, 47.85, 75.99], [5552, 28.07, 25.33], [5553, 31.7, 29.24],
              [5554, 26.98, 30.18], [5555, 32.21, 32.76], [5556, 17.16, 17.29], [5557, 15.34, 14.19],
              [5558, 14.56, 19.66], [5559, 30.04, 31.58], [5560, 74.52, 28.37], [5561, 38.69, 49.15],
              [5562, 40.29, 56.03], [5563, 33.52, 34.96], [5564, 88.05, 56.53], [5565, 19.45, 18.12],
              [5566, 24.67, 27.3], [5567, 28.59, 35.72], [5568, 26.89, 35.03], [5569, 51.02, 38.85],
              [5570, 37.26, 27.17], [5571, 28.9, 21.65], [5572, 20.43, 17.7], [5573, 42.96, 28.46], [5600, 70, 129],
              [5627, 55, 125], [5632, 50, 70], [5636, 52, 60], [5638, 163, 120], [5646, 120, 104], [5648, 65, 172],
              [5649, 102, 108], [5659, 5.35, 4.7], [5660, 7.67, 7.45], [5661, 70, 70], [5663, 120, 90], [5666, 120, 90],
              [5672, 70, 70], [5675, 40, 50], [5677, 120, 90], [5681, 70, 70], [5683, 120, 90], [5689, 120, 90],
              [5706, 120, 90], [5715, 70, 70], [5717, 120, 90], [5720, 70, 70], [5726, 120, 90], [5728, 120, 90],
              [5737, 120, 90], [5738, 120, 90], [5745, 70, 70], [5747, 120, 90], [5757, 40, 50], [5758, 70, 70],
              [5764, 50, 60], [5768, 70, 70], [5777, 120, 90], [5789, 40, 50], [5805, 120, 90], [5808, 70, 70],
              [5811, 120, 90], [5819, 120, 90], [5824, 70, 70], [5830, 70, 70], [5833, 120, 90], [5840, 120, 90],
              [5841, 120, 90], [5846, 120, 90], [5848, 120, 90], [5851, 120, 90], [5855, 50, 60], [5856, 40, 50],
              [5861, 120, 90], [5869, 120, 90], [5876, 120, 90], [5877, 120, 90], [5880, 50, 60], [5881, 40, 50],
              [5882, 50, 60], [5884, 120, 90], [5889, 70, 70], [5898, 120, 90], [5903, 70, 70], [5911, 120, 90],
              [5917, 120, 90], [5918, 120, 90], [5919, 70, 70], [5931, 70, 70], [5933, 40, 50], [5936, 70, 70],
              [5939, 120, 90], [5941, 120, 90], [5942, 120, 90], [5943, 120, 90], [5944, 40, 50], [5945, 40, 50],
              [5946, 40, 50], [5947, 120, 90], [5948, 120, 90], [5949, 120, 90], [5950, 120, 90], [5951, 120, 90],
              [5953, 120, 90], [5954, 120, 90], [5955, 120, 90], [5956, 120, 90], [5957, 120, 90], [5958, 40, 50],
              [5959, 40, 50], [5961, 40, 50], [5962, 50, 60], [5970, 163, 136], [5985, 15, 25], [5986, 50, 60],
              [5987, 15, 25], [5988, 21, 33], [5989, 50, 60], [5990, 50, 60], [5991, 50, 60], [5992, 50, 60],
              [5993, 50, 60], [5994, 40, 50], [5995, 70, 70], [5996, 70, 70], [5997, 70, 70], [5998, 120, 90],
              [5999, 50, 60], [6049, 70, 70], [6050, 70, 70], [6051, 70, 70], [6052, 120, 90], [6053, 120, 90],
              [6054, 120, 90], [6055, 52.5, 52.5], [6066, 37.5, 45], [6067, 15, 25], [6068, 120, 90], [6069, 70, 70],
              [6070, 70, 70], [6071, 70, 70], [6072, 40, 50], [6073, 70, 70], [6074, 70, 70], [6075, 70, 70],
              [6076, 50, 60], [6077, 70, 70], [6078, 50, 60], [6079, 70, 70], [6080, 50, 60], [6081, 50, 60],
              [6082, 70, 70], [6083, 70, 70], [6084, 120, 90], [6085, 120, 90], [6086, 50, 60], [6087, 70, 70],
              [6088, 70, 70], [6089, 70, 70], [6090, 120, 90], [6091, 70, 70], [6092, 70, 70], [6093, 70, 70],
              [6094, 70, 70], [6095, 50, 60], [6096, 70, 70], [6097, 70, 70], [6098, 70, 70], [6099, 120, 90],
              [6100, 70, 70], [6101, 70, 70], [6102, 50, 60], [6103, 70, 70], [6104, 120, 90], [6105, 120, 90],
              [6106, 70, 70], [6107, 70, 70], [6108, 70, 70], [6109, 50, 60], [6110, 70, 70], [6111, 30, 45],
              [6112, 70, 70], [6113, 70, 70], [6114, 50, 60], [6115, 50, 60], [6116, 70, 70], [6117, 70, 70],
              [6118, 70, 70], [6119, 70, 70], [6120, 40, 50], [6121, 70, 70], [6122, 70, 70], [6123, 70, 70],
              [6124, 70, 70], [6125, 70, 70], [6126, 70, 70], [6127, 70, 70], [6128, 70, 70], [6129, 40, 50],
              [6130, 70, 70], [6131, 70, 70], [6132, 70, 70], [6133, 70, 70], [6134, 70, 70], [6135, 70, 70],
              [6136, 70, 70], [6137, 40, 50], [6138, 50, 60], [6139, 70, 70], [6140, 40, 50], [6141, 50, 60],
              [6142, 50, 60], [6143, 70, 70], [6144, 70, 70], [6145, 70, 70], [6146, 30, 45], [6147, 40, 50],
              [6148, 40, 50], [6149, 70, 70], [6150, 40, 50], [6151, 70, 70], [6152, 40, 50], [6153, 40, 50],
              [6154, 70, 70], [6155, 40, 50], [6156, 50, 60], [6157, 50, 60], [6158, 50, 60], [6159, 70, 70],
              [6160, 70, 70], [6161, 40, 50], [6162, 50, 60], [6163, 50, 60], [6164, 70, 70], [6165, 50, 60],
              [6166, 50, 60], [6167, 70, 70], [6168, 30, 45], [6169, 30, 45], [6170, 30, 45], [6227, 120, 90],
              [6228, 15, 25], [6229, 15, 25], [6230, 50, 60], [6231, 50, 60], [6232, 50, 60], [6233, 70, 70],
              [6234, 50, 60], [6235, 50, 60], [6236, 50, 60], [6238, 70, 70], [6239, 50, 60], [6240, 50, 60],
              [6241, 50, 60], [6242, 50, 60], [6243, 70, 70], [6244, 70, 70], [6245, 50, 60], [6246, 70, 70],
              [6247, 50, 60], [6248, 30, 45], [6252, 50, 60], [6253, 120, 90], [6255, 70, 70], [6256, 50, 60],
              [6258, 50, 60], [6259, 120, 90], [6260, 120, 90], [6261, 70, 70], [6262, 70, 70], [6263, 120, 90],
              [6264, 70, 70], [6265, 70, 70], [6266, 50, 60], [6267, 50, 60], [6268, 70, 70], [6269, 50, 60],
              [6270, 50, 60], [6271, 70, 70], [6272, 40, 50], [6274, 70, 70], [6275, 70, 70], [6276, 50, 60],
              [6277, 120, 90], [6278, 70, 70], [6279, 70, 70], [6280, 70, 70], [6281, 70, 70], [6282, 50, 60],
              [6283, 70, 70], [6284, 50, 60], [6286, 70, 70], [6287, 50, 60], [6288, 70, 70], [6289, 50, 60],
              [6290, 120, 90], [6292, 70, 70], [6293, 70, 70], [6294, 120, 90], [6295, 120, 90], [6296, 70, 70],
              [6297, 120, 90], [6299, 70, 70], [6300, 70, 70], [6301, 70, 70], [6302, 70, 70], [6303, 70, 70],
              [6305, 120, 90], [6306, 70, 70], [6307, 120, 90], [6308, 120, 90], [6309, 70, 70], [6310, 50, 60],
              [6312, 120, 90], [6313, 70, 70], [6314, 120, 90], [6315, 70, 70], [6316, 70, 70], [6317, 70, 70],
              [6319, 50, 60], [6320, 70, 70], [6321, 70, 70], [6323, 50, 60], [6324, 50, 60], [6325, 120, 90],
              [6326, 70, 70], [6327, 50, 60], [6328, 120, 90], [6330, 120, 90], [6334, 27.92, 22.8],
              [6335, 36.36, 27.35], [6336, 50, 35.7], [6337, 28.8, 13.04], [6338, 50, 33.77], [6339, 20.96, 16.45],
              [6340, 50, 36.94], [6341, 40, 23.08], [6342, 23.49, 10.98], [6343, 22.07, 18.41], [6344, 19.93, 9.57],
              [6345, 50, 21.26], [6346, 40, 25.58], [6347, 30.77, 13.81], [6348, 28.74, 14.96], [6349, 26.83, 18.14],
              [6350, 30.1, 29.64], [6351, 37.29, 18.38], [6353, 40, 50], [6354, 40, 50], [6355, 30, 45], [6356, 40, 50],
              [6357, 40, 50], [6358, 40, 50], [6359, 28.08, 27.32], [6360, 120, 109.36], [6361, 120, 90],
              [6362, 115.35, 155.44], [6363, 63.74, 113.55], [6364, 120, 108.36], [6365, 120, 90], [6366, 152, 95.28],
              [6367, 70, 70], [6368, 120, 119.04], [6369, 68.6, 48.47], [6370, 120, 90], [6371, 120, 130.57],
              [6372, 120, 90], [6373, 120, 90], [6374, 120, 64.08], [6375, 120, 90], [6376, 70, 70], [6377, 120, 90],
              [6378, 70, 70], [6379, 120, 78.19], [6380, 70, 91.63], [6381, 70, 70], [6382, 120, 108.36],
              [6383, 70, 70], [6384, 120, 108.36], [6385, 120, 65.11], [6386, 120, 90], [6387, 120, 90],
              [6388, 120, 90], [6389, 120, 90], [6390, 120, 90], [6391, 78.33, 99.36], [6392, 120, 90], [6393, 120, 90],
              [6394, 120, 90], [6395, 120, 90], [6396, 120, 117.19], [6397, 120, 90], [6398, 120, 90], [6399, 120, 90],
              [6400, 120, 109.36], [6401, 70, 70], [6402, 120, 130.57], [6403, 120, 90], [6404, 120, 90],
              [6405, 120, 90], [6406, 120, 109.36], [6407, 120, 109.36], [6408, 120, 90], [6409, 120, 90],
              [6410, 120, 90], [6411, 120, 90], [6412, 120, 90], [6413, 120, 90], [6414, 120, 109.36],
              [6415, 120, 119.04], [6416, 120, 90], [6417, 120, 90], [6418, 120, 90], [6419, 120, 90], [6420, 120, 90],
              [6421, 120, 117.19], [6422, 120, 109.36], [6423, 42.81, 43.17], [6424, 115.49, 81.33], [6425, 70, 98.36],
              [6426, 120, 117.19], [6427, 120, 90], [6428, 120, 90], [6429, 120, 90], [6430, 70, 86.89],
              [6431, 120, 90], [6432, 120, 90], [6433, 63.74, 113.55], [6434, 120, 90], [6435, 78.33, 99.36],
              [6436, 120, 90], [6437, 120, 90], [6438, 120, 90], [6439, 120, 125.74], [6440, 120, 90],
              [6441, 120, 109.36], [6442, 70, 70], [6443, 120, 90], [6444, 120, 90], [6445, 120, 90], [6446, 120, 90],
              [6447, 48.53, 70], [6448, 120, 90], [6449, 120, 90], [6450, 120, 90], [6451, 120, 90], [6452, 120, 90],
              [6453, 120, 90], [6454, 120, 90], [6455, 120, 90], [6456, 120, 90], [6457, 56.58, 70], [6458, 40, 55.85],
              [6459, 120, 125.74], [6460, 163.78, 95.28], [6461, 120, 90], [6462, 152, 95.28], [6463, 120, 90],
              [6464, 120, 90], [6465, 120, 90], [6466, 120, 90], [6467, 120, 90], [6468, 120, 90], [6469, 120, 101.08],
              [6470, 120, 90], [6471, 120, 109.36], [6472, 120, 108.36], [6473, 120, 90], [6474, 120, 90],
              [6475, 120, 90], [6476, 120, 108.36], [6477, 120, 90], [6478, 120, 90], [6479, 120, 90], [6480, 120, 90],
              [6481, 120, 90], [6482, 152, 95.28], [6483, 120, 109.36], [6484, 70, 56.48], [6485, 120, 90],
              [6486, 120, 90], [6487, 120, 90], [6488, 120, 90], [6489, 120, 90], [6490, 120, 108.36], [6491, 120, 90],
              [6492, 60.88, 72.65], [6493, 120, 90], [6494, 60.88, 72.65], [6495, 120, 125.74], [6496, 120, 109.36],
              [6497, 120, 90], [6498, 120, 125.74], [6499, 120, 90], [6500, 80.71, 115.49], [6501, 120, 90],
              [6502, 120, 78.19], [6503, 120, 109.36], [6504, 120, 130.57], [6505, 120, 91.63], [6506, 120, 90],
              [6507, 120, 90], [6508, 120, 90], [6509, 120, 119.04], [6510, 120, 90], [6511, 120, 90],
              [6512, 120, 109.36], [6513, 31.53, 53.27], [6514, 120, 90], [6515, 120, 90], [6516, 73.07, 58.95],
              [6517, 68.95, 86.89], [6518, 120, 117.19], [6519, 120, 90], [6520, 120, 90], [6521, 56.58, 56.58],
              [6522, 120, 90], [6523, 120, 90], [6524, 120, 90], [6525, 120, 90], [6526, 120, 90], [6527, 120, 125.74],
              [6528, 120, 125.74], [6529, 120, 90], [6530, 120, 109.36], [6531, 120, 90], [6532, 120, 125.74],
              [6533, 120, 91.63], [6534, 120, 119.04], [6535, 120, 90], [6536, 70.23, 106.94], [6537, 120, 90],
              [6538, 120, 90], [6539, 120, 90], [6540, 120, 90], [6541, 120, 90], [6542, 120, 108.36], [6543, 120, 90],
              [6544, 120, 90], [6546, 120, 90], [6547, 120, 90], [6548, 120, 90], [6549, 120, 90], [6550, 120, 90],
              [6551, 120, 90], [6552, 120, 108.36], [6553, 120, 90], [6554, 120, 90], [6555, 120, 90], [6556, 120, 90],
              [6557, 120, 90], [6558, 120, 90], [6559, 120, 90], [6560, 120, 90], [6561, 120, 90], [6562, 120, 90],
              [6563, 120, 90], [6564, 120, 90], [6565, 120, 90], [6566, 120, 78.64], [6567, 120, 90],
              [6568, 120, 109.36], [6569, 120, 90], [6570, 120, 90], [6572, 120, 90], [6573, 120, 90], [6574, 120, 90],
              [6575, 120, 119.04], [6576, 120, 90], [6577, 120, 90], [6578, 120, 109.36], [6579, 120, 90],
              [6580, 120, 90], [6581, 120, 90], [6582, 120, 90], [6583, 120, 90], [6584, 120, 90], [6585, 120, 109.36],
              [6586, 120, 130.57], [6587, 120, 90], [6588, 120, 109.36], [6589, 120, 90], [6590, 120, 90],
              [6591, 120, 90], [6592, 120, 90], [6593, 120, 90], [6594, 120, 90], [6595, 120, 90], [6596, 120, 90],
              [6597, 120, 90], [6598, 120, 90], [6599, 120, 90], [6600, 120, 90], [6601, 120, 90], [6602, 120, 125.74],
              [6603, 70, 70], [6604, 120, 119.04], [6605, 120, 108.36], [6606, 120, 90], [6607, 120, 125.74],
              [6608, 120, 109.36], [6609, 120, 90], [6610, 120, 90], [6611, 70, 91.63], [6612, 120, 119.04],
              [6613, 120, 90], [6614, 50, 101.08], [6615, 120, 130.57], [6616, 120, 90], [6617, 39.9, 34.9],
              [6618, 120, 90], [6619, 120, 90], [6620, 120, 90], [6621, 120, 90], [6622, 120, 90], [6623, 152, 95.28],
              [6624, 120, 108.36], [6625, 120, 90], [6626, 120, 90], [6627, 120, 90], [6628, 120, 90], [6629, 70, 70],
              [6630, 70, 70], [6631, 50, 60], [6632, 40, 50], [6633, 50, 60], [6634, 70, 70], [6635, 120, 90],
              [6636, 70, 70], [6637, 120, 90], [6638, 70, 70], [6639, 120, 90], [6640, 50, 60], [6641, 70, 70],
              [6642, 40, 50], [6643, 30, 40], [6648, 120, 90], [6649, 120, 90], [6650, 120, 90], [6651, 120, 90],
              [6652, 120, 90], [6653, 70, 70], [6654, 70, 70], [6655, 70, 70], [6656, 70, 70], [6657, 70, 70],
              [6660, 70, 70], [6661, 70, 70], [6662, 70, 70], [6663, 70, 70], [6664, 70, 70], [6665, 70, 70],
              [6666, 70, 70], [6667, 70, 70], [6668, 70, 70], [6669, 70, 70], [6670, 70, 70], [6671, 70, 70],
              [6672, 70, 70], [6673, 70, 70], [6674, 70, 70], [6675, 70, 70], [6676, 70, 70], [6677, 70, 70],
              [6678, 70, 70], [6679, 70, 70], [6680, 70, 70], [6682, 70, 70], [6683, 70, 70], [6684, 70, 70],
              [6685, 50, 60], [6686, 50, 60], [6687, 50, 60], [6688, 50, 60], [6689, 50, 60], [6690, 50, 60],
              [6691, 120, 90], [6692, 120, 90], [6697, 40, 50], [6698, 70, 70], [6699, 70, 70], [6700, 120, 90],
              [6701, 70, 70], [6702, 70, 70], [6703, 30, 40], [6704, 70, 70], [6705, 70, 70], [6706, 70, 70],
              [6707, 120, 90], [6708, 70, 70], [6709, 30, 40], [6710, 50, 60], [6711, 70, 70], [6712, 50, 60],
              [6713, 70, 70], [6714, 50, 60], [6715, 120, 90], [6716, 70, 70], [6717, 70, 70], [6718, 70, 70],
              [6719, 70, 70], [6720, 70, 70], [6721, 50, 60], [6722, 30, 40], [6723, 70, 70], [6724, 70, 70],
              [6725, 70, 70], [6726, 70, 70], [6727, 70, 70], [6728, 70, 70], [6729, 70, 70], [6730, 120, 90],
              [6731, 70, 70], [6732, 70, 70], [6733, 70, 70], [6734, 70, 70], [6735, 70, 70], [6736, 50, 60],
              [6737, 70, 70], [6738, 70, 70], [6739, 50, 60], [6740, 18, 27], [6741, 18, 27], [6742, 18, 27],
              [6743, 18, 27], [6746, 50, 60], [6748, 70, 70], [6749, 70, 70], [6750, 50, 60], [6752, 50, 60],
              [6753, 120, 90], [6754, 70, 70], [6755, 70, 70], [6756, 70, 70], [6757, 70, 70], [6758, 70, 70],
              [6759, 50, 60], [6760, 70, 70], [6761, 70, 70], [6762, 70, 70], [6763, 50, 60], [6764, 70, 70],
              [6766, 120, 90], [6767, 70, 70], [6768, 70, 70], [6769, 120, 90], [6770, 70, 70], [6771, 70, 70],
              [6772, 50, 60], [6773, 120, 90], [6777, 70, 70], [6778, 40, 50], [6779, 50, 60], [6780, 70, 70],
              [6781, 70, 70], [6782, 120, 90], [6783, 70, 70], [6784, 70, 70], [6785, 70, 70], [6786, 70, 70],
              [6787, 70, 70], [6789, 50, 60], [6824, 120, 90], [6825, 120, 90], [6826, 50, 60], [6827, 50, 60],
              [6828, 50, 60], [6829, 70, 70], [6830, 70, 70], [6831, 120, 90], [6832, 70, 70]]],
            [2000,
             [[1, 50, 60], [2, 120, 90], [3, 70, 70], [7, 35.26, 21.02], [9, 70, 70], [13, 120, 90], [14, 120, 90],
              [15, 70, 70], [16, 70, 70], [17, 120, 90], [18, 70, 70], [19, 70, 70], [20, 120, 90], [21, 70, 70],
              [22, 3.02, 9.75], [23, 120, 90], [25, 13.55, 9.36], [26, 98.66, 77.21], [27, 120, 90], [28, 50, 60],
              [29, 120, 90], [30, 26.05, 16.78], [31, 11.48, 9.38], [32, 120, 90], [33, 60.79, 35], [35, 120, 90],
              [37, 120, 90], [38, 120, 90], [40, 70, 70], [42, 49.3, 31.8], [43, 120, 90], [44, 120, 90], [47, 50, 60],
              [48, 70, 70], [49, 37.5, 45], [50, 120, 90], [51, 15.57, 18.15], [53, 40, 50], [56, 120, 90],
              [57, 120, 90], [58, 61.93, 49.09], [61, 70, 70], [62, 27.9, 27.4], [63, 70, 70], [64, 29.97, 42.64],
              [65, 50, 42.55], [66, 20, 25], [68, 98.54, 77.15], [69, 70, 70], [70, 50, 60], [71, 120, 90],
              [72, 120, 90], [73, 120, 90], [75, 50, 60], [77, 120, 90], [78, 59.13, 56.03], [81, 70, 70],
              [82, 12, 28.91], [83, 40, 37.5], [84, 120, 90], [87, 140.68, 39.98], [88, 10.85, 7.56], [89, 70, 70],
              [91, 40, 50], [93, 8.27, 9.25], [94, 120, 90], [96, 17.85, 27], [99, 31.13, 26.62], [100, 8.29, 8.86],
              [101, 70, 70], [103, 120, 90], [105, 40, 50], [106, 70, 70], [109, 40, 50], [110, 120, 90],
              [113, 86.12, 35.5], [119, 70, 70], [121, 13.82, 8.38], [122, 42.72, 53.2], [123, 120, 90],
              [125, 24.22, 37.94], [128, 74.95, 70], [133, 120, 90], [135, 24.22, 25.06], [136, 120, 90],
              [138, 89.29, 46.57], [140, 50, 60], [141, 5, 5.95], [142, 70, 70], [144, 50, 60], [145, 10.42, 7.09],
              [146, 120, 90], [147, 70, 70], [149, 50, 33.8], [150, 80.09, 63.64], [151, 47.04, 30.27], [153, 30, 45],
              [156, 120, 90], [157, 120, 90], [158, 120, 90], [160, 120, 90], [161, 47.65, 26.01], [162, 40, 50],
              [163, 32.08, 38.15], [164, 120, 90], [165, 70, 70], [166, 31.35, 44.44], [169, 97.7, 41.85],
              [170, 120, 90], [171, 35.55, 35], [175, 70, 70], [177, 71.36, 70], [181, 120, 90], [182, 120, 90],
              [183, 70, 70], [184, 120, 90], [186, 16.63, 13.83], [187, 50, 60], [188, 34.84, 17.18], [189, 120, 90],
              [190, 41.9, 24.53], [192, 12, 18], [194, 36.1, 33], [195, 25.2, 22.5], [196, 8.64, 9.03], [197, 120, 90],
              [199, 120, 90], [200, 50, 60], [203, 70, 70], [204, 16.64, 27], [206, 120, 90], [207, 50, 60],
              [210, 120, 90], [211, 42.5, 64.2], [212, 70, 70], [213, 70, 70], [214, 120, 90], [215, 44.5, 31.24],
              [216, 98.28, 54.81], [217, 120, 90], [218, 53.89, 34.22], [220, 23.35, 19.12], [222, 9.57, 9.57],
              [225, 37.5, 45], [226, 13.66, 15.31], [227, 120, 90], [228, 18.5, 27.7], [230, 30, 37.5], [231, 70, 70],
              [233, 22.4, 15.4], [234, 10, 19.36], [235, 34.93, 21.66], [236, 70, 70], [237, 10.83, 7.57],
              [239, 58.9, 76.35], [240, 35.9, 29.8], [241, 46.4, 41.28], [242, 164.4, 59.03], [243, 118.04, 58],
              [244, 120, 90], [245, 120, 90], [246, 60.21, 33.65], [247, 120, 90], [248, 60.9, 49.22], [249, 70, 70],
              [250, 50, 60], [253, 120, 90], [256, 50, 60], [257, 120, 90], [260, 70, 70], [264, 50, 60],
              [265, 120, 90], [267, 120, 90], [268, 120, 90], [269, 120, 90], [270, 70.14, 48.85], [272, 120, 90],
              [273, 25.7, 35.52], [282, 70, 70], [283, 120, 90], [284, 70, 70], [285, 62.31, 50.39],
              [286, 33.37, 83.43], [287, 40, 37.5], [289, 120, 90], [291, 70, 70], [292, 53.52, 70],
              [294, 96.24, 38.52], [295, 120, 90], [296, 36.57, 16.84], [297, 120, 90], [298, 70, 70],
              [299, 26.73, 30.82], [302, 120, 90], [303, 60.81, 32.84], [305, 15.78, 16.19], [306, 53.16, 39.53],
              [307, 70, 70], [308, 22.69, 32.81], [309, 120, 90], [310, 20.52, 19.97], [311, 70, 70],
              [312, 98.14, 57.65], [313, 50, 60], [314, 28.98, 30.23], [315, 120, 90], [317, 31.04, 29.1],
              [320, 40.8, 42.3], [321, 120, 90], [322, 120, 90], [324, 37.5, 45], [325, 120, 90], [326, 28.63, 19.82],
              [327, 52.96, 62.65], [328, 70, 70], [329, 70, 70], [330, 26.79, 29.04], [332, 101.6, 71.83],
              [333, 120, 90], [334, 14.71, 16.26], [337, 19.61, 30.02], [339, 74, 62.86], [340, 120, 90],
              [342, 86.2, 70], [343, 120, 90], [344, 79.03, 44.3], [346, 56.18, 44.76], [347, 70, 70], [348, 120, 90],
              [350, 70, 70], [351, 70, 70], [353, 50, 60], [354, 37.5, 45], [355, 70, 70], [356, 120, 90],
              [358, 70, 70], [361, 49.02, 40.47], [362, 50, 60], [365, 120, 90], [367, 40, 50], [368, 50, 60],
              [369, 5.88, 5.27], [370, 70, 70], [371, 72.52, 67.5], [372, 16.36, 13.13], [374, 50, 60],
              [376, 22.12, 15.96], [377, 25.09, 17.45], [378, 31.04, 34.22], [379, 11.67, 16.73], [382, 70, 70],
              [383, 25.5, 21.6], [385, 120, 90], [386, 50, 60], [387, 70, 70], [389, 37.5, 45], [390, 70, 70],
              [391, 70, 70], [392, 34.26, 35.61], [394, 50, 60], [396, 120, 90], [398, 70, 70], [399, 70, 70],
              [400, 50, 60], [401, 70, 70], [402, 120, 90], [403, 27.52, 29.78], [405, 70, 70], [406, 120, 90],
              [409, 50, 60], [411, 120, 90], [412, 120, 90], [413, 30, 45], [415, 120, 90], [416, 50, 60],
              [418, 36.34, 36.78], [419, 120, 90], [422, 120, 90], [424, 36.5, 31.71], [425, 12.16, 14.12],
              [426, 120, 90], [427, 40, 50], [428, 8.07, 10.33], [429, 70, 70], [430, 27, 24], [432, 72.02, 36.75],
              [434, 70, 70], [436, 20.72, 16.74], [437, 40, 50], [439, 70, 70], [443, 120, 90], [444, 50, 60],
              [445, 120, 90], [446, 70, 70], [450, 120, 90], [451, 50, 60], [452, 120, 90], [453, 70, 70],
              [454, 120, 90], [455, 71.93, 65.93], [457, 40, 50], [458, 92.61, 76.03], [459, 120, 90], [460, 70, 70],
              [461, 50, 60], [463, 10.14, 8.58], [464, 21.08, 14.31], [465, 50, 60], [466, 120, 90], [467, 120, 90],
              [468, 120, 90], [469, 120, 90], [470, 120, 90], [471, 29.42, 44.44], [473, 120, 90], [474, 70, 70],
              [476, 120, 90], [477, 120, 90], [478, 120, 90], [479, 70, 70], [480, 70, 70], [481, 70, 70],
              [482, 70, 70], [484, 70, 70], [485, 120, 90], [486, 50, 60], [487, 29.5, 43.67], [488, 70, 70],
              [490, 70, 70], [493, 120, 90], [494, 16.23, 19.49], [495, 120, 90], [496, 70, 70], [497, 20.34, 27.7],
              [498, 50, 60], [500, 70, 70], [501, 70, 70], [503, 70, 24.56], [504, 14.4, 17.19], [505, 32.44, 29.79],
              [507, 120, 90], [508, 70, 70], [509, 5.13, 4.64], [510, 40, 50], [512, 30, 35], [513, 70, 70],
              [515, 75, 45], [518, 120, 90], [519, 22.23, 21.49], [520, 120, 90], [521, 120, 90], [522, 70, 70],
              [523, 120, 90], [524, 122.06, 81.71], [525, 31.78, 60.44], [526, 70.03, 60], [527, 70, 70], [528, 50, 50],
              [531, 10.37, 9.91], [532, 85.36, 50.72], [534, 41.02, 29.31], [535, 40, 50], [536, 17.11, 23.93],
              [540, 70, 70], [541, 61.04, 50.11], [543, 120, 90], [545, 50.7, 47.79], [547, 12, 18], [548, 120, 90],
              [549, 45, 24.58], [550, 70, 70], [551, 120, 90], [553, 120, 90], [554, 15, 25], [555, 120, 90],
              [556, 120, 90], [557, 40, 50], [558, 120, 90], [559, 70, 70], [561, 120, 90], [563, 78.2, 70],
              [564, 12.02, 6.99], [565, 24.89, 19.74], [568, 22.14, 18.78], [569, 106.46, 58.13], [570, 77.63, 49.89],
              [571, 70, 70], [572, 30, 45], [573, 34.75, 26.58], [574, 70, 70], [577, 32.7, 38.7], [579, 40, 50],
              [581, 30, 45], [582, 120, 90], [583, 70, 70], [584, 21.39, 10.39], [585, 70, 70], [586, 50, 60],
              [588, 12, 22.5], [589, 120, 90], [590, 53.52, 61.02], [591, 120, 90], [593, 65, 51.92], [594, 70, 70],
              [595, 104.15, 43.17], [596, 8.9, 17.2], [597, 40.93, 18.93], [599, 37.1, 32.34], [600, 120, 90],
              [601, 70, 70], [604, 77.66, 49.79], [606, 70, 70], [607, 50, 60], [608, 54.37, 25.93], [610, 50, 60],
              [611, 50, 60], [612, 45.76, 60.33], [614, 20.59, 23], [615, 120, 90], [616, 120, 90], [618, 30, 37.5],
              [619, 120, 90], [621, 120, 90], [623, 8.39, 6.11], [625, 51.68, 25.98], [626, 40, 50], [627, 50, 60],
              [628, 34.13, 29.15], [629, 18.8, 33.4], [630, 70, 70], [631, 39.6, 34.17], [633, 120, 90], [635, 70, 70],
              [636, 21.1, 50.2], [637, 7.79, 7.02], [639, 70, 70], [641, 120, 90], [645, 97.67, 37.44],
              [647, 108.04, 87.9], [648, 70, 70], [649, 70, 70], [650, 120, 90], [651, 120, 90], [653, 70, 70],
              [654, 12.52, 17.79], [656, 120, 90], [657, 120, 90], [659, 7.56, 7.64], [660, 38.63, 26.61],
              [662, 120, 90], [663, 69.14, 36.97], [664, 70, 70], [665, 120, 90], [666, 120, 90], [669, 50, 30.85],
              [670, 70, 70], [672, 70, 70], [673, 120, 90], [675, 70, 70], [678, 32.19, 33.94], [679, 120, 90],
              [680, 10.1, 8.13], [681, 70, 70], [682, 8.1, 6.18], [683, 9.08, 9.76], [686, 16.9, 21.27], [687, 120, 90],
              [688, 120, 90], [690, 40, 50], [691, 18.17, 15.1], [692, 70, 70], [693, 70, 70], [694, 50, 42.14],
              [695, 82.86, 52.5], [697, 120, 90], [698, 70, 70], [700, 70, 70], [701, 120, 90], [702, 70, 70],
              [703, 12, 18], [704, 93.01, 45.96], [705, 30, 45], [706, 70, 70], [708, 70, 70], [709, 32.88, 46.39],
              [710, 120, 90], [711, 50, 60], [714, 50, 60], [715, 120, 90], [716, 70, 70], [717, 36.27, 32.74],
              [718, 79.28, 72.56], [719, 120, 90], [720, 83.47, 31.82], [721, 50, 60], [722, 120, 90], [723, 50, 60],
              [724, 20.76, 58.98], [727, 50, 45], [730, 120, 90], [731, 41.75, 21.4], [732, 151, 158],
              [734, 18.45, 34.92], [737, 10.58, 13.69], [738, 120, 90], [740, 18, 27], [741, 120, 90], [742, 25, 15.29],
              [745, 120, 90], [746, 40, 50], [747, 85.74, 47.21], [748, 120, 90], [749, 50, 60], [750, 133.42, 46.75],
              [751, 70, 70], [753, 50, 60], [754, 32.02, 28.67], [756, 70, 70], [759, 70, 70], [762, 70, 70],
              [763, 70, 70], [766, 100.6, 37.63], [767, 70, 70], [769, 37.94, 60], [771, 120, 90], [772, 70, 70],
              [773, 69.55, 32.33], [775, 70, 70], [776, 120, 90], [778, 120, 90], [779, 50, 60], [781, 71.26, 34.85],
              [782, 120, 90], [783, 50, 45], [784, 33.43, 46.1], [785, 120, 90], [787, 18, 23.03], [789, 70, 70],
              [790, 60.28, 19.43], [795, 120, 90], [796, 70, 70], [799, 50, 60], [801, 32.11, 49.85], [802, 120, 90],
              [803, 42.57, 40], [804, 120, 90], [805, 13.65, 18.71], [806, 120, 90], [807, 9.12, 12.1], [811, 120, 90],
              [812, 50, 60], [813, 8.07, 6.92], [814, 120, 90], [815, 30.9, 14.34], [818, 70, 70], [819, 120, 90],
              [820, 50, 65], [821, 32.18, 30.47], [822, 18.48, 22.65], [823, 120, 90], [824, 120, 90], [825, 70, 70],
              [826, 32.3, 7.9], [827, 12, 18], [829, 8.45, 6.52], [830, 120, 90], [831, 120, 90], [833, 120, 90],
              [835, 69.3, 61.77], [836, 120, 90], [837, 70, 70], [840, 120, 90], [842, 50, 50], [843, 69.06, 43.42],
              [844, 117.83, 54.95], [845, 79.17, 68.36], [846, 120, 90], [847, 70, 70], [848, 9.12, 11.53],
              [850, 26.43, 37.47], [851, 18.96, 12.46], [852, 70, 70], [855, 6.73, 7.13], [857, 120, 90], [860, 70, 70],
              [863, 13.7, 17.4], [865, 70, 42.13], [867, 120, 90], [869, 70, 70], [871, 16.44, 22.77], [872, 70, 70],
              [873, 48, 70], [875, 120, 90], [876, 120, 90], [877, 120, 90], [878, 5.59, 4.6], [881, 120, 90],
              [882, 50, 60], [883, 120, 90], [884, 70, 70], [885, 70, 70], [886, 120, 90], [889, 11.95, 11.28],
              [890, 63.25, 33.78], [891, 120, 90], [892, 120, 90], [894, 23.13, 17.71], [895, 120, 90], [896, 70, 70],
              [897, 13.97, 22.37], [899, 120, 90], [900, 6.81, 4.72], [901, 120, 90], [905, 120, 90], [909, 120, 90],
              [910, 11.75, 7.29], [913, 21.73, 18.25], [914, 120, 90], [915, 38.46, 49.72], [916, 40, 50],
              [917, 30, 45], [918, 47, 50], [919, 120, 90], [922, 50, 60], [924, 8.93, 9.74], [926, 40.84, 38.58],
              [927, 70, 70], [928, 120, 90], [929, 120, 90], [930, 50, 60], [931, 70, 70], [934, 37.5, 45],
              [935, 120, 90], [936, 50, 60], [937, 120, 90], [938, 12, 18], [940, 12, 18], [941, 70, 70], [942, 70, 70],
              [944, 96.61, 70.21], [945, 50, 60], [946, 50, 60], [948, 31.14, 15], [949, 79.45, 48.51],
              [950, 9.26, 20.62], [952, 12.6, 9.35], [953, 70, 70], [954, 120, 90], [955, 120, 90], [957, 120, 90],
              [958, 59.87, 32.44], [960, 50, 60], [961, 120, 90], [963, 70, 70], [964, 12, 15], [965, 50.79, 35],
              [966, 4.52, 4.32], [969, 52.88, 45.27], [970, 50, 60], [971, 35.72, 14.91], [972, 35.77, 19.67],
              [974, 30, 45], [976, 8.35, 13.15], [977, 12.22, 8.58], [978, 70, 48.36], [979, 25.93, 22.72],
              [980, 70, 70], [982, 120, 90], [983, 71.83, 30.1], [985, 194.37, 75.01], [986, 7.84, 7.68],
              [987, 120, 90], [988, 6.14, 5.32], [990, 71.86, 39.63], [991, 120, 90], [993, 89.04, 64.77],
              [994, 40, 50], [997, 120, 90], [998, 70, 70], [999, 120, 90], [1000, 40, 50], [1003, 7.76, 5.82],
              [1004, 70, 70], [1005, 40, 50], [1006, 120, 90], [1007, 28.86, 20.82], [1008, 37.5, 45], [1009, 120, 90],
              [1013, 120, 90], [1015, 70, 70], [1016, 14.94, 23.74], [1017, 50, 60], [1018, 120, 90], [1020, 70, 70],
              [1021, 70, 70], [1022, 120, 90], [1023, 13.9, 28.3], [1025, 120, 90], [1027, 120, 90], [1028, 50, 60],
              [1029, 70, 70], [1030, 7, 9.5], [1032, 23, 23.89], [1033, 30.71, 32.21], [1034, 70, 70],
              [1036, 6.74, 8.62], [1038, 70, 70], [1039, 120, 90], [1042, 120, 90], [1043, 12.3, 25.3], [1044, 120, 90],
              [1045, 120, 90], [1046, 50, 60], [1047, 70, 70], [1048, 70, 70], [1050, 70, 70], [1051, 92.72, 35.97],
              [1052, 50, 60], [1053, 50, 60], [1054, 70, 70], [1056, 22.3, 25.8], [1057, 50, 60], [1058, 70, 70],
              [1059, 65.53, 68.84], [1061, 70, 70], [1062, 7.92, 8.74], [1063, 115.77, 70], [1064, 50, 60],
              [1065, 120, 90], [1066, 50, 60], [1067, 120, 90], [1069, 50, 60], [1070, 20.5, 19], [1071, 125.97, 49.26],
              [1073, 84.92, 72.24], [1075, 6.43, 6.35], [1077, 120, 90], [1078, 120, 90], [1080, 120, 90],
              [1081, 53.54, 36.15], [1082, 75, 64.64], [1084, 160.19, 70.76], [1087, 130.51, 58.25], [1090, 120, 70],
              [1091, 40, 50], [1092, 12, 18], [1093, 50, 60], [1094, 20.61, 20.28], [1095, 27.39, 27.85],
              [1096, 120, 90], [1097, 13.52, 12.14], [1099, 13.78, 13.14], [1100, 55.33, 47.25], [1102, 20.14, 33.65],
              [1104, 70, 70], [1106, 70, 70], [1108, 120, 90], [1109, 71.84, 33.52], [1110, 120, 90],
              [1111, 68.1, 60.82], [1113, 120, 90], [1114, 120, 90], [1117, 50, 60], [1118, 21.27, 36.09],
              [1119, 50, 60], [1120, 120, 90], [1121, 120, 90], [1122, 120, 90], [1124, 33.6, 22.42], [1125, 120, 90],
              [1126, 72.51, 70], [1127, 120, 90], [1128, 70, 70], [1129, 50, 60], [1130, 120, 90], [1131, 40.04, 38.42],
              [1132, 12, 18], [1136, 64.79, 64.92], [1137, 120, 90], [1138, 120, 90], [1139, 89.3, 90], [1140, 50, 45],
              [1141, 151.96, 55.04], [1142, 79.98, 40.43], [1144, 70.4, 75.66], [1145, 120, 90], [1147, 12.27, 6.99],
              [1149, 53.28, 35.03], [1150, 50, 60], [1152, 38.19, 95.28], [1153, 120, 90], [1154, 120, 90],
              [1155, 12.52, 12.5], [1156, 50, 60], [1157, 40.32, 25.17], [1158, 50, 60], [1159, 70, 60],
              [1161, 120, 90], [1163, 19.1, 28.7], [1164, 120, 90], [1165, 120, 90], [1167, 66.18, 60.25],
              [1168, 120, 90], [1169, 24.92, 66.54], [1170, 70, 70], [1171, 89.52, 90], [1172, 70, 70], [1173, 50, 60],
              [1174, 37.2, 58.3], [1175, 29.09, 38.47], [1176, 120, 90], [1177, 70, 70], [1178, 8.86, 7.64],
              [1180, 15.85, 14.23], [1181, 120, 90], [1186, 15.33, 18], [1187, 120, 90], [1188, 40, 50],
              [1189, 120, 90], [1190, 70, 70], [1191, 67.28, 35], [1194, 82.38, 42.91], [1195, 120, 90],
              [1198, 120, 90], [1199, 40, 50], [1200, 27.2, 13.54], [1202, 30, 45], [1203, 15, 25], [1204, 108.29, 90],
              [1205, 37.85, 49.46], [1206, 120, 90], [1207, 30, 45], [1209, 40, 50], [1210, 40, 37.5],
              [1211, 53.75, 32.19], [1212, 70, 70], [1213, 40, 50], [1214, 70, 70], [1216, 50, 60],
              [1217, 90.55, 46.37], [1219, 110.01, 49.26], [1221, 22.66, 24.86], [1223, 70, 70], [1224, 47.2, 82.28],
              [1225, 50, 60], [1226, 25.67, 16.67], [1227, 120, 90], [1228, 57.49, 37.38], [1230, 50, 60],
              [1233, 50, 60], [1234, 12, 18], [1235, 50, 60], [1236, 85.05, 70.88], [1237, 37.5, 45],
              [1238, 14.2, 20.8], [1239, 120, 90], [1240, 120, 90], [1244, 70, 70], [1245, 120, 90], [1246, 70, 70],
              [1247, 70, 70], [1250, 70, 70], [1251, 70, 70], [1253, 50, 60], [1254, 70, 70], [1255, 120, 90],
              [1257, 40, 50], [1259, 105.06, 30.34], [1260, 50, 60], [1262, 110.05, 49.65], [1263, 120, 90],
              [1264, 120, 90], [1265, 13.11, 9.3], [1266, 120, 90], [1268, 30.72, 32.5], [1269, 50, 60],
              [1271, 85.26, 44.5], [1272, 70, 70], [1275, 36.46, 15.29], [1276, 70, 70], [1278, 18.5, 14.7],
              [1280, 11.06, 6.23], [1281, 21.65, 27], [1282, 50, 60], [1286, 120, 90], [1287, 70, 70], [1288, 70, 70],
              [1290, 120, 90], [1292, 70, 70], [1293, 4.01, 4.97], [1295, 70, 70], [1298, 50, 60], [1299, 70, 70],
              [1301, 70, 70], [1302, 30, 45], [1303, 70, 70], [1305, 18.06, 19.95], [1306, 12.9, 26.6],
              [1312, 26.57, 15.77], [1313, 120, 90], [1314, 23.54, 16.63], [1315, 120, 90], [1317, 70, 70],
              [1318, 120, 90], [1319, 46.62, 28.16], [1320, 120, 90], [1321, 48.13, 28.8], [1323, 75.54, 72.3],
              [1324, 120, 90], [1325, 120, 90], [1326, 70, 70], [1327, 70, 70], [1328, 69.9, 51.49], [1331, 120, 90],
              [1332, 5.42, 3.32], [1333, 120, 90], [1334, 55.76, 53.89], [1335, 22.9, 24.9], [1337, 5.66, 6.03],
              [1338, 120, 90], [1339, 11.12, 8.5], [1340, 53.22, 39.25], [1341, 120, 90], [1342, 70, 70],
              [1345, 40, 50], [1346, 50, 60], [1349, 70, 70], [1350, 70, 70], [1351, 97.23, 70], [1352, 120, 90],
              [1353, 70, 70], [1355, 120, 90], [1357, 70, 70], [1358, 120, 90], [1359, 67.94, 52.51], [1360, 18, 27],
              [1361, 77.94, 60.66], [1363, 87.15, 35.16], [1367, 37.84, 31.71], [1370, 17.21, 28.49],
              [1371, 118.59, 70], [1372, 120, 90], [1375, 17.87, 23.42], [1376, 30, 37.5], [1378, 70, 70],
              [1379, 120, 90], [1380, 70, 70], [1381, 120, 90], [1382, 26.47, 36.84], [1383, 8.45, 7.72],
              [1385, 70, 70], [1387, 40, 50], [1388, 120, 90], [1391, 120, 90], [1392, 120, 90], [1393, 70, 70],
              [1395, 70, 70], [1396, 12, 24.84], [1398, 40, 50], [1399, 7.42, 6.96], [1402, 70, 70], [1404, 40, 50],
              [1405, 120, 90], [1406, 4.67, 5.31], [1410, 70, 70], [1411, 50, 60], [1415, 70, 70], [1417, 120, 90],
              [1420, 50, 60], [1421, 120, 90], [1422, 120, 90], [1424, 50, 60], [1426, 12.76, 9.29],
              [1427, 23.02, 15.67], [1428, 8.98, 6.72], [1431, 120, 90], [1432, 6.73, 6.53], [1434, 53.67, 36.6],
              [1436, 70, 70], [1438, 70, 70], [1439, 120, 90], [1440, 70, 70], [1441, 120, 90], [1442, 70, 70],
              [1443, 57.46, 26.71], [1444, 120, 90], [1445, 85.92, 19.7], [1448, 70, 70], [1449, 120, 90],
              [1450, 120, 90], [1451, 120, 90], [1453, 70, 70], [1454, 23.66, 23.15], [1456, 70, 70], [1459, 120, 90],
              [1460, 49, 58], [1461, 6.14, 6.98], [1464, 50, 60], [1465, 30.3, 26.6], [1466, 50, 60], [1467, 70, 70],
              [1469, 70, 70], [1470, 30, 45], [1471, 58.28, 38.29], [1472, 120, 90], [1473, 11.99, 10.02],
              [1474, 18, 27], [1475, 93.38, 40.44], [1476, 48.77, 79.01], [1477, 104.49, 49.9], [1478, 14.96, 11.47],
              [1479, 40, 50], [1481, 70, 70], [1482, 12.31, 14.89], [1483, 70, 70], [1484, 34.55, 69.22],
              [1485, 120, 90], [1486, 73.81, 56.6], [1487, 120, 90], [1488, 120, 90], [1490, 35.69, 22.38],
              [1491, 11.32, 8.34], [1493, 40.01, 20.74], [1503, 120, 90], [1505, 120, 90], [1506, 120, 90],
              [1507, 70, 70], [1508, 23.88, 19.39], [1509, 120, 90], [1510, 15.91, 13.12], [1511, 27.25, 18.05],
              [1512, 50, 60], [1513, 70, 70], [1514, 70, 70], [1515, 30, 45], [1516, 70, 70], [1518, 120, 90],
              [1519, 120, 90], [1520, 70, 70], [1521, 120, 90], [1522, 12.41, 18.24], [1523, 120, 90], [1524, 120, 90],
              [1525, 30, 37.5], [1526, 19.7, 33.1], [1527, 17.34, 33.26], [1530, 97.88, 79.23], [1533, 70, 70],
              [1534, 10.96, 7.99], [1536, 30.57, 20.35], [1537, 39.94, 45.98], [1538, 120, 90], [1539, 20, 15],
              [1540, 40, 50], [1541, 70, 70], [1542, 50, 60], [1544, 120, 90], [1546, 70, 70], [1547, 70, 70],
              [1548, 120, 90], [1549, 50, 60], [1550, 120, 90], [1552, 30, 45], [1553, 70.57, 50.89], [1555, 30, 37.5],
              [1556, 27.63, 11.76], [1557, 59.6, 36.82], [1559, 50, 60], [1561, 37.45, 42.54], [1562, 97.79, 51.18],
              [1565, 120, 90], [1567, 120, 90], [1568, 17.56, 11.49], [1571, 70, 70], [1572, 120, 90], [1574, 50, 60],
              [1575, 124.82, 81.48], [1576, 50, 60], [1577, 50, 60], [1578, 120, 90], [1580, 50, 60],
              [1581, 17.87, 10.61], [1582, 22.41, 22.97], [1585, 70, 70], [1587, 18, 27], [1589, 70, 70],
              [1590, 70, 70], [1591, 12.9, 21.1], [1592, 70, 70], [1593, 25.91, 24.87], [1595, 152.2, 70],
              [1596, 120, 90], [1597, 70, 70], [1598, 15.38, 8.13], [1600, 120, 90], [1601, 70, 70], [1602, 120, 90],
              [1603, 50, 60], [1605, 50, 60], [1607, 70, 70], [1609, 120, 90], [1610, 32.57, 20.36], [1612, 120, 90],
              [1615, 120, 90], [1617, 120, 90], [1619, 8.99, 11.56], [1620, 40, 50], [1621, 70, 70], [1623, 50, 60],
              [1624, 120, 90], [1625, 70, 70], [1626, 70, 70], [1627, 70, 70], [1628, 50, 60], [1629, 40, 50],
              [1630, 70.01, 36.62], [1632, 8.5, 7.41], [1634, 70, 70], [1635, 16.96, 17.21], [1637, 120, 90],
              [1638, 52.95, 70], [1639, 74.31, 70], [1640, 70, 70], [1641, 50.33, 45.33], [1643, 18.14, 18.53],
              [1644, 135.92, 55.65], [1645, 70, 70], [1647, 70, 70], [1648, 120, 90], [1649, 120, 90], [1650, 70, 70],
              [1651, 120, 90], [1652, 57.04, 46.09], [1653, 35, 26.28], [1654, 50, 60], [1656, 8.28, 5.7],
              [1657, 70, 70], [1658, 120, 90], [1659, 38.85, 38.2], [1660, 134.83, 48.67], [1661, 70, 70],
              [1662, 20.69, 28.99], [1663, 35.1, 31.57], [1664, 22.26, 19.82], [1665, 28.19, 19.28], [1666, 6.17, 5.14],
              [1667, 120, 90], [1668, 84.95, 70], [1669, 120, 90], [1671, 120, 90], [1672, 20.29, 61.88],
              [1673, 40.58, 28.22], [1674, 70, 70], [1675, 9.08, 16.02], [1679, 33.66, 20.7], [1680, 87.72, 70.36],
              [1681, 120, 90], [1684, 120, 90], [1685, 37.5, 45], [1686, 120, 90], [1688, 25.71, 34.65],
              [1689, 120, 90], [1690, 120, 90], [1692, 120, 90], [1694, 120, 90], [1695, 120, 90], [1697, 70, 70],
              [1701, 70, 70], [1702, 70, 70], [1704, 32.73, 29.33], [1705, 70, 70], [1706, 40, 50], [1707, 30, 17.24],
              [1709, 16, 15.44], [1711, 70, 70], [1713, 50, 60], [1715, 120, 90], [1717, 70, 70], [1720, 4.58, 3.57],
              [1722, 120, 90], [1724, 34.9, 28.91], [1726, 120, 90], [1728, 120, 90], [1729, 36.89, 30.28],
              [1730, 12, 18], [1734, 17.03, 13.98], [1737, 70, 70], [1739, 70, 70], [1740, 50, 60], [1741, 70, 70],
              [1742, 120, 90], [1743, 70, 70], [1744, 64.97, 47.25], [1745, 34.11, 14.96], [1746, 90.45, 70],
              [1748, 104.76, 45.88], [1749, 50, 60], [1750, 70, 70], [1752, 120, 90], [1753, 25.17, 15.07],
              [1754, 120, 90], [1756, 47.1, 29.63], [1757, 70, 70], [1758, 70, 70], [1760, 12.98, 21.4],
              [1763, 43.44, 47.84], [1764, 70, 70], [1765, 50, 60], [1766, 120, 90], [1767, 120, 88.81],
              [1769, 70, 60.5], [1770, 48, 62], [1771, 19.39, 23.78], [1772, 25.48, 41.18], [1773, 50, 60],
              [1774, 17.87, 21.37], [1775, 70, 70], [1776, 35.63, 37.22], [1778, 120, 90], [1779, 35.69, 81.75],
              [1780, 35.35, 35.59], [1781, 113.83, 52.58], [1783, 12.6, 22.4], [1784, 70, 70], [1785, 120, 90],
              [1786, 40.8, 58.18], [1787, 120, 90], [1788, 120, 90], [1789, 120, 90], [1790, 47.16, 37.74],
              [1792, 25.36, 24.69], [1793, 99.43, 70], [1794, 42.48, 37.47], [1795, 13.2, 9.9], [1796, 50, 60],
              [1797, 70, 70], [1798, 70, 70], [1799, 4.8, 5.01], [1800, 9.59, 5.61], [1801, 70, 70], [1802, 120, 90],
              [1803, 120, 90], [1804, 105.47, 52.76], [1806, 120, 90], [1809, 120, 90], [1811, 120, 90],
              [1812, 43.07, 42.87], [1814, 40, 50], [1815, 15.67, 9.13], [1816, 83.79, 61.8], [1817, 90.35, 31.74],
              [1818, 21.14, 10.89], [1819, 70, 70], [1822, 70, 70], [1824, 50, 65], [1825, 50.4, 52.17], [1827, 70, 70],
              [1829, 23.1, 41.1], [1832, 70, 70], [1833, 120, 90], [1834, 120, 90], [1837, 120, 90], [1839, 70, 70],
              [1841, 70, 70], [1843, 14.6, 12.44], [1844, 30, 45], [1845, 20.76, 23.58], [1846, 120, 90],
              [1847, 50, 60], [1848, 85.7, 63.16], [1849, 120, 90], [1850, 7.35, 6.92], [1851, 7.82, 10.41],
              [1852, 40.34, 32.16], [1853, 120, 90], [1855, 120, 90], [1856, 30, 45], [1857, 70, 70], [1859, 120, 90],
              [1860, 120, 90], [1863, 16.62, 11.53], [1864, 94.1, 90], [1866, 70, 70], [1868, 120, 90],
              [1869, 40, 37.5], [1870, 70, 70], [1873, 70, 70], [1875, 40, 50], [1876, 37.79, 33.06], [1877, 120, 90],
              [1879, 43.02, 40.39], [1881, 50, 60], [1882, 62.54, 30.08], [1883, 120, 90], [1884, 50, 60],
              [1885, 70, 70], [1886, 50, 60], [1887, 70, 70], [1888, 120, 90], [1889, 70, 70], [1890, 120, 90],
              [1891, 33.58, 60], [1892, 70, 70], [1894, 50, 60], [1895, 79.91, 49.67], [1896, 120, 90],
              [1897, 13.67, 11.12], [1898, 8.67, 4.23], [1899, 70, 70], [1900, 34.8, 47.81], [1901, 25.72, 27.84],
              [1903, 70, 70], [1904, 120, 90], [1906, 19.49, 10.43], [1909, 120, 90], [1910, 120, 90], [1912, 70, 70],
              [1914, 120, 90], [1915, 57.34, 41.55], [1916, 120, 90], [1917, 120, 90], [1919, 120, 90], [1920, 70, 70],
              [1921, 28.17, 26.56], [1924, 120, 90], [1925, 49.21, 40.22], [1928, 120, 90], [1929, 6.5, 4.93],
              [1930, 10.76, 8.15], [1933, 12.42, 12.39], [1937, 70, 70], [1938, 120, 90], [1940, 120, 90],
              [1941, 120, 90], [1945, 41.7, 25.8], [1946, 70, 70], [1948, 26.6, 21.6], [1949, 120, 90],
              [1950, 42.96, 58.04], [1952, 92.32, 71.14], [1955, 50, 60], [1956, 40, 50], [1957, 70, 70],
              [1959, 120, 90], [1961, 120, 90], [1962, 15.89, 20.58], [1963, 7.89, 5.56], [1964, 79.54, 41.58],
              [1965, 50, 59.43], [1967, 70, 70], [1969, 70, 70], [1972, 8.68, 7.21], [1974, 70, 70], [1976, 9.37, 9.9],
              [1978, 70, 70], [1979, 50, 60], [1980, 120, 90], [1981, 70.08, 70], [1982, 70, 70], [1984, 70, 70],
              [1986, 120, 90], [1989, 50, 60], [1991, 11.55, 8.24], [1992, 50.97, 29.55], [1995, 43.54, 34.8],
              [1996, 120, 90], [1997, 120, 90], [1998, 7.33, 8.42], [2000, 17.52, 8.25], [2001, 63.05, 65.31],
              [2002, 50, 60], [2004, 8.73, 6.08], [2005, 117.44, 37.08], [2006, 20.36, 23.58], [2007, 70, 70],
              [2008, 70, 70], [2009, 58, 70], [2011, 12, 18], [2012, 70, 70], [2013, 38.69, 111.03],
              [2015, 20.41, 16.91], [2016, 50, 60], [2017, 40, 37.5], [2018, 12, 18], [2020, 70, 70],
              [2021, 91.08, 54.55], [2022, 120, 90], [2023, 12.93, 13.98], [2025, 47.08, 35.03], [2026, 122.65, 67.48],
              [2027, 120, 90], [2028, 120, 90], [2029, 61.44, 42.57], [2030, 50, 60], [2031, 6.44, 5.6],
              [2032, 29.96, 39.24], [2034, 120, 90], [2035, 70, 70], [2038, 120, 90], [2040, 120, 90], [2041, 120, 90],
              [2042, 27.63, 11.76], [2044, 120, 90], [2046, 50, 60], [2048, 13.1, 28.8], [2049, 70, 70], [2050, 11, 25],
              [2051, 120, 90], [2052, 120, 90], [2053, 70, 70], [2054, 21.44, 20.37], [2055, 70, 70], [2056, 50, 60],
              [2057, 120, 90], [2058, 7.15, 5.43], [2059, 11.86, 8.19], [2060, 70, 70], [2061, 70, 70], [2062, 120, 90],
              [2063, 84.41, 70], [2064, 61.23, 37.87], [2066, 120, 90], [2068, 70, 70], [2070, 19.34, 6.55],
              [2071, 120, 90], [2072, 120, 90], [2073, 120, 90], [2074, 70, 70], [2075, 45, 70], [2076, 70, 70],
              [2077, 120, 90], [2081, 41.13, 34.16], [2083, 120, 90], [2084, 23.59, 36.63], [2085, 9.03, 8.79],
              [2087, 70, 70], [2089, 50, 60], [2090, 120, 90], [2091, 120, 90], [2095, 70, 70], [2096, 120, 90],
              [2097, 50, 60], [2098, 40, 50], [2099, 83.99, 31.46], [2100, 71.04, 24.35], [2101, 30.58, 16.13],
              [2103, 11.08, 12.74], [2104, 111.3, 45.15], [2105, 120, 90], [2106, 40.17, 51.44], [2107, 120, 90],
              [2110, 40, 50], [2112, 70, 70], [2115, 70, 70], [2116, 50, 60], [2119, 7.29, 9.02], [2121, 28, 32.4],
              [2122, 70, 70], [2125, 120, 90], [2126, 50, 60], [2127, 19.02, 24.51], [2128, 32.1, 29.68],
              [2130, 120, 90], [2131, 65.5, 56.7], [2132, 19.44, 12.24], [2134, 70, 70], [2135, 22.3, 28.8],
              [2136, 70, 70], [2137, 70, 70], [2138, 24.24, 22.96], [2139, 70, 70], [2140, 40, 50], [2142, 5.59, 1.96],
              [2144, 37.3, 75.7], [2146, 70, 70], [2147, 120, 90], [2148, 95.28, 70], [2149, 120, 90], [2150, 120, 90],
              [2151, 40.63, 26.2], [2152, 120, 90], [2154, 120, 90], [2155, 120, 90], [2156, 43.59, 31.42],
              [2159, 120, 90], [2161, 50, 60], [2162, 27.58, 30.03], [2163, 120, 90], [2164, 22, 26.1], [2166, 120, 90],
              [2167, 10.33, 10.88], [2169, 70, 70], [2170, 50.17, 28.05], [2171, 120, 90], [2174, 40.28, 40.83],
              [2177, 8.15, 8.97], [2178, 16.1, 27], [2179, 26, 37.8], [2180, 31.07, 14.75], [2181, 57.35, 74.71],
              [2182, 120, 90], [2184, 40, 50], [2186, 50, 60], [2187, 120, 90], [2190, 70, 70], [2191, 120, 90],
              [2197, 120, 90], [2198, 40, 50], [2199, 120, 90], [2200, 85.49, 90], [2201, 23.77, 27.53],
              [2203, 11.11, 8.84], [2204, 14.98, 8.4], [2205, 120, 90], [2208, 81.25, 48.76], [2212, 70, 70],
              [2213, 50, 60], [2214, 1.27, 0.88], [2216, 25.21, 17.4], [2217, 120, 90], [2219, 120, 90],
              [2220, 34.09, 21.45], [2223, 40, 50], [2224, 36.28, 36.4], [2225, 50, 60], [2226, 120, 90],
              [2227, 39.22, 33.66], [2228, 50, 60], [2230, 120, 90], [2231, 120, 90], [2232, 28.52, 48.27],
              [2233, 22.35, 13.45], [2235, 50, 60], [2236, 24.63, 27.62], [2237, 120, 90], [2238, 45.83, 36.77],
              [2239, 21.85, 11.47], [2240, 120, 90], [2241, 14.63, 9.52], [2242, 91.6, 70], [2243, 120, 90],
              [2244, 38, 31.98], [2245, 70, 70], [2247, 50, 60], [2248, 40, 50], [2249, 120, 90], [2250, 50, 60],
              [2252, 70, 70], [2253, 14.51, 10.23], [2254, 70, 70], [2255, 37.27, 60.05], [2256, 70, 70],
              [2258, 70.97, 39.98], [2259, 2, 1], [2260, 70, 70], [2262, 70, 70], [2265, 120, 90], [2267, 7.26, 3.97],
              [2268, 120, 90], [2269, 70, 70], [2270, 120, 90], [2271, 6.34, 5.21], [2273, 92.69, 76.05],
              [2274, 70, 70], [2277, 50, 33.82], [2280, 8.57, 5.83], [2281, 120, 90], [2282, 34.6, 40.1],
              [2283, 120, 90], [2284, 70, 70], [2285, 40, 50], [2286, 70, 70], [2289, 120, 90], [2290, 120, 90],
              [2292, 120, 90], [2293, 109.99, 52.3], [2294, 50, 60], [2295, 120, 90], [2297, 153.15, 64.3],
              [2300, 50, 60], [2301, 92.47, 70], [2302, 120, 90], [2303, 56.37, 41.39], [2304, 70, 70], [2305, 120, 90],
              [2306, 50, 60], [2311, 45, 45], [2312, 40.7, 39.93], [2314, 120, 90], [2316, 70, 70], [2317, 120, 90],
              [2319, 50, 60], [2320, 8.59, 8.74], [2321, 120, 90], [2323, 70, 70], [2325, 120, 90], [2326, 120, 90],
              [2327, 120, 90], [2328, 70, 70], [2332, 30.96, 25.63], [2335, 57.22, 73.4], [2336, 120, 90],
              [2337, 120, 90], [2338, 70, 70], [2339, 120, 90], [2340, 120, 90], [2341, 70, 70], [2342, 70, 70],
              [2343, 57.74, 26.83], [2346, 70, 70], [2347, 120, 90], [2348, 37, 70], [2349, 92.7, 76.05],
              [2352, 50, 60], [2356, 226.56, 56.42], [2359, 50, 60], [2363, 30.54, 20.65], [2364, 70, 70],
              [2366, 16.78, 17.31], [2367, 59.45, 50.23], [2368, 70, 70], [2371, 70, 70], [2372, 30, 45],
              [2373, 70, 70], [2374, 12.45, 9.91], [2375, 120, 90], [2378, 20.26, 18.12], [2382, 70, 70],
              [2383, 91.39, 52.48], [2384, 30, 45], [2385, 70, 70], [2387, 40, 50], [2388, 70, 70], [2390, 120, 90],
              [2391, 70, 70], [2392, 7.85, 7.64], [2394, 50, 60], [2396, 120, 90], [2397, 120, 90], [2398, 120, 90],
              [2399, 120, 90], [2401, 9.42, 9.69], [2402, 70, 70], [2404, 120, 90], [2405, 22.61, 36.11],
              [2406, 120, 90], [2407, 120, 90], [2408, 50, 60], [2409, 9.5, 15.2], [2410, 55.09, 24],
              [2411, 9.59, 8.49], [2412, 6.63, 7.08], [2413, 120, 90], [2414, 8.64, 7.09], [2416, 120, 90],
              [2420, 120, 90], [2423, 70, 70], [2424, 70, 90], [2425, 52.54, 35], [2428, 10.11, 12.8], [2429, 12, 18],
              [2430, 70, 70], [2433, 70, 70], [2434, 70, 70], [2435, 22.35, 18.73], [2436, 17.93, 15],
              [2437, 9.73, 8.67], [2438, 120, 90], [2439, 70, 70], [2440, 5.64, 5.78], [2441, 120, 90], [2442, 12, 18],
              [2443, 70, 70], [2444, 120, 90], [2447, 34.36, 17.02], [2448, 120, 90], [2449, 120, 90], [2452, 70, 70],
              [2454, 120, 90], [2456, 70, 70], [2458, 42.99, 19.09], [2459, 32.63, 40.69], [2462, 120, 90],
              [2465, 120, 90], [2466, 120, 90], [2467, 12, 21.72], [2468, 22.08, 35.99], [2470, 120, 90],
              [2471, 120, 90], [2472, 78.4, 34.97], [2473, 120, 90], [2474, 120, 90], [2475, 123.12, 70],
              [2476, 120, 90], [2477, 70, 70], [2478, 120, 90], [2479, 50, 60], [2480, 25.72, 16.26], [2481, 50, 60],
              [2482, 120, 90], [2483, 120, 90], [2484, 120, 90], [2485, 26.73, 30.59], [2486, 70, 70], [2487, 70, 70],
              [2488, 53.21, 52.23], [2490, 70.38, 70], [2493, 109.42, 45.47], [2494, 85.78, 39.36], [2495, 40, 50],
              [2496, 120, 90], [2497, 40.2, 11.31], [2499, 13.19, 8.58], [2500, 14.55, 14.52], [2501, 70, 70],
              [2503, 40, 60], [2504, 120, 90], [2505, 70, 70], [2507, 120, 90], [2508, 70, 70], [2509, 21.55, 18.6],
              [2510, 70, 70], [2511, 120, 90], [2512, 120, 90], [2513, 7, 18.7], [2514, 120, 90], [2515, 50, 60],
              [2516, 33.27, 33.84], [2518, 74.82, 43.44], [2519, 120, 90], [2520, 70, 70], [2521, 50, 60],
              [2524, 10.39, 13.16], [2525, 70, 70], [2526, 70, 70], [2527, 46.45, 44.76], [2528, 120, 90],
              [2529, 43.73, 38.98], [2530, 70, 70], [2532, 70, 70], [2533, 23.69, 46.33], [2534, 120, 90],
              [2535, 5.38, 6.5], [2536, 5.45, 5.06], [2537, 120, 90], [2539, 70, 30.72], [2540, 19.62, 27.9],
              [2542, 34.79, 22.79], [2543, 27.67, 25], [2545, 40, 50], [2546, 70, 70], [2547, 17.63, 16.94],
              [2548, 70, 70], [2549, 70, 70], [2551, 71.76, 36.27], [2553, 70, 70], [2554, 16.72, 26.29],
              [2555, 52.5, 52.5], [2558, 40, 50], [2562, 111.85, 42.43], [2563, 61.13, 37.95], [2564, 33.39, 72.42],
              [2565, 40, 50], [2566, 10.13, 8.41], [2568, 70, 70], [2569, 34.08, 20.39], [2571, 50, 60],
              [2572, 120, 90], [2574, 107.79, 57.67], [2575, 70, 70], [2576, 70, 70], [2577, 16.06, 11.33],
              [2578, 28.35, 12.83], [2580, 120, 90], [2582, 70, 70], [2584, 120, 90], [2585, 70, 58.43],
              [2587, 66.78, 50.99], [2589, 70, 70], [2590, 120, 90], [2591, 120, 90], [2592, 120, 90],
              [2593, 109.49, 44.64], [2595, 70, 70], [2596, 120, 90], [2597, 40, 50], [2598, 70, 70], [2600, 50, 60],
              [2601, 70, 70], [2603, 120, 90], [2604, 27.78, 27.06], [2606, 18.48, 15.38], [2607, 14.85, 16.55],
              [2608, 70, 70], [2610, 70, 70], [2612, 44.84, 32.36], [2613, 120, 90], [2615, 80.55, 54.14],
              [2617, 17.59, 35.03], [2619, 57.48, 50.98], [2620, 50, 60], [2621, 120, 90], [2622, 22.29, 20.66],
              [2623, 36.98, 28.35], [2624, 120, 90], [2627, 70, 70], [2628, 49.77, 79.26], [2630, 120, 90],
              [2631, 70, 70], [2632, 22.83, 26.19], [2633, 30.65, 46.26], [2634, 130.51, 90], [2635, 12, 22.39],
              [2636, 105.09, 70], [2638, 70, 70], [2639, 9.66, 9.9], [2642, 120, 90], [2644, 71.93, 71.93],
              [2646, 30, 45], [2647, 51.91, 54.1], [2649, 50, 60], [2650, 120, 90], [2651, 32.4, 19.95],
              [2652, 37.5, 45], [2653, 70, 70], [2655, 40, 50], [2656, 50.2, 42.1], [2658, 73.53, 35.42],
              [2660, 40, 50], [2661, 70, 70], [2663, 50, 60], [2664, 11, 16.7], [2665, 70, 70], [2667, 63.81, 52.19],
              [2668, 50.55, 38.31], [2669, 75, 64.66], [2670, 70, 70], [2671, 50, 45], [2672, 13.43, 14.62],
              [2677, 70, 70], [2681, 70, 70], [2682, 120, 90], [2683, 9.17, 6.35], [2684, 70.83, 69.48], [2685, 50, 60],
              [2686, 9.12, 8.12], [2687, 94.14, 34.56], [2691, 50, 60], [2692, 70, 70], [2694, 120, 90], [2695, 12, 18],
              [2696, 70, 70], [2697, 120, 90], [2703, 50, 60], [2704, 10.96, 9.94], [2706, 120, 90], [2707, 70, 70],
              [2710, 18.57, 12.32], [2711, 50, 60], [2712, 87.13, 70], [2713, 80, 145], [2714, 50, 60], [2716, 70, 70],
              [2719, 70, 70], [2720, 46, 38.9], [2722, 120, 90], [2723, 70, 70], [2725, 70, 70], [2726, 120.52, 25.63],
              [2728, 120, 90], [2730, 76.1, 66.81], [2731, 120, 90], [2734, 50, 50], [2735, 6.21, 6.8], [2736, 30, 45],
              [2737, 40, 50], [2738, 40, 37.5], [2739, 50, 60], [2740, 120, 90], [2741, 70, 70], [2743, 27.47, 30.75],
              [2746, 70, 70], [2747, 59.05, 33.48], [2748, 123.58, 59.04], [2750, 30, 45], [2752, 70, 70],
              [2753, 50, 60], [2755, 120, 90], [2756, 67, 70], [2757, 120, 90], [2758, 36.94, 36.69], [2759, 120, 90],
              [2760, 120, 90], [2762, 120, 90], [2763, 120, 90], [2764, 70, 70], [2765, 120, 90], [2766, 8.32, 6.64],
              [2767, 120, 90], [2768, 120, 90], [2770, 120, 90], [2772, 70, 70], [2773, 50, 60], [2774, 120, 90],
              [2775, 70, 70], [2778, 70, 70], [2781, 9.91, 6.13], [2782, 64.72, 61.32], [2783, 70, 70],
              [2784, 103.9, 81.72], [2785, 5.56, 14], [2786, 70, 70], [2787, 64.37, 35.05], [2788, 99.81, 58.02],
              [2791, 30, 37.5], [2792, 120, 90], [2793, 40, 50], [2795, 70, 70], [2796, 70, 70], [2797, 38.38, 16.45],
              [2798, 12, 21.53], [2800, 85.82, 80.02], [2801, 120, 90], [2804, 16.93, 11.94], [2806, 70, 70],
              [2807, 36.77, 11.92], [2808, 50, 60], [2809, 120, 90], [2811, 34.31, 28.04], [2813, 34.06, 29.31],
              [2814, 120, 90], [2818, 9.74, 14.61], [2819, 11.84, 8.58], [2820, 70, 70], [2821, 70, 70], [2822, 40, 50],
              [2823, 29.35, 32.47], [2826, 40, 50], [2827, 13.13, 23.21], [2831, 120, 90], [2832, 23.2, 22.2],
              [2833, 65.79, 46.49], [2834, 50, 60], [2835, 37.5, 45], [2836, 36.81, 31.39], [2837, 120, 90],
              [2838, 120, 90], [2839, 120, 90], [2841, 120, 90], [2844, 70, 70], [2845, 120, 90], [2846, 40, 23.06],
              [2847, 30, 45], [2850, 50, 60], [2851, 75.14, 53.01], [2852, 37.5, 45], [2853, 79.31, 70],
              [2854, 14.43, 16.56], [2856, 124.74, 77.59], [2857, 120, 90], [2861, 50, 60], [2862, 70, 70],
              [2863, 25.3, 31], [2864, 120, 90], [2865, 120, 90], [2866, 50, 60], [2867, 120, 90], [2869, 5.93, 4.86],
              [2871, 120, 90], [2872, 14.38, 10.62], [2876, 106.83, 78.93], [2877, 120, 90], [2878, 120, 90],
              [2879, 50, 60], [2880, 39, 52.5], [2882, 120, 90], [2883, 48.97, 31.48], [2884, 102.9, 57.89],
              [2885, 164.05, 83.42], [2886, 70, 70], [2887, 70, 70], [2889, 70, 70], [2890, 120, 90], [2891, 120, 90],
              [2893, 120, 90], [2894, 120, 90], [2897, 120, 90], [2899, 98.66, 70], [2900, 50, 60],
              [2901, 107.65, 88.66], [2902, 120, 90], [2903, 120, 90], [2904, 65, 40.54], [2905, 50, 60],
              [2906, 120, 90], [2907, 11.65, 11.52], [2908, 70, 70], [2910, 41.38, 37.74], [2911, 120, 90],
              [2914, 70, 70], [2916, 70, 70], [2917, 50, 60], [2918, 17.8, 10.33], [2919, 120, 90], [2921, 120, 90],
              [2922, 16, 18], [2923, 56.16, 71.39], [2924, 120, 90], [2925, 120, 90], [2928, 70, 70],
              [2929, 35.62, 43.31], [2930, 70, 70], [2931, 70, 70], [2932, 30, 24.3], [2933, 70, 70],
              [2934, 57.1, 29.4], [2935, 120, 90], [2936, 90.08, 68.66], [2937, 120, 90], [2940, 120, 90],
              [2942, 70, 70], [2943, 120, 90], [2944, 50, 60], [2946, 117.5, 74.87], [2948, 61.55, 60],
              [2950, 116.48, 55.12], [2951, 120, 90], [2952, 70, 70], [2955, 70, 70], [2956, 30.2, 34.9],
              [2957, 120, 90], [2958, 70, 70], [2960, 50, 60], [2961, 50, 60], [2962, 40, 50], [2963, 120, 90],
              [2964, 50, 60], [2965, 120, 90], [2969, 15.24, 25.59], [2971, 70, 70], [2972, 120, 90], [2973, 70, 65],
              [2974, 22.89, 34.75], [2975, 70, 70], [2976, 120, 90], [2978, 24.61, 18.48], [2979, 27.1, 18.5],
              [2980, 21.22, 18.94], [2982, 40, 50], [2984, 13.6, 13.23], [2985, 50, 60], [2986, 120, 90],
              [2988, 120, 90], [2989, 50, 60], [2991, 50, 60], [2995, 26.5, 30.18], [2997, 11.88, 8.2],
              [2999, 6.02, 5.8], [3000, 53.82, 60], [3001, 56.14, 45.79], [3002, 126.06, 90], [3003, 120, 90],
              [3004, 36.81, 97.97], [3006, 70, 70], [3008, 28.3, 32.4], [3009, 50, 60], [3011, 15.65, 30],
              [3012, 70, 70], [3014, 120, 90], [3015, 30, 37.5], [3016, 44.41, 35.25], [3017, 120, 90], [3019, 50, 60],
              [3022, 120, 90], [3024, 70, 70], [3025, 70, 70], [3026, 12.16, 8.01], [3027, 22, 43.41], [3031, 50, 60],
              [3033, 120, 90], [3035, 25.46, 23.67], [3037, 50, 60], [3041, 52.5, 52.5], [3042, 5.83, 5.64],
              [3043, 74.42, 70], [3044, 70, 70], [3045, 120, 90], [3046, 50.66, 21.51], [3047, 50, 60],
              [3048, 101.09, 97.17], [3049, 120, 90], [3050, 27.97, 29.63], [3051, 120, 90], [3052, 50, 60],
              [3053, 70, 70], [3054, 50, 60], [3055, 120, 90], [3056, 15.98, 16.7], [3057, 70, 70], [3058, 71.08, 70],
              [3059, 120, 90], [3060, 70, 70], [3061, 128.24, 46.52], [3063, 70, 70], [3064, 50, 60], [3066, 70, 70],
              [3069, 120, 90], [3070, 56.43, 49.17], [3073, 120, 90], [3076, 120, 90], [3077, 39.42, 34.65],
              [3078, 70, 70], [3079, 70, 70], [3084, 70, 70], [3085, 50, 50], [3086, 97.92, 38.7], [3087, 70, 70],
              [3089, 38.17, 24], [3090, 50, 60], [3091, 19.67, 20.1], [3092, 70, 70], [3095, 120, 90],
              [3098, 29.85, 64.97], [3100, 120, 90], [3101, 120, 90], [3104, 7.73, 6.59], [3105, 70, 70],
              [3106, 34.5, 25.1], [3107, 120, 90], [3109, 50, 60], [3112, 87.4, 44.91], [3113, 50, 60], [3114, 120, 90],
              [3115, 120, 90], [3117, 50, 60], [3118, 120, 90], [3119, 12.2, 16.8], [3121, 64.93, 30.4],
              [3122, 62.93, 34.45], [3123, 120, 90], [3126, 70, 70], [3127, 9.37, 9.65], [3128, 47, 50],
              [3129, 53.29, 36.48], [3130, 12, 10], [3131, 8.27, 8.03], [3132, 120, 90], [3133, 60.55, 31.38],
              [3134, 50, 45], [3135, 120, 90], [3136, 40, 50], [3137, 20.3, 19.5], [3138, 120, 90], [3139, 5.88, 5.48],
              [3140, 70, 70], [3141, 50, 60], [3142, 40, 50], [3143, 70, 70], [3144, 120, 90], [3148, 33.08, 29.22],
              [3149, 120, 90], [3151, 120, 90], [3152, 50, 60], [3154, 87.45, 60.56], [3155, 98.27, 51.32],
              [3158, 18, 18], [3160, 22.3, 61.32], [3161, 12.56, 13.35], [3163, 70, 70], [3164, 70, 70],
              [3165, 70, 45.26], [3166, 0.17, 0.59], [3167, 29.9, 16.62], [3168, 120, 90], [3171, 40, 50],
              [3172, 120, 90], [3175, 73.26, 36.41], [3177, 37.5, 45], [3181, 8.14, 6.4], [3182, 22.27, 15.36],
              [3183, 51.17, 40.2], [3184, 70, 70], [3187, 24.7, 20.1], [3188, 25.17, 19.72], [3189, 192.54, 70.66],
              [3190, 26.99, 20.03], [3191, 70, 70], [3192, 120, 90], [3195, 24.49, 21.37], [3196, 70, 70],
              [3197, 99.63, 37.69], [3198, 9.06, 10.25], [3199, 70, 70], [3200, 40, 50], [3203, 12.22, 10.64],
              [3206, 60.72, 58.05], [3207, 50, 60], [3208, 120, 90], [3211, 70, 70], [3212, 120, 90], [3214, 70, 70],
              [3216, 120, 90], [3217, 42.15, 37.9], [3219, 10.36, 9.85], [3220, 120, 90], [3221, 70, 70],
              [3225, 6.02, 7.89], [3227, 25, 20], [3228, 72.06, 47.49], [3229, 120, 90], [3231, 19.83, 26.04],
              [3234, 37.45, 21.3], [3239, 120, 90], [3240, 120, 90], [3241, 50, 60], [3242, 70, 70], [3243, 12.14, 9.5],
              [3244, 120, 90], [3246, 65.38, 60.87], [3247, 120, 90], [3248, 40, 17.83], [3249, 120, 90],
              [3251, 40, 50], [3252, 50, 60], [3253, 70, 70], [3254, 40.73, 38.06], [3255, 70, 70],
              [3256, 30.27, 22.34], [3257, 50, 60], [3258, 70, 70], [3259, 50, 60], [3260, 10, 13.06], [3262, 70, 70],
              [3263, 120, 90], [3264, 21.89, 30.71], [3265, 120, 90], [3266, 86.9, 70], [3267, 50, 60],
              [3268, 60.02, 38.25], [3270, 17.3, 14.21], [3271, 120, 90], [3272, 101.18, 75.84], [3273, 120, 90],
              [3274, 45, 32.77], [3275, 120, 90], [3276, 120, 90], [3277, 91.74, 42.99], [3278, 63.11, 20.86],
              [3279, 70, 70], [3280, 59.87, 41.55], [3283, 12.69, 12.13], [3284, 42.57, 30.98], [3286, 15.7, 9.65],
              [3287, 50, 60], [3288, 30.42, 23.34], [3289, 85, 70], [3290, 21.59, 14.57], [3292, 120, 90],
              [3293, 70, 70], [3294, 50, 60], [3295, 120, 90], [3296, 30, 45], [3300, 70, 70], [3301, 70, 70],
              [3302, 40, 50], [3303, 70, 70], [3305, 120, 90], [3306, 24.91, 27.22], [3308, 70, 70], [3309, 50, 45],
              [3312, 70, 70], [3313, 120, 90], [3314, 50, 60], [3315, 120, 90], [3316, 120, 90], [3318, 70, 70],
              [3319, 70, 70], [3320, 120, 90], [3321, 50, 60], [3322, 120, 90], [3324, 9.8, 13.83],
              [3325, 38.61, 28.27], [3326, 51.15, 39.66], [3327, 98.77, 87.26], [3328, 120, 90], [3329, 8.87, 8.14],
              [3331, 108.09, 47.79], [3332, 120, 90], [3333, 120, 90], [3334, 8.78, 7.44], [3335, 70, 70],
              [3336, 46.22, 26.88], [3338, 70, 70], [3340, 50, 60], [3341, 24.19, 12.04], [3342, 70, 70],
              [3343, 120, 90], [3344, 96.68, 56.26], [3346, 90.98, 55.27], [3347, 120, 90], [3348, 70, 70],
              [3350, 120, 90], [3351, 120, 90], [3353, 120, 90], [3357, 12.58, 12.94], [3358, 19.2, 17.45],
              [3359, 120, 90], [3361, 120, 90], [3363, 14.08, 11.88], [3364, 12, 21.69], [3366, 120, 90],
              [3367, 50, 60], [3369, 120, 90], [3370, 48.58, 95.54], [3371, 70, 60], [3372, 70, 70], [3376, 120, 90],
              [3378, 9.02, 8.54], [3380, 120, 90], [3381, 120, 90], [3382, 23.2, 25.03], [3384, 70, 70],
              [3386, 120, 90], [3387, 70, 70], [3388, 120, 90], [3389, 31.29, 20.21], [3390, 59.69, 14.2],
              [3391, 120, 90], [3392, 120, 90], [3393, 120, 90], [3394, 120, 90], [3396, 21.88, 28.51],
              [3399, 89.86, 75.76], [3400, 50, 60], [3402, 120, 90], [3403, 16.87, 10.26], [3404, 41.37, 52.15],
              [3407, 63.12, 31.83], [3408, 120, 90], [3411, 70.12, 70], [3414, 50, 60], [3415, 40, 50], [3416, 40, 50],
              [3417, 120, 70], [3418, 120, 90], [3419, 70, 70], [3420, 70, 70], [3422, 50.99, 25.75], [3423, 120, 90],
              [3424, 37.5, 45], [3426, 120, 90], [3428, 70, 70], [3429, 49.14, 44.47], [3431, 120, 90], [3432, 70, 70],
              [3433, 19.6, 20.1], [3434, 6.86, 5.46], [3436, 50, 60], [3437, 70.24, 70], [3438, 70, 70],
              [3439, 36.81, 46.42], [3440, 50, 60], [3441, 59.78, 46.81], [3442, 34.82, 34.71], [3444, 17.9, 15.29],
              [3445, 70, 70], [3448, 5.56, 6.38], [3449, 70, 70], [3450, 70, 70], [3451, 71.38, 68.39], [3452, 120, 90],
              [3453, 15.33, 23.54], [3454, 18.63, 15.82], [3456, 70, 90], [3457, 120, 90], [3459, 72.5, 55.8],
              [3461, 68.26, 26.15], [3462, 55.41, 24.77], [3463, 120, 90], [3464, 120, 90], [3468, 76.43, 44.44],
              [3469, 34.89, 19.21], [3471, 70, 70], [3472, 120, 90], [3473, 12.27, 10.63], [3474, 70, 70],
              [3476, 40, 50], [3480, 120, 90], [3481, 70, 70], [3482, 70, 70], [3483, 70, 70], [3484, 120, 90],
              [3485, 52.28, 52.85], [3487, 50, 60], [3488, 23, 23], [3489, 40, 50], [3492, 120, 90], [3493, 70, 70],
              [3494, 12, 18], [3496, 120, 90], [3497, 120, 90], [3498, 38.68, 34.83], [3499, 120, 90], [3501, 120, 90],
              [3503, 120, 90], [3504, 70, 70], [3505, 120, 90], [3508, 120, 90], [3509, 40, 60], [3510, 120, 90],
              [3511, 70, 70], [3514, 18.7, 27], [3515, 70, 70], [3516, 120, 90], [3517, 70, 70], [3518, 120, 90],
              [3519, 50, 60], [3520, 120, 90], [3521, 120, 90], [3523, 120, 90], [3525, 120, 90], [3527, 120, 90],
              [3530, 52.8, 38.6], [3531, 42.22, 34.38], [3534, 70, 70], [3535, 30, 45], [3537, 120, 90],
              [3539, 120, 90], [3541, 42.81, 43.65], [3543, 120, 90], [3545, 120, 90], [3546, 120, 90],
              [3549, 22.69, 14.17], [3551, 120, 90], [3553, 70, 70], [3554, 50, 60], [3555, 40, 50],
              [3557, 16.81, 25.35], [3558, 70, 70], [3559, 50, 60], [3560, 120, 90], [3561, 120, 90], [3564, 120, 90],
              [3566, 17.61, 17.41], [3568, 12.22, 9.98], [3569, 50, 60], [3570, 70, 70], [3571, 70, 70],
              [3572, 120, 90], [3573, 120, 90], [3575, 120, 90], [3576, 120, 90], [3577, 70, 70], [3579, 22.92, 33.97],
              [3580, 70, 70], [3581, 120, 90], [3582, 4.45, 5.68], [3585, 70, 70], [3586, 70, 70], [3587, 70, 70],
              [3588, 120, 90], [3589, 12, 18], [3590, 40, 43.95], [3592, 70, 70], [3593, 35.78, 25.31], [3594, 120, 90],
              [3595, 70, 90], [3596, 120, 90], [3597, 70, 70], [3598, 22.96, 24.32], [3599, 120, 90],
              [3600, 49.66, 38.48], [3601, 75.67, 62.54], [3602, 51.79, 46.05], [3606, 40, 50], [3607, 12.7, 15.8],
              [3608, 33.57, 26.7], [3609, 151.97, 90], [3610, 50, 60], [3611, 70, 70], [3612, 70, 70], [3613, 40, 50],
              [3614, 9.76, 7.31], [3615, 70, 70], [3617, 70, 70], [3619, 70, 70], [3620, 48, 60], [3621, 50, 60],
              [3622, 120, 90], [3623, 120, 90], [3624, 16.21, 10.44], [3626, 120, 90], [3627, 120, 90], [3628, 30, 45],
              [3629, 70, 70], [3631, 70, 70], [3632, 48.09, 38.27], [3633, 71.55, 70], [3634, 24.1, 17.22],
              [3635, 50, 60], [3636, 70, 70], [3637, 40, 50], [3639, 120, 90], [3641, 40, 50], [3642, 58.18, 27.21],
              [3643, 70, 70], [3644, 37.33, 36.38], [3647, 70, 70], [3648, 70, 70], [3649, 120, 90],
              [3650, 93.96, 49.61], [3651, 40, 50], [3652, 40, 50], [3653, 49.84, 42.61], [3656, 42.55, 28.63],
              [3657, 40, 50], [3659, 45.77, 17.29], [3661, 49.38, 28.07], [3662, 30, 45], [3663, 120, 90],
              [3665, 120, 90], [3666, 120, 90], [3667, 30.09, 35.52], [3668, 120, 90], [3669, 12, 25.38],
              [3670, 96.19, 48.48], [3671, 120, 90], [3675, 120, 90], [3676, 120, 90], [3677, 50, 60],
              [3678, 11.23, 7.28], [3679, 22.74, 35.74], [3681, 70, 70], [3683, 7.87, 11.07], [3685, 120, 90],
              [3686, 120, 90], [3687, 92.77, 76.03], [3688, 120, 90], [3690, 120, 90], [3691, 13.11, 11.71],
              [3692, 24.91, 11.38], [3694, 70, 70], [3695, 120, 90], [3696, 70, 70], [3698, 120, 90],
              [3700, 25.38, 59.21], [3701, 29.01, 18.72], [3702, 16.7, 11.85], [3703, 175.88, 66.13], [3705, 30, 45],
              [3707, 70, 70], [3708, 70, 70], [3710, 50, 60], [3711, 9.31, 9.41], [3713, 71.95, 70], [3714, 120, 90],
              [3716, 120, 90], [3718, 70, 70], [3719, 120, 90], [3720, 95.89, 30.16], [3722, 40, 50], [3723, 30, 45],
              [3724, 12.29, 10.32], [3726, 12, 18], [3728, 120, 90], [3729, 120, 90], [3731, 40, 25.08],
              [3733, 120, 90], [3738, 30, 45], [3741, 120, 90], [3745, 120, 90], [3747, 33.24, 30.21], [3748, 120, 90],
              [3749, 120, 90], [3751, 27.22, 22.15], [3752, 38.07, 10.83], [3753, 50, 60], [3755, 31.66, 30.53],
              [3756, 120, 90], [3758, 50, 60], [3759, 70, 70], [3761, 36.17, 17.01], [3762, 49.07, 30.08],
              [3763, 70, 70], [3764, 56.14, 29.13], [3765, 36.87, 29.24], [3766, 50, 60], [3768, 72.89, 70],
              [3769, 120, 90], [3775, 16.7, 21.1], [3776, 120, 90], [3777, 64.75, 33.71], [3780, 70, 70],
              [3781, 120, 90], [3782, 33.84, 17.76], [3783, 70, 70], [3785, 120, 90], [3786, 10.14, 9.72],
              [3791, 120, 90], [3793, 70, 70], [3795, 28.93, 71.01], [3796, 34.35, 19.61], [3797, 50, 60],
              [3799, 50, 60], [3800, 70, 70], [3801, 120, 90], [3802, 50, 60], [3804, 70, 70], [3807, 21.47, 18.5],
              [3811, 50, 60], [3812, 120, 90], [3814, 70, 70], [3815, 8.38, 6.36], [3816, 120, 90], [3820, 50, 60],
              [3821, 18.9, 24.5], [3822, 120, 90], [3824, 70, 70], [3826, 114.89, 70], [3827, 104.5, 55.33],
              [3828, 48.71, 27.21], [3830, 6.73, 6.06], [3832, 40.07, 56.69], [3833, 30, 45], [3834, 82.66, 53.29],
              [3837, 70, 70], [3839, 120, 90], [3841, 115.85, 58.55], [3842, 70, 70], [3843, 4.12, 8.93],
              [3845, 29.78, 34.18], [3846, 70, 70], [3849, 70, 70], [3850, 28.31, 33.02], [3851, 120, 90],
              [3853, 120, 90], [3854, 28.93, 29.68], [3855, 120, 90], [3856, 16.7, 22.9], [3858, 120, 90],
              [3859, 12, 23.21], [3862, 70, 70], [3863, 50, 60], [3865, 120, 90], [3866, 14.49, 13.27], [3867, 120, 90],
              [3868, 120, 90], [3869, 50, 60], [3870, 113.75, 53.42], [3871, 46.79, 28.4], [3873, 120, 90],
              [3874, 57.1, 44.75], [3877, 120, 70], [3879, 120, 90], [3880, 15.73, 17.34], [3881, 50, 60],
              [3882, 120, 90], [3883, 85.28, 79.59], [3884, 50, 60], [3886, 70, 70], [3887, 120, 90], [3889, 70, 70],
              [3890, 10.56, 9.46], [3891, 17.06, 21.5], [3892, 70, 70], [3896, 70, 70], [3897, 46.88, 27.21],
              [3898, 120, 90], [3899, 120, 90], [3900, 50.61, 29.08], [3901, 70, 70], [3903, 50, 60],
              [3905, 62.21, 43.82], [3906, 70, 70], [3909, 120, 90], [3910, 70, 70], [3915, 30, 45], [3916, 120, 90],
              [3918, 8.88, 7.78], [3919, 120, 90], [3921, 34.37, 32.04], [3922, 120, 90], [3923, 120, 90],
              [3924, 11.01, 5.63], [3925, 87.13, 64.34], [3927, 70, 70], [3928, 15.78, 11.76], [3929, 120, 90],
              [3930, 76.26, 70], [3931, 70, 70], [3932, 32.72, 42.52], [3933, 70, 70], [3935, 120, 90], [3936, 120, 90],
              [3937, 70, 70], [3938, 40, 50], [3939, 40, 50], [3940, 53.79, 32.63], [3941, 120, 90],
              [3942, 32.24, 20.58], [3943, 16.04, 19.53], [3944, 120, 90], [3946, 9.98, 9.98], [3947, 120, 90],
              [3950, 120, 90], [3951, 120, 90], [3952, 120, 90], [3953, 130.15, 56.8], [3954, 120, 90], [3956, 50, 60],
              [3958, 13.07, 12.08], [3959, 107.55, 47.75], [3960, 78.17, 40.51], [3961, 8.09, 5.91],
              [3963, 24.93, 29.76], [3964, 70, 70], [3966, 70, 70], [3968, 26.82, 32.61], [3969, 73.5, 49.04],
              [3970, 46.74, 74.49], [3971, 120, 90], [3972, 120, 86], [3976, 12, 24.6], [3978, 70, 70],
              [3979, 151.53, 70.45], [3980, 50, 60], [3981, 70, 70], [3982, 120, 90], [3983, 30, 45], [3985, 36, 28],
              [3988, 33.8, 45.99], [3990, 70, 70], [3991, 120, 90], [3992, 53.73, 58.98], [3993, 12, 18],
              [3994, 120, 90], [3996, 70, 70], [3997, 120, 90], [3998, 120, 90], [3999, 28.04, 39.32], [4001, 120, 90],
              [4002, 120, 90], [4003, 86.47, 73.85], [4004, 70, 70], [4005, 51.86, 17.81], [4007, 120, 90],
              [4008, 70, 70], [4010, 8.6, 12.5], [4012, 120, 90], [4013, 120, 90], [4014, 120, 90], [4015, 120, 90],
              [4016, 21, 33], [4017, 84.3, 28.73], [4018, 80.65, 70], [4019, 40, 50], [4021, 70, 70], [4022, 70, 70],
              [4023, 34.76, 26.62], [4024, 120, 90], [4026, 36.65, 22.13], [4027, 120, 90], [4028, 70, 70],
              [4031, 17.94, 39.15], [4034, 120, 90], [4035, 17.68, 13.86], [4038, 120, 90], [4040, 85.79, 70.07],
              [4041, 120, 90], [4043, 20, 20], [4045, 10.39, 9.07], [4047, 44.52, 35.91], [4048, 14.6, 19.7],
              [4049, 70, 70], [4051, 120, 90], [4053, 64.92, 33.42], [4057, 50, 60], [4059, 113.78, 76.04],
              [4062, 70.39, 70], [4063, 50, 60], [4065, 70.03, 70], [4066, 70, 70], [4068, 120, 90],
              [4069, 58.37, 31.62], [4070, 70, 70], [4071, 70, 70], [4072, 120, 90], [4073, 30, 45], [4074, 70, 70],
              [4076, 120, 90], [4080, 120, 90], [4081, 120, 90], [4082, 120, 90], [4083, 120, 90], [4084, 14, 13.72],
              [4085, 70, 70], [4087, 120, 90], [4088, 120, 90], [4090, 120, 90], [4091, 70, 70], [4092, 98.89, 70],
              [4093, 120, 90], [4094, 50, 60], [4095, 30.82, 30.34], [4096, 85.87, 50.11], [4097, 120, 90],
              [4100, 50, 60], [4102, 70.01, 70], [4103, 70, 70], [4104, 70, 70], [4105, 120, 90], [4106, 35.03, 33.83],
              [4107, 120, 90], [4108, 47, 127], [4109, 11.09, 23.39], [4110, 70, 70], [4111, 46.81, 38.06],
              [4112, 40, 50], [4115, 120, 90], [4116, 31.55, 32.55], [4117, 53.51, 60], [4118, 27.75, 35.04],
              [4119, 120, 90], [4120, 34.02, 34.24], [4121, 70, 70], [4122, 103.31, 86.3], [4124, 53.38, 47.38],
              [4125, 12, 18], [4128, 28, 24.17], [4129, 14.06, 10.13], [4131, 16.41, 11.2], [4133, 70, 70],
              [4134, 89.38, 44.91], [4136, 50, 60], [4137, 120, 90], [4138, 11.77, 6.96], [4139, 30, 45],
              [4140, 49.79, 34.67], [4142, 70, 70], [4143, 50, 60], [4145, 120, 90], [4146, 6.49, 5.75],
              [4147, 120, 90], [4149, 50, 60], [4150, 70, 70], [4152, 101.39, 50.61], [4154, 120, 90], [4155, 70, 70],
              [4156, 78.4, 74.93], [4157, 30.51, 11.96], [4158, 120, 90], [4159, 6.8, 6.65], [4162, 120, 90],
              [4164, 16.17, 15.54], [4165, 120, 90], [4166, 30, 45], [4167, 70, 70], [4168, 37.5, 45],
              [4169, 35.25, 45.76], [4173, 12, 24.28], [4175, 51.01, 25.06], [4176, 10, 16], [4177, 58.73, 69.61],
              [4178, 120, 90], [4179, 23.41, 16.69], [4180, 14.1, 8.76], [4181, 120, 90], [4182, 76.84, 36.41],
              [4185, 14.91, 16.67], [4186, 50, 60], [4188, 120, 90], [4189, 24.6, 36], [4190, 120, 90], [4192, 50, 60],
              [4193, 120, 90], [4194, 120, 90], [4197, 50, 60], [4199, 76.31, 53.54], [4200, 12.14, 9.28],
              [4203, 62.98, 58.18], [4205, 120, 90], [4206, 12.5, 12], [4207, 60.24, 34.36], [4208, 120, 90],
              [4209, 22.23, 20.17], [4210, 56.87, 36.84], [4211, 120, 90], [4213, 40.9, 35.4], [4215, 120, 90],
              [4216, 120, 90], [4219, 30, 45], [4220, 70, 70], [4221, 70, 70], [4222, 120, 90], [4223, 5.37, 4.59],
              [4224, 42.19, 39.65], [4225, 120, 90], [4226, 73.7, 42.65], [4229, 36.01, 22.9], [4230, 70, 70],
              [4231, 70, 70], [4232, 40, 50], [4233, 30.06, 42.45], [4234, 70, 70], [4235, 6.53, 5.13], [4236, 70, 70],
              [4237, 120, 90], [4238, 120, 90], [4239, 120, 90], [4241, 120, 90], [4242, 22.45, 62.54],
              [4244, 11.58, 16.71], [4245, 50, 60], [4246, 23.77, 36.35], [4248, 70, 70], [4249, 120, 90],
              [4250, 120, 90], [4251, 120, 90], [4252, 7.87, 9.28], [4256, 50, 60], [4257, 40, 50], [4258, 17, 38.5],
              [4259, 12.25, 12.29], [4260, 120, 90], [4261, 50, 60], [4264, 8.46, 8.46], [4265, 70, 70],
              [4266, 120, 90], [4269, 120, 90], [4270, 120, 90], [4272, 72.31, 55.31], [4273, 120, 90], [4274, 120, 90],
              [4275, 70, 70], [4279, 25.11, 25.86], [4281, 70, 70], [4282, 50, 60], [4283, 19.15, 24.03],
              [4284, 120, 90], [4285, 36.64, 28.69], [4286, 120, 90], [4287, 14.84, 10.96], [4288, 120, 90],
              [4289, 43.54, 28.73], [4291, 50, 60], [4293, 7.15, 6.68], [4294, 79.07, 70], [4295, 70, 70],
              [4296, 42.82, 14.61], [4297, 70, 70], [4298, 120, 80], [4299, 70, 48.52], [4301, 60.86, 37.6],
              [4302, 26.64, 23.08], [4305, 70, 70], [4307, 120, 90], [4308, 120, 90], [4309, 11.7, 18], [4310, 50, 60],
              [4312, 70, 70], [4313, 120, 90], [4317, 50, 60], [4318, 39.31, 26.34], [4320, 46.9, 37],
              [4323, 24.53, 33.29], [4325, 29.6, 19.97], [4326, 11.3, 11.2], [4328, 70, 70], [4329, 22.52, 19.08],
              [4330, 70, 70], [4333, 17.64, 32.54], [4334, 120, 90], [4337, 30.93, 37.77], [4338, 26.42, 28.94],
              [4339, 21.74, 15.6], [4340, 13.6, 21.8], [4341, 120, 90], [4343, 120, 90], [4345, 48.44, 41.98],
              [4346, 50, 60], [4347, 120, 90], [4349, 21.62, 31.72], [4350, 26.85, 29.25], [4352, 41.47, 35.71],
              [4353, 40.7, 33.52], [4355, 120, 90], [4356, 12.68, 15.44], [4358, 23.24, 26.31], [4360, 84.9, 70],
              [4362, 57.64, 39.46], [4363, 70, 70], [4364, 59.2, 40.69], [4365, 120, 90], [4366, 70, 70],
              [4367, 120, 90], [4372, 70, 70], [4374, 30, 45], [4375, 70, 70], [4376, 120, 90], [4377, 70, 70],
              [4378, 70, 70], [4380, 66.47, 40.12], [4382, 70, 65], [4383, 70, 70], [4384, 45.16, 27.63],
              [4386, 16.95, 21.6], [4387, 120, 90], [4389, 70, 70], [4390, 120, 90], [4391, 19.92, 20.51],
              [4392, 70, 70], [4394, 70, 70], [4395, 70, 70], [4396, 70, 70], [4397, 7.76, 8.86], [4398, 70, 70],
              [4399, 50, 60], [4400, 120, 90], [4402, 40, 50], [4404, 120, 90], [4405, 6.29, 4.6], [4406, 63.31, 68.07],
              [4407, 70, 70], [4408, 18, 27], [4409, 120, 90], [4410, 70, 70], [4411, 120, 90], [4412, 120, 90],
              [4413, 26.66, 14.26], [4414, 18.02, 27], [4415, 126.64, 97.53], [4416, 70, 70], [4417, 50, 60],
              [4418, 131.53, 70.86], [4419, 70, 70], [4420, 5.73, 6.7], [4421, 73.94, 42.49], [4426, 12, 18],
              [4427, 40, 50], [4428, 70, 70], [4432, 70, 70], [4433, 120, 90], [4436, 40, 50], [4438, 50, 50],
              [4439, 40, 50], [4440, 70, 70], [4441, 16.95, 12.33], [4442, 18, 27], [4443, 41.1, 27.5], [4444, 70, 90],
              [4445, 70, 90], [4446, 37.11, 22.57], [4448, 70, 70], [4450, 120, 90], [4453, 50, 60],
              [4454, 25.13, 30.27], [4455, 70, 70], [4456, 15.9, 14.4], [4457, 40, 50], [4460, 70, 70],
              [4461, 25.09, 25.72], [4463, 38.22, 20.51], [4464, 44.69, 25.78], [4465, 70, 70], [4466, 70, 70],
              [4467, 120, 90], [4468, 70, 70], [4470, 50, 60], [4471, 48.21, 38.33], [4473, 70, 70], [4477, 37.5, 45],
              [4479, 120, 90], [4481, 120, 90], [4482, 120, 90], [4484, 120, 90], [4486, 120, 90], [4487, 44.33, 51.92],
              [4488, 70, 70], [4489, 11.71, 6.08], [4490, 120, 90], [4491, 70, 70], [4493, 47.38, 71.88],
              [4494, 19.4, 18.2], [4495, 74.53, 49.3], [4498, 70, 70], [4500, 18.74, 29.58], [4501, 120, 90],
              [4502, 50, 60], [4504, 69.49, 38], [4505, 70, 70], [4506, 29.14, 12.62], [4508, 43.63, 35.85],
              [4509, 120, 90], [4510, 33.56, 26.64], [4511, 70, 70], [4512, 12.38, 7.83], [4513, 40, 50],
              [4514, 120, 90], [4515, 40.56, 78.59], [4517, 29.39, 25.61], [4518, 72.62, 43.09], [4520, 22.49, 21.03],
              [4521, 115.81, 56], [4523, 50, 60], [4524, 36.64, 34.46], [4525, 50, 60], [4526, 7.23, 8.94],
              [4527, 120, 90], [4530, 13.96, 9.89], [4531, 120, 90], [4532, 66.87, 50.91], [4533, 70, 70],
              [4534, 70, 70], [4535, 70, 70], [4536, 7.2, 20.3], [4538, 18, 18], [4539, 78.64, 44.85],
              [4540, 10.59, 6.68], [4541, 120, 90], [4542, 65, 35], [4543, 37.5, 45], [4545, 70, 70],
              [4546, 16.6, 24.9], [4548, 20.54, 15.72], [4549, 23.8, 26.7], [4550, 65.66, 48.34], [4551, 70, 70],
              [4552, 55.6, 45.56], [4553, 120, 90], [4555, 11.6, 15.4], [4556, 120, 90], [4558, 90.79, 78.09],
              [4560, 120, 90], [4563, 53.86, 28.78], [4566, 83.86, 83.48], [4568, 50, 60], [4569, 70, 70],
              [4571, 70, 70], [4572, 105.72, 48.73], [4576, 28.7, 23.7], [4577, 13.21, 11.61], [4578, 90.9, 70],
              [4579, 8.36, 6.62], [4580, 50, 60], [4582, 70, 70], [4584, 40, 50], [4585, 92.75, 76.06], [4587, 120, 90],
              [4590, 70, 70], [4591, 38.76, 40.37], [4593, 6.78, 5.29], [4597, 120, 90], [4598, 120, 90],
              [4599, 120, 90], [4600, 50, 60], [4601, 33.72, 42.28], [4602, 29.41, 34.07], [4603, 120, 90],
              [4604, 120, 90], [4605, 9.5, 15.6], [4606, 28.45, 30.94], [4607, 120, 90], [4608, 38.4, 32.2],
              [4610, 70, 70], [4611, 62.95, 50.94], [4612, 70, 70], [4613, 120, 77.8], [4614, 70, 70], [4615, 120, 90],
              [4616, 27.98, 41.56], [4617, 95.75, 69.39], [4618, 70, 70], [4619, 70, 70], [4620, 70, 70],
              [4621, 40, 50], [4622, 120, 90], [4623, 18, 27], [4626, 40, 50], [4627, 70, 70], [4628, 120, 90],
              [4629, 70, 70], [4630, 120, 90], [4631, 20.43, 22.07], [4633, 23.94, 28.78], [4634, 34.71, 35.52],
              [4635, 16.11, 11.7], [4636, 120, 90], [4637, 70.44, 90], [4638, 54.7, 34.62], [4641, 15.53, 8.78],
              [4643, 120, 90], [4644, 15.8, 15.4], [4645, 50, 60], [4648, 50, 60], [4649, 50, 60], [4651, 70, 70],
              [4652, 50, 50], [4653, 120, 90], [4655, 120, 90], [4657, 120, 90], [4658, 70, 70], [4660, 70, 70],
              [4661, 70, 70], [4662, 70, 70], [4664, 10.86, 8.78], [4665, 120, 90], [4666, 120, 90], [4667, 70, 70],
              [4668, 62.61, 42.44], [4670, 70, 70], [4671, 120, 90], [4674, 15, 20], [4675, 19.2, 19.5],
              [4676, 13.79, 18.19], [4677, 70, 70], [4679, 120, 90], [4682, 120, 90], [4684, 39.81, 23.32],
              [4685, 60.96, 34.44], [4687, 14.2, 21.3], [4688, 17.49, 12.85], [4689, 50, 60], [4690, 70, 70],
              [4691, 27.06, 17.14], [4692, 3.57, 3.82], [4693, 119.12, 52.9], [4694, 58.78, 40.42], [4695, 70, 70],
              [4696, 120, 90], [4697, 120, 90], [4698, 70, 70], [4699, 120, 90], [4701, 70, 70], [4702, 120, 90],
              [4703, 23.69, 36.87], [4704, 120, 90], [4705, 120, 90], [4708, 70, 70], [4709, 120, 90],
              [4710, 8.73, 6.69], [4711, 34.53, 20.2], [4712, 39.53, 31.14], [4713, 50, 60], [4716, 120, 90],
              [4717, 16.28, 21.19], [4718, 120, 90], [4720, 49.72, 35.65], [4722, 120, 90], [4724, 47.15, 28.88],
              [4725, 8.6, 7.78], [4726, 120, 90], [4728, 25.36, 23.41], [4729, 68.67, 36.75], [4731, 4.74, 5.39],
              [4732, 50, 60], [4733, 86.8, 70], [4734, 20, 20], [4736, 70, 70], [4737, 120, 90], [4738, 50.45, 38.8],
              [4740, 70, 70], [4741, 50, 60], [4742, 120, 90], [4743, 70, 70], [4744, 40, 50], [4745, 40, 50],
              [4747, 55.87, 35.31], [4749, 70, 70], [4750, 9.46, 10.97], [4751, 19.36, 32.46], [4752, 70, 70],
              [4753, 88.11, 37.86], [4754, 120, 90], [4755, 13.77, 7.34], [4756, 129.21, 50], [4757, 120, 90],
              [4760, 120, 90], [4761, 15.75, 12.37], [4762, 52.5, 52.5], [4764, 46.9, 75], [4765, 50, 60],
              [4771, 70, 70], [4772, 70, 70], [4775, 70, 70], [4776, 37.5, 45], [4777, 24.04, 33.32], [4778, 50, 60],
              [4779, 50, 60], [4780, 110.99, 50.6], [4781, 30, 37.5], [4782, 87.14, 72.26], [4784, 120, 90],
              [4785, 120, 90], [4786, 120, 90], [4788, 6.3, 12.1], [4789, 70, 70], [4790, 70, 70], [4791, 39.76, 77.7],
              [4792, 92.77, 76.03], [4793, 120, 90], [4794, 41.99, 22.03], [4797, 20.25, 21.58], [4799, 70, 70],
              [4800, 22.3, 23.87], [4801, 21, 27], [4802, 128.4, 56.12], [4803, 79.74, 17.5], [4805, 16.75, 18],
              [4806, 70, 70], [4807, 50, 60], [4809, 120, 90], [4810, 120, 90], [4811, 50, 60], [4812, 120, 90],
              [4813, 60, 131], [4814, 120, 90], [4815, 55.01, 32.18], [4816, 70, 70], [4818, 120, 90],
              [4819, 57.44, 40.47], [4820, 70, 70], [4821, 120, 90], [4825, 120, 90], [4826, 28.39, 26.06],
              [4828, 47.32, 22.66], [4829, 45.03, 39.57], [4831, 7.24, 8.44], [4832, 12, 18], [4834, 120, 90],
              [4835, 51.6, 40.69], [4838, 39.63, 29.51], [4839, 37.82, 38.91], [4840, 70, 70], [4841, 120, 90],
              [4842, 120, 90], [4844, 59.83, 43.65], [4846, 12.98, 17.47], [4848, 120, 90], [4849, 14.83, 14.22],
              [4851, 120, 90], [4852, 70, 70], [4853, 10.34, 10.99], [4854, 120, 90], [4856, 12, 18], [4863, 70, 70],
              [4864, 8.85, 15.97], [4865, 40, 50], [4866, 12, 18], [4867, 38.67, 22.56], [4869, 120, 90],
              [4871, 21.01, 27.1], [4872, 36.26, 41.54], [4875, 11.1, 18.8], [4876, 40, 50], [4877, 18.65, 29.18],
              [4878, 50, 60], [4879, 120, 90], [4880, 23.1, 15.3], [4881, 35.37, 49.96], [4882, 120, 90],
              [4885, 18, 23.69], [4887, 120, 90], [4888, 70, 70], [4893, 53.46, 31.32], [4894, 50, 60], [4895, 120, 90],
              [4896, 18.2, 35.8], [4897, 22.65, 32.49], [4902, 70, 70], [4905, 40, 50], [4906, 40, 50], [4907, 70, 70],
              [4909, 17.42, 19.96], [4910, 20.48, 22.01], [4911, 11.82, 7.07], [4912, 12.39, 15.28], [4914, 120, 90],
              [4915, 12.81, 25.88], [4916, 21.19, 34.67], [4918, 29.8, 29.23], [4920, 40, 50], [4922, 68.28, 37.1],
              [4923, 120, 90], [4926, 55.14, 28.19], [4927, 28.01, 18.8], [4928, 70, 70], [4929, 70, 70],
              [4930, 70, 70], [4931, 33.7, 31.78], [4934, 51.99, 38.18], [4936, 120, 90], [4939, 28.05, 30.31],
              [4940, 95.48, 82.93], [4942, 50, 60], [4944, 18, 18], [4946, 120, 90], [4949, 50, 60],
              [4950, 70.53, 51.44], [4951, 66.71, 36.01], [4953, 120, 90], [4954, 70, 70], [4955, 29.76, 27.35],
              [4956, 70, 70], [4957, 64.8, 59.23], [4958, 120, 90], [4960, 106.07, 54.99], [4962, 70, 70],
              [4963, 31, 51], [4964, 7.37, 6.44], [4965, 42.65, 79.28], [4966, 70, 70], [4968, 120, 90], [4971, 70, 70],
              [4972, 120, 90], [4973, 34.33, 57.8], [4974, 50, 60], [4975, 52.81, 42.1], [4976, 12, 22.97],
              [4977, 120, 90], [4978, 120, 90], [4979, 56.77, 40.85], [4981, 50, 50], [4983, 29.76, 20.92],
              [4984, 20, 13.27], [4985, 6.45, 5.95], [4987, 39.69, 32.93], [4988, 70, 70], [4989, 120, 90],
              [4990, 106.41, 53.31], [4992, 45.11, 33.84], [4994, 120, 90], [4995, 28.23, 35.68], [4996, 16.69, 30.91],
              [4997, 26.79, 20.82], [4998, 49.03, 43.06], [5000, 13.36, 12.29], [5001, 70, 70], [5002, 120, 90],
              [5003, 120, 90], [5005, 17.46, 22.11], [5006, 112, 90], [5007, 120, 90], [5008, 126.38, 53.28],
              [5009, 18.59, 27.74], [5010, 8.39, 5.61], [5011, 21.98, 26], [5012, 35.55, 43.28], [5013, 46.69, 34.25],
              [5014, 61.9, 35.6], [5017, 13.52, 21.99], [5019, 70, 45.82], [5020, 32.11, 40.08], [5022, 137.19, 88.29],
              [5023, 70, 70], [5025, 120, 90], [5026, 120, 90], [5027, 24.1, 26.31], [5031, 10, 16],
              [5032, 26.02, 40.08], [5033, 40.97, 26.68], [5035, 47.55, 39.99], [5037, 91.49, 46.75], [5038, 18, 27],
              [5041, 120, 90], [5043, 50, 60], [5044, 70, 70], [5046, 59.27, 44.08], [5048, 17.82, 19.75],
              [5049, 120, 90], [5050, 20.33, 12.35], [5051, 12, 18], [5053, 77.54, 45.07], [5054, 45.4, 28.5],
              [5056, 120, 90], [5057, 120, 90], [5058, 48.62, 42.89], [5060, 120, 90], [5061, 120, 90],
              [5062, 67.65, 70], [5063, 20.35, 50], [5064, 20.75, 20.03], [5065, 100.18, 69.74], [5066, 120, 90],
              [5068, 164.36, 62.76], [5069, 149.63, 54.69], [5070, 13.6, 28.86], [5071, 34.13, 33.6], [5072, 120, 90],
              [5073, 50, 60], [5075, 21.04, 24.86], [5077, 40, 50], [5079, 30.65, 35.97], [5081, 120, 90],
              [5082, 9.69, 9.33], [5083, 5.36, 5.53], [5084, 50, 60], [5085, 41.13, 26.96], [5091, 40.5, 33.65],
              [5092, 10, 16], [5093, 50, 60], [5094, 36.74, 43], [5095, 13.3, 17.3], [5097, 120, 90],
              [5098, 47.81, 29.86], [5099, 58.83, 35.89], [5100, 120, 90], [5101, 5.93, 6.13], [5102, 35.03, 31.53],
              [5103, 89.21, 43], [5104, 120, 90], [5107, 70, 65], [5108, 25, 40], [5109, 55.7, 36.5], [5111, 120, 90],
              [5114, 4.87, 4], [5115, 12.26, 31.18], [5116, 26.44, 21.57], [5117, 40, 50], [5119, 120, 90],
              [5121, 36.95, 67.11], [5122, 21.51, 31.21], [5123, 11.8, 11.02], [5124, 56.09, 43.95],
              [5126, 26.81, 24.11], [5127, 18.25, 11.14], [5128, 70, 70], [5130, 50, 60], [5132, 120, 90],
              [5135, 68.8, 41.77], [5136, 10.18, 8.06], [5137, 120, 90], [5138, 15.14, 13.83], [5141, 24.58, 21.45],
              [5143, 70, 70], [5145, 120, 90], [5149, 120, 90], [5150, 52.83, 33.37], [5153, 179.52, 59.91],
              [5154, 70, 90], [5155, 70, 70], [5156, 40, 50], [5157, 50, 60], [5159, 52.86, 48.43], [5160, 120, 90],
              [5161, 17.42, 15.54], [5162, 65.6, 46.34], [5163, 120, 90], [5164, 120, 90], [5165, 3.38, 5.47],
              [5166, 33.73, 21.58], [5167, 120, 90], [5169, 56.5, 44.9], [5171, 249.75, 64.69], [5172, 70, 70],
              [5173, 46.38, 41.15], [5174, 143.07, 72.47], [5178, 120, 90], [5180, 86.39, 54.81], [5181, 120, 90],
              [5182, 16.01, 20.04], [5183, 30.55, 36.38], [5184, 25, 30.44], [5185, 22.64, 29.76], [5186, 12, 18],
              [5187, 12, 18], [5188, 12, 18], [5189, 32, 40], [5191, 50, 25], [5192, 15, 25], [5193, 15, 25],
              [5194, 15, 25], [5197, 15, 25], [5198, 15, 25], [5202, 15, 25], [5203, 15, 25], [5204, 40, 50],
              [5205, 15, 25], [5206, 15, 25], [5207, 15, 25], [5209, 15, 25], [5212, 15, 25], [5213, 15, 25],
              [5214, 15, 25], [5215, 15, 25], [5216, 15, 25], [5217, 70, 70], [5218, 50, 60], [5219, 20.7, 31.7],
              [5220, 12.6, 25.3], [5221, 14.8, 27.6], [5222, 23, 18.2], [5223, 10.5, 15.3], [5224, 16.8, 30.5],
              [5225, 21.5, 24.2], [5226, 8.5, 20.2], [5227, 55.9, 46.8], [5228, 18.7, 32.7], [5229, 7, 15.8],
              [5230, 15.5, 13.1], [5231, 15.2, 18.9], [5232, 26.7, 34.4], [5233, 22.9, 36.3], [5234, 10.9, 17.5],
              [5235, 43.7, 39.9], [5236, 15.6, 18.9], [5237, 27.3, 31.4], [5238, 23.1, 25.3], [5239, 23.3, 28.2],
              [5240, 17, 31.3], [5241, 26.1, 21.4], [5242, 25.2, 23.2], [5243, 28.2, 26.9], [5244, 20.5, 30],
              [5245, 21.3, 30], [5247, 80, 60], [5248, 80, 60], [5249, 19.35, 11.59], [5250, 20.93, 10.99],
              [5251, 10.39, 7.22], [5252, 30, 16.38], [5253, 11.8, 10.66], [5254, 25.42, 16.32], [5255, 23.04, 14.71],
              [5256, 24.56, 17.38], [5257, 15.4, 13.96], [5258, 23.85, 19.14], [5259, 10.2, 9.75], [5260, 14.55, 9.36],
              [5261, 24.59, 17.95], [5262, 13.46, 12.24], [5263, 19.45, 15.67], [5264, 70, 50.86], [5265, 7.91, 11.54],
              [5266, 24.83, 17.86], [5267, 21.83, 15.71], [5268, 15.77, 15], [5269, 14.5, 9.26], [5270, 13.36, 17.93],
              [5271, 70, 70], [5272, 49.88, 21.16], [5273, 27.17, 19.34], [5274, 21.56, 23.35], [5275, 21.89, 20.99],
              [5276, 33.57, 69.59], [5277, 33.53, 44.16], [5278, 17.61, 19.46], [5279, 22.19, 26.31],
              [5280, 54.9, 42.95], [5281, 23.97, 21.11], [5282, 18.86, 21.15], [5283, 14.72, 24.85],
              [5284, 19.82, 21.97], [5285, 12.98, 10.05], [5286, 21.47, 25.37], [5287, 12.95, 13.1],
              [5288, 15.79, 13.5], [5289, 14.72, 18.53], [5290, 23.09, 21.92], [5291, 13.74, 15.42],
              [5292, 27.71, 17.72], [5293, 31.42, 28.8], [5294, 27.26, 35.13], [5295, 17.19, 14.3],
              [5296, 37.77, 51.52], [5297, 36.44, 42.37], [5298, 13.26, 13.27], [5299, 18.16, 20.87],
              [5300, 19.04, 16.88], [5301, 42.73, 37.25], [5302, 9.07, 5.65], [5303, 36.15, 21.1], [5304, 19.35, 28.15],
              [5305, 28.21, 24.21], [5306, 30.08, 35.59], [5307, 28.82, 42.89], [5308, 30.68, 46.96],
              [5309, 22.98, 21.99], [5310, 18.38, 19.26], [5311, 14.95, 17.32], [5312, 24.78, 19.47],
              [5313, 14.05, 18.92], [5314, 22.31, 24.96], [5315, 19.95, 27.16], [5316, 34.5, 42.49],
              [5317, 47.68, 75.34], [5318, 30.3, 21.67], [5319, 13.84, 14.27], [5320, 53.44, 55.56],
              [5321, 21.43, 22.1], [5322, 21.86, 31.16], [5323, 13.54, 22.48], [5324, 28.56, 35.07],
              [5325, 16.07, 19.54], [5326, 34.56, 41.14], [5327, 16.58, 21.05], [5328, 21.03, 21.33],
              [5329, 17.44, 17.44], [5330, 28.89, 22.93], [5331, 20.27, 21.28], [5332, 24.04, 29.18],
              [5333, 13.04, 16.32], [5334, 14.81, 13.78], [5335, 19.89, 15.44], [5336, 16.38, 19.14],
              [5337, 17.09, 17.7], [5338, 33.77, 26.64], [5339, 21.48, 24.94], [5340, 31.28, 38.93],
              [5341, 21.6, 30.78], [5342, 67.33, 44.59], [5343, 16.6, 14.81], [5344, 47.23, 50.54],
              [5345, 17.36, 20.76], [5346, 12.53, 15.06], [5347, 20.45, 23.78], [5348, 18.99, 19.54],
              [5349, 23.6, 27.71], [5350, 17.87, 30.23], [5351, 25.6, 34.49], [5352, 12.65, 19.75], [5353, 20.64, 26.6],
              [5354, 15.47, 9.25], [5355, 24.3, 42.86], [5356, 15.64, 19.61], [5357, 30.99, 21.01],
              [5358, 18.44, 20.69], [5359, 17.32, 25.16], [5360, 14.69, 9.66], [5361, 25.44, 28.51],
              [5362, 22.78, 37.54], [5363, 17.15, 20.75], [5364, 27.13, 35.08], [5365, 14.15, 16.33],
              [5366, 31.71, 24.96], [5367, 18.39, 19.03], [5368, 25.49, 33.82], [5369, 17.87, 17.73],
              [5370, 26.37, 19.9], [5371, 34.48, 40.39], [5372, 23.31, 23.21], [5373, 39.81, 52.34],
              [5374, 38.4, 30.66], [5375, 20.13, 18.67], [5376, 39.93, 36.29], [5377, 17.78, 19.64],
              [5378, 44.16, 54.79], [5379, 17.59, 16], [5380, 19.5, 24.07], [5381, 24.54, 27.3], [5382, 27.26, 39.02],
              [5383, 24.98, 28.96], [5384, 32.06, 28.26], [5385, 35.75, 25.11], [5386, 12.39, 14.93],
              [5387, 16.52, 16.08], [5388, 28.27, 31.03], [5389, 21.28, 32.3], [5390, 27.81, 21.8],
              [5391, 15.92, 17.92], [5392, 18.92, 29.5], [5393, 21.42, 30.33], [5394, 25.56, 27.95],
              [5395, 15.36, 21.7], [5396, 24.37, 24.45], [5397, 37.72, 55.15], [5398, 22.54, 21.56],
              [5399, 30.96, 24.28], [5400, 13.97, 12.67], [5401, 27.87, 36.25], [5402, 25.63, 36.95],
              [5403, 24.28, 25.06], [5404, 24.46, 24.68], [5405, 17.96, 16.23], [5406, 26.71, 28.04],
              [5407, 20.69, 24.62], [5408, 18.11, 22.5], [5409, 31.73, 36.57], [5410, 58.51, 46.49],
              [5411, 27.68, 21.48], [5412, 23.04, 18.15], [5413, 23.32, 18.19], [5414, 9.91, 15.09],
              [5415, 51.57, 56.26], [5416, 12.77, 13.87], [5417, 23.61, 19.35], [5418, 28.79, 36.91],
              [5419, 27.19, 25.1], [5420, 16.27, 16.14], [5421, 18.76, 15.11], [5422, 25.14, 34.37],
              [5423, 35.81, 32.77], [5424, 17.07, 19.91], [5425, 16.63, 19.74], [5426, 22.35, 32.83],
              [5427, 30.13, 36.75], [5428, 18.88, 25.12], [5429, 14.33, 16.18], [5430, 35.21, 32.17],
              [5431, 21.98, 23.51], [5432, 22.49, 30.65], [5433, 22.03, 25.8], [5434, 15.65, 16.63],
              [5435, 28.65, 36.45], [5436, 22.2, 26.91], [5437, 28.46, 24.42], [5438, 26.15, 45.07],
              [5439, 23.1, 32.12], [5440, 42.61, 31.07], [5441, 31.6, 43.27], [5442, 27.28, 31.24],
              [5443, 27.08, 44.53], [5444, 21.92, 35.18], [5445, 16.8, 20.91], [5446, 28.06, 29.76],
              [5447, 20.25, 23.23], [5448, 18.61, 19.97], [5449, 26.78, 33.16], [5450, 28.76, 31.21],
              [5451, 36.55, 47.48], [5452, 22.51, 34.53], [5453, 28.94, 32.53], [5454, 12.32, 16.18],
              [5455, 28.32, 21.25], [5456, 21.35, 24.85], [5457, 16.87, 25.48], [5458, 18.67, 22.48],
              [5459, 25.03, 25.93], [5460, 15.43, 17.97], [5461, 18.92, 17.99], [5462, 22.52, 26.38],
              [5463, 14.28, 17.95], [5464, 18.6, 18.27], [5465, 23.82, 23.85], [5466, 18.5, 23.11],
              [5467, 21.73, 26.16], [5468, 48, 70], [5469, 28.95, 22.5], [5470, 18.2, 26.19], [5471, 21.88, 24.32],
              [5472, 24.34, 29.62], [5473, 18.21, 24.01], [5474, 15.15, 14.65], [5475, 19.39, 18.75],
              [5476, 15.52, 20.64], [5477, 11.66, 13.63], [5478, 18.69, 21.99], [5479, 20.66, 18.21],
              [5480, 38.45, 32.17], [5481, 15.98, 18.15], [5482, 17.06, 18.76], [5483, 25.35, 27.15],
              [5484, 22.09, 21.1], [5485, 22.02, 23.57], [5486, 22.14, 21.65], [5487, 17.97, 21.38],
              [5488, 24.02, 25.06], [5489, 34.19, 66.05], [5490, 28.94, 32.56], [5491, 15.88, 20.08],
              [5492, 22.58, 38.47], [5493, 27.68, 21.75], [5494, 25.82, 30.23], [5495, 33.94, 27.03], [5496, 70, 70],
              [5497, 18.35, 22.55], [5498, 27.02, 39.89], [5499, 33.57, 24.3], [5500, 22.47, 23.4],
              [5501, 27.13, 46.22], [5502, 29.4, 31.24], [5503, 25.48, 24.22], [5504, 29.82, 41.45],
              [5505, 19.44, 30.38], [5506, 19.55, 18.02], [5507, 8.92, 15.03], [5508, 25.07, 35.23],
              [5509, 25.6, 36.32], [5510, 23.88, 39.9], [5511, 27.52, 24.5], [5512, 11.13, 11.46], [5513, 20.91, 23.63],
              [5514, 17.98, 18.09], [5515, 38.99, 31.52], [5516, 24.35, 34.55], [5517, 22.32, 28.37],
              [5518, 19.91, 18.99], [5519, 31.61, 40.04], [5520, 22.33, 22.91], [5521, 33.45, 39.31],
              [5522, 20.71, 22.53], [5523, 26.18, 29.99], [5524, 21.48, 50.1], [5525, 22.24, 21.41],
              [5526, 32.51, 26.74], [5527, 30.84, 34.66], [5528, 20.96, 19.72], [5529, 59.13, 37.8],
              [5530, 19.55, 21.33], [5531, 24.12, 22.95], [5532, 25.42, 24.65], [5533, 14.52, 14.84],
              [5534, 17.4, 14.87], [5535, 15.5, 12.89], [5536, 2, 2], [5537, 12.2, 8.94], [5538, 37.26, 35.28],
              [5539, 14.86, 20], [5540, 23.95, 34.62], [5541, 26.12, 21.77], [5542, 12.8, 16.15], [5543, 12.26, 16.58],
              [5544, 22.77, 32.88], [5545, 16.25, 22.22], [5546, 34.03, 40.31], [5547, 26.1, 25.13],
              [5548, 38.2, 46.39], [5549, 16.23, 22.79], [5550, 16.66, 17.46], [5551, 47.85, 70], [5552, 28.07, 25.33],
              [5553, 31.7, 29.24], [5554, 26.98, 30.18], [5555, 32.21, 32.76], [5556, 17.16, 17.29],
              [5557, 15.34, 14.19], [5558, 14.56, 19.66], [5559, 30.04, 31.58], [5560, 74.52, 28.37],
              [5561, 38.69, 49.15], [5562, 40.29, 56.03], [5563, 33.52, 34.96], [5564, 70, 56.53], [5565, 19.45, 18.12],
              [5566, 24.67, 27.3], [5567, 28.59, 35.72], [5568, 26.89, 35.03], [5569, 51.02, 38.85],
              [5570, 37.26, 27.17], [5571, 28.9, 21.65], [5572, 20.43, 17.7], [5573, 42.96, 28.46], [5590, 70, 70],
              [5600, 70, 70], [5618, 60, 132], [5621, 59, 48], [5624, 79, 140], [5625, 46, 70], [5627, 45, 70],
              [5632, 50, 70], [5636, 50, 60], [5638, 40, 50], [5646, 120, 90], [5648, 58, 90], [5649, 50, 60],
              [5659, 5.35, 4.7], [5660, 7.67, 7.45], [5661, 70, 70], [5663, 120, 90], [5666, 120, 90], [5672, 70, 70],
              [5675, 40, 50], [5677, 120, 90], [5681, 70, 70], [5683, 120, 90], [5689, 120, 90], [5706, 120, 90],
              [5715, 70, 70], [5717, 120, 90], [5720, 70, 70], [5726, 120, 90], [5728, 120, 90], [5737, 120, 90],
              [5738, 120, 90], [5745, 70, 70], [5747, 120, 90], [5757, 40, 50], [5758, 70, 70], [5764, 50, 60],
              [5768, 70, 70], [5777, 120, 90], [5789, 40, 50], [5805, 120, 90], [5808, 70, 70], [5811, 120, 90],
              [5819, 120, 90], [5824, 70, 70], [5830, 70, 70], [5833, 120, 90], [5840, 120, 90], [5841, 120, 90],
              [5846, 120, 90], [5848, 120, 90], [5851, 120, 90], [5855, 50, 50], [5856, 40, 50], [5861, 120, 90],
              [5869, 120, 90], [5876, 120, 90], [5877, 120, 90], [5880, 50, 60], [5881, 70, 70], [5882, 70, 70],
              [5884, 120, 90], [5889, 70, 70], [5898, 120, 90], [5903, 70, 70], [5911, 120, 90], [5917, 120, 90],
              [5918, 120, 90], [5919, 70, 70], [5931, 70, 70], [5933, 40, 50], [5936, 70, 70], [5939, 120, 90],
              [5941, 120, 90], [5942, 120, 90], [5943, 120, 90], [5944, 40, 50], [5945, 40, 50], [5946, 40, 50],
              [5947, 120, 90], [5948, 120, 90], [5949, 120, 90], [5950, 120, 90], [5951, 120, 90], [5953, 120, 90],
              [5954, 120, 90], [5955, 120, 90], [5956, 120, 90], [5957, 120, 90], [5958, 40, 50], [5959, 40, 50],
              [5961, 40, 50], [5962, 50, 60], [5964, 120, 90], [5965, 28, 90], [5966, 68, 80], [5967, 41, 60],
              [5968, 120, 117], [5969, 56, 70], [5970, 70, 70], [5985, 15, 25], [5986, 50, 60], [5987, 15, 25],
              [5988, 21, 33], [5989, 50, 60], [5990, 50, 60], [5991, 50, 60], [5992, 50, 60], [5993, 50, 60],
              [5994, 60.08, 60], [5995, 70, 70], [5996, 70, 70], [5997, 70, 70], [5998, 120, 90], [5999, 50, 60],
              [6049, 70, 70], [6050, 70, 70], [6051, 70, 70], [6052, 120, 90], [6053, 120, 90], [6054, 120, 90],
              [6055, 52.5, 52.5], [6066, 37.5, 45], [6067, 15, 25], [6068, 120, 90], [6069, 70, 70], [6070, 70, 70],
              [6071, 49, 49], [6072, 40, 50], [6073, 49, 49], [6074, 49, 49], [6075, 70, 70], [6076, 50, 60],
              [6077, 49, 49], [6078, 50, 60], [6079, 49, 49], [6080, 70, 70], [6081, 38, 45], [6082, 49, 49],
              [6083, 49, 49], [6084, 84, 63], [6085, 84, 63], [6086, 35, 42], [6087, 49, 49], [6088, 49, 49],
              [6089, 49, 49], [6090, 84, 63], [6091, 49, 49], [6092, 49, 49], [6093, 49, 49], [6094, 49, 49],
              [6095, 35, 42], [6096, 49, 49], [6097, 49, 49], [6098, 49, 49], [6099, 84, 63], [6100, 49, 49],
              [6101, 49, 49], [6102, 35, 42], [6103, 49, 49], [6104, 84, 63], [6105, 84, 63], [6106, 49, 49],
              [6107, 49, 49], [6108, 49, 49], [6109, 35, 42], [6110, 49, 49], [6111, 24, 36], [6112, 49, 49],
              [6113, 42, 42], [6114, 35, 42], [6115, 35, 42], [6116, 49, 49], [6117, 49, 49], [6118, 49, 49],
              [6119, 49, 49], [6120, 28, 35], [6121, 49, 49], [6122, 49, 49], [6123, 49, 49], [6124, 49, 49],
              [6125, 49, 49], [6126, 49, 49], [6127, 49, 49], [6128, 49, 49], [6129, 28, 35], [6130, 49, 49],
              [6131, 49, 49], [6132, 49, 49], [6133, 49, 49], [6134, 49, 49], [6135, 49, 49], [6136, 70, 70],
              [6137, 28, 35], [6138, 35, 42], [6139, 49, 49], [6140, 28, 35], [6141, 49, 49], [6142, 35, 42],
              [6143, 49, 49], [6144, 42, 42], [6145, 49, 49], [6146, 24, 36], [6147, 40, 50], [6148, 32, 40],
              [6149, 49, 49], [6150, 28, 35], [6151, 49, 49], [6152, 28, 35], [6153, 28, 35], [6154, 49, 49],
              [6155, 30, 38], [6156, 35, 42], [6157, 49, 49], [6158, 35, 42], [6159, 49, 49], [6160, 35, 42],
              [6161, 28, 35], [6162, 35, 42], [6163, 50, 60], [6164, 49, 49], [6165, 35, 42], [6166, 70, 70],
              [6167, 70, 70], [6168, 24, 36], [6169, 24, 36], [6170, 24, 36], [6227, 120, 90], [6228, 15, 25],
              [6229, 15, 25], [6230, 50, 60], [6231, 50, 60], [6232, 50, 60], [6233, 70, 70], [6234, 50, 60],
              [6235, 50, 60], [6236, 50, 60], [6238, 70, 70], [6239, 50, 60], [6240, 50, 60], [6241, 50, 60],
              [6242, 50, 60], [6243, 70, 70], [6244, 70, 70], [6245, 50, 60], [6246, 70, 70], [6247, 50, 60],
              [6248, 30, 45], [6252, 50, 60], [6253, 120, 90], [6255, 70, 70], [6256, 50, 60], [6258, 50, 60],
              [6259, 120, 90], [6260, 120, 90], [6261, 70, 70], [6262, 70, 70], [6263, 120, 90], [6264, 70, 70],
              [6265, 70, 70], [6266, 50, 60], [6267, 50, 60], [6268, 70, 70], [6269, 50, 60], [6270, 50, 60],
              [6271, 70, 70], [6272, 40, 50], [6274, 70, 70], [6275, 70, 70], [6276, 50, 60], [6277, 120, 90],
              [6278, 70, 70], [6279, 70, 70], [6280, 70, 70], [6281, 70, 70], [6282, 50, 60], [6283, 70, 70],
              [6284, 50, 60], [6286, 70, 70], [6287, 50, 60], [6288, 70, 70], [6289, 50, 60], [6290, 120, 90],
              [6292, 70, 70], [6293, 70, 70], [6294, 120, 90], [6295, 120, 90], [6296, 70, 70], [6297, 120, 90],
              [6299, 70, 70], [6300, 70, 70], [6301, 70, 70], [6302, 70, 70], [6303, 70, 70], [6305, 120, 90],
              [6306, 70, 70], [6307, 120, 90], [6308, 120, 90], [6309, 70, 70], [6310, 50, 60], [6312, 120, 90],
              [6313, 70, 70], [6314, 120, 90], [6315, 70, 70], [6316, 70, 70], [6317, 70, 70], [6319, 50, 60],
              [6320, 70, 70], [6321, 70, 70], [6323, 50, 60], [6324, 50, 60], [6325, 120, 90], [6326, 70, 70],
              [6327, 50, 60], [6328, 120, 90], [6330, 120, 90], [6334, 17.01, 16], [6335, 22.88, 20.17],
              [6336, 34, 36.4], [6337, 22.28, 16.2], [6338, 35, 27.18], [6339, 20.53, 16.19], [6340, 34, 36.69],
              [6341, 28.74, 25], [6342, 22.3, 20], [6343, 28.6, 33.48], [6344, 22.3, 21.5], [6345, 31.99, 26.94],
              [6346, 30, 21.24], [6347, 22.82, 20], [6348, 40.24, 30], [6349, 20.84, 24.13], [6350, 22.32, 30],
              [6351, 29.17, 16.2], [6353, 40, 50], [6354, 40, 50], [6355, 30, 45], [6356, 50, 60], [6357, 70, 70],
              [6358, 40, 50], [6359, 28.08, 27.32], [6360, 120, 109.36], [6361, 120, 90], [6362, 115.35, 155.44],
              [6363, 63.74, 113.55], [6364, 120, 108.36], [6365, 120, 90], [6366, 152, 95.28], [6367, 70, 70],
              [6368, 120, 119.04], [6369, 68.6, 48.47], [6370, 120, 90], [6371, 120, 130.57], [6372, 120, 90],
              [6373, 120, 90], [6374, 120, 64.08], [6375, 120, 90], [6376, 70, 70], [6377, 120, 90], [6378, 70, 70],
              [6379, 120, 78.19], [6380, 70, 91.63], [6381, 70, 70], [6382, 120, 108.36], [6383, 70, 70],
              [6384, 120, 108.36], [6385, 120, 65.11], [6386, 120, 90], [6387, 120, 90], [6388, 120, 90],
              [6389, 120, 90], [6390, 120, 90], [6391, 78.33, 99.36], [6392, 120, 90], [6393, 120, 90], [6394, 120, 90],
              [6395, 120, 90], [6396, 120, 117.19], [6397, 120, 90], [6398, 120, 90], [6399, 120, 90],
              [6400, 120, 109.36], [6401, 70, 70], [6402, 120, 130.57], [6403, 120, 90], [6404, 120, 90],
              [6405, 120, 90], [6406, 120, 109.36], [6407, 120, 109.36], [6408, 120, 90], [6409, 120, 90],
              [6410, 120, 90], [6411, 120, 90], [6412, 120, 90], [6413, 120, 90], [6414, 120, 109.36],
              [6415, 120, 119.04], [6416, 120, 90], [6417, 120, 90], [6418, 120, 90], [6419, 120, 90], [6420, 120, 90],
              [6421, 120, 117.19], [6422, 120, 109.36], [6423, 42.81, 43.17], [6424, 115.49, 81.33], [6425, 70, 98.36],
              [6426, 120, 117.19], [6427, 120, 90], [6428, 120, 90], [6429, 120, 90], [6430, 70, 86.89],
              [6431, 120, 90], [6432, 120, 90], [6433, 63.74, 113.55], [6434, 120, 90], [6435, 78.33, 99.36],
              [6436, 120, 90], [6437, 120, 90], [6438, 120, 90], [6439, 120, 125.74], [6440, 120, 90],
              [6441, 120, 109.36], [6442, 70, 70], [6443, 120, 90], [6444, 120, 90], [6445, 120, 90], [6446, 120, 90],
              [6447, 48.53, 70], [6448, 120, 90], [6449, 120, 90], [6450, 120, 90], [6451, 120, 90], [6452, 120, 90],
              [6453, 120, 90], [6454, 120, 90], [6455, 120, 90], [6456, 120, 90], [6457, 56.58, 70], [6458, 40, 55.85],
              [6459, 120, 125.74], [6460, 163.78, 95.28], [6461, 120, 90], [6462, 152, 95.28], [6463, 120, 90],
              [6464, 120, 90], [6465, 120, 90], [6466, 120, 90], [6467, 120, 90], [6468, 120, 90], [6469, 120, 101.08],
              [6470, 120, 90], [6471, 120, 109.36], [6472, 120, 108.36], [6473, 120, 90], [6474, 120, 90],
              [6475, 120, 90], [6476, 120, 108.36], [6477, 120, 90], [6478, 120, 90], [6479, 120, 90], [6480, 120, 90],
              [6481, 120, 90], [6482, 152, 95.28], [6483, 120, 109.36], [6484, 70, 56.48], [6485, 120, 90],
              [6486, 120, 90], [6487, 120, 90], [6488, 120, 90], [6489, 120, 90], [6490, 120, 108.36], [6491, 120, 90],
              [6492, 60.88, 72.65], [6493, 120, 90], [6494, 60.88, 72.65], [6495, 120, 125.74], [6496, 120, 109.36],
              [6497, 120, 90], [6498, 120, 125.74], [6499, 120, 90], [6500, 80.71, 115.49], [6501, 120, 90],
              [6502, 120, 78.19], [6503, 120, 109.36], [6504, 120, 130.57], [6505, 120, 91.63], [6506, 120, 90],
              [6507, 120, 90], [6508, 120, 90], [6509, 120, 119.04], [6510, 120, 90], [6511, 120, 90],
              [6512, 120, 109.36], [6513, 31.53, 53.27], [6514, 120, 90], [6515, 120, 90], [6516, 73.07, 58.95],
              [6517, 68.95, 86.89], [6518, 120, 117.19], [6519, 120, 90], [6520, 120, 90], [6521, 56.58, 56.58],
              [6522, 120, 90], [6523, 120, 90], [6524, 120, 90], [6525, 120, 90], [6526, 120, 90], [6527, 120, 125.74],
              [6528, 120, 125.74], [6529, 120, 90], [6530, 120, 109.36], [6531, 120, 90], [6532, 120, 125.74],
              [6533, 120, 91.63], [6534, 120, 119.04], [6535, 120, 90], [6536, 70.23, 106.94], [6537, 120, 90],
              [6538, 120, 90], [6539, 120, 90], [6540, 120, 90], [6541, 120, 90], [6542, 120, 108.36], [6543, 120, 90],
              [6544, 120, 90], [6546, 120, 90], [6547, 120, 90], [6548, 120, 90], [6549, 120, 90], [6550, 120, 90],
              [6551, 120, 90], [6552, 120, 108.36], [6553, 120, 90], [6554, 120, 90], [6555, 120, 90], [6556, 120, 90],
              [6557, 120, 90], [6558, 120, 90], [6559, 120, 90], [6560, 120, 90], [6561, 120, 90], [6562, 120, 90],
              [6563, 120, 90], [6564, 120, 90], [6565, 120, 90], [6566, 120, 78.64], [6567, 120, 90],
              [6568, 120, 109.36], [6569, 120, 90], [6570, 120, 90], [6572, 120, 90], [6573, 120, 90], [6574, 120, 90],
              [6575, 120, 119.04], [6576, 120, 90], [6577, 120, 90], [6578, 120, 109.36], [6579, 120, 90],
              [6580, 120, 90], [6581, 120, 90], [6582, 120, 90], [6583, 120, 90], [6584, 120, 90], [6585, 120, 109.36],
              [6586, 120, 130.57], [6587, 120, 90], [6588, 120, 109.36], [6589, 120, 90], [6590, 120, 90],
              [6591, 120, 90], [6592, 120, 90], [6593, 120, 90], [6594, 120, 90], [6595, 120, 90], [6596, 120, 90],
              [6597, 120, 90], [6598, 120, 90], [6599, 120, 90], [6600, 120, 90], [6601, 120, 90], [6602, 120, 125.74],
              [6603, 70, 70], [6604, 120, 119.04], [6605, 120, 108.36], [6606, 120, 90], [6607, 120, 125.74],
              [6608, 120, 109.36], [6609, 120, 90], [6610, 120, 90], [6611, 70, 91.63], [6612, 120, 119.04],
              [6613, 120, 90], [6614, 50, 101.08], [6615, 120, 130.57], [6616, 120, 90], [6617, 39.9, 34.9],
              [6618, 120, 90], [6619, 120, 90], [6620, 120, 90], [6621, 120, 90], [6622, 120, 90], [6623, 152, 95.28],
              [6624, 120, 108.36], [6625, 120, 90], [6626, 120, 90], [6627, 120, 90], [6628, 120, 90], [6629, 70, 70],
              [6630, 70, 70], [6631, 50, 60], [6632, 28, 35], [6633, 50, 60], [6634, 49, 49], [6635, 70, 70],
              [6636, 70, 70], [6637, 84, 63], [6638, 70, 70], [6639, 84, 63], [6640, 50, 60], [6641, 70, 70],
              [6642, 40, 50], [6643, 30, 40], [6648, 120, 90], [6649, 84, 63], [6650, 84, 63], [6651, 84, 63],
              [6652, 84, 63], [6653, 70, 70], [6654, 49, 49], [6655, 49, 49], [6656, 49, 49], [6657, 70, 70],
              [6660, 49, 49], [6661, 49, 49], [6662, 49, 49], [6663, 49, 49], [6664, 49, 49], [6665, 49, 49],
              [6666, 49, 49], [6667, 49, 49], [6668, 49, 49], [6669, 49, 49], [6670, 49, 49], [6671, 49, 49],
              [6672, 49, 49], [6673, 49, 49], [6674, 49, 49], [6675, 49, 49], [6676, 49, 49], [6677, 49, 49],
              [6678, 49, 49], [6679, 70, 70], [6680, 49, 49], [6682, 49, 49], [6683, 70, 70], [6684, 49, 49],
              [6685, 35, 42], [6686, 35, 42], [6687, 35, 42], [6688, 35, 42], [6689, 35, 42], [6690, 35, 42],
              [6691, 10.46, 2.78], [6692, 12.66, 2.21], [6697, 40, 50], [6698, 70, 70], [6699, 70, 70], [6700, 120, 90],
              [6701, 70, 70], [6702, 70, 70], [6703, 30, 40], [6704, 70, 70], [6705, 70, 70], [6706, 70, 70],
              [6707, 120, 90], [6708, 70, 70], [6709, 30, 40], [6710, 50, 60], [6711, 70, 70], [6712, 50, 60],
              [6713, 70, 70], [6714, 50, 60], [6715, 120, 90], [6716, 70, 70], [6717, 70, 70], [6718, 70, 70],
              [6719, 70, 70], [6720, 70, 70], [6721, 50, 60], [6722, 30, 40], [6723, 70, 70], [6724, 70, 70],
              [6725, 70, 70], [6726, 70, 70], [6727, 70, 70], [6728, 70, 70], [6729, 70, 70], [6730, 120, 90],
              [6731, 70, 70], [6732, 70, 70], [6733, 70, 70], [6734, 70, 70], [6735, 70, 70], [6736, 50, 60],
              [6737, 70, 70], [6738, 70, 70], [6739, 50, 60], [6740, 18, 27], [6741, 18, 27], [6742, 18, 27],
              [6743, 18, 27], [6746, 50, 60], [6748, 70, 70], [6749, 70, 70], [6750, 70, 70], [6752, 35, 42],
              [6753, 120, 90], [6754, 70, 70], [6755, 70, 70], [6756, 70, 70], [6757, 70, 70], [6758, 70, 70],
              [6759, 50, 60], [6760, 70, 70], [6761, 70, 70], [6762, 70, 70], [6763, 35, 42], [6764, 70, 70],
              [6766, 120, 90], [6767, 49, 49], [6768, 49, 49], [6769, 120, 90], [6770, 70, 70], [6771, 70, 70],
              [6772, 50, 60], [6773, 120, 90], [6777, 70, 70], [6778, 70, 70], [6779, 50, 60], [6780, 70, 70],
              [6781, 70, 70], [6782, 120, 90], [6783, 70, 70], [6784, 70, 70], [6785, 70, 70], [6786, 70, 70],
              [6787, 70, 70], [6789, 70, 70], [6790, 70, 70], [6791, 30, 40], [6792, 70, 70], [6793, 30, 40],
              [6794, 70, 70], [6795, 70, 70], [6796, 70, 70], [6797, 70, 70], [6798, 30, 40], [6799, 30, 40],
              [6800, 70, 70], [6801, 70, 70], [6802, 70, 70], [6803, 70, 70], [6804, 70, 70], [6805, 70, 70],
              [6806, 70, 70], [6807, 70, 70], [6808, 120, 90], [6809, 70, 70], [6810, 70, 70], [6811, 30, 40],
              [6812, 30, 40], [6813, 70, 70], [6814, 30, 40], [6815, 70, 70], [6816, 120, 90], [6817, 50, 60],
              [6818, 21.25, 24.78], [6819, 40, 48], [6820, 40, 48], [6821, 56, 56], [6822, 56, 56], [6823, 56, 56],
              [6824, 120, 90], [6825, 120, 90], [6826, 50, 60], [6827, 50, 60], [6828, 50, 60], [6829, 70, 70],
              [6830, 70, 70], [6831, 120, 90], [6832, 70, 70], [6833, 30, 40], [6834, 30, 40], [6835, 30, 40],
              [6836, 70, 70], [6837, 120, 90], [6838, 30, 40], [6841, 49, 49], [6842, 70, 70], [6843, 70, 70],
              [6844, 50, 60], [6845, 120, 90], [6846, 120, 90], [6847, 70, 70], [6848, 50, 60], [6849, 70, 70],
              [6850, 50, 60], [6851, 50, 60], [6852, 50, 60], [6853, 50, 60], [6854, 120, 90], [6855, 50, 60],
              [6856, 70, 70], [6857, 70, 70], [6858, 50, 60], [6859, 30, 40], [6860, 70, 70], [6861, 50, 60],
              [6862, 50, 60], [6864, 40, 50], [6865, 30, 45], [6866, 19.37, 24.9]]],
            [2001, [[2, 51, 44], [7, 33, 33], [25, 14, 10], [42, 21, 22], [48, 95, 70], [49, 38, 26], [51, 32, 33],
                    [62, 22, 32], [65, 27, 23], [78, 21, 21], [82, 12, 21], [83, 43, 50], [87, 39, 33], [99, 33, 33],
                    [101, 70, 57], [119, 45, 33], [122, 37, 22], [125, 35, 37], [135, 21, 21], [138, 35, 33],
                    [163, 31, 28], [166, 43, 43], [169, 28, 22], [186, 17, 22], [190, 33, 32], [194, 27, 27],
                    [200, 45, 34], [204, 12, 21], [211, 22, 54], [215, 31, 33], [216, 26, 22], [218, 69, 28],
                    [220, 20, 21], [226, 18, 20], [230, 54, 50], [231, 60, 53], [233, 18, 19], [234, 12, 18],
                    [239, 22, 22], [240, 21, 19], [242, 37, 21], [243, 32, 33], [246, 64, 38], [248, 22, 21],
                    [270, 32, 32], [272, 62, 19], [282, 48, 24], [285, 21, 22], [286, 22, 13], [299, 21, 22],
                    [305, 22, 22], [306, 33, 33], [308, 13, 53], [310, 23, 22], [312, 22, 22], [314, 20, 30],
                    [317, 32, 33], [320, 26, 30], [324, 54, 45], [327, 51, 46], [329, 44, 36], [330, 32, 33],
                    [332, 33, 33], [334, 39, 34], [337, 27, 19], [339, 25, 22], [344, 35, 21], [346, 47, 40],
                    [355, 55, 37], [361, 33, 33], [365, 50, 36], [378, 22, 27], [379, 16, 14], [389, 18, 26],
                    [392, 21, 22], [399, 85, 41], [402, 38, 32], [403, 33, 34], [418, 24, 22], [424, 22, 22],
                    [425, 19, 30], [428, 31, 22], [430, 22, 29], [432, 40, 34], [436, 29, 24], [455, 30, 27],
                    [471, 21, 22], [479, 39, 38], [480, 70, 29], [487, 36, 33], [493, 32, 33], [494, 17, 19],
                    [497, 11, 16], [503, 72, 24], [504, 16, 14], [505, 31, 34], [519, 20, 30], [525, 20, 34],
                    [536, 21, 21], [541, 87, 45], [545, 23, 28], [568, 22, 22], [569, 59, 33], [570, 28, 22],
                    [573, 33, 34], [577, 32, 26], [579, 56, 50], [585, 70, 62], [590, 44, 49], [593, 49, 45],
                    [595, 33, 33], [597, 26, 10], [599, 17, 25], [604, 60, 36], [608, 32, 22], [612, 53, 50],
                    [618, 29, 23], [625, 26, 19], [627, 38, 35], [628, 33, 33], [631, 21, 22], [654, 15, 12],
                    [660, 35, 36], [662, 82, 55], [663, 60, 37], [669, 38, 26], [678, 21, 29], [686, 17, 27],
                    [691, 25, 22], [694, 45, 37], [695, 85, 63], [700, 65, 47], [703, 12, 19], [704, 29, 34],
                    [709, 55, 38], [716, 70, 64], [717, 42, 33], [719, 34, 31], [720, 25, 22], [724, 32, 33],
                    [727, 58, 57], [734, 22, 32], [737, 14, 12], [750, 22, 22], [751, 35, 19], [754, 32, 33],
                    [766, 79, 34], [769, 41, 51], [773, 32, 34], [781, 30, 24], [783, 22, 28], [785, 66, 66],
                    [790, 51, 35], [801, 21, 22], [803, 39, 37], [805, 44, 31], [811, 30, 26], [815, 16, 16],
                    [820, 45, 52], [821, 21, 22], [822, 19, 23], [826, 21, 22], [827, 11, 15], [835, 32, 33],
                    [843, 33, 33], [844, 32, 26], [845, 70, 34], [848, 27, 22], [865, 57, 36], [871, 47, 26],
                    [878, 7, 6], [882, 50, 39], [890, 21, 22], [894, 30, 12], [909, 79, 46], [913, 21, 18],
                    [915, 66, 43], [922, 59, 41], [926, 76, 24], [938, 12, 14], [940, 12, 15], [941, 44, 42],
                    [944, 26, 22], [949, 78, 38], [950, 17, 22], [964, 13, 17], [969, 47, 44], [971, 23, 19],
                    [972, 43, 28], [978, 57, 43], [979, 22, 22], [985, 92, 46], [990, 26, 22], [993, 70, 45],
                    [998, 40, 23], [1003, 8, 6], [1006, 13, 20], [1008, 24, 26], [1016, 11, 16], [1030, 9, 15],
                    [1033, 21, 22], [1042, 120, 55], [1048, 46, 45], [1051, 29, 22], [1056, 23, 46], [1059, 51, 55],
                    [1071, 109, 33], [1073, 58, 38], [1082, 61, 52], [1084, 91, 39], [1094, 21, 22], [1095, 22, 22],
                    [1097, 37, 20], [1100, 24, 25], [1102, 16, 18], [1106, 108, 38], [1109, 30, 33], [1111, 43, 58],
                    [1124, 71, 42], [1131, 35, 33], [1132, 12, 15], [1136, 51, 57], [1140, 33, 28], [1141, 33, 33],
                    [1142, 29, 29], [1144, 35, 25], [1145, 32, 25], [1150, 40, 30], [1155, 33, 33], [1156, 30, 20],
                    [1157, 41, 28], [1159, 57, 49], [1167, 21, 21], [1169, 22, 22], [1174, 32, 48], [1175, 23, 22],
                    [1177, 43, 34], [1186, 15, 22], [1194, 120, 52], [1200, 21, 22], [1203, 11, 19], [1205, 22, 22],
                    [1213, 23, 23], [1217, 33, 34], [1219, 22, 22], [1221, 23, 22], [1224, 33, 33], [1226, 24, 16],
                    [1228, 20, 21], [1234, 12, 16], [1235, 28, 25], [1238, 14, 29], [1247, 65, 38], [1254, 60, 31],
                    [1262, 33, 33], [1268, 51, 36], [1275, 25, 15], [1281, 17, 24], [1295, 50, 60], [1302, 60, 73],
                    [1303, 95, 46], [1305, 19, 22], [1319, 59, 28], [1320, 48, 46], [1323, 25, 22], [1334, 21, 21],
                    [1358, 60, 32], [1359, 32, 33], [1361, 33, 33], [1363, 35, 34], [1367, 43, 49], [1370, 15, 25],
                    [1375, 21, 22], [1376, 30, 27], [1396, 11, 20], [1420, 59, 54], [1445, 75, 19], [1454, 26, 33],
                    [1456, 33, 33], [1465, 18, 21], [1466, 40, 27], [1471, 34, 33], [1473, 17, 25], [1475, 35, 33],
                    [1476, 33, 34], [1477, 22, 22], [1481, 50, 33], [1482, 13, 17], [1484, 34, 34], [1486, 14, 14],
                    [1490, 24, 22], [1491, 12, 9], [1493, 30, 22], [1507, 40, 27], [1508, 32, 33], [1510, 17, 22],
                    [1511, 32, 33], [1515, 25, 20], [1522, 15, 22], [1525, 53, 51], [1527, 31, 33], [1530, 63, 59],
                    [1536, 19, 20], [1537, 34, 31], [1548, 31, 34], [1553, 32, 33], [1555, 60, 50], [1556, 33, 33],
                    [1557, 37, 34], [1561, 21, 22], [1562, 32, 33], [1568, 34, 33], [1575, 103, 69], [1577, 30, 23],
                    [1580, 50, 41], [1582, 30, 30], [1587, 17, 21], [1589, 49, 22], [1593, 13, 14], [1598, 16, 9],
                    [1610, 33, 34], [1628, 40, 24], [1635, 19, 18], [1638, 34, 54], [1644, 38, 33], [1645, 50, 33],
                    [1659, 28, 25], [1660, 32, 34], [1662, 15, 12], [1663, 33, 34], [1664, 18, 16], [1672, 21, 22],
                    [1673, 72, 48], [1680, 31, 33], [1685, 50, 45], [1704, 19, 23], [1717, 65, 32], [1724, 22, 22],
                    [1730, 17, 13], [1744, 33, 33], [1748, 32, 33], [1756, 33, 33], [1760, 13, 17], [1763, 26, 26],
                    [1769, 63, 54], [1771, 21, 22], [1772, 11, 16], [1774, 31, 33], [1776, 32, 20], [1780, 20, 22],
                    [1781, 22, 21], [1786, 20, 27], [1790, 21, 21], [1792, 34, 34], [1794, 38, 41], [1795, 14, 10],
                    [1797, 70, 50], [1798, 45, 60], [1804, 21, 22], [1812, 15, 19], [1816, 114, 27], [1818, 22, 22],
                    [1824, 43, 50], [1825, 22, 32], [1829, 20, 30], [1841, 53, 53], [1845, 33, 33], [1848, 33, 33],
                    [1853, 71, 29], [1864, 81, 75], [1866, 70, 39], [1869, 40, 47], [1876, 32, 33], [1879, 26, 22],
                    [1882, 19, 22], [1891, 33, 50], [1894, 40, 16], [1901, 21, 22], [1903, 108, 40], [1915, 52, 42],
                    [1916, 21, 19], [1917, 32, 33], [1921, 24, 22], [1925, 33, 33], [1930, 11, 9], [1933, 12, 16],
                    [1945, 31, 33], [1948, 27, 36], [1950, 22, 40], [1952, 120, 79], [1962, 14, 18], [1965, 68, 53],
                    [1995, 33, 33], [2000, 34, 33], [2001, 40, 30], [2006, 26, 24], [2011, 12, 18], [2017, 49, 50],
                    [2021, 33, 33], [2023, 12, 12], [2025, 33, 34], [2026, 53, 36], [2028, 51, 27], [2029, 31, 33],
                    [2032, 17, 20], [2035, 70, 39], [2042, 21, 22], [2048, 14, 32], [2056, 42, 49], [2057, 117, 48],
                    [2064, 60, 39], [2081, 21, 22], [2084, 65, 35], [2098, 16, 19], [2099, 27, 22], [2101, 10, 14],
                    [2104, 35, 33], [2121, 19, 18], [2127, 20, 13], [2128, 33, 33], [2131, 31, 42], [2138, 30, 29],
                    [2142, 10, 11], [2144, 24, 76], [2162, 21, 43], [2163, 42, 20], [2170, 29, 22], [2171, 32, 30],
                    [2174, 30, 23], [2178, 13, 21], [2180, 33, 34], [2181, 34, 33], [2182, 32, 34], [2190, 30, 25],
                    [2198, 26, 19], [2201, 33, 33], [2208, 55, 39], [2213, 50, 41], [2216, 26, 34], [2220, 21, 22],
                    [2224, 32, 36], [2227, 20, 21], [2232, 33, 33], [2236, 20, 22], [2238, 33, 33], [2239, 24, 22],
                    [2244, 27, 29], [2250, 50, 34], [2255, 32, 32], [2258, 33, 34], [2277, 35, 30], [2280, 9, 7],
                    [2282, 22, 65], [2293, 33, 33], [2297, 111, 40], [2300, 51, 60], [2303, 21, 22], [2311, 42, 41],
                    [2312, 21, 22], [2316, 63, 39], [2332, 16, 17], [2335, 33, 33], [2343, 29, 19], [2352, 49, 41],
                    [2356, 120, 57], [2366, 17, 18], [2367, 36, 33], [2371, 64, 36], [2383, 37, 22], [2384, 30, 43],
                    [2404, 32, 33], [2405, 31, 35], [2428, 38, 22], [2429, 12, 12], [2433, 63, 25], [2435, 20, 17],
                    [2443, 65, 39], [2447, 20, 21], [2458, 17, 15], [2459, 14, 19], [2467, 12, 17], [2472, 36, 24],
                    [2483, 73, 52], [2485, 14, 14], [2488, 27, 28], [2493, 26, 22], [2494, 31, 33], [2497, 21, 22],
                    [2500, 31, 21], [2501, 69, 30], [2505, 50, 35], [2509, 16, 19], [2514, 36, 33], [2516, 33, 33],
                    [2518, 32, 33], [2524, 11, 12], [2527, 27, 21], [2533, 11, 19], [2539, 62, 29], [2540, 23, 25],
                    [2543, 24, 24], [2547, 17, 16], [2551, 43, 33], [2554, 12, 12], [2555, 40, 25], [2562, 38, 34],
                    [2564, 20, 22], [2574, 31, 33], [2576, 63, 32], [2585, 62, 51], [2587, 32, 33], [2593, 30, 33],
                    [2595, 45, 42], [2603, 98, 45], [2604, 33, 33], [2606, 22, 16], [2607, 11, 10], [2612, 31, 32],
                    [2615, 37, 33], [2617, 50, 27], [2619, 12, 13], [2622, 31, 22], [2627, 70, 40], [2628, 22, 22],
                    [2632, 32, 20], [2633, 32, 33], [2635, 13, 22], [2644, 29, 22], [2647, 36, 31], [2650, 25, 22],
                    [2656, 22, 21], [2658, 32, 33], [2667, 32, 34], [2668, 32, 33], [2669, 58, 51], [2670, 50, 34],
                    [2671, 52, 60], [2684, 36, 19], [2687, 28, 19], [2692, 65, 29], [2695, 12, 13], [2720, 38, 42],
                    [2723, 45, 70], [2743, 33, 33], [2747, 32, 32], [2748, 33, 33], [2758, 37, 33], [2762, 97, 52],
                    [2775, 65, 39], [2785, 14, 16], [2787, 37, 28], [2788, 33, 33], [2791, 44, 28], [2797, 15, 16],
                    [2798, 12, 21], [2813, 31, 33], [2822, 30, 25], [2823, 22, 22], [2827, 14, 20], [2832, 16, 16],
                    [2833, 57, 37], [2835, 38, 35], [2836, 35, 18], [2838, 50, 41], [2846, 28, 29], [2851, 22, 18],
                    [2854, 38, 40], [2856, 38, 33], [2867, 22, 22], [2872, 19, 22], [2876, 32, 34], [2879, 25, 26],
                    [2880, 39, 31], [2883, 36, 34], [2884, 26, 45], [2897, 120, 63], [2901, 80, 66], [2904, 53, 36],
                    [2910, 21, 22], [2914, 50, 34], [2918, 58, 41], [2922, 17, 17], [2923, 33, 33], [2929, 34, 33],
                    [2932, 36, 36], [2934, 24, 22], [2935, 80, 36], [2936, 25, 22], [2946, 34, 22], [2950, 33, 33],
                    [2969, 23, 19], [2973, 41, 54], [2974, 48, 24], [2978, 32, 33], [2979, 28, 17], [2991, 45, 48],
                    [2995, 22, 22], [3009, 42, 47], [3011, 33, 33], [3016, 34, 34], [3019, 48, 24], [3027, 20, 22],
                    [3033, 95, 54], [3035, 21, 21], [3041, 36, 27], [3046, 32, 14], [3048, 49, 25], [3050, 36, 23],
                    [3053, 80, 70], [3061, 33, 34], [3066, 63, 33], [3070, 35, 38], [3077, 40, 22], [3086, 81, 27],
                    [3091, 10, 16], [3092, 50, 27], [3098, 21, 21], [3106, 20, 22], [3112, 62, 33], [3114, 33, 31],
                    [3119, 12, 28], [3121, 21, 22], [3122, 33, 33], [3123, 120, 43], [3126, 50, 23], [3129, 39, 49],
                    [3133, 29, 22], [3134, 54, 45], [3137, 33, 33], [3142, 41, 50], [3148, 37, 34], [3154, 35, 33],
                    [3155, 29, 23], [3158, 16, 19], [3160, 21, 22], [3161, 22, 22], [3164, 60, 40], [3167, 23, 33],
                    [3171, 40, 22], [3175, 41, 29], [3182, 22, 26], [3188, 44, 42], [3189, 40, 33], [3195, 21, 22],
                    [3206, 33, 33], [3217, 32, 33], [3221, 50, 24], [3228, 32, 33], [3231, 22, 22], [3234, 62, 28],
                    [3246, 64, 37], [3248, 21, 24], [3251, 40, 49], [3252, 44, 29], [3254, 26, 19], [3256, 23, 25],
                    [3264, 34, 34], [3268, 33, 33], [3272, 27, 24], [3273, 90, 20], [3274, 34, 28], [3277, 36, 25],
                    [3280, 32, 33], [3283, 27, 22], [3284, 21, 22], [3289, 71, 59], [3301, 46, 45], [3306, 24, 30],
                    [3308, 70, 41], [3309, 50, 45], [3320, 62, 68], [3321, 50, 28], [3326, 21, 22], [3327, 57, 60],
                    [3331, 21, 21], [3336, 27, 22], [3344, 21, 21], [3346, 21, 37], [3348, 65, 34], [3357, 12, 19],
                    [3358, 16, 19], [3363, 82, 34], [3364, 11, 19], [3372, 60, 36], [3382, 44, 27], [3404, 43, 34],
                    [3407, 21, 22], [3418, 88, 42], [3422, 26, 20], [3429, 32, 33], [3434, 7, 6], [3438, 60, 33],
                    [3439, 22, 22], [3441, 31, 32], [3442, 21, 22], [3451, 53, 57], [3453, 21, 22], [3454, 13, 10],
                    [3457, 33, 34], [3459, 28, 24], [3462, 56, 25], [3468, 23, 22], [3469, 34, 20], [3476, 34, 44],
                    [3494, 12, 15], [3498, 22, 30], [3503, 97, 62], [3511, 20, 36], [3515, 17, 77], [3517, 63, 24],
                    [3531, 31, 22], [3541, 24, 30], [3557, 10, 16], [3559, 50, 44], [3566, 14, 12], [3569, 76, 77],
                    [3572, 32, 32], [3579, 22, 33], [3590, 35, 38], [3593, 57, 23], [3598, 18, 14], [3602, 22, 22],
                    [3608, 30, 32], [3632, 33, 33], [3639, 22, 22], [3642, 36, 31], [3644, 33, 33], [3650, 44, 32],
                    [3653, 22, 22], [3656, 32, 33], [3659, 21, 17], [3661, 34, 34], [3667, 21, 22], [3669, 11, 22],
                    [3670, 44, 33], [3679, 21, 22], [3700, 27, 32], [3703, 34, 35], [3718, 60, 31], [3726, 12, 13],
                    [3729, 120, 32], [3731, 30, 25], [3747, 31, 25], [3751, 26, 22], [3755, 33, 34], [3761, 23, 24],
                    [3765, 29, 19], [3777, 33, 24], [3782, 82, 35], [3786, 14, 12], [3795, 31, 33], [3796, 33, 34],
                    [3802, 56, 60], [3807, 21, 21], [3827, 33, 33], [3828, 22, 25], [3832, 33, 33], [3833, 27, 14],
                    [3834, 33, 40], [3841, 30, 33], [3845, 34, 34], [3854, 21, 22], [3855, 21, 21], [3859, 12, 16],
                    [3870, 36, 34], [3871, 23, 26], [3874, 32, 33], [3883, 21, 22], [3884, 65, 39], [3889, 90, 33],
                    [3897, 30, 33], [3900, 29, 28], [3905, 34, 34], [3915, 32, 33], [3921, 33, 34], [3925, 76, 56],
                    [3932, 28, 36], [3942, 20, 34], [3943, 18, 30], [3947, 59, 46], [3953, 33, 33], [3956, 48, 57],
                    [3959, 21, 21], [3960, 43, 33], [3963, 30, 16], [3969, 105, 53], [3970, 33, 33], [3972, 99, 73],
                    [3976, 17, 16], [3985, 34, 26], [3988, 25, 34], [3992, 33, 34], [3993, 11, 14], [3999, 31, 33],
                    [4015, 65, 35], [4022, 50, 33], [4023, 32, 33], [4026, 42, 21], [4027, 100, 43], [4028, 38, 49],
                    [4031, 18, 15], [4034, 106, 56], [4035, 22, 22], [4038, 120, 47], [4040, 33, 34], [4043, 19, 19],
                    [4047, 34, 40], [4074, 25, 38], [4082, 102, 45], [4084, 12, 19], [4091, 44, 17], [4095, 33, 33],
                    [4096, 31, 33], [4106, 31, 33], [4107, 80, 34], [4109, 19, 20], [4111, 21, 14], [4116, 32, 33],
                    [4118, 33, 34], [4120, 32, 33], [4122, 73, 68], [4124, 31, 32], [4125, 13, 18], [4134, 39, 33],
                    [4152, 134, 59], [4156, 22, 23], [4164, 22, 22], [4165, 47, 46], [4169, 30, 23], [4173, 12, 19],
                    [4176, 11, 16], [4177, 58, 40], [4182, 32, 33], [4185, 21, 22], [4188, 113, 29], [4189, 22, 34],
                    [4199, 50, 33], [4203, 33, 34], [4206, 17, 19], [4209, 22, 20], [4229, 29, 23], [4242, 21, 21],
                    [4246, 12, 16], [4250, 79, 27], [4272, 33, 34], [4279, 28, 34], [4283, 20, 20], [4285, 38, 34],
                    [4298, 50, 62], [4299, 23, 41], [4301, 67, 34], [4302, 18, 19], [4310, 36, 29], [4312, 63, 36],
                    [4318, 21, 22], [4320, 34, 33], [4325, 66, 34], [4326, 11, 14], [4329, 23, 34], [4333, 18, 23],
                    [4338, 34, 33], [4345, 20, 23], [4349, 32, 33], [4350, 20, 22], [4352, 22, 22], [4353, 30, 28],
                    [4358, 13, 17], [4362, 54, 34], [4364, 21, 22], [4380, 19, 14], [4382, 63, 53], [4384, 37, 22],
                    [4386, 15, 19], [4391, 21, 21], [4406, 51, 35], [4413, 13, 13], [4414, 15, 26], [4415, 105, 31],
                    [4421, 33, 33], [4426, 11, 15], [4438, 63, 30], [4440, 50, 38], [4441, 17, 13], [4442, 15, 22],
                    [4446, 33, 34], [4454, 25, 23], [4461, 41, 30], [4464, 64, 31], [4470, 35, 40], [4471, 22, 22],
                    [4477, 34, 39], [4487, 37, 50], [4491, 55, 40], [4494, 20, 20], [4495, 30, 23], [4500, 30, 22],
                    [4504, 68, 43], [4506, 21, 22], [4508, 37, 32], [4510, 30, 25], [4515, 33, 33], [4518, 44, 33],
                    [4521, 31, 33], [4524, 32, 33], [4532, 24, 22], [4536, 23, 21], [4542, 50, 31], [4545, 56, 43],
                    [4550, 32, 33], [4552, 16, 19], [4558, 30, 29], [4563, 32, 34], [4572, 33, 21], [4587, 36, 28],
                    [4591, 24, 22], [4601, 61, 33], [4602, 26, 33], [4606, 21, 22], [4608, 23, 25], [4610, 64, 31],
                    [4611, 21, 22], [4613, 52, 43], [4616, 24, 19], [4617, 100, 43], [4618, 29, 28], [4623, 15, 20],
                    [4626, 38, 25], [4631, 16, 16], [4633, 21, 22], [4634, 33, 32], [4635, 90, 15], [4638, 80, 46],
                    [4643, 24, 19], [4644, 14, 19], [4648, 32, 11], [4660, 70, 33], [4668, 33, 33], [4670, 70, 26],
                    [4676, 14, 23], [4684, 25, 22], [4689, 50, 36], [4693, 34, 32], [4694, 24, 24], [4703, 11, 16],
                    [4710, 9, 7], [4711, 17, 16], [4712, 27, 20], [4717, 22, 22], [4724, 38, 23], [4728, 27, 24],
                    [4729, 42, 33], [4732, 96, 113], [4734, 19, 19], [4738, 46, 57], [4745, 20, 25], [4747, 74, 39],
                    [4749, 50, 38], [4753, 28, 23], [4762, 69, 66], [4764, 58, 51], [4777, 23, 24], [4780, 21, 21],
                    [4781, 30, 35], [4789, 45, 28], [4791, 21, 22], [4794, 29, 21], [4800, 32, 33], [4801, 11, 23],
                    [4802, 32, 22], [4805, 15, 22], [4815, 32, 33], [4819, 20, 22], [4820, 60, 55], [4826, 22, 22],
                    [4828, 44, 22], [4829, 22, 30], [4832, 12, 17], [4835, 30, 28], [4839, 44, 24], [4840, 65, 45],
                    [4844, 23, 22], [4849, 23, 21], [4863, 50, 31], [4864, 21, 24], [4865, 35, 25], [4871, 18, 24],
                    [4872, 32, 33], [4877, 27, 21], [4880, 17, 21], [4881, 32, 33], [4888, 62, 60], [4897, 18, 27],
                    [4910, 32, 34], [4912, 11, 23], [4914, 37, 20], [4915, 23, 19], [4918, 25, 35], [4922, 44, 22],
                    [4926, 28, 24], [4927, 21, 21], [4931, 21, 22], [4939, 26, 25], [4940, 50, 23], [4944, 15, 19],
                    [4950, 32, 33], [4951, 55, 33], [4955, 33, 33], [4957, 21, 23], [4960, 129, 57], [4973, 35, 40],
                    [4975, 34, 34], [4976, 12, 19], [4978, 83, 64], [4979, 108, 40], [4983, 25, 22], [4987, 20, 21],
                    [4990, 22, 22], [4992, 27, 26], [4995, 32, 35], [4996, 32, 33], [4997, 31, 22], [4998, 32, 33],
                    [5005, 19, 33], [5006, 55, 29], [5008, 32, 33], [5009, 19, 21], [5011, 33, 33], [5012, 27, 30],
                    [5013, 12, 19], [5017, 34, 34], [5019, 58, 36], [5022, 99, 55], [5027, 34, 34], [5031, 11, 16],
                    [5032, 24, 35], [5033, 21, 22], [5035, 32, 33], [5037, 34, 21], [5038, 12, 21], [5046, 32, 33],
                    [5048, 24, 21], [5050, 13, 15], [5051, 12, 13], [5053, 32, 24], [5058, 32, 33], [5062, 39, 56],
                    [5063, 27, 38], [5064, 32, 34], [5065, 31, 33], [5068, 35, 26], [5069, 33, 33], [5070, 22, 22],
                    [5071, 33, 34], [5073, 68, 49], [5075, 22, 33], [5079, 21, 22], [5081, 41, 19], [5091, 60, 52],
                    [5092, 12, 19], [5095, 14, 17], [5098, 21, 22], [5102, 20, 12], [5103, 33, 33], [5104, 67, 45],
                    [5107, 61, 52], [5108, 24, 37], [5109, 24, 22], [5116, 29, 34], [5121, 21, 21], [5122, 33, 24],
                    [5126, 21, 22], [5127, 22, 22], [5130, 62, 73], [5138, 16, 15], [5149, 26, 24], [5150, 76, 47],
                    [5153, 40, 33], [5159, 47, 28], [5162, 24, 24], [5173, 51, 28], [5180, 23, 37], [5181, 20, 22],
                    [5182, 23, 26], [5183, 33, 33], [5184, 40, 24], [5185, 36, 20], [5186, 13, 19], [5187, 12, 13],
                    [5188, 12, 15], [5189, 20, 11], [5217, 65, 44], [5219, 17, 60], [5220, 14, 62], [5221, 13, 48],
                    [5222, 16, 24], [5223, 11, 31], [5224, 16, 45], [5225, 17, 62], [5226, 12, 60], [5227, 31, 69],
                    [5228, 20, 62], [5229, 11, 44], [5230, 16, 38], [5231, 15, 37], [5232, 20, 69], [5233, 24, 82],
                    [5234, 11, 28], [5235, 43, 43], [5236, 16, 44], [5237, 33, 67], [5238, 20, 52], [5239, 25, 69],
                    [5240, 19, 69], [5241, 29, 63], [5242, 23, 50], [5243, 28, 69], [5244, 20, 87], [5245, 26, 69],
                    [5247, 40, 15], [5248, 41, 21], [5273, 27, 18], [5276, 34, 67], [5279, 23, 27], [5287, 13, 14],
                    [5290, 24, 22], [5298, 14, 14], [5299, 19, 21], [5303, 35, 22], [5305, 29, 25], [5314, 23, 25],
                    [5315, 20, 28], [5317, 48, 72], [5321, 22, 23], [5323, 14, 23], [5328, 22, 22], [5332, 25, 30],
                    [5333, 14, 17], [5336, 17, 20], [5337, 18, 18], [5338, 34, 27], [5339, 22, 25], [5340, 32, 37],
                    [5343, 17, 15], [5344, 45, 49], [5347, 21, 24], [5349, 24, 28], [5350, 22, 31], [5353, 21, 27],
                    [5355, 25, 41], [5357, 30, 22], [5359, 18, 26], [5366, 32, 25], [5371, 35, 39], [5372, 24, 25],
                    [5375, 21, 19], [5377, 18, 20], [5383, 30, 29], [5385, 34, 26], [5387, 17, 17], [5400, 14, 13],
                    [5403, 25, 26], [5404, 25, 25], [5407, 21, 25], [5408, 19, 23], [5411, 27, 22], [5412, 24, 19],
                    [5414, 13, 16], [5415, 49, 54], [5418, 29, 37], [5420, 17, 17], [5421, 19, 16], [5422, 26, 35],
                    [5425, 17, 20], [5426, 23, 32], [5428, 19, 26], [5431, 22, 24], [5432, 23, 31], [5434, 16, 17],
                    [5436, 23, 26], [5437, 29, 25], [5440, 41, 32], [5441, 32, 42], [5444, 22, 36], [5447, 21, 24],
                    [5449, 27, 34], [5450, 29, 32], [5452, 23, 35], [5453, 35, 33], [5454, 15, 17], [5455, 29, 22],
                    [5457, 17, 26], [5459, 26, 26], [5462, 23, 27], [5463, 15, 18], [5464, 19, 19], [5465, 24, 24],
                    [5472, 25, 30], [5473, 19, 25], [5476, 16, 21], [5479, 21, 19], [5480, 37, 33], [5482, 18, 19],
                    [5486, 23, 22], [5489, 35, 63], [5492, 23, 39], [5494, 26, 31], [5495, 33, 28], [5498, 37, 39],
                    [5499, 34, 25], [5501, 28, 44], [5505, 20, 31], [5508, 26, 36], [5528, 21, 20], [5532, 26, 25],
                    [5534, 18, 15], [5539, 17, 20], [5541, 27, 22], [5544, 23, 33], [5545, 17, 23], [5547, 27, 26],
                    [5550, 17, 18], [5571, 28, 22], [5659, 9, 7], [5944, 7, 8], [5945, 11, 9], [5946, 6, 5],
                    [5962, 77, 101], [5986, 65, 42], [5989, 50, 60], [5990, 50, 60], [5991, 50, 60], [5992, 50, 60],
                    [5993, 50, 60], [5996, 63, 36], [6055, 70, 41], [6066, 38, 36], [6068, 66, 57], [6069, 71, 71],
                    [6070, 71, 71], [6071, 36, 36], [6072, 26, 51], [6073, 41, 46], [6074, 46, 46], [6075, 71, 71],
                    [6076, 51, 49], [6077, 41, 41], [6078, 51, 61], [6079, 50, 49], [6080, 51, 57], [6081, 31, 37],
                    [6082, 46, 46], [6083, 41, 41], [6084, 61, 46], [6085, 51, 51], [6086, 31, 28], [6087, 121, 41],
                    [6088, 50, 50], [6089, 41, 40], [6090, 71, 54], [6091, 36, 41], [6092, 41, 49], [6093, 46, 46],
                    [6094, 46, 46], [6095, 31, 31], [6096, 41, 36], [6097, 50, 42], [6098, 41, 41], [6099, 61, 46],
                    [6100, 46, 46], [6101, 46, 36], [6102, 31, 33], [6103, 41, 41], [6104, 51, 38], [6105, 61, 46],
                    [6106, 36, 36], [6107, 36, 36], [6108, 46, 43], [6109, 26, 35], [6110, 41, 46], [6111, 20, 31],
                    [6112, 41, 41], [6113, 31, 31], [6114, 31, 31], [6115, 31, 37], [6116, 46, 41], [6117, 36, 36],
                    [6118, 46, 45], [6119, 41, 41], [6120, 26, 30], [6121, 41, 41], [6122, 41, 36], [6123, 30, 31],
                    [6124, 46, 36], [6125, 36, 36], [6126, 41, 41], [6127, 41, 41], [6128, 35, 47], [6129, 21, 31],
                    [6130, 41, 41], [6131, 41, 41], [6132, 46, 46], [6133, 41, 41], [6134, 41, 41], [6135, 121, 121],
                    [6136, 101, 101], [6137, 21, 26], [6138, 36, 43], [6139, 41, 43], [6140, 26, 36], [6141, 41, 50],
                    [6142, 35, 43], [6143, 36, 36], [6144, 31, 31], [6145, 46, 46], [6146, 20, 31], [6147, 31, 47],
                    [6148, 31, 39], [6149, 41, 41], [6150, 21, 31], [6151, 31, 31], [6152, 26, 32], [6153, 29, 36],
                    [6154, 41, 41], [6155, 26, 33], [6156, 31, 37], [6157, 50, 46], [6158, 31, 35], [6159, 46, 46],
                    [6160, 26, 31], [6161, 19, 27], [6162, 25, 31], [6163, 71, 60], [6164, 41, 46], [6165, 36, 35],
                    [6166, 61, 43], [6167, 71, 58], [6244, 67, 50], [6353, 25, 16], [6357, 35, 29], [6358, 27, 36],
                    [6359, 26, 26], [6360, 107, 80], [6361, 107, 90], [6362, 65, 64], [6363, 65, 70], [6364, 107, 80],
                    [6365, 111, 83], [6366, 111, 83], [6367, 63, 64], [6368, 107, 80], [6369, 70, 70], [6370, 106, 80],
                    [6371, 107, 90], [6372, 111, 83], [6373, 111, 90], [6374, 107, 80], [6375, 120, 80], [6376, 71, 64],
                    [6377, 120, 89], [6378, 65, 64], [6379, 71, 70], [6380, 70, 63], [6381, 71, 64], [6382, 107, 80],
                    [6383, 71, 64], [6384, 107, 80], [6385, 107, 66], [6386, 107, 80], [6387, 106, 89], [6388, 107, 79],
                    [6389, 111, 83], [6390, 107, 80], [6391, 64, 63], [6392, 107, 80], [6393, 120, 90], [6394, 111, 83],
                    [6395, 107, 80], [6396, 111, 83], [6397, 107, 80], [6398, 120, 90], [6399, 111, 83],
                    [6400, 105, 79], [6401, 70, 70], [6402, 111, 83], [6403, 120, 90], [6404, 111, 83], [6405, 111, 83],
                    [6406, 107, 80], [6407, 107, 80], [6408, 107, 80], [6409, 107, 80], [6410, 107, 80],
                    [6411, 104, 78], [6412, 107, 80], [6413, 120, 90], [6414, 120, 80], [6415, 107, 80],
                    [6416, 111, 83], [6417, 111, 83], [6418, 120, 90], [6419, 111, 90], [6420, 120, 90],
                    [6421, 107, 80], [6422, 107, 80], [6423, 33, 32], [6424, 71, 70], [6425, 71, 64], [6426, 107, 90],
                    [6427, 120, 90], [6428, 120, 90], [6429, 120, 89], [6430, 65, 70], [6431, 107, 80], [6432, 107, 90],
                    [6433, 58, 63], [6434, 107, 80], [6435, 70, 62], [6436, 120, 80], [6437, 111, 83], [6438, 107, 80],
                    [6439, 107, 80], [6440, 120, 90], [6441, 105, 78], [6442, 64, 63], [6443, 107, 80], [6444, 82, 90],
                    [6445, 107, 80], [6446, 111, 83], [6447, 64, 48], [6448, 107, 80], [6449, 111, 90], [6450, 120, 90],
                    [6451, 111, 90], [6452, 120, 80], [6453, 107, 80], [6454, 107, 80], [6455, 107, 80],
                    [6456, 107, 80], [6457, 36, 41], [6458, 28, 32], [6459, 120, 83], [6460, 120, 90], [6461, 107, 80],
                    [6462, 106, 90], [6463, 107, 90], [6464, 120, 90], [6465, 111, 90], [6466, 106, 80],
                    [6467, 120, 90], [6468, 111, 83], [6469, 107, 80], [6470, 107, 80], [6471, 107, 80],
                    [6472, 111, 83], [6473, 111, 83], [6474, 107, 80], [6475, 107, 80], [6476, 107, 80],
                    [6477, 115, 87], [6478, 107, 80], [6479, 107, 80], [6480, 107, 80], [6481, 111, 83],
                    [6482, 111, 90], [6483, 107, 80], [6484, 71, 52], [6485, 105, 80], [6486, 111, 83], [6487, 107, 80],
                    [6488, 107, 80], [6489, 107, 80], [6490, 107, 80], [6491, 107, 80], [6492, 29, 32], [6493, 107, 80],
                    [6494, 29, 32], [6495, 105, 79], [6496, 107, 80], [6497, 120, 90], [6498, 120, 90], [6499, 120, 90],
                    [6500, 71, 64], [6501, 107, 80], [6502, 63, 64], [6503, 107, 80], [6504, 107, 90], [6505, 107, 80],
                    [6506, 107, 90], [6507, 111, 83], [6508, 111, 83], [6509, 107, 80], [6510, 120, 90],
                    [6511, 107, 80], [6512, 107, 80], [6513, 26, 24], [6514, 106, 79], [6515, 107, 90], [6516, 71, 59],
                    [6517, 34, 32], [6518, 107, 90], [6519, 120, 90], [6520, 120, 90], [6521, 53, 52], [6522, 107, 80],
                    [6523, 120, 90], [6524, 120, 91], [6525, 107, 80], [6526, 111, 83], [6527, 107, 80],
                    [6528, 107, 80], [6529, 120, 90], [6530, 105, 79], [6531, 111, 90], [6532, 107, 80],
                    [6533, 107, 80], [6534, 107, 90], [6535, 111, 83], [6536, 34, 37], [6537, 111, 83], [6538, 111, 90],
                    [6539, 107, 80], [6540, 111, 90], [6541, 111, 83], [6542, 111, 83], [6543, 111, 83],
                    [6544, 111, 83], [6546, 111, 83], [6547, 120, 90], [6548, 111, 83], [6549, 111, 90],
                    [6550, 111, 83], [6551, 111, 83], [6552, 111, 90], [6553, 111, 83], [6554, 111, 83],
                    [6555, 111, 83], [6556, 111, 83], [6557, 111, 83], [6558, 107, 80], [6559, 111, 83],
                    [6560, 107, 80], [6561, 111, 90], [6562, 111, 83], [6563, 111, 83], [6564, 111, 83],
                    [6565, 120, 90], [6566, 107, 70], [6567, 111, 83], [6568, 107, 80], [6569, 107, 80],
                    [6570, 111, 83], [6572, 111, 83], [6573, 107, 80], [6574, 107, 80], [6575, 106, 79],
                    [6576, 107, 80], [6577, 107, 80], [6578, 107, 80], [6579, 111, 83], [6580, 107, 80],
                    [6581, 120, 90], [6582, 107, 80], [6583, 120, 90], [6584, 115, 87], [6585, 107, 80],
                    [6586, 107, 80], [6587, 107, 80], [6588, 107, 80], [6589, 107, 80], [6590, 115, 87],
                    [6591, 111, 83], [6592, 111, 83], [6593, 111, 83], [6594, 111, 83], [6595, 107, 80],
                    [6596, 107, 80], [6597, 111, 83], [6598, 111, 83], [6599, 120, 90], [6600, 107, 80],
                    [6601, 111, 83], [6602, 107, 80], [6603, 65, 64], [6604, 111, 90], [6605, 107, 80], [6606, 107, 80],
                    [6607, 120, 80], [6608, 107, 80], [6609, 107, 80], [6610, 107, 80], [6611, 65, 64], [6612, 107, 90],
                    [6613, 107, 80], [6614, 34, 37], [6615, 107, 80], [6616, 107, 80], [6617, 38, 33], [6618, 107, 80],
                    [6619, 111, 83], [6620, 111, 83], [6621, 107, 80], [6622, 107, 80], [6623, 120, 90],
                    [6624, 120, 83], [6625, 111, 83], [6626, 120, 90], [6627, 107, 80], [6628, 111, 90], [6629, 65, 70],
                    [6630, 70, 70], [6631, 61, 73], [6632, 26, 31], [6633, 36, 43], [6634, 46, 46], [6635, 51, 51],
                    [6636, 81, 81], [6637, 61, 46], [6638, 71, 58], [6639, 51, 64], [6640, 72, 80], [6643, 51, 48],
                    [6649, 61, 48], [6650, 61, 46], [6651, 41, 31], [6652, 61, 46], [6653, 56, 56], [6654, 41, 41],
                    [6655, 36, 36], [6656, 46, 41], [6657, 51, 51], [6660, 46, 33], [6661, 36, 36], [6662, 53, 46],
                    [6663, 41, 41], [6664, 50, 50], [6665, 41, 41], [6666, 41, 36], [6667, 41, 41], [6668, 41, 30],
                    [6669, 50, 50], [6670, 41, 41], [6671, 61, 41], [6672, 46, 36], [6673, 46, 41], [6674, 46, 46],
                    [6675, 41, 41], [6676, 61, 61], [6677, 41, 41], [6678, 41, 41], [6679, 101, 101], [6680, 36, 36],
                    [6682, 36, 36], [6683, 41, 41], [6684, 36, 50], [6685, 30, 35], [6686, 31, 37], [6687, 31, 37],
                    [6688, 31, 37], [6689, 30, 37], [6690, 31, 37], [6697, 40, 31], [6699, 73, 61], [6700, 88, 80],
                    [6701, 73, 93], [6702, 74, 49], [6704, 59, 50], [6706, 49, 47], [6708, 69, 69], [6715, 72, 60],
                    [6716, 92, 60], [6718, 101, 76], [6722, 78, 62], [6723, 70, 53], [6725, 53, 54], [6726, 103, 69],
                    [6728, 63, 62], [6730, 53, 54], [6734, 69, 52], [6737, 74, 62], [6738, 60, 60], [6741, 17, 20],
                    [6748, 36, 36], [6749, 41, 41], [6750, 61, 61], [6752, 31, 37], [6753, 51, 46], [6754, 46, 46],
                    [6755, 61, 61], [6756, 51, 51], [6757, 46, 46], [6758, 51, 65], [6759, 31, 37], [6760, 61, 61],
                    [6761, 61, 61], [6762, 51, 51], [6763, 31, 31], [6764, 46, 51], [6766, 71, 74], [6767, 41, 45],
                    [6768, 46, 46], [6769, 61, 78], [6770, 51, 61], [6771, 51, 56], [6772, 41, 52], [6773, 71, 65],
                    [6777, 71, 70], [6778, 41, 41], [6779, 51, 61], [6780, 51, 57], [6781, 61, 61], [6782, 101, 91],
                    [6783, 71, 71], [6784, 51, 51], [6785, 51, 51], [6786, 51, 61], [6787, 46, 58], [6789, 61, 61],
                    [6790, 103, 78], [6791, 96, 65], [6794, 102, 77], [6795, 75, 66], [6798, 98, 67], [6803, 80, 69],
                    [6804, 80, 69], [6805, 105, 79], [6806, 75, 69], [6807, 101, 69], [6808, 104, 79], [6812, 117, 103],
                    [6813, 101, 76], [6814, 96, 89], [6816, 98, 82], [6818, 21, 24], [6819, 39, 47], [6820, 38, 44],
                    [6821, 51, 52], [6822, 54, 53], [6823, 50, 52], [6833, 93, 72], [6834, 104, 87], [6835, 113, 87],
                    [6836, 103, 80], [6837, 104, 78], [6838, 116, 89], [6841, 41, 30], [6845, 103, 78], [6846, 115, 99],
                    [6847, 102, 77], [6848, 105, 79], [6849, 68, 67], [6850, 103, 78], [6851, 102, 77], [6852, 106, 80],
                    [6853, 106, 80], [6854, 101, 84], [6855, 104, 79], [6856, 103, 78], [6857, 104, 87],
                    [6858, 109, 82], [6859, 93, 71], [6860, 103, 78], [6861, 106, 88], [6862, 106, 80], [6867, 12, 20],
                    [6868, 12, 17], [6869, 15, 18], [6870, 15, 21], [6871, 16, 19], [6872, 12, 18], [6873, 21, 21],
                    [6874, 17, 21], [6875, 16, 20], [6876, 15, 22], [6877, 18, 21], [6878, 15, 19], [6879, 15, 22],
                    [6880, 21, 27], [6881, 15, 15], [6882, 16, 21], [6883, 15, 23], [6884, 7, 8], [6885, 26, 16],
                    [6886, 12, 17], [6887, 120, 40], [6888, 11, 12], [6889, 22, 14], [6890, 8, 10], [6891, 18, 17],
                    [6892, 9, 10], [6893, 23, 15], [6894, 7, 9], [6895, 29, 16], [6896, 9, 12], [6897, 16, 16],
                    [6898, 6, 8], [6899, 30, 14], [6900, 6, 7], [6901, 25, 16], [6902, 11, 16], [6903, 36, 25],
                    [6904, 12, 12], [6905, 45, 26], [6906, 8, 10], [6907, 26, 17], [6908, 8, 8], [6909, 25, 19],
                    [6910, 36, 31], [6911, 65, 44], [6912, 40, 25], [6913, 71, 43], [6914, 13, 12], [6915, 42, 41],
                    [6916, 11, 12], [6917, 31, 37], [6918, 31, 25], [6919, 31, 31], [6920, 31, 25], [6921, 54, 40],
                    [6922, 15, 13], [6923, 59, 43], [6924, 11, 12], [6925, 45, 45], [6926, 75, 31], [6927, 75, 41],
                    [6928, 21, 20], [6929, 60, 45], [6930, 22, 15], [6931, 42, 45], [6932, 21, 14], [6933, 31, 29],
                    [6934, 21, 15], [6935, 50, 55], [6936, 25, 23], [6937, 53, 45], [6938, 23, 15], [6939, 55, 42],
                    [6940, 13, 11], [6941, 33, 26], [6942, 35, 30], [6943, 65, 44], [6944, 12, 12], [6945, 84, 65],
                    [6946, 71, 37], [6947, 75, 55], [6948, 15, 13], [6949, 54, 41], [6950, 18, 15], [6951, 60, 45],
                    [6952, 69, 28], [6953, 72, 41], [6954, 31, 18], [6955, 54, 41], [6956, 20, 16], [6957, 84, 73],
                    [6958, 16, 12], [6959, 55, 45], [6960, 12, 11], [6961, 31, 28], [6962, 14, 12], [6963, 12, 11],
                    [6964, 28, 18], [6965, 9, 10], [6966, 34, 77], [6967, 25, 74], [6968, 44, 97], [6969, 26, 66],
                    [6970, 36, 80], [6971, 38, 29], [6972, 77, 35], [6973, 24, 12], [6974, 6, 7], [6975, 9, 10],
                    [6976, 22, 18], [6977, 7, 9], [6978, 53, 21], [6979, 7, 9], [6980, 20, 15], [6981, 9, 9],
                    [6982, 29, 17], [6983, 12, 14], [6984, 34, 26], [6985, 60, 34], [6986, 120, 49], [6987, 9, 9],
                    [6988, 27, 12], [6989, 15, 16], [6990, 32, 23], [6991, 7, 5], [6992, 24, 13], [6993, 8, 8],
                    [6994, 61, 26], [6995, 11, 11], [6996, 22, 16], [6997, 7, 6], [6998, 15, 8], [6999, 7, 7],
                    [7000, 21, 15], [7001, 7, 7], [7002, 18, 14], [7003, 8, 8], [7004, 18, 14], [7005, 15, 15],
                    [7006, 31, 25], [7007, 43, 33], [7008, 43, 33], [7009, 21, 15], [7010, 21, 15], [7011, 10, 10],
                    [7012, 24, 23], [7013, 32, 21], [7014, 13, 11], [7015, 12, 9], [7019, 11, 10], [7020, 43, 45],
                    [7021, 13, 12], [7022, 23, 23], [7023, 19, 19], [7024, 31, 31], [7025, 15, 13], [7026, 31, 25],
                    [7027, 22, 21], [7028, 43, 45], [7029, 45, 31], [7030, 62, 45], [7031, 15, 13], [7032, 31, 25],
                    [7033, 25, 25], [7034, 40, 33], [7035, 11, 12], [7036, 31, 31], [7037, 31, 33], [7038, 41, 45],
                    [7039, 25, 14], [7040, 33, 31], [7041, 15, 13], [7042, 62, 58], [7043, 21, 31], [7044, 31, 31],
                    [7045, 40, 25], [7046, 58, 41], [7047, 20, 15], [7048, 31, 25], [7049, 55, 41], [7050, 23, 17],
                    [7051, 61, 45], [7052, 17, 15], [7053, 55, 45], [7054, 18, 15], [7055, 45, 32], [7056, 15, 15],
                    [7057, 66, 45], [7058, 31, 19], [7059, 61, 45], [7060, 32, 21], [7061, 55, 45], [7062, 20, 14],
                    [7063, 55, 25], [7064, 32, 15], [7065, 45, 45], [7066, 13, 13], [7067, 56, 46], [7068, 45, 35],
                    [7069, 75, 65], [7070, 31, 21], [7071, 61, 45], [7072, 11, 12], [7073, 31, 31], [7074, 26, 21],
                    [7075, 56, 60], [7076, 31, 25], [7077, 44, 31], [7078, 11, 12], [7079, 31, 25], [7080, 47, 41],
                    [7081, 82, 64], [7082, 31, 25], [7083, 45, 45], [7084, 70, 24], [7085, 71, 45], [7086, 13, 12],
                    [7087, 46, 41], [7088, 31, 28], [7089, 61, 45], [7090, 22, 12], [7091, 60, 45], [7092, 63, 27],
                    [7093, 82, 70], [7094, 42, 31], [7095, 64, 45], [7096, 31, 25], [7097, 45, 31], [7098, 31, 31],
                    [7099, 58, 46], [7100, 15, 13], [7101, 21, 20], [7102, 15, 11], [7103, 37, 18], [7104, 10, 7],
                    [7105, 22, 13], [7106, 5, 7], [7107, 22, 12], [7108, 12, 10], [7109, 30, 16], [7110, 9, 11],
                    [7111, 28, 14], [7112, 5, 5], [7113, 34, 14], [7114, 29, 21], [7115, 49, 27], [7116, 11, 12],
                    [7117, 34, 22], [7118, 8, 16], [7119, 17, 16], [7120, 12, 14], [7121, 43, 38], [7122, 10, 8],
                    [7123, 30, 17], [7124, 7, 10], [7125, 16, 16], [7126, 8, 7], [7127, 21, 16], [7128, 9, 8],
                    [7129, 21, 14], [7130, 8, 9], [7131, 24, 14], [7132, 9, 8], [7133, 35, 21], [7134, 18, 11],
                    [7135, 26, 11], [7136, 19, 14], [7137, 35, 20], [7138, 10, 9], [7139, 26, 19], [7140, 6, 7],
                    [7141, 14, 12], [7142, 9, 11], [7143, 26, 15], [7144, 9, 9], [7145, 18, 14], [7146, 11, 12],
                    [7147, 29, 22], [7148, 9, 11], [7149, 37, 21], [7150, 5, 9], [7151, 18, 14], [7152, 8, 8],
                    [7153, 29, 21], [7154, 18, 21], [7155, 26, 24], [7156, 20, 19], [7157, 10, 8], [7158, 46, 23],
                    [7159, 21, 15], [7160, 49, 32], [7161, 9, 11], [7162, 27, 22], [7163, 8, 7], [7164, 22, 13],
                    [7165, 13, 11], [7166, 58, 32], [7167, 7, 8], [7168, 28, 18], [7169, 5, 5], [7170, 38, 23],
                    [7171, 6, 7], [7172, 44, 27], [7173, 14, 14], [7174, 70, 42], [7175, 6, 5], [7176, 17, 13],
                    [7177, 16, 10], [7178, 23, 13], [7179, 16, 14], [7180, 50, 31], [7181, 10, 10], [7182, 43, 20],
                    [7183, 20, 12], [7184, 92, 62], [7185, 19, 15], [7186, 53, 28], [7187, 14, 11], [7188, 49, 27],
                    [7189, 18, 16], [7190, 46, 27], [7191, 18, 13], [7192, 27, 16], [7193, 14, 13], [7194, 21, 12],
                    [7195, 15, 13], [7196, 42, 24], [7197, 8, 6], [7198, 22, 11], [7199, 16, 11], [7200, 35, 18],
                    [7201, 6, 5], [7202, 14, 9], [7203, 10, 7], [7204, 18, 16], [7205, 20, 17], [7206, 56, 31],
                    [7207, 15, 15], [7208, 42, 27], [7209, 17, 10], [7210, 50, 41], [7211, 10, 10], [7212, 28, 16],
                    [7213, 8, 9], [7214, 70, 35], [7215, 8, 6], [7216, 56, 28], [7217, 13, 10], [7218, 32, 21],
                    [7219, 18, 18], [7220, 38, 25], [7221, 15, 12], [7222, 34, 24], [7223, 12, 11], [7224, 43, 22],
                    [7225, 7, 8], [7226, 29, 17], [7227, 11, 11], [7228, 32, 23], [7229, 14, 9], [7230, 62, 30],
                    [7231, 11, 9], [7232, 32, 20], [7233, 8, 6], [7234, 27, 16], [7235, 12, 10], [7236, 21, 16],
                    [7237, 7, 7], [7238, 21, 14], [7239, 8, 8], [7240, 19, 13], [7241, 21, 22], [7242, 28, 15],
                    [7243, 5, 6], [7244, 18, 12], [7245, 5, 7], [7246, 27, 15], [7247, 7, 9], [7248, 26, 18],
                    [7249, 7, 8], [7250, 25, 16], [7251, 18, 20], [7252, 30, 24], [7253, 16, 10], [7254, 59, 18],
                    [7255, 48, 25], [7256, 26, 17], [7257, 120, 90], [7258, 120, 90], [7259, 103, 65], [7260, 124, 95],
                    [7261, 103, 91], [7262, 118, 138], [7263, 107, 95], [7264, 124, 145], [7265, 104, 92],
                    [7266, 126, 96], [7267, 103, 91], [7268, 125, 96], [7269, 125, 96], [7270, 102, 65], [7271, 69, 68],
                    [7272, 124, 95], [7273, 124, 145], [7274, 124, 94], [7275, 105, 94], [7276, 67, 64],
                    [7277, 104, 92], [7278, 118, 139], [7279, 120, 90], [7280, 126, 96], [7281, 103, 91],
                    [7282, 117, 137], [7283, 15, 25], [7284, 11, 10], [7285, 12, 11], [7286, 20, 31], [7287, 17, 35],
                    [7288, 37, 40], [7289, 43, 31], [7290, 69, 45], [7291, 52, 43], [7292, 49, 52], [7293, 33, 31],
                    [7294, 32, 31], [7295, 15, 14], [7296, 27, 23], [7297, 29, 25], [7298, 16, 20], [7299, 17, 22],
                    [7300, 21, 34], [7301, 13, 30], [7302, 55, 64], [7303, 84, 81], [7304, 43, 48], [7305, 58, 60],
                    [7306, 39, 47], [7307, 57, 64], [7308, 46, 53], [7309, 43, 51], [7310, 89, 77], [7311, 72, 71],
                    [7312, 56, 61], [7313, 115, 85], [7314, 109, 82], [7315, 107, 81], [7316, 109, 82], [7317, 110, 82],
                    [7318, 109, 82], [7319, 116, 86], [7320, 108, 81], [7321, 140, 105], [7322, 109, 82],
                    [7323, 138, 103], [7324, 115, 85], [7325, 110, 82], [7326, 109, 82], [7327, 138, 104],
                    [7328, 42, 50], [7329, 77, 75], [7330, 57, 56], [7331, 57, 56], [7332, 42, 49], [7333, 78, 99],
                    [7337, 16, 16], [7342, 14, 9], [7343, 14, 9], [7344, 12, 9], [7348, 12, 8], [7352, 11, 9],
                    [7354, 14, 14], [7356, 11, 8], [7357, 22, 11], [7358, 16, 11], [7359, 27, 12], [7360, 13, 10],
                    [7362, 11, 9], [7363, 13, 12], [7364, 12, 12], [7367, 13, 8], [7370, 12, 11], [7371, 17, 12],
                    [7372, 19, 10], [7373, 15, 11], [7374, 11, 8], [7375, 12, 8], [7376, 9, 8], [7377, 11, 8],
                    [7378, 21, 20], [7379, 37, 28], [7396, 56, 56], [7397, 94, 72], [7398, 56, 56], [7399, 41, 49],
                    [7400, 63, 62], [7401, 41, 49], [7402, 79, 101], [7403, 34, 41], [7404, 100, 75], [7405, 55, 56],
                    [7406, 75, 94], [7407, 56, 56], [7408, 63, 78], [7409, 25, 31], [7410, 26, 32], [7411, 26, 32],
                    [7412, 60, 65], [7413, 24, 31], [7414, 25, 31], [7415, 23, 36], [7416, 33, 42], [7417, 26, 33],
                    [7418, 29, 32], [7419, 65, 72], [7420, 24, 32], [7421, 49, 57], [7422, 25, 31], [7423, 40, 43],
                    [7424, 65, 60], [7425, 48, 41], [7426, 81, 70], [7427, 60, 57], [7428, 60, 60], [7429, 36, 40],
                    [7430, 56, 43], [7431, 40, 43], [7432, 97, 74], [7433, 60, 56], [7434, 101, 64], [7435, 66, 61],
                    [7436, 78, 70], [7437, 34, 45], [7438, 61, 60], [7439, 55, 50], [7440, 84, 75], [7441, 50, 46],
                    [7442, 75, 65], [7443, 75, 67], [7444, 92, 75], [7445, 75, 63], [7446, 105, 80], [7447, 46, 47],
                    [7448, 78, 77], [7449, 28, 27], [7450, 28, 32], [7451, 17, 20], [7452, 32, 21], [7453, 81, 39],
                    [7454, 24, 25], [7455, 33, 30], [7456, 101, 76], [7457, 71, 71], [7458, 51, 51], [7459, 71, 71],
                    [7460, 71, 81], [7461, 51, 50], [7462, 61, 61], [7463, 71, 71], [7464, 81, 61], [7465, 81, 61],
                    [7466, 71, 53], [7467, 71, 71], [7468, 61, 61], [7469, 86, 65], [7470, 91, 68], [7471, 116, 87],
                    [7472, 41, 91], [7473, 51, 61], [7474, 71, 71], [7475, 71, 71], [7476, 66, 66], [7477, 56, 56],
                    [7478, 61, 61], [7479, 61, 61], [7480, 71, 60], [7481, 51, 61], [7482, 71, 53], [7483, 71, 71],
                    [7484, 51, 61], [7485, 121, 91], [7486, 101, 76], [7487, 66, 66], [7488, 81, 61], [7489, 86, 55],
                    [7490, 61, 61], [7491, 81, 61], [7492, 101, 76], [7493, 71, 71], [7494, 71, 71], [7495, 71, 71],
                    [7496, 121, 91], [7497, 81, 61], [7498, 51, 61], [7499, 60, 51], [7500, 61, 61], [7501, 81, 61],
                    [7502, 80, 61], [7503, 91, 68], [7504, 86, 64], [7505, 71, 71], [7506, 81, 61], [7507, 66, 66],
                    [7508, 81, 61], [7509, 71, 71], [7510, 71, 71], [7511, 81, 61], [7512, 71, 71], [7513, 80, 61],
                    [7514, 120, 91], [7515, 91, 68], [7516, 71, 71], [7517, 121, 91], [7518, 81, 61], [7519, 71, 71],
                    [7520, 71, 71], [7521, 51, 61], [7522, 91, 68], [7523, 71, 71], [7524, 121, 121], [7525, 71, 71],
                    [7526, 86, 64], [7527, 51, 61], [7528, 101, 76], [7529, 121, 121], [7530, 91, 68], [7531, 51, 61],
                    [7532, 71, 71], [7533, 101, 76], [7534, 121, 121], [7535, 71, 71], [7536, 91, 68], [7537, 96, 72],
                    [7538, 101, 76], [7539, 71, 71], [7540, 101, 76], [7541, 91, 68], [7542, 101, 76], [7543, 91, 68],
                    [7544, 96, 72], [7545, 66, 66], [7546, 81, 61], [7547, 80, 61], [7548, 61, 61], [7549, 71, 71],
                    [7550, 61, 61], [7551, 61, 61], [7552, 61, 61], [7553, 71, 71], [7554, 111, 101], [7555, 101, 81],
                    [7556, 71, 71], [7557, 121, 91], [7558, 51, 51], [7559, 80, 61], [7560, 61, 61], [7561, 121, 91],
                    [7562, 121, 91], [7563, 91, 68], [7564, 91, 68], [7565, 71, 71], [7566, 71, 71], [7567, 71, 71],
                    [7568, 71, 71], [7569, 71, 71], [7570, 71, 71], [7571, 71, 71], [7572, 121, 91], [7573, 71, 61],
                    [7574, 71, 71], [7575, 81, 61], [7576, 81, 61], [7577, 91, 68], [7578, 71, 71], [7579, 91, 68],
                    [7580, 91, 68], [7581, 91, 68], [7582, 91, 80], [7583, 71, 71], [7584, 66, 66], [7585, 66, 65],
                    [7586, 121, 91], [7587, 61, 61], [7588, 71, 71], [7589, 121, 91], [7590, 71, 71], [7591, 81, 61],
                    [7592, 91, 68], [7593, 96, 72], [7594, 71, 71], [7595, 71, 71], [7596, 61, 61], [7597, 71, 71],
                    [7598, 81, 61], [7599, 71, 71], [7600, 71, 71], [7601, 61, 61], [7602, 56, 56], [7603, 71, 71],
                    [7604, 71, 71], [7605, 71, 71], [7606, 71, 61], [7607, 91, 68], [7608, 61, 61], [7609, 71, 71],
                    [7610, 61, 61], [7611, 46, 71], [7612, 71, 68], [7613, 71, 71], [7614, 81, 71], [7615, 91, 68],
                    [7616, 91, 68], [7617, 81, 61], [7618, 91, 68], [7619, 71, 71], [7620, 61, 61], [7621, 71, 71],
                    [7622, 91, 68], [7623, 71, 71], [7624, 101, 76], [7625, 61, 61], [7626, 91, 68], [7627, 66, 66],
                    [7628, 91, 68], [7629, 61, 61], [7630, 66, 66], [7631, 66, 66], [7632, 91, 68], [7633, 61, 61],
                    [7634, 19, 34], [7635, 19, 28], [7636, 21, 31], [7637, 43, 42], [7638, 27, 23], [7639, 13, 17],
                    [7640, 12, 14], [7641, 15, 19], [7642, 37, 46], [7643, 19, 20], [7644, 36, 52], [7645, 18, 25],
                    [7646, 36, 34], [7647, 50, 31], [7648, 13, 14], [7649, 13, 14], [7650, 20, 22], [7651, 17, 14],
                    [7652, 19, 15], [7653, 53, 41], [7654, 15, 17], [7655, 19, 18], [7656, 16, 15], [7657, 34, 35],
                    [7658, 23, 33], [7659, 14, 21], [7661, 10, 10], [7662, 15, 13], [7663, 18, 20], [7664, 29, 44],
                    [7665, 46, 67], [7666, 18, 23], [7667, 18, 21], [7668, 18, 14], [7669, 12, 8], [7670, 33, 26],
                    [7671, 45, 39], [7672, 10, 9], [7673, 8, 7], [7674, 22, 19], [7675, 9, 10], [7676, 6, 7],
                    [7677, 6, 6], [7678, 10, 8], [7679, 14, 11], [7680, 20, 22], [7681, 5, 3], [7682, 16, 13],
                    [7683, 5, 3], [7684, 16, 15], [7685, 12, 11], [7686, 22, 20], [7687, 5, 3], [7688, 18, 17],
                    [7689, 12, 13], [7690, 7, 8], [7691, 21, 26], [7692, 11, 10], [7693, 9, 9], [7694, 10, 9],
                    [7695, 31, 21], [7696, 5, 3], [7697, 16, 12], [7698, 10, 8], [7699, 14, 16], [7700, 11, 10],
                    [7701, 9, 8], [7702, 17, 13], [7703, 15, 15], [7704, 18, 19], [7705, 22, 14], [7706, 11, 10],
                    [7707, 10, 10], [7708, 9, 7], [7709, 12, 15], [7710, 6, 6], [7711, 16, 12], [7712, 13, 10],
                    [7713, 21, 12], [7714, 11, 9], [7715, 44, 52], [7716, 55, 56], [7717, 78, 99], [7718, 57, 56],
                    [7719, 42, 49], [7720, 80, 102], [7721, 57, 57], [7722, 71, 57], [7723, 41, 48], [7724, 76, 96],
                    [7725, 24, 33], [7726, 43, 51], [7727, 58, 58], [7728, 71, 69], [7729, 57, 57], [7730, 41, 48],
                    [7731, 77, 98], [7732, 43, 51], [7733, 63, 78], [7734, 92, 71], [7735, 102, 100], [7736, 41, 49],
                    [7737, 62, 61], [7738, 41, 49], [7739, 46, 61], [7740, 42, 49], [7741, 62, 76], [7742, 69, 75],
                    [7743, 56, 56], [7744, 77, 97], [7745, 78, 61], [7746, 57, 57], [7747, 72, 92], [7748, 64, 63],
                    [7749, 57, 58], [7750, 70, 89], [7751, 92, 71], [7752, 101, 99], [7753, 63, 62], [7754, 57, 58],
                    [7755, 42, 49], [7756, 95, 62], [7757, 73, 61], [7758, 106, 80], [7759, 36, 42], [7760, 72, 74],
                    [7761, 43, 55], [7762, 93, 85], [7763, 19, 28], [7764, 19, 27], [7765, 20, 31], [7766, 11, 21],
                    [7767, 29, 36], [7768, 12, 23], [7769, 42, 39], [7770, 62, 45], [7771, 17, 18], [7772, 16, 20],
                    [7773, 26, 28], [7774, 15, 26], [7775, 45, 42], [7776, 18, 37], [7777, 24, 39], [7778, 9, 13],
                    [7779, 15, 20], [7780, 23, 23], [7781, 30, 33], [7782, 36, 29], [7783, 37, 28], [7784, 15, 36],
                    [7785, 26, 46], [7786, 16, 18], [7787, 26, 33], [7788, 23, 27], [7789, 24, 30], [7790, 24, 31],
                    [7791, 47, 43], [7792, 20, 26], [7793, 38, 38], [7795, 61, 58], [7796, 96, 74], [7797, 61, 59],
                    [7798, 61, 58], [7799, 61, 59], [7800, 60, 60], [7801, 63, 59], [7802, 61, 57], [7803, 63, 62],
                    [7804, 98, 74], [7805, 62, 59], [7806, 63, 59], [7807, 61, 57], [7808, 100, 75], [7809, 100, 74],
                    [7810, 60, 56], [7811, 61, 58], [7812, 61, 57], [7813, 62, 58], [7815, 62, 59], [7816, 61, 57],
                    [7817, 99, 74], [7818, 62, 59], [7819, 62, 58], [7820, 63, 75], [7821, 61, 58], [7822, 99, 76],
                    [7823, 95, 73], [7824, 103, 77], [7825, 62, 58], [7826, 99, 74], [7827, 45, 50], [7828, 61, 58],
                    [7829, 60, 60], [7830, 62, 58], [7831, 62, 60], [7832, 62, 58], [7833, 61, 57], [7834, 45, 50],
                    [7835, 62, 58], [7836, 102, 76], [7837, 62, 58], [7838, 99, 74], [7839, 62, 58], [7840, 99, 74],
                    [7841, 61, 57], [7842, 61, 59], [7843, 61, 58], [7844, 61, 56], [7845, 23, 14], [7846, 62, 58],
                    [7847, 100, 75], [7848, 100, 75], [7849, 104, 78], [7850, 45, 50], [7851, 61, 57], [7852, 38, 44],
                    [7853, 46, 51], [7854, 45, 49], [7855, 45, 50], [7856, 43, 50], [7857, 61, 57], [7858, 61, 58],
                    [7859, 60, 59], [7860, 62, 57], [7861, 59, 55], [7862, 106, 79], [7863, 107, 80], [7864, 61, 59],
                    [7865, 63, 60], [7866, 99, 74], [7867, 62, 58], [7868, 62, 58], [7869, 98, 73], [7870, 62, 58],
                    [7871, 61, 59], [7872, 99, 74], [7873, 61, 57], [7874, 62, 58], [7875, 45, 50], [7876, 61, 57],
                    [7877, 101, 75], [7878, 63, 61], [7879, 61, 59], [7880, 61, 59], [7881, 61, 59], [7882, 45, 39],
                    [7883, 45, 50], [7884, 61, 58], [7885, 61, 59], [7886, 61, 59], [7887, 62, 58], [7888, 62, 58],
                    [7889, 99, 74], [7890, 61, 59], [7891, 45, 50], [7892, 62, 58], [7893, 62, 57], [7894, 63, 59],
                    [7895, 62, 60], [7896, 99, 74], [7897, 101, 75], [7898, 62, 57], [7899, 62, 60], [7900, 99, 74],
                    [7901, 61, 56], [7902, 61, 60], [7903, 99, 74], [7904, 62, 57], [7905, 61, 57], [7906, 62, 58],
                    [7907, 100, 74], [7908, 95, 74], [7909, 62, 59], [7910, 62, 58], [7911, 61, 56], [7912, 62, 58],
                    [7913, 61, 59], [7914, 61, 59], [7915, 99, 74], [7916, 97, 74], [7917, 101, 75], [7918, 61, 57],
                    [7919, 62, 58], [7920, 100, 75], [7921, 62, 57], [7922, 63, 59], [7923, 61, 57], [7924, 62, 57],
                    [7925, 62, 57], [7926, 97, 75], [7927, 62, 58], [7928, 43, 50], [7929, 101, 75], [7930, 61, 57],
                    [7931, 62, 58], [7932, 62, 58], [7933, 45, 51], [7934, 43, 51], [7935, 63, 59], [7936, 62, 58],
                    [7937, 62, 57], [7938, 61, 58], [7939, 99, 76], [7940, 98, 73], [7941, 99, 74], [7942, 61, 59],
                    [7943, 62, 58], [7944, 43, 50], [7945, 99, 74], [7946, 62, 58], [7947, 99, 74], [7948, 45, 51],
                    [7949, 100, 74], [7950, 104, 77], [7951, 61, 57], [7952, 51, 44], [7953, 45, 51], [7954, 62, 58],
                    [7955, 62, 58], [7956, 63, 59], [7957, 96, 74], [7958, 101, 75], [7959, 62, 58], [7960, 58, 58],
                    [7961, 62, 59], [7962, 63, 59], [7963, 45, 50], [7964, 100, 74], [7965, 62, 61], [7966, 60, 58],
                    [7967, 61, 57], [7968, 107, 80], [7969, 99, 74], [7970, 62, 58], [7971, 45, 50], [7972, 61, 57],
                    [7974, 45, 51], [7975, 62, 58], [7976, 100, 75], [7977, 61, 58], [7978, 99, 74], [7979, 100, 75],
                    [7980, 61, 57], [7981, 100, 74], [7982, 62, 58], [7983, 61, 57], [7984, 100, 75], [7985, 61, 59],
                    [7986, 61, 57], [7987, 61, 59], [7988, 98, 73], [7989, 47, 54], [7990, 62, 50], [7992, 63, 59],
                    [7993, 99, 76], [7994, 60, 57], [7995, 61, 58], [7996, 61, 59], [7997, 62, 58], [7998, 62, 58],
                    [7999, 61, 58], [8000, 45, 50], [8001, 61, 59], [8002, 45, 50], [8003, 43, 50], [8004, 45, 50],
                    [8005, 27, 34], [8006, 17, 24], [8007, 28, 37], [8008, 23, 31], [8009, 20, 21], [8010, 16, 20],
                    [8011, 19, 22], [8012, 14, 18], [8013, 8, 8], [8014, 9, 10], [8015, 12, 13], [8016, 6, 6],
                    [8017, 14, 14], [8018, 8, 9], [8019, 18, 20], [8020, 15, 17], [8021, 7, 8], [8022, 32, 42],
                    [8023, 18, 20], [8024, 24, 22], [8025, 18, 25], [8026, 20, 22], [8027, 13, 11], [8028, 16, 16],
                    [8029, 32, 29], [8030, 20, 17], [8031, 12, 11], [8032, 20, 29], [8033, 31, 34], [8034, 29, 41],
                    [8035, 23, 22], [8036, 19, 25], [8037, 28, 34], [8038, 56, 56], [8039, 39, 70], [8040, 23, 70],
                    [8041, 8, 18], [8042, 7, 10], [8043, 12, 18], [8044, 12, 17], [8045, 5, 3], [8046, 5, 3],
                    [8047, 5, 6], [8048, 17, 23], [8049, 13, 17], [8050, 10, 11], [8051, 23, 27], [8052, 42, 49],
                    [8053, 28, 39], [8054, 24, 34], [8055, 35, 50], [8056, 46, 54], [8057, 29, 36], [8058, 24, 29],
                    [8059, 27, 34], [8060, 32, 37], [8061, 60, 67], [8062, 62, 80], [8063, 13, 10], [8064, 14, 17],
                    [8065, 20, 15], [8066, 91, 56], [8067, 45, 34], [8068, 14, 12], [8069, 13, 30], [8070, 19, 20],
                    [8071, 57, 24], [8072, 48, 27], [8073, 70, 34], [8074, 15, 18], [8075, 16, 19], [8076, 70, 50],
                    [8077, 102, 43], [8078, 31, 45], [8079, 76, 61], [8080, 97, 27], [8081, 117, 60], [8082, 79, 46],
                    [8083, 127, 51], [8084, 74, 64], [8085, 55, 38], [8086, 18, 52], [8087, 15, 36], [8088, 20, 42],
                    [8089, 24, 56], [8090, 26, 40], [8091, 26, 70], [8092, 25, 54], [8093, 28, 70], [8094, 14, 70],
                    [8095, 23, 29], [8096, 27, 43], [8097, 21, 37], [8098, 9, 30], [8099, 56, 56], [8100, 56, 56],
                    [8101, 57, 56], [8102, 42, 49], [8103, 57, 56], [8104, 56, 56], [8105, 93, 72], [8106, 58, 58],
                    [8107, 42, 49], [8108, 62, 61], [8109, 57, 57], [8110, 41, 49], [8111, 61, 60], [8112, 56, 56],
                    [8113, 93, 72], [8114, 42, 49], [8115, 80, 102], [8116, 58, 58], [8117, 62, 99], [8118, 42, 50],
                    [8119, 57, 57], [8120, 61, 60], [8121, 42, 49], [8122, 56, 56], [8123, 94, 72], [8124, 57, 57],
                    [8125, 94, 72], [8126, 54, 54], [8127, 57, 58], [8128, 104, 102], [8129, 56, 56], [8130, 94, 72],
                    [8131, 41, 49], [8132, 62, 61], [8133, 42, 50], [8134, 63, 61], [8135, 94, 72], [8136, 33, 41],
                    [8137, 56, 57], [8138, 58, 58], [8139, 72, 86], [8140, 70, 90], [8141, 56, 56], [8142, 56, 56],
                    [8143, 79, 101], [8144, 36, 43], [8145, 41, 48], [8146, 61, 75], [8147, 56, 56], [8148, 57, 57],
                    [8149, 42, 50], [8150, 81, 104], [8151, 41, 49], [8152, 70, 89], [8153, 56, 57], [8154, 56, 56],
                    [8155, 90, 69], [8156, 89, 119], [8157, 58, 58], [8158, 57, 56], [8159, 54, 55], [8160, 56, 56],
                    [8161, 94, 72], [8162, 95, 73], [8163, 63, 59], [8164, 56, 56], [8165, 57, 57], [8166, 102, 77],
                    [8167, 94, 72], [8168, 56, 57], [8169, 62, 59], [8170, 57, 57], [8171, 57, 57], [8172, 102, 76],
                    [8173, 56, 56], [8174, 57, 57], [8175, 42, 49], [8176, 42, 49], [8177, 42, 50], [8178, 58, 58],
                    [8179, 61, 60], [8180, 56, 56], [8181, 101, 76], [8182, 94, 72], [8183, 58, 58], [8184, 56, 56],
                    [8185, 56, 56], [8186, 57, 57], [8187, 42, 50], [8188, 33, 41], [8189, 62, 60], [8190, 41, 48],
                    [8191, 93, 92], [8192, 58, 57], [8193, 101, 75], [8194, 56, 55], [8195, 57, 56], [8196, 42, 50],
                    [8197, 58, 58], [8198, 42, 50], [8199, 77, 98], [8200, 42, 49], [8201, 102, 77], [8202, 73, 72],
                    [8203, 99, 72], [8204, 93, 72], [8205, 40, 47], [8206, 64, 63], [8207, 56, 56], [8208, 41, 49],
                    [8209, 102, 77], [8210, 57, 57], [8211, 79, 101], [8212, 42, 49], [8213, 57, 57], [8214, 78, 99],
                    [8215, 57, 57], [8216, 57, 56], [8217, 58, 57], [8218, 23, 35], [8219, 64, 63], [8220, 41, 49],
                    [8221, 62, 60], [8222, 34, 42], [8223, 41, 49], [8224, 61, 74], [8225, 45, 53], [8226, 79, 101],
                    [8227, 57, 56], [8228, 40, 47], [8229, 56, 55], [8230, 57, 57], [8231, 33, 41], [8232, 70, 71],
                    [8233, 56, 56], [8234, 40, 48], [8235, 78, 99], [8236, 42, 49], [8237, 70, 69], [8238, 56, 56],
                    [8239, 118, 90], [8240, 57, 56], [8241, 42, 50], [8242, 63, 62], [8245, 57, 57], [8246, 58, 58],
                    [8247, 93, 72], [8248, 34, 41], [8249, 62, 61], [8250, 56, 56], [8251, 57, 56], [8252, 61, 60],
                    [8253, 92, 71], [8254, 42, 53], [8255, 56, 56], [8256, 42, 49], [8257, 78, 99], [8258, 56, 56],
                    [8259, 56, 56], [8260, 57, 58], [8261, 77, 98], [8262, 63, 64], [8263, 98, 74], [8264, 43, 51],
                    [8265, 63, 102], [8267, 93, 71], [8268, 57, 57], [8269, 57, 56], [8270, 32, 41], [8271, 42, 50],
                    [8272, 61, 60], [8273, 57, 56], [8274, 56, 56], [8275, 43, 50], [8276, 56, 56], [8277, 50, 35],
                    [8278, 94, 72], [8279, 56, 56], [8280, 58, 58], [8281, 56, 56], [8282, 58, 58], [8283, 57, 57],
                    [8284, 57, 56], [8285, 58, 58], [8286, 58, 58], [8287, 57, 57], [8288, 42, 50], [8289, 62, 61],
                    [8290, 58, 58], [8291, 58, 58], [8292, 57, 57], [8293, 56, 56], [8294, 56, 56], [8295, 93, 72],
                    [8296, 93, 57], [8297, 57, 57], [8298, 29, 57], [8299, 34, 41], [8300, 102, 77], [8301, 58, 57],
                    [8302, 56, 56], [8303, 94, 72], [8304, 56, 56], [8305, 92, 71], [8306, 42, 50], [8307, 33, 41],
                    [8308, 56, 56], [8309, 22, 30], [8310, 62, 60], [8311, 22, 28], [8312, 20, 24], [8313, 20, 24],
                    [8314, 23, 30], [8315, 20, 24], [8316, 20, 24], [8317, 59, 59], [8318, 97, 73], [8319, 33, 39],
                    [8320, 94, 72], [8321, 58, 43], [8322, 57, 57], [8323, 42, 50], [8324, 99, 74], [8325, 96, 74],
                    [8326, 93, 72], [8327, 92, 71], [8328, 95, 73], [8329, 56, 56], [8330, 95, 73], [8331, 92, 71],
                    [8332, 93, 72], [8333, 25, 34], [8334, 22, 32], [8335, 18, 29], [8336, 25, 20], [8337, 15, 19],
                    [8338, 14, 15], [8339, 51, 53], [8340, 17, 20], [8341, 35, 42], [8342, 18, 18], [8343, 21, 22],
                    [8344, 15, 14], [8345, 20, 16], [8346, 22, 31], [8347, 18, 21], [8348, 26, 35], [8349, 16, 20],
                    [8350, 19, 21], [8351, 15, 11], [8352, 23, 36], [8353, 17, 21], [8354, 28, 36], [8355, 19, 20],
                    [8356, 26, 34], [8357, 18, 18], [8358, 27, 20], [8359, 38, 50], [8360, 42, 53], [8361, 18, 16],
                    [8362, 20, 30], [8363, 28, 40], [8364, 33, 29], [8365, 13, 15], [8366, 28, 25], [8367, 16, 18],
                    [8368, 19, 30], [8369, 22, 31], [8370, 24, 25], [8371, 23, 22], [8372, 30, 25], [8373, 28, 37],
                    [8374, 26, 37], [8375, 18, 17], [8376, 32, 35], [8377, 24, 19], [8378, 24, 20], [8379, 28, 26],
                    [8380, 35, 33], [8381, 31, 41], [8382, 23, 26], [8383, 29, 35], [8384, 27, 43], [8385, 24, 33],
                    [8386, 17, 21], [8387, 29, 30], [8388, 19, 20], [8389, 19, 23], [8390, 16, 18], [8391, 19, 24],
                    [8392, 22, 27], [8393, 46, 67], [8394, 29, 23], [8395, 22, 25], [8396, 62, 60], [8397, 99, 74],
                    [8398, 67, 53], [8399, 92, 58], [8400, 82, 74], [8401, 96, 58], [8402, 72, 60], [8403, 84, 57],
                    [8404, 61, 59], [8405, 85, 57], [8406, 71, 59], [8407, 62, 60], [8408, 60, 73], [8409, 42, 37],
                    [8410, 84, 63], [8411, 93, 65], [8412, 62, 61], [8413, 80, 64], [8414, 119, 57], [8415, 132, 84],
                    [8416, 41, 44], [8417, 88, 59], [8418, 29, 35], [8419, 70, 52], [8420, 93, 71], [8421, 98, 74],
                    [8422, 38, 42], [8423, 65, 63], [8424, 92, 103], [8425, 47, 63], [8426, 59, 57], [8427, 61, 52],
                    [8428, 71, 58], [8429, 38, 38], [8430, 65, 63], [8431, 97, 73], [8432, 66, 63], [8433, 64, 62],
                    [8434, 91, 60], [8435, 152, 71], [8436, 99, 74], [8438, 43, 38], [8439, 49, 46], [8440, 120, 70],
                    [8441, 96, 60], [8442, 60, 59], [8443, 80, 73], [8444, 65, 63], [8445, 37, 35], [8446, 49, 44],
                    [8447, 78, 64], [8448, 62, 58], [8449, 140, 56], [8450, 103, 69], [8451, 22, 33], [8452, 31, 47],
                    [8453, 20, 29], [8454, 35, 46], [8455, 25, 33], [8456, 24, 33], [8457, 65, 63], [8458, 54, 44],
                    [8459, 81, 58], [8460, 61, 59], [8461, 106, 58], [8462, 88, 59], [8463, 87, 70], [8464, 99, 74],
                    [8465, 42, 33], [8466, 48, 60], [8467, 54, 51], [8468, 76, 64], [8469, 64, 58], [8470, 99, 75],
                    [8471, 41, 50], [8472, 115, 57], [8473, 80, 74], [8474, 60, 59], [8475, 96, 72], [8476, 96, 73],
                    [8477, 96, 73], [8478, 35, 39], [8479, 61, 59], [8480, 99, 75], [8481, 62, 52], [8482, 65, 55],
                    [8483, 67, 58], [8484, 82, 64], [8485, 90, 74], [8486, 40, 35], [8487, 78, 58], [8488, 60, 57],
                    [8489, 38, 66], [8490, 82, 64], [8491, 70, 72], [8492, 72, 57], [8493, 95, 58], [8494, 38, 33],
                    [8495, 106, 109], [8496, 43, 58], [8497, 70, 75], [8498, 47, 58], [8499, 61, 58], [8500, 97, 59],
                    [8501, 65, 80], [8502, 100, 59], [8503, 97, 73], [8504, 61, 60], [8505, 98, 74], [8506, 99, 74],
                    [8507, 99, 75], [8508, 48, 52], [8509, 60, 58], [8510, 105, 73], [8511, 95, 72], [8512, 65, 63],
                    [8513, 72, 70], [8514, 74, 72], [8515, 61, 60], [8516, 170, 92], [8517, 80, 32], [8518, 99, 95],
                    [8519, 44, 43], [8520, 68, 58], [8521, 60, 58], [8522, 63, 59], [8523, 61, 58], [8524, 60, 57],
                    [8525, 80, 58], [8526, 96, 73], [8527, 84, 86], [8528, 101, 83], [8529, 105, 82], [8530, 42, 41],
                    [8531, 96, 93], [8532, 81, 86], [8533, 98, 93], [8534, 67, 68], [8535, 93, 96], [8536, 25, 55],
                    [8537, 65, 42], [8538, 65, 42], [8539, 55, 47], [8540, 45, 80], [8541, 56, 88], [8542, 52, 85],
                    [8543, 30, 81], [8544, 35, 88], [8546, 42, 80], [8547, 42, 86], [8548, 16, 22], [8549, 26, 35],
                    [8550, 21, 33], [8551, 40, 33], [8552, 35, 44], [8553, 53, 74], [8554, 24, 21], [8555, 43, 41],
                    [8556, 49, 72], [8557, 71, 70], [8558, 33, 37], [8559, 44, 44], [8560, 34, 41], [8561, 25, 33],
                    [8562, 41, 42], [8563, 53, 59], [8564, 108, 86], [8565, 10, 13], [8566, 16, 15], [8567, 24, 23],
                    [8568, 18, 17], [8569, 18, 16], [8570, 10, 10], [8571, 14, 11], [8572, 15, 11], [8573, 13, 11],
                    [8574, 15, 13], [8575, 10, 10], [8576, 23, 17], [8577, 19, 17], [8578, 25, 25], [8579, 20, 22],
                    [8580, 18, 18], [8581, 12, 10], [8582, 19, 18], [8583, 20, 19], [8584, 15, 15], [8585, 13, 13],
                    [8586, 25, 20], [8587, 11, 9], [8588, 25, 15], [8589, 14, 13], [8590, 25, 16], [8591, 21, 17],
                    [8592, 35, 36], [8593, 29, 29], [8594, 30, 29], [8595, 14, 13], [8596, 15, 16], [8597, 22, 13],
                    [8598, 18, 12], [8599, 15, 13], [8600, 25, 16], [8601, 34, 25], [8602, 34, 23], [8603, 20, 17],
                    [8604, 23, 20], [8605, 20, 19], [8606, 26, 18], [8607, 20, 18], [8608, 25, 22], [8609, 30, 22],
                    [8610, 27, 20], [8611, 21, 15], [8612, 25, 17], [8613, 15, 12], [8614, 20, 15], [8615, 13, 13],
                    [8616, 25, 18], [8617, 36, 16], [8618, 21, 13], [8619, 26, 15], [8622, 50, 35], [8623, 54, 36],
                    [8624, 19, 14], [8625, 39, 34], [8626, 28, 19], [8627, 30, 24], [8628, 39, 31], [8629, 40, 31],
                    [8630, 27, 19], [8631, 34, 23], [8632, 25, 18], [8633, 28, 21], [8634, 15, 11], [8635, 18, 12],
                    [8636, 12, 10], [8637, 18, 15], [8638, 18, 13], [8639, 21, 13], [8640, 28, 21], [8641, 49, 22],
                    [8642, 31, 27], [8643, 35, 34], [8644, 36, 29], [8645, 26, 23], [8646, 33, 24], [8647, 21, 16],
                    [8648, 20, 15], [8649, 28, 24], [8650, 41, 19], [8651, 39, 27], [8652, 54, 36], [8653, 34, 31],
                    [8654, 45, 37], [8655, 25, 26], [8656, 25, 21], [8657, 10, 8], [8658, 16, 13], [8659, 37, 19],
                    [8660, 16, 13], [8661, 19, 13], [8662, 23, 14], [8663, 25, 15], [8664, 32, 23], [8665, 53, 37],
                    [8666, 23, 23], [8667, 26, 23], [8668, 24, 32], [8669, 48, 45], [8670, 21, 24], [8671, 30, 33],
                    [8672, 16, 21], [8673, 29, 28], [8674, 29, 21], [8675, 39, 23], [8676, 51, 35], [8677, 59, 35],
                    [8678, 48, 25], [8679, 55, 23], [8680, 28, 22], [8681, 44, 28], [8682, 49, 25], [8683, 48, 15],
                    [8684, 33, 25], [8685, 24, 21], [8686, 24, 21], [8687, 35, 22], [8688, 47, 29], [8689, 40, 27],
                    [8690, 54, 27], [8691, 27, 30], [8692, 57, 32], [8693, 45, 15], [8694, 52, 27], [8695, 16, 17],
                    [8696, 21, 22], [8697, 21, 17], [8698, 23, 19], [8699, 29, 19], [8700, 30, 18], [8701, 35, 18],
                    [8702, 34, 21], [8703, 29, 26], [8704, 39, 30], [8705, 33, 21], [8706, 42, 22], [8707, 25, 26],
                    [8708, 38, 29], [8709, 45, 23], [8710, 43, 23], [8711, 14, 13], [8712, 26, 24], [8713, 40, 24],
                    [8714, 8, 8], [8715, 10, 8], [8716, 12, 9], [8717, 14, 13], [8718, 14, 11], [8719, 23, 25],
                    [8720, 30, 33], [8721, 30, 33], [8722, 28, 26], [8723, 30, 29], [8724, 29, 28], [8725, 25, 22],
                    [8726, 28, 24], [8727, 25, 25], [8728, 22, 23], [8729, 27, 23], [8730, 21, 18], [8731, 22, 21],
                    [8732, 28, 22], [8733, 29, 22], [8734, 25, 20], [8735, 22, 19], [8736, 22, 22], [8737, 22, 19],
                    [8738, 24, 20], [8739, 24, 21], [8740, 24, 20], [8741, 28, 22], [8742, 25, 23], [8743, 25, 21],
                    [8744, 25, 22], [8745, 29, 21], [8746, 31, 24], [8747, 32, 25], [8748, 33, 26], [8749, 27, 22],
                    [8750, 25, 27], [8751, 25, 28], [8752, 20, 18], [8753, 21, 19], [8754, 21, 23], [8755, 22, 21],
                    [8756, 34, 25], [8757, 21, 19], [8758, 21, 21], [8759, 25, 24], [8760, 34, 36], [8761, 26, 21],
                    [8762, 33, 22], [8763, 19, 18], [8764, 35, 28], [8765, 29, 21], [8766, 29, 23], [8767, 35, 27],
                    [8768, 34, 26], [8769, 22, 22], [8770, 35, 27], [8771, 37, 29], [8772, 35, 28], [8773, 20, 18],
                    [8774, 21, 21], [8775, 22, 19], [8776, 21, 21], [8777, 26, 21], [8778, 37, 28], [8779, 10, 15],
                    [8780, 14, 11], [8781, 16, 11], [8782, 17, 12], [8783, 11, 8], [8784, 14, 10], [8785, 8, 7],
                    [8786, 10, 11], [8787, 12, 12], [8788, 14, 11], [8790, 8, 7], [8791, 7, 6], [8792, 13, 12],
                    [8793, 8, 8], [8794, 8, 7], [8795, 9, 8], [8796, 15, 11], [8797, 17, 11], [8798, 9, 9],
                    [8799, 12, 10], [8800, 11, 8], [8801, 13, 11], [8802, 8, 7], [8803, 9, 9], [8804, 7, 11],
                    [8805, 10, 9], [8806, 10, 11], [8807, 15, 15], [8808, 8, 8], [8809, 6, 7], [8810, 12, 12],
                    [8811, 8, 9], [8812, 13, 11], [8814, 7, 7], [8815, 9, 9], [8816, 13, 8], [8817, 19, 11],
                    [8818, 56, 46], [8819, 41, 25], [8820, 63, 53], [8821, 53, 35], [8822, 64, 54], [8823, 34, 29],
                    [8824, 24, 20], [8825, 38, 33], [8826, 24, 24], [8827, 43, 33], [8828, 46, 37], [8829, 47, 37],
                    [8830, 31, 35], [8831, 38, 33], [8832, 20, 11], [8833, 37, 32], [8834, 42, 36], [8835, 37, 21],
                    [8836, 55, 45], [8837, 36, 21], [8838, 47, 41], [8839, 29, 14], [8840, 42, 28], [8841, 29, 14],
                    [8842, 17, 23], [8843, 21, 12], [8844, 29, 24], [8845, 15, 19], [8846, 38, 33], [8847, 20, 23],
                    [8848, 55, 45], [8849, 34, 27], [8850, 42, 37], [8851, 26, 28], [8852, 38, 29], [8853, 14, 19],
                    [8854, 38, 33], [8855, 21, 11], [8856, 34, 28], [8857, 26, 13], [8858, 34, 15], [8859, 51, 46],
                    [8860, 36, 12], [8861, 38, 33], [8862, 28, 24], [8863, 43, 37], [8864, 22, 23], [8865, 34, 29],
                    [8866, 22, 23], [8867, 60, 54], [8868, 42, 37], [8869, 56, 51], [8870, 51, 42], [8871, 41, 36],
                    [8872, 30, 27], [8873, 45, 40], [8874, 38, 32], [8875, 38, 33], [8876, 21, 18], [8877, 47, 42],
                    [8878, 19, 11], [8879, 33, 28], [8880, 34, 28], [8881, 62, 52], [8882, 36, 31], [8883, 56, 50],
                    [8884, 20, 18], [8885, 69, 44], [8886, 38, 33], [8887, 22, 12], [8888, 35, 25], [8889, 51, 42],
                    [8890, 14, 19], [8891, 38, 33], [8892, 14, 11], [8893, 38, 33], [8894, 20, 19], [8895, 15, 11],
                    [8896, 29, 24], [8897, 15, 11], [8898, 22, 21], [8899, 58, 52], [8900, 43, 37], [8901, 55, 34],
                    [8902, 38, 33], [8903, 28, 17], [8904, 38, 33], [8905, 27, 17], [8906, 33, 28], [8907, 24, 22],
                    [8908, 34, 29], [8909, 25, 22], [8910, 26, 13], [8911, 26, 13], [8912, 47, 42], [8913, 31, 27],
                    [8914, 46, 41], [8915, 31, 27], [8916, 55, 45], [8917, 43, 27], [8918, 51, 46], [8919, 39, 37],
                    [8920, 40, 38], [8921, 40, 38], [8922, 33, 28], [8923, 26, 21], [8924, 16, 16], [8925, 12, 12],
                    [8926, 16, 14], [8927, 19, 17], [8928, 15, 14], [8929, 11, 10], [8930, 9, 11], [8931, 15, 17],
                    [8932, 21, 22], [8933, 30, 28], [8934, 30, 30], [8935, 55, 46], [8936, 29, 21], [8937, 38, 33],
                    [8938, 29, 21], [8939, 34, 29], [8940, 20, 18], [8941, 33, 28], [8942, 20, 18], [8943, 31, 22],
                    [8944, 34, 29], [8945, 25, 14], [8946, 34, 29], [8947, 25, 14], [8948, 34, 29], [8949, 25, 14],
                    [8950, 25, 21], [8951, 34, 29], [8952, 25, 21], [8953, 56, 50], [8954, 31, 21], [8955, 47, 42],
                    [8956, 33, 28], [8957, 31, 21], [8958, 56, 47], [8959, 32, 22], [8960, 56, 46], [8961, 31, 22],
                    [8962, 51, 46], [8963, 34, 33], [8964, 21, 12], [8965, 51, 45], [8966, 43, 34], [8967, 47, 37],
                    [8968, 33, 28], [8969, 22, 14], [8970, 47, 41], [8971, 47, 37], [8972, 21, 14], [8973, 47, 38],
                    [8974, 14, 20], [8975, 55, 45], [8976, 59, 54], [8977, 29, 24], [8978, 14, 11], [8979, 43, 37],
                    [8980, 34, 28], [8981, 33, 28], [8983, 38, 33], [8984, 27, 22], [8985, 38, 33], [8986, 27, 22],
                    [8987, 29, 29], [8988, 19, 13], [8989, 38, 33], [8990, 20, 13], [8991, 38, 32], [8992, 19, 13],
                    [8993, 42, 31], [8994, 45, 31], [8995, 44, 32], [8996, 55, 46], [8997, 25, 14], [8998, 29, 24],
                    [8999, 21, 11], [9000, 63, 53], [9001, 54, 34], [9002, 46, 37], [9003, 26, 24], [9004, 56, 46],
                    [9005, 25, 21], [9006, 38, 33], [9007, 31, 22], [9008, 45, 28], [9009, 37, 28], [9010, 29, 24],
                    [9011, 21, 11], [9012, 29, 28], [9013, 14, 14], [9014, 46, 37], [9015, 23, 16], [9016, 22, 16],
                    [9017, 47, 37], [9018, 31, 34], [9019, 37, 36], [9020, 20, 25], [9021, 38, 33], [9022, 26, 28],
                    [9023, 39, 31], [9024, 46, 37], [9025, 34, 29], [9026, 38, 20], [9027, 34, 19], [9028, 46, 37],
                    [9030, 50, 37], [9031, 42, 31], [9032, 50, 37], [9033, 34, 33], [9034, 55, 45], [9035, 46, 41],
                    [9036, 42, 37], [9037, 19, 15], [9038, 29, 29], [9039, 15, 22], [9040, 42, 37], [9041, 28, 23],
                    [9042, 46, 37], [9043, 38, 33], [9044, 29, 14], [9045, 38, 28], [9046, 32, 23], [9047, 42, 32],
                    [9048, 36, 25], [9049, 68, 42], [9050, 34, 23], [9051, 47, 38], [9052, 22, 20], [9053, 31, 22],
                    [9054, 34, 24], [9055, 26, 14], [9056, 38, 25], [9057, 51, 33], [9058, 31, 22], [9059, 56, 37],
                    [9060, 50, 34], [9061, 25, 20], [9062, 14, 15], [9063, 38, 29], [9064, 14, 20], [9065, 25, 24],
                    [9066, 18, 20], [9067, 34, 24], [9068, 31, 20], [9069, 38, 45], [9070, 14, 14], [9071, 29, 37],
                    [9072, 14, 18], [9073, 14, 18], [9074, 33, 32], [9075, 25, 29], [9076, 25, 28], [9077, 38, 24],
                    [9078, 31, 18], [9079, 51, 42], [9080, 23, 20], [9081, 35, 27], [9082, 56, 37], [9083, 26, 22],
                    [9084, 33, 24], [9085, 21, 23], [9086, 42, 33], [9087, 47, 33], [9088, 35, 19], [9089, 18, 15],
                    [9090, 25, 20], [9091, 26, 17], [9092, 51, 33], [9093, 24, 22], [9094, 55, 53], [9095, 14, 12],
                    [9096, 29, 36], [9097, 38, 25], [9098, 42, 27], [9099, 21, 11], [9100, 45, 28], [9101, 14, 14],
                    [9102, 45, 36], [9103, 33, 33], [9104, 42, 33], [9105, 19, 13], [9106, 25, 13], [9107, 38, 28],
                    [9108, 38, 29], [9109, 43, 31], [9110, 51, 33], [9111, 29, 14], [9112, 56, 46], [9113, 27, 22],
                    [9114, 34, 29], [9115, 14, 11], [9116, 20, 15], [9117, 35, 13], [9118, 54, 36], [9119, 19, 13],
                    [9120, 29, 24], [9121, 37, 32], [9122, 46, 41], [9123, 34, 21], [9124, 43, 33], [9125, 19, 28],
                    [9126, 50, 44], [9127, 33, 24], [9128, 38, 29], [9129, 53, 41], [9130, 60, 47], [9131, 31, 32],
                    [9132, 55, 50], [9133, 31, 21], [9134, 38, 29], [9135, 57, 40], [9136, 50, 35], [9137, 20, 15],
                    [9138, 17, 11], [9139, 36, 32], [9140, 47, 42], [9141, 31, 27], [9142, 56, 47], [9143, 21, 23],
                    [9144, 25, 29], [9145, 42, 36], [9146, 50, 40], [9149, 21, 18], [9150, 25, 28], [9151, 20, 19],
                    [9152, 31, 32], [9153, 15, 20], [9154, 18, 18], [9155, 27, 31], [9156, 32, 30], [9157, 35, 39],
                    [9158, 13, 17], [9159, 24, 35], [9160, 15, 15], [9161, 20, 22], [9162, 31, 35], [9163, 33, 27],
                    [9164, 23, 22], [9165, 22, 48], [9166, 27, 30], [9167, 20, 23], [9168, 34, 38], [9169, 23, 23],
                    [9170, 32, 41], [9171, 20, 19], [9172, 23, 29], [9173, 25, 35], [9174, 18, 19], [9175, 21, 24],
                    [9176, 12, 12], [9177, 28, 25], [9178, 24, 40], [9179, 26, 37], [9180, 12, 16], [9181, 20, 19],
                    [9182, 30, 40], [9183, 26, 25], [9184, 30, 32], [9185, 23, 24], [9186, 19, 23], [9187, 27, 26],
                    [9188, 29, 33], [9189, 25, 26], [9190, 18, 22], [9191, 23, 22], [9192, 25, 28], [9193, 20, 19],
                    [9194, 34, 21], [9195, 40, 49], [9196, 31, 32], [9197, 43, 28], [9198, 39, 29], [9199, 70, 45],
                    [9200, 49, 58], [9201, 65, 38], [9202, 50, 48], [9203, 13, 22], [9204, 12, 16], [9205, 32, 31],
                    [9206, 20, 25], [9207, 34, 38], [9208, 49, 49], [9209, 34, 30], [9210, 60, 50], [9211, 30, 37],
                    [9212, 53, 52], [9213, 80, 70], [9214, 51, 47], [9215, 20, 28], [9216, 75, 76], [9217, 67, 50],
                    [9218, 29, 27], [9219, 53, 60], [9220, 39, 36], [9221, 32, 37], [9222, 50, 59], [9223, 46, 59],
                    [9224, 63, 48], [9225, 50, 41], [9226, 74, 48], [9227, 76, 60], [9228, 79, 81], [9229, 57, 60],
                    [9230, 43, 42], [9231, 83, 67], [9232, 54, 46], [9233, 46, 44], [9234, 30, 38], [9235, 45, 50],
                    [9236, 26, 21], [9237, 44, 25], [9238, 45, 60], [9239, 66, 79], [9240, 45, 51], [9241, 34, 49],
                    [9242, 51, 43], [9243, 64, 60], [9244, 50, 47], [9245, 25, 32], [9246, 37, 30], [9247, 57, 44],
                    [9248, 47, 35], [9249, 31, 23], [9250, 35, 23], [9251, 38, 33], [9252, 21, 29], [9253, 96, 70],
                    [9254, 110, 127], [9255, 55, 38], [9257, 93, 86], [9258, 49, 73], [9259, 77, 77], [9260, 62, 46],
                    [9261, 102, 132], [9263, 66, 74], [9264, 64, 70], [9265, 67, 74], [9266, 105, 132], [9267, 77, 80],
                    [9268, 69, 77], [9269, 107, 121], [9270, 105, 132], [9271, 106, 134], [9272, 108, 137],
                    [9273, 114, 145], [9274, 94, 92], [9275, 80, 76], [9276, 97, 92], [9277, 103, 85], [9278, 92, 93],
                    [9279, 92, 89], [9280, 78, 77], [9281, 93, 88], [9282, 110, 100], [9283, 106, 122],
                    [9284, 115, 144], [9285, 92, 119], [9286, 112, 142], [9287, 113, 141], [9288, 63, 48],
                    [9289, 117, 140], [9290, 99, 119], [9291, 110, 135], [9292, 109, 135], [9293, 72, 52],
                    [9294, 78, 78], [9295, 91, 89], [9296, 70, 51], [9297, 82, 58], [9298, 91, 120], [9299, 102, 134],
                    [9300, 111, 138], [9301, 97, 124], [9302, 114, 141], [9303, 113, 145], [9304, 60, 86],
                    [9305, 99, 127], [9306, 114, 146], [9307, 52, 76], [9308, 59, 86], [9309, 63, 80], [9310, 72, 88],
                    [9311, 66, 82], [9312, 72, 88], [9313, 66, 81], [9314, 76, 94], [9315, 47, 47], [9316, 30, 30],
                    [9317, 13, 15], [9318, 15, 19], [9319, 45, 52], [9320, 70, 70], [9327, 14, 19], [9328, 29, 35],
                    [9329, 40, 50], [9330, 54, 62], [9331, 38, 38], [9332, 34, 40], [9333, 14, 17], [9334, 12, 15],
                    [9335, 39, 39], [9336, 32, 39], [9337, 22, 27], [9338, 14, 16], [9339, 19, 24], [9340, 55, 64],
                    [9341, 29, 34], [9342, 38, 38], [9343, 9, 11], [9344, 22, 26], [9345, 22, 27], [9346, 16, 19],
                    [9347, 12, 16], [9348, 23, 26], [9349, 19, 23], [9350, 56, 66], [9351, 40, 39], [9352, 44, 44],
                    [9353, 22, 26], [9354, 31, 31], [9355, 20, 20], [9356, 38, 45], [9357, 22, 25], [9358, 29, 28],
                    [9359, 23, 23], [9360, 34, 41], [9361, 31, 37], [9362, 40, 39], [9363, 35, 41], [9364, 46, 35],
                    [9365, 21, 26], [9366, 36, 42], [9367, 23, 22], [9368, 35, 35], [9369, 37, 37], [9370, 19, 22],
                    [9371, 35, 35], [9372, 30, 29], [9373, 25, 25], [9374, 45, 45], [9375, 26, 31], [9376, 50, 50],
                    [9377, 15, 21], [9378, 21, 25], [9379, 38, 47], [9380, 35, 42], [9381, 70, 84], [9382, 41, 48],
                    [9383, 44, 44], [9384, 22, 26], [9385, 27, 32], [9386, 25, 29], [9387, 20, 23], [9388, 20, 27],
                    [9389, 22, 26], [9390, 23, 28], [9391, 26, 31], [9392, 25, 29], [9393, 27, 27], [9394, 20, 24],
                    [9395, 28, 33], [9396, 29, 36], [9397, 56, 66], [9398, 51, 61], [9399, 75, 87], [9400, 32, 39],
                    [9401, 48, 47], [9402, 49, 38], [9403, 116, 87], [9404, 116, 86], [9405, 117, 87], [9406, 111, 87],
                    [9407, 70, 68], [9408, 117, 87], [9409, 115, 86], [9410, 117, 87], [9411, 115, 85], [9412, 115, 86],
                    [9413, 117, 87], [9414, 116, 86], [9415, 117, 87], [9416, 111, 84], [9417, 117, 87],
                    [9418, 114, 83], [9419, 115, 87], [9420, 116, 86], [9421, 114, 83], [9422, 115, 87],
                    [9423, 111, 83], [9424, 116, 86], [9425, 117, 87], [9426, 115, 87], [9427, 117, 87],
                    [9428, 115, 85], [9429, 115, 86], [9430, 117, 87], [9431, 115, 86], [9432, 67, 65], [9433, 111, 83],
                    [9434, 115, 86], [9435, 117, 87], [9436, 115, 86], [9437, 116, 86], [9438, 117, 87],
                    [9439, 115, 85], [9440, 117, 87], [9441, 115, 87], [9442, 117, 87], [9443, 116, 86],
                    [9444, 115, 85], [9445, 115, 86], [9446, 117, 87], [9447, 115, 86], [9448, 117, 87], [9449, 93, 72],
                    [9450, 111, 83], [9451, 111, 87], [9452, 115, 86], [9453, 115, 86], [9454, 115, 86],
                    [9455, 117, 87], [9456, 116, 86], [9457, 111, 87], [9458, 116, 86], [9459, 115, 86],
                    [9460, 117, 87], [9461, 115, 86], [9462, 117, 87], [9463, 85, 83], [9464, 85, 83], [9465, 67, 65],
                    [9466, 115, 86], [9467, 116, 86], [9468, 116, 68], [9469, 117, 87], [9470, 115, 85],
                    [9471, 159, 95], [9472, 190, 180], [9473, 52, 91], [9474, 85, 139], [9475, 120, 106],
                    [9476, 120, 200], [9477, 38, 54], [9478, 60, 83], [9479, 84, 93], [9480, 125, 139], [9481, 27, 79],
                    [9482, 42, 123], [9483, 120, 90], [9484, 168, 83], [9485, 76, 50], [9486, 100, 80], [9487, 27, 55],
                    [9488, 47, 82], [9489, 111, 83], [9490, 110, 107], [9491, 47, 80], [9492, 77, 91], [9493, 120, 100],
                    [9494, 127, 138], [9495, 47, 46], [9496, 85, 57], [9497, 44, 31], [9498, 74, 50], [9499, 67, 83],
                    [9500, 111, 123], [9501, 70, 119], [9502, 120, 200], [9503, 67, 57], [9504, 84, 68],
                    [9505, 67, 108], [9506, 111, 174], [9507, 78, 83], [9508, 110, 158], [9509, 111, 77],
                    [9510, 111, 113], [9511, 67, 66], [9512, 67, 110], [9513, 80, 84], [9514, 111, 126], [9515, 70, 70],
                    [9516, 120, 104], [9517, 111, 91], [9518, 145, 142], [9519, 34, 39], [9520, 56, 64],
                    [9521, 67, 170], [9522, 104, 200], [9523, 111, 91], [9524, 138, 149], [9525, 32, 42],
                    [9526, 49, 63], [9527, 85, 86], [9528, 110, 117], [9529, 46, 55], [9530, 73, 83], [9531, 46, 63],
                    [9532, 55, 99], [9533, 111, 116], [9534, 161, 157], [9535, 38, 94], [9536, 65, 164],
                    [9537, 130, 90], [9538, 180, 145], [9539, 64, 63], [9540, 85, 98], [9541, 46, 45], [9542, 71, 69],
                    [9543, 38, 49], [9544, 60, 76], [9545, 67, 65], [9546, 76, 91], [9547, 41, 52], [9548, 68, 85],
                    [9549, 35, 36], [9550, 54, 65], [9551, 38, 59], [9552, 58, 97], [9553, 47, 55], [9554, 67, 83],
                    [9555, 64, 144], [9556, 101, 173], [9557, 38, 63], [9558, 67, 99], [9559, 44, 46], [9560, 59, 70],
                    [9561, 46, 72], [9562, 72, 112], [9563, 63, 141], [9564, 103, 174], [9565, 67, 65], [9566, 74, 106],
                    [9567, 61, 80], [9568, 79, 129], [9569, 111, 108], [9570, 143, 149], [9571, 95, 180],
                    [9572, 145, 200], [9573, 85, 83], [9574, 111, 135], [9575, 74, 82], [9576, 124, 137],
                    [9577, 120, 81], [9578, 155, 140], [9579, 45, 108], [9580, 66, 141], [9581, 49, 65], [9582, 59, 86],
                    [9583, 111, 146], [9584, 170, 174], [9585, 111, 74], [9586, 119, 87], [9587, 64, 63],
                    [9588, 66, 84], [9589, 35, 80], [9590, 54, 123], [9591, 67, 57], [9592, 73, 65], [9593, 38, 58],
                    [9594, 60, 103], [9595, 43, 59], [9596, 72, 90], [9597, 29, 29], [9598, 39, 56], [9599, 111, 74],
                    [9600, 111, 83], [9601, 49, 83], [9602, 99, 155], [9603, 64, 83], [9604, 97, 108], [9605, 64, 46],
                    [9606, 67, 55], [9607, 57, 71], [9608, 90, 83], [9609, 42, 47], [9610, 54, 65], [9611, 47, 55],
                    [9612, 67, 74], [9613, 70, 142], [9614, 107, 174], [9615, 55, 48], [9616, 89, 78], [9617, 23, 31],
                    [9618, 67, 65], [9619, 36, 48], [9620, 36, 48], [9621, 40, 74], [9622, 54, 82], [9623, 67, 57],
                    [9624, 67, 65], [9625, 111, 83], [9626, 110, 114], [9627, 67, 48], [9628, 85, 65], [9629, 47, 57],
                    [9630, 85, 78], [9631, 47, 48], [9632, 60, 77], [9633, 63, 79], [9634, 107, 150], [9635, 152, 141],
                    [9636, 178, 174], [9637, 79, 85], [9638, 118, 127], [9639, 23, 32], [9640, 38, 65], [9641, 64, 50],
                    [9642, 76, 82], [9643, 29, 54], [9644, 46, 86], [9645, 67, 130], [9646, 77, 174], [9647, 111, 83],
                    [9648, 127, 157], [9651, 71, 70], [9652, 93, 92], [9653, 60, 55], [9654, 99, 76], [9655, 49, 49],
                    [9656, 82, 81], [9657, 62, 61], [9658, 76, 67], [9659, 53, 45], [9660, 78, 77], [9661, 43, 43],
                    [9662, 76, 74], [9663, 47, 43], [9664, 78, 72], [9665, 67, 66], [9666, 82, 81], [9667, 56, 50],
                    [9668, 82, 71], [9669, 50, 50], [9670, 70, 70], [9671, 49, 50], [9672, 93, 81], [9673, 53, 53],
                    [9674, 70, 70], [9675, 60, 61], [9676, 110, 83], [9677, 52, 50], [9678, 77, 73], [9679, 50, 52],
                    [9680, 77, 76], [9681, 67, 55], [9682, 88, 81], [9683, 64, 59], [9684, 84, 81], [9685, 61, 60],
                    [9686, 85, 82], [9687, 57, 50], [9688, 85, 82], [9689, 88, 89], [9690, 86, 83], [9691, 55, 49],
                    [9692, 82, 73], [9693, 70, 54], [9694, 110, 73], [9695, 43, 43], [9696, 77, 73], [9697, 48, 44],
                    [9698, 100, 67], [9699, 43, 49], [9700, 80, 81], [9701, 46, 46], [9702, 61, 59], [9703, 40, 41],
                    [9704, 82, 79], [9705, 41, 41], [9706, 89, 85], [9707, 60, 49], [9708, 76, 59], [9709, 50, 50],
                    [9710, 60, 58], [9711, 108, 81], [9712, 107, 84], [9713, 108, 81], [9714, 105, 79], [9715, 103, 78],
                    [9716, 55, 45], [9717, 70, 60], [9718, 49, 46], [9719, 76, 73], [9720, 101, 75], [9721, 94, 83],
                    [9722, 43, 43], [9723, 90, 87], [9724, 75, 72], [9725, 95, 87], [9726, 29, 37], [9727, 69, 67],
                    [9728, 60, 58], [9729, 69, 66], [9730, 35, 35], [9731, 100, 75], [9735, 71, 61], [9736, 58, 58],
                    [9737, 58, 52], [9738, 121, 84], [9739, 74, 72], [9740, 80, 78], [9741, 81, 73], [9742, 78, 70],
                    [9743, 59, 50], [9744, 110, 80], [9745, 68, 67], [9746, 71, 71], [9747, 68, 66], [9748, 56, 59],
                    [9751, 49, 43], [9752, 60, 55], [9753, 46, 46], [9754, 78, 78], [9755, 49, 49], [9756, 87, 84],
                    [9757, 48, 48], [9758, 70, 68], [9759, 25, 15], [9760, 55, 33], [9761, 57, 35], [9762, 51, 22],
                    [9763, 27, 18], [9764, 34, 15], [9765, 59, 35], [9766, 52, 26], [9767, 51, 60], [9768, 46, 30],
                    [9769, 29, 21], [9770, 58, 51], [9771, 69, 27], [9772, 38, 17], [9773, 55, 41], [9774, 29, 23],
                    [9775, 29, 21], [9776, 38, 16], [9777, 59, 35], [9778, 57, 38], [9779, 51, 36], [9780, 54, 42],
                    [9781, 38, 19], [9782, 57, 39], [9783, 46, 26], [9784, 46, 38], [9785, 35, 29], [9786, 28, 20],
                    [9787, 54, 35], [9788, 27, 21], [9789, 59, 26], [9790, 54, 32], [9791, 69, 41], [9792, 57, 50],
                    [9793, 21, 15], [9794, 17, 16], [9795, 17, 15], [9796, 26, 20], [9797, 21, 15], [9798, 17, 16],
                    [9799, 66, 54], [9800, 32, 27], [9801, 26, 20], [9802, 26, 20], [9803, 12, 10], [9804, 24, 18],
                    [9805, 50, 35], [9806, 32, 23], [9807, 41, 24], [9808, 120, 70], [9809, 60, 20], [9811, 64, 33],
                    [9812, 120, 65], [9813, 90, 35], [9814, 32, 17], [9815, 65, 33], [9816, 47, 18], [9817, 40, 16],
                    [9818, 90, 24], [9819, 81, 54], [9820, 99, 57], [9821, 70, 37], [9822, 29, 24], [9823, 40, 25],
                    [9824, 42, 33], [9825, 29, 22], [9826, 81, 53], [9827, 73, 38], [9828, 81, 52], [9829, 63, 37],
                    [9830, 48, 35], [9831, 61, 34], [9832, 47, 29], [9833, 50, 33], [9834, 88, 54], [9835, 48, 42],
                    [9836, 73, 50], [9837, 44, 27], [9838, 81, 59], [9839, 22, 19], [9840, 66, 47], [9841, 130, 71],
                    [9842, 45, 25], [9843, 40, 28], [9844, 53, 32], [9845, 43, 36], [9846, 40, 23], [9847, 19, 16],
                    [9848, 35, 22], [9849, 35, 20], [9850, 35, 15], [9851, 31, 15], [9852, 29, 15], [9853, 32, 21],
                    [9854, 18, 15], [9855, 43, 35], [9856, 21, 22], [9857, 21, 16], [9858, 65, 39], [9859, 82, 48],
                    [9860, 69, 50], [9861, 81, 70], [9862, 41, 45], [9863, 66, 45], [9864, 81, 30], [9865, 52, 30],
                    [9866, 81, 30], [9867, 31, 21], [9868, 69, 42], [9869, 63, 35], [9870, 53, 65], [9871, 69, 39],
                    [9872, 35, 30], [9873, 50, 47], [9874, 64, 28], [9875, 49, 32], [9876, 35, 30], [9877, 51, 39],
                    [9878, 62, 35], [9879, 54, 30], [9880, 59, 45], [9881, 80, 41], [9882, 59, 45], [9883, 52, 28],
                    [9884, 50, 25], [9885, 65, 30], [9886, 62, 29], [9887, 53, 35], [9888, 69, 50], [9889, 69, 40],
                    [9890, 61, 40], [9891, 51, 31], [9892, 42, 31], [9893, 32, 23], [9894, 68, 44], [9895, 30, 18],
                    [9896, 13, 16], [9897, 51, 31], [9898, 53, 40], [9899, 36, 27], [9900, 90, 79], [9901, 82, 50],
                    [9902, 131, 95], [9903, 110, 65], [9904, 96, 67], [9905, 61, 45], [9906, 62, 34], [9907, 43, 39],
                    [9908, 95, 60], [9909, 21, 18], [9910, 88, 72], [9911, 129, 67], [9912, 79, 45], [9913, 32, 26],
                    [9914, 45, 33], [9915, 45, 37], [9916, 45, 40], [9917, 42, 37], [9918, 124, 40], [9919, 111, 91],
                    [9920, 133, 92], [9921, 35, 27], [9922, 40, 21], [9923, 44, 27], [9924, 70, 34], [9925, 80, 76],
                    [9926, 60, 76], [9927, 45, 29], [9928, 86, 42], [9929, 70, 60], [9930, 60, 37], [9931, 81, 46],
                    [9932, 80, 37], [9933, 75, 57], [9934, 76, 40], [9935, 59, 30], [9936, 64, 40], [9937, 40, 37],
                    [9938, 23, 20], [9939, 66, 30], [9940, 52, 45], [9941, 55, 28], [9942, 29, 22], [9943, 173, 93],
                    [9944, 76, 36], [9945, 108, 43], [9946, 51, 24], [9947, 76, 36], [9948, 142, 65], [9949, 128, 73],
                    [9950, 101, 70], [9951, 47, 29], [9952, 76, 35], [9953, 39, 29], [9954, 100, 65], [9955, 37, 30],
                    [9956, 87, 35], [9957, 137, 62], [9958, 41, 31], [9959, 119, 57], [9960, 82, 36], [9961, 38, 37],
                    [9962, 49, 31], [9963, 90, 54], [9964, 46, 43], [9965, 43, 20], [9966, 88, 42], [9967, 105, 47],
                    [9968, 59, 52], [9969, 57, 31], [9970, 76, 35], [9971, 51, 36], [9972, 155, 61], [9973, 65, 50],
                    [9974, 42, 18], [9975, 121, 48], [9976, 155, 61], [9977, 55, 25], [9978, 60, 26], [9979, 137, 57],
                    [9980, 69, 29], [9981, 41, 23], [9982, 23, 16], [9983, 120, 45], [9984, 62, 34], [9985, 62, 33],
                    [9986, 67, 36], [9987, 69, 57], [9988, 63, 37], [9989, 51, 39], [9990, 38, 22], [9991, 64, 44],
                    [9992, 63, 47], [9993, 45, 51], [9994, 42, 36], [9995, 59, 47], [9996, 50, 42], [9997, 22, 30],
                    [9998, 25, 20], [9999, 40, 45], [10000, 32, 20], [10001, 26, 19], [10002, 23, 18], [10003, 68, 36],
                    [10004, 25, 21], [10005, 25, 20], [10006, 19, 15], [10007, 47, 54], [10008, 63, 63],
                    [10009, 65, 46], [10010, 77, 42], [10011, 58, 40], [10012, 84, 36], [10013, 41, 39],
                    [10014, 53, 61], [10015, 41, 39], [10016, 45, 52], [10017, 53, 46], [10018, 57, 52],
                    [10019, 56, 49], [10020, 71, 60], [10021, 92, 60], [10022, 73, 60], [10023, 84, 61],
                    [10024, 106, 74], [10025, 89, 74], [10026, 87, 63], [10027, 84, 67], [10030, 77, 63],
                    [10031, 92, 82], [10032, 102, 77], [10033, 58, 44], [10034, 64, 43], [10035, 116, 60],
                    [10036, 106, 48], [10037, 126, 63], [10038, 37, 24], [10039, 21, 25], [10040, 37, 25],
                    [10041, 34, 21], [10042, 58, 39], [10043, 62, 30], [10044, 71, 30], [10045, 46, 26],
                    [10046, 70, 45], [10047, 66, 36], [10048, 62, 36], [10049, 42, 33], [10050, 58, 40],
                    [10051, 65, 44], [10052, 84, 74], [10053, 95, 79], [10054, 82, 79], [10055, 91, 81],
                    [10056, 76, 77], [10057, 86, 81], [10058, 46, 52], [10059, 99, 57], [10060, 70, 51],
                    [10061, 85, 82], [10063, 24, 28], [10064, 46, 38], [10065, 41, 53], [10066, 56, 51],
                    [10067, 83, 66], [10068, 88, 68], [10069, 84, 67], [10070, 51, 29], [10071, 83, 60],
                    [10072, 80, 29], [10073, 84, 35], [10074, 83, 36], [10075, 98, 51], [10076, 83, 51],
                    [10077, 84, 51], [10078, 102, 63], [10079, 64, 47], [10080, 53, 47], [10081, 100, 63],
                    [10082, 68, 74], [10083, 52, 51], [10084, 58, 40], [10085, 55, 26], [10086, 61, 36],
                    [10087, 55, 25], [10088, 85, 54], [10089, 85, 56], [10090, 67, 54], [10091, 81, 39],
                    [10092, 95, 40], [10093, 63, 54], [10094, 106, 65], [10095, 97, 64], [10096, 83, 50],
                    [10097, 65, 50], [10098, 75, 56], [10099, 88, 62], [10101, 97, 79], [10102, 84, 72],
                    [10103, 85, 82], [10104, 20, 21], [10105, 37, 25], [10106, 37, 36], [10107, 78, 75],
                    [10108, 96, 89], [10109, 143, 90], [10110, 76, 68], [10111, 109, 83], [10112, 115, 93],
                    [10113, 123, 103], [10114, 98, 60], [10115, 56, 41], [10116, 65, 55], [10117, 61, 67],
                    [10118, 66, 75], [10119, 28, 19], [10120, 37, 24], [10121, 93, 83], [10122, 93, 82],
                    [10123, 103, 88], [10124, 89, 87], [10125, 100, 62], [10126, 85, 50], [10127, 84, 54],
                    [10128, 85, 60], [10129, 101, 65], [10130, 93, 63], [10131, 63, 51], [10132, 63, 51],
                    [10133, 85, 50], [10134, 105, 73], [10135, 101, 82], [10136, 69, 34], [10137, 80, 54],
                    [10138, 76, 40], [10139, 73, 47], [10141, 66, 40], [10142, 72, 43], [10144, 94, 47],
                    [10145, 54, 57], [10146, 66, 64], [10148, 69, 36], [10149, 71, 78], [10150, 32, 44],
                    [10151, 55, 53], [10152, 79, 62], [10153, 87, 69], [10154, 35, 35], [10155, 65, 67],
                    [10156, 45, 47], [10157, 86, 64], [10158, 45, 49], [10159, 65, 52], [10160, 69, 44],
                    [10161, 101, 57], [10162, 74, 38], [10163, 98, 46], [10164, 77, 39], [10165, 82, 41],
                    [10166, 61, 36], [10167, 76, 59], [10168, 75, 59], [10169, 85, 61], [10170, 36, 47],
                    [10171, 66, 56], [10172, 50, 45], [10173, 65, 56], [10174, 62, 43], [10175, 84, 57],
                    [10176, 24, 26], [10177, 21, 24], [10178, 28, 27], [10179, 22, 24], [10180, 46, 37],
                    [10181, 28, 20], [10182, 46, 52], [10183, 61, 34], [10184, 61, 21], [10185, 19, 15],
                    [10186, 16, 14], [10187, 25, 19], [10188, 26, 18], [10189, 84, 43], [10190, 27, 17],
                    [10191, 64, 33], [10192, 44, 26], [10193, 25, 23], [10194, 18, 13], [10195, 18, 15],
                    [10196, 48, 34], [10197, 45, 32], [10198, 32, 36], [10199, 31, 36], [10200, 30, 36],
                    [10201, 29, 33], [10202, 73, 64], [10203, 60, 42], [10204, 61, 42], [10205, 52, 38],
                    [10206, 48, 33], [10207, 44, 31], [10208, 48, 35], [10209, 45, 32], [10210, 53, 43],
                    [10211, 51, 40], [10212, 58, 36], [10213, 55, 34], [10214, 48, 43], [10215, 45, 40],
                    [10216, 50, 35], [10217, 53, 38], [10218, 51, 42], [10219, 49, 42], [10220, 47, 39],
                    [10221, 51, 35], [10222, 48, 37], [10223, 62, 51], [10224, 68, 57], [10225, 65, 62],
                    [10226, 34, 34], [10227, 36, 34], [10228, 33, 31], [10234, 66, 52], [10235, 46, 41],
                    [10236, 46, 44], [10237, 43, 42], [10238, 51, 51], [10239, 68, 54], [10240, 44, 46],
                    [10241, 37, 50], [10242, 50, 39], [10243, 51, 43], [10244, 46, 52], [10245, 23, 35],
                    [10246, 40, 37], [10247, 30, 35], [10248, 46, 39], [10249, 30, 39], [10250, 46, 44],
                    [10251, 51, 43], [10252, 46, 44], [10253, 46, 48], [10255, 51, 47], [10256, 54, 52],
                    [10257, 50, 43], [10258, 52, 51], [10259, 23, 38], [10260, 46, 44], [10261, 52, 43],
                    [10263, 30, 38], [10264, 46, 44], [10267, 37, 35], [10268, 52, 39], [10269, 37, 38],
                    [10270, 39, 44], [10271, 46, 36], [10272, 38, 39], [10276, 44, 43], [10277, 53, 48],
                    [10278, 31, 39], [10279, 51, 50], [10280, 30, 46], [10281, 46, 52], [10283, 30, 35],
                    [10284, 44, 43], [10285, 33, 34], [10286, 38, 36], [10287, 38, 35], [10288, 50, 35],
                    [10289, 51, 40], [10290, 50, 39], [10291, 50, 43], [10292, 36, 42], [10293, 50, 50],
                    [10294, 23, 35], [10295, 30, 39], [10296, 45, 44], [10297, 31, 35], [10298, 39, 40],
                    [10299, 30, 35], [10300, 39, 40], [10301, 39, 44], [10302, 30, 39], [10303, 46, 45],
                    [10304, 31, 39], [10305, 39, 44], [10306, 37, 47], [10307, 43, 49], [10309, 44, 39],
                    [10310, 31, 39], [10311, 40, 44], [10312, 43, 42], [10313, 53, 46], [10314, 47, 40],
                    [10315, 45, 35], [10317, 37, 38], [10318, 54, 44], [10319, 37, 46], [10320, 84, 51],
                    [10321, 37, 35], [10322, 51, 52], [10323, 36, 49], [10326, 66, 52], [10327, 37, 42],
                    [10329, 38, 35], [10330, 43, 50], [10332, 30, 35], [10333, 50, 50], [10334, 56, 50],
                    [10335, 45, 51], [10337, 36, 38], [10338, 52, 44], [10339, 37, 39], [10340, 53, 44],
                    [10341, 30, 34], [10342, 39, 36], [10343, 43, 39], [10344, 38, 43], [10347, 30, 46],
                    [10354, 30, 38], [10355, 51, 44], [10356, 37, 42], [10357, 51, 51], [10358, 45, 43],
                    [10360, 30, 35], [10361, 46, 40], [10362, 50, 50], [10363, 82, 51], [10364, 86, 48],
                    [10366, 52, 51], [10367, 81, 50], [10368, 85, 52], [10369, 81, 50], [10370, 86, 53],
                    [10371, 39, 52], [10372, 30, 38], [10374, 30, 39], [10376, 30, 34], [10377, 32, 36],
                    [10378, 49, 49], [10380, 43, 45], [10381, 66, 52], [10382, 43, 46], [10383, 85, 51],
                    [10384, 50, 50], [10385, 86, 52], [10388, 23, 39], [10390, 31, 36], [10391, 44, 35],
                    [10392, 44, 43], [10394, 30, 34], [10395, 39, 40], [10396, 31, 35], [10398, 31, 39],
                    [10399, 45, 44], [10400, 31, 36], [10402, 30, 46], [10403, 47, 52], [10404, 32, 40],
                    [10408, 30, 46], [10409, 45, 52], [10410, 34, 46], [10411, 52, 51], [10412, 62, 34],
                    [10413, 88, 50], [10417, 46, 52], [10418, 30, 35], [10419, 50, 50], [10420, 51, 52],
                    [10422, 44, 50], [10424, 47, 47], [10425, 30, 42], [10426, 45, 51], [10427, 38, 35],
                    [10428, 38, 44], [10431, 31, 39], [10432, 46, 44], [10433, 30, 38], [10434, 46, 44],
                    [10435, 51, 40], [10436, 37, 35], [10437, 50, 35], [10438, 31, 35], [10439, 45, 51],
                    [10440, 30, 42], [10441, 50, 43], [10442, 38, 39], [10443, 30, 34], [10444, 51, 36],
                    [10445, 53, 44], [10447, 30, 34], [10448, 40, 37], [10450, 30, 38], [10453, 83, 43],
                    [10454, 80, 42], [10455, 83, 50], [10456, 30, 38], [10458, 30, 35], [10459, 38, 35],
                    [10461, 30, 39], [10463, 23, 31], [10464, 32, 36], [10467, 30, 43], [10469, 37, 38],
                    [10471, 36, 34], [10474, 21, 21], [10475, 21, 21], [10476, 22, 23], [10477, 23, 23],
                    [10478, 31, 50], [10479, 46, 35], [10480, 30, 34], [10482, 30, 39], [10483, 35, 44],
                    [10484, 30, 38], [10485, 35, 44], [10486, 30, 38], [10487, 35, 44], [10490, 17, 30],
                    [10491, 10, 23], [10492, 8, 14], [10493, 36, 41], [10494, 11, 40], [10495, 13, 33], [10496, 10, 22],
                    [10497, 29, 61], [10498, 10, 29], [10499, 10, 57], [10500, 13, 59], [10501, 13, 59],
                    [10502, 34, 89], [10503, 13, 60], [10504, 15, 81], [10505, 35, 70], [10506, 17, 47],
                    [10507, 10, 26], [10508, 27, 68], [10509, 29, 46], [10510, 16, 42], [10511, 8, 22], [10512, 30, 34],
                    [10513, 39, 40], [10514, 19, 29], [10515, 21, 37], [10516, 19, 31], [10517, 30, 42],
                    [10518, 24, 29], [10519, 28, 33], [10520, 13, 18], [10521, 23, 30], [10522, 22, 29],
                    [10523, 22, 29], [10524, 22, 29], [10525, 22, 29], [10526, 22, 29], [10527, 21, 27],
                    [10528, 30, 30], [10529, 22, 29], [10530, 22, 29], [10531, 22, 29], [10532, 24, 24],
                    [10533, 38, 32], [10534, 17, 15], [10535, 34, 29], [10536, 18, 24], [10537, 26, 23],
                    [10538, 33, 28], [10539, 19, 20], [10540, 37, 30], [10541, 46, 40], [10542, 56, 36], [10543, 7, 7],
                    [10544, 13, 11], [10545, 7, 7], [10546, 8, 8], [10547, 8, 9], [10548, 13, 13], [10549, 9, 9],
                    [10550, 16, 11], [10551, 9, 10], [10552, 8, 8], [10553, 22, 16], [10554, 23, 15], [10555, 14, 10],
                    [10556, 24, 16], [10557, 19, 12], [10558, 36, 20], [10559, 22, 14], [10560, 22, 15],
                    [10561, 12, 11], [10562, 9, 8], [10563, 7, 8], [10564, 5, 5], [10565, 9, 10], [10566, 16, 13],
                    [10567, 16, 13], [10568, 11, 11], [10569, 16, 14], [10570, 23, 17], [10571, 30, 19],
                    [10572, 13, 11], [10573, 12, 8], [10574, 17, 13], [10575, 16, 15], [10576, 15, 12], [10577, 21, 13],
                    [10578, 51, 61], [10579, 73, 62], [10580, 92, 75], [10581, 120, 102], [10582, 88, 75],
                    [10583, 78, 72], [10584, 105, 85], [10585, 77, 81], [10586, 114, 99], [10587, 100, 80],
                    [10588, 52, 52], [10589, 94, 85], [10590, 116, 90], [10591, 103, 98], [10592, 92, 51],
                    [10593, 67, 57], [10594, 96, 94], [10595, 47, 55], [10596, 61, 60], [10597, 78, 64],
                    [10598, 76, 61], [10600, 18, 22], [10601, 18, 18], [10602, 36, 44], [10603, 50, 51],
                    [10604, 62, 39], [10605, 22, 11], [10606, 18, 11], [10607, 28, 15], [10608, 15, 11],
                    [10609, 15, 11], [10610, 25, 11], [10611, 25, 16], [10612, 23, 17], [10613, 63, 18],
                    [10614, 50, 32], [10615, 59, 32], [10616, 50, 43], [10617, 69, 38], [10618, 70, 38],
                    [10619, 50, 29], [10620, 35, 24], [10621, 50, 20], [10622, 45, 23], [10623, 50, 23],
                    [10624, 50, 23], [10625, 41, 28], [10626, 70, 38], [10627, 60, 28], [10628, 66, 45],
                    [10629, 66, 45], [10630, 38, 23], [10631, 60, 23], [10632, 45, 23], [10633, 67, 33],
                    [10634, 67, 23], [10635, 67, 23], [10636, 50, 33], [10637, 50, 29], [10638, 28, 20],
                    [10639, 70, 39], [10640, 63, 39], [10641, 63, 39], [10642, 63, 39], [10643, 50, 35],
                    [10644, 63, 39], [10645, 45, 37], [10646, 63, 37], [10647, 63, 37], [10648, 50, 46],
                    [10649, 55, 33], [10650, 63, 30], [10651, 63, 32], [10652, 50, 31], [10653, 69, 31],
                    [10654, 47, 37], [10655, 65, 37], [10656, 63, 37], [10657, 50, 28], [10658, 60, 26],
                    [10659, 25, 20], [10660, 70, 32], [10661, 108, 39], [10662, 65, 42], [10663, 55, 22],
                    [10664, 70, 32], [10665, 65, 32], [10666, 70, 28], [10667, 65, 28], [10668, 60, 29],
                    [10669, 25, 20], [10670, 63, 28], [10671, 62, 40], [10672, 70, 39], [10673, 45, 19],
                    [10674, 50, 25], [10675, 50, 48], [10676, 50, 48], [10677, 45, 24], [10678, 55, 37],
                    [10679, 85, 37], [10680, 30, 26], [10681, 60, 32], [10682, 50, 32], [10683, 49, 32],
                    [10684, 33, 35], [10685, 120, 50], [10686, 60, 50], [10687, 50, 53], [10688, 85, 53],
                    [10689, 85, 53], [10690, 85, 53], [10691, 85, 53], [10692, 95, 36], [10693, 120, 36],
                    [10694, 90, 36], [10695, 70, 36], [10696, 70, 35], [10697, 45, 35], [10698, 50, 45],
                    [10699, 60, 45], [10700, 25, 27], [10701, 108, 34], [10702, 108, 34], [10703, 108, 34],
                    [10704, 68, 34], [10705, 80, 32], [10706, 70, 32], [10707, 55, 59], [10708, 63, 59],
                    [10709, 63, 59], [10710, 108, 26], [10711, 65, 26], [10712, 70, 49], [10713, 70, 49],
                    [10714, 60, 41], [10715, 108, 31], [10716, 68, 59], [10717, 70, 59], [10718, 60, 59],
                    [10719, 85, 54], [10720, 95, 54], [10721, 35, 30], [10722, 90, 52], [10723, 70, 52],
                    [10724, 70, 52], [10725, 60, 52], [10726, 48, 38], [10727, 65, 38], [10728, 65, 39],
                    [10729, 65, 39], [10730, 70, 39], [10731, 50, 32], [10732, 70, 32], [10733, 70, 32],
                    [10734, 70, 32], [10735, 70, 25], [10736, 70, 25], [10737, 120, 25], [10738, 70, 40],
                    [10739, 35, 20], [10740, 63, 28], [10741, 50, 28], [10742, 62, 47], [10743, 55, 44],
                    [10744, 50, 33], [10745, 63, 36], [10746, 63, 34], [10747, 36, 26], [10748, 60, 23],
                    [10749, 63, 33], [10750, 63, 12], [10751, 63, 29], [10752, 63, 29], [10753, 70, 38],
                    [10754, 60, 28], [10755, 23, 16], [10756, 120, 90], [10757, 24, 15], [10758, 35, 13],
                    [10759, 80, 34], [10760, 80, 44], [10761, 63, 45], [10762, 63, 34], [10763, 50, 34],
                    [10764, 35, 34], [10765, 45, 33], [10766, 65, 33], [10767, 70, 24], [10768, 60, 24],
                    [10769, 63, 24], [10770, 70, 50], [10771, 70, 50], [10772, 45, 60], [10773, 63, 70],
                    [10774, 50, 33], [10775, 63, 33], [10776, 50, 23], [10777, 40, 26], [10778, 120, 26],
                    [10779, 50, 39], [10780, 60, 26], [10781, 55, 26], [10782, 50, 23], [10783, 75, 45],
                    [10784, 70, 33], [10785, 70, 33], [10786, 49, 26], [10787, 60, 26], [10788, 67, 59],
                    [10789, 55, 34], [10790, 70, 34], [10791, 70, 34], [10792, 35, 23], [10793, 64, 23],
                    [10794, 69, 24], [10795, 69, 24], [10796, 70, 24], [10797, 63, 24], [10798, 40, 24],
                    [10799, 28, 21], [10800, 63, 46], [10801, 63, 33], [10802, 50, 33], [10803, 45, 26],
                    [10804, 86, 28], [10805, 85, 30], [10806, 50, 29], [10807, 63, 29], [10808, 40, 20],
                    [10809, 36, 25], [10810, 50, 25], [10811, 50, 22], [10812, 100, 74], [10813, 62, 59],
                    [10814, 50, 29], [10815, 63, 29], [10816, 70, 28], [10817, 63, 28], [10818, 70, 46],
                    [10819, 70, 46], [10820, 70, 36], [10821, 63, 23], [10822, 63, 23], [10823, 55, 23],
                    [10824, 50, 33], [10825, 50, 33], [10826, 56, 34], [10827, 50, 34], [10828, 40, 25],
                    [10829, 65, 39], [10830, 63, 39], [10831, 67, 38], [10832, 64, 38], [10833, 63, 38],
                    [10834, 63, 38], [10835, 64, 38], [10836, 60, 38], [10837, 70, 38], [10838, 63, 38],
                    [10839, 50, 38], [10840, 35, 30], [10841, 110, 24], [10842, 45, 23], [10843, 63, 33],
                    [10844, 45, 40], [10845, 40, 36], [10846, 50, 36], [10847, 45, 24], [10848, 63, 24],
                    [10849, 63, 24], [10850, 55, 38], [10851, 45, 33], [10852, 50, 33], [10853, 70, 47],
                    [10854, 65, 34], [10855, 70, 34], [10856, 70, 41], [10857, 70, 41], [10858, 60, 39],
                    [10859, 70, 39], [10860, 95, 40], [10861, 85, 40], [10862, 60, 40], [10863, 33, 30],
                    [10864, 90, 40], [10865, 63, 25], [10866, 45, 29], [10867, 65, 39], [10868, 65, 39],
                    [10869, 70, 24], [10870, 70, 33], [10871, 70, 34], [10872, 70, 24], [10873, 84, 24],
                    [10874, 70, 24], [10875, 70, 32], [10876, 84, 32], [10877, 100, 42], [10878, 70, 32],
                    [10879, 70, 32], [10880, 70, 32], [10881, 50, 22], [10882, 90, 33], [10883, 108, 33],
                    [10884, 120, 33], [10885, 50, 46], [10886, 70, 34], [10887, 50, 33], [10888, 95, 43],
                    [10889, 65, 36], [10890, 50, 26], [10891, 35, 26], [10892, 45, 32], [10893, 70, 56],
                    [10894, 70, 56], [10895, 108, 48], [10896, 70, 48], [10897, 70, 48], [10898, 70, 48],
                    [10899, 60, 31], [10900, 50, 25], [10901, 60, 22], [10902, 60, 23], [10903, 63, 31],
                    [10904, 63, 31], [10905, 50, 31], [10906, 69, 45], [10907, 69, 45], [10908, 63, 27],
                    [10909, 108, 27], [10910, 63, 27], [10911, 90, 70], [10912, 90, 70], [10913, 55, 49],
                    [10914, 120, 49], [10915, 70, 54], [10916, 85, 54], [10917, 90, 54], [10918, 45, 45],
                    [10978, 63, 23], [10979, 63, 43], [10980, 60, 33], [11091, 10, 6], [11092, 15, 11], [11093, 13, 8],
                    [11094, 22, 11], [11095, 10, 7], [11096, 25, 19], [11097, 13, 8], [11098, 11, 7], [11099, 50, 40],
                    [11100, 10, 7], [11101, 14, 9], [11102, 13, 8], [11103, 20, 11], [11104, 70, 40], [11105, 40, 39],
                    [11106, 34, 20], [11107, 25, 14], [11108, 11, 6], [11109, 25, 20], [11110, 25, 12], [11111, 8, 8],
                    [11112, 37, 21], [11113, 32, 18], [11114, 50, 33], [11115, 9, 6], [11116, 10, 5], [11117, 11, 8],
                    [11118, 21, 14], [11119, 50, 27], [11120, 37, 25], [11121, 12, 10], [11122, 14, 8], [11123, 19, 10],
                    [11124, 11, 9], [11125, 37, 17], [11126, 18, 11], [11127, 8, 8], [11128, 16, 8], [11129, 8, 6],
                    [11130, 17, 10], [11131, 9, 6], [11132, 22, 13], [11133, 14, 9], [11134, 8, 4], [11135, 70, 34],
                    [11136, 13, 9], [11137, 8, 6], [11138, 22, 15], [11139, 15, 10], [11140, 14, 12], [11141, 12, 8],
                    [11142, 12, 8], [11143, 10, 6], [11144, 11, 9], [11145, 30, 24], [11146, 8, 7], [11147, 5, 3],
                    [11148, 40, 35], [11149, 15, 11], [11150, 26, 18], [11151, 16, 13], [11152, 15, 12],
                    [11153, 15, 10], [11154, 30, 18], [11155, 18, 10], [11156, 12, 11], [11157, 12, 10],
                    [11158, 14, 11], [11159, 13, 12], [11160, 14, 10], [11161, 14, 11], [11162, 13, 12],
                    [11163, 14, 14], [11164, 19, 18], [11165, 14, 10], [11166, 60, 39], [11167, 104, 55],
                    [11168, 26, 19], [11169, 12, 11], [11170, 16, 13], [11171, 16, 13], [11172, 11, 11],
                    [11173, 16, 14], [11174, 9, 8], [11175, 7, 8], [11176, 5, 5], [11177, 23, 17], [11178, 9, 10],
                    [11179, 13, 11], [11180, 12, 8], [11181, 17, 13], [11182, 16, 15], [11183, 15, 12]]],
            [2002, [[2, 46, 39], [7, 30, 30], [25, 13, 10], [42, 20, 21], [48, 79, 61], [49, 35, 24], [51, 30, 30],
                    [62, 21, 30], [65, 24, 21], [78, 20, 20], [82, 12, 20], [83, 38, 43], [87, 35, 30], [99, 30, 29],
                    [101, 61, 51], [119, 40, 29], [122, 32, 20], [125, 31, 32], [135, 20, 20], [138, 31, 30],
                    [163, 27, 25], [166, 36, 35], [169, 25, 20], [186, 16, 20], [190, 30, 29], [194, 23, 24],
                    [200, 40, 30], [204, 12, 21], [211, 21, 48], [215, 29, 30], [216, 23, 20], [218, 57, 25],
                    [220, 18, 19], [226, 16, 17], [230, 45, 42], [231, 54, 48], [233, 18, 19], [234, 12, 16],
                    [239, 20, 20], [240, 20, 18], [242, 32, 19], [243, 30, 30], [246, 51, 32], [248, 21, 20],
                    [270, 30, 29], [272, 49, 17], [282, 43, 22], [285, 20, 20], [286, 20, 12], [299, 19, 20],
                    [305, 20, 20], [306, 30, 30], [308, 12, 43], [310, 20, 20], [312, 20, 20], [314, 18, 27],
                    [317, 30, 30], [320, 23, 27], [324, 46, 39], [327, 45, 40], [329, 39, 31], [330, 30, 30],
                    [332, 30, 30], [334, 34, 30], [337, 25, 18], [339, 22, 20], [344, 30, 20], [346, 43, 36],
                    [355, 49, 32], [361, 30, 30], [365, 44, 32], [378, 20, 24], [379, 15, 13], [389, 18, 24],
                    [392, 19, 20], [399, 75, 38], [402, 34, 30], [403, 29, 30], [418, 22, 20], [424, 20, 20],
                    [425, 16, 25], [428, 28, 20], [430, 21, 27], [432, 35, 30], [436, 27, 22], [455, 26, 24],
                    [471, 19, 20], [479, 33, 33], [480, 61, 26], [487, 32, 29], [493, 30, 30], [494, 16, 18],
                    [497, 10, 15], [503, 64, 23], [504, 14, 12], [505, 28, 30], [519, 18, 27], [525, 20, 31],
                    [536, 20, 20], [541, 76, 41], [545, 21, 25], [568, 20, 20], [569, 52, 30], [570, 26, 21],
                    [573, 30, 30], [577, 29, 24], [579, 47, 43], [585, 59, 55], [590, 35, 39], [593, 43, 39],
                    [595, 31, 30], [597, 23, 10], [599, 16, 22], [604, 53, 32], [608, 28, 20], [612, 43, 42],
                    [618, 26, 21], [625, 24, 18], [627, 33, 31], [628, 30, 30], [631, 20, 20], [654, 15, 12],
                    [660, 32, 32], [662, 69, 47], [663, 51, 34], [669, 31, 23], [678, 20, 26], [686, 15, 23],
                    [691, 23, 20], [694, 40, 33], [695, 72, 53], [700, 58, 43], [703, 12, 17], [704, 26, 30],
                    [716, 61, 58], [717, 37, 30], [719, 31, 28], [720, 24, 20], [724, 29, 29], [727, 48, 48],
                    [734, 21, 32], [737, 14, 12], [750, 20, 20], [751, 32, 18], [754, 30, 30], [766, 66, 30],
                    [769, 37, 44], [773, 29, 30], [781, 27, 22], [783, 21, 26], [785, 55, 54], [790, 43, 30],
                    [801, 20, 20], [803, 36, 33], [805, 37, 27], [811, 27, 23], [815, 16, 16], [820, 40, 44],
                    [821, 20, 20], [822, 17, 21], [826, 20, 20], [827, 10, 14], [835, 30, 30], [843, 30, 30],
                    [844, 28, 23], [845, 58, 30], [848, 25, 20], [865, 50, 33], [871, 41, 23], [878, 7, 6],
                    [882, 45, 34], [890, 20, 20], [894, 28, 12], [909, 64, 40], [913, 20, 18], [915, 56, 37],
                    [922, 47, 34], [926, 62, 22], [938, 12, 13], [940, 12, 14], [941, 39, 35], [944, 23, 20],
                    [949, 67, 34], [950, 16, 20], [964, 12, 16], [969, 41, 38], [971, 21, 17], [972, 38, 25],
                    [978, 49, 38], [979, 20, 20], [985, 77, 41], [990, 23, 20], [993, 60, 39], [998, 37, 21],
                    [1003, 8, 6], [1008, 23, 24], [1016, 11, 15], [1030, 9, 14], [1033, 20, 20], [1042, 96, 47],
                    [1048, 40, 38], [1051, 25, 20], [1056, 21, 43], [1059, 45, 47], [1073, 50, 33], [1082, 53, 45],
                    [1094, 20, 20], [1095, 20, 20], [1097, 33, 19], [1100, 22, 22], [1102, 15, 17], [1106, 90, 33],
                    [1109, 28, 30], [1111, 38, 48], [1131, 33, 30], [1132, 12, 15], [1136, 44, 47], [1140, 29, 25],
                    [1141, 29, 30], [1142, 25, 25], [1144, 30, 22], [1145, 30, 24], [1150, 36, 27], [1155, 30, 30],
                    [1156, 28, 19], [1157, 37, 25], [1159, 50, 43], [1167, 20, 20], [1169, 20, 20], [1174, 30, 44],
                    [1175, 20, 20], [1177, 36, 30], [1186, 15, 20], [1194, 98, 45], [1200, 20, 20], [1203, 11, 18],
                    [1205, 20, 20], [1213, 23, 21], [1217, 30, 30], [1219, 20, 20], [1221, 21, 19], [1224, 30, 30],
                    [1226, 21, 15], [1228, 19, 20], [1234, 12, 15], [1235, 27, 23], [1238, 14, 27], [1247, 57, 33],
                    [1254, 54, 28], [1262, 29, 30], [1268, 43, 31], [1275, 22, 14], [1281, 15, 21], [1295, 45, 53],
                    [1302, 54, 63], [1303, 83, 41], [1305, 18, 20], [1319, 51, 26], [1320, 43, 40], [1323, 22, 20],
                    [1334, 20, 20], [1358, 51, 28], [1359, 29, 30], [1361, 30, 30], [1363, 31, 30], [1367, 37, 41],
                    [1370, 14, 22], [1375, 20, 20], [1376, 26, 24], [1396, 11, 20], [1420, 52, 48], [1445, 65, 18],
                    [1454, 24, 29], [1456, 29, 29], [1465, 17, 20], [1466, 36, 24], [1471, 30, 30], [1473, 15, 22],
                    [1475, 32, 30], [1476, 29, 30], [1477, 20, 20], [1481, 45, 29], [1482, 13, 17], [1484, 30, 30],
                    [1486, 14, 13], [1490, 22, 20], [1491, 11, 9], [1493, 28, 21], [1507, 37, 25], [1508, 30, 30],
                    [1510, 16, 20], [1511, 30, 30], [1515, 24, 19], [1522, 14, 20], [1525, 44, 43], [1527, 28, 30],
                    [1530, 57, 52], [1536, 17, 18], [1537, 31, 28], [1548, 29, 31], [1553, 29, 30], [1555, 49, 41],
                    [1556, 30, 30], [1557, 34, 30], [1561, 19, 20], [1562, 29, 30], [1568, 32, 30], [1575, 87, 60],
                    [1577, 28, 21], [1580, 45, 38], [1582, 26, 26], [1587, 17, 19], [1589, 44, 20], [1598, 15, 9],
                    [1610, 30, 30], [1628, 36, 22], [1635, 18, 17], [1638, 29, 44], [1644, 36, 30], [1645, 45, 29],
                    [1659, 26, 23], [1660, 29, 30], [1662, 15, 12], [1663, 29, 30], [1664, 17, 16], [1672, 20, 20],
                    [1673, 62, 42], [1680, 30, 30], [1685, 44, 40], [1704, 17, 21], [1717, 57, 28], [1724, 20, 20],
                    [1730, 17, 12], [1744, 30, 29], [1748, 29, 30], [1756, 29, 30], [1760, 13, 16], [1763, 24, 23],
                    [1769, 57, 48], [1771, 20, 20], [1772, 11, 15], [1774, 26, 28], [1780, 19, 20], [1781, 20, 20],
                    [1786, 20, 26], [1790, 20, 20], [1792, 30, 30], [1794, 34, 37], [1795, 13, 10], [1797, 61, 42],
                    [1798, 41, 53], [1804, 19, 20], [1812, 14, 18], [1816, 97, 26], [1818, 20, 20], [1824, 36, 42],
                    [1825, 20, 28], [1829, 19, 27], [1841, 45, 44], [1845, 30, 30], [1848, 30, 30], [1853, 60, 26],
                    [1864, 69, 63], [1866, 62, 34], [1869, 34, 40], [1876, 29, 30], [1879, 23, 20], [1882, 18, 20],
                    [1891, 28, 41], [1894, 36, 16], [1901, 20, 20], [1903, 89, 35], [1915, 46, 37], [1916, 20, 18],
                    [1917, 29, 30], [1921, 20, 18], [1925, 30, 30], [1930, 11, 9], [1933, 11, 15], [1945, 28, 29],
                    [1948, 24, 33], [1950, 21, 35], [1952, 106, 70], [1962, 13, 17], [1965, 60, 47], [1995, 30, 30],
                    [2000, 30, 30], [2001, 37, 27], [2006, 23, 21], [2011, 12, 17], [2017, 41, 41], [2021, 30, 29],
                    [2023, 12, 12], [2025, 30, 30], [2026, 43, 31], [2028, 42, 24], [2029, 29, 30], [2032, 17, 19],
                    [2035, 62, 34], [2042, 19, 20], [2048, 14, 31], [2056, 34, 40], [2057, 89, 40], [2064, 53, 35],
                    [2081, 19, 20], [2084, 56, 31], [2098, 14, 17], [2099, 24, 20], [2101, 10, 13], [2104, 31, 30],
                    [2121, 18, 17], [2127, 17, 12], [2128, 30, 30], [2131, 28, 39], [2138, 27, 26], [2142, 10, 11],
                    [2144, 22, 65], [2162, 20, 37], [2163, 36, 18], [2170, 25, 20], [2171, 28, 26], [2174, 28, 21],
                    [2178, 13, 19], [2180, 29, 30], [2181, 30, 29], [2182, 29, 30], [2190, 28, 23], [2198, 24, 18],
                    [2201, 30, 30], [2208, 48, 34], [2213, 45, 38], [2216, 24, 30], [2220, 19, 20], [2224, 30, 32],
                    [2227, 18, 18], [2232, 30, 30], [2236, 19, 20], [2238, 30, 30], [2239, 22, 20], [2244, 25, 27],
                    [2250, 45, 30], [2255, 29, 29], [2258, 29, 30], [2277, 29, 26], [2280, 9, 7], [2282, 20, 60],
                    [2293, 30, 30], [2300, 43, 49], [2303, 20, 20], [2311, 39, 38], [2312, 20, 20], [2316, 55, 33],
                    [2332, 15, 16], [2335, 30, 30], [2343, 27, 18], [2352, 44, 38], [2366, 16, 17], [2367, 33, 30],
                    [2371, 57, 32], [2383, 33, 20], [2384, 27, 37], [2404, 29, 29], [2405, 30, 32], [2428, 33, 20],
                    [2429, 12, 12], [2433, 55, 23], [2435, 18, 14], [2443, 57, 34], [2447, 19, 20], [2458, 16, 14],
                    [2459, 13, 17], [2467, 12, 16], [2472, 32, 22], [2483, 61, 44], [2485, 14, 13], [2488, 25, 25],
                    [2493, 23, 20], [2494, 28, 30], [2497, 20, 20], [2500, 26, 18], [2501, 62, 27], [2505, 45, 30],
                    [2509, 15, 18], [2514, 30, 30], [2516, 30, 30], [2518, 30, 30], [2524, 11, 11], [2527, 24, 20],
                    [2533, 11, 18], [2539, 55, 27], [2540, 20, 22], [2543, 21, 21], [2547, 16, 15], [2551, 38, 30],
                    [2554, 12, 12], [2555, 35, 23], [2562, 34, 30], [2564, 20, 20], [2574, 29, 30], [2576, 56, 29],
                    [2585, 54, 44], [2587, 29, 29], [2593, 28, 30], [2595, 42, 36], [2603, 77, 39], [2604, 30, 30],
                    [2606, 20, 15], [2607, 11, 10], [2612, 30, 30], [2615, 33, 30], [2617, 41, 24], [2619, 12, 13],
                    [2622, 27, 20], [2627, 60, 34], [2628, 20, 20], [2632, 30, 18], [2633, 30, 30], [2635, 13, 20],
                    [2644, 26, 20], [2647, 32, 27], [2650, 22, 20], [2656, 20, 20], [2658, 29, 30], [2667, 29, 30],
                    [2668, 30, 30], [2669, 48, 43], [2670, 45, 30], [2671, 48, 54], [2687, 24, 17], [2692, 58, 26],
                    [2695, 12, 13], [2720, 35, 38], [2723, 41, 63], [2743, 30, 30], [2747, 29, 30], [2748, 30, 30],
                    [2758, 33, 29], [2762, 76, 44], [2775, 57, 34], [2785, 13, 15], [2788, 30, 30], [2791, 39, 26],
                    [2797, 14, 15], [2798, 12, 20], [2813, 29, 30], [2822, 28, 23], [2823, 20, 20], [2827, 13, 18],
                    [2832, 16, 16], [2833, 49, 32], [2835, 33, 31], [2836, 30, 17], [2838, 41, 34], [2846, 25, 26],
                    [2851, 20, 17], [2854, 34, 34], [2856, 34, 30], [2867, 20, 20], [2872, 18, 20], [2876, 30, 30],
                    [2879, 24, 24], [2880, 35, 28], [2883, 32, 30], [2884, 23, 38], [2897, 90, 51], [2901, 66, 54],
                    [2904, 47, 32], [2910, 20, 20], [2914, 45, 30], [2918, 50, 36], [2922, 15, 16], [2923, 29, 29],
                    [2929, 30, 30], [2932, 32, 32], [2934, 21, 20], [2935, 66, 31], [2936, 23, 20], [2946, 29, 20],
                    [2950, 30, 30], [2969, 21, 18], [2973, 38, 48], [2974, 40, 22], [2978, 29, 30], [2979, 24, 16],
                    [2991, 40, 43], [2995, 20, 20], [3009, 37, 41], [3011, 30, 30], [3016, 30, 30], [3019, 42, 22],
                    [3027, 19, 20], [3033, 75, 45], [3035, 20, 20], [3041, 34, 26], [3046, 30, 14], [3048, 44, 23],
                    [3050, 31, 21], [3053, 68, 61], [3061, 30, 30], [3066, 57, 30], [3070, 33, 35], [3077, 34, 20],
                    [3086, 67, 25], [3091, 10, 15], [3092, 45, 24], [3098, 20, 20], [3106, 19, 21], [3112, 56, 30],
                    [3114, 33, 30], [3119, 11, 27], [3121, 20, 20], [3122, 30, 30], [3126, 45, 21], [3129, 35, 43],
                    [3133, 25, 20], [3134, 46, 39], [3137, 30, 30], [3142, 34, 41], [3148, 33, 29], [3154, 31, 30],
                    [3155, 26, 21], [3158, 16, 18], [3160, 19, 20], [3161, 20, 20], [3164, 54, 35], [3167, 21, 29],
                    [3171, 37, 20], [3175, 35, 26], [3182, 19, 22], [3188, 39, 36], [3189, 35, 30], [3195, 20, 20],
                    [3206, 30, 30], [3217, 30, 30], [3221, 45, 22], [3228, 29, 30], [3231, 20, 20], [3234, 53, 25],
                    [3246, 57, 33], [3248, 19, 22], [3251, 36, 43], [3252, 40, 26], [3254, 25, 18], [3256, 21, 22],
                    [3264, 29, 30], [3268, 30, 30], [3272, 24, 21], [3273, 77, 19], [3274, 28, 24], [3277, 31, 22],
                    [3280, 29, 30], [3283, 25, 21], [3284, 20, 20], [3289, 61, 50], [3301, 42, 40], [3306, 22, 26],
                    [3308, 62, 38], [3309, 42, 38], [3320, 54, 58], [3321, 45, 25], [3326, 20, 20], [3327, 50, 51],
                    [3331, 20, 20], [3336, 24, 20], [3344, 20, 19], [3346, 20, 32], [3348, 57, 30], [3357, 12, 18],
                    [3358, 15, 18], [3363, 65, 30], [3364, 11, 17], [3372, 53, 31], [3382, 37, 24], [3404, 38, 30],
                    [3407, 19, 20], [3418, 74, 37], [3422, 24, 18], [3429, 29, 29], [3434, 7, 6], [3438, 54, 29],
                    [3439, 20, 20], [3441, 29, 30], [3442, 20, 20], [3451, 47, 49], [3453, 20, 20], [3454, 12, 10],
                    [3457, 30, 30], [3459, 26, 22], [3462, 53, 24], [3468, 21, 20], [3469, 30, 18], [3476, 30, 38],
                    [3494, 12, 15], [3498, 20, 26], [3503, 78, 51], [3511, 19, 32], [3515, 15, 58], [3517, 55, 22],
                    [3531, 27, 20], [3541, 22, 27], [3557, 10, 15], [3559, 45, 40], [3566, 14, 12], [3569, 65, 65],
                    [3572, 28, 28], [3579, 20, 31], [3590, 29, 32], [3593, 46, 20], [3598, 17, 13], [3602, 20, 20],
                    [3608, 27, 29], [3632, 30, 30], [3639, 20, 20], [3642, 33, 29], [3644, 29, 29], [3650, 39, 30],
                    [3653, 20, 20], [3656, 29, 30], [3659, 20, 16], [3661, 30, 30], [3667, 19, 20], [3669, 11, 20],
                    [3670, 39, 30], [3679, 19, 20], [3700, 23, 26], [3703, 28, 30], [3718, 53, 28], [3726, 11, 13],
                    [3729, 100, 30], [3731, 28, 23], [3747, 28, 23], [3751, 23, 20], [3755, 29, 30], [3761, 21, 21],
                    [3765, 25, 18], [3777, 29, 22], [3782, 69, 31], [3786, 13, 12], [3795, 29, 30], [3796, 30, 30],
                    [3802, 47, 50], [3807, 20, 20], [3827, 30, 30], [3828, 20, 22], [3832, 28, 28], [3833, 25, 13],
                    [3834, 29, 35], [3841, 27, 30], [3845, 30, 30], [3854, 19, 20], [3855, 20, 20], [3859, 12, 16],
                    [3870, 32, 30], [3874, 29, 30], [3883, 20, 20], [3884, 58, 34], [3889, 79, 30], [3897, 28, 29],
                    [3905, 29, 29], [3915, 29, 30], [3921, 30, 30], [3925, 65, 48], [3932, 25, 31], [3942, 19, 30],
                    [3943, 17, 27], [3947, 48, 39], [3953, 30, 30], [3956, 44, 53], [3959, 20, 20], [3960, 39, 30],
                    [3963, 25, 15], [3969, 85, 45], [3970, 30, 30], [3972, 82, 62], [3976, 17, 15], [3985, 30, 24],
                    [3988, 24, 30], [3992, 30, 30], [3993, 11, 13], [3999, 29, 30], [4015, 58, 31], [4022, 44, 28],
                    [4023, 29, 30], [4026, 36, 19], [4027, 83, 38], [4028, 32, 40], [4031, 17, 15], [4034, 83, 47],
                    [4035, 20, 20], [4038, 95, 40], [4040, 29, 30], [4043, 18, 18], [4047, 29, 34], [4074, 22, 32],
                    [4082, 83, 39], [4084, 12, 18], [4091, 39, 16], [4095, 30, 30], [4096, 30, 30], [4106, 28, 30],
                    [4107, 72, 31], [4109, 18, 19], [4111, 20, 14], [4116, 28, 30], [4118, 30, 30], [4120, 30, 30],
                    [4122, 63, 57], [4124, 30, 30], [4125, 13, 17], [4134, 34, 30], [4152, 108, 50], [4156, 20, 21],
                    [4164, 20, 20], [4165, 40, 39], [4169, 28, 22], [4173, 12, 18], [4176, 11, 15], [4177, 51, 35],
                    [4182, 28, 30], [4185, 19, 20], [4188, 91, 26], [4189, 19, 30], [4199, 46, 30], [4203, 29, 30],
                    [4206, 15, 19], [4209, 21, 19], [4229, 27, 21], [4242, 20, 20], [4246, 11, 14], [4250, 71, 26],
                    [4272, 30, 30], [4279, 25, 30], [4283, 19, 18], [4285, 32, 29], [4298, 44, 52], [4299, 20, 35],
                    [4301, 59, 32], [4310, 33, 26], [4312, 54, 32], [4318, 19, 20], [4320, 31, 31], [4325, 54, 30],
                    [4326, 10, 14], [4329, 21, 30], [4333, 17, 21], [4338, 30, 30], [4345, 19, 21], [4349, 30, 29],
                    [4350, 20, 20], [4352, 20, 20], [4353, 27, 26], [4358, 12, 16], [4362, 48, 31], [4364, 20, 20],
                    [4380, 17, 13], [4382, 55, 47], [4384, 32, 20], [4386, 15, 17], [4391, 20, 20], [4406, 42, 30],
                    [4413, 12, 12], [4414, 15, 24], [4415, 88, 28], [4421, 30, 30], [4426, 11, 15], [4438, 55, 27],
                    [4440, 45, 33], [4441, 17, 13], [4442, 15, 20], [4446, 29, 30], [4454, 22, 20], [4461, 38, 28],
                    [4464, 56, 28], [4470, 31, 34], [4471, 20, 20], [4477, 31, 35], [4487, 30, 39], [4491, 49, 34],
                    [4494, 19, 20], [4495, 27, 21], [4500, 27, 20], [4504, 61, 38], [4506, 19, 20], [4508, 33, 28],
                    [4510, 26, 22], [4515, 30, 29], [4518, 36, 28], [4521, 29, 30], [4524, 30, 30], [4532, 23, 20],
                    [4536, 22, 20], [4542, 41, 26], [4545, 50, 37], [4550, 29, 30], [4552, 15, 18], [4558, 29, 27],
                    [4563, 29, 30], [4572, 29, 20], [4587, 32, 25], [4591, 21, 20], [4602, 23, 29], [4606, 19, 20],
                    [4608, 21, 23], [4610, 57, 28], [4611, 20, 20], [4613, 45, 38], [4616, 22, 18], [4617, 86, 39],
                    [4618, 26, 25], [4623, 15, 19], [4626, 35, 23], [4633, 20, 20], [4634, 31, 30], [4635, 72, 13],
                    [4638, 67, 39], [4643, 22, 18], [4644, 14, 18], [4648, 31, 11], [4660, 61, 29], [4668, 29, 29],
                    [4670, 61, 25], [4676, 13, 20], [4684, 22, 20], [4689, 45, 32], [4693, 31, 30], [4694, 22, 22],
                    [4703, 10, 15], [4710, 9, 7], [4711, 17, 15], [4712, 24, 18], [4717, 20, 20], [4724, 31, 20],
                    [4728, 25, 22], [4729, 37, 30], [4732, 77, 88], [4734, 18, 18], [4738, 42, 51], [4745, 19, 22],
                    [4747, 60, 33], [4749, 45, 33], [4753, 25, 21], [4762, 57, 55], [4764, 49, 43], [4777, 21, 22],
                    [4780, 20, 20], [4781, 27, 31], [4789, 41, 25], [4791, 19, 20], [4794, 26, 20], [4800, 30, 30],
                    [4801, 11, 20], [4802, 28, 20], [4805, 15, 21], [4815, 29, 30], [4819, 19, 20], [4820, 53, 49],
                    [4826, 20, 20], [4828, 40, 21], [4829, 20, 27], [4832, 12, 16], [4835, 26, 24], [4839, 37, 22],
                    [4840, 56, 38], [4844, 21, 20], [4849, 20, 19], [4863, 45, 28], [4864, 19, 22], [4865, 32, 23],
                    [4871, 16, 21], [4872, 30, 30], [4877, 25, 20], [4880, 17, 21], [4881, 30, 30], [4888, 54, 52],
                    [4897, 17, 24], [4910, 29, 30], [4912, 11, 20], [4914, 32, 18], [4915, 21, 18], [4918, 22, 30],
                    [4922, 37, 20], [4926, 26, 22], [4927, 20, 20], [4931, 19, 20], [4939, 24, 23], [4940, 44, 22],
                    [4944, 14, 17], [4950, 30, 30], [4951, 45, 29], [4955, 30, 30], [4957, 20, 20], [4960, 107, 50],
                    [4973, 31, 34], [4975, 30, 30], [4976, 12, 18], [4978, 68, 53], [4979, 89, 36], [4983, 22, 19],
                    [4987, 20, 20], [4990, 20, 20], [4992, 25, 23], [4995, 28, 30], [4996, 30, 30], [4997, 28, 20],
                    [4998, 30, 30], [5005, 18, 30], [5006, 48, 26], [5008, 29, 30], [5009, 19, 20], [5011, 30, 30],
                    [5012, 27, 29], [5013, 11, 18], [5017, 29, 30], [5019, 52, 33], [5022, 81, 47], [5027, 29, 30],
                    [5031, 10, 15], [5032, 22, 30], [5033, 20, 20], [5035, 30, 30], [5037, 30, 20], [5038, 12, 19],
                    [5046, 30, 30], [5048, 21, 19], [5050, 12, 14], [5051, 12, 13], [5053, 30, 22], [5058, 30, 30],
                    [5062, 34, 47], [5063, 24, 33], [5064, 28, 30], [5065, 28, 30], [5068, 30, 23], [5069, 29, 30],
                    [5070, 20, 20], [5071, 29, 30], [5073, 61, 44], [5075, 21, 30], [5079, 20, 20], [5081, 36, 17],
                    [5091, 52, 45], [5092, 12, 17], [5095, 14, 17], [5098, 20, 20], [5102, 20, 12], [5103, 30, 30],
                    [5104, 57, 39], [5107, 53, 45], [5108, 23, 33], [5109, 22, 20], [5116, 27, 31], [5121, 20, 20],
                    [5122, 30, 22], [5126, 19, 20], [5127, 20, 20], [5130, 51, 59], [5138, 15, 15], [5149, 24, 21],
                    [5150, 64, 40], [5153, 35, 30], [5159, 40, 25], [5162, 23, 22], [5173, 43, 25], [5180, 21, 32],
                    [5181, 19, 20], [5182, 21, 23], [5183, 30, 30], [5184, 37, 22], [5185, 32, 18], [5186, 13, 18],
                    [5187, 12, 13], [5188, 12, 15], [5189, 18, 11], [5217, 57, 39], [5219, 17, 54], [5220, 14, 57],
                    [5221, 12, 43], [5222, 16, 23], [5223, 11, 30], [5224, 15, 43], [5225, 16, 56], [5226, 12, 56],
                    [5227, 30, 65], [5228, 20, 60], [5229, 11, 43], [5230, 16, 37], [5231, 14, 34], [5232, 19, 62],
                    [5233, 24, 78], [5234, 11, 26], [5235, 40, 41], [5236, 15, 42], [5237, 29, 59], [5238, 18, 46],
                    [5239, 24, 65], [5240, 19, 66], [5241, 28, 62], [5242, 21, 46], [5243, 27, 67], [5244, 20, 79],
                    [5245, 25, 67], [5247, 36, 14], [5248, 37, 20], [5273, 26, 17], [5276, 31, 54], [5279, 21, 24],
                    [5287, 13, 13], [5290, 22, 21], [5298, 13, 13], [5299, 18, 20], [5303, 32, 21], [5305, 26, 23],
                    [5314, 21, 23], [5315, 19, 25], [5317, 41, 59], [5321, 21, 21], [5323, 14, 21], [5328, 19, 20],
                    [5332, 22, 26], [5333, 13, 15], [5336, 15, 18], [5337, 17, 17], [5338, 30, 24], [5339, 21, 23],
                    [5340, 28, 32], [5343, 16, 14], [5344, 41, 42], [5347, 20, 22], [5349, 22, 25], [5350, 20, 27],
                    [5353, 19, 24], [5355, 22, 35], [5357, 26, 20], [5359, 17, 23], [5366, 29, 23], [5371, 32, 34],
                    [5372, 22, 23], [5375, 19, 18], [5377, 17, 18], [5383, 26, 26], [5385, 31, 23], [5387, 16, 15],
                    [5400, 14, 13], [5403, 23, 23], [5404, 23, 23], [5407, 20, 23], [5408, 18, 21], [5411, 24, 20],
                    [5412, 21, 17], [5414, 12, 15], [5415, 42, 45], [5418, 27, 33], [5420, 16, 16], [5421, 17, 14],
                    [5422, 24, 31], [5425, 17, 19], [5426, 20, 27], [5428, 18, 23], [5431, 22, 23], [5432, 22, 28],
                    [5434, 15, 16], [5436, 20, 23], [5437, 27, 23], [5440, 35, 28], [5441, 28, 35], [5444, 22, 32],
                    [5447, 19, 22], [5449, 25, 29], [5450, 26, 28], [5452, 22, 30], [5453, 30, 29], [5454, 14, 15],
                    [5455, 25, 20], [5457, 16, 23], [5459, 23, 24], [5462, 21, 24], [5463, 14, 17], [5464, 18, 18],
                    [5465, 22, 22], [5472, 22, 26], [5473, 17, 22], [5476, 15, 20], [5479, 20, 18], [5480, 33, 29],
                    [5482, 17, 18], [5486, 21, 21], [5489, 30, 51], [5492, 22, 35], [5494, 24, 27], [5495, 28, 24],
                    [5498, 34, 35], [5499, 30, 23], [5501, 25, 38], [5505, 18, 27], [5508, 23, 31], [5528, 20, 18],
                    [5532, 23, 23], [5534, 16, 14], [5539, 16, 19], [5541, 25, 21], [5544, 21, 29], [5545, 16, 21],
                    [5547, 26, 24], [5550, 17, 17], [5571, 25, 20], [5659, 9, 7], [5944, 7, 8], [5945, 11, 9],
                    [5946, 6, 5], [5962, 74, 91], [5986, 55, 37], [5996, 55, 31], [6055, 61, 37], [6066, 34, 33],
                    [6068, 58, 48], [6069, 62, 58], [6070, 62, 58], [6071, 33, 31], [6072, 23, 43], [6073, 37, 39],
                    [6074, 42, 39], [6075, 62, 58], [6076, 45, 42], [6077, 37, 36], [6078, 45, 51], [6079, 45, 42],
                    [6080, 45, 48], [6081, 29, 32], [6082, 42, 39], [6083, 38, 35], [6084, 54, 39], [6085, 46, 43],
                    [6086, 29, 25], [6087, 107, 36], [6088, 44, 42], [6089, 37, 35], [6090, 62, 45], [6091, 33, 35],
                    [6092, 38, 42], [6093, 42, 39], [6094, 42, 39], [6095, 29, 27], [6096, 38, 31], [6097, 45, 36],
                    [6098, 38, 35], [6099, 54, 39], [6100, 42, 39], [6101, 42, 31], [6102, 29, 29], [6103, 38, 35],
                    [6104, 46, 33], [6105, 54, 39], [6106, 33, 31], [6107, 33, 31], [6108, 42, 37], [6109, 24, 31],
                    [6110, 38, 39], [6111, 19, 27], [6112, 36, 36], [6113, 28, 28], [6114, 28, 28], [6115, 28, 33],
                    [6116, 40, 36], [6117, 32, 32], [6118, 40, 39], [6119, 36, 36], [6120, 24, 27], [6121, 36, 36],
                    [6122, 36, 32], [6123, 28, 28], [6124, 40, 32], [6125, 32, 32], [6126, 36, 36], [6127, 36, 36],
                    [6128, 31, 40], [6129, 20, 27], [6130, 36, 36], [6131, 38, 35], [6132, 42, 39], [6133, 38, 35],
                    [6134, 38, 35], [6135, 101, 94], [6136, 85, 80], [6137, 20, 24], [6138, 32, 37], [6139, 37, 37],
                    [6140, 25, 32], [6141, 37, 42], [6142, 31, 37], [6143, 32, 32], [6144, 27, 28], [6145, 40, 40],
                    [6146, 19, 27], [6147, 27, 40], [6148, 27, 34], [6149, 36, 36], [6150, 19, 27], [6151, 27, 28],
                    [6152, 23, 28], [6153, 25, 31], [6154, 36, 36], [6155, 25, 30], [6156, 28, 32], [6157, 43, 40],
                    [6158, 29, 31], [6159, 41, 39], [6160, 24, 28], [6161, 18, 25], [6162, 23, 27], [6163, 60, 51],
                    [6164, 37, 39], [6165, 32, 31], [6166, 53, 37], [6167, 60, 49], [6244, 58, 43], [6353, 23, 15],
                    [6357, 33, 26], [6358, 24, 31], [6359, 24, 24], [6360, 94, 70], [6361, 94, 80], [6362, 59, 57],
                    [6363, 59, 62], [6364, 94, 71], [6365, 102, 75], [6366, 102, 75], [6367, 57, 57], [6368, 94, 71],
                    [6369, 63, 62], [6370, 94, 70], [6371, 95, 79], [6372, 102, 75], [6373, 102, 82], [6374, 95, 70],
                    [6375, 105, 70], [6376, 64, 57], [6377, 105, 78], [6378, 59, 57], [6379, 64, 62], [6380, 64, 57],
                    [6381, 64, 57], [6382, 95, 70], [6383, 64, 57], [6384, 94, 71], [6385, 95, 59], [6386, 95, 70],
                    [6387, 94, 78], [6388, 95, 70], [6389, 102, 75], [6390, 94, 71], [6391, 58, 55], [6392, 95, 70],
                    [6393, 105, 78], [6394, 102, 75], [6395, 94, 71], [6396, 102, 75], [6397, 95, 70], [6398, 110, 82],
                    [6399, 102, 75], [6400, 92, 68], [6401, 63, 63], [6402, 102, 75], [6403, 110, 82], [6404, 102, 75],
                    [6405, 102, 75], [6406, 95, 70], [6407, 94, 71], [6408, 94, 71], [6409, 95, 70], [6410, 94, 71],
                    [6411, 91, 68], [6412, 95, 70], [6413, 110, 82], [6414, 105, 70], [6415, 94, 70], [6416, 102, 75],
                    [6417, 102, 75], [6418, 110, 82], [6419, 102, 82], [6420, 110, 82], [6421, 95, 70], [6422, 94, 71],
                    [6423, 31, 30], [6424, 64, 63], [6425, 64, 57], [6426, 95, 79], [6427, 110, 82], [6428, 105, 79],
                    [6429, 110, 81], [6430, 59, 63], [6431, 94, 71], [6432, 95, 79], [6433, 53, 56], [6434, 94, 70],
                    [6435, 63, 55], [6436, 105, 70], [6437, 102, 75], [6438, 95, 70], [6439, 95, 70], [6440, 105, 79],
                    [6441, 91, 68], [6442, 58, 56], [6443, 95, 70], [6444, 73, 80], [6445, 95, 70], [6446, 102, 75],
                    [6447, 58, 43], [6448, 95, 70], [6449, 102, 82], [6450, 105, 79], [6451, 102, 82], [6452, 105, 70],
                    [6453, 95, 70], [6454, 95, 70], [6455, 95, 70], [6456, 95, 70], [6457, 34, 37], [6458, 26, 30],
                    [6459, 110, 75], [6460, 105, 79], [6461, 95, 70], [6462, 94, 78], [6463, 94, 78], [6464, 110, 82],
                    [6465, 102, 82], [6466, 94, 70], [6467, 105, 79], [6468, 102, 75], [6469, 95, 70], [6470, 94, 71],
                    [6471, 95, 70], [6472, 102, 75], [6473, 102, 75], [6474, 95, 70], [6475, 95, 70], [6476, 95, 70],
                    [6477, 111, 83], [6478, 95, 70], [6479, 95, 70], [6480, 95, 70], [6481, 102, 75], [6482, 102, 82],
                    [6483, 95, 70], [6484, 64, 47], [6485, 91, 71], [6486, 102, 75], [6487, 94, 71], [6488, 94, 71],
                    [6489, 94, 70], [6490, 95, 70], [6491, 95, 70], [6492, 28, 30], [6493, 94, 71], [6494, 28, 29],
                    [6495, 91, 68], [6496, 94, 71], [6497, 110, 82], [6498, 110, 82], [6499, 105, 78], [6500, 64, 57],
                    [6501, 94, 71], [6502, 57, 57], [6503, 95, 70], [6504, 94, 80], [6505, 95, 70], [6506, 95, 79],
                    [6507, 102, 75], [6508, 102, 75], [6509, 94, 71], [6510, 110, 82], [6511, 94, 71], [6512, 94, 71],
                    [6513, 24, 22], [6514, 93, 69], [6515, 95, 78], [6516, 64, 53], [6517, 32, 29], [6518, 95, 79],
                    [6519, 105, 79], [6520, 110, 82], [6521, 49, 48], [6522, 95, 70], [6523, 110, 82], [6524, 105, 79],
                    [6525, 94, 71], [6526, 102, 75], [6527, 94, 71], [6528, 95, 70], [6529, 105, 80], [6530, 92, 68],
                    [6531, 102, 82], [6532, 95, 70], [6533, 95, 70], [6534, 95, 79], [6535, 102, 75], [6536, 32, 33],
                    [6537, 102, 75], [6538, 102, 82], [6539, 95, 70], [6540, 102, 82], [6541, 102, 75], [6542, 102, 75],
                    [6543, 102, 75], [6544, 102, 75], [6546, 102, 75], [6547, 110, 82], [6548, 102, 75],
                    [6549, 102, 82], [6550, 102, 75], [6551, 102, 75], [6552, 102, 82], [6553, 102, 75],
                    [6554, 102, 75], [6555, 102, 75], [6556, 102, 75], [6557, 102, 75], [6558, 95, 70], [6559, 102, 75],
                    [6560, 95, 70], [6561, 102, 82], [6562, 102, 75], [6563, 102, 75], [6564, 102, 75], [6565, 105, 80],
                    [6566, 95, 63], [6567, 102, 75], [6568, 94, 71], [6569, 94, 71], [6570, 102, 75], [6572, 102, 75],
                    [6573, 94, 71], [6574, 95, 70], [6575, 94, 70], [6576, 95, 70], [6577, 94, 71], [6578, 95, 70],
                    [6579, 102, 75], [6580, 94, 71], [6581, 105, 79], [6582, 95, 70], [6583, 105, 78], [6584, 111, 83],
                    [6585, 94, 71], [6586, 94, 71], [6587, 94, 71], [6588, 94, 70], [6589, 94, 70], [6590, 111, 83],
                    [6591, 102, 75], [6592, 102, 75], [6593, 102, 75], [6594, 102, 75], [6595, 95, 70], [6596, 95, 70],
                    [6597, 102, 75], [6598, 102, 75], [6599, 105, 79], [6600, 95, 70], [6601, 102, 75], [6602, 95, 70],
                    [6603, 59, 57], [6604, 102, 82], [6605, 95, 70], [6606, 94, 71], [6607, 105, 70], [6608, 95, 70],
                    [6609, 95, 70], [6610, 95, 70], [6611, 59, 57], [6612, 95, 79], [6613, 95, 70], [6614, 32, 33],
                    [6615, 94, 71], [6616, 95, 70], [6617, 35, 31], [6618, 94, 71], [6619, 102, 75], [6620, 102, 75],
                    [6621, 95, 70], [6622, 94, 71], [6623, 105, 79], [6624, 110, 75], [6625, 102, 75], [6626, 110, 82],
                    [6627, 95, 70], [6628, 102, 82], [6629, 59, 63], [6630, 63, 63], [6631, 53, 60], [6632, 24, 28],
                    [6633, 33, 37], [6634, 41, 39], [6635, 46, 43], [6636, 70, 65], [6637, 54, 39], [6638, 62, 48],
                    [6639, 46, 53], [6640, 61, 67], [6643, 40, 38], [6649, 54, 41], [6650, 54, 39], [6651, 37, 27],
                    [6652, 52, 40], [6653, 50, 46], [6654, 36, 36], [6655, 33, 31], [6656, 40, 36], [6657, 46, 43],
                    [6660, 41, 29], [6661, 32, 32], [6662, 46, 40], [6663, 36, 36], [6664, 44, 42], [6665, 36, 36],
                    [6666, 36, 32], [6667, 36, 36], [6668, 36, 27], [6669, 45, 42], [6670, 37, 36], [6671, 52, 36],
                    [6672, 41, 31], [6673, 42, 35], [6674, 40, 40], [6675, 37, 36], [6676, 53, 51], [6677, 36, 36],
                    [6678, 37, 36], [6679, 85, 80], [6680, 33, 31], [6682, 32, 32], [6683, 36, 36], [6684, 33, 42],
                    [6685, 28, 32], [6686, 27, 32], [6687, 28, 33], [6688, 27, 32], [6689, 28, 33], [6690, 27, 32],
                    [6697, 38, 29], [6699, 62, 53], [6700, 73, 66], [6701, 64, 78], [6702, 65, 43], [6704, 50, 42],
                    [6706, 43, 41], [6708, 58, 56], [6715, 62, 51], [6716, 79, 52], [6718, 85, 64], [6722, 64, 52],
                    [6723, 61, 46], [6725, 45, 45], [6726, 89, 60], [6728, 52, 50], [6730, 45, 45], [6734, 60, 45],
                    [6737, 64, 54], [6738, 50, 49], [6741, 17, 19], [6748, 32, 32], [6749, 35, 35], [6750, 52, 51],
                    [6752, 27, 32], [6753, 44, 40], [6754, 41, 39], [6755, 52, 52], [6756, 44, 44], [6757, 39, 39],
                    [6758, 44, 55], [6759, 27, 32], [6760, 52, 52], [6761, 52, 51], [6762, 44, 44], [6763, 29, 27],
                    [6764, 40, 44], [6766, 62, 60], [6767, 38, 38], [6768, 40, 40], [6769, 52, 65], [6770, 45, 51],
                    [6771, 45, 47], [6772, 35, 44], [6773, 60, 55], [6777, 60, 58], [6778, 36, 36], [6779, 45, 51],
                    [6780, 45, 48], [6781, 53, 51], [6782, 85, 72], [6783, 61, 59], [6784, 44, 44], [6785, 45, 44],
                    [6786, 45, 51], [6787, 40, 49], [6789, 52, 51], [6790, 89, 67], [6791, 76, 53], [6794, 87, 66],
                    [6795, 66, 58], [6798, 79, 56], [6803, 68, 59], [6804, 66, 58], [6805, 92, 70], [6806, 66, 59],
                    [6807, 85, 59], [6808, 91, 69], [6812, 97, 84], [6813, 85, 65], [6814, 77, 71], [6816, 80, 66],
                    [6818, 20, 22], [6819, 38, 46], [6820, 36, 40], [6821, 45, 48], [6822, 51, 51], [6823, 44, 46],
                    [6833, 72, 58], [6834, 90, 75], [6835, 98, 75], [6836, 88, 69], [6837, 89, 68], [6838, 102, 78],
                    [6841, 36, 27], [6845, 89, 67], [6846, 102, 88], [6847, 87, 66], [6848, 91, 70], [6849, 62, 59],
                    [6850, 89, 67], [6851, 87, 66], [6852, 92, 70], [6853, 94, 71], [6854, 85, 70], [6855, 89, 68],
                    [6856, 88, 67], [6857, 90, 75], [6858, 98, 74], [6859, 71, 56], [6860, 88, 67], [6861, 94, 78],
                    [6862, 92, 70], [6867, 12, 20], [6868, 12, 16], [6869, 15, 17], [6870, 15, 20], [6871, 15, 18],
                    [6872, 12, 18], [6873, 20, 20], [6874, 16, 20], [6875, 16, 19], [6876, 15, 20], [6877, 18, 20],
                    [6878, 15, 18], [6879, 15, 20], [6880, 20, 25], [6881, 15, 15], [6882, 16, 20], [6883, 15, 21],
                    [6884, 7, 8], [6885, 25, 16], [6886, 11, 16], [6887, 116, 39], [6888, 11, 12], [6889, 21, 14],
                    [6890, 8, 10], [6891, 18, 17], [6892, 9, 10], [6893, 22, 15], [6894, 7, 9], [6895, 28, 16],
                    [6896, 9, 11], [6897, 16, 15], [6898, 6, 8], [6899, 28, 14], [6900, 6, 7], [6901, 24, 16],
                    [6902, 10, 15], [6903, 34, 23], [6904, 11, 11], [6905, 42, 25], [6906, 8, 9], [6907, 25, 16],
                    [6908, 8, 8], [6909, 24, 18], [6910, 34, 30], [6911, 63, 43], [6912, 38, 24], [6913, 66, 41],
                    [6914, 13, 12], [6915, 42, 39], [6916, 11, 12], [6917, 30, 34], [6918, 30, 23], [6919, 30, 29],
                    [6920, 29, 23], [6921, 52, 38], [6922, 14, 13], [6923, 57, 41], [6924, 11, 12], [6925, 44, 42],
                    [6926, 67, 29], [6927, 71, 39], [6928, 21, 20], [6929, 58, 42], [6930, 22, 15], [6931, 42, 42],
                    [6932, 21, 14], [6933, 30, 28], [6934, 20, 15], [6935, 49, 51], [6936, 24, 22], [6937, 52, 42],
                    [6938, 21, 15], [6939, 53, 40], [6940, 13, 11], [6941, 31, 24], [6942, 33, 29], [6943, 62, 41],
                    [6944, 12, 12], [6945, 74, 57], [6946, 63, 35], [6947, 70, 51], [6948, 15, 13], [6949, 52, 39],
                    [6950, 17, 15], [6951, 57, 42], [6952, 62, 27], [6953, 67, 39], [6954, 30, 17], [6955, 52, 39],
                    [6956, 19, 16], [6957, 77, 65], [6958, 15, 12], [6959, 52, 42], [6960, 12, 11], [6961, 30, 27],
                    [6962, 13, 12], [6963, 12, 10], [6964, 27, 17], [6965, 9, 10], [6966, 29, 60], [6967, 23, 60],
                    [6968, 41, 85], [6969, 23, 53], [6970, 31, 63], [6971, 36, 28], [6972, 73, 34], [6973, 23, 12],
                    [6974, 6, 7], [6975, 9, 10], [6976, 21, 17], [6977, 7, 8], [6978, 51, 21], [6979, 7, 9],
                    [6980, 19, 15], [6981, 9, 9], [6982, 28, 16], [6983, 12, 13], [6984, 33, 24], [6985, 56, 31],
                    [6986, 112, 47], [6987, 9, 9], [6988, 26, 12], [6989, 14, 14], [6990, 30, 22], [6991, 7, 5],
                    [6992, 23, 13], [6993, 8, 8], [6994, 58, 26], [6995, 11, 10], [6996, 21, 16], [6997, 7, 6],
                    [6998, 15, 8], [6999, 7, 7], [7000, 21, 15], [7001, 7, 7], [7002, 18, 13], [7003, 8, 8],
                    [7004, 18, 14], [7005, 14, 15], [7006, 29, 24], [7007, 40, 31], [7008, 40, 30], [7009, 21, 15],
                    [7010, 20, 15], [7011, 10, 10], [7012, 23, 22], [7013, 29, 20], [7014, 13, 10], [7015, 12, 9],
                    [7019, 11, 10], [7020, 42, 42], [7021, 13, 12], [7022, 23, 22], [7023, 18, 18], [7024, 29, 28],
                    [7025, 15, 13], [7026, 29, 23], [7027, 20, 20], [7028, 42, 42], [7029, 42, 30], [7030, 58, 42],
                    [7031, 15, 13], [7032, 31, 23], [7033, 24, 23], [7034, 37, 31], [7035, 11, 12], [7036, 31, 31],
                    [7037, 29, 30], [7038, 38, 40], [7039, 24, 14], [7040, 31, 29], [7041, 15, 13], [7042, 58, 55],
                    [7043, 21, 29], [7044, 29, 28], [7045, 38, 24], [7046, 56, 40], [7047, 19, 15], [7048, 29, 24],
                    [7049, 54, 40], [7050, 21, 16], [7051, 59, 43], [7052, 16, 15], [7053, 54, 43], [7054, 18, 15],
                    [7055, 41, 29], [7056, 14, 15], [7057, 64, 43], [7058, 30, 19], [7059, 59, 43], [7060, 30, 20],
                    [7061, 54, 43], [7062, 19, 14], [7063, 50, 24], [7064, 30, 15], [7065, 44, 43], [7066, 13, 13],
                    [7067, 55, 43], [7068, 42, 33], [7069, 72, 59], [7070, 30, 21], [7071, 59, 42], [7072, 11, 12],
                    [7073, 30, 30], [7074, 26, 21], [7075, 56, 59], [7076, 30, 24], [7077, 41, 28], [7078, 11, 12],
                    [7079, 30, 24], [7080, 44, 38], [7081, 74, 58], [7082, 29, 24], [7083, 44, 42], [7084, 61, 23],
                    [7085, 66, 42], [7086, 13, 12], [7087, 45, 39], [7088, 29, 26], [7089, 58, 42], [7090, 20, 12],
                    [7091, 57, 42], [7092, 56, 25], [7093, 74, 63], [7094, 40, 29], [7095, 60, 42], [7096, 30, 24],
                    [7097, 42, 29], [7098, 29, 28], [7099, 55, 43], [7100, 15, 13], [7101, 21, 19], [7102, 14, 11],
                    [7103, 34, 18], [7104, 10, 7], [7105, 22, 13], [7106, 5, 7], [7107, 22, 12], [7108, 11, 9],
                    [7109, 28, 15], [7110, 9, 11], [7111, 27, 14], [7112, 5, 5], [7113, 32, 14], [7114, 27, 20],
                    [7115, 48, 26], [7116, 10, 11], [7117, 34, 22], [7118, 8, 15], [7119, 17, 15], [7120, 11, 13],
                    [7121, 39, 35], [7122, 9, 8], [7123, 28, 16], [7124, 7, 10], [7125, 16, 16], [7126, 8, 7],
                    [7127, 20, 16], [7128, 9, 8], [7129, 21, 14], [7130, 8, 9], [7131, 23, 14], [7132, 8, 8],
                    [7133, 33, 20], [7134, 17, 11], [7135, 25, 11], [7136, 17, 13], [7137, 33, 19], [7138, 9, 9],
                    [7139, 24, 18], [7140, 6, 7], [7141, 14, 12], [7142, 9, 10], [7143, 25, 14], [7144, 9, 9],
                    [7145, 18, 14], [7146, 10, 11], [7147, 27, 20], [7148, 8, 11], [7149, 35, 21], [7150, 5, 8],
                    [7151, 18, 14], [7152, 8, 8], [7153, 27, 21], [7154, 17, 19], [7155, 25, 24], [7156, 19, 19],
                    [7157, 9, 8], [7158, 42, 23], [7159, 19, 14], [7160, 48, 31], [7161, 9, 11], [7162, 26, 21],
                    [7163, 8, 7], [7164, 21, 13], [7165, 12, 11], [7166, 56, 31], [7167, 7, 7], [7168, 27, 18],
                    [7169, 5, 5], [7170, 36, 22], [7171, 6, 7], [7172, 40, 25], [7173, 14, 13], [7174, 67, 41],
                    [7175, 6, 5], [7176, 17, 13], [7177, 15, 9], [7178, 23, 13], [7179, 15, 14], [7180, 49, 30],
                    [7181, 10, 10], [7182, 40, 19], [7183, 18, 11], [7184, 88, 59], [7185, 17, 14], [7186, 50, 26],
                    [7187, 13, 10], [7188, 47, 25], [7189, 16, 15], [7190, 44, 26], [7191, 16, 13], [7192, 26, 16],
                    [7193, 14, 13], [7194, 21, 12], [7195, 14, 12], [7196, 40, 23], [7197, 8, 6], [7198, 21, 11],
                    [7199, 14, 11], [7200, 32, 17], [7201, 6, 5], [7202, 14, 9], [7203, 10, 7], [7204, 18, 16],
                    [7205, 18, 16], [7206, 54, 31], [7207, 14, 14], [7208, 40, 25], [7209, 16, 10], [7210, 49, 39],
                    [7211, 9, 10], [7212, 27, 16], [7213, 8, 8], [7214, 66, 34], [7215, 8, 6], [7216, 54, 27],
                    [7217, 12, 10], [7218, 30, 20], [7219, 16, 16], [7220, 35, 23], [7221, 14, 11], [7222, 32, 23],
                    [7223, 12, 11], [7224, 40, 21], [7225, 7, 8], [7226, 27, 17], [7227, 10, 11], [7228, 30, 22],
                    [7229, 13, 9], [7230, 59, 29], [7231, 10, 9], [7232, 30, 19], [7233, 8, 6], [7234, 26, 16],
                    [7235, 12, 10], [7236, 21, 16], [7237, 7, 7], [7238, 21, 14], [7239, 8, 8], [7240, 19, 13],
                    [7241, 20, 20], [7242, 27, 15], [7243, 5, 6], [7244, 18, 12], [7245, 5, 7], [7246, 26, 15],
                    [7247, 7, 8], [7248, 25, 17], [7249, 7, 8], [7250, 24, 15], [7251, 17, 19], [7252, 29, 23],
                    [7253, 14, 10], [7254, 57, 17], [7255, 47, 24], [7256, 24, 16], [7257, 111, 83], [7258, 111, 83],
                    [7259, 96, 60], [7260, 118, 91], [7261, 96, 82], [7262, 99, 112], [7263, 103, 89], [7264, 109, 123],
                    [7265, 98, 85], [7266, 121, 91], [7267, 97, 83], [7268, 121, 91], [7269, 121, 91], [7270, 94, 59],
                    [7271, 68, 66], [7272, 118, 89], [7273, 110, 124], [7274, 117, 88], [7275, 101, 88], [7276, 65, 59],
                    [7277, 97, 83], [7278, 100, 113], [7279, 110, 81], [7280, 121, 92], [7281, 96, 82], [7282, 98, 111],
                    [7283, 14, 23], [7284, 11, 10], [7285, 12, 11], [7286, 18, 27], [7287, 16, 31], [7288, 34, 36],
                    [7289, 36, 27], [7290, 60, 39], [7291, 45, 37], [7292, 43, 45], [7293, 29, 27], [7294, 28, 27],
                    [7295, 14, 13], [7296, 25, 22], [7297, 27, 23], [7298, 16, 19], [7299, 16, 21], [7300, 20, 32],
                    [7301, 13, 28], [7302, 49, 56], [7303, 81, 78], [7304, 38, 42], [7305, 51, 52], [7306, 35, 41],
                    [7307, 53, 59], [7308, 43, 49], [7309, 38, 44], [7310, 85, 73], [7311, 70, 69], [7312, 49, 52],
                    [7313, 109, 80], [7314, 98, 74], [7315, 95, 72], [7316, 99, 74], [7317, 100, 75], [7318, 98, 75],
                    [7319, 112, 83], [7320, 97, 73], [7321, 126, 94], [7322, 98, 73], [7323, 121, 91], [7324, 109, 80],
                    [7325, 100, 75], [7326, 99, 74], [7327, 122, 91], [7328, 36, 42], [7329, 66, 63], [7330, 45, 45],
                    [7331, 45, 45], [7332, 35, 40], [7333, 67, 82], [7337, 15, 15], [7342, 13, 8], [7343, 13, 9],
                    [7344, 12, 9], [7348, 12, 8], [7352, 11, 9], [7354, 14, 13], [7356, 11, 8], [7357, 21, 11],
                    [7358, 15, 11], [7359, 25, 12], [7360, 13, 10], [7362, 11, 9], [7363, 12, 12], [7364, 12, 12],
                    [7367, 13, 8], [7370, 12, 11], [7371, 16, 12], [7372, 18, 10], [7373, 15, 11], [7374, 11, 8],
                    [7375, 12, 8], [7376, 9, 8], [7377, 11, 8], [7378, 20, 19], [7379, 34, 26], [7396, 44, 44],
                    [7397, 73, 58], [7398, 44, 45], [7399, 34, 39], [7400, 56, 54], [7401, 34, 40], [7402, 69, 85],
                    [7403, 28, 34], [7404, 82, 63], [7405, 43, 44], [7406, 62, 74], [7407, 45, 44], [7408, 56, 67],
                    [7409, 22, 27], [7410, 24, 29], [7411, 24, 29], [7412, 48, 51], [7413, 22, 28], [7414, 22, 27],
                    [7415, 21, 31], [7416, 28, 35], [7417, 23, 29], [7418, 26, 28], [7419, 54, 58], [7420, 22, 29],
                    [7421, 40, 47], [7422, 22, 27], [7423, 33, 35], [7424, 56, 50], [7425, 38, 34], [7426, 63, 56],
                    [7427, 49, 46], [7428, 52, 51], [7429, 30, 33], [7430, 48, 37], [7431, 34, 36], [7432, 79, 60],
                    [7433, 50, 48], [7434, 84, 54], [7435, 58, 53], [7436, 67, 61], [7437, 29, 37], [7438, 52, 50],
                    [7439, 44, 41], [7440, 71, 62], [7441, 41, 38], [7442, 62, 53], [7443, 67, 59], [7444, 77, 63],
                    [7445, 66, 56], [7446, 92, 70], [7447, 39, 39], [7448, 68, 65], [7449, 25, 24], [7450, 25, 28],
                    [7451, 16, 18], [7452, 29, 20], [7453, 70, 35], [7454, 21, 22], [7455, 30, 27], [7456, 91, 68],
                    [7457, 66, 64], [7458, 46, 45], [7459, 66, 64], [7460, 66, 72], [7461, 46, 44], [7462, 55, 53],
                    [7463, 62, 61], [7464, 74, 56], [7465, 70, 53], [7466, 62, 46], [7467, 66, 64], [7468, 54, 53],
                    [7469, 74, 56], [7470, 83, 61], [7471, 103, 76], [7472, 37, 79], [7473, 46, 53], [7474, 66, 64],
                    [7475, 66, 64], [7476, 58, 56], [7477, 51, 49], [7478, 54, 53], [7479, 54, 53], [7480, 66, 55],
                    [7481, 46, 53], [7482, 62, 46], [7483, 66, 64], [7484, 49, 56], [7485, 107, 79], [7486, 86, 64],
                    [7487, 58, 56], [7488, 70, 53], [7489, 78, 51], [7490, 55, 53], [7491, 70, 53], [7492, 86, 64],
                    [7493, 62, 60], [7494, 62, 60], [7495, 66, 64], [7496, 107, 79], [7497, 71, 53], [7498, 46, 53],
                    [7499, 54, 45], [7500, 57, 56], [7501, 74, 56], [7502, 70, 53], [7503, 78, 59], [7504, 74, 55],
                    [7505, 62, 60], [7506, 74, 56], [7507, 59, 56], [7508, 70, 53], [7509, 66, 64], [7510, 66, 64],
                    [7511, 74, 56], [7512, 66, 64], [7513, 70, 53], [7514, 113, 85], [7515, 78, 58], [7516, 66, 64],
                    [7517, 107, 79], [7518, 74, 56], [7519, 62, 60], [7520, 62, 61], [7521, 46, 53], [7522, 83, 61],
                    [7523, 62, 61], [7524, 101, 98], [7525, 66, 64], [7526, 74, 55], [7527, 46, 53], [7528, 91, 68],
                    [7529, 107, 103], [7530, 83, 61], [7531, 49, 56], [7532, 66, 64], [7533, 91, 68], [7534, 107, 103],
                    [7535, 62, 61], [7536, 83, 61], [7537, 82, 61], [7538, 91, 68], [7539, 62, 61], [7540, 91, 68],
                    [7541, 78, 58], [7542, 91, 68], [7543, 78, 58], [7544, 82, 61], [7545, 58, 56], [7546, 71, 53],
                    [7547, 70, 53], [7548, 57, 56], [7549, 66, 64], [7550, 54, 53], [7551, 55, 53], [7552, 55, 53],
                    [7553, 62, 61], [7554, 99, 88], [7555, 91, 72], [7556, 66, 64], [7557, 107, 79], [7558, 46, 45],
                    [7559, 70, 53], [7560, 55, 53], [7561, 107, 79], [7562, 107, 79], [7563, 83, 61], [7564, 78, 58],
                    [7565, 62, 61], [7566, 62, 60], [7567, 66, 64], [7568, 62, 61], [7569, 62, 61], [7570, 62, 60],
                    [7571, 62, 60], [7572, 107, 79], [7573, 66, 56], [7574, 62, 60], [7575, 74, 56], [7576, 74, 56],
                    [7577, 83, 61], [7578, 62, 61], [7579, 83, 61], [7580, 83, 61], [7581, 78, 59], [7582, 78, 68],
                    [7583, 66, 64], [7584, 58, 56], [7585, 58, 57], [7586, 107, 79], [7587, 57, 56], [7588, 62, 61],
                    [7589, 107, 79], [7590, 66, 64], [7591, 70, 53], [7592, 83, 61], [7593, 82, 61], [7594, 62, 60],
                    [7595, 62, 61], [7596, 54, 53], [7597, 62, 61], [7598, 74, 56], [7599, 66, 64], [7600, 66, 64],
                    [7601, 55, 53], [7602, 51, 49], [7603, 66, 64], [7604, 66, 64], [7605, 66, 64], [7606, 66, 56],
                    [7607, 83, 61], [7608, 55, 53], [7609, 66, 64], [7610, 54, 54], [7611, 44, 64], [7612, 66, 61],
                    [7613, 62, 61], [7614, 70, 60], [7615, 83, 61], [7616, 78, 58], [7617, 70, 54], [7618, 78, 58],
                    [7619, 66, 64], [7620, 57, 56], [7621, 66, 64], [7622, 83, 61], [7623, 62, 60], [7624, 91, 68],
                    [7625, 54, 53], [7626, 78, 58], [7627, 59, 56], [7628, 83, 61], [7629, 54, 53], [7630, 58, 56],
                    [7631, 62, 60], [7632, 78, 58], [7633, 54, 53], [7634, 17, 29], [7635, 17, 25], [7636, 20, 28],
                    [7637, 37, 36], [7638, 26, 22], [7639, 13, 15], [7640, 11, 13], [7641, 15, 18], [7642, 35, 41],
                    [7643, 18, 19], [7644, 34, 45], [7645, 18, 24], [7646, 32, 30], [7647, 43, 28], [7648, 12, 13],
                    [7649, 13, 13], [7650, 19, 21], [7651, 15, 13], [7652, 17, 14], [7653, 49, 38], [7654, 14, 16],
                    [7655, 17, 17], [7656, 15, 14], [7657, 30, 31], [7658, 22, 30], [7659, 13, 19], [7661, 10, 10],
                    [7662, 15, 13], [7663, 18, 19], [7664, 26, 37], [7665, 39, 55], [7666, 16, 19], [7667, 16, 19],
                    [7668, 17, 13], [7669, 11, 8], [7670, 31, 25], [7671, 42, 36], [7672, 10, 9], [7673, 8, 7],
                    [7674, 21, 18], [7675, 9, 10], [7676, 6, 7], [7677, 6, 6], [7678, 10, 8], [7679, 13, 10],
                    [7680, 20, 21], [7681, 5, 3], [7682, 16, 13], [7683, 5, 3], [7684, 15, 15], [7685, 12, 11],
                    [7686, 22, 19], [7687, 5, 3], [7688, 16, 15], [7689, 12, 12], [7690, 7, 8], [7691, 21, 25],
                    [7692, 11, 10], [7693, 9, 9], [7694, 10, 9], [7695, 30, 20], [7696, 5, 3], [7697, 16, 12],
                    [7698, 10, 8], [7699, 13, 15], [7700, 11, 10], [7701, 9, 8], [7702, 17, 13], [7703, 13, 14],
                    [7704, 18, 18], [7705, 22, 14], [7706, 11, 10], [7707, 10, 10], [7708, 9, 7], [7709, 12, 15],
                    [7710, 6, 6], [7711, 16, 12], [7712, 13, 10], [7713, 20, 12], [7714, 11, 9], [7715, 38, 45],
                    [7716, 44, 44], [7717, 67, 81], [7718, 45, 45], [7719, 34, 40], [7720, 70, 86], [7721, 46, 45],
                    [7722, 56, 46], [7723, 33, 39], [7724, 64, 77], [7725, 21, 28], [7726, 37, 43], [7727, 48, 47],
                    [7728, 62, 60], [7729, 46, 46], [7730, 33, 38], [7731, 66, 79], [7732, 36, 42], [7733, 57, 67],
                    [7734, 70, 55], [7735, 86, 83], [7736, 34, 40], [7737, 54, 52], [7738, 34, 39], [7739, 42, 53],
                    [7740, 34, 40], [7741, 55, 64], [7742, 59, 62], [7743, 45, 44], [7744, 65, 78], [7745, 67, 52],
                    [7746, 46, 46], [7747, 57, 71], [7748, 58, 56], [7749, 47, 47], [7750, 62, 75], [7751, 71, 56],
                    [7752, 85, 81], [7753, 56, 54], [7754, 47, 47], [7755, 35, 40], [7756, 82, 54], [7757, 63, 54],
                    [7758, 93, 71], [7759, 33, 37], [7760, 61, 61], [7761, 37, 46], [7762, 71, 66], [7763, 17, 25],
                    [7764, 17, 22], [7765, 19, 27], [7766, 11, 20], [7767, 27, 34], [7768, 11, 22], [7769, 39, 37],
                    [7770, 56, 42], [7771, 16, 18], [7772, 15, 19], [7773, 24, 27], [7774, 14, 24], [7775, 41, 40],
                    [7776, 17, 34], [7777, 23, 37], [7778, 9, 13], [7779, 15, 20], [7780, 21, 21], [7781, 27, 31],
                    [7782, 33, 27], [7783, 34, 26], [7784, 14, 32], [7785, 24, 42], [7786, 15, 17], [7787, 25, 31],
                    [7788, 21, 24], [7789, 23, 29], [7790, 22, 29], [7791, 43, 41], [7792, 19, 24], [7793, 36, 36],
                    [7795, 53, 47], [7796, 76, 60], [7797, 53, 49], [7798, 53, 47], [7799, 53, 50], [7800, 52, 51],
                    [7801, 56, 50], [7802, 53, 45], [7803, 57, 54], [7804, 80, 60], [7805, 54, 49], [7806, 56, 49],
                    [7807, 53, 45], [7808, 83, 62], [7809, 82, 61], [7810, 52, 45], [7811, 54, 48], [7812, 53, 47],
                    [7813, 55, 48], [7815, 55, 49], [7816, 54, 46], [7817, 82, 61], [7818, 55, 49], [7819, 55, 48],
                    [7820, 56, 62], [7821, 53, 47], [7822, 82, 64], [7823, 75, 59], [7824, 88, 66], [7825, 54, 47],
                    [7826, 82, 61], [7827, 40, 41], [7828, 54, 48], [7829, 51, 51], [7830, 54, 47], [7831, 54, 51],
                    [7832, 55, 48], [7833, 52, 46], [7834, 41, 42], [7835, 55, 48], [7836, 87, 65], [7837, 54, 47],
                    [7838, 81, 60], [7839, 55, 48], [7840, 82, 61], [7841, 53, 46], [7842, 53, 49], [7843, 53, 47],
                    [7844, 52, 45], [7845, 21, 13], [7846, 55, 48], [7847, 83, 62], [7848, 83, 62], [7849, 89, 66],
                    [7850, 40, 41], [7851, 53, 45], [7852, 35, 38], [7853, 41, 43], [7854, 40, 40], [7855, 40, 41],
                    [7856, 37, 42], [7857, 54, 46], [7858, 53, 48], [7859, 51, 50], [7860, 54, 47], [7861, 50, 43],
                    [7862, 93, 68], [7863, 95, 71], [7864, 53, 49], [7865, 57, 51], [7866, 82, 61], [7867, 55, 48],
                    [7868, 54, 47], [7869, 80, 59], [7870, 54, 47], [7871, 53, 50], [7872, 81, 60], [7873, 53, 46],
                    [7874, 54, 47], [7875, 40, 41], [7876, 53, 46], [7877, 85, 63], [7878, 56, 53], [7879, 53, 49],
                    [7880, 53, 50], [7881, 53, 49], [7882, 39, 34], [7883, 41, 42], [7884, 53, 47], [7885, 52, 49],
                    [7886, 53, 49], [7887, 54, 47], [7888, 54, 47], [7889, 81, 60], [7890, 53, 49], [7891, 40, 41],
                    [7892, 55, 48], [7893, 54, 47], [7894, 56, 49], [7895, 54, 51], [7896, 81, 60], [7897, 84, 63],
                    [7898, 54, 47], [7899, 55, 52], [7900, 81, 60], [7901, 52, 45], [7902, 52, 52], [7903, 81, 60],
                    [7904, 54, 47], [7905, 53, 45], [7906, 54, 48], [7907, 82, 61], [7908, 76, 60], [7909, 54, 49],
                    [7910, 55, 48], [7911, 53, 45], [7912, 55, 48], [7913, 53, 49], [7914, 53, 49], [7915, 81, 60],
                    [7916, 78, 61], [7917, 84, 63], [7918, 53, 46], [7919, 54, 47], [7920, 83, 62], [7921, 54, 47],
                    [7922, 56, 50], [7923, 52, 46], [7924, 54, 47], [7925, 54, 47], [7926, 79, 62], [7927, 55, 48],
                    [7928, 36, 42], [7929, 85, 63], [7930, 53, 46], [7931, 54, 47], [7932, 54, 47], [7933, 40, 43],
                    [7934, 37, 42], [7935, 56, 49], [7936, 55, 48], [7937, 54, 46], [7938, 53, 47], [7939, 81, 63],
                    [7940, 80, 59], [7941, 81, 61], [7942, 53, 50], [7943, 55, 48], [7944, 36, 41], [7945, 81, 60],
                    [7946, 54, 48], [7947, 81, 60], [7948, 41, 42], [7949, 82, 61], [7950, 89, 66], [7951, 52, 46],
                    [7952, 44, 38], [7953, 41, 42], [7954, 55, 48], [7955, 55, 48], [7956, 56, 49], [7957, 77, 61],
                    [7958, 85, 63], [7959, 55, 48], [7960, 48, 48], [7961, 55, 50], [7962, 56, 50], [7963, 40, 41],
                    [7964, 82, 61], [7965, 55, 52], [7966, 52, 48], [7967, 54, 46], [7968, 95, 70], [7969, 81, 61],
                    [7970, 55, 48], [7971, 40, 42], [7972, 53, 46], [7974, 41, 43], [7975, 55, 48], [7976, 84, 62],
                    [7977, 54, 48], [7978, 81, 60], [7979, 83, 62], [7980, 54, 46], [7981, 82, 61], [7982, 55, 48],
                    [7983, 53, 47], [7984, 83, 62], [7985, 53, 50], [7986, 54, 46], [7987, 53, 50], [7988, 80, 60],
                    [7989, 44, 49], [7990, 54, 41], [7992, 56, 50], [7993, 81, 63], [7994, 52, 46], [7995, 53, 48],
                    [7996, 53, 49], [7997, 55, 48], [7998, 55, 48], [7999, 53, 47], [8000, 40, 42], [8001, 52, 49],
                    [8002, 40, 41], [8003, 37, 42], [8004, 40, 41], [8005, 23, 29], [8006, 16, 21], [8007, 27, 34],
                    [8008, 22, 28], [8009, 18, 19], [8010, 15, 18], [8011, 18, 20], [8012, 13, 16], [8013, 8, 8],
                    [8014, 9, 10], [8015, 11, 11], [8016, 6, 5], [8017, 13, 14], [8018, 7, 8], [8019, 17, 18],
                    [8020, 14, 15], [8021, 7, 7], [8022, 28, 36], [8023, 17, 19], [8024, 23, 20], [8025, 17, 23],
                    [8026, 19, 21], [8027, 13, 11], [8028, 15, 15], [8029, 28, 26], [8030, 18, 17], [8031, 12, 11],
                    [8032, 19, 26], [8033, 27, 30], [8034, 26, 36], [8035, 22, 21], [8036, 18, 23], [8037, 24, 29],
                    [8038, 45, 44], [8039, 36, 66], [8040, 22, 66], [8041, 7, 16], [8042, 7, 10], [8043, 11, 17],
                    [8044, 12, 16], [8045, 5, 3], [8046, 5, 3], [8047, 5, 6], [8048, 16, 21], [8049, 12, 16],
                    [8050, 9, 11], [8051, 21, 24], [8052, 38, 47], [8053, 26, 36], [8054, 22, 32], [8055, 32, 48],
                    [8056, 43, 51], [8057, 25, 34], [8058, 21, 27], [8059, 26, 32], [8060, 29, 35], [8061, 56, 64],
                    [8062, 58, 76], [8063, 12, 9], [8064, 13, 15], [8065, 17, 13], [8066, 79, 50], [8067, 42, 32],
                    [8068, 12, 10], [8069, 13, 28], [8070, 17, 18], [8071, 49, 22], [8072, 40, 24], [8073, 60, 31],
                    [8074, 13, 15], [8075, 14, 18], [8076, 60, 43], [8079, 64, 51], [8080, 83, 25], [8081, 99, 53],
                    [8082, 69, 41], [8083, 106, 45], [8084, 61, 52], [8085, 47, 33], [8086, 17, 48], [8087, 15, 33],
                    [8088, 19, 39], [8089, 23, 51], [8090, 24, 36], [8091, 24, 66], [8092, 22, 50], [8093, 25, 66],
                    [8094, 14, 66], [8095, 22, 28], [8096, 25, 40], [8097, 21, 35], [8098, 9, 27], [8099, 45, 45],
                    [8100, 44, 44], [8101, 45, 45], [8102, 34, 39], [8103, 46, 45], [8104, 45, 44], [8105, 72, 57],
                    [8106, 47, 47], [8107, 34, 40], [8108, 54, 52], [8109, 46, 46], [8110, 34, 40], [8111, 53, 50],
                    [8112, 45, 44], [8113, 72, 57], [8114, 34, 39], [8115, 70, 87], [8116, 47, 47], [8117, 55, 81],
                    [8118, 35, 41], [8119, 46, 46], [8120, 53, 51], [8121, 35, 40], [8122, 45, 45], [8123, 73, 58],
                    [8124, 46, 47], [8125, 73, 58], [8126, 41, 42], [8127, 47, 47], [8128, 90, 87], [8129, 45, 45],
                    [8130, 73, 57], [8131, 33, 39], [8132, 55, 52], [8133, 35, 41], [8134, 56, 53], [8135, 73, 57],
                    [8136, 27, 33], [8137, 45, 46], [8138, 47, 48], [8139, 64, 74], [8140, 54, 67], [8141, 44, 44],
                    [8142, 45, 45], [8143, 69, 85], [8144, 31, 37], [8145, 34, 39], [8146, 53, 62], [8147, 44, 44],
                    [8148, 46, 46], [8149, 35, 41], [8150, 73, 90], [8151, 33, 39], [8152, 62, 77], [8153, 45, 46],
                    [8154, 44, 44], [8155, 67, 53], [8156, 79, 101], [8157, 47, 47], [8158, 45, 45], [8159, 42, 42],
                    [8160, 45, 45], [8161, 73, 58], [8162, 75, 59], [8163, 56, 49], [8164, 44, 44], [8165, 47, 46],
                    [8166, 86, 65], [8167, 73, 58], [8168, 45, 46], [8169, 55, 50], [8170, 46, 46], [8171, 45, 46],
                    [8172, 86, 64], [8173, 45, 45], [8174, 46, 45], [8175, 35, 40], [8176, 34, 39], [8177, 36, 42],
                    [8178, 47, 47], [8179, 53, 51], [8180, 45, 44], [8181, 85, 64], [8182, 73, 57], [8183, 48, 47],
                    [8184, 44, 44], [8185, 44, 45], [8186, 47, 46], [8187, 36, 41], [8188, 27, 33], [8189, 54, 51],
                    [8190, 34, 39], [8191, 71, 71], [8192, 47, 47], [8193, 84, 63], [8194, 44, 44], [8195, 46, 45],
                    [8196, 36, 41], [8197, 48, 47], [8198, 36, 41], [8199, 66, 80], [8200, 34, 40], [8201, 87, 66],
                    [8202, 58, 58], [8203, 81, 57], [8204, 72, 57], [8205, 32, 37], [8206, 58, 57], [8207, 45, 45],
                    [8208, 34, 39], [8209, 87, 66], [8210, 47, 47], [8211, 69, 85], [8212, 34, 39], [8213, 46, 46],
                    [8214, 67, 82], [8215, 46, 45], [8216, 45, 45], [8217, 47, 47], [8218, 21, 29], [8219, 58, 56],
                    [8220, 33, 39], [8221, 54, 51], [8222, 29, 34], [8223, 34, 39], [8224, 52, 61], [8225, 39, 46],
                    [8226, 69, 84], [8227, 45, 45], [8228, 32, 37], [8229, 44, 44], [8230, 46, 46], [8231, 28, 33],
                    [8232, 63, 62], [8233, 45, 45], [8234, 32, 37], [8235, 67, 81], [8236, 34, 40], [8237, 62, 59],
                    [8238, 45, 44], [8239, 99, 75], [8240, 46, 45], [8241, 35, 41], [8242, 56, 54], [8245, 46, 46],
                    [8246, 48, 47], [8247, 72, 57], [8248, 28, 34], [8249, 55, 52], [8250, 44, 44], [8251, 46, 45],
                    [8252, 53, 51], [8253, 71, 56], [8254, 39, 47], [8255, 45, 44], [8256, 35, 40], [8257, 67, 81],
                    [8258, 45, 45], [8259, 45, 44], [8260, 47, 47], [8261, 66, 79], [8262, 57, 57], [8263, 80, 61],
                    [8264, 37, 44], [8265, 57, 86], [8267, 71, 56], [8268, 46, 45], [8269, 45, 45], [8270, 27, 33],
                    [8271, 35, 41], [8272, 54, 51], [8273, 45, 45], [8274, 45, 44], [8275, 36, 42], [8276, 45, 44],
                    [8277, 42, 30], [8278, 73, 57], [8279, 45, 45], [8280, 48, 47], [8281, 45, 45], [8282, 48, 47],
                    [8283, 47, 46], [8284, 46, 45], [8285, 48, 47], [8286, 48, 47], [8287, 47, 47], [8288, 35, 41],
                    [8289, 55, 52], [8290, 47, 47], [8291, 48, 47], [8292, 46, 46], [8293, 45, 44], [8294, 45, 45],
                    [8295, 72, 57], [8296, 72, 47], [8297, 46, 46], [8298, 29, 53], [8299, 28, 34], [8300, 86, 65],
                    [8301, 47, 47], [8302, 45, 44], [8303, 73, 58], [8304, 45, 44], [8305, 71, 56], [8306, 36, 41],
                    [8307, 27, 33], [8308, 45, 44], [8309, 20, 26], [8310, 54, 52], [8311, 18, 22], [8312, 17, 19],
                    [8313, 16, 19], [8314, 19, 22], [8315, 17, 19], [8316, 16, 18], [8317, 50, 50], [8318, 78, 59],
                    [8319, 27, 30], [8320, 73, 58], [8321, 47, 36], [8322, 47, 46], [8323, 35, 41], [8324, 82, 61],
                    [8325, 77, 60], [8326, 72, 57], [8327, 70, 56], [8328, 74, 59], [8329, 45, 45], [8330, 74, 59],
                    [8331, 71, 56], [8332, 72, 57], [8333, 24, 31], [8334, 20, 27], [8335, 16, 26], [8336, 23, 19],
                    [8337, 14, 18], [8338, 13, 14], [8339, 44, 45], [8340, 16, 19], [8341, 31, 35], [8342, 17, 17],
                    [8343, 19, 20], [8344, 15, 14], [8345, 20, 16], [8346, 20, 28], [8347, 17, 20], [8348, 24, 31],
                    [8349, 16, 19], [8350, 18, 20], [8351, 15, 11], [8352, 21, 31], [8353, 16, 19], [8354, 25, 31],
                    [8355, 17, 18], [8356, 25, 31], [8357, 17, 17], [8358, 25, 19], [8359, 35, 44], [8360, 37, 44],
                    [8361, 17, 15], [8362, 19, 27], [8363, 25, 34], [8364, 30, 26], [8365, 13, 15], [8366, 25, 22],
                    [8367, 16, 17], [8368, 19, 27], [8369, 20, 27], [8370, 21, 23], [8371, 21, 21], [8372, 26, 22],
                    [8373, 26, 32], [8374, 24, 33], [8375, 17, 15], [8376, 29, 31], [8377, 22, 18], [8378, 23, 19],
                    [8379, 27, 24], [8380, 31, 31], [8381, 28, 36], [8382, 21, 24], [8383, 26, 31], [8384, 24, 37],
                    [8385, 22, 28], [8386, 16, 19], [8387, 26, 27], [8388, 18, 19], [8389, 18, 21], [8390, 15, 17],
                    [8391, 18, 22], [8392, 21, 24], [8393, 40, 55], [8394, 27, 21], [8395, 21, 23], [8396, 56, 52],
                    [8397, 82, 61], [8398, 56, 43], [8399, 76, 48], [8400, 66, 60], [8401, 77, 47], [8402, 59, 48],
                    [8403, 68, 46], [8404, 52, 49], [8405, 69, 46], [8406, 58, 48], [8407, 56, 54], [8408, 52, 59],
                    [8409, 39, 34], [8410, 66, 51], [8411, 86, 61], [8412, 54, 52], [8413, 68, 54], [8414, 93, 46],
                    [8415, 102, 66], [8416, 37, 38], [8417, 73, 49], [8418, 28, 32], [8419, 63, 46], [8420, 72, 55],
                    [8421, 80, 60], [8422, 36, 39], [8423, 59, 57], [8424, 76, 81], [8425, 44, 57], [8426, 50, 46],
                    [8427, 52, 44], [8428, 59, 48], [8429, 36, 35], [8430, 59, 57], [8431, 78, 59], [8432, 61, 57],
                    [8433, 58, 55], [8434, 76, 50], [8435, 117, 58], [8436, 82, 61], [8438, 40, 35], [8439, 45, 42],
                    [8440, 94, 57], [8441, 79, 50], [8442, 51, 49], [8443, 67, 60], [8444, 59, 57], [8445, 33, 31],
                    [8446, 44, 38], [8447, 65, 53], [8448, 53, 48], [8449, 103, 44], [8450, 82, 56], [8451, 22, 31],
                    [8452, 30, 43], [8453, 20, 27], [8454, 30, 39], [8455, 24, 31], [8456, 24, 31], [8457, 59, 57],
                    [8458, 48, 39], [8459, 68, 48], [8460, 54, 50], [8461, 84, 48], [8462, 73, 50], [8463, 72, 59],
                    [8464, 81, 60], [8465, 39, 30], [8466, 42, 51], [8467, 47, 43], [8468, 63, 53], [8469, 54, 48],
                    [8470, 81, 62], [8471, 39, 46], [8472, 89, 45], [8473, 66, 60], [8474, 52, 49], [8475, 76, 58],
                    [8476, 77, 59], [8477, 77, 58], [8478, 33, 36], [8479, 52, 49], [8480, 81, 61], [8481, 56, 47],
                    [8482, 56, 47], [8483, 57, 48], [8484, 68, 52], [8485, 74, 61], [8486, 37, 32], [8487, 65, 48],
                    [8488, 51, 46], [8489, 36, 59], [8490, 68, 53], [8491, 58, 58], [8492, 60, 47], [8493, 75, 47],
                    [8494, 36, 31], [8495, 83, 85], [8496, 36, 48], [8497, 60, 63], [8498, 42, 48], [8499, 53, 47],
                    [8500, 78, 50], [8501, 59, 70], [8502, 81, 49], [8503, 78, 59], [8504, 53, 51], [8505, 79, 60],
                    [8506, 81, 61], [8507, 81, 61], [8508, 43, 44], [8509, 52, 48], [8510, 84, 59], [8511, 74, 57],
                    [8512, 59, 57], [8513, 61, 58], [8514, 67, 66], [8515, 54, 52], [8516, 138, 77], [8517, 70, 29],
                    [8518, 83, 77], [8519, 42, 39], [8520, 57, 47], [8521, 51, 47], [8522, 54, 50], [8523, 52, 48],
                    [8524, 51, 46], [8525, 67, 48], [8526, 77, 58], [8527, 69, 69], [8528, 79, 65], [8529, 86, 65],
                    [8530, 40, 38], [8531, 81, 76], [8532, 68, 69], [8533, 81, 75], [8534, 57, 56], [8535, 77, 78],
                    [8536, 22, 45], [8537, 55, 36], [8538, 54, 36], [8539, 47, 40], [8540, 38, 61], [8541, 48, 70],
                    [8542, 43, 65], [8543, 26, 62], [8544, 32, 73], [8546, 35, 62], [8547, 38, 72], [8548, 15, 21],
                    [8549, 25, 33], [8550, 20, 31], [8551, 37, 31], [8552, 33, 41], [8553, 48, 65], [8554, 23, 21],
                    [8555, 40, 38], [8556, 45, 64], [8557, 63, 62], [8558, 31, 34], [8559, 40, 39], [8560, 32, 38],
                    [8561, 25, 31], [8562, 38, 38], [8563, 47, 52], [8564, 92, 74], [8565, 10, 12], [8566, 16, 14],
                    [8567, 23, 22], [8568, 17, 16], [8569, 18, 16], [8570, 10, 10], [8571, 14, 11], [8572, 14, 11],
                    [8573, 12, 11], [8574, 15, 13], [8575, 10, 10], [8576, 22, 16], [8577, 18, 17], [8578, 24, 24],
                    [8579, 19, 21], [8580, 17, 17], [8581, 12, 10], [8582, 18, 17], [8583, 19, 19], [8584, 15, 14],
                    [8585, 12, 12], [8586, 33, 19], [8587, 10, 9], [8588, 39, 17], [8589, 14, 13], [8590, 23, 16],
                    [8591, 20, 16], [8592, 32, 32], [8593, 27, 26], [8594, 41, 27], [8595, 14, 14], [8596, 18, 15],
                    [8597, 21, 21], [8598, 28, 21], [8599, 15, 12], [8600, 23, 16], [8601, 31, 23], [8602, 31, 21],
                    [8603, 25, 16], [8604, 42, 22], [8605, 25, 24], [8606, 42, 25], [8607, 19, 25], [8608, 30, 28],
                    [8609, 28, 21], [8610, 25, 25], [8611, 27, 19], [8612, 38, 23], [8613, 15, 12], [8614, 28, 19],
                    [8615, 12, 12], [8616, 32, 22], [8617, 33, 16], [8618, 20, 13], [8619, 36, 25], [8622, 60, 31],
                    [8623, 61, 32], [8624, 19, 20], [8625, 49, 30], [8626, 25, 18], [8627, 39, 22], [8628, 35, 26],
                    [8629, 34, 28], [8630, 23, 17], [8631, 30, 22], [8632, 23, 17], [8633, 26, 20], [8634, 15, 14],
                    [8635, 27, 15], [8636, 12, 9], [8637, 22, 15], [8638, 16, 13], [8639, 20, 13], [8640, 25, 19],
                    [8641, 45, 21], [8642, 28, 23], [8643, 31, 27], [8644, 48, 28], [8645, 24, 21], [8646, 28, 22],
                    [8647, 20, 15], [8648, 20, 15], [8649, 25, 22], [8650, 35, 18], [8651, 34, 23], [8652, 47, 33],
                    [8653, 30, 27], [8654, 65, 32], [8655, 23, 23], [8656, 24, 20], [8657, 9, 12], [8658, 22, 18],
                    [8659, 34, 23], [8660, 15, 12], [8661, 18, 13], [8662, 22, 14], [8663, 24, 15], [8664, 30, 21],
                    [8665, 46, 33], [8666, 20, 19], [8667, 23, 21], [8668, 20, 26], [8669, 41, 37], [8670, 19, 22],
                    [8671, 29, 30], [8672, 16, 20], [8673, 27, 26], [8674, 27, 18], [8675, 55, 24], [8676, 44, 30],
                    [8677, 51, 31], [8678, 40, 22], [8679, 47, 21], [8680, 26, 20], [8681, 38, 25], [8682, 42, 23],
                    [8683, 38, 14], [8684, 30, 23], [8685, 22, 20], [8686, 31, 19], [8687, 28, 19], [8688, 42, 26],
                    [8689, 35, 24], [8690, 45, 25], [8691, 25, 27], [8692, 47, 29], [8693, 38, 14], [8694, 44, 24],
                    [8695, 15, 16], [8696, 22, 20], [8697, 20, 16], [8698, 37, 18], [8699, 32, 18], [8700, 34, 18],
                    [8701, 29, 16], [8702, 30, 19], [8703, 26, 23], [8704, 34, 27], [8705, 30, 19], [8706, 38, 21],
                    [8707, 23, 23], [8708, 33, 26], [8709, 40, 21], [8710, 35, 22], [8711, 18, 12], [8712, 24, 22],
                    [8713, 36, 23], [8714, 7, 6], [8715, 8, 7], [8716, 8, 8], [8717, 13, 12], [8718, 9, 8],
                    [8719, 22, 24], [8720, 28, 31], [8721, 28, 31], [8722, 27, 24], [8723, 29, 27], [8724, 27, 26],
                    [8725, 24, 20], [8726, 27, 22], [8727, 23, 24], [8728, 21, 22], [8729, 26, 21], [8730, 20, 17],
                    [8731, 21, 20], [8732, 27, 20], [8733, 28, 21], [8734, 23, 19], [8735, 21, 17], [8736, 21, 21],
                    [8737, 21, 18], [8738, 22, 19], [8739, 22, 20], [8740, 22, 19], [8741, 27, 20], [8742, 24, 21],
                    [8743, 24, 20], [8744, 25, 21], [8745, 28, 19], [8746, 30, 23], [8747, 30, 23], [8748, 31, 25],
                    [8749, 25, 20], [8750, 23, 26], [8751, 24, 26], [8752, 19, 17], [8753, 20, 18], [8754, 20, 22],
                    [8755, 21, 19], [8756, 32, 24], [8757, 20, 18], [8758, 20, 20], [8759, 24, 23], [8760, 32, 34],
                    [8761, 24, 20], [8762, 31, 21], [8763, 18, 17], [8764, 33, 26], [8765, 28, 19], [8766, 27, 21],
                    [8767, 33, 25], [8768, 32, 25], [8769, 21, 21], [8770, 33, 26], [8771, 32, 27], [8772, 33, 26],
                    [8773, 19, 17], [8774, 20, 20], [8775, 21, 18], [8776, 20, 19], [8777, 25, 20], [8778, 34, 26],
                    [8779, 9, 14], [8780, 14, 11], [8781, 15, 11], [8782, 17, 11], [8783, 10, 8], [8784, 14, 10],
                    [8785, 8, 7], [8786, 9, 11], [8787, 12, 12], [8788, 14, 10], [8790, 8, 7], [8791, 6, 6],
                    [8792, 13, 11], [8793, 8, 8], [8794, 8, 7], [8795, 9, 8], [8796, 14, 10], [8797, 16, 11],
                    [8798, 9, 9], [8799, 11, 9], [8800, 10, 8], [8801, 12, 10], [8802, 7, 7], [8803, 8, 9],
                    [8804, 7, 10], [8805, 9, 9], [8806, 10, 11], [8807, 15, 14], [8808, 8, 7], [8809, 6, 7],
                    [8810, 12, 11], [8811, 7, 9], [8812, 12, 10], [8814, 6, 6], [8815, 9, 8], [8816, 12, 8],
                    [8817, 18, 10], [8818, 51, 42], [8819, 37, 23], [8820, 56, 47], [8821, 45, 31], [8822, 58, 48],
                    [8823, 32, 27], [8824, 23, 19], [8825, 36, 31], [8826, 23, 22], [8827, 40, 31], [8828, 41, 34],
                    [8829, 44, 35], [8830, 29, 31], [8831, 35, 30], [8832, 19, 11], [8833, 34, 29], [8834, 38, 33],
                    [8835, 34, 20], [8836, 49, 40], [8837, 33, 20], [8838, 43, 38], [8839, 27, 13], [8840, 39, 26],
                    [8841, 27, 13], [8842, 16, 21], [8843, 20, 12], [8844, 28, 23], [8845, 15, 18], [8846, 35, 30],
                    [8847, 19, 21], [8848, 50, 41], [8849, 30, 24], [8850, 39, 34], [8851, 24, 25], [8852, 36, 27],
                    [8853, 14, 18], [8854, 36, 31], [8855, 21, 11], [8856, 32, 27], [8857, 24, 13], [8858, 30, 14],
                    [8859, 47, 41], [8860, 32, 12], [8861, 36, 30], [8862, 27, 22], [8863, 40, 35], [8864, 21, 22],
                    [8865, 32, 27], [8866, 21, 22], [8867, 54, 48], [8868, 40, 34], [8869, 52, 47], [8870, 48, 38],
                    [8871, 38, 32], [8872, 28, 25], [8873, 41, 35], [8874, 35, 29], [8875, 36, 30], [8876, 20, 17],
                    [8877, 44, 38], [8878, 18, 11], [8879, 31, 26], [8880, 32, 27], [8881, 54, 45], [8882, 31, 27],
                    [8883, 51, 46], [8884, 19, 17], [8885, 63, 41], [8886, 35, 30], [8887, 20, 12], [8888, 32, 23],
                    [8889, 48, 38], [8890, 14, 17], [8891, 36, 30], [8892, 14, 11], [8893, 36, 32], [8894, 19, 19],
                    [8895, 15, 11], [8896, 28, 22], [8897, 15, 11], [8898, 21, 19], [8899, 51, 45], [8900, 38, 32],
                    [8901, 50, 31], [8902, 36, 31], [8903, 26, 17], [8904, 36, 30], [8905, 25, 16], [8906, 32, 26],
                    [8907, 22, 20], [8908, 32, 27], [8909, 23, 20], [8910, 24, 13], [8911, 24, 13], [8912, 44, 39],
                    [8913, 29, 25], [8914, 42, 37], [8915, 29, 25], [8916, 50, 41], [8917, 37, 24], [8918, 47, 41],
                    [8919, 34, 32], [8920, 36, 33], [8921, 36, 34], [8922, 32, 26], [8923, 25, 20], [8924, 15, 14],
                    [8925, 11, 11], [8926, 15, 13], [8927, 17, 16], [8928, 14, 13], [8929, 11, 10], [8930, 9, 11],
                    [8931, 14, 15], [8932, 19, 20], [8933, 26, 25], [8934, 28, 27], [8935, 51, 41], [8936, 27, 20],
                    [8937, 35, 30], [8938, 27, 20], [8939, 32, 27], [8940, 19, 17], [8941, 31, 26], [8942, 19, 17],
                    [8943, 29, 20], [8944, 32, 27], [8945, 24, 14], [8946, 32, 27], [8947, 23, 14], [8948, 32, 27],
                    [8949, 23, 14], [8950, 24, 20], [8951, 32, 27], [8952, 24, 20], [8953, 51, 46], [8954, 28, 20],
                    [8955, 44, 39], [8956, 30, 26], [8957, 28, 20], [8958, 52, 43], [8959, 29, 21], [8960, 51, 42],
                    [8961, 29, 20], [8962, 47, 42], [8963, 32, 30], [8964, 20, 12], [8965, 46, 41], [8966, 39, 31],
                    [8967, 43, 34], [8968, 32, 26], [8969, 20, 13], [8970, 43, 37], [8971, 44, 35], [8972, 19, 13],
                    [8973, 44, 35], [8974, 14, 20], [8975, 49, 40], [8976, 53, 47], [8977, 28, 22], [8978, 14, 11],
                    [8979, 40, 35], [8980, 32, 27], [8981, 31, 26], [8983, 36, 30], [8984, 25, 21], [8985, 36, 31],
                    [8986, 25, 21], [8987, 28, 27], [8988, 19, 12], [8989, 36, 31], [8990, 19, 12], [8991, 35, 30],
                    [8992, 19, 12], [8993, 37, 27], [8994, 40, 28], [8995, 40, 29], [8996, 50, 41], [8997, 23, 14],
                    [8998, 28, 23], [8999, 20, 11], [9000, 56, 46], [9001, 48, 31], [9002, 42, 33], [9003, 25, 22],
                    [9004, 51, 42], [9005, 23, 19], [9006, 36, 31], [9007, 29, 20], [9008, 40, 26], [9009, 34, 26],
                    [9010, 28, 23], [9011, 20, 11], [9012, 28, 27], [9013, 14, 14], [9014, 42, 33], [9015, 21, 16],
                    [9016, 20, 15], [9017, 44, 35], [9018, 28, 30], [9019, 33, 32], [9020, 19, 23], [9021, 36, 31],
                    [9022, 25, 26], [9023, 35, 28], [9024, 42, 33], [9025, 32, 27], [9026, 36, 19], [9027, 30, 18],
                    [9028, 42, 33], [9030, 46, 33], [9031, 38, 29], [9032, 46, 33], [9033, 32, 30], [9034, 50, 41],
                    [9035, 42, 37], [9036, 39, 34], [9037, 17, 14], [9038, 28, 28], [9039, 15, 21], [9040, 39, 33],
                    [9041, 26, 22], [9042, 43, 34], [9043, 35, 30], [9044, 28, 14], [9045, 36, 27], [9046, 30, 22],
                    [9047, 38, 29], [9048, 33, 23], [9049, 62, 38], [9050, 31, 22], [9051, 44, 35], [9052, 21, 18],
                    [9053, 29, 21], [9054, 32, 23], [9055, 25, 13], [9056, 36, 24], [9057, 47, 31], [9058, 29, 20],
                    [9059, 51, 35], [9060, 45, 31], [9061, 24, 19], [9062, 14, 14], [9063, 36, 27], [9064, 14, 19],
                    [9065, 24, 23], [9066, 18, 19], [9067, 32, 23], [9068, 28, 19], [9069, 36, 41], [9070, 14, 14],
                    [9071, 28, 34], [9072, 14, 17], [9073, 14, 17], [9074, 31, 29], [9075, 22, 25], [9076, 24, 27],
                    [9077, 36, 23], [9078, 28, 17], [9079, 47, 38], [9080, 22, 19], [9081, 31, 25], [9082, 51, 35],
                    [9083, 24, 20], [9084, 31, 22], [9085, 20, 21], [9086, 39, 30], [9087, 44, 31], [9088, 32, 18],
                    [9089, 18, 15], [9090, 24, 19], [9091, 24, 16], [9092, 46, 30], [9093, 23, 20], [9094, 50, 47],
                    [9095, 14, 12], [9096, 27, 33], [9097, 33, 22], [9098, 39, 25], [9099, 20, 11], [9100, 40, 25],
                    [9101, 14, 14], [9102, 41, 32], [9103, 29, 30], [9104, 39, 30], [9105, 19, 12], [9106, 24, 13],
                    [9107, 36, 27], [9108, 36, 27], [9109, 39, 28], [9110, 48, 31], [9111, 27, 13], [9112, 51, 42],
                    [9113, 26, 21], [9114, 32, 27], [9115, 14, 11], [9116, 20, 15], [9117, 32, 12], [9118, 48, 32],
                    [9119, 19, 12], [9120, 28, 23], [9121, 34, 30], [9122, 42, 37], [9123, 31, 20], [9124, 40, 32],
                    [9125, 17, 25], [9126, 44, 39], [9127, 30, 22], [9128, 36, 27], [9129, 48, 38], [9130, 55, 43],
                    [9131, 29, 30], [9132, 49, 44], [9133, 28, 20], [9134, 36, 28], [9135, 50, 35], [9136, 45, 31],
                    [9137, 20, 15], [9138, 16, 11], [9139, 32, 28], [9140, 44, 39], [9141, 29, 25], [9142, 52, 43],
                    [9143, 21, 21], [9144, 24, 28], [9145, 37, 31], [9146, 45, 36], [9149, 20, 17], [9150, 23, 25],
                    [9151, 19, 18], [9152, 27, 28], [9153, 14, 18], [9154, 16, 16], [9155, 25, 27], [9156, 29, 27],
                    [9157, 30, 33], [9158, 12, 16], [9159, 22, 31], [9160, 15, 15], [9161, 19, 20], [9162, 28, 30],
                    [9163, 30, 25], [9164, 21, 20], [9165, 20, 40], [9166, 24, 27], [9167, 19, 21], [9168, 30, 33],
                    [9169, 22, 22], [9170, 29, 35], [9171, 19, 18], [9172, 21, 26], [9173, 23, 31], [9174, 18, 18],
                    [9175, 20, 22], [9176, 11, 11], [9177, 24, 22], [9178, 22, 35], [9179, 24, 32], [9180, 12, 15],
                    [9181, 19, 17], [9182, 27, 34], [9183, 23, 22], [9184, 27, 28], [9185, 22, 22], [9186, 17, 20],
                    [9187, 24, 23], [9188, 27, 29], [9189, 24, 24], [9190, 17, 20], [9191, 21, 20], [9192, 22, 24],
                    [9193, 19, 18], [9194, 31, 20], [9195, 36, 43], [9196, 29, 29], [9197, 38, 26], [9198, 35, 27],
                    [9199, 60, 40], [9200, 46, 53], [9201, 56, 34], [9202, 44, 42], [9203, 12, 18], [9204, 11, 14],
                    [9205, 27, 25], [9206, 18, 21], [9207, 31, 34], [9208, 43, 42], [9209, 31, 28], [9210, 51, 43],
                    [9211, 29, 33], [9212, 46, 45], [9213, 67, 59], [9214, 43, 40], [9215, 19, 25], [9216, 62, 63],
                    [9217, 55, 43], [9218, 28, 25], [9219, 46, 51], [9220, 34, 31], [9221, 29, 33], [9222, 44, 51],
                    [9223, 39, 48], [9224, 54, 42], [9225, 44, 36], [9226, 64, 43], [9227, 62, 51], [9228, 66, 67],
                    [9229, 49, 51], [9230, 40, 37], [9231, 68, 56], [9232, 47, 41], [9233, 40, 39], [9234, 28, 34],
                    [9235, 40, 44], [9236, 24, 20], [9237, 39, 23], [9238, 38, 50], [9239, 56, 66], [9240, 40, 44],
                    [9241, 31, 42], [9242, 45, 38], [9243, 55, 51], [9244, 43, 41], [9245, 25, 31], [9246, 34, 28],
                    [9247, 48, 38], [9248, 42, 32], [9249, 29, 22], [9250, 32, 22], [9251, 34, 30], [9252, 20, 27],
                    [9253, 78, 58], [9254, 102, 111], [9255, 50, 36], [9257, 80, 72], [9258, 44, 62], [9259, 65, 66],
                    [9260, 54, 41], [9261, 87, 109], [9263, 58, 63], [9264, 53, 57], [9265, 57, 63], [9266, 91, 108],
                    [9267, 70, 72], [9268, 63, 67], [9269, 96, 104], [9270, 91, 108], [9271, 92, 111], [9272, 96, 117],
                    [9273, 98, 119], [9274, 90, 86], [9275, 67, 64], [9276, 91, 85], [9277, 88, 73], [9278, 85, 86],
                    [9279, 83, 79], [9280, 67, 66], [9281, 87, 79], [9282, 100, 91], [9283, 93, 102], [9284, 110, 130],
                    [9285, 81, 98], [9286, 104, 126], [9287, 107, 124], [9288, 59, 46], [9289, 105, 122],
                    [9290, 83, 97], [9291, 100, 114], [9292, 99, 114], [9293, 67, 48], [9294, 68, 67], [9295, 83, 79],
                    [9296, 63, 46], [9297, 80, 56], [9298, 82, 103], [9299, 95, 116], [9300, 102, 119], [9301, 87, 106],
                    [9302, 107, 124], [9303, 97, 120], [9304, 60, 81], [9305, 90, 111], [9306, 108, 133],
                    [9307, 47, 68], [9308, 56, 77], [9309, 57, 70], [9310, 66, 77], [9311, 62, 74], [9312, 66, 77],
                    [9313, 61, 73], [9314, 74, 89], [9315, 42, 40], [9316, 28, 28], [9317, 12, 13], [9318, 15, 17],
                    [9319, 39, 45], [9320, 57, 57], [9327, 13, 15], [9328, 25, 30], [9329, 34, 41], [9330, 46, 50],
                    [9331, 33, 33], [9332, 31, 35], [9333, 13, 15], [9334, 11, 14], [9335, 34, 34], [9336, 28, 33],
                    [9337, 19, 23], [9338, 12, 13], [9339, 17, 21], [9340, 48, 52], [9341, 25, 29], [9342, 33, 33],
                    [9343, 9, 10], [9344, 19, 21], [9345, 20, 24], [9346, 14, 16], [9347, 11, 14], [9348, 21, 24],
                    [9349, 18, 21], [9350, 48, 55], [9351, 36, 33], [9352, 39, 39], [9353, 20, 23], [9354, 27, 27],
                    [9355, 19, 18], [9356, 33, 38], [9357, 19, 22], [9358, 26, 25], [9359, 20, 20], [9360, 30, 35],
                    [9361, 27, 32], [9362, 36, 34], [9363, 31, 35], [9364, 40, 31], [9365, 19, 23], [9366, 31, 36],
                    [9367, 21, 20], [9368, 31, 31], [9369, 33, 32], [9370, 17, 20], [9371, 32, 31], [9372, 27, 26],
                    [9373, 23, 23], [9374, 38, 38], [9375, 23, 27], [9376, 42, 41], [9377, 13, 17], [9378, 19, 22],
                    [9379, 33, 39], [9380, 29, 34], [9381, 56, 67], [9382, 33, 39], [9383, 37, 37], [9384, 19, 21],
                    [9385, 22, 24], [9386, 21, 23], [9387, 17, 19], [9388, 17, 22], [9389, 19, 21], [9390, 21, 25],
                    [9391, 24, 28], [9392, 22, 26], [9393, 25, 24], [9394, 17, 19], [9395, 23, 25], [9396, 25, 30],
                    [9397, 47, 54], [9398, 42, 49], [9399, 64, 71], [9400, 28, 34], [9401, 42, 40], [9402, 44, 34],
                    [9403, 112, 83], [9404, 111, 82], [9405, 113, 83], [9406, 102, 83], [9407, 70, 66], [9408, 113, 83],
                    [9409, 110, 83], [9410, 113, 83], [9411, 109, 80], [9412, 109, 82], [9413, 113, 83],
                    [9414, 112, 82], [9415, 113, 83], [9416, 103, 78], [9417, 113, 83], [9418, 109, 77],
                    [9419, 111, 83], [9420, 111, 82], [9421, 109, 77], [9422, 111, 83], [9423, 102, 75],
                    [9424, 112, 82], [9425, 113, 83], [9426, 111, 83], [9427, 113, 83], [9428, 109, 80],
                    [9429, 110, 83], [9430, 113, 83], [9431, 110, 81], [9432, 64, 61], [9433, 102, 75], [9434, 110, 81],
                    [9435, 113, 83], [9436, 110, 81], [9437, 112, 82], [9438, 113, 83], [9439, 110, 80],
                    [9440, 113, 83], [9441, 111, 83], [9442, 113, 83], [9443, 111, 82], [9444, 109, 80],
                    [9445, 110, 83], [9446, 113, 83], [9447, 110, 83], [9448, 113, 83], [9449, 72, 57], [9450, 102, 75],
                    [9451, 102, 83], [9452, 110, 81], [9453, 109, 82], [9454, 110, 83], [9455, 113, 83],
                    [9456, 111, 82], [9457, 102, 83], [9458, 111, 82], [9459, 110, 83], [9460, 113, 83],
                    [9461, 110, 83], [9462, 113, 83], [9463, 79, 75], [9464, 79, 75], [9465, 64, 61], [9466, 110, 83],
                    [9467, 112, 83], [9468, 112, 66], [9469, 113, 83], [9470, 110, 81], [9471, 144, 87],
                    [9472, 170, 158], [9473, 48, 79], [9474, 79, 123], [9475, 111, 96], [9476, 111, 174],
                    [9477, 36, 49], [9478, 57, 75], [9479, 82, 88], [9480, 120, 129], [9481, 27, 70], [9482, 41, 109],
                    [9483, 111, 83], [9484, 151, 76], [9485, 71, 47], [9486, 93, 73], [9487, 27, 49], [9488, 45, 75],
                    [9489, 102, 75], [9490, 100, 95], [9491, 44, 70], [9492, 73, 83], [9493, 111, 91], [9494, 117, 123],
                    [9495, 44, 42], [9496, 79, 53], [9497, 43, 30], [9498, 69, 48], [9499, 64, 75], [9500, 102, 109],
                    [9501, 67, 107], [9502, 110, 174], [9503, 64, 53], [9504, 78, 63], [9505, 64, 97], [9506, 102, 151],
                    [9507, 74, 75], [9508, 101, 138], [9509, 102, 70], [9510, 102, 101], [9511, 64, 61], [9512, 64, 98],
                    [9513, 75, 77], [9514, 102, 111], [9515, 67, 65], [9516, 110, 94], [9517, 102, 83],
                    [9518, 130, 124], [9519, 32, 36], [9520, 54, 59], [9521, 67, 156], [9522, 101, 183],
                    [9523, 102, 83], [9524, 124, 129], [9525, 30, 38], [9526, 47, 58], [9527, 80, 78], [9528, 101, 104],
                    [9529, 43, 49], [9530, 69, 75], [9531, 43, 56], [9532, 53, 89], [9533, 102, 104], [9534, 143, 136],
                    [9535, 33, 73], [9536, 59, 134], [9537, 119, 83], [9538, 160, 127], [9539, 59, 57], [9540, 79, 89],
                    [9541, 43, 41], [9542, 67, 64], [9543, 36, 45], [9544, 58, 70], [9545, 64, 61], [9546, 71, 82],
                    [9547, 39, 47], [9548, 64, 78], [9549, 33, 34], [9550, 52, 61], [9551, 35, 52], [9552, 56, 88],
                    [9553, 44, 49], [9554, 64, 75], [9555, 61, 127], [9556, 94, 150], [9557, 36, 56], [9558, 64, 89],
                    [9559, 42, 42], [9560, 56, 65], [9561, 43, 64], [9562, 68, 100], [9563, 60, 125], [9564, 95, 151],
                    [9565, 64, 61], [9566, 70, 96], [9567, 56, 70], [9568, 74, 114], [9569, 102, 97], [9570, 129, 131],
                    [9571, 88, 158], [9572, 132, 174], [9573, 79, 75], [9574, 102, 120], [9575, 67, 72],
                    [9576, 113, 121], [9577, 111, 74], [9578, 140, 125], [9579, 44, 97], [9580, 63, 125],
                    [9581, 48, 61], [9582, 56, 78], [9583, 102, 128], [9584, 151, 151], [9585, 102, 68],
                    [9586, 108, 78], [9587, 59, 56], [9588, 63, 76], [9589, 35, 73], [9590, 52, 110], [9591, 64, 53],
                    [9592, 69, 61], [9593, 36, 52], [9594, 57, 92], [9595, 40, 53], [9596, 68, 82], [9597, 27, 27],
                    [9598, 38, 52], [9599, 102, 68], [9600, 102, 75], [9601, 48, 75], [9602, 92, 135], [9603, 61, 75],
                    [9604, 90, 97], [9605, 59, 42], [9606, 64, 51], [9607, 53, 63], [9608, 84, 75], [9609, 39, 43],
                    [9610, 52, 61], [9611, 44, 49], [9612, 64, 68], [9613, 66, 125], [9614, 98, 151], [9615, 53, 45],
                    [9616, 83, 71], [9617, 22, 29], [9618, 64, 61], [9619, 33, 44], [9620, 33, 44], [9621, 39, 68],
                    [9622, 52, 75], [9623, 64, 53], [9624, 64, 61], [9625, 102, 75], [9626, 100, 100], [9627, 64, 45],
                    [9628, 79, 61], [9629, 46, 53], [9630, 79, 71], [9631, 44, 44], [9632, 58, 71], [9633, 57, 69],
                    [9634, 99, 131], [9635, 137, 125], [9636, 159, 151], [9637, 74, 77], [9638, 108, 113],
                    [9639, 21, 29], [9640, 38, 61], [9641, 57, 45], [9642, 71, 75], [9643, 28, 49], [9644, 45, 78],
                    [9645, 64, 115], [9646, 72, 151], [9647, 102, 75], [9648, 115, 137], [9651, 55, 55], [9652, 79, 76],
                    [9653, 48, 45], [9654, 84, 64], [9655, 39, 40], [9656, 67, 66], [9657, 54, 53], [9658, 63, 55],
                    [9659, 42, 37], [9660, 66, 66], [9661, 37, 38], [9662, 64, 60], [9663, 39, 37], [9664, 67, 61],
                    [9665, 55, 55], [9666, 65, 65], [9667, 49, 42], [9668, 67, 59], [9669, 40, 40], [9670, 60, 58],
                    [9671, 41, 42], [9672, 77, 67], [9673, 44, 43], [9674, 57, 57], [9675, 49, 50], [9676, 91, 68],
                    [9677, 41, 40], [9678, 65, 60], [9679, 41, 42], [9680, 66, 64], [9681, 52, 43], [9682, 73, 65],
                    [9683, 53, 49], [9684, 69, 65], [9685, 48, 48], [9686, 71, 67], [9687, 46, 41], [9688, 71, 67],
                    [9689, 78, 78], [9690, 73, 69], [9691, 44, 40], [9692, 68, 60], [9693, 60, 47], [9694, 88, 60],
                    [9695, 37, 38], [9696, 65, 58], [9697, 42, 39], [9698, 80, 56], [9699, 38, 43], [9700, 68, 68],
                    [9701, 38, 38], [9702, 53, 49], [9703, 34, 35], [9704, 69, 64], [9705, 35, 35], [9706, 75, 69],
                    [9707, 48, 40], [9708, 63, 50], [9709, 41, 42], [9710, 51, 49], [9711, 96, 73], [9712, 95, 74],
                    [9713, 96, 73], [9714, 91, 69], [9715, 87, 66], [9716, 46, 37], [9717, 54, 47], [9718, 40, 38],
                    [9719, 64, 59], [9720, 84, 62], [9721, 77, 68], [9722, 37, 37], [9723, 80, 76], [9724, 64, 59],
                    [9725, 83, 76], [9726, 26, 34], [9727, 59, 55], [9728, 52, 48], [9729, 59, 55], [9730, 31, 31],
                    [9731, 83, 62], [9735, 62, 52], [9736, 48, 47], [9737, 51, 45], [9738, 101, 70], [9739, 60, 58],
                    [9740, 72, 69], [9741, 65, 59], [9742, 63, 57], [9743, 49, 42], [9744, 90, 66], [9745, 58, 55],
                    [9746, 56, 56], [9747, 61, 57], [9748, 52, 53], [9751, 43, 37], [9752, 52, 47], [9753, 38, 38],
                    [9754, 63, 63], [9755, 40, 40], [9756, 75, 71], [9757, 39, 40], [9758, 62, 58], [9759, 24, 15],
                    [9760, 47, 29], [9761, 49, 30], [9762, 44, 20], [9763, 25, 17], [9764, 30, 15], [9765, 48, 30],
                    [9766, 46, 23], [9767, 45, 52], [9768, 39, 26], [9769, 27, 19], [9770, 51, 45], [9771, 59, 24],
                    [9772, 34, 17], [9773, 46, 35], [9774, 26, 21], [9775, 27, 20], [9776, 33, 15], [9777, 49, 30],
                    [9778, 49, 33], [9779, 44, 32], [9780, 46, 36], [9781, 34, 18], [9782, 48, 34], [9783, 40, 23],
                    [9784, 40, 32], [9785, 32, 26], [9786, 25, 18], [9787, 46, 30], [9788, 25, 19], [9789, 50, 23],
                    [9790, 46, 29], [9791, 56, 35], [9792, 48, 42], [9793, 19, 14], [9794, 16, 15], [9795, 15, 14],
                    [9796, 23, 17], [9797, 19, 14], [9798, 16, 15], [9799, 54, 44], [9800, 28, 24], [9801, 23, 19],
                    [9802, 23, 19], [9803, 12, 10], [9804, 21, 17], [9805, 42, 31], [9806, 27, 21], [9807, 36, 23],
                    [9808, 94, 57], [9809, 50, 19], [9811, 53, 29], [9812, 92, 54], [9813, 74, 31], [9814, 27, 16],
                    [9815, 54, 29], [9816, 40, 17], [9817, 33, 15], [9818, 74, 22], [9819, 65, 45], [9820, 80, 48],
                    [9821, 59, 32], [9822, 27, 22], [9823, 35, 23], [9824, 37, 30], [9825, 25, 19], [9826, 64, 44],
                    [9827, 59, 33], [9828, 67, 44], [9829, 51, 32], [9830, 40, 31], [9831, 50, 30], [9832, 41, 26],
                    [9833, 42, 29], [9834, 74, 47], [9835, 42, 37], [9836, 59, 41], [9837, 38, 25], [9838, 66, 49],
                    [9839, 21, 18], [9840, 54, 39], [9841, 102, 58], [9842, 40, 23], [9843, 35, 25], [9844, 45, 29],
                    [9845, 38, 31], [9846, 35, 21], [9847, 18, 15], [9848, 32, 20], [9849, 31, 19], [9850, 31, 15],
                    [9851, 29, 14], [9852, 25, 14], [9853, 28, 19], [9854, 17, 14], [9855, 37, 31], [9856, 19, 20],
                    [9857, 19, 15], [9858, 54, 33], [9859, 68, 41], [9860, 58, 43], [9861, 70, 60], [9862, 35, 38],
                    [9863, 55, 39], [9864, 68, 27], [9865, 45, 28], [9866, 68, 27], [9867, 27, 19], [9868, 57, 37],
                    [9869, 52, 31], [9870, 46, 54], [9871, 57, 34], [9872, 31, 27], [9873, 43, 40], [9874, 52, 25],
                    [9875, 42, 28], [9876, 31, 27], [9877, 44, 34], [9878, 51, 31], [9879, 47, 27], [9880, 50, 39],
                    [9881, 64, 34], [9882, 48, 38], [9883, 43, 25], [9884, 43, 23], [9885, 53, 27], [9886, 53, 26],
                    [9887, 46, 31], [9888, 59, 44], [9889, 57, 35], [9890, 51, 35], [9891, 43, 27], [9892, 36, 28],
                    [9893, 30, 21], [9894, 59, 38], [9895, 29, 17], [9896, 12, 15], [9897, 44, 28], [9898, 46, 34],
                    [9899, 31, 24], [9900, 72, 63], [9901, 66, 43], [9902, 100, 73], [9903, 89, 54], [9904, 78, 56],
                    [9905, 50, 38], [9906, 53, 30], [9907, 38, 34], [9908, 78, 51], [9909, 19, 16], [9910, 69, 58],
                    [9911, 99, 54], [9912, 64, 38], [9913, 29, 24], [9914, 40, 29], [9915, 38, 32], [9916, 40, 36],
                    [9917, 35, 31], [9918, 98, 35], [9919, 91, 74], [9920, 103, 72], [9921, 31, 24], [9922, 35, 19],
                    [9923, 39, 25], [9924, 55, 29], [9925, 66, 61], [9926, 50, 60], [9927, 39, 27], [9928, 70, 36],
                    [9929, 57, 49], [9930, 51, 32], [9931, 67, 40], [9932, 68, 33], [9933, 63, 48], [9934, 61, 34],
                    [9935, 49, 27], [9936, 52, 35], [9937, 35, 32], [9938, 21, 19], [9939, 56, 27], [9940, 45, 38],
                    [9941, 48, 26], [9942, 26, 20], [9943, 128, 74], [9944, 60, 31], [9945, 86, 38], [9946, 44, 22],
                    [9947, 64, 32], [9948, 112, 54], [9949, 104, 61], [9950, 78, 57], [9951, 41, 27], [9952, 64, 31],
                    [9953, 32, 25], [9954, 81, 53], [9955, 31, 26], [9956, 71, 31], [9957, 106, 51], [9958, 35, 28],
                    [9959, 99, 50], [9960, 64, 31], [9961, 34, 32], [9962, 43, 27], [9963, 77, 47], [9964, 41, 37],
                    [9965, 38, 18], [9966, 71, 36], [9967, 85, 40], [9968, 49, 44], [9969, 46, 26], [9970, 66, 31],
                    [9971, 40, 30], [9972, 119, 51], [9973, 54, 43], [9974, 38, 17], [9975, 99, 42], [9976, 122, 52],
                    [9977, 46, 23], [9978, 51, 24], [9979, 105, 48], [9980, 56, 26], [9981, 34, 20], [9982, 21, 15],
                    [9983, 94, 39], [9984, 50, 30], [9985, 52, 29], [9986, 55, 32], [9987, 56, 46], [9988, 51, 32],
                    [9989, 43, 34], [9990, 37, 22], [9991, 53, 38], [9992, 55, 41], [9993, 39, 43], [9994, 35, 31],
                    [9995, 51, 41], [9996, 42, 36], [9997, 20, 26], [9998, 22, 18], [9999, 34, 38], [10000, 28, 19],
                    [10001, 24, 18], [10002, 21, 17], [10003, 55, 31], [10004, 24, 19], [10005, 24, 19],
                    [10006, 18, 14], [10007, 41, 46], [10008, 57, 56], [10009, 57, 39], [10010, 66, 37],
                    [10011, 52, 34], [10012, 70, 31], [10013, 37, 33], [10014, 47, 49], [10015, 36, 34],
                    [10016, 41, 44], [10017, 48, 40], [10018, 50, 44], [10019, 49, 41], [10020, 62, 52],
                    [10021, 77, 51], [10022, 65, 53], [10023, 70, 51], [10024, 93, 64], [10025, 79, 64],
                    [10026, 75, 55], [10027, 70, 55], [10030, 65, 53], [10031, 85, 74], [10032, 87, 65],
                    [10033, 51, 38], [10034, 58, 38], [10035, 96, 51], [10036, 93, 43], [10037, 102, 53],
                    [10038, 34, 23], [10039, 20, 23], [10040, 33, 23], [10041, 31, 19], [10042, 55, 37],
                    [10043, 58, 29], [10044, 66, 29], [10045, 41, 24], [10046, 61, 39], [10047, 58, 31],
                    [10048, 54, 32], [10049, 38, 29], [10050, 51, 36], [10051, 59, 41], [10052, 71, 61],
                    [10053, 78, 62], [10054, 68, 63], [10055, 75, 65], [10056, 64, 63], [10057, 73, 66],
                    [10058, 40, 45], [10059, 81, 47], [10060, 60, 43], [10061, 71, 67], [10063, 23, 25],
                    [10064, 41, 34], [10065, 37, 46], [10066, 48, 43], [10067, 69, 54], [10068, 77, 58],
                    [10069, 70, 55], [10070, 46, 27], [10071, 68, 49], [10072, 68, 26], [10073, 70, 31],
                    [10074, 69, 32], [10075, 80, 43], [10076, 71, 43], [10077, 69, 43], [10078, 86, 53],
                    [10079, 54, 39], [10080, 47, 41], [10081, 83, 53], [10082, 56, 60], [10083, 46, 44],
                    [10084, 51, 35], [10085, 49, 24], [10086, 54, 32], [10087, 49, 22], [10088, 71, 46],
                    [10089, 71, 47], [10090, 57, 45], [10091, 70, 34], [10092, 78, 35], [10093, 53, 45],
                    [10094, 90, 56], [10095, 81, 54], [10096, 69, 42], [10097, 56, 41], [10098, 64, 46],
                    [10099, 77, 54], [10101, 82, 66], [10102, 70, 57], [10103, 72, 67], [10104, 20, 20],
                    [10105, 34, 23], [10106, 34, 32], [10107, 66, 62], [10108, 79, 72], [10109, 127, 80],
                    [10110, 64, 56], [10111, 91, 69], [10112, 94, 75], [10113, 112, 92], [10114, 81, 50],
                    [10115, 49, 36], [10116, 56, 46], [10117, 53, 54], [10118, 57, 62], [10119, 26, 18],
                    [10120, 34, 22], [10121, 78, 68], [10122, 78, 68], [10123, 91, 77], [10124, 79, 75],
                    [10125, 83, 51], [10126, 71, 43], [10127, 71, 45], [10128, 72, 50], [10129, 92, 59],
                    [10130, 85, 58], [10131, 54, 43], [10132, 55, 44], [10133, 72, 42], [10134, 96, 67],
                    [10135, 93, 74], [10136, 60, 31], [10137, 71, 48], [10138, 64, 35], [10139, 63, 40],
                    [10141, 57, 36], [10142, 62, 38], [10144, 79, 40], [10145, 49, 49], [10146, 57, 54],
                    [10148, 58, 31], [10149, 60, 64], [10150, 29, 38], [10151, 50, 47], [10152, 69, 54],
                    [10153, 76, 60], [10154, 30, 30], [10155, 59, 60], [10156, 41, 40], [10157, 73, 54],
                    [10158, 40, 42], [10159, 56, 44], [10160, 59, 38], [10161, 85, 49], [10162, 64, 33],
                    [10163, 87, 42], [10164, 66, 34], [10165, 71, 37], [10166, 53, 31], [10167, 64, 49],
                    [10168, 65, 50], [10169, 71, 51], [10170, 33, 41], [10171, 57, 48], [10172, 44, 39],
                    [10173, 57, 47], [10174, 54, 37], [10175, 70, 48], [10176, 22, 23], [10177, 20, 21],
                    [10178, 25, 24], [10179, 20, 22], [10180, 42, 34], [10181, 26, 18], [10182, 41, 45],
                    [10183, 53, 30], [10184, 52, 20], [10185, 18, 15], [10186, 16, 13], [10187, 24, 18],
                    [10188, 25, 17], [10189, 69, 37], [10190, 24, 16], [10191, 54, 30], [10192, 39, 24],
                    [10193, 23, 21], [10194, 17, 12], [10195, 16, 14], [10196, 44, 32], [10197, 42, 30],
                    [10198, 30, 34], [10199, 30, 33], [10200, 29, 34], [10201, 28, 31], [10202, 69, 59],
                    [10203, 57, 40], [10204, 58, 40], [10205, 48, 36], [10206, 45, 31], [10207, 41, 29],
                    [10208, 45, 33], [10209, 42, 30], [10210, 50, 40], [10211, 47, 37], [10212, 53, 34],
                    [10213, 51, 32], [10214, 45, 39], [10215, 42, 37], [10216, 48, 34], [10217, 51, 36],
                    [10218, 47, 38], [10219, 46, 39], [10220, 44, 36], [10221, 47, 32], [10222, 45, 34],
                    [10223, 57, 47], [10224, 64, 53], [10225, 59, 56], [10226, 33, 32], [10227, 34, 32],
                    [10228, 32, 29], [10234, 57, 45], [10235, 42, 36], [10236, 42, 39], [10237, 36, 35],
                    [10238, 44, 43], [10239, 60, 48], [10240, 38, 38], [10241, 31, 41], [10242, 42, 33],
                    [10243, 44, 37], [10244, 41, 45], [10245, 21, 30], [10246, 37, 33], [10247, 26, 30],
                    [10248, 41, 33], [10249, 27, 33], [10250, 40, 38], [10251, 43, 36], [10252, 41, 38],
                    [10253, 41, 42], [10255, 43, 40], [10256, 48, 45], [10257, 42, 36], [10258, 45, 44],
                    [10259, 20, 33], [10260, 41, 39], [10261, 46, 37], [10263, 26, 32], [10264, 42, 38],
                    [10267, 31, 29], [10268, 45, 34], [10269, 31, 32], [10270, 35, 38], [10271, 42, 33],
                    [10272, 34, 33], [10276, 37, 36], [10277, 46, 41], [10278, 27, 33], [10279, 44, 42],
                    [10280, 26, 38], [10281, 41, 44], [10283, 27, 30], [10284, 37, 37], [10285, 28, 29],
                    [10286, 34, 31], [10287, 34, 31], [10288, 41, 30], [10289, 44, 35], [10290, 42, 33],
                    [10291, 42, 36], [10292, 30, 35], [10293, 42, 42], [10294, 20, 29], [10295, 27, 33],
                    [10296, 39, 38], [10297, 27, 30], [10298, 35, 35], [10299, 27, 30], [10300, 35, 35],
                    [10301, 35, 38], [10302, 27, 33], [10303, 40, 39], [10304, 27, 33], [10305, 36, 38],
                    [10306, 32, 40], [10307, 36, 40], [10309, 37, 34], [10310, 27, 33], [10311, 36, 39],
                    [10312, 36, 35], [10313, 46, 38], [10314, 42, 36], [10315, 40, 31], [10317, 31, 32],
                    [10318, 48, 39], [10319, 32, 39], [10320, 68, 43], [10321, 32, 31], [10322, 44, 44],
                    [10323, 31, 40], [10326, 57, 45], [10327, 31, 35], [10329, 34, 31], [10330, 36, 41],
                    [10332, 26, 29], [10333, 42, 42], [10334, 46, 42], [10335, 40, 43], [10337, 30, 32],
                    [10338, 46, 38], [10339, 32, 34], [10340, 47, 38], [10341, 26, 29], [10342, 36, 32],
                    [10343, 37, 33], [10344, 33, 37], [10347, 26, 38], [10354, 25, 31], [10355, 44, 38],
                    [10356, 32, 36], [10357, 43, 43], [10358, 40, 36], [10360, 26, 30], [10361, 41, 35],
                    [10362, 42, 42], [10363, 65, 43], [10364, 72, 41], [10366, 44, 43], [10367, 64, 41],
                    [10368, 70, 45], [10369, 64, 41], [10370, 72, 46], [10371, 35, 45], [10372, 26, 31],
                    [10374, 27, 33], [10376, 26, 29], [10377, 29, 32], [10378, 41, 41], [10380, 35, 37],
                    [10381, 57, 44], [10382, 36, 38], [10383, 71, 44], [10384, 41, 41], [10385, 73, 45],
                    [10388, 21, 33], [10390, 28, 32], [10391, 38, 31], [10392, 38, 37], [10394, 26, 29],
                    [10395, 36, 35], [10396, 27, 30], [10398, 27, 33], [10399, 40, 38], [10400, 28, 31],
                    [10402, 26, 38], [10403, 42, 45], [10404, 29, 35], [10408, 26, 38], [10409, 40, 45],
                    [10410, 29, 38], [10411, 45, 43], [10412, 49, 29], [10413, 76, 45], [10417, 41, 45],
                    [10418, 26, 30], [10419, 41, 41], [10420, 44, 44], [10422, 37, 41], [10424, 43, 41],
                    [10425, 26, 35], [10426, 39, 43], [10427, 33, 31], [10428, 34, 38], [10431, 27, 34],
                    [10432, 41, 38], [10433, 26, 32], [10434, 41, 38], [10435, 43, 34], [10436, 32, 31],
                    [10437, 41, 30], [10438, 27, 31], [10439, 40, 44], [10440, 26, 35], [10441, 42, 37],
                    [10442, 33, 34], [10443, 26, 29], [10444, 44, 31], [10445, 46, 38], [10447, 26, 29],
                    [10448, 37, 33], [10450, 26, 33], [10453, 67, 36], [10454, 62, 36], [10455, 67, 42],
                    [10456, 25, 32], [10458, 26, 30], [10459, 34, 31], [10461, 27, 34], [10463, 21, 27],
                    [10464, 30, 33], [10467, 26, 36], [10469, 31, 32], [10471, 31, 29], [10474, 18, 17],
                    [10475, 18, 17], [10476, 19, 20], [10477, 21, 21], [10478, 28, 41], [10479, 40, 31],
                    [10480, 25, 29], [10482, 26, 33], [10483, 32, 38], [10484, 26, 33], [10485, 31, 38],
                    [10486, 26, 32], [10487, 31, 39], [10490, 16, 29], [10491, 9, 22], [10492, 8, 14], [10493, 36, 38],
                    [10494, 11, 39], [10495, 13, 31], [10496, 10, 21], [10497, 29, 57], [10498, 10, 27], [10499, 9, 55],
                    [10500, 12, 57], [10501, 12, 57], [10502, 33, 84], [10503, 12, 59], [10504, 15, 79],
                    [10505, 34, 63], [10506, 16, 42], [10507, 10, 24], [10508, 26, 64], [10509, 29, 43],
                    [10510, 15, 41], [10511, 8, 21], [10512, 26, 29], [10513, 35, 36], [10514, 18, 26], [10515, 19, 31],
                    [10516, 17, 26], [10517, 26, 36], [10518, 20, 23], [10519, 23, 26], [10520, 12, 15],
                    [10521, 20, 26], [10522, 20, 26], [10523, 20, 26], [10524, 19, 24], [10525, 20, 25],
                    [10526, 20, 26], [10527, 18, 22], [10528, 26, 25], [10529, 20, 25], [10530, 20, 25],
                    [10531, 19, 24], [10532, 23, 22], [10533, 35, 30], [10534, 16, 14], [10535, 32, 27],
                    [10536, 18, 22], [10537, 24, 22], [10538, 31, 26], [10539, 18, 19], [10540, 34, 27],
                    [10541, 42, 36], [10542, 48, 32], [10543, 7, 7], [10544, 12, 11], [10545, 7, 7], [10546, 8, 8],
                    [10547, 8, 8], [10548, 12, 12], [10549, 8, 8], [10550, 15, 11], [10551, 8, 8], [10552, 8, 8],
                    [10553, 20, 15], [10554, 20, 13], [10555, 13, 9], [10556, 22, 15], [10557, 16, 11], [10558, 31, 18],
                    [10559, 20, 13], [10560, 20, 14], [10577, 19, 12], [10578, 44, 52], [10579, 59, 50],
                    [10580, 77, 63], [10581, 97, 82], [10582, 74, 61], [10583, 66, 60], [10584, 81, 67],
                    [10585, 62, 65], [10586, 88, 77], [10587, 78, 64], [10588, 48, 47], [10589, 74, 67],
                    [10590, 93, 73], [10591, 90, 85], [10592, 77, 43], [10593, 60, 51], [10594, 79, 76],
                    [10595, 44, 50], [10596, 53, 51], [10597, 66, 54], [10598, 62, 49], [10600, 17, 20],
                    [10601, 18, 17], [10602, 32, 38], [10603, 45, 45], [10604, 51, 33], [10605, 21, 11],
                    [10606, 17, 11], [10607, 27, 15], [10608, 15, 11], [10609, 15, 11], [10610, 24, 11],
                    [10611, 24, 16], [10612, 22, 17], [10613, 55, 18], [10614, 45, 29], [10615, 51, 27],
                    [10616, 44, 38], [10617, 59, 34], [10618, 62, 34], [10619, 45, 26], [10620, 33, 23],
                    [10621, 45, 19], [10622, 40, 21], [10623, 46, 21], [10624, 45, 21], [10625, 38, 26],
                    [10626, 60, 32], [10627, 53, 26], [10628, 60, 40], [10629, 58, 38], [10630, 35, 21],
                    [10631, 53, 21], [10632, 40, 21], [10633, 58, 29], [10634, 58, 21], [10635, 59, 21],
                    [10636, 45, 29], [10637, 45, 26], [10638, 27, 19], [10639, 60, 33], [10640, 55, 33],
                    [10641, 55, 34], [10642, 57, 35], [10643, 45, 31], [10644, 55, 33], [10645, 40, 34],
                    [10646, 56, 33], [10647, 56, 33], [10648, 46, 40], [10649, 50, 30], [10650, 56, 27],
                    [10651, 55, 28], [10652, 44, 28], [10653, 60, 27], [10654, 43, 33], [10655, 56, 32],
                    [10656, 56, 33], [10657, 44, 25], [10658, 53, 23], [10659, 24, 19], [10660, 62, 28],
                    [10661, 93, 35], [10662, 57, 35], [10663, 50, 21], [10664, 60, 28], [10665, 59, 29],
                    [10666, 62, 25], [10667, 58, 25], [10668, 53, 27], [10669, 24, 19], [10670, 55, 25],
                    [10671, 55, 35], [10672, 62, 34], [10673, 40, 18], [10674, 45, 22], [10675, 46, 44],
                    [10676, 46, 43], [10677, 40, 21], [10678, 48, 31], [10679, 71, 33], [10680, 28, 23],
                    [10681, 52, 27], [10682, 46, 28], [10683, 44, 28], [10684, 31, 33], [10685, 101, 44],
                    [10686, 53, 45], [10687, 45, 48], [10688, 72, 48], [10689, 72, 46], [10690, 73, 48],
                    [10691, 74, 48], [10692, 78, 31], [10693, 102, 32], [10694, 77, 31], [10695, 61, 32],
                    [10696, 61, 32], [10697, 40, 31], [10698, 46, 41], [10699, 54, 41], [10700, 24, 25],
                    [10701, 91, 30], [10702, 92, 30], [10703, 93, 30], [10704, 60, 30], [10705, 69, 28],
                    [10706, 61, 28], [10707, 49, 53], [10708, 55, 53], [10709, 57, 53], [10710, 89, 24],
                    [10711, 57, 24], [10712, 62, 44], [10713, 62, 44], [10714, 53, 35], [10715, 93, 28],
                    [10716, 60, 53], [10717, 58, 53], [10718, 53, 53], [10719, 74, 48], [10720, 79, 48],
                    [10721, 33, 28], [10722, 76, 47], [10723, 60, 47], [10724, 61, 47], [10725, 55, 48],
                    [10726, 43, 32], [10727, 57, 33], [10728, 59, 35], [10729, 57, 34], [10730, 61, 33],
                    [10731, 44, 27], [10732, 60, 28], [10733, 61, 28], [10734, 61, 28], [10735, 61, 23],
                    [10736, 60, 22], [10737, 103, 24], [10738, 62, 35], [10739, 32, 19], [10740, 56, 26],
                    [10741, 46, 27], [10742, 55, 40], [10743, 48, 36], [10744, 46, 29], [10745, 55, 33],
                    [10746, 55, 29], [10747, 33, 24], [10748, 53, 21], [10749, 55, 29], [10750, 56, 12],
                    [10751, 55, 26], [10752, 56, 26], [10753, 61, 33], [10754, 53, 25], [10755, 22, 16],
                    [10756, 100, 77], [10757, 23, 15], [10758, 32, 13], [10759, 67, 30], [10760, 68, 39],
                    [10761, 54, 38], [10762, 55, 30], [10763, 45, 30], [10764, 32, 30], [10765, 40, 29],
                    [10766, 57, 29], [10767, 60, 22], [10768, 53, 22], [10769, 57, 22], [10770, 59, 45],
                    [10771, 61, 45], [10772, 40, 53], [10773, 56, 61], [10774, 45, 29], [10775, 55, 28],
                    [10776, 46, 21], [10777, 36, 24], [10778, 99, 24], [10779, 45, 33], [10780, 53, 23],
                    [10781, 48, 23], [10782, 45, 21], [10783, 67, 41], [10784, 60, 29], [10785, 61, 30],
                    [10786, 44, 23], [10787, 52, 23], [10788, 57, 53], [10789, 49, 30], [10790, 61, 30],
                    [10791, 62, 30], [10792, 32, 21], [10793, 57, 21], [10794, 61, 22], [10795, 62, 22],
                    [10796, 63, 22], [10797, 56, 22], [10798, 37, 22], [10799, 27, 20], [10800, 56, 39],
                    [10801, 55, 29], [10802, 46, 29], [10803, 41, 23], [10804, 72, 26], [10805, 74, 27],
                    [10806, 45, 27], [10807, 55, 27], [10808, 36, 19], [10809, 33, 23], [10810, 45, 23],
                    [10811, 45, 20], [10812, 82, 61], [10813, 55, 49], [10814, 45, 26], [10815, 56, 26],
                    [10816, 60, 25], [10817, 56, 25], [10818, 61, 40], [10819, 60, 38], [10820, 61, 32],
                    [10821, 54, 21], [10822, 56, 21], [10823, 49, 21], [10824, 44, 28], [10825, 45, 29],
                    [10826, 50, 30], [10827, 46, 30], [10828, 38, 23], [10829, 58, 34], [10830, 55, 33],
                    [10831, 58, 32], [10832, 55, 32], [10833, 55, 32], [10834, 55, 33], [10835, 56, 33],
                    [10836, 53, 33], [10837, 62, 34], [10838, 56, 33], [10839, 45, 33], [10840, 32, 27],
                    [10841, 91, 23], [10842, 40, 21], [10843, 56, 29], [10844, 41, 35], [10845, 36, 32],
                    [10846, 44, 31], [10847, 42, 22], [10848, 56, 22], [10849, 56, 22], [10850, 49, 33],
                    [10851, 42, 30], [10852, 46, 29], [10853, 61, 43], [10854, 57, 30], [10855, 61, 30],
                    [10856, 61, 38], [10857, 60, 38], [10858, 54, 34], [10859, 61, 34], [10860, 78, 35],
                    [10861, 72, 35], [10862, 53, 34], [10863, 30, 27], [10864, 80, 36], [10865, 55, 23],
                    [10866, 41, 26], [10867, 56, 33], [10868, 56, 33], [10869, 62, 22], [10870, 61, 29],
                    [10871, 61, 30], [10872, 60, 22], [10873, 73, 23], [10874, 62, 22], [10875, 59, 27],
                    [10876, 72, 30], [10877, 87, 37], [10878, 61, 30], [10879, 61, 28], [10880, 62, 29],
                    [10881, 45, 21], [10882, 75, 29], [10883, 90, 29], [10884, 101, 29], [10885, 45, 40],
                    [10886, 60, 30], [10887, 45, 30], [10888, 79, 38], [10889, 57, 32], [10890, 46, 24],
                    [10891, 33, 23], [10892, 41, 28], [10893, 62, 50], [10894, 60, 50], [10895, 91, 43],
                    [10896, 59, 44], [10897, 61, 44], [10898, 61, 44], [10899, 52, 27], [10900, 46, 23],
                    [10901, 52, 20], [10902, 53, 21], [10903, 55, 27], [10904, 56, 28], [10905, 45, 27],
                    [10906, 61, 42], [10907, 61, 41], [10908, 55, 24], [10909, 90, 25], [10910, 56, 26],
                    [10911, 76, 61], [10912, 76, 61], [10913, 48, 44], [10914, 99, 43], [10915, 62, 49],
                    [10916, 71, 48], [10917, 77, 48], [10918, 41, 38], [10978, 56, 21], [10979, 54, 35],
                    [10980, 53, 29], [11091, 9, 6], [11092, 13, 9], [11093, 12, 7], [11094, 19, 10], [11095, 9, 7],
                    [11096, 24, 18], [11097, 11, 7], [11098, 10, 7], [11099, 45, 37], [11100, 9, 6], [11101, 13, 8],
                    [11102, 11, 7], [11103, 17, 10], [11104, 59, 35], [11105, 35, 35], [11106, 30, 18], [11107, 21, 12],
                    [11108, 10, 5], [11109, 23, 19], [11110, 20, 10], [11111, 8, 8], [11112, 32, 19], [11113, 28, 16],
                    [11114, 43, 29], [11115, 9, 5], [11116, 9, 5], [11117, 10, 7], [11118, 18, 12], [11119, 43, 24],
                    [11120, 33, 23], [11121, 11, 8], [11122, 12, 7], [11123, 16, 9], [11124, 10, 8], [11125, 32, 16],
                    [11126, 15, 9], [11127, 8, 8], [11128, 14, 7], [11129, 8, 5], [11130, 16, 10], [11131, 8, 6],
                    [11132, 20, 12], [11133, 13, 8], [11134, 7, 4], [11135, 59, 30], [11136, 12, 8], [11137, 7, 5],
                    [11138, 21, 15], [11139, 14, 9], [11140, 12, 10], [11141, 11, 7], [11142, 10, 7], [11143, 9, 6],
                    [11144, 11, 8], [11145, 29, 23], [11146, 8, 6], [11147, 5, 3], [11148, 35, 31], [11149, 15, 11],
                    [11150, 24, 17], [11151, 15, 13], [11152, 14, 12], [11153, 15, 10], [11154, 27, 17],
                    [11155, 17, 10], [11156, 12, 11], [11157, 12, 10], [11158, 13, 11], [11159, 13, 12],
                    [11160, 14, 10], [11161, 14, 11], [11162, 13, 12], [11163, 13, 13], [11164, 18, 17],
                    [11165, 13, 10], [11166, 53, 33], [11167, 93, 51], [11168, 26, 18], [11169, 11, 10],
                    [11170, 14, 12], [11171, 15, 12], [11172, 10, 10], [11173, 15, 13], [11174, 8, 8], [11175, 7, 7],
                    [11176, 5, 5], [11177, 21, 16], [11178, 8, 9], [11179, 12, 10], [11180, 11, 8], [11181, 16, 13],
                    [11182, 14, 13], [11183, 13, 11], [11184, 112, 87], [11185, 112, 87], [11186, 112, 87],
                    [11187, 112, 87], [11188, 112, 87], [11189, 79, 123], [11190, 102, 83], [11191, 102, 83],
                    [11192, 102, 83], [11193, 102, 83], [11194, 62, 40], [11195, 60, 37], [11196, 76, 34],
                    [11197, 88, 30], [11198, 22, 23], [11199, 33, 25], [11200, 47, 33], [11201, 11, 11],
                    [11202, 14, 18], [11203, 14, 15], [11204, 75, 58], [11205, 57, 37], [11206, 56, 55],
                    [11207, 13, 15], [11208, 33, 18], [11292, 14, 18], [11293, 10, 12], [11294, 12, 15],
                    [11295, 12, 15]]],
            [2003, [[2, 80, 34], [7, 27, 26], [25, 13, 9], [42, 19, 20], [48, 66, 54], [49, 31, 22], [51, 34, 29],
                    [62, 19, 28], [65, 21, 19], [78, 25, 18], [82, 12, 19], [83, 33, 37], [87, 31, 27], [99, 26, 26],
                    [101, 53, 45], [119, 36, 25], [122, 28, 30], [125, 27, 28], [135, 37, 32], [138, 56, 35],
                    [163, 36, 34], [166, 30, 29], [169, 31, 19], [186, 18, 18], [190, 27, 26], [194, 20, 22],
                    [200, 36, 27], [204, 12, 21], [211, 20, 42], [215, 28, 27], [216, 21, 18], [218, 47, 23],
                    [220, 16, 17], [226, 21, 15], [231, 48, 42], [233, 18, 19], [234, 11, 15], [239, 57, 50],
                    [240, 51, 29], [242, 60, 30], [243, 56, 32], [246, 41, 27], [248, 36, 18], [270, 48, 38],
                    [272, 39, 16], [282, 39, 20], [285, 31, 18], [286, 25, 28], [299, 25, 18], [305, 27, 29],
                    [306, 31, 27], [308, 11, 35], [310, 18, 18], [312, 19, 18], [314, 17, 24], [317, 56, 37],
                    [320, 21, 25], [324, 38, 33], [327, 40, 36], [329, 36, 27], [330, 51, 30], [332, 57, 29],
                    [334, 31, 38], [337, 28, 27], [339, 33, 24], [344, 38, 37], [346, 47, 38], [355, 43, 28],
                    [361, 27, 26], [365, 72, 44], [378, 18, 21], [379, 14, 12], [389, 17, 22], [392, 18, 18],
                    [399, 65, 34], [402, 88, 50], [403, 42, 26], [418, 20, 19], [424, 22, 21], [425, 14, 21],
                    [428, 26, 19], [430, 20, 24], [432, 63, 38], [436, 42, 36], [455, 48, 26], [471, 18, 22],
                    [479, 28, 28], [480, 53, 23], [487, 28, 26], [493, 67, 52], [494, 16, 17], [497, 10, 14],
                    [503, 81, 22], [504, 12, 10], [505, 46, 27], [519, 18, 24], [525, 19, 29], [536, 28, 18],
                    [541, 112, 45], [545, 25, 28], [568, 18, 18], [569, 87, 28], [570, 24, 19], [573, 28, 26],
                    [577, 47, 22], [585, 50, 48], [590, 47, 54], [593, 37, 33], [595, 45, 27], [597, 34, 16],
                    [599, 51, 29], [604, 117, 58], [608, 25, 18], [612, 33, 39], [618, 23, 19], [625, 37, 17],
                    [628, 34, 27], [631, 35, 25], [654, 15, 12], [660, 56, 37], [662, 58, 43], [663, 60, 33],
                    [669, 26, 20], [678, 18, 23], [686, 15, 21], [691, 26, 32], [694, 36, 29], [695, 60, 45],
                    [700, 51, 38], [703, 12, 16], [704, 45, 26], [716, 53, 51], [717, 38, 27], [719, 55, 43],
                    [720, 22, 35], [724, 27, 35], [734, 19, 31], [737, 14, 12], [750, 36, 24], [751, 30, 16],
                    [754, 28, 27], [766, 82, 43], [769, 52, 37], [773, 44, 33], [781, 26, 20], [785, 50, 44],
                    [790, 36, 26], [801, 19, 20], [803, 32, 29], [805, 31, 24], [811, 36, 21], [815, 16, 16],
                    [820, 56, 38], [821, 38, 27], [822, 16, 20], [826, 19, 18], [827, 10, 14], [835, 52, 28],
                    [843, 34, 27], [844, 25, 23], [845, 49, 39], [848, 23, 22], [865, 65, 29], [871, 36, 23],
                    [878, 7, 6], [882, 40, 29], [890, 34, 32], [894, 26, 12], [909, 99, 34], [913, 21, 21],
                    [915, 48, 32], [922, 38, 28], [926, 50, 19], [938, 11, 12], [940, 11, 14], [941, 34, 30],
                    [944, 40, 22], [949, 57, 30], [950, 14, 18], [964, 11, 15], [969, 48, 39], [971, 19, 16],
                    [972, 33, 25], [978, 43, 43], [979, 18, 18], [985, 77, 36], [990, 21, 18], [993, 63, 35],
                    [998, 34, 19], [1003, 8, 6], [1008, 21, 23], [1016, 11, 14], [1030, 9, 14], [1033, 19, 19],
                    [1042, 118, 64], [1048, 34, 32], [1051, 22, 18], [1056, 20, 39], [1059, 40, 40], [1073, 61, 29],
                    [1082, 93, 39], [1094, 23, 19], [1095, 18, 18], [1097, 30, 20], [1100, 31, 24], [1102, 15, 16],
                    [1106, 75, 28], [1109, 30, 27], [1111, 45, 46], [1131, 53, 39], [1132, 11, 14], [1136, 38, 39],
                    [1141, 64, 35], [1142, 22, 23], [1144, 25, 20], [1145, 28, 23], [1150, 33, 24], [1155, 29, 26],
                    [1156, 26, 18], [1157, 40, 33], [1159, 83, 38], [1167, 25, 21], [1169, 31, 26], [1174, 28, 41],
                    [1175, 28, 21], [1177, 31, 26], [1186, 15, 18], [1194, 92, 39], [1200, 19, 19], [1203, 11, 17],
                    [1205, 25, 22], [1213, 22, 19], [1217, 47, 26], [1219, 31, 18], [1221, 18, 18], [1224, 78, 47],
                    [1226, 19, 26], [1228, 31, 22], [1234, 12, 15], [1235, 25, 20], [1238, 14, 25], [1247, 49, 29],
                    [1254, 48, 24], [1262, 39, 29], [1268, 37, 28], [1275, 32, 13], [1281, 14, 18], [1295, 40, 47],
                    [1302, 48, 55], [1303, 73, 35], [1305, 20, 18], [1319, 50, 24], [1320, 39, 35], [1323, 43, 27],
                    [1334, 83, 50], [1358, 57, 36], [1359, 37, 27], [1361, 46, 27], [1363, 55, 47], [1367, 52, 39],
                    [1370, 13, 20], [1375, 34, 33], [1396, 11, 20], [1420, 46, 43], [1445, 70, 25], [1454, 23, 25],
                    [1456, 26, 26], [1465, 17, 18], [1466, 33, 21], [1471, 50, 37], [1473, 14, 19], [1475, 59, 27],
                    [1476, 51, 37], [1477, 52, 19], [1481, 40, 26], [1482, 13, 17], [1484, 47, 32], [1486, 14, 13],
                    [1490, 35, 18], [1491, 11, 9], [1493, 26, 19], [1507, 35, 22], [1508, 27, 27], [1510, 16, 19],
                    [1511, 32, 26], [1515, 23, 18], [1522, 26, 20], [1525, 37, 36], [1527, 35, 31], [1530, 73, 50],
                    [1536, 17, 20], [1537, 70, 51], [1548, 40, 38], [1553, 46, 27], [1556, 37, 29], [1557, 31, 27],
                    [1561, 18, 18], [1562, 49, 36], [1568, 29, 27], [1575, 178, 74], [1577, 26, 18], [1580, 41, 34],
                    [1582, 23, 23], [1587, 17, 17], [1589, 38, 18], [1598, 14, 8], [1610, 27, 26], [1628, 33, 21],
                    [1635, 17, 16], [1638, 46, 40], [1644, 116, 66], [1645, 40, 25], [1659, 24, 21], [1660, 54, 31],
                    [1662, 14, 11], [1663, 45, 35], [1664, 17, 15], [1672, 50, 32], [1673, 83, 37], [1680, 131, 51],
                    [1685, 38, 35], [1704, 16, 19], [1717, 50, 25], [1724, 36, 30], [1730, 17, 12], [1744, 47, 30],
                    [1748, 45, 27], [1756, 28, 26], [1760, 13, 16], [1763, 22, 21], [1769, 51, 43], [1771, 18, 18],
                    [1772, 12, 14], [1774, 22, 24], [1780, 37, 32], [1781, 35, 30], [1786, 19, 24], [1790, 18, 18],
                    [1792, 26, 26], [1794, 31, 32], [1795, 13, 10], [1797, 53, 35], [1798, 37, 47], [1804, 33, 20],
                    [1812, 14, 17], [1816, 156, 44], [1818, 18, 18], [1824, 31, 35], [1825, 18, 24], [1829, 17, 25],
                    [1841, 38, 37], [1845, 43, 27], [1848, 54, 29], [1853, 51, 24], [1864, 110, 65], [1866, 54, 29],
                    [1876, 47, 29], [1879, 38, 18], [1882, 16, 18], [1891, 35, 33], [1894, 33, 15], [1901, 36, 24],
                    [1903, 74, 31], [1915, 42, 33], [1916, 23, 19], [1917, 49, 33], [1921, 17, 14], [1925, 33, 26],
                    [1930, 10, 8], [1933, 11, 14], [1945, 51, 36], [1948, 21, 30], [1950, 20, 31], [1952, 192, 62],
                    [1962, 12, 15], [1965, 66, 42], [1995, 50, 30], [2000, 35, 26], [2001, 34, 25], [2006, 21, 19],
                    [2011, 12, 17], [2017, 33, 34], [2021, 30, 26], [2023, 11, 11], [2025, 67, 52], [2026, 138, 54],
                    [2028, 48, 33], [2029, 41, 28], [2032, 16, 18], [2035, 54, 29], [2042, 29, 29], [2048, 14, 29],
                    [2056, 28, 46], [2057, 68, 34], [2064, 62, 32], [2081, 34, 17], [2084, 72, 27], [2098, 13, 16],
                    [2099, 36, 26], [2101, 36, 21], [2104, 51, 34], [2121, 17, 16], [2127, 15, 15], [2128, 28, 27],
                    [2131, 26, 35], [2138, 27, 26], [2142, 9, 10], [2144, 21, 55], [2162, 31, 32], [2163, 46, 42],
                    [2170, 29, 19], [2171, 24, 23], [2174, 25, 22], [2178, 12, 18], [2180, 41, 26], [2181, 65, 49],
                    [2182, 34, 26], [2190, 26, 20], [2198, 21, 17], [2201, 27, 27], [2208, 42, 30], [2213, 41, 34],
                    [2216, 36, 27], [2220, 30, 19], [2224, 37, 30], [2227, 19, 21], [2232, 27, 27], [2236, 36, 25],
                    [2238, 34, 26], [2239, 49, 19], [2244, 23, 24], [2250, 40, 26], [2255, 42, 26], [2258, 26, 26],
                    [2277, 29, 22], [2280, 9, 7], [2282, 18, 55], [2293, 51, 48], [2300, 36, 41], [2303, 32, 28],
                    [2311, 36, 34], [2312, 37, 19], [2316, 48, 28], [2332, 14, 15], [2335, 53, 39], [2343, 38, 27],
                    [2352, 38, 34], [2366, 15, 16], [2367, 46, 27], [2371, 51, 29], [2383, 48, 36], [2384, 23, 31],
                    [2404, 26, 26], [2405, 33, 29], [2428, 28, 30], [2429, 12, 12], [2433, 47, 21], [2435, 16, 12],
                    [2443, 50, 29], [2447, 23, 18], [2458, 32, 24], [2459, 28, 15], [2467, 12, 15], [2472, 28, 20],
                    [2483, 50, 48], [2485, 13, 16], [2488, 31, 23], [2493, 50, 18], [2494, 37, 27], [2497, 35, 18],
                    [2500, 23, 17], [2501, 55, 24], [2505, 40, 26], [2509, 15, 17], [2514, 109, 43], [2516, 42, 26],
                    [2518, 52, 31], [2524, 10, 10], [2527, 37, 32], [2533, 10, 16], [2539, 89, 27], [2540, 18, 20],
                    [2543, 18, 21], [2547, 17, 32], [2551, 93, 37], [2554, 12, 21], [2562, 104, 36], [2564, 29, 20],
                    [2574, 76, 43], [2576, 50, 25], [2585, 48, 38], [2587, 43, 26], [2593, 42, 27], [2595, 38, 31],
                    [2603, 60, 38], [2604, 27, 27], [2606, 18, 14], [2607, 13, 10], [2612, 43, 28], [2615, 71, 29],
                    [2617, 34, 21], [2619, 11, 12], [2622, 24, 19], [2627, 52, 29], [2628, 50, 35], [2632, 50, 35],
                    [2633, 46, 27], [2635, 12, 18], [2644, 31, 19], [2647, 28, 24], [2650, 28, 25], [2656, 19, 18],
                    [2658, 44, 27], [2667, 43, 26], [2668, 61, 44], [2669, 74, 36], [2670, 39, 26], [2671, 45, 49],
                    [2687, 46, 23], [2692, 51, 23], [2695, 12, 13], [2720, 32, 35], [2723, 36, 55], [2743, 26, 26],
                    [2747, 39, 33], [2748, 44, 33], [2758, 30, 26], [2762, 60, 37], [2775, 50, 29], [2785, 12, 14],
                    [2788, 40, 26], [2797, 22, 16], [2798, 12, 18], [2813, 47, 27], [2822, 26, 21], [2823, 25, 18],
                    [2827, 12, 17], [2832, 16, 16], [2833, 42, 29], [2835, 29, 27], [2836, 26, 19], [2838, 33, 28],
                    [2846, 26, 37], [2851, 19, 16], [2854, 43, 29], [2856, 56, 31], [2867, 63, 43], [2872, 18, 19],
                    [2876, 60, 34], [2879, 23, 21], [2880, 38, 26], [2883, 40, 42], [2884, 33, 39], [2897, 67, 41],
                    [2901, 54, 44], [2904, 60, 28], [2910, 18, 18], [2914, 41, 27], [2918, 92, 31], [2922, 14, 15],
                    [2923, 87, 50], [2929, 51, 33], [2932, 28, 29], [2934, 19, 18], [2935, 55, 28], [2936, 37, 25],
                    [2946, 37, 27], [2950, 39, 27], [2969, 24, 16], [2973, 35, 43], [2974, 34, 20], [2978, 27, 26],
                    [2979, 22, 15], [2991, 36, 39], [2995, 39, 36], [3011, 40, 26], [3016, 40, 26], [3019, 37, 20],
                    [3027, 18, 19], [3033, 59, 37], [3035, 19, 19], [3046, 57, 25], [3048, 48, 28], [3050, 26, 19],
                    [3053, 57, 54], [3061, 51, 26], [3066, 51, 26], [3070, 40, 31], [3077, 57, 47], [3086, 114, 39],
                    [3091, 15, 14], [3092, 40, 21], [3098, 38, 38], [3106, 18, 21], [3112, 49, 30], [3114, 57, 29],
                    [3119, 11, 25], [3121, 24, 22], [3122, 37, 31], [3126, 40, 19], [3129, 82, 45], [3133, 43, 33],
                    [3134, 38, 33], [3137, 33, 27], [3142, 29, 34], [3148, 38, 27], [3154, 60, 27], [3155, 23, 19],
                    [3158, 15, 17], [3160, 19, 18], [3161, 18, 18], [3164, 49, 31], [3167, 19, 25], [3171, 34, 18],
                    [3175, 44, 29], [3182, 154, 48], [3188, 52, 31], [3189, 48, 27], [3195, 31, 22], [3206, 55, 27],
                    [3217, 34, 26], [3221, 40, 19], [3228, 50, 27], [3231, 18, 18], [3234, 45, 23], [3246, 91, 29],
                    [3248, 17, 25], [3252, 35, 22], [3254, 25, 26], [3256, 29, 20], [3264, 25, 26], [3268, 30, 27],
                    [3272, 43, 30], [3273, 66, 17], [3274, 23, 20], [3277, 40, 25], [3280, 36, 27], [3283, 23, 20],
                    [3284, 45, 33], [3289, 95, 57], [3301, 39, 36], [3306, 19, 23], [3308, 55, 34], [3309, 34, 32],
                    [3320, 47, 49], [3321, 41, 22], [3326, 18, 19], [3327, 43, 43], [3331, 35, 21], [3336, 22, 19],
                    [3344, 22, 18], [3346, 35, 39], [3348, 50, 26], [3357, 12, 17], [3358, 19, 16], [3363, 51, 26],
                    [3364, 11, 16], [3372, 47, 27], [3382, 32, 22], [3404, 43, 38], [3407, 36, 34], [3418, 62, 32],
                    [3422, 42, 30], [3429, 42, 35], [3434, 7, 6], [3438, 48, 26], [3439, 31, 24], [3441, 53, 39],
                    [3442, 24, 18], [3451, 41, 42], [3453, 18, 19], [3454, 11, 11], [3457, 67, 50], [3459, 24, 21],
                    [3462, 51, 24], [3468, 28, 24], [3469, 25, 17], [3494, 11, 14], [3498, 17, 22], [3503, 62, 42],
                    [3511, 18, 28], [3515, 14, 44], [3517, 47, 20], [3531, 24, 18], [3541, 25, 23], [3557, 10, 13],
                    [3559, 41, 36], [3566, 15, 12], [3569, 55, 55], [3572, 32, 24], [3579, 19, 29], [3590, 25, 27],
                    [3593, 54, 56], [3598, 16, 13], [3602, 18, 18], [3608, 41, 27], [3632, 26, 26], [3639, 35, 23],
                    [3642, 59, 26], [3644, 39, 26], [3650, 35, 27], [3653, 24, 18], [3656, 46, 27], [3659, 42, 29],
                    [3661, 26, 26], [3667, 29, 31], [3669, 11, 18], [3670, 110, 48], [3679, 17, 18], [3700, 20, 22],
                    [3703, 40, 25], [3718, 47, 25], [3726, 11, 12], [3729, 125, 48], [3731, 55, 69], [3747, 58, 31],
                    [3751, 39, 26], [3755, 35, 26], [3761, 19, 21], [3765, 21, 20], [3777, 25, 29], [3782, 58, 32],
                    [3786, 13, 12], [3795, 52, 37], [3796, 26, 26], [3807, 19, 18], [3827, 32, 26], [3828, 19, 20],
                    [3832, 55, 50], [3833, 63, 33], [3834, 30, 41], [3841, 63, 29], [3845, 55, 26], [3854, 33, 26],
                    [3855, 48, 38], [3859, 12, 15], [3870, 55, 35], [3874, 41, 27], [3883, 55, 34], [3884, 52, 30],
                    [3889, 70, 26], [3897, 37, 26], [3905, 25, 25], [3915, 27, 27], [3921, 27, 26], [3925, 56, 41],
                    [3932, 23, 27], [3942, 31, 29], [3943, 30, 24], [3947, 39, 33], [3953, 39, 34], [3956, 41, 51],
                    [3959, 28, 18], [3960, 64, 52], [3963, 21, 15], [3969, 70, 45], [3970, 52, 35], [3972, 150, 72],
                    [3976, 17, 14], [3985, 27, 22], [3988, 23, 28], [3992, 75, 36], [3993, 11, 12], [3999, 41, 27],
                    [4015, 51, 27], [4022, 38, 23], [4023, 27, 27], [4026, 30, 18], [4027, 69, 33], [4028, 26, 33],
                    [4031, 16, 14], [4034, 65, 39], [4035, 19, 18], [4038, 76, 34], [4040, 73, 35], [4043, 18, 17],
                    [4047, 47, 38], [4074, 19, 27], [4082, 68, 34], [4084, 11, 16], [4091, 35, 15], [4095, 26, 26],
                    [4096, 47, 31], [4106, 47, 30], [4107, 64, 28], [4109, 17, 17], [4111, 19, 13], [4116, 25, 26],
                    [4118, 27, 26], [4120, 63, 32], [4122, 53, 48], [4124, 40, 28], [4125, 12, 16], [4134, 114, 49],
                    [4152, 87, 42], [4156, 18, 19], [4164, 26, 18], [4165, 34, 33], [4169, 26, 20], [4173, 11, 16],
                    [4176, 11, 14], [4177, 101, 57], [4182, 47, 26], [4185, 17, 19], [4188, 74, 23], [4189, 17, 26],
                    [4199, 87, 37], [4203, 49, 27], [4206, 14, 18], [4209, 41, 38], [4229, 26, 20], [4242, 33, 30],
                    [4246, 11, 22], [4250, 63, 18], [4272, 49, 31], [4279, 42, 35], [4283, 29, 22], [4285, 28, 31],
                    [4298, 39, 44], [4299, 32, 30], [4301, 52, 51], [4310, 30, 24], [4312, 46, 27], [4318, 18, 18],
                    [4320, 28, 29], [4325, 63, 26], [4326, 10, 13], [4329, 22, 26], [4333, 47, 31], [4338, 28, 26],
                    [4345, 31, 24], [4349, 64, 32], [4350, 19, 18], [4352, 18, 18], [4353, 24, 23], [4358, 14, 15],
                    [4362, 83, 52], [4364, 24, 27], [4380, 17, 19], [4382, 101, 41], [4384, 55, 37], [4386, 14, 16],
                    [4391, 51, 28], [4406, 55, 26], [4413, 11, 12], [4414, 15, 22], [4415, 73, 33], [4421, 32, 26],
                    [4426, 11, 14], [4438, 49, 32], [4440, 41, 28], [4441, 16, 13], [4442, 14, 18], [4446, 65, 32],
                    [4454, 19, 18], [4461, 38, 26], [4464, 48, 26], [4470, 28, 30], [4471, 18, 18], [4477, 28, 31],
                    [4487, 25, 31], [4491, 44, 29], [4494, 18, 20], [4495, 25, 20], [4500, 24, 18], [4504, 63, 38],
                    [4506, 17, 18], [4508, 29, 25], [4510, 31, 33], [4515, 57, 43], [4518, 52, 35], [4521, 50, 27],
                    [4524, 27, 27], [4532, 31, 18], [4536, 20, 19], [4542, 33, 23], [4545, 44, 32], [4550, 41, 28],
                    [4552, 14, 16], [4558, 27, 25], [4563, 40, 27], [4572, 30, 26], [4587, 56, 22], [4591, 37, 25],
                    [4602, 22, 25], [4606, 29, 29], [4608, 19, 22], [4610, 50, 24], [4611, 29, 18], [4613, 39, 33],
                    [4616, 21, 17], [4617, 124, 52], [4618, 24, 22], [4623, 15, 18], [4626, 32, 21], [4633, 22, 19],
                    [4634, 29, 27], [4635, 57, 13], [4638, 107, 34], [4643, 24, 22], [4644, 13, 17], [4648, 29, 11],
                    [4660, 53, 25], [4668, 60, 33], [4670, 52, 23], [4676, 15, 18], [4684, 20, 18], [4689, 41, 28],
                    [4693, 59, 29], [4694, 34, 20], [4703, 12, 14], [4710, 9, 7], [4711, 16, 15], [4712, 39, 33],
                    [4717, 18, 29], [4724, 28, 20], [4728, 25, 23], [4729, 69, 50], [4732, 61, 69], [4734, 16, 16],
                    [4738, 38, 45], [4745, 17, 20], [4747, 49, 33], [4749, 40, 28], [4753, 26, 21], [4762, 47, 45],
                    [4764, 25, 36], [4777, 24, 23], [4780, 44, 39], [4789, 37, 22], [4791, 23, 28], [4794, 24, 18],
                    [4800, 51, 41], [4801, 11, 18], [4802, 26, 18], [4805, 15, 20], [4815, 37, 27], [4819, 35, 22],
                    [4820, 46, 44], [4826, 18, 18], [4828, 67, 50], [4829, 36, 32], [4832, 12, 16], [4835, 22, 21],
                    [4839, 31, 19], [4840, 49, 31], [4844, 29, 19], [4849, 21, 20], [4863, 41, 24], [4864, 18, 20],
                    [4865, 30, 21], [4871, 15, 19], [4872, 119, 49], [4877, 22, 18], [4880, 17, 20], [4881, 33, 32],
                    [4888, 47, 44], [4897, 15, 21], [4910, 38, 27], [4912, 10, 18], [4914, 32, 21], [4915, 18, 16],
                    [4918, 46, 26], [4922, 60, 45], [4926, 54, 50], [4927, 18, 18], [4931, 17, 18], [4939, 22, 21],
                    [4940, 38, 23], [4944, 14, 15], [4950, 59, 27], [4951, 37, 33], [4955, 44, 30], [4957, 31, 24],
                    [4960, 88, 48], [4973, 29, 30], [4975, 26, 26], [4976, 11, 16], [4978, 56, 43], [4979, 150, 31],
                    [4983, 19, 18], [4987, 29, 19], [4990, 42, 26], [4992, 23, 21], [4995, 29, 25], [4996, 47, 27],
                    [4997, 24, 22], [4998, 78, 27], [5005, 41, 36], [5006, 81, 36], [5008, 55, 27], [5009, 18, 18],
                    [5011, 57, 41], [5012, 40, 46], [5013, 19, 16], [5017, 26, 26], [5019, 47, 30], [5022, 159, 68],
                    [5027, 36, 26], [5031, 10, 14], [5032, 45, 26], [5033, 32, 22], [5035, 27, 27], [5037, 81, 34],
                    [5038, 12, 18], [5046, 52, 27], [5048, 32, 28], [5050, 18, 14], [5051, 11, 12], [5053, 27, 21],
                    [5058, 50, 27], [5062, 41, 34], [5063, 21, 28], [5064, 53, 34], [5065, 62, 32], [5068, 40, 21],
                    [5069, 51, 32], [5070, 23, 20], [5071, 25, 26], [5073, 61, 39], [5075, 24, 27], [5079, 18, 18],
                    [5081, 41, 16], [5091, 85, 41], [5092, 11, 16], [5095, 14, 16], [5098, 29, 19], [5102, 19, 12],
                    [5103, 84, 44], [5104, 83, 33], [5107, 95, 39], [5108, 21, 29], [5109, 47, 19], [5116, 36, 28],
                    [5121, 24, 18], [5122, 36, 28], [5126, 27, 22], [5127, 18, 18], [5130, 43, 48], [5138, 15, 14],
                    [5149, 21, 19], [5150, 54, 34], [5153, 61, 34], [5159, 76, 29], [5162, 21, 20], [5173, 37, 22],
                    [5180, 27, 41], [5181, 17, 18], [5182, 38, 21], [5183, 39, 33], [5184, 33, 21], [5185, 29, 17],
                    [5186, 12, 16], [5187, 12, 12], [5188, 11, 14], [5189, 18, 10], [5217, 50, 35], [5219, 17, 49],
                    [5220, 14, 51], [5221, 12, 39], [5222, 15, 21], [5223, 11, 29], [5224, 15, 42], [5225, 16, 51],
                    [5226, 12, 52], [5227, 29, 61], [5228, 19, 58], [5229, 11, 41], [5230, 16, 36], [5231, 13, 31],
                    [5232, 19, 55], [5233, 23, 74], [5234, 11, 25], [5235, 38, 40], [5236, 15, 39], [5237, 26, 52],
                    [5238, 16, 40], [5239, 23, 60], [5240, 18, 64], [5241, 27, 60], [5242, 20, 42], [5243, 26, 65],
                    [5244, 19, 72], [5245, 25, 64], [5247, 32, 13], [5248, 33, 19], [5273, 25, 16], [5276, 28, 44],
                    [5279, 20, 22], [5287, 12, 12], [5290, 20, 19], [5298, 12, 12], [5299, 17, 19], [5303, 30, 20],
                    [5305, 24, 21], [5314, 20, 21], [5315, 18, 23], [5317, 35, 48], [5321, 21, 20], [5323, 14, 20],
                    [5328, 18, 18], [5332, 19, 23], [5333, 12, 14], [5336, 14, 16], [5337, 16, 16], [5338, 26, 22],
                    [5339, 20, 21], [5340, 25, 28], [5343, 14, 13], [5344, 37, 37], [5347, 18, 20], [5349, 20, 23],
                    [5350, 19, 24], [5353, 17, 21], [5355, 20, 30], [5357, 23, 18], [5359, 17, 21], [5366, 25, 21],
                    [5371, 29, 30], [5372, 21, 20], [5375, 17, 16], [5377, 15, 16], [5383, 23, 23], [5385, 27, 21],
                    [5387, 15, 14], [5400, 14, 13], [5403, 21, 21], [5404, 21, 21], [5407, 19, 21], [5408, 17, 20],
                    [5411, 21, 18], [5412, 19, 16], [5414, 12, 14], [5415, 35, 37], [5418, 24, 29], [5420, 16, 15],
                    [5421, 16, 13], [5422, 22, 27], [5425, 16, 18], [5426, 18, 23], [5428, 17, 21], [5431, 21, 22],
                    [5432, 21, 25], [5434, 14, 15], [5436, 18, 20], [5437, 25, 21], [5440, 30, 24], [5441, 25, 30],
                    [5444, 21, 29], [5447, 18, 20], [5449, 22, 26], [5450, 24, 25], [5452, 20, 26], [5453, 27, 26],
                    [5454, 13, 14], [5455, 22, 18], [5457, 14, 20], [5459, 21, 21], [5462, 20, 22], [5463, 13, 16],
                    [5464, 17, 16], [5465, 20, 20], [5472, 19, 22], [5473, 16, 20], [5476, 15, 18], [5479, 19, 17],
                    [5480, 29, 25], [5482, 16, 17], [5486, 20, 19], [5489, 26, 41], [5492, 22, 32], [5494, 22, 24],
                    [5495, 24, 21], [5498, 32, 31], [5499, 26, 20], [5501, 23, 32], [5505, 16, 23], [5508, 21, 27],
                    [5528, 18, 17], [5532, 21, 20], [5534, 15, 13], [5539, 15, 18], [5541, 23, 19], [5544, 20, 25],
                    [5545, 15, 19], [5547, 25, 23], [5550, 16, 16], [5571, 22, 18], [5659, 9, 7], [5944, 7, 8],
                    [5945, 11, 9], [5946, 6, 5], [5962, 71, 83], [5996, 47, 27], [6068, 51, 40], [6069, 54, 47],
                    [6070, 54, 47], [6071, 31, 27], [6072, 21, 36], [6073, 33, 34], [6074, 38, 33], [6075, 54, 47],
                    [6076, 39, 36], [6077, 33, 31], [6078, 39, 42], [6079, 41, 35], [6080, 39, 40], [6081, 26, 28],
                    [6082, 38, 33], [6083, 35, 30], [6084, 48, 33], [6085, 42, 36], [6086, 26, 23], [6087, 94, 31],
                    [6088, 39, 36], [6089, 33, 30], [6090, 54, 38], [6091, 31, 30], [6092, 35, 35], [6093, 38, 33],
                    [6094, 38, 33], [6095, 26, 24], [6096, 35, 27], [6097, 41, 31], [6098, 35, 30], [6099, 48, 33],
                    [6100, 38, 33], [6101, 38, 27], [6102, 26, 26], [6103, 35, 30], [6104, 42, 29], [6105, 48, 33],
                    [6106, 30, 27], [6107, 30, 27], [6108, 38, 32], [6109, 23, 27], [6110, 35, 33], [6111, 17, 24],
                    [6112, 32, 31], [6113, 26, 25], [6114, 26, 25], [6115, 26, 29], [6116, 36, 31], [6117, 29, 29],
                    [6118, 36, 34], [6119, 32, 31], [6120, 22, 25], [6121, 32, 32], [6122, 32, 28], [6123, 25, 25],
                    [6124, 35, 29], [6125, 29, 29], [6126, 32, 32], [6127, 32, 32], [6128, 27, 34], [6130, 32, 31],
                    [6131, 35, 30], [6132, 38, 33], [6133, 35, 30], [6134, 35, 30], [6135, 84, 73], [6136, 72, 63],
                    [6137, 19, 22], [6138, 29, 33], [6139, 33, 32], [6140, 23, 28], [6141, 33, 36], [6142, 27, 32],
                    [6143, 29, 29], [6144, 24, 24], [6145, 35, 35], [6146, 17, 24], [6147, 24, 34], [6148, 24, 29],
                    [6149, 32, 32], [6150, 18, 24], [6151, 24, 24], [6152, 21, 25], [6153, 22, 27], [6154, 32, 32],
                    [6155, 23, 27], [6156, 26, 29], [6157, 38, 35], [6158, 26, 27], [6159, 36, 34], [6160, 22, 25],
                    [6161, 17, 23], [6162, 20, 24], [6163, 51, 43], [6164, 33, 34], [6165, 29, 28], [6166, 46, 32],
                    [6167, 51, 42], [6244, 50, 37], [6353, 40, 40], [6357, 40, 40], [6358, 91, 41], [6359, 22, 22],
                    [6360, 84, 62], [6361, 84, 70], [6362, 54, 52], [6363, 54, 56], [6364, 84, 63], [6365, 93, 69],
                    [6366, 93, 69], [6367, 51, 52], [6368, 84, 63], [6369, 58, 56], [6370, 83, 62], [6371, 84, 69],
                    [6372, 93, 69], [6373, 93, 74], [6374, 84, 62], [6375, 93, 62], [6376, 58, 52], [6377, 92, 68],
                    [6378, 54, 52], [6379, 59, 55], [6380, 58, 51], [6381, 58, 52], [6382, 84, 62], [6383, 58, 52],
                    [6384, 84, 63], [6385, 84, 52], [6386, 84, 62], [6387, 83, 68], [6388, 84, 62], [6389, 93, 69],
                    [6390, 84, 63], [6391, 53, 49], [6392, 84, 62], [6393, 93, 69], [6394, 93, 69], [6395, 84, 63],
                    [6396, 93, 69], [6397, 84, 62], [6398, 100, 74], [6399, 93, 69], [6400, 80, 59], [6401, 58, 57],
                    [6402, 93, 69], [6403, 100, 74], [6404, 93, 69], [6405, 93, 69], [6406, 84, 62], [6407, 84, 63],
                    [6408, 84, 63], [6409, 84, 62], [6410, 84, 63], [6411, 78, 58], [6412, 84, 62], [6413, 100, 74],
                    [6414, 93, 62], [6415, 83, 62], [6416, 93, 69], [6417, 93, 69], [6418, 100, 74], [6419, 93, 74],
                    [6420, 100, 74], [6421, 84, 62], [6422, 84, 63], [6423, 29, 27], [6424, 58, 57], [6425, 58, 52],
                    [6426, 84, 69], [6427, 100, 74], [6428, 93, 69], [6429, 100, 74], [6430, 54, 57], [6431, 84, 63],
                    [6432, 84, 69], [6433, 48, 50], [6434, 83, 62], [6435, 57, 49], [6436, 93, 62], [6437, 93, 69],
                    [6438, 84, 62], [6439, 84, 62], [6440, 93, 69], [6441, 79, 59], [6442, 53, 49], [6443, 84, 62],
                    [6444, 66, 70], [6445, 84, 62], [6446, 93, 69], [6447, 52, 39], [6448, 84, 62], [6449, 93, 74],
                    [6450, 93, 69], [6451, 93, 74], [6452, 93, 62], [6453, 84, 62], [6454, 84, 62], [6455, 84, 62],
                    [6456, 84, 62], [6457, 32, 33], [6458, 24, 27], [6459, 100, 69], [6460, 93, 69], [6461, 84, 62],
                    [6462, 82, 68], [6463, 83, 68], [6464, 100, 74], [6465, 93, 74], [6466, 83, 62], [6467, 92, 68],
                    [6468, 93, 69], [6469, 84, 62], [6470, 84, 63], [6471, 84, 62], [6472, 93, 69], [6473, 93, 69],
                    [6474, 84, 62], [6475, 84, 62], [6476, 84, 62], [6477, 106, 80], [6478, 84, 62], [6479, 84, 62],
                    [6480, 84, 62], [6481, 93, 69], [6482, 93, 74], [6483, 84, 62], [6484, 59, 43], [6485, 79, 63],
                    [6486, 93, 69], [6487, 84, 63], [6488, 84, 63], [6489, 84, 62], [6490, 84, 62], [6491, 84, 62],
                    [6492, 27, 27], [6493, 84, 63], [6494, 27, 27], [6495, 80, 59], [6496, 84, 63], [6498, 100, 74],
                    [6499, 93, 69], [6500, 58, 52], [6501, 84, 63], [6502, 51, 52], [6503, 84, 62], [6504, 84, 70],
                    [6505, 84, 62], [6506, 84, 69], [6507, 93, 69], [6508, 93, 69], [6509, 84, 63], [6510, 100, 74],
                    [6511, 84, 63], [6512, 84, 63], [6513, 22, 20], [6514, 82, 61], [6515, 84, 69], [6516, 59, 48],
                    [6517, 31, 27], [6518, 84, 69], [6519, 92, 69], [6520, 100, 74], [6521, 46, 44], [6522, 84, 62],
                    [6523, 100, 74], [6524, 93, 69], [6525, 84, 63], [6526, 93, 69], [6527, 84, 63], [6528, 84, 62],
                    [6529, 92, 70], [6530, 80, 59], [6531, 93, 74], [6532, 84, 62], [6533, 84, 62], [6534, 84, 69],
                    [6535, 93, 69], [6536, 30, 30], [6537, 93, 69], [6538, 93, 74], [6539, 84, 62], [6540, 93, 74],
                    [6541, 93, 69], [6542, 93, 69], [6543, 93, 69], [6544, 93, 69], [6546, 93, 69], [6547, 100, 74],
                    [6548, 93, 69], [6549, 93, 74], [6550, 93, 69], [6551, 93, 69], [6552, 93, 74], [6553, 93, 69],
                    [6554, 93, 69], [6555, 93, 69], [6556, 93, 69], [6557, 93, 69], [6558, 84, 62], [6559, 93, 69],
                    [6560, 84, 62], [6561, 93, 74], [6562, 93, 69], [6563, 93, 69], [6564, 93, 69], [6565, 92, 70],
                    [6566, 84, 56], [6567, 93, 69], [6568, 84, 63], [6569, 84, 63], [6570, 93, 69], [6572, 93, 69],
                    [6573, 84, 63], [6574, 84, 62], [6575, 83, 61], [6576, 84, 62], [6577, 84, 63], [6578, 84, 62],
                    [6579, 93, 69], [6580, 84, 63], [6581, 92, 69], [6582, 84, 62], [6583, 92, 68], [6584, 106, 80],
                    [6585, 84, 63], [6586, 84, 63], [6587, 84, 63], [6588, 83, 62], [6589, 84, 62], [6590, 106, 80],
                    [6591, 93, 69], [6592, 93, 69], [6593, 93, 69], [6594, 93, 69], [6595, 84, 62], [6596, 84, 62],
                    [6597, 93, 69], [6598, 93, 69], [6599, 93, 69], [6600, 84, 62], [6601, 93, 69], [6602, 84, 62],
                    [6603, 54, 52], [6604, 93, 74], [6605, 84, 62], [6606, 84, 63], [6607, 93, 62], [6608, 84, 62],
                    [6609, 84, 62], [6610, 84, 62], [6611, 54, 52], [6612, 84, 69], [6613, 84, 62], [6614, 30, 30],
                    [6615, 84, 63], [6616, 84, 62], [6617, 33, 30], [6618, 84, 63], [6619, 93, 69], [6620, 93, 69],
                    [6621, 84, 62], [6622, 84, 63], [6623, 93, 69], [6624, 100, 69], [6625, 93, 69], [6626, 100, 74],
                    [6627, 84, 62], [6628, 93, 74], [6629, 54, 57], [6630, 58, 57], [6631, 46, 49], [6632, 23, 25],
                    [6633, 30, 32], [6634, 36, 34], [6635, 42, 36], [6636, 61, 53], [6637, 48, 33], [6638, 54, 40],
                    [6639, 42, 43], [6640, 52, 56], [6643, 31, 30], [6649, 48, 34], [6650, 48, 33], [6651, 33, 24],
                    [6652, 45, 35], [6653, 45, 39], [6654, 32, 31], [6655, 31, 27], [6656, 36, 31], [6657, 42, 36],
                    [6660, 36, 26], [6661, 29, 29], [6662, 40, 35], [6663, 32, 31], [6664, 39, 36], [6665, 32, 32],
                    [6666, 32, 29], [6667, 32, 31], [6668, 32, 24], [6669, 41, 36], [6670, 33, 31], [6671, 45, 31],
                    [6672, 36, 27], [6673, 38, 30], [6674, 36, 35], [6675, 33, 31], [6676, 46, 43], [6677, 32, 32],
                    [6678, 33, 31], [6679, 72, 63], [6680, 30, 27], [6682, 29, 28], [6683, 32, 32], [6684, 30, 36],
                    [6685, 25, 28], [6686, 24, 28], [6687, 26, 29], [6688, 24, 28], [6689, 25, 29], [6690, 24, 28],
                    [6697, 35, 28], [6699, 53, 46], [6700, 61, 54], [6701, 56, 65], [6702, 56, 38], [6704, 42, 35],
                    [6706, 39, 35], [6708, 48, 46], [6715, 53, 42], [6716, 67, 44], [6718, 71, 54], [6722, 52, 44],
                    [6723, 53, 40], [6725, 39, 38], [6726, 76, 53], [6728, 44, 41], [6730, 39, 37], [6734, 52, 39],
                    [6737, 55, 47], [6738, 42, 40], [6741, 17, 17], [6748, 29, 28], [6749, 31, 30], [6750, 45, 43],
                    [6752, 24, 28], [6753, 38, 35], [6754, 36, 34], [6755, 44, 44], [6756, 38, 38], [6757, 34, 33],
                    [6758, 38, 46], [6759, 24, 28], [6760, 44, 44], [6761, 45, 43], [6762, 38, 38], [6763, 26, 24],
                    [6764, 35, 38], [6766, 54, 49], [6767, 35, 33], [6768, 36, 35], [6769, 44, 54], [6770, 39, 43],
                    [6771, 39, 40], [6772, 31, 37], [6773, 50, 46], [6777, 52, 48], [6778, 32, 32], [6779, 39, 43],
                    [6780, 39, 40], [6781, 46, 42], [6782, 72, 58], [6783, 52, 48], [6784, 38, 38], [6785, 39, 37],
                    [6786, 39, 43], [6787, 36, 42], [6789, 45, 43], [6790, 76, 58], [6791, 61, 43], [6794, 74, 57],
                    [6795, 59, 51], [6798, 64, 47], [6803, 58, 51], [6804, 55, 49], [6805, 80, 61], [6806, 57, 51],
                    [6807, 72, 51], [6808, 79, 60], [6812, 81, 69], [6813, 71, 55], [6814, 62, 57], [6816, 65, 54],
                    [6818, 19, 21], [6819, 36, 45], [6820, 34, 37], [6821, 39, 45], [6822, 48, 47], [6823, 38, 41],
                    [6833, 56, 46], [6834, 78, 64], [6835, 85, 65], [6836, 76, 59], [6837, 76, 58], [6838, 90, 68],
                    [6841, 32, 24], [6845, 76, 58], [6846, 91, 78], [6847, 73, 56], [6848, 80, 61], [6849, 56, 53],
                    [6850, 76, 58], [6851, 74, 57], [6852, 81, 62], [6853, 83, 63], [6854, 71, 59], [6855, 77, 59],
                    [6856, 76, 58], [6857, 78, 64], [6858, 89, 68], [6859, 55, 44], [6860, 75, 57], [6861, 83, 68],
                    [6862, 81, 62], [6867, 12, 20], [6868, 12, 16], [6869, 14, 16], [6870, 15, 19], [6871, 15, 16],
                    [6872, 12, 18], [6873, 19, 19], [6874, 16, 18], [6875, 15, 18], [6876, 15, 18], [6877, 17, 19],
                    [6878, 15, 17], [6879, 15, 18], [6880, 19, 22], [6881, 15, 14], [6882, 15, 19], [6883, 15, 19],
                    [6884, 7, 8], [6885, 24, 15], [6886, 11, 14], [6887, 112, 38], [6888, 10, 11], [6889, 21, 14],
                    [6890, 8, 10], [6891, 18, 16], [6892, 9, 9], [6893, 21, 15], [6894, 7, 9], [6895, 26, 15],
                    [6896, 8, 11], [6897, 16, 15], [6898, 6, 8], [6899, 27, 14], [6900, 6, 7], [6901, 23, 16],
                    [6902, 10, 13], [6903, 33, 22], [6904, 11, 11], [6905, 40, 24], [6906, 8, 9], [6907, 24, 16],
                    [6908, 8, 8], [6909, 24, 18], [6910, 32, 28], [6911, 60, 41], [6912, 35, 23], [6913, 61, 38],
                    [6914, 12, 12], [6915, 41, 36], [6916, 10, 11], [6917, 29, 32], [6918, 28, 21], [6919, 29, 27],
                    [6920, 27, 22], [6921, 50, 36], [6922, 13, 12], [6923, 54, 38], [6924, 10, 11], [6925, 43, 39],
                    [6926, 60, 27], [6927, 67, 36], [6928, 20, 19], [6929, 55, 39], [6930, 21, 15], [6931, 41, 39],
                    [6932, 20, 14], [6933, 29, 26], [6934, 19, 15], [6935, 47, 46], [6936, 23, 20], [6937, 50, 39],
                    [6938, 19, 14], [6939, 51, 37], [6940, 12, 11], [6941, 29, 23], [6942, 30, 27], [6943, 59, 39],
                    [6944, 11, 11], [6945, 64, 49], [6946, 57, 32], [6947, 66, 46], [6948, 14, 12], [6949, 49, 37],
                    [6950, 16, 14], [6951, 53, 39], [6952, 55, 25], [6953, 62, 37], [6954, 28, 16], [6955, 49, 37],
                    [6956, 17, 15], [6957, 70, 58], [6958, 14, 11], [6959, 50, 39], [6960, 11, 11], [6961, 28, 25],
                    [6962, 12, 11], [6963, 11, 10], [6964, 26, 17], [6965, 9, 10], [6966, 25, 46], [6967, 20, 48],
                    [6968, 39, 75], [6969, 21, 42], [6970, 27, 50], [6971, 34, 27], [6972, 70, 33], [6973, 22, 12],
                    [6974, 6, 7], [6975, 9, 10], [6976, 21, 17], [6977, 7, 8], [6978, 50, 21], [6979, 7, 9],
                    [6980, 19, 15], [6981, 8, 9], [6982, 26, 16], [6983, 11, 13], [6984, 31, 23], [6985, 52, 29],
                    [6986, 105, 45], [6987, 9, 9], [6988, 25, 12], [6989, 13, 13], [6990, 28, 21], [6991, 7, 5],
                    [6992, 22, 13], [6993, 8, 8], [6994, 56, 25], [6995, 10, 10], [6996, 21, 15], [6997, 7, 6],
                    [6998, 15, 8], [6999, 7, 7], [7000, 20, 15], [7001, 7, 7], [7002, 18, 13], [7003, 8, 8],
                    [7004, 18, 14], [7005, 14, 14], [7006, 28, 22], [7007, 36, 28], [7008, 36, 28], [7009, 20, 14],
                    [7010, 19, 14], [7011, 10, 10], [7012, 22, 20], [7013, 29, 20], [7014, 12, 9], [7015, 11, 8],
                    [7019, 11, 9], [7020, 41, 39], [7021, 12, 11], [7022, 22, 21], [7023, 16, 16], [7024, 27, 26],
                    [7025, 14, 12], [7026, 27, 21], [7027, 18, 18], [7028, 41, 39], [7029, 39, 28], [7030, 55, 38],
                    [7031, 15, 13], [7032, 31, 21], [7033, 23, 22], [7034, 34, 29], [7035, 11, 12], [7036, 31, 30],
                    [7037, 27, 27], [7038, 34, 36], [7039, 23, 14], [7040, 29, 27], [7041, 14, 12], [7042, 55, 51],
                    [7043, 20, 27], [7044, 28, 26], [7045, 35, 23], [7046, 54, 38], [7047, 18, 15], [7048, 28, 22],
                    [7049, 52, 38], [7050, 18, 15], [7051, 57, 41], [7052, 15, 14], [7053, 52, 41], [7054, 18, 15],
                    [7055, 37, 26], [7056, 13, 14], [7057, 61, 41], [7058, 28, 18], [7059, 57, 41], [7060, 28, 19],
                    [7061, 52, 41], [7062, 17, 13], [7063, 46, 22], [7064, 28, 15], [7065, 43, 41], [7066, 12, 12],
                    [7067, 53, 40], [7068, 39, 30], [7069, 68, 52], [7070, 28, 20], [7071, 57, 39], [7072, 10, 11],
                    [7073, 29, 28], [7074, 26, 21], [7075, 56, 57], [7076, 28, 23], [7077, 37, 25], [7078, 11, 11],
                    [7079, 28, 22], [7080, 41, 36], [7081, 68, 52], [7082, 27, 23], [7083, 42, 39], [7084, 53, 21],
                    [7085, 61, 39], [7086, 12, 12], [7087, 43, 36], [7088, 27, 24], [7089, 54, 39], [7090, 19, 12],
                    [7091, 53, 39], [7092, 49, 22], [7093, 68, 56], [7094, 37, 28], [7095, 56, 39], [7096, 28, 23],
                    [7097, 39, 27], [7098, 27, 24], [7099, 52, 40], [7100, 15, 13], [7101, 20, 18], [7102, 13, 10],
                    [7103, 31, 17], [7104, 9, 7], [7105, 21, 13], [7106, 5, 7], [7107, 22, 12], [7108, 11, 9],
                    [7109, 27, 15], [7110, 8, 10], [7111, 25, 14], [7112, 5, 5], [7113, 30, 13], [7114, 25, 18],
                    [7115, 47, 26], [7116, 10, 11], [7117, 33, 22], [7118, 8, 14], [7119, 17, 15], [7120, 10, 12],
                    [7121, 36, 31], [7122, 9, 8], [7123, 26, 16], [7124, 7, 9], [7125, 16, 15], [7126, 7, 7],
                    [7127, 20, 16], [7128, 9, 8], [7129, 20, 14], [7130, 8, 8], [7131, 22, 14], [7132, 8, 8],
                    [7133, 31, 20], [7134, 16, 11], [7135, 25, 11], [7136, 15, 12], [7137, 30, 19], [7138, 9, 8],
                    [7139, 23, 18], [7140, 6, 7], [7141, 14, 12], [7142, 9, 10], [7143, 24, 14], [7144, 9, 9],
                    [7145, 18, 14], [7146, 10, 11], [7147, 25, 19], [7148, 8, 10], [7149, 33, 20], [7150, 5, 8],
                    [7151, 18, 14], [7152, 8, 8], [7153, 26, 20], [7154, 15, 17], [7155, 25, 23], [7156, 18, 19],
                    [7157, 9, 8], [7158, 39, 22], [7159, 18, 13], [7160, 46, 30], [7161, 9, 10], [7162, 25, 20],
                    [7163, 8, 7], [7164, 21, 13], [7165, 11, 10], [7166, 53, 29], [7167, 7, 7], [7168, 26, 17],
                    [7169, 5, 5], [7170, 35, 22], [7171, 6, 7], [7172, 37, 24], [7173, 13, 12], [7174, 64, 39],
                    [7175, 6, 5], [7176, 17, 13], [7177, 14, 9], [7178, 23, 13], [7179, 14, 13], [7180, 48, 29],
                    [7181, 9, 9], [7182, 37, 19], [7183, 17, 11], [7184, 84, 57], [7185, 16, 13], [7186, 47, 25],
                    [7187, 13, 10], [7188, 45, 24], [7189, 15, 14], [7190, 42, 25], [7191, 15, 12], [7192, 26, 16],
                    [7193, 13, 12], [7194, 20, 12], [7195, 13, 11], [7196, 38, 22], [7197, 7, 6], [7198, 21, 11],
                    [7199, 13, 10], [7200, 30, 17], [7201, 6, 5], [7202, 14, 9], [7203, 9, 7], [7204, 18, 16],
                    [7205, 17, 14], [7206, 52, 30], [7207, 13, 13], [7208, 38, 24], [7209, 16, 10], [7210, 47, 38],
                    [7211, 9, 10], [7212, 26, 16], [7213, 7, 7], [7214, 63, 33], [7215, 8, 6], [7216, 52, 27],
                    [7217, 11, 10], [7218, 28, 19], [7219, 15, 15], [7220, 32, 22], [7221, 13, 11], [7222, 30, 22],
                    [7223, 11, 10], [7224, 37, 19], [7225, 7, 8], [7226, 26, 16], [7227, 10, 10], [7228, 28, 21],
                    [7229, 12, 9], [7230, 56, 28], [7231, 10, 8], [7232, 28, 18], [7233, 8, 6], [7234, 25, 15],
                    [7235, 11, 9], [7236, 20, 16], [7237, 7, 7], [7238, 20, 14], [7239, 8, 8], [7240, 18, 13],
                    [7241, 18, 19], [7242, 26, 15], [7243, 5, 6], [7244, 17, 12], [7245, 5, 7], [7246, 25, 14],
                    [7247, 7, 8], [7248, 24, 17], [7249, 7, 8], [7250, 23, 15], [7251, 17, 19], [7252, 28, 22],
                    [7253, 13, 10], [7254, 55, 17], [7255, 45, 24], [7256, 22, 15], [7257, 93, 69], [7258, 93, 69],
                    [7259, 89, 56], [7260, 112, 86], [7261, 90, 74], [7262, 84, 91], [7263, 100, 84], [7264, 96, 104],
                    [7265, 93, 78], [7266, 116, 87], [7267, 90, 75], [7268, 116, 87], [7269, 116, 87], [7270, 87, 54],
                    [7271, 67, 63], [7272, 113, 84], [7273, 98, 105], [7274, 111, 82], [7275, 96, 82], [7276, 62, 54],
                    [7277, 91, 76], [7278, 84, 92], [7279, 100, 73], [7280, 117, 88], [7281, 89, 74], [7282, 82, 89],
                    [7283, 13, 21], [7284, 11, 10], [7285, 12, 11], [7286, 16, 23], [7287, 15, 26], [7288, 31, 32],
                    [7289, 31, 24], [7290, 52, 35], [7291, 39, 32], [7292, 37, 39], [7293, 26, 24], [7294, 24, 23],
                    [7295, 13, 12], [7296, 24, 20], [7297, 26, 22], [7298, 15, 17], [7299, 16, 19], [7300, 19, 29],
                    [7301, 13, 26], [7302, 44, 49], [7303, 78, 75], [7304, 34, 36], [7305, 45, 45], [7306, 32, 37],
                    [7307, 50, 54], [7308, 41, 45], [7309, 34, 38], [7310, 82, 69], [7311, 68, 66], [7312, 43, 45],
                    [7313, 104, 75], [7314, 88, 67], [7315, 84, 64], [7316, 89, 67], [7317, 91, 68], [7318, 89, 68],
                    [7319, 108, 79], [7320, 87, 66], [7321, 113, 84], [7322, 89, 66], [7323, 107, 80], [7324, 104, 75],
                    [7325, 91, 68], [7326, 90, 67], [7327, 108, 81], [7328, 30, 35], [7329, 56, 52], [7330, 36, 36],
                    [7331, 37, 36], [7332, 29, 33], [7333, 58, 68], [7337, 14, 14], [7342, 13, 8], [7343, 12, 8],
                    [7344, 12, 9], [7348, 12, 8], [7352, 11, 9], [7354, 13, 13], [7356, 10, 8], [7357, 21, 10],
                    [7358, 15, 11], [7359, 25, 12], [7360, 13, 10], [7362, 11, 9], [7363, 11, 11], [7364, 11, 11],
                    [7367, 12, 7], [7370, 11, 10], [7371, 16, 12], [7372, 17, 9], [7373, 14, 10], [7374, 11, 8],
                    [7375, 11, 7], [7376, 9, 8], [7377, 11, 8], [7378, 20, 18], [7379, 32, 24], [7396, 35, 34],
                    [7397, 57, 47], [7398, 35, 36], [7399, 28, 32], [7400, 50, 47], [7401, 28, 32], [7402, 61, 71],
                    [7403, 23, 27], [7404, 68, 52], [7405, 34, 35], [7406, 52, 58], [7407, 36, 35], [7408, 50, 57],
                    [7409, 19, 23], [7410, 22, 27], [7411, 22, 27], [7412, 39, 41], [7413, 20, 25], [7414, 19, 23],
                    [7415, 19, 27], [7416, 24, 29], [7417, 21, 25], [7418, 24, 25], [7419, 45, 46], [7420, 21, 26],
                    [7421, 33, 38], [7422, 20, 24], [7423, 27, 28], [7424, 48, 43], [7425, 31, 27], [7426, 50, 45],
                    [7427, 40, 38], [7428, 46, 44], [7429, 25, 28], [7430, 41, 32], [7431, 29, 30], [7432, 64, 49],
                    [7433, 43, 41], [7434, 70, 46], [7435, 51, 46], [7436, 58, 53], [7437, 24, 30], [7438, 45, 43],
                    [7439, 36, 34], [7440, 59, 52], [7441, 34, 32], [7442, 51, 43], [7443, 60, 53], [7444, 64, 52],
                    [7445, 58, 50], [7446, 81, 61], [7447, 33, 33], [7448, 59, 56], [7449, 23, 22], [7450, 23, 24],
                    [7451, 15, 16], [7452, 26, 18], [7453, 60, 32], [7454, 19, 19], [7455, 27, 25], [7456, 82, 60],
                    [7457, 61, 57], [7458, 42, 40], [7459, 61, 57], [7460, 61, 64], [7461, 42, 39], [7462, 49, 45],
                    [7463, 55, 53], [7464, 68, 51], [7465, 61, 45], [7466, 55, 41], [7467, 61, 57], [7468, 48, 45],
                    [7469, 64, 49], [7470, 75, 55], [7471, 91, 67], [7472, 33, 70], [7473, 42, 45], [7474, 61, 57],
                    [7475, 61, 57], [7476, 51, 48], [7477, 45, 43], [7478, 48, 46], [7479, 48, 45], [7480, 61, 50],
                    [7481, 42, 46], [7482, 55, 41], [7483, 61, 57], [7484, 47, 51], [7485, 94, 70], [7486, 73, 54],
                    [7487, 51, 48], [7488, 61, 45], [7489, 72, 47], [7490, 49, 45], [7491, 61, 46], [7492, 73, 54],
                    [7493, 54, 51], [7494, 54, 51], [7495, 61, 57], [7496, 94, 70], [7497, 61, 45], [7498, 42, 46],
                    [7499, 48, 40], [7500, 54, 51], [7501, 68, 51], [7502, 61, 45], [7503, 67, 51], [7504, 64, 47],
                    [7505, 54, 51], [7506, 68, 51], [7507, 52, 48], [7508, 61, 46], [7509, 61, 57], [7510, 61, 57],
                    [7511, 68, 51], [7512, 61, 57], [7513, 61, 45], [7514, 106, 80], [7515, 67, 50], [7516, 61, 57],
                    [7517, 94, 70], [7518, 68, 51], [7519, 54, 51], [7520, 55, 52], [7521, 42, 45], [7522, 75, 55],
                    [7523, 55, 53], [7524, 84, 80], [7525, 61, 57], [7526, 64, 47], [7527, 42, 45], [7528, 82, 60],
                    [7529, 94, 88], [7530, 75, 55], [7531, 47, 51], [7532, 61, 57], [7533, 82, 60], [7534, 94, 88],
                    [7535, 55, 52], [7536, 75, 55], [7537, 70, 52], [7538, 82, 60], [7539, 55, 53], [7540, 82, 60],
                    [7541, 67, 50], [7542, 82, 60], [7543, 67, 50], [7544, 70, 52], [7545, 51, 48], [7546, 61, 45],
                    [7547, 61, 45], [7548, 54, 51], [7549, 61, 57], [7550, 48, 45], [7551, 49, 45], [7552, 49, 45],
                    [7553, 55, 52], [7554, 88, 76], [7555, 82, 64], [7556, 61, 57], [7557, 94, 70], [7558, 42, 40],
                    [7559, 61, 45], [7560, 49, 45], [7561, 94, 70], [7562, 94, 70], [7563, 75, 55], [7564, 67, 50],
                    [7565, 55, 53], [7566, 54, 51], [7567, 61, 57], [7568, 55, 52], [7569, 55, 52], [7570, 54, 51],
                    [7571, 54, 51], [7572, 94, 70], [7573, 61, 51], [7574, 54, 51], [7575, 68, 51], [7576, 68, 51],
                    [7577, 75, 55], [7578, 55, 53], [7579, 75, 55], [7580, 75, 55], [7581, 67, 51], [7582, 67, 57],
                    [7583, 61, 57], [7584, 51, 48], [7585, 52, 49], [7586, 94, 70], [7587, 54, 51], [7588, 55, 53],
                    [7589, 94, 70], [7590, 61, 57], [7591, 61, 46], [7592, 75, 55], [7593, 70, 52], [7594, 54, 51],
                    [7595, 55, 53], [7596, 48, 45], [7597, 55, 53], [7598, 68, 51], [7599, 61, 57], [7600, 61, 57],
                    [7601, 49, 45], [7602, 45, 43], [7603, 61, 57], [7604, 61, 57], [7605, 61, 57], [7606, 61, 51],
                    [7607, 75, 55], [7608, 49, 45], [7609, 61, 57], [7610, 48, 47], [7611, 43, 57], [7612, 61, 55],
                    [7613, 55, 53], [7614, 61, 51], [7615, 75, 55], [7616, 67, 50], [7617, 61, 47], [7618, 67, 50],
                    [7619, 61, 57], [7620, 54, 51], [7621, 61, 57], [7622, 75, 55], [7623, 54, 51], [7624, 82, 60],
                    [7625, 48, 46], [7626, 67, 50], [7627, 52, 48], [7628, 75, 55], [7629, 48, 46], [7630, 51, 48],
                    [7631, 57, 54], [7632, 67, 50], [7633, 48, 46], [7634, 16, 26], [7635, 16, 22], [7636, 19, 25],
                    [7637, 32, 31], [7638, 25, 21], [7639, 12, 14], [7640, 11, 12], [7641, 15, 17], [7642, 32, 37],
                    [7643, 18, 18], [7644, 31, 40], [7645, 18, 22], [7646, 28, 27], [7647, 36, 25], [7648, 12, 12],
                    [7649, 12, 13], [7650, 18, 19], [7651, 14, 13], [7652, 15, 13], [7653, 45, 33], [7654, 13, 14],
                    [7655, 16, 15], [7656, 14, 13], [7657, 27, 27], [7658, 22, 28], [7659, 13, 18], [7661, 10, 10],
                    [7662, 15, 13], [7663, 17, 19], [7664, 23, 32], [7665, 34, 44], [7666, 14, 17], [7667, 15, 17],
                    [7668, 16, 13], [7669, 11, 8], [7672, 10, 9], [7673, 8, 7], [7674, 20, 17], [7676, 6, 7],
                    [7677, 6, 6], [7678, 10, 8], [7679, 13, 10], [7680, 20, 21], [7681, 5, 3], [7682, 16, 13],
                    [7683, 5, 3], [7684, 15, 14], [7685, 12, 11], [7686, 21, 19], [7687, 5, 3], [7688, 15, 14],
                    [7690, 7, 8], [7691, 20, 24], [7692, 11, 10], [7693, 9, 9], [7694, 10, 9], [7695, 28, 20],
                    [7696, 5, 3], [7697, 16, 12], [7698, 10, 8], [7699, 13, 15], [7700, 11, 10], [7701, 9, 8],
                    [7702, 17, 13], [7703, 12, 13], [7705, 21, 13], [7706, 11, 10], [7707, 10, 10], [7708, 9, 7],
                    [7709, 12, 14], [7710, 6, 6], [7711, 16, 12], [7713, 20, 12], [7714, 10, 9], [7715, 33, 38],
                    [7716, 34, 35], [7717, 57, 66], [7718, 36, 36], [7719, 28, 33], [7720, 62, 73], [7721, 37, 36],
                    [7722, 44, 37], [7723, 27, 31], [7724, 54, 62], [7725, 19, 24], [7726, 31, 36], [7727, 39, 39],
                    [7728, 54, 51], [7729, 38, 37], [7730, 26, 30], [7731, 56, 64], [7732, 31, 35], [7733, 51, 58],
                    [7734, 54, 43], [7735, 73, 68], [7736, 28, 32], [7737, 48, 45], [7738, 27, 31], [7739, 38, 46],
                    [7740, 28, 32], [7741, 48, 54], [7742, 51, 52], [7743, 36, 35], [7744, 55, 63], [7745, 57, 45],
                    [7746, 37, 37], [7747, 45, 54], [7748, 52, 50], [7749, 38, 39], [7750, 54, 62], [7751, 54, 44],
                    [7752, 71, 67], [7753, 50, 47], [7754, 38, 39], [7755, 29, 32], [7756, 71, 48], [7757, 54, 47],
                    [7758, 81, 63], [7759, 29, 33], [7760, 51, 50], [7761, 55, 51], [7762, 32, 39], [7763, 16, 22],
                    [7764, 15, 18], [7765, 17, 24], [7766, 10, 19], [7767, 26, 31], [7768, 11, 21], [7769, 37, 35],
                    [7770, 51, 38], [7771, 15, 17], [7772, 14, 18], [7773, 23, 25], [7774, 13, 22], [7775, 38, 38],
                    [7776, 15, 31], [7777, 22, 35], [7778, 9, 12], [7779, 15, 20], [7780, 19, 19], [7781, 25, 29],
                    [7782, 30, 26], [7783, 31, 25], [7784, 13, 29], [7785, 23, 39], [7786, 14, 17], [7787, 24, 29],
                    [7788, 19, 22], [7789, 22, 27], [7790, 20, 27], [7791, 40, 38], [7792, 18, 22], [7793, 34, 34],
                    [7795, 171, 98], [7796, 296, 75], [7797, 320, 85], [7798, 164, 40], [7799, 175, 76],
                    [7800, 100, 44], [7801, 266, 78], [7802, 185, 40], [7803, 492, 157], [7804, 228, 91],
                    [7805, 158, 55], [7806, 160, 89], [7807, 106, 83], [7808, 180, 140], [7809, 120, 77],
                    [7810, 292, 119], [7811, 732, 150], [7812, 45, 40], [7813, 90, 40], [7815, 88, 40],
                    [7816, 406, 140], [7817, 73, 50], [7818, 86, 81], [7819, 60, 72], [7820, 96, 52], [7821, 266, 71],
                    [7822, 142, 73], [7823, 120, 51], [7824, 208, 73], [7825, 213, 75], [7826, 120, 91],
                    [7827, 173, 66], [7828, 205, 118], [7829, 103, 54], [7830, 147, 60], [7831, 165, 43],
                    [7832, 187, 94], [7833, 63, 40], [7834, 175, 90], [7835, 128, 40], [7836, 177, 86], [7837, 48, 40],
                    [7838, 183, 80], [7839, 122, 98], [7840, 277, 110], [7841, 175, 72], [7842, 46, 41], [7843, 51, 40],
                    [7844, 196, 65], [7845, 53, 51], [7846, 274, 140], [7847, 489, 140], [7848, 356, 133],
                    [7849, 356, 200], [7850, 103, 93], [7851, 190, 90], [7852, 101, 48], [7853, 92, 62], [7854, 40, 40],
                    [7855, 40, 40], [7856, 247, 140], [7857, 67, 40], [7858, 46, 40], [7859, 186, 74], [7860, 124, 79],
                    [7861, 51, 40], [7862, 402, 69], [7863, 554, 103], [7864, 45, 41], [7865, 51, 44], [7866, 160, 76],
                    [7867, 55, 40], [7868, 53, 40], [7869, 160, 79], [7870, 50, 40], [7871, 64, 42], [7872, 180, 169],
                    [7873, 278, 119], [7874, 48, 40], [7875, 302, 125], [7876, 180, 140], [7877, 120, 74],
                    [7878, 236, 56], [7879, 190, 103], [7880, 97, 72], [7881, 120, 66], [7882, 51, 40], [7883, 120, 93],
                    [7884, 67, 64], [7885, 70, 50], [7886, 80, 41], [7887, 55, 40], [7888, 140, 51], [7889, 322, 120],
                    [7890, 170, 111], [7891, 75, 40], [7892, 64, 40], [7893, 64, 40], [7894, 140, 97], [7895, 80, 43],
                    [7896, 329, 90], [7897, 270, 62], [7898, 120, 59], [7899, 566, 113], [7900, 304, 93],
                    [7901, 120, 60], [7902, 161, 88], [7903, 272, 110], [7904, 120, 83], [7905, 140, 71],
                    [7906, 146, 111], [7907, 172, 62], [7908, 170, 60], [7909, 120, 50], [7910, 124, 58],
                    [7911, 180, 140], [7912, 449, 195], [7913, 247, 61], [7914, 120, 68], [7915, 120, 90],
                    [7916, 150, 57], [7917, 120, 52], [7918, 71, 40], [7919, 120, 40], [7920, 91, 51], [7921, 60, 40],
                    [7922, 120, 42], [7923, 133, 40], [7924, 47, 40], [7925, 62, 40], [7926, 86, 51], [7927, 140, 57],
                    [7928, 120, 53], [7929, 232, 96], [7930, 340, 57], [7931, 59, 40], [7932, 89, 40], [7933, 120, 75],
                    [7934, 176, 141], [7935, 246, 90], [7936, 179, 60], [7937, 75, 52], [7938, 120, 40],
                    [7939, 395, 140], [7940, 167, 86], [7941, 341, 133], [7942, 176, 111], [7943, 61, 40],
                    [7944, 120, 43], [7945, 270, 53], [7946, 124, 91], [7947, 101, 64], [7948, 120, 40],
                    [7949, 199, 111], [7950, 120, 57], [7951, 169, 73], [7952, 125, 90], [7953, 69, 40],
                    [7954, 120, 40], [7955, 200, 60], [7956, 425, 149], [7957, 120, 50], [7958, 216, 53],
                    [7959, 188, 65], [7960, 120, 45], [7961, 206, 207], [7962, 386, 112], [7963, 120, 40],
                    [7964, 200, 112], [7965, 179, 70], [7966, 142, 93], [7967, 182, 40], [7968, 495, 159],
                    [7969, 420, 220], [7970, 203, 83], [7971, 45, 40], [7972, 77, 47], [7974, 120, 40],
                    [7975, 378, 120], [7976, 400, 64], [7977, 278, 164], [7978, 172, 79], [7979, 128, 74],
                    [7980, 331, 80], [7981, 169, 50], [7982, 83, 44], [7983, 120, 40], [7984, 180, 140], [7985, 91, 59],
                    [7986, 97, 40], [7987, 106, 51], [7988, 120, 49], [7989, 900, 98], [7990, 83, 40], [7992, 120, 75],
                    [7993, 231, 103], [7994, 120, 52], [7995, 543, 201], [7996, 136, 59], [7997, 315, 145],
                    [7998, 120, 40], [7999, 138, 100], [8000, 120, 40], [8001, 248, 99], [8002, 167, 93],
                    [8003, 120, 40], [8004, 189, 218], [8005, 20, 25], [8006, 15, 19], [8007, 26, 31], [8008, 21, 26],
                    [8009, 16, 17], [8010, 14, 16], [8011, 16, 18], [8012, 12, 15], [8013, 7, 7], [8014, 9, 9],
                    [8015, 10, 9], [8016, 6, 5], [8017, 12, 13], [8018, 7, 7], [8019, 16, 16], [8020, 13, 14],
                    [8021, 6, 6], [8022, 24, 30], [8023, 16, 17], [8024, 21, 19], [8025, 17, 21], [8026, 18, 19],
                    [8027, 13, 11], [8028, 14, 14], [8029, 24, 22], [8030, 17, 16], [8031, 12, 11], [8032, 18, 23],
                    [8033, 24, 26], [8034, 24, 31], [8035, 20, 19], [8036, 17, 21], [8037, 21, 25], [8038, 36, 35],
                    [8039, 33, 61], [8040, 21, 61], [8041, 7, 14], [8042, 7, 10], [8043, 11, 16], [8044, 11, 15],
                    [8045, 5, 3], [8046, 5, 3], [8047, 5, 5], [8048, 15, 20], [8049, 12, 15], [8050, 9, 11],
                    [8051, 19, 23], [8052, 35, 44], [8053, 23, 35], [8054, 20, 30], [8055, 30, 46], [8056, 41, 48],
                    [8057, 22, 32], [8058, 19, 26], [8059, 24, 29], [8060, 27, 33], [8061, 52, 62], [8062, 54, 72],
                    [8063, 10, 11], [8064, 17, 20], [8065, 14, 13], [8066, 117, 46], [8067, 39, 30], [8068, 11, 11],
                    [8069, 13, 27], [8070, 16, 17], [8071, 42, 20], [8072, 34, 22], [8073, 52, 28], [8074, 14, 12],
                    [8075, 29, 16], [8076, 58, 37], [8079, 53, 43], [8080, 96, 44], [8081, 84, 46], [8082, 60, 37],
                    [8083, 89, 40], [8084, 85, 43], [8085, 39, 29], [8086, 16, 44], [8087, 15, 31], [8088, 18, 37],
                    [8089, 21, 46], [8090, 21, 32], [8091, 23, 61], [8092, 20, 47], [8093, 23, 61], [8094, 14, 61],
                    [8095, 21, 27], [8096, 24, 37], [8097, 20, 32], [8098, 9, 25], [8099, 36, 36], [8100, 35, 35],
                    [8101, 37, 36], [8102, 28, 31], [8103, 37, 36], [8104, 35, 35], [8105, 56, 45], [8106, 39, 39],
                    [8107, 28, 33], [8108, 48, 45], [8109, 38, 37], [8110, 28, 32], [8111, 45, 42], [8112, 35, 35],
                    [8113, 55, 45], [8114, 28, 32], [8115, 62, 74], [8116, 39, 38], [8117, 49, 67], [8118, 29, 34],
                    [8119, 37, 37], [8120, 46, 44], [8121, 29, 32], [8122, 36, 36], [8123, 56, 46], [8124, 37, 38],
                    [8125, 57, 46], [8126, 31, 32], [8127, 38, 39], [8128, 78, 74], [8129, 36, 36], [8130, 56, 46],
                    [8131, 27, 31], [8132, 48, 45], [8133, 29, 33], [8134, 49, 47], [8135, 57, 46], [8136, 23, 27],
                    [8137, 36, 37], [8138, 39, 39], [8139, 57, 64], [8140, 42, 50], [8141, 35, 35], [8142, 36, 36],
                    [8143, 61, 71], [8144, 27, 32], [8145, 28, 31], [8146, 46, 52], [8147, 35, 35], [8148, 38, 37],
                    [8149, 29, 34], [8150, 65, 78], [8151, 27, 31], [8152, 55, 66], [8153, 36, 37], [8154, 35, 35],
                    [8155, 50, 41], [8156, 70, 86], [8157, 39, 38], [8158, 36, 36], [8159, 32, 33], [8160, 36, 36],
                    [8161, 57, 46], [8162, 59, 47], [8163, 49, 41], [8164, 35, 35], [8165, 38, 38], [8166, 73, 55],
                    [8167, 57, 46], [8168, 36, 37], [8169, 48, 42], [8170, 37, 37], [8171, 36, 37], [8172, 73, 54],
                    [8173, 36, 36], [8174, 37, 36], [8175, 29, 32], [8176, 28, 32], [8177, 30, 35], [8178, 38, 39],
                    [8179, 46, 43], [8180, 36, 35], [8181, 71, 54], [8182, 56, 46], [8183, 39, 39], [8184, 35, 35],
                    [8185, 35, 36], [8186, 38, 38], [8187, 30, 34], [8188, 22, 26], [8189, 47, 44], [8190, 28, 31],
                    [8191, 55, 54], [8192, 39, 38], [8193, 71, 52], [8194, 35, 34], [8195, 37, 36], [8196, 30, 34],
                    [8197, 39, 39], [8198, 30, 34], [8199, 57, 65], [8200, 28, 33], [8201, 74, 56], [8202, 47, 46],
                    [8203, 66, 45], [8204, 55, 45], [8205, 26, 29], [8206, 53, 51], [8207, 36, 36], [8208, 28, 32],
                    [8209, 74, 56], [8210, 38, 38], [8211, 60, 71], [8212, 28, 32], [8213, 38, 37], [8214, 58, 67],
                    [8215, 37, 36], [8216, 37, 36], [8217, 38, 38], [8218, 18, 25], [8219, 52, 50], [8220, 27, 31],
                    [8221, 47, 44], [8222, 24, 28], [8223, 28, 32], [8224, 45, 50], [8225, 35, 41], [8226, 60, 70],
                    [8227, 36, 36], [8228, 26, 29], [8229, 35, 34], [8230, 38, 37], [8231, 23, 27], [8232, 56, 54],
                    [8233, 36, 36], [8234, 26, 29], [8235, 57, 66], [8236, 28, 32], [8237, 54, 51], [8238, 35, 35],
                    [8239, 83, 63], [8240, 37, 36], [8241, 29, 34], [8242, 50, 47], [8245, 38, 37], [8246, 39, 39],
                    [8247, 56, 46], [8248, 24, 28], [8249, 48, 45], [8250, 34, 35], [8251, 37, 36], [8252, 46, 43],
                    [8253, 54, 44], [8254, 35, 41], [8255, 35, 35], [8256, 30, 33], [8257, 58, 67], [8258, 36, 36],
                    [8259, 36, 35], [8260, 38, 39], [8261, 56, 64], [8262, 51, 52], [8263, 66, 50], [8264, 32, 37],
                    [8265, 51, 73], [8267, 55, 44], [8268, 37, 37], [8269, 36, 36], [8270, 22, 27], [8271, 29, 34],
                    [8272, 47, 44], [8273, 36, 36], [8274, 36, 35], [8275, 31, 35], [8276, 35, 35], [8277, 34, 26],
                    [8278, 56, 46], [8279, 36, 36], [8280, 39, 39], [8281, 36, 36], [8282, 39, 39], [8283, 38, 37],
                    [8284, 37, 36], [8285, 39, 39], [8286, 39, 39], [8287, 38, 38], [8288, 29, 34], [8289, 48, 45],
                    [8290, 39, 39], [8291, 39, 39], [8292, 38, 37], [8293, 35, 35], [8294, 36, 35], [8295, 56, 46],
                    [8296, 55, 38], [8297, 37, 37], [8298, 28, 50], [8299, 23, 27], [8300, 73, 56], [8301, 38, 38],
                    [8302, 36, 35], [8303, 56, 46], [8304, 36, 35], [8305, 54, 44], [8306, 30, 34], [8307, 22, 26],
                    [8308, 36, 35], [8309, 17, 22], [8310, 47, 45], [8311, 15, 17], [8312, 14, 15], [8313, 14, 15],
                    [8314, 15, 17], [8315, 14, 15], [8316, 14, 14], [8317, 42, 42], [8318, 63, 48], [8319, 22, 23],
                    [8320, 57, 46], [8321, 39, 30], [8322, 38, 38], [8323, 30, 34], [8324, 67, 50], [8325, 61, 49],
                    [8326, 56, 45], [8327, 54, 44], [8328, 59, 47], [8329, 36, 36], [8330, 58, 47], [8331, 54, 44],
                    [8332, 56, 46], [8336, 21, 18], [8337, 13, 16], [8338, 13, 13], [8339, 38, 39], [8340, 15, 18],
                    [8341, 27, 30], [8342, 16, 16], [8343, 18, 19], [8344, 14, 13], [8345, 20, 16], [8346, 19, 24],
                    [8347, 16, 18], [8348, 22, 27], [8349, 16, 18], [8350, 18, 18], [8351, 14, 11], [8352, 20, 27],
                    [8353, 14, 17], [8354, 23, 28], [8355, 15, 16], [8356, 24, 29], [8357, 15, 15], [8358, 23, 18],
                    [8359, 33, 39], [8360, 32, 37], [8361, 15, 14], [8362, 18, 24], [8363, 23, 30], [8364, 28, 24],
                    [8365, 13, 14], [8366, 23, 20], [8367, 16, 17], [8368, 18, 24], [8369, 19, 24], [8370, 19, 20],
                    [8371, 20, 19], [8372, 23, 20], [8373, 23, 28], [8374, 22, 28], [8375, 15, 14], [8376, 27, 27],
                    [8377, 21, 16], [8378, 21, 18], [8379, 25, 23], [8380, 27, 28], [8381, 26, 31], [8382, 19, 22],
                    [8383, 24, 28], [8384, 22, 31], [8385, 20, 25], [8386, 14, 17], [8387, 23, 24], [8388, 18, 18],
                    [8389, 17, 19], [8390, 14, 16], [8391, 17, 20], [8392, 19, 22], [8393, 34, 45], [8394, 24, 20],
                    [8395, 20, 21], [8396, 51, 46], [8397, 67, 50], [8398, 47, 36], [8399, 62, 40], [8400, 53, 49],
                    [8401, 63, 38], [8402, 49, 39], [8403, 55, 37], [8404, 45, 41], [8405, 56, 37], [8406, 48, 40],
                    [8407, 51, 48], [8408, 44, 48], [8409, 36, 31], [8410, 52, 41], [8411, 80, 56], [8412, 48, 45],
                    [8413, 58, 45], [8414, 73, 38], [8415, 79, 53], [8416, 34, 33], [8417, 61, 40], [8418, 27, 29],
                    [8419, 57, 42], [8420, 56, 43], [8421, 65, 49], [8422, 35, 36], [8423, 54, 51], [8424, 63, 64],
                    [8425, 41, 51], [8426, 42, 37], [8427, 45, 37], [8428, 49, 40], [8429, 35, 32], [8430, 54, 51],
                    [8431, 63, 48], [8432, 55, 51], [8433, 53, 49], [8434, 63, 41], [8435, 90, 47], [8436, 67, 50],
                    [8438, 38, 32], [8439, 42, 39], [8440, 74, 46], [8441, 65, 43], [8442, 43, 41], [8443, 56, 49],
                    [8444, 54, 51], [8445, 30, 27], [8446, 39, 33], [8447, 55, 45], [8448, 45, 40], [8449, 76, 35],
                    [8450, 65, 45], [8451, 21, 29], [8452, 28, 39], [8453, 20, 26], [8454, 26, 32], [8455, 24, 29],
                    [8456, 23, 29], [8457, 54, 51], [8458, 43, 34], [8459, 57, 40], [8460, 47, 42], [8461, 67, 40],
                    [8462, 62, 42], [8463, 60, 50], [8464, 67, 49], [8465, 36, 28], [8466, 37, 43], [8467, 42, 37],
                    [8468, 51, 44], [8469, 46, 39], [8470, 67, 51], [8471, 37, 42], [8472, 69, 37], [8473, 55, 49],
                    [8474, 44, 41], [8475, 61, 46], [8476, 62, 47], [8477, 62, 47], [8478, 32, 33], [8479, 45, 41],
                    [8480, 66, 51], [8481, 51, 41], [8482, 49, 40], [8483, 48, 40], [8484, 57, 43], [8485, 61, 50],
                    [8486, 35, 29], [8487, 54, 40], [8488, 43, 37], [8489, 35, 53], [8490, 56, 44], [8491, 48, 46],
                    [8492, 50, 38], [8493, 60, 39], [8494, 35, 29], [8495, 65, 66], [8496, 31, 40], [8497, 52, 52],
                    [8498, 36, 40], [8499, 46, 39], [8500, 63, 42], [8501, 54, 62], [8502, 66, 41], [8503, 63, 48],
                    [8504, 46, 43], [8505, 64, 49], [8506, 67, 50], [8507, 66, 51], [8508, 38, 38], [8509, 44, 40],
                    [8510, 67, 48], [8511, 58, 45], [8512, 54, 51], [8513, 52, 48], [8514, 58, 57], [8515, 47, 44],
                    [8516, 111, 64], [8517, 60, 26], [8518, 69, 63], [8519, 40, 36], [8520, 48, 39], [8521, 44, 39],
                    [8522, 46, 42], [8523, 45, 40], [8524, 43, 38], [8525, 56, 40], [8526, 61, 47], [8527, 57, 56],
                    [8528, 62, 51], [8529, 71, 51], [8530, 37, 34], [8531, 67, 61], [8532, 57, 55], [8533, 66, 61],
                    [8534, 48, 47], [8535, 65, 64], [8536, 20, 37], [8537, 46, 31], [8538, 45, 31], [8539, 41, 35],
                    [8540, 33, 47], [8541, 41, 56], [8542, 35, 50], [8543, 22, 47], [8544, 29, 60], [8546, 29, 47],
                    [8547, 34, 60], [8548, 15, 19], [8549, 24, 31], [8550, 20, 29], [8551, 35, 29], [8552, 31, 38],
                    [8553, 44, 58], [8554, 22, 20], [8555, 37, 35], [8556, 41, 57], [8557, 56, 55], [8558, 29, 32],
                    [8559, 37, 35], [8560, 30, 35], [8561, 24, 29], [8562, 35, 35], [8563, 43, 46], [8564, 79, 64],
                    [8565, 10, 12], [8566, 16, 14], [8567, 22, 21], [8568, 16, 16], [8569, 18, 15], [8570, 10, 10],
                    [8571, 14, 11], [8572, 14, 11], [8573, 12, 11], [8574, 15, 13], [8575, 10, 10], [8576, 21, 16],
                    [8577, 18, 16], [8578, 23, 22], [8579, 18, 20], [8580, 17, 17], [8581, 12, 10], [8582, 17, 17],
                    [8583, 19, 18], [8584, 14, 14], [8585, 11, 11], [8586, 32, 19], [8587, 10, 9], [8588, 34, 16],
                    [8589, 14, 13], [8590, 22, 15], [8591, 19, 15], [8592, 29, 28], [8593, 25, 23], [8594, 38, 25],
                    [8595, 14, 14], [8596, 17, 15], [8597, 20, 21], [8598, 27, 21], [8599, 15, 12], [8600, 22, 15],
                    [8601, 28, 20], [8602, 27, 19], [8603, 25, 15], [8604, 41, 21], [8605, 23, 23], [8606, 40, 23],
                    [8607, 18, 24], [8608, 29, 26], [8609, 27, 19], [8610, 23, 24], [8611, 24, 18], [8612, 35, 22],
                    [8613, 15, 11], [8614, 28, 19], [8615, 12, 11], [8616, 29, 21], [8617, 30, 15], [8618, 19, 13],
                    [8619, 33, 25], [8622, 52, 27], [8623, 52, 28], [8624, 18, 20], [8625, 43, 26], [8626, 23, 17],
                    [8627, 35, 20], [8628, 31, 24], [8629, 30, 25], [8630, 21, 16], [8631, 28, 20], [8632, 22, 16],
                    [8633, 24, 19], [8634, 15, 14], [8635, 25, 14], [8636, 11, 9], [8637, 22, 14], [8638, 15, 12],
                    [8639, 19, 13], [8640, 23, 18], [8641, 41, 20], [8642, 26, 21], [8643, 27, 27], [8644, 43, 24],
                    [8645, 22, 19], [8646, 26, 20], [8647, 20, 15], [8648, 19, 14], [8649, 23, 21], [8650, 31, 17],
                    [8651, 32, 21], [8652, 41, 29], [8653, 28, 25], [8654, 57, 27], [8655, 22, 21], [8656, 22, 19],
                    [8657, 9, 12], [8658, 21, 18], [8659, 31, 23], [8660, 14, 12], [8661, 17, 13], [8662, 21, 13],
                    [8663, 22, 14], [8664, 27, 19], [8665, 40, 29], [8666, 18, 17], [8667, 20, 19], [8668, 18, 23],
                    [8669, 35, 33], [8670, 18, 20], [8671, 27, 28], [8672, 15, 18], [8673, 26, 25], [8674, 25, 18],
                    [8675, 50, 22], [8676, 38, 26], [8677, 43, 27], [8678, 36, 20], [8679, 40, 19], [8680, 24, 19],
                    [8681, 34, 22], [8682, 37, 21], [8683, 32, 13], [8684, 27, 21], [8685, 21, 18], [8686, 30, 18],
                    [8687, 24, 17], [8688, 37, 24], [8689, 31, 22], [8690, 39, 22], [8691, 23, 24], [8692, 41, 26],
                    [8693, 34, 13], [8694, 37, 22], [8695, 14, 15], [8696, 21, 19], [8697, 19, 15], [8698, 35, 17],
                    [8699, 29, 16], [8700, 32, 16], [8701, 25, 15], [8702, 27, 18], [8703, 24, 21], [8704, 31, 25],
                    [8705, 28, 18], [8706, 35, 19], [8707, 20, 21], [8708, 29, 23], [8709, 36, 20], [8710, 31, 20],
                    [8711, 11, 10], [8712, 21, 20], [8713, 31, 21], [8714, 6, 5], [8715, 7, 6], [8716, 7, 7],
                    [8717, 12, 11], [8718, 8, 8], [8719, 21, 23], [8720, 26, 29], [8721, 27, 29], [8722, 25, 23],
                    [8723, 27, 25], [8724, 25, 25], [8725, 22, 18], [8726, 25, 21], [8727, 22, 22], [8728, 19, 20],
                    [8729, 24, 20], [8730, 19, 16], [8731, 20, 18], [8732, 25, 19], [8733, 27, 20], [8734, 22, 18],
                    [8735, 20, 16], [8736, 20, 19], [8737, 20, 17], [8738, 21, 18], [8739, 21, 19], [8740, 21, 18],
                    [8741, 25, 19], [8742, 23, 20], [8743, 23, 19], [8744, 24, 20], [8745, 26, 18], [8746, 28, 22],
                    [8747, 28, 22], [8748, 29, 23], [8749, 23, 19], [8750, 22, 24], [8751, 23, 25], [8752, 18, 16],
                    [8753, 19, 17], [8754, 19, 20], [8755, 20, 18], [8756, 30, 22], [8757, 19, 17], [8758, 19, 18],
                    [8759, 22, 21], [8760, 30, 32], [8761, 23, 19], [8762, 29, 20], [8763, 17, 16], [8764, 31, 24],
                    [8765, 26, 18], [8766, 26, 20], [8767, 31, 24], [8768, 30, 23], [8769, 20, 19], [8770, 31, 24],
                    [8771, 29, 26], [8772, 31, 25], [8773, 18, 16], [8774, 19, 18], [8775, 20, 17], [8776, 19, 18],
                    [8777, 23, 19], [8778, 32, 25], [8779, 9, 13], [8780, 13, 11], [8781, 15, 10], [8782, 16, 11],
                    [8783, 10, 8], [8784, 13, 10], [8785, 7, 7], [8786, 9, 10], [8787, 11, 11], [8788, 13, 10],
                    [8790, 8, 7], [8791, 6, 6], [8792, 12, 11], [8793, 8, 7], [8794, 8, 7], [8795, 9, 7],
                    [8796, 13, 10], [8797, 15, 10], [8798, 9, 8], [8799, 11, 9], [8800, 10, 8], [8801, 11, 10],
                    [8802, 7, 7], [8803, 8, 8], [8804, 7, 9], [8805, 9, 9], [8806, 9, 10], [8807, 14, 13], [8808, 8, 7],
                    [8809, 6, 7], [8810, 11, 11], [8811, 7, 9], [8812, 12, 10], [8814, 6, 6], [8815, 9, 8],
                    [8816, 12, 7], [8817, 18, 10], [8818, 47, 38], [8819, 33, 22], [8820, 50, 41], [8821, 39, 27],
                    [8822, 52, 43], [8823, 31, 25], [8824, 22, 18], [8825, 34, 29], [8826, 22, 21], [8827, 37, 29],
                    [8828, 37, 30], [8829, 41, 32], [8830, 27, 28], [8831, 33, 27], [8832, 19, 11], [8833, 32, 26],
                    [8834, 35, 30], [8835, 31, 19], [8836, 45, 36], [8837, 30, 18], [8838, 40, 34], [8839, 25, 13],
                    [8840, 36, 24], [8841, 24, 13], [8842, 15, 19], [8843, 19, 12], [8844, 27, 22], [8845, 15, 17],
                    [8846, 33, 28], [8847, 18, 19], [8848, 45, 36], [8849, 27, 21], [8850, 37, 31], [8851, 22, 22],
                    [8852, 34, 25], [8853, 14, 17], [8854, 34, 29], [8855, 20, 11], [8856, 30, 25], [8857, 23, 13],
                    [8858, 27, 14], [8859, 43, 37], [8860, 29, 12], [8861, 33, 28], [8862, 25, 21], [8863, 37, 32],
                    [8864, 20, 21], [8865, 31, 25], [8866, 20, 21], [8867, 50, 43], [8868, 37, 31], [8869, 48, 43],
                    [8870, 44, 35], [8871, 34, 29], [8872, 36, 30], [8873, 36, 30], [8874, 32, 27], [8875, 34, 28],
                    [8876, 18, 16], [8877, 41, 35], [8878, 18, 11], [8879, 29, 24], [8880, 30, 25], [8881, 48, 39],
                    [8882, 28, 24], [8883, 47, 41], [8884, 18, 16], [8885, 58, 38], [8886, 33, 27], [8887, 19, 11],
                    [8888, 29, 21], [8889, 44, 35], [8890, 14, 16], [8891, 34, 28], [8892, 14, 11], [8893, 34, 30],
                    [8894, 19, 18], [8895, 15, 11], [8896, 26, 21], [8897, 15, 11], [8898, 20, 18], [8899, 45, 39],
                    [8900, 33, 28], [8901, 44, 29], [8902, 34, 29], [8903, 25, 16], [8904, 33, 28], [8905, 23, 15],
                    [8906, 30, 24], [8907, 20, 19], [8908, 30, 25], [8909, 22, 19], [8910, 22, 13], [8911, 23, 13],
                    [8912, 41, 36], [8913, 26, 23], [8914, 39, 33], [8915, 27, 23], [8916, 45, 36], [8917, 32, 22],
                    [8918, 43, 38], [8919, 30, 28], [8920, 32, 29], [8921, 33, 31], [8922, 30, 24], [8923, 24, 19],
                    [8924, 14, 13], [8925, 11, 11], [8926, 14, 13], [8927, 15, 15], [8928, 13, 12], [8929, 10, 10],
                    [8930, 9, 10], [8931, 13, 14], [8932, 17, 18], [8933, 23, 23], [8934, 26, 25], [8935, 47, 38],
                    [8936, 25, 19], [8937, 33, 28], [8938, 25, 19], [8939, 31, 25], [8940, 18, 16], [8941, 30, 24],
                    [8942, 18, 16], [8943, 26, 19], [8944, 31, 25], [8945, 22, 13], [8946, 31, 25], [8947, 22, 13],
                    [8948, 30, 25], [8949, 21, 13], [8950, 22, 19], [8951, 31, 25], [8952, 23, 19], [8953, 47, 41],
                    [8954, 26, 18], [8955, 41, 36], [8956, 28, 23], [8957, 26, 18], [8958, 48, 40], [8959, 27, 19],
                    [8960, 47, 38], [8961, 27, 19], [8962, 44, 38], [8963, 30, 28], [8964, 19, 12], [8965, 42, 36],
                    [8966, 36, 28], [8967, 39, 31], [8968, 30, 25], [8969, 19, 13], [8970, 40, 34], [8971, 41, 32],
                    [8972, 17, 13], [8973, 41, 33], [8974, 14, 19], [8975, 45, 36], [8976, 48, 42], [8977, 26, 21],
                    [8978, 14, 11], [8979, 37, 32], [8980, 30, 25], [8981, 29, 24], [8983, 34, 28], [8984, 23, 19],
                    [8985, 34, 29], [8986, 24, 20], [8987, 27, 25], [8988, 18, 12], [8989, 34, 28], [8990, 18, 12],
                    [8991, 32, 27], [8992, 18, 12], [8993, 33, 24], [8994, 35, 25], [8995, 36, 27], [8996, 46, 37],
                    [8997, 22, 13], [8998, 27, 21], [8999, 19, 11], [9000, 50, 41], [9001, 42, 28], [9002, 39, 30],
                    [9003, 23, 21], [9004, 47, 38], [9005, 21, 18], [9006, 34, 29], [9007, 27, 19], [9008, 37, 24],
                    [9009, 32, 24], [9010, 27, 21], [9011, 19, 11], [9012, 27, 25], [9013, 14, 13], [9014, 38, 30],
                    [9015, 20, 15], [9016, 19, 14], [9017, 41, 32], [9018, 26, 26], [9019, 30, 29], [9020, 18, 21],
                    [9021, 34, 29], [9022, 24, 24], [9023, 31, 25], [9024, 38, 30], [9025, 30, 25], [9026, 34, 18],
                    [9027, 27, 17], [9028, 39, 30], [9030, 41, 30], [9031, 34, 26], [9032, 41, 30], [9033, 30, 28],
                    [9034, 46, 37], [9035, 39, 33], [9036, 36, 31], [9037, 16, 14], [9038, 27, 26], [9039, 15, 20],
                    [9040, 36, 30], [9041, 24, 20], [9042, 39, 31], [9043, 33, 28], [9044, 26, 14], [9045, 33, 25],
                    [9046, 28, 20], [9047, 35, 27], [9048, 30, 21], [9049, 56, 35], [9050, 28, 20], [9051, 41, 33],
                    [9052, 20, 17], [9053, 27, 20], [9054, 31, 22], [9055, 24, 13], [9056, 34, 23], [9057, 44, 29],
                    [9058, 27, 19], [9059, 47, 32], [9060, 40, 28], [9061, 47, 32], [9062, 40, 28], [9063, 33, 25],
                    [9064, 14, 18], [9065, 23, 21], [9066, 17, 17], [9067, 30, 22], [9068, 26, 18], [9069, 33, 37],
                    [9070, 14, 13], [9071, 27, 31], [9072, 14, 16], [9073, 14, 16], [9074, 29, 27], [9075, 20, 23],
                    [9076, 23, 25], [9077, 34, 22], [9078, 26, 16], [9079, 44, 35], [9080, 21, 18], [9081, 29, 22],
                    [9082, 47, 32], [9083, 23, 18], [9084, 29, 21], [9085, 19, 19], [9086, 36, 28], [9087, 41, 29],
                    [9088, 29, 17], [9089, 17, 14], [9090, 23, 18], [9091, 23, 15], [9092, 42, 27], [9093, 21, 19],
                    [9094, 45, 42], [9095, 14, 12], [9096, 26, 30], [9097, 29, 21], [9098, 36, 23], [9099, 19, 11],
                    [9100, 35, 23], [9101, 14, 13], [9102, 37, 28], [9103, 26, 26], [9104, 36, 28], [9105, 18, 12],
                    [9106, 22, 13], [9107, 33, 25], [9108, 34, 25], [9109, 35, 26], [9110, 44, 29], [9111, 25, 13],
                    [9112, 47, 38], [9113, 25, 20], [9114, 30, 25], [9115, 14, 11], [9116, 19, 14], [9117, 29, 12],
                    [9118, 43, 29], [9119, 18, 12], [9120, 27, 21], [9121, 32, 27], [9122, 39, 33], [9123, 28, 18],
                    [9124, 38, 30], [9125, 16, 23], [9126, 40, 34], [9127, 28, 20], [9128, 34, 25], [9129, 44, 34],
                    [9130, 51, 40], [9131, 27, 27], [9132, 45, 40], [9133, 26, 18], [9134, 34, 26], [9135, 44, 31],
                    [9136, 40, 28], [9137, 16, 11], [9138, 19, 15], [9139, 29, 25], [9140, 19, 15], [9141, 27, 23],
                    [9142, 48, 40], [9143, 20, 20], [9144, 24, 26], [9145, 32, 26], [9146, 40, 32], [9149, 19, 16],
                    [9150, 21, 22], [9151, 18, 16], [9152, 24, 25], [9153, 13, 17], [9154, 15, 15], [9155, 22, 24],
                    [9156, 26, 24], [9157, 26, 29], [9158, 12, 15], [9159, 20, 27], [9160, 14, 14], [9161, 18, 19],
                    [9162, 25, 26], [9163, 28, 23], [9164, 19, 19], [9165, 18, 33], [9166, 21, 24], [9167, 18, 19],
                    [9168, 26, 28], [9169, 21, 20], [9170, 27, 30], [9171, 18, 17], [9172, 19, 23], [9173, 21, 27],
                    [9174, 17, 17], [9175, 19, 20], [9176, 11, 11], [9177, 21, 19], [9178, 20, 30], [9179, 22, 28],
                    [9180, 12, 14], [9181, 18, 16], [9182, 24, 29], [9183, 21, 20], [9184, 24, 25], [9185, 21, 20],
                    [9186, 15, 18], [9187, 22, 21], [9188, 25, 26], [9189, 23, 22], [9190, 15, 18], [9191, 20, 19],
                    [9192, 19, 21], [9193, 18, 17], [9194, 28, 19], [9195, 32, 37], [9196, 26, 26], [9198, 31, 24],
                    [9199, 51, 35], [9200, 42, 47], [9201, 47, 31], [9202, 37, 36], [9203, 11, 15], [9204, 10, 12],
                    [9209, 28, 25], [9211, 27, 29], [9214, 35, 33], [9218, 26, 22], [9226, 55, 37], [9227, 51, 42],
                    [9228, 54, 55], [9229, 41, 43], [9230, 37, 32], [9232, 41, 35], [9233, 35, 34], [9234, 27, 31],
                    [9235, 35, 38], [9237, 34, 22], [9238, 32, 41], [9242, 39, 34], [9244, 36, 35], [9245, 24, 29],
                    [9248, 37, 29], [9254, 94, 97], [9255, 46, 34], [9257, 69, 61], [9258, 39, 52], [9259, 56, 56],
                    [9260, 47, 37], [9261, 73, 90], [9263, 50, 55], [9264, 45, 47], [9265, 49, 53], [9266, 79, 89],
                    [9267, 65, 64], [9268, 57, 58], [9269, 85, 89], [9270, 79, 89], [9271, 81, 93], [9272, 86, 99],
                    [9273, 85, 98], [9274, 86, 81], [9275, 57, 54], [9276, 84, 79], [9277, 75, 63], [9278, 78, 81],
                    [9279, 76, 70], [9280, 58, 57], [9281, 81, 71], [9282, 91, 82], [9283, 82, 86], [9284, 105, 116],
                    [9285, 71, 81], [9286, 97, 111], [9287, 101, 108], [9288, 56, 43], [9289, 95, 107], [9290, 70, 80],
                    [9291, 91, 97], [9292, 90, 96], [9293, 63, 45], [9294, 59, 58], [9295, 76, 71], [9296, 57, 42],
                    [9297, 78, 55], [9298, 74, 88], [9299, 88, 100], [9300, 93, 102], [9301, 78, 90], [9302, 101, 109],
                    [9303, 83, 99], [9304, 60, 77], [9305, 81, 98], [9306, 102, 122], [9307, 43, 60], [9308, 54, 70],
                    [9309, 51, 62], [9310, 61, 68], [9311, 58, 68], [9312, 61, 68], [9313, 57, 65], [9314, 73, 84],
                    [9315, 36, 35], [9316, 26, 26], [9317, 10, 11], [9318, 14, 16], [9319, 34, 38], [9320, 47, 46],
                    [9327, 11, 13], [9328, 21, 25], [9329, 28, 33], [9330, 39, 41], [9331, 29, 29], [9332, 28, 31],
                    [9333, 12, 14], [9334, 11, 13], [9335, 30, 29], [9336, 24, 28], [9337, 17, 20], [9338, 11, 11],
                    [9339, 16, 19], [9340, 41, 43], [9341, 21, 24], [9342, 29, 29], [9343, 8, 9], [9344, 16, 16],
                    [9345, 17, 21], [9346, 12, 13], [9347, 10, 12], [9348, 20, 22], [9349, 16, 19], [9350, 40, 45],
                    [9351, 32, 29], [9352, 35, 34], [9353, 18, 20], [9354, 24, 24], [9355, 18, 16], [9356, 29, 32],
                    [9357, 17, 19], [9358, 23, 22], [9359, 17, 18], [9360, 27, 30], [9361, 24, 28], [9362, 32, 30],
                    [9363, 27, 31], [9364, 35, 27], [9365, 17, 20], [9366, 28, 31], [9367, 20, 18], [9368, 27, 27],
                    [9369, 29, 28], [9370, 16, 18], [9371, 29, 27], [9372, 25, 23], [9373, 21, 21], [9374, 33, 32],
                    [9375, 21, 24], [9376, 35, 34], [9377, 12, 14], [9378, 16, 19], [9379, 28, 33], [9380, 25, 28],
                    [9381, 45, 53], [9382, 27, 32], [9383, 32, 31], [9384, 16, 17], [9385, 18, 19], [9386, 17, 18],
                    [9387, 15, 15], [9388, 15, 17], [9389, 16, 16], [9390, 18, 22], [9391, 22, 25], [9392, 20, 22],
                    [9393, 22, 22], [9394, 14, 15], [9395, 19, 19], [9396, 21, 25], [9397, 39, 44], [9398, 34, 39],
                    [9399, 54, 58], [9400, 24, 29], [9401, 36, 34], [9402, 39, 30], [9403, 108, 79], [9404, 107, 78],
                    [9405, 109, 80], [9406, 93, 80], [9407, 70, 64], [9408, 109, 80], [9409, 104, 79], [9410, 109, 80],
                    [9411, 104, 75], [9412, 104, 78], [9413, 109, 80], [9414, 107, 79], [9415, 109, 80], [9416, 95, 73],
                    [9417, 109, 80], [9418, 103, 71], [9419, 106, 80], [9420, 106, 77], [9421, 103, 71],
                    [9422, 106, 80], [9423, 93, 69], [9424, 107, 79], [9425, 109, 80], [9426, 106, 80], [9427, 109, 80],
                    [9428, 104, 75], [9429, 104, 79], [9430, 109, 80], [9431, 106, 77], [9432, 60, 56], [9433, 93, 69],
                    [9434, 105, 77], [9435, 109, 80], [9436, 106, 77], [9437, 107, 79], [9438, 109, 80],
                    [9439, 105, 76], [9440, 109, 80], [9441, 106, 80], [9442, 109, 80], [9443, 107, 78],
                    [9444, 104, 75], [9445, 104, 79], [9446, 109, 80], [9447, 104, 79], [9448, 109, 80], [9449, 55, 45],
                    [9450, 93, 69], [9451, 93, 80], [9452, 106, 77], [9453, 104, 79], [9454, 104, 79], [9455, 109, 80],
                    [9456, 106, 77], [9457, 93, 80], [9458, 106, 78], [9459, 104, 79], [9460, 109, 80], [9461, 104, 79],
                    [9462, 109, 80], [9463, 74, 69], [9464, 74, 69], [9465, 60, 56], [9466, 104, 79], [9467, 108, 79],
                    [9468, 107, 64], [9469, 109, 80], [9470, 105, 76], [9471, 117, 72], [9472, 135, 121],
                    [9473, 45, 69], [9474, 74, 108], [9475, 93, 78], [9476, 93, 131], [9477, 33, 44], [9478, 55, 69],
                    [9479, 81, 84], [9480, 116, 120], [9481, 26, 62], [9482, 41, 97], [9483, 93, 69], [9484, 122, 69],
                    [9485, 67, 45], [9486, 86, 67], [9487, 26, 45], [9488, 44, 69], [9489, 93, 69], [9490, 91, 84],
                    [9491, 41, 62], [9492, 68, 75], [9493, 93, 75], [9494, 98, 97], [9495, 41, 38], [9496, 74, 50],
                    [9497, 42, 29], [9498, 66, 45], [9499, 60, 69], [9500, 93, 97], [9501, 60, 86], [9502, 93, 131],
                    [9503, 60, 50], [9504, 73, 58], [9505, 60, 87], [9506, 93, 131], [9507, 69, 69], [9508, 93, 121],
                    [9509, 93, 65], [9510, 93, 90], [9511, 60, 57], [9512, 60, 88], [9513, 70, 70], [9514, 93, 99],
                    [9515, 60, 56], [9516, 92, 76], [9517, 93, 75], [9518, 117, 108], [9519, 30, 33], [9520, 52, 55],
                    [9521, 66, 131], [9522, 97, 152], [9523, 93, 75], [9524, 111, 112], [9525, 29, 35], [9526, 46, 53],
                    [9527, 75, 71], [9528, 93, 93], [9529, 40, 45], [9530, 65, 69], [9531, 39, 49], [9532, 50, 79],
                    [9533, 93, 93], [9534, 127, 118], [9535, 29, 57], [9536, 54, 110], [9537, 100, 69], [9538, 125, 97],
                    [9539, 54, 51], [9540, 74, 80], [9541, 40, 37], [9542, 64, 59], [9543, 34, 41], [9544, 55, 64],
                    [9545, 60, 56], [9546, 67, 74], [9547, 36, 43], [9548, 61, 71], [9549, 32, 32], [9550, 50, 56],
                    [9551, 33, 47], [9552, 53, 79], [9553, 41, 45], [9554, 60, 69], [9555, 58, 111], [9556, 86, 130],
                    [9557, 34, 50], [9558, 60, 80], [9559, 39, 38], [9560, 54, 56], [9561, 40, 57], [9562, 64, 89],
                    [9563, 57, 110], [9564, 88, 131], [9565, 60, 56], [9566, 66, 86], [9567, 51, 62], [9568, 70, 101],
                    [9569, 93, 87], [9570, 117, 115], [9571, 77, 121], [9572, 109, 131], [9573, 74, 69],
                    [9574, 93, 106], [9575, 61, 63], [9576, 103, 107], [9577, 93, 63], [9578, 114, 98], [9579, 43, 87],
                    [9580, 60, 110], [9581, 46, 56], [9582, 54, 71], [9583, 93, 113], [9584, 135, 131], [9585, 93, 63],
                    [9586, 97, 71], [9587, 53, 50], [9588, 59, 68], [9589, 35, 67], [9590, 50, 98], [9591, 60, 50],
                    [9592, 65, 56], [9593, 34, 47], [9594, 55, 83], [9595, 38, 48], [9596, 64, 74], [9597, 26, 25],
                    [9598, 38, 49], [9599, 93, 63], [9600, 93, 69], [9601, 46, 69], [9602, 85, 117], [9603, 58, 69],
                    [9604, 83, 87], [9605, 53, 38], [9606, 60, 48], [9607, 49, 56], [9608, 78, 69], [9609, 37, 40],
                    [9610, 50, 56], [9611, 41, 45], [9612, 60, 63], [9613, 63, 110], [9614, 91, 131], [9615, 51, 43],
                    [9616, 77, 65], [9617, 22, 27], [9618, 60, 56], [9619, 31, 39], [9620, 31, 39], [9621, 39, 63],
                    [9622, 50, 69], [9623, 60, 50], [9624, 60, 56], [9625, 93, 69], [9626, 91, 89], [9627, 60, 43],
                    [9628, 74, 56], [9629, 45, 50], [9630, 74, 65], [9631, 41, 40], [9632, 55, 65], [9633, 51, 60],
                    [9634, 91, 115], [9635, 123, 110], [9636, 141, 131], [9637, 69, 71], [9638, 99, 100],
                    [9639, 19, 25], [9640, 37, 56], [9641, 52, 40], [9642, 67, 69], [9643, 27, 44], [9644, 44, 71],
                    [9645, 60, 102], [9646, 68, 131], [9647, 93, 69], [9648, 105, 120], [9651, 43, 43], [9652, 66, 63],
                    [9653, 39, 36], [9654, 71, 54], [9655, 32, 32], [9656, 54, 54], [9657, 48, 45], [9658, 53, 46],
                    [9659, 34, 30], [9660, 57, 57], [9661, 33, 33], [9662, 54, 49], [9663, 33, 31], [9664, 58, 51],
                    [9665, 45, 45], [9666, 52, 52], [9667, 42, 36], [9668, 54, 48], [9669, 32, 32], [9670, 52, 49],
                    [9671, 34, 34], [9672, 64, 55], [9673, 36, 35], [9674, 47, 47], [9675, 40, 41], [9676, 75, 56],
                    [9677, 33, 32], [9678, 55, 49], [9679, 33, 33], [9680, 57, 54], [9681, 40, 34], [9682, 61, 53],
                    [9683, 44, 41], [9684, 58, 52], [9685, 38, 38], [9686, 60, 54], [9687, 37, 34], [9688, 60, 55],
                    [9689, 68, 69], [9690, 62, 57], [9691, 36, 33], [9692, 56, 48], [9693, 51, 41], [9694, 70, 48],
                    [9695, 33, 33], [9696, 55, 47], [9697, 36, 34], [9698, 64, 46], [9699, 34, 38], [9700, 58, 56],
                    [9701, 31, 31], [9702, 46, 41], [9703, 29, 29], [9704, 58, 52], [9705, 30, 30], [9706, 63, 57],
                    [9707, 38, 32], [9708, 53, 42], [9709, 34, 35], [9710, 43, 40], [9711, 86, 66], [9712, 84, 66],
                    [9713, 86, 65], [9714, 79, 60], [9715, 75, 57], [9716, 39, 30], [9717, 42, 37], [9718, 33, 31],
                    [9720, 70, 52], [9721, 63, 56], [9722, 31, 32], [9723, 70, 66], [9724, 55, 49], [9725, 73, 66],
                    [9726, 24, 30], [9727, 50, 45], [9728, 45, 40], [9729, 50, 45], [9730, 27, 27], [9731, 69, 51],
                    [9735, 54, 45], [9736, 39, 39], [9737, 45, 40], [9738, 85, 59], [9739, 49, 46], [9740, 65, 61],
                    [9741, 52, 48], [9742, 51, 47], [9743, 40, 35], [9744, 74, 54], [9745, 49, 46], [9746, 44, 44],
                    [9747, 54, 49], [9748, 48, 48], [9751, 38, 31], [9752, 45, 40], [9753, 31, 32], [9754, 52, 51],
                    [9755, 32, 33], [9756, 65, 60], [9757, 32, 33], [9758, 54, 50], [9759, 22, 15], [9760, 40, 25],
                    [9761, 42, 27], [9762, 38, 19], [9763, 23, 16], [9764, 26, 14], [9765, 40, 27], [9766, 40, 20],
                    [9767, 39, 45], [9768, 33, 24], [9769, 25, 18], [9770, 44, 39], [9771, 50, 22], [9772, 31, 16],
                    [9773, 39, 29], [9774, 24, 19], [9775, 25, 19], [9776, 29, 15], [9777, 41, 26], [9778, 42, 28],
                    [9779, 38, 28], [9780, 40, 31], [9781, 30, 17], [9782, 41, 29], [9783, 34, 21], [9784, 35, 27],
                    [9785, 29, 24], [9786, 22, 16], [9787, 39, 26], [9788, 22, 18], [9789, 42, 21], [9790, 40, 25],
                    [9791, 45, 30], [9792, 40, 35], [9793, 17, 13], [9794, 15, 14], [9795, 14, 13], [9796, 20, 16],
                    [9797, 16, 13], [9798, 15, 14], [9799, 43, 37], [9800, 24, 21], [9801, 20, 17], [9802, 20, 17],
                    [9803, 11, 10], [9804, 19, 15], [9805, 35, 27], [9806, 23, 18], [9807, 32, 21], [9808, 74, 47],
                    [9809, 42, 18], [9811, 43, 26], [9812, 71, 44], [9813, 60, 28], [9814, 23, 15], [9815, 45, 26],
                    [9816, 34, 17], [9817, 27, 14], [9818, 60, 20], [9819, 53, 37], [9820, 64, 40], [9821, 50, 28],
                    [9822, 24, 21], [9823, 30, 21], [9824, 32, 26], [9825, 22, 18], [9826, 51, 37], [9827, 48, 28],
                    [9828, 56, 38], [9829, 41, 27], [9830, 33, 26], [9831, 41, 26], [9832, 36, 23], [9833, 35, 25],
                    [9834, 63, 41], [9835, 37, 32], [9836, 48, 34], [9837, 33, 22], [9838, 54, 40], [9839, 20, 17],
                    [9840, 44, 33], [9841, 80, 47], [9842, 36, 22], [9843, 31, 22], [9844, 39, 25], [9845, 33, 27],
                    [9846, 30, 20], [9847, 16, 14], [9848, 29, 19], [9849, 28, 17], [9850, 28, 15], [9851, 26, 13],
                    [9852, 22, 13], [9853, 25, 18], [9854, 15, 13], [9855, 31, 26], [9856, 17, 18], [9857, 17, 14],
                    [9858, 45, 29], [9859, 57, 36], [9860, 49, 37], [9861, 61, 52], [9862, 30, 32], [9863, 47, 33],
                    [9864, 57, 25], [9865, 39, 25], [9866, 56, 24], [9867, 23, 18], [9868, 48, 32], [9869, 44, 27],
                    [9870, 40, 45], [9871, 47, 29], [9872, 27, 24], [9873, 36, 34], [9874, 43, 23], [9875, 36, 25],
                    [9876, 27, 24], [9877, 38, 29], [9878, 42, 27], [9879, 41, 25], [9880, 43, 33], [9881, 51, 29],
                    [9882, 39, 32], [9883, 36, 22], [9884, 36, 21], [9885, 43, 24], [9886, 45, 23], [9887, 40, 28],
                    [9888, 51, 38], [9889, 47, 30], [9890, 42, 30], [9891, 36, 24], [9892, 32, 25], [9893, 27, 19],
                    [9894, 51, 34], [9895, 27, 17], [9896, 12, 14], [9897, 38, 25], [9898, 40, 30], [9899, 26, 21],
                    [9900, 59, 51], [9901, 53, 36], [9902, 76, 56], [9903, 71, 50], [9904, 63, 46], [9905, 41, 32],
                    [9906, 45, 27], [9907, 34, 30], [9908, 64, 42], [9909, 17, 15], [9910, 54, 46], [9911, 76, 44],
                    [9912, 51, 32], [9913, 25, 22], [9914, 35, 26], [9915, 33, 28], [9916, 34, 31], [9917, 29, 26],
                    [9918, 77, 30], [9919, 75, 61], [9920, 80, 57], [9921, 28, 22], [9922, 30, 18], [9923, 34, 23],
                    [9924, 44, 26], [9925, 54, 49], [9926, 42, 47], [9927, 34, 24], [9928, 57, 31], [9929, 45, 40],
                    [9930, 43, 28], [9931, 56, 34], [9932, 57, 29], [9933, 52, 40], [9934, 49, 29], [9935, 41, 24],
                    [9936, 42, 30], [9937, 30, 28], [9938, 18, 17], [9939, 48, 24], [9940, 38, 33], [9941, 41, 23],
                    [9942, 23, 18], [9943, 95, 58], [9944, 48, 27], [9945, 69, 33], [9946, 39, 20], [9947, 54, 29],
                    [9948, 88, 45], [9949, 84, 51], [9950, 60, 46], [9951, 37, 24], [9952, 53, 27], [9953, 27, 22],
                    [9954, 66, 44], [9955, 26, 22], [9956, 57, 27], [9957, 82, 42], [9958, 31, 25], [9959, 82, 44],
                    [9960, 50, 26], [9961, 31, 28], [9962, 37, 24], [9963, 66, 40], [9964, 36, 32], [9965, 34, 17],
                    [9966, 57, 31], [9967, 69, 34], [9968, 42, 38], [9969, 37, 22], [9970, 57, 28], [9971, 32, 25],
                    [9972, 92, 42], [9973, 45, 37], [9974, 34, 16], [9975, 81, 37], [9976, 96, 44], [9977, 38, 21],
                    [9978, 44, 22], [9979, 81, 39], [9980, 46, 24], [9981, 28, 18], [9982, 19, 14], [9983, 74, 34],
                    [9984, 41, 26], [9985, 43, 26], [9986, 44, 27], [9987, 46, 38], [9988, 41, 27], [9989, 36, 29],
                    [9990, 36, 22], [9991, 44, 32], [9992, 47, 36], [9993, 34, 36], [9994, 29, 26], [9995, 44, 35],
                    [9996, 35, 30], [9997, 18, 23], [9998, 20, 16], [9999, 29, 32], [10000, 25, 18], [10001, 21, 17],
                    [10002, 19, 15], [10003, 45, 27], [10004, 22, 18], [10005, 23, 18], [10006, 17, 14],
                    [10007, 37, 39], [10008, 52, 49], [10009, 49, 33], [10010, 56, 32], [10011, 46, 30],
                    [10012, 59, 26], [10013, 34, 28], [10014, 41, 40], [10015, 33, 30], [10016, 37, 38],
                    [10017, 43, 34], [10018, 44, 37], [10019, 43, 34], [10020, 54, 44], [10021, 64, 43],
                    [10022, 59, 46], [10023, 59, 43], [10024, 82, 55], [10025, 71, 55], [10026, 65, 47],
                    [10027, 58, 45], [10030, 55, 44], [10031, 78, 66], [10032, 74, 55], [10033, 45, 34],
                    [10034, 53, 34], [10035, 80, 44], [10036, 82, 38], [10037, 82, 45], [10038, 31, 21],
                    [10039, 20, 21], [10040, 30, 21], [10041, 29, 18], [10042, 52, 35], [10043, 54, 28],
                    [10044, 62, 28], [10045, 37, 22], [10046, 54, 35], [10047, 50, 27], [10048, 47, 29],
                    [10049, 34, 25], [10050, 45, 32], [10051, 54, 37], [10052, 60, 50], [10053, 65, 49],
                    [10054, 55, 50], [10055, 62, 52], [10056, 54, 51], [10057, 62, 53], [10058, 35, 38],
                    [10059, 67, 38], [10060, 52, 36], [10061, 60, 55], [10063, 22, 22], [10064, 38, 30],
                    [10065, 34, 39], [10066, 41, 36], [10067, 58, 45], [10068, 67, 49], [10069, 59, 45],
                    [10070, 42, 24], [10071, 56, 41], [10072, 59, 23], [10073, 59, 28], [10074, 57, 28],
                    [10075, 65, 36], [10076, 61, 37], [10077, 58, 37], [10078, 73, 44], [10079, 46, 33],
                    [10080, 41, 36], [10081, 69, 45], [10082, 46, 49], [10083, 41, 38], [10084, 45, 31],
                    [10085, 43, 22], [10086, 47, 29], [10087, 43, 20], [10088, 60, 39], [10089, 60, 40],
                    [10090, 47, 37], [10091, 60, 29], [10092, 64, 31], [10093, 44, 37], [10094, 76, 48],
                    [10095, 68, 45], [10096, 57, 36], [10097, 48, 34], [10098, 55, 38], [10099, 67, 47],
                    [10101, 69, 55], [10102, 58, 45], [10103, 60, 55], [10104, 19, 19], [10105, 31, 21],
                    [10106, 31, 28], [10107, 57, 52], [10108, 66, 58], [10109, 113, 72], [10110, 54, 46],
                    [10111, 76, 57], [10112, 77, 61], [10113, 101, 83], [10114, 67, 43], [10115, 43, 31],
                    [10116, 48, 39], [10117, 46, 43], [10118, 50, 52], [10119, 25, 16], [10120, 31, 21],
                    [10121, 66, 56], [10122, 65, 55], [10123, 81, 68], [10124, 70, 64], [10125, 69, 42],
                    [10126, 60, 37], [10127, 60, 37], [10128, 61, 43], [10129, 84, 54], [10130, 78, 54],
                    [10131, 46, 36], [10132, 47, 37], [10133, 61, 35], [10134, 88, 61], [10135, 85, 67],
                    [10136, 52, 27], [10137, 63, 43], [10138, 54, 30], [10139, 54, 34], [10141, 50, 32],
                    [10142, 54, 33], [10144, 67, 34], [10145, 44, 42], [10146, 50, 45], [10148, 48, 28],
                    [10149, 50, 52], [10150, 27, 33], [10151, 45, 41], [10152, 60, 46], [10153, 66, 51],
                    [10154, 26, 26], [10155, 54, 53], [10156, 36, 33], [10157, 62, 46], [10158, 35, 37],
                    [10159, 49, 38], [10160, 51, 33], [10161, 72, 42], [10162, 55, 28], [10163, 77, 38],
                    [10164, 55, 29], [10165, 61, 33], [10166, 46, 28], [10167, 54, 41], [10168, 56, 43],
                    [10169, 60, 43], [10170, 31, 35], [10171, 50, 41], [10172, 39, 33], [10173, 49, 40],
                    [10174, 47, 32], [10175, 58, 40], [10176, 20, 21], [10177, 18, 19], [10178, 22, 21],
                    [10179, 19, 20], [10180, 39, 31], [10181, 24, 17], [10182, 37, 39], [10183, 46, 27],
                    [10184, 44, 18], [10185, 17, 14], [10186, 16, 12], [10187, 22, 18], [10188, 23, 16],
                    [10189, 57, 32], [10190, 21, 15], [10191, 46, 27], [10192, 34, 22], [10193, 20, 19],
                    [10194, 16, 12], [10195, 15, 13], [10196, 41, 30], [10197, 39, 28], [10198, 29, 31],
                    [10199, 28, 31], [10200, 28, 32], [10201, 27, 29], [10202, 65, 54], [10203, 55, 38],
                    [10204, 56, 38], [10205, 45, 33], [10206, 42, 29], [10207, 39, 28], [10208, 42, 31],
                    [10209, 40, 28], [10210, 46, 37], [10211, 44, 35], [10212, 49, 32], [10213, 47, 30],
                    [10214, 42, 36], [10215, 40, 34], [10216, 47, 33], [10217, 50, 35], [10218, 44, 35],
                    [10219, 43, 36], [10220, 41, 33], [10221, 44, 30], [10222, 42, 32], [10223, 52, 42],
                    [10224, 61, 50], [10225, 54, 50], [10226, 31, 29], [10227, 32, 29], [10228, 30, 28],
                    [10234, 49, 39], [10235, 38, 32], [10236, 38, 34], [10237, 30, 29], [10238, 38, 36],
                    [10239, 53, 43], [10240, 32, 31], [10241, 27, 34], [10242, 35, 29], [10243, 38, 31],
                    [10244, 37, 39], [10245, 19, 26], [10246, 34, 30], [10247, 23, 26], [10248, 37, 29],
                    [10249, 23, 28], [10250, 36, 33], [10251, 37, 31], [10252, 36, 33], [10253, 36, 36],
                    [10255, 37, 34], [10256, 43, 39], [10257, 35, 31], [10258, 39, 37], [10259, 18, 28],
                    [10260, 37, 34], [10261, 40, 32], [10263, 22, 26], [10264, 37, 34], [10267, 27, 25],
                    [10268, 39, 30], [10269, 26, 27], [10270, 32, 33], [10271, 37, 30], [10272, 30, 29],
                    [10276, 32, 31], [10277, 40, 36], [10278, 24, 29], [10279, 37, 35], [10280, 23, 32],
                    [10281, 36, 38], [10283, 24, 26], [10284, 32, 31], [10285, 24, 24], [10286, 31, 27],
                    [10287, 30, 27], [10288, 34, 26], [10289, 38, 30], [10290, 35, 29], [10291, 35, 31],
                    [10292, 26, 29], [10293, 35, 35], [10294, 18, 25], [10295, 24, 29], [10296, 34, 33],
                    [10297, 24, 26], [10298, 31, 31], [10299, 24, 26], [10300, 32, 30], [10301, 32, 34],
                    [10302, 24, 28], [10303, 36, 35], [10304, 24, 29], [10305, 33, 33], [10306, 28, 33],
                    [10307, 30, 33], [10309, 32, 29], [10310, 24, 29], [10311, 34, 34], [10312, 30, 29],
                    [10313, 40, 32], [10314, 38, 32], [10315, 35, 27], [10317, 26, 27], [10318, 43, 34],
                    [10319, 27, 32], [10320, 56, 36], [10321, 28, 27], [10322, 38, 37], [10323, 26, 33],
                    [10326, 49, 38], [10327, 26, 29], [10329, 30, 27], [10330, 30, 33], [10332, 22, 25],
                    [10333, 35, 35], [10334, 38, 35], [10335, 35, 37], [10337, 26, 26], [10338, 40, 33],
                    [10339, 28, 29], [10340, 41, 33], [10341, 23, 25], [10342, 33, 29], [10343, 31, 28],
                    [10344, 29, 32], [10347, 23, 32], [10354, 22, 26], [10355, 37, 33], [10356, 27, 30],
                    [10357, 37, 37], [10358, 35, 30], [10360, 22, 25], [10361, 37, 31], [10362, 35, 35],
                    [10363, 52, 36], [10364, 60, 35], [10366, 38, 36], [10367, 50, 34], [10368, 58, 39],
                    [10369, 51, 34], [10370, 61, 40], [10371, 32, 39], [10372, 22, 26], [10374, 24, 28],
                    [10376, 23, 25], [10377, 27, 28], [10378, 33, 33], [10380, 29, 30], [10381, 49, 37],
                    [10382, 30, 31], [10383, 59, 37], [10384, 34, 34], [10385, 62, 38], [10388, 18, 28],
                    [10390, 26, 29], [10391, 32, 27], [10392, 32, 31], [10394, 23, 25], [10395, 33, 31],
                    [10396, 24, 26], [10398, 24, 29], [10399, 35, 32], [10400, 25, 27], [10402, 23, 32],
                    [10403, 39, 39], [10404, 27, 31], [10408, 23, 31], [10409, 35, 39], [10410, 25, 32],
                    [10411, 39, 37], [10412, 39, 25], [10413, 66, 40], [10417, 37, 39], [10418, 23, 25],
                    [10419, 34, 34], [10420, 38, 38], [10422, 31, 34], [10424, 39, 35], [10425, 23, 29],
                    [10426, 34, 36], [10427, 29, 27], [10428, 30, 33], [10431, 24, 29], [10432, 37, 33],
                    [10433, 22, 27], [10434, 36, 32], [10435, 37, 30], [10436, 28, 27], [10437, 34, 26],
                    [10438, 25, 27], [10439, 35, 37], [10440, 23, 30], [10441, 36, 32], [10442, 29, 30],
                    [10443, 23, 25], [10444, 37, 28], [10445, 40, 34], [10447, 22, 24], [10448, 34, 30],
                    [10450, 22, 27], [10453, 54, 31], [10454, 49, 30], [10455, 54, 35], [10456, 22, 27],
                    [10458, 23, 26], [10459, 30, 27], [10461, 24, 30], [10463, 19, 24], [10464, 28, 30],
                    [10467, 23, 31], [10469, 27, 27], [10471, 26, 25], [10474, 15, 14], [10475, 15, 14],
                    [10476, 17, 18], [10477, 19, 19], [10478, 26, 34], [10479, 36, 27], [10480, 22, 24],
                    [10482, 23, 28], [10483, 29, 33], [10484, 23, 28], [10485, 28, 33], [10486, 23, 27],
                    [10487, 28, 34], [10490, 16, 27], [10491, 9, 21], [10492, 8, 13], [10493, 35, 36], [10494, 11, 38],
                    [10495, 12, 29], [10496, 10, 20], [10497, 28, 54], [10498, 9, 25], [10499, 9, 54], [10500, 12, 56],
                    [10501, 12, 56], [10502, 33, 78], [10503, 12, 57], [10504, 14, 77], [10505, 34, 57],
                    [10506, 15, 37], [10507, 9, 23], [10508, 26, 59], [10509, 28, 40], [10510, 15, 40], [10511, 7, 20],
                    [10512, 22, 24], [10513, 32, 31], [10514, 16, 24], [10515, 17, 26], [10516, 16, 23],
                    [10517, 22, 30], [10518, 17, 18], [10519, 22, 20], [10520, 11, 12], [10521, 18, 23],
                    [10522, 18, 22], [10523, 18, 22], [10524, 24, 24], [10525, 17, 22], [10526, 18, 22],
                    [10527, 16, 18], [10528, 22, 22], [10529, 21, 22], [10530, 18, 22], [10531, 16, 21],
                    [10532, 22, 21], [10533, 32, 27], [10534, 15, 13], [10535, 31, 25], [10536, 17, 20],
                    [10537, 22, 20], [10538, 29, 24], [10539, 17, 17], [10540, 31, 25], [10541, 38, 32],
                    [10542, 41, 28], [10543, 7, 7], [10544, 12, 10], [10545, 7, 7], [10546, 8, 8], [10547, 8, 8],
                    [10548, 11, 10], [10549, 8, 8], [10550, 14, 11], [10551, 8, 8], [10552, 7, 7], [10553, 18, 14],
                    [10554, 17, 11], [10555, 11, 8], [10556, 20, 14], [10557, 14, 10], [10558, 27, 17], [10559, 19, 13],
                    [10560, 19, 13], [10577, 18, 11], [10578, 38, 44], [10579, 47, 41], [10580, 64, 52],
                    [10581, 79, 66], [10582, 62, 49], [10583, 57, 50], [10584, 63, 53], [10585, 50, 52],
                    [10586, 68, 60], [10587, 61, 51], [10588, 44, 42], [10589, 58, 53], [10590, 75, 59],
                    [10591, 78, 73], [10592, 64, 37], [10593, 54, 45], [10594, 65, 61], [10595, 41, 45],
                    [10596, 46, 43], [10597, 55, 45], [10598, 50, 39], [10600, 42, 31], [10601, 58, 36],
                    [10602, 29, 33], [10603, 42, 40], [10604, 42, 29], [10605, 19, 11], [10606, 16, 11],
                    [10607, 25, 14], [10608, 14, 11], [10609, 14, 11], [10610, 23, 11], [10611, 23, 15],
                    [10612, 21, 16], [10613, 48, 17], [10614, 41, 25], [10615, 44, 23], [10616, 39, 32],
                    [10617, 51, 30], [10618, 55, 29], [10619, 41, 24], [10620, 30, 21], [10621, 41, 17],
                    [10622, 36, 19], [10623, 41, 19], [10624, 41, 18], [10625, 35, 23], [10626, 51, 27],
                    [10627, 47, 23], [10628, 53, 34], [10629, 51, 33], [10630, 31, 18], [10631, 47, 20],
                    [10632, 36, 19], [10633, 51, 25], [10634, 50, 19], [10635, 52, 19], [10636, 41, 25],
                    [10637, 40, 23], [10638, 25, 18], [10639, 52, 28], [10640, 48, 28], [10641, 47, 29],
                    [10642, 51, 30], [10643, 41, 27], [10644, 48, 28], [10645, 36, 31], [10646, 49, 30],
                    [10647, 49, 29], [10648, 42, 35], [10649, 45, 26], [10650, 49, 24], [10651, 47, 24],
                    [10652, 39, 25], [10653, 52, 24], [10654, 39, 29], [10655, 48, 27], [10656, 49, 29],
                    [10657, 39, 21], [10658, 46, 20], [10659, 23, 18], [10660, 54, 25], [10661, 80, 30],
                    [10662, 49, 30], [10663, 46, 19], [10664, 51, 24], [10665, 53, 26], [10666, 55, 23],
                    [10667, 51, 23], [10668, 47, 25], [10669, 22, 18], [10670, 48, 22], [10671, 49, 30],
                    [10672, 54, 29], [10673, 36, 17], [10674, 41, 19], [10675, 41, 39], [10676, 41, 39],
                    [10677, 36, 19], [10678, 41, 26], [10679, 59, 29], [10680, 26, 20], [10681, 44, 23],
                    [10682, 41, 25], [10683, 39, 25], [10684, 29, 30], [10685, 85, 39], [10686, 47, 40],
                    [10687, 41, 42], [10688, 61, 42], [10689, 61, 40], [10690, 62, 42], [10691, 64, 42],
                    [10692, 64, 27], [10693, 87, 28], [10694, 65, 27], [10695, 52, 27], [10696, 52, 30],
                    [10697, 36, 27], [10698, 41, 37], [10699, 48, 37], [10700, 23, 23], [10701, 77, 26],
                    [10702, 78, 27], [10703, 79, 27], [10704, 52, 26], [10705, 60, 25], [10706, 53, 24],
                    [10707, 43, 46], [10708, 48, 46], [10709, 51, 46], [10710, 73, 22], [10711, 49, 23],
                    [10712, 54, 40], [10713, 54, 40], [10714, 47, 30], [10715, 79, 25], [10716, 52, 46],
                    [10717, 49, 46], [10718, 47, 46], [10719, 64, 43], [10720, 65, 43], [10721, 30, 26],
                    [10722, 64, 42], [10723, 51, 42], [10724, 54, 42], [10725, 51, 43], [10726, 38, 26],
                    [10727, 50, 28], [10728, 53, 31], [10729, 49, 29], [10730, 52, 28], [10731, 39, 23],
                    [10732, 52, 24], [10733, 53, 24], [10734, 52, 24], [10735, 53, 21], [10736, 52, 20],
                    [10737, 88, 22], [10738, 54, 30], [10739, 30, 17], [10740, 49, 23], [10741, 43, 25],
                    [10742, 49, 34], [10743, 42, 29], [10744, 41, 25], [10745, 48, 29], [10746, 48, 25],
                    [10747, 30, 21], [10748, 47, 19], [10749, 47, 25], [10750, 49, 12], [10751, 48, 22],
                    [10752, 49, 24], [10753, 52, 29], [10754, 46, 21], [10755, 21, 15], [10756, 83, 66],
                    [10757, 23, 14], [10758, 30, 12], [10759, 55, 27], [10760, 57, 33], [10761, 47, 31],
                    [10762, 48, 26], [10763, 41, 26], [10764, 30, 26], [10765, 36, 24], [10766, 50, 25],
                    [10767, 52, 19], [10768, 47, 20], [10769, 50, 20], [10770, 50, 40], [10771, 52, 40],
                    [10772, 36, 47], [10773, 49, 54], [10774, 40, 24], [10775, 47, 24], [10776, 42, 20],
                    [10777, 33, 21], [10778, 82, 21], [10779, 41, 28], [10780, 47, 21], [10781, 42, 20],
                    [10782, 41, 19], [10783, 60, 37], [10784, 51, 25], [10785, 53, 27], [10786, 40, 21],
                    [10787, 44, 20], [10788, 48, 46], [10789, 44, 26], [10790, 53, 26], [10791, 54, 26],
                    [10792, 30, 19], [10793, 50, 19], [10794, 54, 20], [10795, 55, 20], [10796, 56, 20],
                    [10797, 49, 21], [10798, 34, 20], [10799, 25, 18], [10800, 49, 33], [10801, 48, 25],
                    [10802, 41, 26], [10803, 36, 21], [10804, 60, 24], [10805, 64, 25], [10806, 39, 24],
                    [10807, 48, 24], [10808, 33, 17], [10809, 31, 20], [10810, 40, 20], [10811, 41, 18],
                    [10812, 128, 50], [10813, 49, 41], [10814, 40, 23], [10815, 49, 23], [10816, 52, 22],
                    [10817, 49, 22], [10818, 52, 35], [10819, 51, 31], [10820, 52, 28], [10821, 46, 19],
                    [10822, 49, 19], [10823, 44, 19], [10824, 39, 24], [10825, 40, 25], [10826, 44, 26],
                    [10827, 41, 26], [10828, 35, 21], [10829, 51, 30], [10830, 48, 28], [10831, 50, 27],
                    [10832, 47, 27], [10833, 47, 27], [10834, 48, 28], [10835, 49, 29], [10836, 47, 28],
                    [10837, 55, 29], [10838, 49, 28], [10839, 40, 28], [10840, 30, 24], [10841, 75, 21],
                    [10842, 36, 19], [10843, 49, 25], [10844, 37, 30], [10845, 33, 28], [10846, 39, 27],
                    [10847, 38, 20], [10848, 49, 20], [10849, 49, 20], [10850, 43, 28], [10851, 38, 26],
                    [10852, 41, 26], [10853, 53, 38], [10854, 50, 26], [10855, 53, 26], [10856, 52, 34],
                    [10857, 52, 34], [10858, 48, 29], [10859, 53, 29], [10860, 64, 31], [10861, 60, 31],
                    [10862, 47, 29], [10863, 27, 23], [10864, 71, 32], [10865, 48, 20], [10866, 38, 23],
                    [10867, 49, 28], [10868, 48, 27], [10869, 54, 20], [10870, 52, 25], [10871, 53, 26],
                    [10872, 51, 20], [10873, 62, 21], [10874, 54, 20], [10875, 50, 23], [10876, 62, 27],
                    [10877, 75, 32], [10878, 52, 27], [10879, 53, 25], [10880, 55, 25], [10881, 40, 19],
                    [10882, 62, 24], [10883, 75, 25], [10884, 85, 26], [10885, 40, 35], [10886, 51, 26],
                    [10887, 41, 26], [10888, 65, 33], [10889, 50, 29], [10890, 43, 22], [10891, 30, 20],
                    [10892, 38, 24], [10893, 54, 44], [10894, 51, 44], [10895, 76, 37], [10896, 49, 39],
                    [10897, 53, 40], [10898, 52, 39], [10899, 45, 23], [10900, 42, 21], [10901, 44, 18],
                    [10902, 47, 19], [10903, 47, 23], [10904, 49, 24], [10905, 40, 24], [10906, 53, 38],
                    [10907, 53, 37], [10908, 48, 21], [10909, 74, 23], [10910, 49, 24], [10911, 64, 54],
                    [10912, 63, 54], [10913, 42, 40], [10914, 82, 38], [10915, 55, 44], [10916, 59, 43],
                    [10917, 66, 43], [10918, 37, 32], [10978, 49, 19], [10979, 45, 28], [10980, 47, 26], [11091, 9, 6],
                    [11092, 12, 8], [11093, 11, 6], [11094, 15, 8], [11095, 8, 6], [11096, 23, 18], [11097, 10, 6],
                    [11098, 9, 6], [11099, 41, 33], [11100, 9, 6], [11101, 11, 7], [11102, 10, 6], [11103, 15, 9],
                    [11104, 50, 31], [11105, 31, 30], [11106, 27, 17], [11107, 18, 10], [11108, 9, 5], [11109, 21, 18],
                    [11110, 17, 9], [11111, 7, 8], [11112, 28, 18], [11113, 24, 15], [11114, 37, 26], [11115, 8, 5],
                    [11116, 8, 5], [11117, 9, 7], [11118, 15, 10], [11119, 36, 22], [11120, 29, 21], [11121, 10, 8],
                    [11122, 10, 7], [11123, 14, 8], [11124, 9, 7], [11125, 28, 15], [11126, 13, 8], [11127, 7, 7],
                    [11128, 12, 6], [11129, 7, 5], [11130, 15, 10], [11131, 7, 6], [11132, 19, 12], [11133, 11, 7],
                    [11134, 7, 4], [11135, 49, 27], [11136, 10, 7], [11137, 7, 5], [11138, 20, 14], [11139, 12, 8],
                    [11140, 11, 9], [11141, 10, 6], [11142, 9, 6], [11143, 8, 5], [11144, 10, 7], [11145, 27, 22],
                    [11146, 8, 6], [11147, 5, 3], [11148, 31, 27], [11149, 15, 11], [11150, 23, 17], [11151, 14, 12],
                    [11152, 14, 12], [11153, 14, 9], [11154, 26, 16], [11155, 17, 10], [11156, 11, 10], [11157, 12, 10],
                    [11158, 12, 10], [11159, 13, 12], [11160, 14, 10], [11161, 13, 10], [11162, 12, 11],
                    [11163, 12, 12], [11164, 17, 16], [11165, 12, 9], [11166, 47, 28], [11167, 83, 47], [11168, 23, 16],
                    [11169, 10, 9], [11170, 12, 10], [11171, 14, 11], [11172, 9, 9], [11173, 14, 12], [11174, 8, 7],
                    [11175, 7, 7], [11176, 5, 5], [11177, 18, 15], [11178, 8, 8], [11179, 11, 9], [11180, 10, 7],
                    [11181, 15, 13], [11182, 12, 11], [11183, 12, 10], [11184, 108, 83], [11185, 108, 83],
                    [11186, 108, 83], [11187, 108, 83], [11188, 108, 83], [11189, 74, 108], [11190, 93, 80],
                    [11191, 93, 80], [11192, 93, 80], [11193, 93, 80], [11194, 50, 35], [11195, 21, 32],
                    [11196, 94, 61], [11197, 116, 50], [11198, 40, 29], [11199, 60, 33], [11200, 58, 29],
                    [11201, 10, 11], [11202, 58, 35], [11203, 13, 14], [11204, 86, 52], [11205, 123, 85],
                    [11206, 68, 57], [11207, 11, 12], [11208, 30, 19], [11292, 14, 18], [11293, 10, 12],
                    [11294, 12, 15], [11295, 12, 15], [11296, 83, 63], [11297, 100, 74], [11298, 26, 25],
                    [11299, 40, 25], [11300, 21, 29], [11301, 58, 53], [11302, 32, 30], [11303, 24, 24],
                    [11304, 32, 22], [11306, 15, 23], [11307, 18, 24], [11313, 19, 24], [11314, 37, 35],
                    [11315, 39, 36], [11316, 29, 27], [11317, 40, 39], [11318, 20, 24], [11319, 24, 22],
                    [11320, 23, 21], [11321, 37, 41], [11322, 90, 42], [11323, 29, 33], [11324, 30, 21],
                    [11325, 34, 24], [11326, 32, 36], [11327, 33, 25], [11328, 32, 37], [11329, 27, 32],
                    [11330, 31, 29], [11331, 39, 41], [11332, 23, 26], [11333, 46, 32], [11334, 52, 33],
                    [11335, 33, 24], [11336, 15, 17], [11337, 28, 30], [11338, 37, 36], [11339, 42, 36],
                    [11340, 39, 38], [11341, 56, 50], [11342, 45, 36], [11343, 40, 43], [11344, 38, 43],
                    [11345, 32, 40], [11346, 45, 36], [11347, 38, 32], [11348, 56, 47], [11349, 22, 19],
                    [11350, 47, 54], [11351, 35, 38], [11352, 27, 36], [11353, 46, 43], [11354, 31, 25],
                    [11355, 41, 33], [11356, 26, 21], [11357, 30, 27], [11358, 19, 25], [11359, 62, 48],
                    [11360, 40, 25], [11361, 58, 53], [11362, 32, 30], [11363, 10, 10], [11364, 12, 13],
                    [11365, 29, 24]]],
            [2004, [[7, 27, 26], [25, 13, 9], [48, 60, 40], [49, 28, 20], [51, 30, 26], [62, 18, 26], [65, 19, 17],
                    [78, 21, 18], [82, 12, 17], [83, 28, 32], [99, 26, 26], [101, 50, 41], [119, 34, 24], [138, 44, 29],
                    [163, 32, 30], [166, 29, 28], [190, 27, 26], [200, 34, 26], [204, 11, 21], [211, 19, 37],
                    [216, 21, 18], [218, 42, 23], [220, 16, 17], [226, 19, 15], [231, 46, 39], [233, 17, 18],
                    [234, 11, 14], [240, 45, 27], [243, 49, 28], [246, 37, 26], [272, 36, 15], [282, 37, 28],
                    [286, 23, 24], [305, 22, 26], [308, 11, 31], [310, 18, 18], [312, 19, 18], [314, 17, 24],
                    [324, 32, 28], [327, 36, 31], [329, 32, 23], [346, 45, 36], [355, 41, 27], [361, 27, 26],
                    [378, 18, 19], [379, 14, 12], [389, 25, 27], [392, 18, 18], [399, 62, 30], [424, 19, 18],
                    [425, 14, 20], [428, 26, 19], [430, 19, 22], [432, 60, 36], [436, 39, 32], [471, 18, 19],
                    [479, 50, 40], [480, 50, 28], [487, 25, 23], [494, 16, 17], [497, 9, 14], [503, 72, 20],
                    [504, 12, 10], [505, 39, 24], [519, 16, 24], [525, 19, 26], [536, 25, 18], [541, 100, 40],
                    [545, 21, 25], [568, 18, 18], [569, 73, 27], [570, 24, 19], [577, 39, 22], [585, 47, 40],
                    [590, 44, 51], [593, 33, 29], [597, 33, 14], [604, 41, 26], [608, 24, 18], [612, 29, 28],
                    [618, 20, 18], [628, 30, 27], [631, 31, 22], [660, 50, 33], [662, 49, 41], [663, 57, 29],
                    [669, 21, 17], [678, 18, 23], [686, 13, 19], [691, 23, 27], [694, 32, 25], [695, 60, 45],
                    [700, 46, 35], [703, 11, 15], [716, 50, 45], [724, 18, 34], [734, 17, 31], [751, 29, 20],
                    [754, 28, 27], [766, 77, 41], [769, 49, 31], [785, 45, 36], [790, 30, 23], [801, 17, 18],
                    [803, 29, 26], [805, 28, 22], [820, 53, 33], [822, 15, 19], [826, 19, 18], [827, 10, 13],
                    [835, 43, 25], [843, 31, 27], [845, 45, 35], [848, 23, 19], [865, 62, 26], [871, 34, 19],
                    [878, 7, 6], [882, 38, 27], [894, 26, 12], [913, 18, 18], [915, 45, 32], [922, 32, 40],
                    [926, 45, 19], [938, 11, 12], [940, 11, 13], [941, 30, 25], [949, 52, 30], [950, 14, 18],
                    [964, 11, 15], [969, 43, 35], [971, 18, 16], [978, 37, 38], [979, 18, 18], [985, 69, 33],
                    [993, 59, 31], [998, 40, 28], [1003, 8, 6], [1008, 35, 36], [1016, 11, 14], [1030, 9, 13],
                    [1048, 36, 35], [1056, 19, 36], [1059, 35, 34], [1095, 18, 18], [1097, 30, 17], [1106, 71, 32],
                    [1111, 40, 40], [1131, 46, 34], [1132, 11, 13], [1136, 34, 32], [1142, 22, 20], [1144, 24, 19],
                    [1145, 27, 22], [1150, 32, 21], [1155, 25, 26], [1156, 25, 17], [1157, 36, 31], [1159, 78, 34],
                    [1167, 21, 19], [1169, 26, 23], [1174, 27, 37], [1177, 26, 22], [1186, 15, 16], [1194, 82, 37],
                    [1200, 17, 19], [1203, 11, 17], [1213, 21, 16], [1219, 26, 16], [1221, 18, 17], [1226, 18, 23],
                    [1234, 12, 14], [1235, 23, 18], [1238, 14, 23], [1247, 46, 26], [1254, 46, 23], [1268, 34, 27],
                    [1275, 28, 12], [1281, 14, 18], [1295, 38, 36], [1302, 43, 48], [1303, 69, 33], [1320, 35, 30],
                    [1334, 73, 44], [1358, 51, 32], [1359, 32, 27], [1370, 13, 20], [1396, 11, 19], [1420, 53, 43],
                    [1445, 67, 24], [1456, 25, 25], [1466, 31, 25], [1473, 13, 18], [1475, 56, 28], [1476, 48, 33],
                    [1477, 28, 17], [1481, 38, 24], [1484, 40, 27], [1486, 13, 13], [1491, 11, 8], [1493, 25, 19],
                    [1507, 33, 28], [1510, 16, 19], [1511, 27, 26], [1515, 20, 15], [1522, 24, 18], [1525, 33, 33],
                    [1527, 31, 27], [1530, 69, 44], [1536, 15, 18], [1537, 61, 44], [1548, 34, 32], [1557, 29, 24],
                    [1562, 41, 30], [1568, 29, 27], [1577, 25, 17], [1580, 39, 30], [1582, 29, 23], [1587, 17, 16],
                    [1589, 46, 24], [1598, 11, 8], [1610, 25, 26], [1628, 30, 17], [1635, 17, 16], [1638, 41, 33],
                    [1644, 101, 57], [1645, 48, 30], [1659, 24, 21], [1662, 13, 11], [1673, 73, 39], [1680, 115, 44],
                    [1685, 33, 30], [1704, 14, 17], [1717, 47, 32], [1730, 17, 11], [1763, 22, 21], [1769, 46, 38],
                    [1771, 18, 18], [1772, 10, 13], [1774, 22, 23], [1786, 18, 22], [1794, 29, 29], [1795, 12, 9],
                    [1797, 50, 32], [1798, 35, 40], [1804, 29, 17], [1812, 14, 15], [1818, 18, 18], [1824, 26, 29],
                    [1825, 18, 23], [1841, 37, 36], [1845, 36, 27], [1848, 46, 26], [1864, 104, 62], [1866, 51, 27],
                    [1882, 16, 18], [1891, 31, 27], [1894, 32, 15], [1903, 70, 30], [1915, 37, 30], [1916, 19, 17],
                    [1921, 14, 11], [1930, 10, 8], [1933, 11, 14], [1950, 19, 28], [1952, 168, 68], [1962, 12, 14],
                    [1965, 62, 37], [1995, 44, 25], [2000, 30, 26], [2001, 31, 23], [2006, 21, 19], [2011, 12, 16],
                    [2017, 44, 30], [2021, 25, 26], [2023, 11, 11], [2025, 58, 46], [2028, 45, 31], [2029, 35, 28],
                    [2035, 51, 28], [2048, 14, 28], [2056, 23, 41], [2057, 58, 31], [2064, 55, 30], [2081, 29, 17],
                    [2084, 61, 26], [2098, 13, 16], [2099, 30, 22], [2127, 15, 13], [2128, 28, 27], [2138, 24, 23],
                    [2142, 9, 10], [2171, 24, 23], [2178, 12, 16], [2180, 34, 26], [2190, 25, 19], [2198, 19, 15],
                    [2201, 27, 27], [2208, 72, 37], [2213, 39, 30], [2224, 33, 26], [2227, 17, 19], [2232, 27, 27],
                    [2238, 30, 26], [2244, 21, 21], [2250, 38, 25], [2258, 26, 26], [2277, 26, 19], [2280, 13, 10],
                    [2282, 17, 51], [2300, 50, 40], [2303, 28, 24], [2311, 34, 31], [2316, 46, 32], [2343, 36, 25],
                    [2352, 36, 31], [2367, 39, 27], [2371, 48, 28], [2384, 25, 31], [2404, 26, 26], [2429, 12, 12],
                    [2433, 41, 20], [2435, 14, 11], [2443, 47, 32], [2458, 28, 21], [2459, 25, 15], [2467, 11, 14],
                    [2483, 41, 45], [2485, 12, 14], [2488, 26, 23], [2494, 31, 27], [2497, 30, 18], [2500, 23, 17],
                    [2501, 52, 30], [2505, 38, 25], [2524, 10, 9], [2533, 10, 16], [2539, 78, 24], [2540, 16, 20],
                    [2543, 16, 19], [2547, 15, 28], [2554, 10, 10], [2562, 91, 32], [2564, 27, 18], [2574, 66, 36],
                    [2576, 68, 36], [2585, 42, 33], [2595, 36, 29], [2603, 54, 32], [2606, 18, 14], [2612, 36, 25],
                    [2617, 32, 21], [2619, 11, 11], [2627, 49, 28], [2635, 12, 16], [2647, 28, 24], [2656, 19, 18],
                    [2670, 36, 25], [2671, 41, 44], [2687, 40, 21], [2692, 48, 28], [2695, 12, 13], [2720, 29, 33],
                    [2723, 34, 40], [2758, 30, 26], [2762, 52, 33], [2775, 47, 28], [2785, 12, 14], [2798, 12, 17],
                    [2822, 23, 18], [2823, 22, 18], [2827, 12, 17], [2832, 16, 16], [2833, 37, 25], [2835, 25, 23],
                    [2836, 25, 17], [2838, 31, 26], [2846, 25, 35], [2851, 19, 14], [2872, 18, 19], [2879, 21, 18],
                    [2880, 34, 23], [2883, 35, 38], [2901, 44, 36], [2904, 57, 25], [2910, 18, 18], [2914, 39, 26],
                    [2922, 13, 14], [2929, 43, 28], [2934, 19, 18], [2935, 50, 27], [2950, 33, 27], [2969, 20, 15],
                    [2973, 32, 38], [2974, 32, 20], [2978, 27, 26], [2991, 34, 30], [3016, 34, 26], [3019, 39, 21],
                    [3027, 16, 17], [3033, 47, 31], [3035, 19, 19], [3046, 50, 22], [3053, 66, 48], [3066, 45, 28],
                    [3070, 37, 31], [3077, 48, 41], [3086, 100, 34], [3091, 13, 14], [3092, 48, 28], [3098, 33, 28],
                    [3112, 49, 26], [3114, 54, 29], [3119, 11, 24], [3126, 40, 27], [3133, 38, 29], [3134, 32, 35],
                    [3137, 28, 27], [3142, 28, 33], [3148, 32, 23], [3155, 23, 19], [3158, 15, 16], [3161, 18, 18],
                    [3164, 47, 32], [3167, 19, 25], [3171, 31, 17], [3182, 134, 43], [3206, 47, 27], [3221, 38, 32],
                    [3228, 42, 27], [3231, 18, 18], [3234, 40, 23], [3246, 81, 28], [3248, 16, 22], [3252, 42, 26],
                    [3254, 22, 25], [3256, 25, 20], [3264, 25, 26], [3273, 60, 36], [3274, 19, 17], [3280, 30, 27],
                    [3289, 90, 54], [3301, 36, 33], [3306, 19, 23], [3308, 52, 31], [3309, 35, 36], [3320, 41, 42],
                    [3321, 50, 28], [3326, 18, 19], [3327, 38, 36], [3331, 30, 18], [3346, 33, 37], [3348, 47, 30],
                    [3357, 12, 17], [3363, 51, 26], [3364, 11, 15], [3372, 45, 30], [3382, 30, 22], [3418, 55, 30],
                    [3434, 7, 7], [3438, 46, 25], [3439, 26, 21], [3451, 37, 37], [3454, 11, 10], [3459, 22, 19],
                    [3462, 48, 23], [3469, 24, 17], [3494, 11, 13], [3498, 15, 19], [3503, 50, 35], [3511, 18, 25],
                    [3515, 13, 34], [3517, 45, 28], [3531, 24, 18], [3541, 23, 23], [3557, 10, 13], [3559, 38, 28],
                    [3569, 47, 47], [3579, 18, 27], [3590, 21, 23], [3593, 51, 49], [3598, 16, 12], [3602, 18, 18],
                    [3608, 37, 24], [3653, 20, 18], [3659, 37, 27], [3661, 26, 26], [3669, 11, 17], [3679, 17, 26],
                    [3700, 19, 20], [3718, 45, 32], [3726, 10, 12], [3729, 111, 43], [3731, 48, 60], [3751, 34, 24],
                    [3755, 30, 23], [3765, 20, 18], [3777, 25, 20], [3782, 58, 27], [3796, 26, 26], [3827, 44, 26],
                    [3828, 17, 20], [3833, 63, 33], [3845, 47, 26], [3854, 29, 23], [3859, 11, 15], [3870, 48, 31],
                    [3874, 36, 27], [3884, 49, 28], [3889, 58, 24], [3905, 25, 25], [3915, 24, 24], [3921, 24, 26],
                    [3925, 48, 35], [3932, 21, 26], [3942, 28, 25], [3943, 25, 23], [3947, 36, 30], [3956, 40, 48],
                    [3960, 56, 44], [3969, 70, 40], [3970, 44, 30], [3972, 142, 68], [3976, 17, 13], [3985, 23, 20],
                    [3988, 22, 25], [3992, 66, 32], [3993, 10, 12], [4015, 48, 26], [4022, 44, 30], [4023, 27, 27],
                    [4026, 26, 16], [4027, 65, 31], [4028, 22, 27], [4031, 16, 14], [4034, 56, 44], [4038, 65, 32],
                    [4043, 17, 16], [4047, 39, 32], [4074, 17, 23], [4082, 60, 32], [4084, 11, 16], [4091, 37, 28],
                    [4106, 41, 29], [4107, 61, 27], [4109, 17, 17], [4111, 16, 13], [4122, 46, 41], [4124, 33, 28],
                    [4125, 12, 14], [4152, 87, 42], [4156, 16, 17], [4165, 32, 32], [4169, 26, 20], [4173, 11, 15],
                    [4176, 10, 13], [4199, 73, 33], [4209, 36, 34], [4229, 23, 20], [4242, 27, 25], [4246, 11, 19],
                    [4272, 41, 26], [4283, 25, 19], [4285, 25, 30], [4298, 34, 37], [4299, 31, 25], [4301, 47, 49],
                    [4310, 28, 21], [4312, 44, 26], [4325, 53, 25], [4338, 25, 26], [4350, 19, 18], [4353, 23, 23],
                    [4358, 12, 13], [4362, 72, 46], [4380, 15, 17], [4382, 88, 37], [4386, 13, 15], [4413, 11, 11],
                    [4414, 14, 21], [4426, 10, 13], [4438, 43, 30], [4440, 39, 27], [4442, 13, 17], [4454, 18, 17],
                    [4464, 43, 25], [4470, 23, 24], [4471, 18, 18], [4477, 26, 28], [4487, 20, 25], [4491, 42, 27],
                    [4495, 25, 20], [4500, 18, 18], [4504, 53, 34], [4506, 17, 18], [4508, 25, 22], [4515, 50, 41],
                    [4518, 43, 31], [4521, 42, 27], [4524, 27, 27], [4532, 26, 18], [4536, 19, 18], [4542, 28, 20],
                    [4545, 42, 31], [4552, 14, 16], [4558, 26, 23], [4572, 26, 23], [4591, 31, 21], [4602, 20, 25],
                    [4610, 58, 28], [4613, 33, 29], [4616, 21, 18], [4617, 110, 46], [4618, 24, 21], [4623, 14, 17],
                    [4626, 29, 17], [4634, 27, 25], [4638, 93, 32], [4643, 20, 19], [4644, 13, 17], [4648, 36, 25],
                    [4660, 58, 30], [4668, 52, 29], [4670, 49, 32], [4676, 13, 17], [4684, 20, 16], [4689, 36, 25],
                    [4703, 10, 14], [4710, 8, 6], [4717, 18, 18], [4724, 25, 18], [4728, 22, 20], [4732, 58, 65],
                    [4734, 14, 15], [4738, 34, 40], [4745, 20, 19], [4747, 49, 27], [4749, 38, 27], [4762, 39, 37],
                    [4764, 22, 29], [4777, 20, 20], [4789, 45, 25], [4791, 20, 25], [4794, 21, 17], [4801, 10, 16],
                    [4805, 15, 18], [4820, 44, 38], [4826, 16, 18], [4828, 63, 44], [4832, 12, 15], [4835, 22, 21],
                    [4839, 29, 19], [4840, 47, 29], [4849, 18, 18], [4863, 39, 32], [4864, 18, 20], [4865, 28, 18],
                    [4871, 15, 18], [4877, 22, 18], [4880, 17, 20], [4881, 29, 28], [4888, 41, 38], [4897, 15, 20],
                    [4912, 10, 16], [4914, 28, 18], [4915, 18, 16], [4918, 20, 25], [4926, 47, 43], [4927, 16, 18],
                    [4931, 17, 18], [4939, 22, 21], [4940, 36, 20], [4944, 13, 14], [4950, 52, 27], [4951, 30, 29],
                    [4955, 37, 27], [4957, 29, 23], [4960, 88, 42], [4973, 26, 26], [4975, 26, 26], [4976, 11, 15],
                    [4978, 54, 41], [4983, 18, 17], [4990, 37, 24], [4992, 23, 21], [4997, 24, 20], [4998, 70, 27],
                    [5006, 76, 34], [5009, 18, 18], [5011, 50, 35], [5012, 36, 41], [5013, 16, 16], [5017, 26, 26],
                    [5019, 42, 28], [5031, 10, 13], [5035, 27, 27], [5038, 11, 16], [5046, 45, 27], [5048, 29, 25],
                    [5050, 16, 13], [5051, 11, 11], [5053, 27, 21], [5062, 26, 33], [5063, 19, 24], [5071, 25, 26],
                    [5073, 54, 35], [5075, 21, 27], [5079, 16, 18], [5081, 36, 16], [5091, 74, 36], [5092, 11, 14],
                    [5095, 14, 15], [5102, 19, 12], [5107, 90, 33], [5108, 19, 25], [5116, 32, 28], [5126, 26, 20],
                    [5127, 17, 18], [5130, 50, 45], [5149, 19, 17], [5150, 49, 32], [5159, 64, 26], [5162, 21, 20],
                    [5173, 35, 22], [5181, 17, 18], [5184, 30, 19], [5185, 26, 15], [5186, 12, 15], [5187, 12, 12],
                    [5188, 11, 13], [5189, 17, 10], [5217, 44, 31], [5219, 17, 44], [5220, 14, 47], [5221, 11, 35],
                    [5222, 15, 20], [5223, 11, 28], [5224, 15, 40], [5225, 15, 46], [5226, 12, 49], [5227, 28, 58],
                    [5228, 19, 57], [5229, 11, 40], [5230, 15, 36], [5231, 12, 28], [5232, 18, 50], [5233, 23, 70],
                    [5234, 10, 23], [5235, 35, 39], [5236, 15, 37], [5237, 23, 46], [5238, 15, 35], [5239, 22, 56],
                    [5240, 18, 61], [5241, 26, 59], [5242, 18, 38], [5243, 25, 62], [5244, 19, 65], [5245, 24, 62],
                    [5247, 29, 13], [5248, 30, 18], [5273, 24, 15], [5276, 25, 36], [5279, 18, 20], [5287, 12, 12],
                    [5290, 19, 18], [5298, 11, 11], [5299, 16, 17], [5303, 28, 19], [5305, 22, 19], [5314, 18, 20],
                    [5315, 17, 21], [5317, 30, 39], [5321, 20, 19], [5323, 13, 18], [5328, 16, 16], [5332, 17, 20],
                    [5333, 11, 13], [5336, 13, 14], [5337, 15, 16], [5338, 23, 20], [5339, 19, 19], [5340, 22, 24],
                    [5343, 13, 12], [5344, 33, 32], [5347, 17, 18], [5349, 19, 20], [5350, 17, 21], [5353, 15, 18],
                    [5355, 17, 26], [5357, 20, 16], [5359, 16, 19], [5366, 23, 19], [5371, 26, 26], [5372, 19, 18],
                    [5375, 15, 15], [5377, 14, 15], [5383, 20, 20], [5385, 24, 19], [5387, 14, 13], [5400, 14, 13],
                    [5403, 19, 19], [5404, 19, 19], [5407, 17, 19], [5408, 16, 18], [5411, 18, 16], [5412, 18, 15],
                    [5414, 11, 13], [5415, 29, 31], [5418, 22, 26], [5420, 15, 15], [5421, 14, 12], [5422, 20, 24],
                    [5425, 16, 17], [5426, 16, 20], [5428, 16, 19], [5431, 21, 21], [5432, 20, 23], [5434, 13, 13],
                    [5436, 16, 18], [5437, 23, 19], [5440, 25, 21], [5441, 22, 25], [5444, 21, 27], [5447, 17, 18],
                    [5449, 20, 23], [5450, 21, 22], [5452, 19, 23], [5453, 24, 23], [5454, 12, 13], [5455, 19, 16],
                    [5457, 13, 17], [5459, 19, 19], [5462, 18, 20], [5463, 12, 14], [5464, 16, 15], [5465, 19, 19],
                    [5472, 17, 20], [5473, 15, 18], [5476, 14, 17], [5479, 18, 16], [5480, 26, 22], [5482, 15, 16],
                    [5486, 18, 18], [5489, 23, 33], [5492, 21, 29], [5494, 20, 22], [5495, 21, 19], [5498, 29, 28],
                    [5499, 23, 19], [5501, 21, 28], [5505, 15, 20], [5508, 19, 23], [5528, 16, 15], [5532, 19, 18],
                    [5534, 14, 13], [5539, 15, 16], [5541, 22, 18], [5544, 18, 22], [5545, 15, 18], [5547, 24, 22],
                    [5550, 16, 15], [5571, 19, 16], [5944, 7, 7], [5945, 8, 9], [5946, 6, 5], [5962, 68, 76],
                    [5989, 221, 179], [5990, 221, 179], [5991, 221, 179], [5992, 221, 200], [5993, 221, 179],
                    [5996, 45, 25], [6068, 45, 33], [6069, 48, 38], [6070, 48, 38], [6071, 29, 23], [6073, 30, 28],
                    [6074, 35, 28], [6075, 48, 38], [6076, 35, 30], [6077, 30, 26], [6078, 35, 35], [6079, 37, 29],
                    [6080, 35, 34], [6081, 24, 24], [6082, 35, 28], [6083, 32, 25], [6084, 43, 28], [6085, 38, 30],
                    [6087, 83, 26], [6088, 34, 30], [6089, 30, 26], [6090, 48, 31], [6091, 29, 25], [6092, 32, 29],
                    [6093, 35, 28], [6094, 35, 28], [6095, 24, 21], [6096, 32, 23], [6097, 37, 26], [6098, 32, 25],
                    [6099, 43, 28], [6100, 35, 28], [6101, 35, 23], [6102, 24, 22], [6103, 32, 25], [6104, 38, 24],
                    [6105, 43, 28], [6106, 27, 24], [6108, 35, 27], [6109, 21, 23], [6110, 32, 28], [6111, 15, 21],
                    [6112, 29, 27], [6113, 23, 23], [6114, 23, 23], [6115, 23, 26], [6116, 31, 27], [6117, 26, 25],
                    [6118, 31, 29], [6119, 29, 27], [6120, 21, 22], [6121, 28, 28], [6122, 29, 24], [6123, 23, 23],
                    [6124, 31, 25], [6125, 26, 25], [6126, 28, 28], [6127, 28, 28], [6128, 24, 29], [6130, 29, 27],
                    [6131, 32, 25], [6132, 35, 28], [6133, 32, 25], [6134, 32, 25], [6135, 70, 56], [6136, 61, 49],
                    [6137, 18, 20], [6138, 26, 28], [6139, 30, 27], [6140, 21, 24], [6141, 30, 30], [6142, 24, 27],
                    [6143, 26, 25], [6145, 31, 30], [6146, 15, 21], [6147, 21, 28], [6148, 21, 25], [6149, 28, 28],
                    [6150, 16, 21], [6151, 21, 21], [6152, 19, 21], [6153, 20, 23], [6154, 28, 28], [6155, 21, 23],
                    [6156, 24, 25], [6157, 33, 29], [6158, 24, 23], [6159, 32, 28], [6160, 21, 22], [6161, 16, 20],
                    [6162, 18, 21], [6163, 43, 36], [6164, 30, 28], [6165, 26, 24], [6166, 40, 27], [6167, 43, 35],
                    [6244, 60, 33], [6353, 40, 40], [6357, 40, 22], [6358, 91, 41], [6359, 20, 20], [6360, 74, 55],
                    [6361, 74, 62], [6362, 50, 47], [6363, 50, 50], [6364, 74, 56], [6365, 86, 63], [6366, 86, 63],
                    [6367, 46, 47], [6368, 74, 56], [6369, 53, 50], [6370, 73, 54], [6371, 74, 60], [6372, 86, 63],
                    [6373, 86, 68], [6374, 74, 55], [6375, 82, 55], [6376, 53, 47], [6377, 81, 60], [6378, 50, 47],
                    [6379, 53, 49], [6380, 53, 45], [6381, 53, 47], [6382, 74, 55], [6383, 53, 47], [6384, 74, 56],
                    [6385, 74, 47], [6386, 74, 55], [6387, 73, 59], [6388, 74, 54], [6389, 86, 63], [6390, 74, 56],
                    [6391, 48, 44], [6392, 74, 55], [6393, 81, 60], [6394, 86, 63], [6395, 74, 56], [6396, 86, 63],
                    [6397, 74, 55], [6398, 92, 68], [6399, 86, 63], [6400, 70, 52], [6401, 53, 51], [6402, 86, 63],
                    [6403, 92, 68], [6404, 86, 63], [6405, 86, 63], [6406, 74, 55], [6407, 74, 56], [6408, 74, 56],
                    [6409, 74, 55], [6410, 74, 56], [6411, 68, 50], [6412, 74, 55], [6413, 92, 68], [6414, 82, 55],
                    [6415, 74, 55], [6416, 86, 63], [6417, 86, 63], [6418, 92, 68], [6419, 86, 68], [6420, 92, 68],
                    [6421, 74, 55], [6422, 74, 56], [6423, 27, 25], [6424, 53, 51], [6425, 53, 47], [6426, 74, 60],
                    [6427, 92, 68], [6428, 82, 60], [6429, 92, 67], [6430, 50, 51], [6431, 74, 56], [6432, 74, 60],
                    [6433, 44, 44], [6434, 74, 55], [6435, 51, 43], [6436, 82, 55], [6437, 86, 63], [6438, 74, 55],
                    [6439, 74, 55], [6440, 82, 60], [6441, 69, 51], [6442, 48, 44], [6443, 74, 55], [6444, 60, 62],
                    [6445, 74, 55], [6446, 86, 63], [6447, 47, 36], [6448, 74, 55], [6449, 86, 68], [6450, 82, 60],
                    [6451, 86, 68], [6452, 82, 55], [6453, 74, 55], [6454, 74, 55], [6455, 74, 55], [6456, 74, 55],
                    [6457, 31, 30], [6458, 22, 25], [6459, 92, 63], [6460, 82, 60], [6461, 74, 55], [6462, 73, 59],
                    [6463, 74, 60], [6464, 92, 68], [6465, 86, 68], [6466, 73, 54], [6467, 80, 60], [6468, 86, 63],
                    [6469, 74, 55], [6470, 74, 56], [6471, 74, 55], [6472, 86, 63], [6473, 86, 63], [6474, 74, 55],
                    [6475, 74, 55], [6476, 74, 55], [6477, 101, 76], [6478, 74, 55], [6479, 74, 55], [6480, 74, 55],
                    [6481, 86, 63], [6482, 86, 68], [6483, 74, 55], [6484, 53, 39], [6485, 69, 56], [6486, 86, 63],
                    [6487, 74, 56], [6488, 74, 56], [6489, 74, 55], [6490, 74, 55], [6491, 74, 55], [6492, 26, 25],
                    [6493, 74, 56], [6494, 26, 24], [6495, 69, 51], [6496, 74, 56], [6498, 92, 68], [6499, 82, 60],
                    [6500, 53, 47], [6501, 74, 56], [6502, 46, 47], [6503, 74, 55], [6504, 74, 62], [6505, 74, 55],
                    [6506, 74, 60], [6507, 86, 63], [6508, 86, 63], [6509, 74, 56], [6510, 92, 68], [6511, 74, 56],
                    [6512, 74, 56], [6513, 20, 19], [6514, 72, 53], [6515, 74, 60], [6516, 53, 43], [6517, 29, 24],
                    [6518, 74, 60], [6519, 81, 60], [6520, 92, 68], [6521, 42, 40], [6522, 74, 55], [6523, 92, 68],
                    [6524, 82, 61], [6525, 74, 56], [6526, 86, 63], [6527, 74, 56], [6528, 74, 55], [6529, 81, 62],
                    [6530, 70, 52], [6531, 86, 68], [6532, 74, 55], [6533, 74, 55], [6534, 74, 60], [6535, 86, 63],
                    [6536, 29, 27], [6537, 86, 63], [6538, 86, 68], [6539, 74, 55], [6540, 86, 68], [6541, 86, 63],
                    [6542, 86, 63], [6543, 86, 63], [6544, 86, 63], [6546, 86, 63], [6547, 92, 68], [6548, 86, 63],
                    [6549, 86, 68], [6550, 86, 63], [6551, 86, 63], [6552, 86, 68], [6553, 86, 63], [6554, 86, 63],
                    [6555, 86, 63], [6556, 86, 63], [6557, 86, 63], [6558, 74, 55], [6559, 86, 63], [6560, 74, 55],
                    [6561, 86, 68], [6562, 86, 63], [6563, 86, 63], [6564, 86, 63], [6565, 81, 62], [6566, 74, 50],
                    [6567, 86, 63], [6568, 74, 56], [6569, 74, 56], [6570, 86, 63], [6572, 86, 63], [6573, 74, 56],
                    [6574, 74, 55], [6575, 73, 54], [6576, 74, 55], [6577, 74, 56], [6578, 74, 55], [6579, 86, 63],
                    [6580, 74, 56], [6581, 80, 60], [6582, 74, 55], [6583, 81, 60], [6584, 101, 76], [6585, 74, 56],
                    [6586, 74, 56], [6587, 74, 56], [6588, 74, 55], [6589, 74, 55], [6590, 101, 76], [6591, 86, 63],
                    [6592, 86, 63], [6593, 86, 63], [6594, 86, 63], [6595, 74, 55], [6596, 74, 55], [6597, 86, 63],
                    [6598, 86, 63], [6599, 82, 60], [6600, 74, 55], [6601, 86, 63], [6602, 74, 55], [6603, 50, 47],
                    [6604, 86, 68], [6605, 74, 55], [6606, 74, 56], [6607, 81, 55], [6608, 74, 55], [6609, 74, 55],
                    [6610, 74, 55], [6611, 50, 47], [6612, 74, 60], [6613, 74, 55], [6614, 29, 27], [6615, 74, 56],
                    [6616, 74, 55], [6617, 30, 28], [6618, 74, 56], [6619, 86, 63], [6620, 86, 63], [6621, 74, 55],
                    [6622, 74, 56], [6623, 82, 60], [6624, 92, 63], [6625, 86, 63], [6626, 92, 68], [6627, 74, 55],
                    [6628, 86, 68], [6629, 50, 51], [6630, 53, 51], [6631, 40, 40], [6633, 27, 27], [6634, 32, 28],
                    [6635, 38, 30], [6636, 52, 42], [6637, 43, 28], [6638, 48, 33], [6639, 38, 35], [6640, 25, 65],
                    [6643, 50, 27], [6649, 43, 29], [6650, 43, 28], [6651, 30, 21], [6652, 39, 29], [6653, 40, 32],
                    [6654, 29, 27], [6655, 29, 23], [6656, 31, 27], [6657, 38, 30], [6660, 32, 22], [6661, 26, 25],
                    [6662, 35, 29], [6663, 29, 27], [6664, 34, 30], [6665, 28, 28], [6666, 28, 25], [6667, 29, 27],
                    [6668, 29, 21], [6669, 37, 30], [6670, 30, 26], [6671, 39, 27], [6672, 32, 24], [6673, 35, 25],
                    [6674, 31, 29], [6675, 30, 26], [6676, 40, 35], [6677, 28, 28], [6678, 30, 26], [6679, 61, 49],
                    [6680, 27, 24], [6682, 26, 24], [6683, 28, 28], [6684, 27, 30], [6685, 23, 25], [6686, 21, 24],
                    [6687, 23, 26], [6688, 21, 24], [6689, 23, 26], [6690, 21, 24], [6697, 33, 27], [6699, 25, 78],
                    [6700, 80, 38], [6701, 75, 45], [6702, 35, 23], [6704, 90, 48], [6715, 51, 38], [6716, 30, 32],
                    [6718, 31, 55], [6722, 35, 32], [6723, 85, 50], [6726, 45, 70], [6728, 55, 35], [6734, 70, 45],
                    [6737, 31, 90], [6738, 75, 53], [6741, 17, 15], [6748, 26, 24], [6749, 27, 26], [6750, 39, 36],
                    [6752, 21, 24], [6753, 33, 30], [6754, 32, 28], [6755, 38, 37], [6756, 33, 33], [6757, 29, 28],
                    [6758, 33, 39], [6759, 21, 24], [6760, 38, 37], [6761, 39, 36], [6762, 33, 33], [6763, 24, 21],
                    [6764, 31, 33], [6766, 48, 39], [6767, 32, 27], [6768, 31, 29], [6769, 38, 44], [6770, 34, 36],
                    [6771, 34, 34], [6772, 27, 31], [6773, 42, 39], [6777, 44, 39], [6778, 28, 28], [6779, 34, 36],
                    [6780, 35, 34], [6781, 40, 35], [6782, 61, 46], [6783, 44, 39], [6784, 33, 33], [6785, 34, 32],
                    [6786, 34, 36], [6787, 31, 35], [6789, 39, 36], [6790, 35, 107], [6791, 95, 90], [6794, 21, 40],
                    [6795, 46, 75], [6798, 35, 28], [6803, 31, 81], [6804, 50, 107], [6805, 80, 140], [6806, 30, 73],
                    [6807, 35, 47], [6808, 21, 40], [6812, 176, 80], [6813, 31, 70], [6814, 134, 110], [6816, 90, 100],
                    [6818, 18, 20], [6819, 34, 43], [6820, 33, 33], [6821, 35, 41], [6822, 45, 44], [6823, 32, 36],
                    [6833, 75, 62], [6834, 160, 110], [6835, 310, 150], [6836, 40, 70], [6837, 21, 28],
                    [6838, 150, 100], [6841, 29, 21], [6845, 31, 65], [6846, 38, 59], [6847, 40, 45], [6848, 40, 21],
                    [6849, 78, 48], [6850, 45, 53], [6851, 21, 46], [6852, 90, 132], [6853, 31, 55], [6854, 160, 84],
                    [6855, 40, 40], [6856, 30, 56], [6857, 35, 78], [6858, 50, 55], [6859, 63, 58], [6860, 25, 31],
                    [6861, 30, 50], [6862, 35, 40], [6867, 12, 19], [6868, 12, 15], [6869, 13, 15], [6870, 14, 18],
                    [6871, 14, 15], [6872, 12, 17], [6873, 18, 17], [6874, 15, 17], [6875, 15, 17], [6876, 15, 16],
                    [6877, 16, 17], [6878, 14, 15], [6879, 14, 17], [6880, 18, 20], [6881, 15, 13], [6882, 15, 18],
                    [6883, 14, 18], [6910, 60, 48], [6911, 65, 51], [6912, 20, 12], [6913, 58, 45], [6914, 12, 12],
                    [6915, 39, 30], [6917, 28, 31], [6918, 30, 25], [6919, 35, 36], [6920, 21, 20], [6921, 47, 34],
                    [6922, 12, 11], [6923, 51, 36], [6925, 41, 37], [6926, 57, 30], [6927, 65, 35], [6928, 19, 18],
                    [6929, 54, 37], [6930, 30, 20], [6931, 39, 37], [6932, 19, 14], [6933, 28, 25], [6934, 18, 15],
                    [6935, 45, 38], [6936, 22, 23], [6937, 47, 37], [6938, 18, 14], [6939, 48, 35], [6940, 12, 11],
                    [6941, 28, 22], [6942, 20, 17], [6943, 75, 54], [6944, 11, 11], [6945, 50, 30], [6946, 56, 31],
                    [6947, 65, 44], [6948, 12, 11], [6949, 47, 35], [6950, 13, 11], [6951, 50, 38], [6952, 52, 24],
                    [6953, 59, 32], [6954, 27, 16], [6955, 47, 35], [6957, 66, 55], [6958, 13, 11], [6959, 47, 37],
                    [6960, 15, 15], [6961, 45, 24], [6962, 13, 11], [6965, 9, 10], [6966, 21, 35], [6967, 18, 39],
                    [6968, 37, 65], [6969, 18, 34], [6970, 23, 40], [7005, 14, 14], [7006, 32, 30], [7007, 57, 27],
                    [7008, 56, 28], [7011, 10, 10], [7012, 22, 25], [7013, 21, 19], [7014, 14, 9], [7015, 8, 8],
                    [7019, 11, 9], [7021, 12, 11], [7022, 25, 30], [7023, 16, 18], [7024, 26, 30], [7026, 26, 20],
                    [7027, 17, 17], [7028, 39, 37], [7029, 37, 27], [7030, 52, 36], [7031, 15, 19], [7032, 30, 20],
                    [7033, 25, 21], [7034, 32, 28], [7035, 11, 12], [7036, 30, 29], [7037, 26, 26], [7038, 32, 35],
                    [7039, 22, 14], [7040, 28, 26], [7042, 54, 31], [7043, 19, 26], [7044, 27, 25], [7045, 33, 22],
                    [7046, 51, 36], [7048, 27, 21], [7049, 49, 36], [7050, 17, 14], [7051, 54, 39], [7052, 15, 18],
                    [7053, 49, 39], [7054, 17, 15], [7055, 35, 25], [7056, 13, 14], [7057, 58, 39], [7058, 27, 17],
                    [7059, 54, 31], [7060, 27, 18], [7061, 49, 39], [7062, 16, 13], [7063, 50, 35], [7064, 27, 18],
                    [7065, 41, 39], [7066, 12, 12], [7067, 50, 39], [7068, 71, 29], [7069, 77, 51], [7070, 34, 30],
                    [7071, 56, 38], [7072, 10, 11], [7073, 28, 27], [7074, 17, 15], [7075, 56, 54], [7076, 28, 21],
                    [7077, 38, 28], [7078, 11, 11], [7079, 35, 21], [7080, 40, 34], [7081, 67, 49], [7082, 20, 20],
                    [7083, 48, 37], [7084, 52, 25], [7085, 60, 37], [7086, 12, 14], [7087, 42, 34], [7088, 54, 29],
                    [7089, 62, 37], [7090, 18, 12], [7091, 54, 37], [7092, 55, 45], [7093, 67, 55], [7094, 48, 32],
                    [7095, 55, 40], [7096, 27, 22], [7097, 38, 30], [7098, 26, 25], [7099, 51, 38], [7100, 15, 13],
                    [7101, 19, 17], [7156, 17, 18], [7259, 83, 52], [7260, 106, 82], [7261, 84, 67], [7262, 70, 74],
                    [7263, 96, 79], [7264, 84, 88], [7265, 88, 72], [7266, 112, 83], [7267, 84, 68], [7268, 111, 82],
                    [7269, 111, 82], [7270, 80, 50], [7271, 66, 61], [7272, 107, 79], [7273, 86, 90], [7274, 105, 76],
                    [7275, 91, 76], [7276, 59, 49], [7277, 86, 69], [7278, 71, 75], [7279, 92, 65], [7280, 113, 84],
                    [7281, 83, 66], [7282, 69, 72], [7283, 13, 19], [7284, 11, 10], [7285, 12, 11], [7286, 15, 20],
                    [7287, 13, 23], [7288, 28, 28], [7289, 26, 21], [7290, 45, 31], [7291, 34, 28], [7292, 33, 34],
                    [7293, 24, 21], [7294, 21, 20], [7295, 13, 14], [7296, 23, 21], [7297, 25, 22], [7298, 15, 16],
                    [7299, 16, 18], [7300, 18, 27], [7301, 13, 24], [7302, 39, 43], [7303, 75, 72], [7304, 30, 32],
                    [7305, 39, 39], [7306, 30, 33], [7307, 47, 50], [7308, 38, 41], [7309, 31, 33], [7310, 79, 66],
                    [7311, 66, 64], [7312, 37, 38], [7313, 99, 71], [7314, 80, 61], [7315, 75, 57], [7316, 81, 61],
                    [7317, 82, 62], [7318, 80, 62], [7319, 104, 75], [7320, 78, 59], [7321, 101, 76], [7322, 80, 60],
                    [7323, 94, 70], [7324, 99, 71], [7325, 83, 62], [7326, 81, 61], [7327, 96, 71], [7328, 25, 29],
                    [7329, 47, 44], [7330, 29, 29], [7331, 29, 29], [7332, 24, 27], [7333, 50, 56], [7337, 15, 12],
                    [7342, 13, 10], [7343, 15, 8], [7344, 11, 9], [7348, 15, 8], [7352, 12, 11], [7354, 26, 15],
                    [7356, 14, 14], [7357, 24, 15], [7358, 14, 10], [7359, 24, 15], [7360, 17, 10], [7362, 17, 12],
                    [7363, 12, 11], [7364, 15, 11], [7367, 15, 12], [7370, 11, 10], [7371, 13, 11], [7372, 13, 10],
                    [7373, 13, 10], [7374, 11, 8], [7375, 12, 8], [7376, 7, 8], [7377, 11, 8], [7378, 20, 18],
                    [7379, 30, 23], [7396, 28, 27], [7397, 45, 37], [7398, 28, 29], [7399, 23, 26], [7400, 45, 41],
                    [7401, 23, 26], [7402, 53, 60], [7403, 19, 22], [7404, 56, 43], [7405, 27, 28], [7406, 43, 46],
                    [7407, 29, 28], [7408, 45, 49], [7410, 22, 38], [7411, 53, 49], [7413, 11, 14], [7414, 21, 35],
                    [7415, 11, 16], [7416, 27, 33], [7417, 23, 20], [7420, 29, 32], [7421, 27, 29], [7423, 57, 64],
                    [7433, 80, 58], [7434, 100, 100], [7435, 43, 80], [7436, 60, 82], [7437, 19, 18], [7438, 38, 31],
                    [7441, 23, 15], [7442, 43, 21], [7443, 80, 115], [7444, 70, 115], [7445, 35, 78], [7446, 46, 85],
                    [7447, 20, 19], [7448, 39, 33], [7449, 20, 20], [7450, 21, 21], [7451, 14, 15], [7452, 23, 17],
                    [7453, 52, 29], [7454, 16, 17], [7455, 24, 22], [7456, 73, 53], [7457, 57, 51], [7458, 38, 35],
                    [7459, 57, 51], [7460, 57, 56], [7461, 38, 34], [7462, 43, 39], [7463, 48, 45], [7464, 62, 45],
                    [7465, 53, 39], [7466, 48, 35], [7467, 57, 51], [7468, 43, 39], [7469, 55, 42], [7470, 68, 49],
                    [7471, 81, 59], [7472, 30, 61], [7473, 38, 39], [7474, 57, 51], [7475, 57, 51], [7476, 45, 41],
                    [7477, 41, 37], [7478, 43, 40], [7479, 43, 39], [7480, 57, 45], [7481, 38, 40], [7482, 48, 35],
                    [7483, 57, 51], [7484, 45, 45], [7485, 83, 61], [7486, 62, 45], [7487, 45, 41], [7488, 53, 39],
                    [7489, 65, 42], [7490, 43, 39], [7491, 53, 40], [7492, 63, 46], [7493, 48, 43], [7494, 48, 43],
                    [7495, 57, 51], [7496, 83, 61], [7497, 53, 39], [7498, 38, 40], [7499, 43, 34], [7500, 51, 45],
                    [7501, 62, 45], [7502, 53, 39], [7503, 58, 43], [7504, 56, 40], [7505, 48, 43], [7506, 62, 45],
                    [7507, 46, 41], [7508, 53, 40], [7509, 57, 51], [7510, 57, 51], [7511, 62, 45], [7512, 57, 51],
                    [7513, 53, 39], [7514, 100, 75], [7515, 58, 42], [7516, 57, 51], [7517, 83, 61], [7518, 62, 45],
                    [7519, 48, 43], [7520, 48, 44], [7521, 38, 39], [7522, 68, 49], [7523, 48, 45], [7524, 71, 64],
                    [7525, 57, 51], [7526, 55, 40], [7527, 38, 39], [7528, 73, 53], [7529, 83, 75], [7530, 68, 49],
                    [7531, 45, 45], [7532, 57, 51], [7533, 73, 53], [7534, 83, 75], [7535, 48, 44], [7536, 68, 49],
                    [7537, 60, 44], [7538, 73, 53], [7539, 48, 45], [7540, 73, 53], [7541, 58, 42], [7542, 73, 53],
                    [7543, 57, 42], [7544, 60, 44], [7545, 45, 41], [7546, 53, 39], [7547, 53, 39], [7548, 51, 45],
                    [7549, 57, 51], [7550, 43, 39], [7551, 43, 39], [7552, 43, 39], [7553, 48, 44], [7554, 78, 66],
                    [7555, 73, 56], [7556, 57, 51], [7557, 83, 61], [7558, 38, 34], [7559, 53, 39], [7560, 43, 39],
                    [7561, 83, 61], [7562, 83, 61], [7563, 68, 49], [7564, 57, 42], [7565, 48, 45], [7566, 48, 43],
                    [7567, 57, 51], [7568, 48, 44], [7569, 48, 44], [7570, 48, 43], [7571, 48, 43], [7572, 83, 61],
                    [7573, 57, 45], [7574, 48, 43], [7575, 62, 45], [7576, 62, 45], [7577, 68, 49], [7578, 48, 45],
                    [7579, 68, 49], [7580, 68, 49], [7581, 58, 43], [7582, 58, 48], [7583, 57, 51], [7584, 45, 41],
                    [7585, 46, 42], [7586, 83, 61], [7587, 51, 45], [7588, 48, 45], [7589, 83, 61], [7590, 57, 51],
                    [7591, 53, 40], [7592, 68, 49], [7593, 60, 44], [7594, 48, 43], [7595, 48, 45], [7596, 43, 39],
                    [7597, 48, 45], [7598, 62, 45], [7599, 57, 51], [7600, 57, 51], [7601, 43, 39], [7602, 41, 37],
                    [7603, 57, 51], [7604, 57, 51], [7605, 57, 51], [7606, 57, 45], [7607, 68, 49], [7608, 43, 39],
                    [7609, 57, 51], [7610, 43, 40], [7611, 41, 51], [7612, 57, 49], [7613, 48, 45], [7614, 53, 43],
                    [7615, 68, 49], [7616, 58, 42], [7617, 53, 40], [7618, 58, 42], [7619, 57, 51], [7620, 51, 45],
                    [7621, 57, 51], [7622, 68, 49], [7623, 48, 43], [7624, 73, 53], [7625, 43, 40], [7626, 58, 42],
                    [7627, 46, 41], [7628, 68, 49], [7629, 43, 40], [7630, 45, 41], [7631, 54, 48], [7632, 57, 42],
                    [7633, 43, 40], [7634, 15, 22], [7635, 14, 19], [7636, 18, 23], [7637, 28, 27], [7638, 24, 20],
                    [7639, 11, 13], [7640, 10, 11], [7641, 14, 17], [7642, 30, 32], [7643, 18, 18], [7644, 28, 36],
                    [7645, 18, 21], [7646, 25, 24], [7647, 31, 22], [7648, 11, 11], [7649, 11, 12], [7650, 17, 18],
                    [7651, 13, 12], [7652, 14, 12], [7653, 41, 31], [7654, 12, 13], [7655, 14, 14], [7656, 13, 13],
                    [7657, 23, 24], [7658, 21, 25], [7659, 13, 17], [7661, 10, 10], [7662, 17, 14], [7663, 17, 19],
                    [7664, 21, 27], [7665, 29, 36], [7666, 13, 14], [7667, 14, 16], [7668, 13, 12], [7669, 11, 8],
                    [7672, 9, 9], [7673, 8, 7], [7674, 17, 16], [7676, 6, 7], [7677, 5, 6], [7678, 10, 8],
                    [7679, 11, 9], [7680, 37, 20], [7681, 5, 3], [7682, 16, 13], [7683, 3, 3], [7684, 15, 14],
                    [7685, 12, 11], [7686, 21, 19], [7687, 5, 4], [7688, 15, 14], [7690, 7, 8], [7691, 24, 24],
                    [7692, 10, 8], [7693, 9, 9], [7694, 9, 9], [7695, 28, 20], [7696, 3, 3], [7697, 16, 12],
                    [7698, 9, 8], [7699, 12, 14], [7700, 14, 10], [7701, 9, 8], [7702, 22, 13], [7703, 12, 13],
                    [7705, 23, 13], [7706, 11, 10], [7707, 12, 10], [7708, 9, 7], [7709, 12, 14], [7710, 6, 5],
                    [7711, 15, 11], [7713, 28, 12], [7714, 10, 9], [7715, 29, 33], [7716, 27, 28], [7717, 49, 54],
                    [7718, 29, 29], [7719, 24, 27], [7720, 54, 62], [7721, 30, 29], [7722, 35, 30], [7723, 22, 25],
                    [7724, 46, 49], [7725, 17, 21], [7726, 27, 30], [7727, 32, 32], [7728, 48, 44], [7729, 31, 30],
                    [7730, 21, 24], [7731, 48, 52], [7732, 26, 30], [7733, 45, 50], [7734, 41, 34], [7735, 61, 57],
                    [7736, 23, 26], [7737, 42, 38], [7738, 22, 25], [7739, 35, 40], [7740, 23, 26], [7741, 42, 46],
                    [7742, 44, 43], [7743, 29, 28], [7744, 47, 51], [7745, 49, 39], [7746, 30, 29], [7747, 36, 42],
                    [7748, 47, 44], [7749, 31, 32], [7750, 47, 52], [7751, 41, 34], [7752, 60, 55], [7753, 44, 41],
                    [7754, 31, 32], [7755, 24, 26], [7756, 61, 42], [7757, 36, 103], [7758, 65, 110], [7759, 31, 29],
                    [7760, 65, 48], [7761, 50, 61], [7762, 118, 90], [7763, 14, 19], [7764, 13, 15], [7765, 15, 21],
                    [7766, 10, 18], [7767, 24, 29], [7768, 10, 19], [7769, 34, 34], [7770, 46, 36], [7771, 14, 16],
                    [7772, 14, 17], [7773, 22, 24], [7774, 12, 21], [7775, 36, 36], [7776, 14, 29], [7777, 21, 33],
                    [7778, 9, 12], [7779, 15, 20], [7780, 17, 18], [7781, 23, 27], [7782, 27, 25], [7783, 28, 23],
                    [7784, 13, 27], [7785, 22, 36], [7786, 14, 16], [7787, 23, 27], [7788, 18, 20], [7789, 20, 26],
                    [7790, 19, 25], [7791, 37, 36], [7792, 16, 21], [7793, 33, 32], [7795, 171, 98], [7796, 237, 75],
                    [7797, 256, 85], [7798, 164, 32], [7799, 175, 76], [7800, 100, 37], [7801, 213, 78], [7802, 40, 29],
                    [7803, 394, 126], [7804, 182, 91], [7805, 158, 55], [7806, 160, 89], [7807, 106, 29],
                    [7808, 180, 42], [7809, 120, 77], [7810, 234, 119], [7811, 586, 120], [7812, 39, 31],
                    [7813, 90, 33], [7815, 88, 34], [7816, 325, 112], [7817, 56, 41], [7818, 86, 81], [7819, 43, 72],
                    [7820, 96, 43], [7821, 213, 71], [7822, 142, 73], [7823, 47, 39], [7824, 208, 73], [7825, 170, 75],
                    [7826, 120, 91], [7827, 173, 66], [7828, 173, 118], [7829, 103, 37], [7830, 147, 60],
                    [7831, 165, 37], [7832, 187, 94], [7833, 63, 30], [7834, 175, 90], [7835, 128, 33], [7836, 177, 86],
                    [7837, 42, 32], [7838, 183, 80], [7839, 122, 98], [7840, 222, 110], [7841, 175, 72], [7842, 40, 35],
                    [7843, 40, 31], [7844, 196, 65], [7845, 53, 51], [7846, 219, 112], [7847, 391, 112],
                    [7848, 285, 106], [7849, 285, 160], [7850, 103, 93], [7851, 190, 90], [7852, 101, 48],
                    [7853, 92, 62], [7854, 31, 27], [7855, 32, 28], [7856, 197, 112], [7857, 41, 31], [7858, 40, 32],
                    [7859, 186, 74], [7860, 124, 79], [7861, 35, 27], [7862, 322, 52], [7863, 443, 103], [7864, 39, 34],
                    [7865, 46, 37], [7866, 160, 76], [7867, 55, 32], [7868, 42, 31], [7869, 160, 79], [7870, 42, 31],
                    [7871, 64, 35], [7872, 180, 135], [7873, 222, 119], [7874, 42, 32], [7875, 242, 100],
                    [7876, 180, 112], [7877, 120, 74], [7878, 189, 40], [7879, 190, 103], [7880, 97, 72],
                    [7881, 120, 66], [7882, 51, 40], [7883, 120, 93], [7884, 67, 64], [7885, 39, 34], [7886, 80, 35],
                    [7887, 42, 32], [7888, 140, 51], [7889, 258, 120], [7890, 170, 111], [7891, 75, 28], [7892, 64, 33],
                    [7893, 41, 31], [7894, 140, 97], [7895, 80, 37], [7896, 264, 90], [7897, 216, 62], [7898, 120, 59],
                    [7899, 453, 113], [7900, 243, 93], [7901, 120, 29], [7902, 161, 88], [7903, 218, 110],
                    [7904, 120, 31], [7905, 140, 71], [7906, 146, 111], [7907, 172, 42], [7908, 170, 40],
                    [7909, 120, 50], [7910, 124, 58], [7911, 180, 29], [7912, 359, 156], [7913, 198, 61],
                    [7914, 120, 68], [7915, 54, 40], [7916, 150, 42], [7917, 59, 43], [7918, 71, 30], [7919, 120, 32],
                    [7920, 91, 43], [7921, 60, 31], [7922, 120, 35], [7923, 133, 31], [7924, 41, 31], [7925, 41, 31],
                    [7926, 52, 42], [7927, 140, 57], [7928, 120, 53], [7929, 186, 96], [7930, 272, 57], [7931, 59, 32],
                    [7932, 42, 32], [7933, 120, 75], [7934, 176, 113], [7935, 197, 90], [7936, 179, 32], [7937, 75, 31],
                    [7938, 40, 31], [7939, 316, 112], [7940, 167, 86], [7941, 273, 107], [7942, 176, 111],
                    [7943, 43, 33], [7944, 120, 43], [7945, 216, 53], [7946, 124, 91], [7947, 101, 40], [7948, 120, 30],
                    [7949, 199, 111], [7950, 66, 49], [7951, 169, 73], [7952, 125, 90], [7953, 33, 30], [7954, 120, 32],
                    [7955, 200, 60], [7956, 340, 120], [7957, 49, 41], [7958, 173, 53], [7959, 188, 65],
                    [7960, 120, 32], [7961, 165, 165], [7962, 309, 112], [7963, 32, 27], [7964, 160, 112],
                    [7965, 179, 38], [7966, 142, 93], [7967, 182, 31], [7968, 396, 128], [7969, 336, 176],
                    [7970, 162, 83], [7971, 32, 29], [7972, 77, 30], [7974, 33, 30], [7975, 302, 120], [7976, 320, 43],
                    [7977, 222, 131], [7978, 172, 40], [7979, 128, 74], [7980, 265, 80], [7981, 169, 41],
                    [7982, 83, 33], [7983, 120, 31], [7984, 180, 112], [7985, 91, 59], [7986, 41, 31], [7987, 106, 35],
                    [7988, 54, 39], [7989, 720, 98], [7990, 83, 28], [7992, 120, 75], [7993, 185, 103], [7994, 120, 52],
                    [7995, 434, 161], [7996, 136, 34], [7997, 252, 116], [7998, 120, 32], [7999, 138, 100],
                    [8000, 120, 29], [8001, 198, 99], [8002, 167, 93], [8003, 120, 29], [8004, 189, 175],
                    [8005, 18, 21], [8006, 14, 17], [8007, 24, 28], [8008, 21, 24], [8009, 15, 15], [8010, 13, 15],
                    [8011, 15, 17], [8012, 11, 14], [8013, 7, 6], [8014, 8, 9], [8015, 8, 8], [8016, 6, 5],
                    [8017, 12, 12], [8018, 7, 6], [8019, 14, 13], [8020, 12, 12], [8021, 6, 5], [8022, 21, 25],
                    [8023, 15, 16], [8024, 19, 18], [8025, 16, 19], [8026, 17, 18], [8027, 13, 11], [8028, 13, 13],
                    [8029, 21, 20], [8030, 16, 15], [8031, 12, 11], [8032, 17, 21], [8033, 21, 22], [8034, 21, 26],
                    [8035, 18, 18], [8036, 16, 19], [8037, 19, 21], [8038, 29, 28], [8039, 30, 57], [8040, 20, 57],
                    [8041, 7, 13], [8042, 7, 9], [8043, 10, 14], [8044, 10, 15], [8045, 5, 3], [8046, 5, 3],
                    [8047, 5, 5], [8048, 14, 19], [8049, 11, 15], [8050, 9, 10], [8051, 20, 21], [8052, 32, 43],
                    [8053, 21, 35], [8054, 18, 30], [8055, 29, 42], [8056, 41, 45], [8057, 19, 29], [8058, 18, 25],
                    [8059, 23, 25], [8060, 25, 29], [8061, 50, 55], [8062, 52, 68], [8063, 10, 9], [8064, 14, 18],
                    [8065, 14, 11], [8068, 11, 10], [8069, 13, 24], [8071, 38, 20], [8073, 46, 25], [8074, 12, 12],
                    [8075, 26, 15], [8076, 52, 34], [8086, 14, 40], [8087, 15, 28], [8088, 17, 35], [8089, 20, 42],
                    [8090, 19, 29], [8091, 21, 57], [8092, 18, 44], [8093, 21, 57], [8094, 14, 57], [8095, 20, 26],
                    [8096, 22, 35], [8097, 20, 30], [8098, 8, 23], [8099, 29, 29], [8100, 28, 27], [8101, 29, 29],
                    [8102, 23, 25], [8103, 29, 29], [8104, 28, 28], [8105, 43, 36], [8106, 32, 32], [8107, 24, 27],
                    [8108, 42, 39], [8109, 31, 30], [8110, 23, 26], [8111, 39, 36], [8112, 28, 28], [8113, 43, 36],
                    [8114, 23, 26], [8115, 55, 63], [8116, 32, 31], [8117, 43, 55], [8118, 24, 28], [8119, 30, 29],
                    [8120, 40, 37], [8121, 24, 26], [8122, 29, 29], [8123, 44, 37], [8124, 30, 31], [8125, 44, 37],
                    [8126, 24, 25], [8127, 31, 32], [8128, 67, 63], [8129, 29, 29], [8130, 44, 37], [8131, 22, 25],
                    [8132, 42, 39], [8133, 24, 27], [8134, 44, 41], [8135, 44, 36], [8136, 19, 22], [8137, 29, 30],
                    [8138, 32, 32], [8139, 51, 55], [8140, 32, 37], [8141, 28, 27], [8142, 29, 29], [8143, 53, 60],
                    [8144, 24, 27], [8145, 23, 25], [8146, 40, 43], [8147, 28, 27], [8148, 31, 30], [8149, 25, 28],
                    [8150, 58, 68], [8151, 22, 25], [8152, 49, 56], [8153, 29, 30], [8154, 28, 27], [8155, 38, 32],
                    [8156, 61, 73], [8157, 32, 31], [8158, 29, 29], [8159, 25, 26], [8160, 29, 28], [8161, 44, 37],
                    [8162, 46, 38], [8163, 44, 34], [8164, 27, 28], [8165, 31, 31], [8166, 61, 47], [8167, 44, 37],
                    [8168, 29, 30], [8169, 43, 35], [8170, 30, 30], [8171, 29, 30], [8172, 62, 46], [8173, 29, 29],
                    [8174, 30, 29], [8175, 24, 26], [8176, 23, 26], [8177, 25, 29], [8178, 31, 32], [8179, 40, 36],
                    [8180, 28, 28], [8181, 59, 46], [8182, 44, 37], [8183, 32, 32], [8184, 28, 27], [8185, 28, 28],
                    [8186, 31, 31], [8187, 25, 28], [8188, 18, 21], [8189, 41, 38], [8190, 23, 25], [8191, 42, 42],
                    [8192, 32, 31], [8193, 59, 44], [8194, 28, 27], [8195, 29, 29], [8196, 25, 28], [8197, 32, 32],
                    [8198, 25, 28], [8199, 49, 53], [8200, 23, 27], [8201, 63, 48], [8202, 38, 37], [8203, 54, 36],
                    [8204, 43, 36], [8205, 20, 23], [8206, 48, 46], [8207, 29, 28], [8208, 23, 26], [8209, 62, 48],
                    [8210, 31, 31], [8211, 53, 60], [8212, 23, 25], [8213, 31, 30], [8214, 50, 55], [8215, 30, 29],
                    [8216, 29, 29], [8217, 31, 31], [8218, 16, 21], [8219, 47, 45], [8220, 22, 25], [8221, 41, 38],
                    [8222, 20, 24], [8223, 23, 26], [8224, 39, 41], [8225, 31, 36], [8226, 52, 58], [8227, 29, 29],
                    [8228, 20, 23], [8229, 28, 27], [8230, 31, 30], [8231, 19, 22], [8232, 50, 48], [8233, 29, 29],
                    [8234, 21, 23], [8235, 49, 54], [8236, 23, 26], [8237, 47, 44], [8238, 28, 28], [8239, 69, 53],
                    [8240, 30, 29], [8241, 25, 28], [8242, 44, 41], [8245, 31, 30], [8246, 32, 32], [8247, 44, 36],
                    [8248, 20, 23], [8249, 42, 39], [8250, 27, 28], [8251, 30, 29], [8252, 40, 37], [8253, 42, 34],
                    [8254, 33, 37], [8255, 28, 28], [8256, 25, 27], [8257, 49, 55], [8258, 29, 28], [8259, 28, 28],
                    [8260, 31, 32], [8261, 48, 52], [8262, 46, 47], [8263, 54, 41], [8264, 27, 31], [8265, 46, 61],
                    [8267, 42, 35], [8268, 30, 29], [8269, 29, 29], [8270, 18, 22], [8271, 24, 28], [8272, 41, 37],
                    [8273, 29, 29], [8274, 28, 28], [8275, 26, 29], [8276, 28, 28], [8277, 29, 22], [8278, 44, 37],
                    [8279, 29, 29], [8280, 32, 32], [8281, 29, 28], [8282, 32, 32], [8283, 31, 30], [8284, 30, 29],
                    [8285, 32, 32], [8286, 32, 32], [8287, 31, 31], [8288, 24, 28], [8289, 42, 39], [8290, 32, 32],
                    [8291, 32, 32], [8292, 31, 30], [8293, 28, 28], [8294, 29, 28], [8295, 44, 36], [8296, 43, 31],
                    [8297, 30, 30], [8298, 28, 46], [8299, 19, 22], [8300, 62, 47], [8301, 31, 31], [8302, 29, 28],
                    [8303, 44, 37], [8304, 28, 28], [8305, 41, 34], [8306, 25, 28], [8307, 18, 21], [8308, 29, 28],
                    [8309, 15, 19], [8310, 42, 38], [8311, 13, 13], [8312, 12, 12], [8313, 12, 11], [8314, 12, 12],
                    [8315, 12, 12], [8316, 11, 11], [8317, 35, 35], [8318, 51, 39], [8319, 18, 18], [8320, 44, 37],
                    [8321, 32, 26], [8322, 31, 31], [8323, 25, 28], [8324, 56, 41], [8325, 49, 40], [8326, 43, 36],
                    [8327, 41, 34], [8328, 46, 38], [8329, 29, 28], [8330, 46, 38], [8331, 41, 34], [8332, 44, 36],
                    [8336, 20, 17], [8337, 12, 15], [8338, 12, 12], [8339, 33, 33], [8340, 15, 17], [8341, 23, 26],
                    [8342, 15, 15], [8343, 17, 17], [8344, 14, 13], [8345, 20, 15], [8346, 18, 22], [8347, 15, 17],
                    [8348, 20, 23], [8349, 15, 16], [8350, 17, 17], [8351, 14, 11], [8352, 18, 23], [8353, 13, 16],
                    [8354, 21, 24], [8355, 14, 14], [8356, 23, 26], [8357, 14, 14], [8358, 22, 17], [8359, 30, 34],
                    [8360, 27, 31], [8361, 14, 13], [8362, 17, 22], [8363, 21, 26], [8364, 25, 22], [8365, 12, 14],
                    [8366, 20, 18], [8367, 16, 16], [8368, 17, 22], [8369, 18, 22], [8370, 18, 18], [8371, 19, 18],
                    [8372, 21, 18], [8373, 21, 24], [8374, 20, 25], [8375, 14, 13], [8376, 24, 24], [8377, 19, 15],
                    [8378, 20, 17], [8379, 24, 22], [8380, 24, 25], [8381, 24, 27], [8382, 18, 19], [8383, 22, 25],
                    [8384, 20, 26], [8385, 18, 22], [8386, 13, 15], [8387, 21, 21], [8388, 17, 17], [8389, 16, 18],
                    [8390, 13, 14], [8391, 16, 18], [8392, 18, 20], [8393, 29, 37], [8394, 22, 18], [8395, 18, 19],
                    [8396, 47, 39], [8397, 55, 41], [8398, 40, 29], [8399, 51, 33], [8400, 43, 40], [8401, 51, 31],
                    [8402, 41, 31], [8403, 45, 30], [8404, 39, 34], [8405, 45, 30], [8406, 40, 32], [8407, 47, 42],
                    [8408, 38, 38], [8409, 34, 28], [8410, 40, 33], [8411, 74, 52], [8412, 42, 39], [8413, 50, 38],
                    [8414, 57, 31], [8415, 61, 42], [8416, 31, 29], [8417, 50, 34], [8418, 26, 27], [8419, 52, 37],
                    [8420, 44, 34], [8421, 53, 40], [8422, 33, 33], [8423, 50, 45], [8424, 52, 51], [8425, 39, 45],
                    [8426, 35, 30], [8427, 38, 32], [8428, 41, 33], [8429, 33, 30], [8430, 50, 45], [8431, 51, 39],
                    [8432, 51, 45], [8433, 48, 43], [8434, 52, 34], [8435, 70, 38], [8436, 55, 41], [8438, 36, 30],
                    [8439, 39, 35], [8440, 58, 38], [8441, 54, 36], [8442, 37, 34], [8443, 47, 40], [8444, 50, 45],
                    [8445, 27, 24], [8446, 35, 29], [8447, 46, 37], [8448, 38, 33], [8449, 56, 27], [8450, 52, 37],
                    [8451, 21, 27], [8452, 27, 36], [8453, 20, 24], [8454, 22, 27], [8455, 23, 27], [8456, 23, 27],
                    [8457, 50, 45], [8458, 38, 30], [8459, 47, 33], [8460, 41, 36], [8461, 53, 33], [8462, 52, 36],
                    [8463, 50, 42], [8464, 55, 40], [8465, 34, 25], [8466, 32, 37], [8467, 36, 31], [8468, 42, 37],
                    [8469, 39, 32], [8470, 55, 42], [8471, 35, 38], [8472, 54, 29], [8473, 45, 40], [8474, 38, 35],
                    [8475, 48, 37], [8476, 49, 38], [8477, 49, 38], [8478, 30, 30], [8479, 39, 34], [8480, 54, 42],
                    [8481, 46, 37], [8482, 42, 33], [8483, 41, 33], [8484, 47, 35], [8485, 50, 41], [8486, 33, 27],
                    [8487, 46, 33], [8488, 36, 30], [8489, 33, 47], [8490, 47, 37], [8491, 39, 37], [8492, 41, 31],
                    [8493, 47, 32], [8494, 33, 27], [8495, 51, 51], [8496, 26, 33], [8497, 44, 43], [8498, 32, 33],
                    [8499, 40, 32], [8500, 51, 36], [8501, 50, 55], [8502, 53, 35], [8503, 51, 39], [8504, 40, 37],
                    [8505, 52, 40], [8506, 55, 41], [8507, 54, 42], [8508, 34, 32], [8509, 38, 33], [8510, 53, 39],
                    [8511, 46, 35], [8512, 50, 45], [8513, 44, 40], [8514, 49, 45], [8515, 41, 38], [8516, 90, 54],
                    [8517, 52, 23], [8518, 58, 51], [8519, 38, 32], [8520, 41, 32], [8521, 37, 32], [8522, 39, 35],
                    [8523, 38, 33], [8524, 36, 31], [8525, 47, 33], [8526, 49, 38], [8527, 47, 45], [8528, 48, 40],
                    [8529, 58, 40], [8530, 35, 31], [8531, 56, 49], [8532, 48, 44], [8533, 55, 49], [8534, 41, 39],
                    [8535, 54, 52], [8536, 18, 30], [8537, 38, 27], [8538, 38, 26], [8539, 35, 30], [8540, 28, 36],
                    [8541, 35, 44], [8542, 29, 38], [8543, 19, 36], [8544, 27, 50], [8546, 25, 37], [8547, 30, 50],
                    [8548, 15, 18], [8549, 23, 29], [8550, 20, 27], [8551, 32, 28], [8552, 29, 35], [8553, 40, 51],
                    [8554, 21, 20], [8555, 34, 33], [8556, 38, 50], [8557, 50, 49], [8558, 27, 30], [8559, 34, 31],
                    [8560, 28, 33], [8561, 23, 28], [8562, 32, 32], [8563, 39, 41], [8564, 67, 55], [8565, 10, 12],
                    [8566, 22, 14], [8567, 22, 21], [8568, 16, 16], [8569, 19, 15], [8570, 10, 10], [8571, 14, 11],
                    [8572, 12, 12], [8573, 13, 11], [8574, 15, 13], [8575, 10, 10], [8576, 32, 19], [8577, 14, 16],
                    [8578, 24, 21], [8579, 14, 20], [8580, 18, 17], [8581, 14, 15], [8582, 20, 18], [8583, 20, 18],
                    [8584, 16, 14], [8585, 11, 11], [8586, 30, 18], [8587, 10, 8], [8588, 31, 15], [8589, 14, 12],
                    [8590, 20, 14], [8591, 19, 14], [8592, 26, 25], [8593, 23, 20], [8594, 36, 23], [8595, 14, 13],
                    [8596, 17, 14], [8597, 18, 21], [8598, 27, 21], [8599, 14, 12], [8600, 20, 14], [8601, 25, 18],
                    [8602, 25, 18], [8603, 24, 14], [8604, 39, 21], [8605, 22, 21], [8606, 37, 23], [8607, 17, 22],
                    [8608, 26, 25], [8609, 25, 18], [8610, 22, 22], [8611, 23, 17], [8612, 33, 22], [8613, 14, 11],
                    [8614, 26, 19], [8615, 11, 11], [8616, 26, 20], [8617, 27, 14], [8618, 18, 12], [8619, 30, 25],
                    [8622, 45, 23], [8623, 45, 25], [8624, 17, 19], [8625, 37, 23], [8626, 21, 16], [8627, 32, 18],
                    [8628, 27, 22], [8629, 26, 22], [8630, 19, 15], [8631, 26, 19], [8632, 20, 15], [8633, 22, 17],
                    [8634, 14, 14], [8635, 24, 14], [8636, 10, 9], [8637, 21, 14], [8638, 14, 11], [8639, 18, 13],
                    [8640, 21, 17], [8641, 37, 20], [8642, 24, 19], [8643, 24, 24], [8644, 39, 22], [8645, 20, 18],
                    [8646, 23, 18], [8647, 19, 14], [8648, 18, 14], [8649, 21, 19], [8650, 27, 16], [8651, 29, 19],
                    [8652, 35, 26], [8653, 26, 22], [8654, 49, 23], [8655, 20, 19], [8656, 20, 18], [8657, 9, 12],
                    [8658, 19, 16], [8659, 28, 22], [8660, 13, 11], [8661, 17, 13], [8662, 20, 12], [8663, 21, 14],
                    [8664, 25, 17], [8665, 35, 26], [8666, 16, 15], [8667, 18, 17], [8668, 16, 20], [8669, 31, 29],
                    [8670, 17, 18], [8671, 25, 26], [8672, 14, 17], [8673, 25, 23], [8674, 23, 16], [8675, 46, 21],
                    [8676, 32, 23], [8677, 37, 24], [8678, 32, 18], [8679, 34, 17], [8680, 23, 17], [8681, 31, 20],
                    [8682, 32, 19], [8683, 27, 13], [8684, 25, 19], [8685, 19, 17], [8686, 28, 17], [8687, 20, 15],
                    [8688, 32, 22], [8689, 28, 20], [8690, 33, 20], [8691, 22, 21], [8692, 36, 24], [8693, 31, 12],
                    [8694, 31, 20], [8695, 13, 14], [8696, 20, 18], [8697, 18, 14], [8698, 34, 16], [8699, 27, 15],
                    [8700, 30, 15], [8701, 21, 13], [8702, 24, 17], [8703, 23, 19], [8704, 28, 22], [8705, 25, 16],
                    [8706, 31, 18], [8707, 18, 19], [8708, 25, 21], [8709, 33, 18], [8710, 27, 18], [8711, 10, 9],
                    [8712, 20, 18], [8713, 28, 19], [8714, 6, 5], [8715, 7, 6], [8716, 6, 6], [8717, 11, 11],
                    [8718, 8, 7], [8719, 24, 24], [8720, 25, 27], [8721, 26, 28], [8722, 24, 23], [8723, 26, 25],
                    [8724, 24, 24], [8725, 26, 22], [8726, 25, 23], [8727, 22, 22], [8728, 21, 21], [8729, 23, 21],
                    [8730, 21, 21], [8731, 21, 21], [8732, 25, 22], [8733, 26, 22], [8734, 26, 22], [8735, 21, 22],
                    [8736, 21, 21], [8737, 21, 21], [8738, 21, 21], [8739, 21, 21], [8740, 21, 21], [8741, 24, 21],
                    [8742, 23, 22], [8743, 22, 22], [8744, 23, 22], [8745, 24, 22], [8746, 27, 24], [8747, 27, 23],
                    [8748, 28, 23], [8749, 23, 22], [8750, 22, 23], [8751, 22, 25], [8752, 21, 21], [8753, 21, 21],
                    [8754, 21, 21], [8755, 21, 21], [8756, 27, 22], [8757, 21, 21], [8758, 21, 21], [8759, 22, 21],
                    [8760, 29, 30], [8761, 22, 21], [8762, 27, 22], [8763, 21, 21], [8764, 29, 24], [8765, 25, 21],
                    [8766, 26, 22], [8767, 28, 24], [8768, 29, 23], [8769, 27, 23], [8770, 28, 24], [8771, 28, 26],
                    [8772, 30, 25], [8773, 21, 21], [8774, 21, 21], [8775, 21, 21], [8776, 21, 21], [8777, 22, 22],
                    [8778, 29, 25], [8779, 10, 11], [8780, 13, 9], [8781, 16, 13], [8782, 14, 10], [8783, 10, 8],
                    [8784, 12, 9], [8785, 7, 7], [8786, 9, 10], [8787, 11, 10], [8788, 12, 10], [8790, 10, 8],
                    [8791, 6, 6], [8792, 12, 10], [8793, 8, 8], [8794, 8, 7], [8795, 9, 7], [8796, 13, 9],
                    [8797, 15, 9], [8798, 9, 8], [8799, 15, 13], [8800, 10, 8], [8801, 10, 9], [8802, 8, 7],
                    [8803, 8, 8], [8804, 7, 8], [8805, 9, 8], [8806, 9, 10], [8807, 13, 12], [8808, 9, 8], [8809, 6, 8],
                    [8810, 10, 10], [8811, 7, 9], [8812, 11, 9], [8814, 6, 7], [8815, 9, 9], [8816, 12, 7],
                    [8817, 17, 10], [8818, 41, 34], [8819, 35, 33], [8820, 50, 41], [8821, 39, 27], [8822, 48, 39],
                    [8823, 31, 25], [8824, 22, 18], [8825, 34, 29], [8826, 22, 21], [8827, 37, 29], [8828, 37, 28],
                    [8829, 41, 32], [8830, 27, 28], [8831, 33, 25], [8832, 19, 11], [8833, 30, 24], [8834, 35, 30],
                    [8835, 29, 19], [8836, 45, 36], [8837, 30, 21], [8838, 38, 32], [8839, 24, 13], [8840, 34, 24],
                    [8841, 23, 13], [8842, 15, 18], [8843, 19, 12], [8844, 27, 22], [8845, 14, 17], [8846, 33, 26],
                    [8847, 18, 19], [8848, 42, 34], [8849, 27, 21], [8850, 37, 31], [8851, 22, 22], [8852, 32, 25],
                    [8853, 14, 17], [8854, 32, 27], [8855, 20, 14], [8856, 30, 25], [8857, 23, 13], [8858, 27, 14],
                    [8859, 40, 35], [8860, 27, 12], [8861, 33, 28], [8862, 24, 21], [8863, 37, 32], [8864, 21, 21],
                    [8865, 31, 25], [8866, 22, 21], [8867, 45, 38], [8868, 37, 31], [8869, 48, 39], [8870, 44, 35],
                    [8871, 32, 27], [8872, 35, 30], [8873, 26, 22], [8874, 30, 25], [8875, 34, 28], [8876, 18, 18],
                    [8877, 41, 33], [8878, 27, 24], [8879, 18, 11], [8880, 30, 25], [8881, 48, 39], [8882, 28, 24],
                    [8883, 47, 37], [8884, 17, 15], [8885, 52, 35], [8886, 33, 25], [8887, 19, 11], [8888, 37, 33],
                    [8889, 44, 35], [8890, 13, 16], [8891, 32, 28], [8892, 14, 11], [8893, 34, 30], [8894, 19, 18],
                    [8895, 15, 11], [8896, 24, 20], [8897, 15, 10], [8898, 19, 18], [8899, 45, 39], [8900, 33, 28],
                    [8901, 39, 29], [8902, 32, 27], [8903, 25, 21], [8904, 33, 28], [8905, 23, 19], [8906, 30, 24],
                    [8907, 19, 19], [8908, 28, 24], [8909, 21, 18], [8910, 21, 12], [8911, 23, 13], [8912, 41, 36],
                    [8913, 26, 23], [8914, 39, 33], [8915, 27, 23], [8916, 42, 34], [8917, 32, 22], [8918, 43, 35],
                    [8919, 30, 26], [8920, 32, 27], [8921, 33, 31], [8922, 30, 24], [8923, 24, 20], [8924, 14, 13],
                    [8925, 11, 10], [8926, 14, 12], [8927, 15, 15], [8928, 13, 12], [8929, 10, 10], [8930, 9, 10],
                    [8931, 13, 14], [8932, 16, 18], [8933, 23, 23], [8934, 26, 25], [8935, 41, 34], [8936, 25, 19],
                    [8937, 33, 28], [8938, 24, 19], [8939, 31, 24], [8940, 18, 16], [8941, 30, 24], [8942, 18, 16],
                    [8943, 26, 19], [8944, 31, 25], [8945, 22, 19], [8946, 31, 25], [8947, 22, 18], [8948, 30, 25],
                    [8949, 25, 20], [8950, 22, 19], [8951, 30, 25], [8952, 23, 19], [8953, 38, 32], [8954, 24, 17],
                    [8955, 39, 34], [8956, 26, 23], [8957, 26, 18], [8958, 47, 39], [8959, 27, 19], [8960, 44, 36],
                    [8961, 27, 19], [8962, 39, 34], [8963, 30, 26], [8964, 19, 12], [8965, 41, 34], [8966, 36, 28],
                    [8967, 39, 30], [8968, 30, 25], [8969, 18, 13], [8970, 40, 34], [8971, 34, 30], [8972, 17, 13],
                    [8973, 39, 31], [8974, 13, 19], [8975, 45, 36], [8976, 48, 39], [8977, 26, 21], [8978, 14, 11],
                    [8979, 37, 32], [8980, 30, 25], [8981, 29, 23], [8983, 34, 28], [8984, 28, 20], [8985, 33, 28],
                    [8986, 25, 20], [8987, 27, 25], [8988, 18, 26], [8989, 34, 28], [8990, 23, 20], [8991, 32, 27],
                    [8992, 18, 18], [8993, 33, 30], [8994, 41, 35], [8995, 35, 27], [8996, 45, 37], [8997, 22, 21],
                    [8998, 27, 20], [8999, 19, 11], [9000, 47, 39], [9001, 41, 28], [9002, 39, 30], [9003, 23, 21],
                    [9004, 44, 37], [9005, 20, 18], [9006, 34, 27], [9007, 27, 19], [9008, 37, 24], [9009, 32, 24],
                    [9010, 25, 20], [9011, 19, 11], [9012, 27, 25], [9013, 20, 24], [9014, 36, 28], [9015, 19, 14],
                    [9016, 19, 14], [9017, 39, 30], [9018, 26, 26], [9019, 30, 29], [9020, 18, 18], [9021, 34, 29],
                    [9022, 32, 24], [9023, 31, 25], [9024, 36, 29], [9025, 30, 25], [9026, 34, 18], [9027, 27, 17],
                    [9028, 39, 30], [9030, 40, 30], [9031, 32, 26], [9032, 41, 30], [9033, 30, 26], [9034, 46, 37],
                    [9035, 39, 33], [9036, 36, 31], [9037, 16, 14], [9038, 27, 26], [9039, 15, 20], [9040, 34, 28],
                    [9041, 23, 19], [9042, 39, 29], [9043, 33, 28], [9044, 24, 14], [9045, 33, 25], [9046, 28, 20],
                    [9047, 33, 27], [9048, 30, 21], [9049, 53, 35], [9050, 28, 20], [9051, 41, 33], [9052, 44, 26],
                    [9053, 31, 31], [9054, 35, 27], [9055, 45, 21], [9056, 48, 25], [9057, 41, 29], [9058, 25, 19],
                    [9059, 47, 32], [9060, 40, 28], [9061, 65, 52], [9062, 21, 21], [9063, 33, 24], [9064, 16, 18],
                    [9065, 22, 21], [9066, 16, 17], [9067, 30, 22], [9068, 26, 18], [9069, 33, 37], [9070, 17, 17],
                    [9071, 25, 31], [9072, 13, 16], [9073, 14, 16], [9074, 29, 27], [9075, 20, 23], [9076, 23, 25],
                    [9077, 34, 22], [9078, 26, 16], [9079, 36, 31], [9080, 21, 18], [9081, 27, 22], [9082, 44, 30],
                    [9083, 30, 24], [9084, 37, 27], [9085, 19, 19], [9086, 36, 28], [9087, 41, 27], [9088, 29, 17],
                    [9089, 17, 14], [9090, 23, 18], [9091, 23, 15], [9092, 39, 25], [9093, 20, 19], [9094, 45, 38],
                    [9095, 14, 12], [9096, 26, 30], [9097, 29, 21], [9098, 36, 23], [9099, 19, 13], [9100, 33, 22],
                    [9101, 15, 17], [9102, 37, 28], [9103, 24, 24], [9104, 36, 28], [9105, 21, 14], [9106, 28, 15],
                    [9107, 33, 25], [9108, 34, 25], [9109, 33, 26], [9110, 37, 28], [9111, 25, 13], [9112, 43, 35],
                    [9113, 32, 27], [9114, 48, 25], [9115, 14, 14], [9116, 22, 15], [9117, 29, 12], [9118, 43, 29],
                    [9119, 17, 12], [9120, 27, 21], [9121, 30, 25], [9122, 37, 32], [9123, 26, 18], [9124, 38, 30],
                    [9125, 16, 23], [9126, 40, 34], [9127, 28, 25], [9128, 34, 28], [9129, 37, 31], [9130, 49, 40],
                    [9131, 25, 25], [9132, 39, 34], [9133, 26, 18], [9134, 34, 26], [9135, 44, 31], [9136, 40, 28],
                    [9137, 16, 11], [9138, 19, 15], [9139, 27, 24], [9140, 39, 34], [9141, 25, 23], [9142, 45, 40],
                    [9143, 20, 20], [9144, 23, 26], [9145, 32, 26], [9146, 40, 32], [9149, 18, 16], [9150, 19, 20],
                    [9151, 16, 16], [9152, 21, 22], [9153, 12, 15], [9154, 14, 14], [9155, 20, 21], [9156, 23, 21],
                    [9157, 23, 25], [9158, 11, 14], [9159, 19, 23], [9160, 14, 14], [9161, 17, 18], [9162, 22, 23],
                    [9163, 25, 21], [9164, 18, 17], [9165, 16, 27], [9166, 19, 21], [9167, 17, 17], [9168, 23, 25],
                    [9169, 20, 19], [9170, 24, 26], [9171, 17, 16], [9172, 18, 20], [9173, 19, 24], [9174, 17, 16],
                    [9175, 18, 18], [9176, 10, 10], [9177, 18, 17], [9178, 19, 25], [9179, 20, 24], [9180, 12, 14],
                    [9181, 17, 16], [9182, 21, 25], [9183, 19, 18], [9184, 22, 22], [9185, 20, 19], [9186, 14, 16],
                    [9187, 20, 19], [9188, 23, 23], [9189, 22, 21], [9190, 14, 16], [9191, 19, 17], [9192, 17, 19],
                    [9193, 18, 16], [9194, 26, 28], [9195, 28, 32], [9196, 29, 22], [9198, 29, 22], [9199, 27, 22],
                    [9200, 27, 22], [9201, 32, 31], [9202, 32, 31], [9203, 10, 12], [9204, 9, 10], [9209, 25, 23],
                    [9211, 33, 33], [9214, 39, 37], [9218, 23, 20], [9226, 38, 28], [9227, 42, 35], [9228, 40, 45],
                    [9229, 35, 36], [9230, 34, 28], [9232, 35, 31], [9233, 31, 33], [9234, 31, 33], [9235, 31, 33],
                    [9237, 30, 20], [9238, 33, 36], [9242, 35, 36], [9244, 39, 37], [9245, 24, 27], [9248, 32, 26],
                    [9254, 87, 85], [9255, 43, 31], [9257, 60, 52], [9258, 34, 45], [9259, 48, 48], [9260, 41, 34],
                    [9261, 62, 74], [9263, 44, 47], [9264, 37, 39], [9265, 41, 44], [9266, 68, 73], [9267, 59, 57],
                    [9268, 52, 51], [9269, 76, 76], [9270, 68, 73], [9271, 71, 77], [9272, 77, 85], [9273, 73, 80],
                    [9274, 82, 75], [9275, 48, 46], [9276, 79, 73], [9277, 65, 54], [9278, 72, 75], [9279, 69, 63],
                    [9280, 50, 49], [9281, 76, 64], [9282, 83, 74], [9283, 72, 72], [9284, 100, 105], [9285, 62, 67],
                    [9286, 90, 98], [9287, 95, 95], [9288, 52, 41], [9289, 85, 93], [9290, 59, 66], [9291, 83, 83],
                    [9292, 82, 81], [9293, 59, 42], [9294, 51, 50], [9295, 69, 63], [9296, 52, 39], [9297, 77, 53],
                    [9298, 67, 76], [9299, 81, 86], [9300, 86, 88], [9301, 70, 77], [9302, 95, 96], [9303, 71, 81],
                    [9304, 59, 73], [9305, 74, 86], [9306, 97, 111], [9307, 40, 53], [9308, 51, 64], [9309, 46, 55],
                    [9310, 57, 60], [9311, 54, 61], [9312, 57, 60], [9313, 53, 59], [9314, 71, 80], [9315, 35, 34],
                    [9316, 37, 25], [9317, 12, 14], [9318, 14, 16], [9319, 33, 37], [9320, 47, 44], [9327, 12, 14],
                    [9328, 19, 22], [9329, 27, 29], [9330, 36, 38], [9331, 22, 24], [9332, 26, 29], [9333, 11, 14],
                    [9334, 11, 13], [9335, 22, 23], [9336, 20, 22], [9337, 16, 19], [9338, 10, 13], [9339, 16, 18],
                    [9340, 35, 38], [9341, 17, 23], [9342, 28, 28], [9343, 8, 9], [9344, 16, 16], [9345, 17, 21],
                    [9346, 12, 13], [9347, 10, 12], [9348, 23, 21], [9349, 16, 19], [9350, 35, 40], [9351, 28, 26],
                    [9352, 34, 36], [9353, 15, 20], [9354, 25, 30], [9355, 17, 15], [9356, 32, 30], [9357, 15, 18],
                    [9358, 22, 25], [9359, 16, 24], [9360, 26, 29], [9361, 20, 18], [9362, 31, 29], [9363, 20, 22],
                    [9364, 34, 26], [9365, 16, 21], [9366, 45, 50], [9367, 19, 21], [9368, 61, 65], [9369, 28, 35],
                    [9370, 15, 16], [9371, 22, 26], [9372, 45, 30], [9373, 18, 18], [9374, 32, 31], [9375, 19, 23],
                    [9376, 45, 45], [9377, 12, 13], [9378, 18, 22], [9379, 27, 32], [9380, 24, 27], [9381, 55, 51],
                    [9382, 25, 30], [9383, 45, 30], [9384, 16, 17], [9385, 17, 18], [9386, 16, 17], [9387, 14, 14],
                    [9388, 13, 14], [9389, 16, 15], [9390, 17, 21], [9391, 21, 24], [9392, 19, 21], [9393, 21, 21],
                    [9394, 14, 15], [9395, 18, 18], [9396, 20, 24], [9397, 34, 38], [9398, 33, 38], [9399, 45, 50],
                    [9400, 20, 24], [9401, 70, 64], [9402, 38, 29], [9403, 102, 75], [9406, 120, 82], [9411, 98, 71],
                    [9416, 50, 60], [9417, 103, 76], [9420, 100, 73], [9423, 88, 65], [9428, 98, 74], [9431, 100, 73],
                    [9436, 100, 73], [9443, 101, 74], [9444, 98, 71], [9451, 120, 76], [9452, 100, 80], [9453, 82, 63],
                    [9456, 100, 73], [9457, 88, 90], [9458, 100, 74], [9465, 57, 53], [9470, 99, 72], [9473, 43, 65],
                    [9474, 120, 90], [9477, 34, 42], [9478, 52, 65], [9487, 25, 43], [9488, 42, 65], [9491, 39, 59],
                    [9492, 64, 71], [9497, 41, 28], [9498, 118, 43], [9509, 88, 82], [9519, 21, 25], [9520, 89, 53],
                    [9525, 21, 20], [9526, 44, 50], [9529, 32, 31], [9530, 62, 65], [9531, 37, 47], [9532, 78, 75],
                    [9539, 51, 48], [9540, 70, 76], [9541, 38, 35], [9542, 61, 56], [9543, 32, 39], [9544, 54, 61],
                    [9547, 34, 41], [9548, 58, 67], [9549, 31, 31], [9550, 60, 53], [9551, 32, 45], [9552, 78, 75],
                    [9553, 39, 43], [9554, 57, 65], [9555, 55, 90], [9556, 81, 90], [9557, 42, 47], [9558, 91, 76],
                    [9561, 38, 54], [9562, 61, 84], [9581, 44, 53], [9582, 51, 67], [9593, 32, 45], [9594, 52, 79],
                    [9595, 36, 46], [9596, 61, 70], [9597, 25, 24], [9598, 75, 90], [9609, 31, 31], [9610, 47, 53],
                    [9611, 45, 45], [9612, 57, 60], [9613, 60, 90], [9614, 86, 90], [9617, 17, 15], [9618, 58, 53],
                    [9619, 21, 20], [9620, 21, 20], [9633, 48, 57], [9634, 86, 74], [9639, 18, 24], [9640, 66, 53],
                    [9641, 49, 38], [9642, 120, 65], [9643, 26, 42], [9644, 52, 67], [9651, 90, 60], [9652, 90, 60],
                    [9653, 50, 45], [9654, 65, 39], [9661, 80, 47], [9662, 100, 44], [9663, 70, 45], [9664, 70, 45],
                    [9665, 48, 40], [9666, 60, 40], [9667, 21, 18], [9668, 38, 32], [9670, 100, 55], [9673, 40, 24],
                    [9674, 45, 24], [9675, 35, 37], [9676, 57, 46], [9677, 20, 21], [9678, 35, 25], [9681, 50, 37],
                    [9682, 60, 37], [9687, 19, 28], [9689, 23, 21], [9690, 40, 33], [9691, 60, 38], [9692, 40, 31],
                    [9693, 40, 33], [9694, 40, 35], [9695, 39, 38], [9696, 43, 35], [9699, 31, 35], [9700, 80, 45],
                    [9701, 32, 27], [9702, 100, 45], [9704, 90, 43], [9705, 35, 40], [9706, 100, 60], [9709, 21, 17],
                    [9710, 25, 18], [9711, 25, 30], [9712, 25, 30], [9713, 31, 31], [9714, 35, 49], [9715, 70, 55],
                    [9716, 25, 25], [9717, 35, 35], [9718, 31, 29], [9720, 55, 46], [9721, 65, 39], [9722, 39, 43],
                    [9723, 55, 40], [9724, 68, 58], [9725, 75, 52], [9726, 25, 28], [9727, 47, 31], [9728, 25, 25],
                    [9729, 21, 23], [9730, 42, 50], [9731, 68, 55], [9735, 46, 48], [9736, 50, 55], [9737, 35, 21],
                    [9738, 38, 46], [9739, 46, 42], [9740, 90, 90], [9741, 95, 78], [9742, 53, 46], [9743, 35, 31],
                    [9744, 95, 60], [9745, 40, 23], [9746, 46, 28], [9747, 40, 55], [9748, 40, 45], [9751, 42, 47],
                    [9752, 39, 57], [9755, 38, 36], [9756, 35, 33], [9757, 21, 18], [9758, 25, 18], [9759, 20, 14],
                    [9760, 34, 22], [9761, 35, 23], [9762, 33, 17], [9763, 21, 15], [9764, 23, 14], [9765, 32, 24],
                    [9766, 35, 18], [9767, 34, 39], [9768, 28, 21], [9769, 23, 16], [9770, 39, 33], [9771, 43, 21],
                    [9772, 28, 15], [9773, 33, 25], [9774, 21, 17], [9775, 23, 17], [9776, 26, 14], [9777, 34, 22],
                    [9778, 35, 25], [9779, 33, 24], [9780, 34, 26], [9781, 27, 16], [9782, 35, 25], [9783, 30, 19],
                    [9784, 30, 23], [9785, 26, 22], [9786, 20, 15], [9787, 33, 23], [9788, 20, 16], [9789, 35, 19],
                    [9790, 34, 22], [9791, 36, 26], [9792, 34, 29], [9793, 16, 12], [9794, 13, 13], [9795, 12, 12],
                    [9796, 17, 15], [9797, 14, 12], [9798, 14, 13], [9799, 35, 30], [9800, 20, 19], [9801, 18, 15],
                    [9802, 18, 15], [9803, 11, 9], [9804, 17, 14], [9805, 29, 23], [9806, 19, 16], [9807, 28, 19],
                    [9808, 58, 38], [9809, 34, 17], [9811, 35, 23], [9812, 54, 36], [9813, 49, 24], [9814, 20, 13],
                    [9815, 38, 23], [9816, 29, 16], [9817, 22, 13], [9818, 49, 19], [9819, 42, 30], [9820, 52, 33],
                    [9821, 42, 25], [9822, 22, 19], [9823, 26, 19], [9824, 28, 23], [9825, 19, 16], [9826, 40, 31],
                    [9827, 38, 25], [9828, 46, 32], [9829, 33, 24], [9830, 28, 23], [9831, 34, 23], [9832, 31, 21],
                    [9833, 30, 22], [9834, 53, 35], [9835, 33, 28], [9836, 39, 28], [9837, 28, 20], [9838, 44, 33],
                    [9839, 18, 16], [9840, 36, 27], [9841, 63, 39], [9842, 32, 20], [9843, 28, 20], [9844, 33, 22],
                    [9845, 29, 24], [9846, 26, 18], [9847, 15, 13], [9848, 26, 17], [9849, 24, 16], [9850, 25, 14],
                    [9851, 24, 13], [9852, 19, 12], [9853, 23, 17], [9854, 14, 12], [9855, 26, 23], [9856, 15, 16],
                    [9857, 16, 13], [9858, 37, 25], [9859, 48, 31], [9860, 42, 31], [9861, 53, 45], [9862, 25, 26],
                    [9863, 39, 28], [9864, 48, 23], [9865, 34, 22], [9866, 47, 22], [9867, 20, 16], [9868, 40, 28],
                    [9869, 36, 23], [9870, 35, 37], [9871, 39, 25], [9872, 23, 21], [9873, 31, 29], [9874, 35, 20],
                    [9875, 31, 23], [9876, 24, 21], [9877, 33, 26], [9878, 34, 23], [9879, 35, 22], [9880, 36, 28],
                    [9881, 41, 24], [9882, 32, 27], [9883, 30, 20], [9884, 31, 19], [9885, 35, 21], [9886, 38, 21],
                    [9887, 35, 25], [9888, 44, 33], [9889, 39, 26], [9890, 35, 26], [9891, 30, 21], [9892, 28, 22],
                    [9893, 25, 18], [9894, 44, 30], [9895, 26, 16], [9896, 11, 14], [9897, 32, 22], [9898, 35, 26],
                    [9899, 22, 18], [9900, 48, 40], [9901, 43, 31], [9902, 58, 43], [9903, 57, 48], [9904, 52, 38],
                    [9905, 34, 28], [9906, 39, 24], [9907, 30, 26], [9908, 52, 35], [9909, 16, 14], [9910, 43, 37],
                    [9911, 58, 36], [9912, 41, 27], [9913, 23, 20], [9914, 31, 23], [9915, 29, 25], [9916, 30, 27],
                    [9917, 24, 22], [9918, 61, 26], [9919, 61, 50], [9920, 62, 45], [9921, 25, 20], [9922, 26, 16],
                    [9923, 29, 21], [9924, 35, 22], [9925, 44, 39], [9926, 35, 37], [9927, 29, 21], [9928, 47, 27],
                    [9929, 36, 33], [9930, 36, 24], [9931, 46, 30], [9932, 48, 26], [9933, 44, 33], [9934, 39, 24],
                    [9935, 34, 22], [9936, 35, 26], [9937, 26, 24], [9938, 16, 15], [9939, 41, 22], [9940, 33, 28],
                    [9941, 36, 21], [9942, 20, 16], [9943, 71, 46], [9944, 38, 24], [9945, 55, 28], [9946, 34, 19],
                    [9947, 46, 26], [9948, 69, 38], [9949, 68, 43], [9950, 47, 37], [9951, 33, 22], [9952, 44, 24],
                    [9953, 23, 19], [9954, 54, 36], [9955, 22, 19], [9956, 46, 24], [9957, 63, 34], [9958, 26, 22],
                    [9959, 69, 38], [9960, 39, 22], [9961, 27, 24], [9962, 32, 22], [9963, 56, 35], [9964, 32, 28],
                    [9965, 30, 15], [9966, 46, 26], [9967, 56, 30], [9968, 35, 32], [9969, 30, 19], [9970, 49, 26],
                    [9971, 26, 21], [9972, 71, 35], [9973, 38, 31], [9974, 31, 16], [9975, 67, 32], [9976, 75, 37],
                    [9977, 32, 19], [9978, 38, 20], [9979, 62, 33], [9980, 37, 21], [9981, 24, 16], [9982, 17, 13],
                    [9983, 58, 29], [9984, 33, 23], [9985, 36, 23], [9986, 36, 24], [9987, 38, 31], [9988, 33, 23],
                    [9989, 30, 25], [9990, 35, 22], [9991, 36, 28], [9992, 41, 31], [9993, 29, 31], [9994, 24, 22],
                    [9995, 38, 30], [9996, 29, 25], [9997, 16, 20], [9998, 17, 15], [9999, 25, 27], [10000, 23, 17],
                    [10001, 19, 16], [10002, 17, 14], [10003, 36, 24], [10004, 21, 17], [10005, 21, 17],
                    [10006, 16, 13], [10007, 32, 34], [10008, 47, 44], [10009, 43, 28], [10010, 48, 28],
                    [10011, 41, 26], [10012, 49, 23], [10013, 30, 24], [10014, 36, 32], [10015, 29, 26],
                    [10016, 33, 32], [10017, 39, 30], [10018, 38, 32], [10019, 38, 29], [10020, 47, 38],
                    [10021, 53, 37], [10022, 53, 40], [10023, 49, 36], [10024, 72, 48], [10025, 63, 48],
                    [10026, 57, 41], [10027, 48, 37], [10030, 47, 37], [10031, 72, 60], [10032, 63, 46],
                    [10033, 40, 29], [10034, 48, 31], [10035, 66, 37], [10036, 72, 34], [10037, 67, 38],
                    [10038, 29, 19], [10039, 20, 20], [10040, 27, 19], [10041, 27, 16], [10042, 50, 33],
                    [10043, 51, 27], [10044, 58, 27], [10045, 34, 21], [10046, 47, 31], [10047, 44, 24],
                    [10048, 41, 26], [10049, 31, 22], [10050, 40, 28], [10051, 50, 34], [10052, 50, 41],
                    [10053, 53, 39], [10054, 46, 39], [10055, 51, 42], [10056, 45, 42], [10057, 53, 43],
                    [10058, 30, 32], [10059, 55, 31], [10060, 45, 30], [10061, 51, 45], [10063, 20, 20],
                    [10064, 34, 27], [10065, 31, 34], [10066, 35, 30], [10067, 48, 37], [10068, 58, 42],
                    [10069, 49, 38], [10070, 38, 23], [10071, 46, 33], [10072, 51, 21], [10073, 49, 25],
                    [10074, 47, 25], [10075, 53, 31], [10076, 52, 31], [10077, 48, 31], [10078, 61, 37],
                    [10079, 38, 28], [10080, 37, 31], [10081, 57, 38], [10082, 38, 40], [10083, 37, 33],
                    [10084, 39, 28], [10085, 38, 21], [10086, 41, 25], [10087, 38, 18], [10088, 50, 33],
                    [10089, 51, 34], [10090, 40, 31], [10091, 51, 25], [10092, 52, 27], [10093, 37, 31],
                    [10094, 64, 41], [10095, 57, 38], [10096, 47, 30], [10097, 42, 29], [10098, 47, 32],
                    [10099, 59, 41], [10101, 58, 45], [10102, 49, 36], [10103, 51, 45], [10104, 19, 18],
                    [10105, 28, 20], [10106, 28, 25], [10107, 49, 43], [10108, 54, 46], [10109, 100, 64],
                    [10110, 46, 38], [10111, 63, 47], [10112, 63, 49], [10113, 92, 74], [10114, 56, 36],
                    [10115, 37, 27], [10116, 41, 33], [10117, 40, 35], [10118, 43, 43], [10119, 24, 15],
                    [10120, 29, 19], [10121, 56, 46], [10122, 55, 45], [10123, 72, 59], [10124, 61, 56],
                    [10125, 57, 34], [10126, 51, 32], [10127, 50, 30], [10128, 51, 36], [10129, 77, 50],
                    [10130, 72, 49], [10131, 39, 31], [10132, 40, 31], [10133, 51, 29], [10134, 80, 56],
                    [10135, 78, 61], [10136, 45, 25], [10137, 56, 38], [10138, 46, 27], [10139, 47, 29],
                    [10141, 43, 29], [10142, 47, 29], [10144, 57, 29], [10145, 39, 36], [10146, 43, 38],
                    [10148, 40, 24], [10149, 42, 42], [10150, 25, 28], [10151, 41, 36], [10152, 52, 40],
                    [10153, 58, 44], [10154, 22, 23], [10155, 50, 47], [10156, 33, 28], [10157, 53, 39],
                    [10158, 31, 32], [10159, 42, 32], [10160, 44, 28], [10161, 60, 36], [10162, 48, 25],
                    [10163, 68, 35], [10164, 47, 25], [10165, 53, 29], [10166, 40, 24], [10167, 46, 34],
                    [10168, 48, 37], [10169, 50, 36], [10170, 28, 31], [10171, 43, 35], [10172, 34, 28],
                    [10173, 42, 34], [10174, 42, 27], [10175, 48, 33], [10176, 18, 19], [10177, 16, 18],
                    [10178, 19, 19], [10179, 17, 19], [10180, 36, 28], [10181, 22, 15], [10182, 34, 34],
                    [10183, 40, 24], [10184, 37, 17], [10185, 16, 14], [10186, 15, 12], [10187, 20, 17],
                    [10188, 21, 14], [10189, 47, 28], [10190, 19, 14], [10191, 39, 24], [10192, 30, 20],
                    [10193, 18, 17], [10194, 15, 11], [10195, 14, 12], [10196, 38, 28], [10197, 37, 26],
                    [10198, 28, 29], [10199, 27, 29], [10200, 27, 30], [10201, 26, 27], [10202, 61, 50],
                    [10203, 52, 37], [10204, 53, 37], [10205, 42, 31], [10206, 39, 27], [10207, 37, 26],
                    [10208, 39, 29], [10209, 37, 27], [10210, 43, 34], [10211, 41, 32], [10212, 44, 29],
                    [10213, 44, 28], [10214, 39, 33], [10215, 37, 32], [10216, 45, 32], [10217, 48, 34],
                    [10218, 41, 33], [10219, 40, 33], [10220, 38, 31], [10221, 41, 28], [10222, 39, 30],
                    [10223, 48, 39], [10224, 57, 46], [10225, 50, 45], [10226, 30, 28], [10227, 31, 28],
                    [10228, 29, 26], [10234, 42, 33], [10235, 34, 29], [10236, 34, 30], [10237, 25, 24],
                    [10238, 33, 30], [10239, 47, 39], [10240, 28, 26], [10241, 23, 28], [10242, 29, 25],
                    [10243, 33, 27], [10244, 33, 34], [10245, 17, 22], [10246, 31, 27], [10247, 20, 22],
                    [10248, 33, 24], [10249, 20, 24], [10250, 32, 29], [10251, 31, 26], [10252, 32, 29],
                    [10253, 32, 31], [10255, 31, 29], [10256, 38, 34], [10257, 30, 26], [10258, 34, 31],
                    [10259, 16, 23], [10260, 33, 30], [10261, 35, 27], [10263, 19, 22], [10264, 34, 29],
                    [10267, 23, 22], [10268, 33, 26], [10269, 22, 23], [10270, 29, 29], [10271, 34, 27],
                    [10272, 27, 25], [10276, 27, 26], [10277, 35, 31], [10278, 21, 25], [10279, 32, 29],
                    [10280, 20, 26], [10281, 32, 33], [10283, 21, 23], [10284, 27, 27], [10285, 20, 21],
                    [10286, 27, 24], [10287, 27, 24], [10288, 28, 22], [10289, 32, 27], [10290, 29, 25],
                    [10291, 29, 26], [10292, 22, 24], [10293, 29, 29], [10294, 16, 22], [10295, 21, 25],
                    [10296, 29, 28], [10297, 21, 23], [10298, 28, 27], [10299, 21, 23], [10300, 29, 26],
                    [10301, 29, 29], [10302, 21, 24], [10303, 32, 31], [10304, 21, 25], [10305, 30, 29],
                    [10306, 25, 28], [10307, 25, 27], [10309, 27, 25], [10310, 21, 25], [10311, 31, 30],
                    [10312, 25, 24], [10313, 35, 27], [10314, 34, 28], [10315, 31, 24], [10317, 23, 23],
                    [10318, 38, 30], [10319, 23, 27], [10320, 46, 30], [10321, 24, 23], [10322, 32, 32],
                    [10323, 22, 27], [10326, 42, 33], [10327, 22, 24], [10329, 27, 23], [10330, 25, 27],
                    [10332, 19, 22], [10333, 30, 29], [10334, 31, 29], [10335, 30, 31], [10337, 22, 22],
                    [10338, 35, 29], [10339, 24, 25], [10340, 37, 29], [10341, 20, 21], [10342, 30, 25],
                    [10343, 26, 24], [10344, 25, 28], [10347, 20, 27], [10354, 19, 21], [10355, 32, 28],
                    [10356, 23, 25], [10357, 31, 31], [10358, 30, 26], [10360, 19, 22], [10361, 33, 27],
                    [10362, 30, 29], [10363, 42, 30], [10364, 50, 30], [10366, 33, 30], [10367, 40, 28],
                    [10368, 48, 33], [10369, 40, 29], [10370, 51, 35], [10371, 29, 34], [10372, 19, 22],
                    [10374, 21, 24], [10376, 20, 21], [10377, 25, 25], [10378, 27, 27], [10380, 24, 25],
                    [10381, 42, 32], [10382, 25, 26], [10383, 50, 32], [10384, 29, 28], [10385, 52, 33],
                    [10388, 17, 24], [10390, 23, 26], [10391, 28, 24], [10392, 27, 27], [10394, 20, 21],
                    [10395, 30, 27], [10396, 21, 23], [10398, 21, 25], [10399, 31, 28], [10400, 22, 24],
                    [10402, 20, 26], [10403, 35, 34], [10404, 24, 27], [10408, 20, 26], [10409, 31, 33],
                    [10410, 22, 27], [10411, 34, 31], [10412, 32, 21], [10413, 57, 36], [10417, 33, 33],
                    [10418, 20, 22], [10419, 28, 28], [10420, 33, 33], [10422, 26, 28], [10424, 36, 30],
                    [10425, 20, 24], [10426, 30, 30], [10427, 25, 24], [10428, 27, 29], [10431, 21, 25],
                    [10432, 33, 29], [10433, 19, 22], [10434, 33, 28], [10435, 31, 26], [10436, 24, 23],
                    [10437, 29, 23], [10438, 22, 24], [10439, 31, 32], [10440, 20, 25], [10441, 30, 27],
                    [10442, 25, 26], [10443, 20, 21], [10444, 32, 24], [10445, 35, 29], [10447, 19, 20],
                    [10448, 31, 27], [10450, 19, 23], [10453, 44, 26], [10454, 38, 25], [10455, 44, 29],
                    [10456, 19, 22], [10458, 20, 22], [10459, 27, 24], [10461, 21, 26], [10463, 17, 21],
                    [10464, 26, 27], [10467, 20, 26], [10469, 23, 23], [10471, 22, 21], [10474, 13, 11],
                    [10475, 13, 11], [10476, 15, 16], [10477, 17, 17], [10478, 23, 28], [10479, 32, 24],
                    [10480, 19, 20], [10482, 20, 23], [10483, 26, 28], [10484, 20, 23], [10485, 25, 29],
                    [10486, 20, 23], [10487, 25, 30], [10490, 16, 25], [10491, 9, 21], [10492, 8, 13], [10493, 34, 33],
                    [10494, 11, 37], [10495, 11, 27], [10496, 9, 18], [10497, 28, 50], [10498, 9, 24], [10499, 9, 53],
                    [10500, 11, 54], [10501, 11, 54], [10502, 32, 73], [10503, 11, 56], [10504, 14, 75],
                    [10505, 33, 51], [10506, 15, 34], [10507, 9, 21], [10508, 26, 56], [10509, 28, 38], [10510, 14, 39],
                    [10511, 7, 19], [10512, 19, 21], [10513, 29, 28], [10514, 15, 22], [10515, 15, 23], [10516, 14, 20],
                    [10517, 19, 25], [10518, 14, 14], [10519, 19, 16], [10520, 9, 9], [10521, 16, 20], [10522, 16, 19],
                    [10523, 16, 19], [10524, 22, 21], [10525, 15, 19], [10526, 16, 20], [10527, 13, 14],
                    [10528, 19, 19], [10529, 19, 19], [10530, 16, 19], [10531, 14, 17], [10532, 22, 21],
                    [10533, 32, 27], [10534, 20, 13], [10535, 31, 25], [10536, 16, 19], [10537, 22, 20],
                    [10538, 29, 24], [10539, 17, 17], [10540, 31, 25], [10541, 38, 32], [10542, 40, 28], [10543, 7, 7],
                    [10544, 11, 9], [10545, 7, 7], [10546, 10, 8], [10547, 8, 8], [10548, 12, 9], [10549, 8, 8],
                    [10550, 9, 11], [10551, 9, 8], [10552, 7, 7], [10553, 24, 16], [10554, 19, 13], [10555, 11, 8],
                    [10556, 20, 13], [10557, 10, 10], [10558, 30, 20], [10559, 14, 9], [10560, 20, 13], [10577, 22, 13],
                    [10578, 33, 37], [10579, 60, 40], [10580, 75, 42], [10581, 63, 53], [10582, 52, 39],
                    [10583, 49, 42], [10584, 49, 42], [10585, 40, 41], [10586, 52, 47], [10587, 47, 40],
                    [10588, 41, 38], [10589, 46, 42], [10590, 60, 47], [10591, 68, 63], [10592, 53, 31],
                    [10593, 48, 39], [10594, 53, 49], [10595, 39, 41], [10596, 40, 37], [10597, 46, 38],
                    [10598, 41, 31], [10602, 26, 29], [10603, 38, 35], [10604, 34, 24], [10605, 17, 12],
                    [10606, 15, 10], [10607, 20, 15], [10608, 14, 10], [10609, 14, 10], [10610, 21, 11],
                    [10611, 21, 14], [10612, 19, 14], [10613, 46, 32], [10614, 47, 24], [10615, 42, 30],
                    [10616, 42, 31], [10617, 48, 35], [10618, 52, 28], [10619, 39, 23], [10620, 28, 19],
                    [10621, 46, 28], [10622, 34, 18], [10623, 39, 25], [10624, 48, 24], [10625, 30, 20],
                    [10626, 48, 26], [10627, 45, 30], [10628, 50, 31], [10629, 48, 31], [10630, 48, 28],
                    [10631, 48, 25], [10632, 34, 21], [10633, 54, 43], [10634, 47, 32], [10635, 49, 35],
                    [10636, 39, 28], [10637, 58, 32], [10638, 23, 16], [10639, 49, 34], [10640, 46, 27],
                    [10641, 45, 28], [10642, 54, 32], [10643, 39, 25], [10644, 62, 36], [10645, 34, 28],
                    [10646, 47, 29], [10647, 47, 28], [10648, 40, 32], [10649, 43, 25], [10650, 47, 33],
                    [10651, 45, 32], [10652, 40, 24], [10653, 49, 30], [10654, 40, 28], [10655, 46, 32],
                    [10656, 47, 28], [10657, 37, 28], [10658, 50, 28], [10659, 20, 17], [10660, 51, 36],
                    [10661, 76, 29], [10662, 47, 29], [10663, 44, 28], [10664, 48, 32], [10665, 50, 32],
                    [10666, 80, 36], [10667, 65, 32], [10668, 45, 32], [10669, 20, 16], [10670, 46, 28],
                    [10671, 52, 29], [10672, 51, 27], [10673, 34, 22], [10674, 39, 22], [10675, 50, 37],
                    [10676, 39, 35], [10677, 38, 21], [10678, 39, 25], [10679, 56, 28], [10680, 35, 28],
                    [10681, 42, 32], [10682, 39, 24], [10683, 37, 24], [10684, 26, 19], [10685, 80, 37],
                    [10686, 45, 38], [10687, 39, 38], [10688, 58, 39], [10689, 58, 38], [10690, 59, 40],
                    [10691, 61, 40], [10692, 61, 37], [10693, 82, 37], [10694, 60, 33], [10695, 62, 32],
                    [10696, 49, 29], [10697, 32, 24], [10698, 39, 32], [10699, 46, 34], [10700, 20, 15],
                    [10701, 50, 30], [10702, 74, 26], [10703, 75, 26], [10704, 49, 25], [10705, 57, 24],
                    [10706, 50, 36], [10707, 41, 42], [10708, 55, 44], [10709, 48, 43], [10710, 69, 32],
                    [10711, 47, 32], [10712, 51, 37], [10713, 64, 38], [10714, 45, 28], [10715, 60, 32],
                    [10716, 49, 40], [10717, 47, 40], [10718, 45, 40], [10719, 61, 36], [10720, 62, 40],
                    [10721, 28, 21], [10722, 61, 39], [10723, 48, 38], [10724, 51, 39], [10725, 48, 38],
                    [10726, 36, 24], [10727, 47, 27], [10728, 50, 28], [10729, 58, 36], [10730, 65, 34],
                    [10731, 37, 32], [10732, 60, 38], [10733, 50, 32], [10734, 49, 32], [10735, 50, 26],
                    [10736, 49, 32], [10737, 83, 45], [10738, 51, 29], [10739, 28, 15], [10740, 47, 32],
                    [10741, 50, 38], [10742, 47, 31], [10743, 40, 27], [10744, 39, 24], [10745, 46, 28],
                    [10746, 46, 24], [10747, 28, 16], [10748, 42, 26], [10749, 45, 30], [10750, 47, 32],
                    [10751, 46, 32], [10752, 47, 32], [10753, 56, 36], [10754, 44, 26], [10755, 20, 15],
                    [10756, 79, 45], [10757, 20, 14], [10758, 29, 18], [10759, 52, 26], [10760, 54, 31],
                    [10761, 45, 29], [10762, 46, 36], [10763, 39, 25], [10764, 28, 21], [10765, 34, 23],
                    [10766, 60, 34], [10767, 49, 32], [10768, 45, 30], [10769, 47, 28], [10770, 47, 34],
                    [10771, 49, 37], [10772, 37, 42], [10773, 47, 46], [10774, 38, 23], [10775, 45, 23],
                    [10776, 40, 22], [10777, 32, 20], [10778, 78, 36], [10779, 38, 27], [10780, 45, 28],
                    [10781, 40, 28], [10782, 48, 30], [10783, 57, 34], [10784, 48, 30], [10785, 50, 26],
                    [10786, 44, 32], [10787, 50, 28], [10788, 46, 34], [10789, 42, 25], [10790, 50, 25],
                    [10791, 51, 25], [10792, 35, 28], [10793, 47, 28], [10794, 51, 32], [10795, 52, 32],
                    [10796, 53, 32], [10797, 46, 30], [10798, 38, 28], [10799, 23, 16], [10800, 47, 31],
                    [10801, 62, 36], [10802, 49, 25], [10803, 34, 20], [10804, 60, 32], [10805, 73, 33],
                    [10806, 41, 32], [10807, 46, 23], [10808, 36, 20], [10809, 30, 26], [10810, 47, 30],
                    [10811, 50, 28], [10812, 128, 50], [10814, 38, 28], [10815, 47, 30], [10816, 49, 32],
                    [10817, 47, 30], [10818, 49, 32], [10819, 48, 30], [10820, 49, 27], [10821, 44, 28],
                    [10822, 47, 30], [10823, 50, 28], [10824, 37, 26], [10825, 38, 32], [10826, 42, 25],
                    [10827, 39, 30], [10828, 33, 26], [10829, 50, 32], [10830, 46, 27], [10831, 47, 32],
                    [10832, 45, 26], [10833, 45, 26], [10834, 46, 27], [10835, 47, 28], [10836, 45, 27],
                    [10837, 52, 28], [10838, 47, 27], [10839, 38, 26], [10840, 28, 20], [10841, 60, 30],
                    [10842, 34, 30], [10843, 47, 30], [10844, 34, 26], [10845, 32, 24], [10846, 36, 26],
                    [10847, 40, 28], [10848, 47, 32], [10849, 47, 32], [10850, 41, 27], [10851, 48, 30],
                    [10852, 45, 28], [10853, 58, 40], [10854, 47, 32], [10855, 50, 27], [10856, 49, 31],
                    [10857, 49, 32], [10858, 46, 28], [10859, 50, 28], [10860, 61, 30], [10861, 57, 30],
                    [10862, 51, 28], [10863, 25, 19], [10864, 67, 31], [10865, 46, 32], [10866, 36, 22],
                    [10867, 47, 26], [10868, 46, 26], [10869, 70, 32], [10870, 61, 36], [10871, 50, 25],
                    [10872, 70, 30], [10873, 59, 32], [10874, 58, 32], [10875, 50, 32], [10876, 59, 26],
                    [10877, 71, 30], [10878, 49, 26], [10879, 50, 32], [10880, 52, 32], [10881, 40, 26],
                    [10882, 59, 32], [10883, 71, 36], [10884, 80, 36], [10885, 50, 33], [10886, 48, 24],
                    [10887, 39, 28], [10888, 62, 32], [10889, 47, 28], [10890, 41, 25], [10891, 29, 21],
                    [10892, 34, 21], [10893, 51, 41], [10894, 48, 40], [10895, 72, 35], [10896, 47, 36],
                    [10897, 50, 37], [10898, 45, 37], [10899, 58, 30], [10900, 47, 30], [10901, 42, 30],
                    [10902, 45, 23], [10903, 50, 32], [10904, 52, 32], [10905, 38, 23], [10906, 50, 35],
                    [10907, 50, 35], [10908, 46, 28], [10909, 60, 38], [10910, 47, 32], [10911, 61, 32],
                    [10912, 60, 45], [10913, 40, 36], [10914, 78, 36], [10915, 52, 41], [10916, 56, 41],
                    [10917, 63, 40], [10918, 35, 30], [10978, 47, 32], [10979, 43, 27], [10980, 45, 25], [11091, 8, 5],
                    [11092, 10, 8], [11093, 12, 7], [11094, 16, 12], [11095, 10, 7], [11096, 19, 12], [11097, 10, 8],
                    [11098, 9, 7], [11099, 32, 18], [11100, 14, 11], [11101, 11, 9], [11102, 12, 9], [11103, 15, 10],
                    [11104, 48, 22], [11105, 34, 22], [11106, 29, 15], [11107, 17, 10], [11108, 9, 6], [11109, 16, 12],
                    [11110, 16, 9], [11111, 13, 7], [11112, 23, 14], [11113, 28, 17], [11114, 53, 33], [11115, 7, 6],
                    [11116, 8, 6], [11117, 8, 5], [11118, 15, 9], [11119, 48, 25], [11120, 28, 16], [11121, 9, 6],
                    [11122, 12, 8], [11123, 21, 12], [11124, 9, 8], [11125, 27, 15], [11126, 13, 11], [11127, 7, 7],
                    [11128, 13, 7], [11129, 7, 6], [11130, 15, 10], [11131, 7, 6], [11132, 24, 14], [11133, 11, 8],
                    [11134, 6, 4], [11135, 66, 26], [11136, 10, 8], [11137, 6, 5], [11138, 19, 11], [11139, 10, 6],
                    [11140, 10, 9], [11141, 8, 6], [11142, 9, 7], [11143, 7, 6], [11144, 9, 8], [11145, 31, 19],
                    [11146, 7, 6], [11147, 5, 3], [11148, 43, 22], [11149, 18, 11], [11150, 18, 16], [11151, 23, 16],
                    [11152, 16, 11], [11153, 15, 9], [11154, 25, 18], [11155, 19, 10], [11156, 11, 10], [11157, 14, 10],
                    [11158, 15, 10], [11159, 20, 10], [11160, 30, 15], [11161, 12, 10], [11162, 18, 12],
                    [11163, 15, 12], [11164, 17, 16], [11165, 17, 12], [11166, 45, 27], [11167, 75, 43],
                    [11168, 28, 20], [11169, 8, 8], [11170, 10, 9], [11171, 12, 10], [11172, 10, 9], [11173, 12, 11],
                    [11174, 6, 6], [11175, 6, 6], [11176, 6, 6], [11177, 21, 18], [11178, 7, 7], [11179, 14, 12],
                    [11180, 13, 10], [11181, 16, 13], [11182, 14, 11], [11183, 14, 13], [11184, 102, 79],
                    [11185, 102, 79], [11186, 102, 79], [11187, 102, 79], [11188, 102, 79], [11189, 78, 90],
                    [11195, 19, 18], [11197, 97, 45], [11199, 52, 28], [11201, 10, 10], [11202, 51, 32],
                    [11203, 13, 14], [11204, 77, 50], [11205, 108, 74], [11206, 61, 54], [11207, 9, 9],
                    [11209, 221, 200], [11210, 780, 95], [11211, 102, 103], [11212, 780, 103], [11213, 780, 95],
                    [11214, 780, 95], [11215, 102, 103], [11216, 780, 103], [11217, 102, 103], [11218, 780, 103],
                    [11219, 102, 103], [11220, 780, 95], [11221, 102, 103], [11222, 102, 103], [11223, 102, 97],
                    [11224, 102, 103], [11225, 780, 103], [11226, 780, 103], [11228, 102, 103], [11229, 102, 103],
                    [11230, 102, 103], [11231, 102, 103], [11232, 102, 103], [11233, 102, 103], [11234, 102, 97],
                    [11235, 102, 103], [11236, 102, 103], [11237, 780, 103], [11238, 780, 103], [11239, 102, 103],
                    [11240, 102, 103], [11241, 102, 103], [11242, 102, 103], [11243, 780, 95], [11245, 102, 103],
                    [11246, 221, 179], [11247, 221, 179], [11248, 102, 103], [11249, 102, 103], [11250, 102, 103],
                    [11251, 102, 103], [11252, 102, 103], [11253, 102, 103], [11254, 102, 97], [11255, 102, 103],
                    [11256, 102, 103], [11257, 780, 103], [11258, 780, 103], [11259, 780, 95], [11260, 780, 103],
                    [11262, 102, 103], [11263, 102, 103], [11264, 102, 103], [11265, 102, 103], [11266, 102, 103],
                    [11267, 102, 103], [11268, 102, 103], [11269, 102, 103], [11270, 221, 179], [11271, 780, 103],
                    [11272, 780, 103], [11274, 102, 103], [11275, 102, 97], [11276, 102, 103], [11277, 102, 103],
                    [11278, 102, 103], [11279, 221, 179], [11280, 780, 103], [11281, 780, 103], [11283, 102, 97],
                    [11284, 102, 103], [11285, 102, 97], [11286, 102, 103], [11287, 102, 97], [11288, 102, 103],
                    [11289, 102, 103], [11290, 780, 103], [11291, 780, 103], [11292, 14, 18], [11293, 10, 12],
                    [11294, 12, 15], [11295, 12, 15], [11296, 31, 55], [11297, 92, 68], [11298, 23, 20],
                    [11300, 41, 44], [11303, 19, 17], [11304, 30, 20], [11305, 60, 49], [11306, 14, 20],
                    [11307, 16, 20], [11308, 18, 30], [11309, 27, 24], [11310, 21, 21], [11311, 21, 22],
                    [11312, 24, 20], [11313, 18, 21], [11314, 35, 36], [11315, 33, 30], [11316, 30, 33],
                    [11317, 33, 33], [11318, 19, 22], [11319, 21, 19], [11320, 20, 18], [11321, 48, 33],
                    [11322, 62, 32], [11323, 25, 27], [11324, 30, 21], [11325, 37, 22], [11326, 26, 28],
                    [11327, 31, 23], [11328, 28, 32], [11329, 23, 28], [11330, 35, 36], [11331, 32, 34],
                    [11332, 20, 18], [11333, 38, 28], [11334, 45, 29], [11335, 29, 22], [11336, 13, 14],
                    [11337, 25, 27], [11338, 26, 28], [11339, 34, 28], [11340, 33, 33], [11341, 38, 31],
                    [11342, 33, 33], [11343, 34, 37], [11344, 33, 36], [11345, 27, 32], [11346, 42, 31],
                    [11347, 33, 28], [11348, 46, 39], [11349, 21, 18], [11350, 33, 33], [11351, 30, 33],
                    [11352, 30, 33], [11353, 39, 37], [11354, 29, 23], [11355, 34, 28], [11356, 32, 26],
                    [11357, 27, 24], [11358, 25, 27], [11359, 41, 44], [11360, 40, 26], [11361, 46, 39],
                    [11362, 29, 27], [11363, 9, 10], [11364, 11, 12], [11365, 36, 23], [11366, 21, 21], [11367, 45, 44],
                    [11368, 21, 23], [11369, 53, 55], [11370, 22, 26], [11371, 31, 31], [11372, 32, 34],
                    [11373, 55, 35], [11374, 40, 40], [11375, 60, 46], [11376, 21, 21], [11377, 48, 43],
                    [11378, 28, 29], [11384, 52, 52], [11385, 68, 68], [11386, 66, 68], [11387, 99, 75],
                    [11388, 69, 62], [11389, 53, 45], [11390, 58, 56], [11391, 49, 40], [11392, 99, 75],
                    [11393, 70, 65], [11394, 97, 68], [11395, 99, 75], [11396, 97, 90], [11397, 97, 83],
                    [11398, 64, 67], [11399, 95, 90], [11400, 99, 75], [11401, 87, 36], [11402, 61, 68],
                    [11403, 58, 67], [11404, 106, 79], [11405, 78, 75], [11406, 87, 71], [11407, 41, 41],
                    [11408, 89, 62], [11409, 57, 50], [11410, 88, 69], [11411, 60, 55], [11412, 94, 90],
                    [11413, 90, 78], [11414, 64, 90], [11415, 98, 75], [11416, 38, 37], [11417, 59, 59],
                    [11418, 60, 65], [11419, 57, 60], [11420, 87, 74], [11421, 99, 73], [11422, 74, 84],
                    [11423, 60, 82], [11424, 58, 48], [11425, 22, 18], [11426, 9, 7], [11427, 8, 8], [11428, 53, 26],
                    [11429, 15, 12], [11430, 9, 10], [11431, 12, 10], [11432, 8, 8], [11433, 10, 12], [11434, 10, 9],
                    [11435, 7, 8], [11436, 20, 20], [11437, 12, 11], [11438, 10, 9], [11439, 11, 9], [11440, 16, 14],
                    [11441, 46, 28], [11442, 9, 8], [11443, 11, 11], [11444, 14, 9], [11445, 8, 8], [11446, 11, 9],
                    [11447, 17, 14], [11448, 12, 10], [11449, 12, 8], [11450, 12, 10], [11451, 9, 7], [11452, 10, 9],
                    [11453, 30, 19], [11454, 13, 11], [11455, 8, 8], [11456, 8, 8], [11457, 9, 9], [11458, 6, 7],
                    [11459, 6, 6], [11460, 7, 6], [11461, 9, 8], [11462, 7, 7], [11463, 10, 9], [11464, 9, 7],
                    [11465, 18, 14], [11466, 14, 9], [11467, 15, 11], [11468, 38, 25], [11469, 16, 12], [11470, 21, 16],
                    [11471, 15, 14], [11472, 28, 17], [11473, 10, 9], [11474, 8, 9], [11475, 9, 9], [11476, 12, 9],
                    [11477, 24, 19], [11478, 30, 19], [11479, 11, 9], [11480, 21, 17], [11481, 15, 14], [11482, 17, 14],
                    [11483, 19, 15], [11484, 21, 15], [11485, 25, 18], [11486, 23, 15], [11487, 17, 14],
                    [11488, 24, 18], [11489, 13, 11], [11490, 14, 13], [11491, 11, 9], [11492, 8, 7], [11493, 8, 8],
                    [11494, 6, 7], [11495, 6, 6], [11496, 7, 8], [11497, 9, 8], [11498, 9, 8], [11499, 9, 9],
                    [11500, 22, 20], [11501, 8, 8], [11502, 12, 10], [11503, 7, 8], [11504, 9, 9], [11505, 14, 11],
                    [11506, 10, 10], [11507, 11, 12], [11508, 7, 8], [11509, 27, 16], [11510, 11, 9], [11511, 12, 9],
                    [11512, 19, 12], [11513, 13, 11], [11514, 9, 9], [11515, 9, 9], [11516, 14, 11], [11517, 21, 18],
                    [11518, 10, 15], [11519, 22, 15], [11520, 33, 20], [11521, 8, 6], [11522, 10, 10], [11523, 11, 9],
                    [11524, 8, 7], [11525, 11, 8], [11526, 16, 11], [11527, 10, 10], [11528, 8, 7], [11529, 79, 81],
                    [11530, 82, 90], [11531, 79, 52], [11532, 68, 90], [11533, 41, 37], [11534, 95, 90],
                    [11535, 101, 85], [11536, 38, 63], [11537, 106, 65], [11538, 94, 70], [11539, 87, 69],
                    [11540, 58, 44], [11541, 100, 73], [11542, 100, 76], [11543, 101, 68], [11544, 45, 61],
                    [11545, 54, 90], [11546, 120, 76], [11547, 100, 76], [11548, 120, 76], [11549, 57, 46],
                    [11550, 101, 75], [11551, 71, 58], [11552, 100, 90], [11553, 110, 90], [11554, 34, 65],
                    [11555, 63, 70], [11556, 112, 74], [11557, 98, 75], [11558, 59, 90], [11559, 101, 75],
                    [11560, 43, 67], [11561, 120, 90], [11562, 98, 75], [11563, 119, 90], [11564, 88, 90],
                    [11565, 120, 72], [11566, 73, 90], [11567, 101, 75], [11568, 97, 68], [11569, 98, 89],
                    [11570, 98, 75], [11571, 10, 11], [11572, 17, 14], [11573, 120, 90], [11574, 12, 12],
                    [11575, 31, 30], [11576, 14, 14], [11577, 14, 14], [11578, 19, 19], [11579, 18, 25],
                    [11580, 11, 13], [11581, 14, 17], [11582, 18, 20], [11583, 38, 29], [11585, 30, 17],
                    [11586, 54, 26], [11587, 14, 13], [11588, 41, 36], [11589, 49, 29], [11590, 44, 28],
                    [11591, 32, 22], [11592, 71, 39], [11593, 57, 24], [11594, 97, 51], [11595, 46, 27],
                    [11596, 30, 29], [11597, 85, 46], [11598, 29, 14], [11599, 34, 24], [11600, 27, 24],
                    [11601, 55, 38], [11602, 60, 35], [11603, 68, 32], [11604, 16, 17], [11605, 24, 18],
                    [11606, 40, 32], [11607, 36, 27], [11608, 38, 33], [11609, 41, 22], [11610, 30, 36],
                    [11611, 35, 24], [11612, 45, 27], [11613, 38, 25], [11614, 28, 25], [11615, 28, 18],
                    [11616, 26, 22], [11617, 34, 23], [11618, 37, 35], [11619, 26, 21], [11620, 24, 21],
                    [11621, 36, 24], [11622, 25, 39], [11623, 28, 22], [11624, 39, 26], [11625, 28, 27],
                    [11626, 22, 25], [11627, 37, 21], [11628, 32, 27], [11629, 35, 37], [11630, 58, 27],
                    [11631, 57, 42], [11632, 33, 28], [11633, 22, 22], [11634, 37, 33], [11635, 26, 21],
                    [11636, 29, 23], [11637, 35, 26], [11638, 40, 26], [11639, 26, 26], [11640, 58, 38],
                    [11641, 31, 26], [11642, 22, 20], [11643, 39, 26], [11644, 31, 20], [11645, 38, 28],
                    [11646, 20, 19], [11647, 29, 24], [11648, 20, 21], [11649, 23, 20], [11650, 18, 19],
                    [11651, 29, 29], [11652, 32, 23], [11653, 48, 28], [11654, 44, 25], [11655, 45, 30],
                    [11656, 48, 26], [11657, 65, 39], [11658, 31, 23], [11659, 57, 42], [11660, 33, 31],
                    [11661, 30, 22], [11662, 48, 26], [11663, 34, 22], [11664, 26, 27], [11665, 63, 26],
                    [11666, 47, 26], [11667, 59, 36], [11668, 36, 25], [11669, 35, 23], [11670, 42, 29],
                    [11671, 43, 27], [11672, 38, 30], [11673, 49, 30], [11674, 39, 32], [11675, 50, 44],
                    [11676, 45, 30], [11677, 68, 48], [11678, 56, 35], [11679, 46, 25], [11680, 45, 27],
                    [11681, 36, 27], [11682, 65, 32], [11683, 25, 20], [11684, 37, 31], [11685, 25, 22],
                    [11686, 46, 25], [11687, 20, 20], [11688, 62, 41], [11689, 40, 24], [11690, 26, 21],
                    [11691, 32, 25], [11692, 38, 28], [11693, 20, 20], [11694, 19, 19], [11695, 22, 21],
                    [11696, 25, 24], [11697, 24, 24], [11698, 19, 19], [11699, 43, 34], [11700, 32, 32],
                    [11701, 35, 32], [11702, 39, 26], [11703, 19, 17], [11704, 21, 22], [11705, 50, 28],
                    [11706, 149, 65], [11707, 29, 23], [11708, 28, 20], [11709, 59, 28], [11710, 80, 39],
                    [11712, 49, 39], [11713, 86, 40], [11714, 46, 11], [11745, 33, 30], [11746, 31, 19]]],
            [2005, [[25, 12, 9], [48, 53, 36], [49, 27, 20], [51, 30, 26], [62, 18, 25], [65, 19, 16], [78, 20, 18],
                    [82, 15, 16], [83, 28, 31], [99, 26, 25], [101, 46, 37], [119, 33, 23], [138, 40, 28],
                    [163, 32, 30], [166, 27, 26], [190, 26, 25], [200, 33, 25], [204, 15, 27], [211, 21, 36],
                    [216, 21, 18], [218, 37, 22], [220, 15, 16], [226, 18, 14], [231, 45, 35], [233, 17, 18],
                    [234, 12, 12], [240, 63, 37], [243, 42, 26], [246, 34, 25], [272, 33, 15], [282, 37, 27],
                    [286, 18, 21], [305, 20, 24], [308, 11, 27], [310, 17, 17], [312, 19, 18], [314, 17, 23],
                    [324, 32, 28], [327, 36, 31], [329, 32, 23], [346, 44, 35], [355, 38, 27], [361, 26, 25],
                    [378, 17, 19], [379, 14, 12], [389, 25, 26], [392, 17, 17], [399, 54, 29], [424, 19, 18],
                    [425, 14, 18], [428, 24, 18], [430, 19, 21], [432, 47, 28], [436, 42, 35], [471, 18, 19],
                    [479, 47, 37], [480, 50, 28], [487, 24, 22], [497, 9, 14], [503, 98, 28], [504, 12, 10],
                    [505, 35, 24], [519, 16, 22], [536, 25, 18], [541, 91, 36], [545, 20, 23], [568, 17, 17],
                    [569, 64, 25], [570, 24, 19], [577, 37, 21], [585, 46, 36], [590, 44, 49], [593, 43, 35],
                    [597, 32, 14], [604, 99, 53], [608, 23, 18], [612, 28, 27], [618, 20, 17], [628, 29, 26],
                    [631, 26, 22], [660, 44, 31], [662, 48, 40], [663, 55, 28], [669, 26, 18], [678, 17, 21],
                    [686, 17, 18], [691, 23, 26], [694, 31, 24], [695, 54, 41], [700, 44, 34], [703, 15, 15],
                    [716, 46, 40], [724, 18, 26], [734, 20, 25], [751, 27, 20], [754, 27, 25], [766, 77, 41],
                    [769, 48, 30], [801, 17, 18], [803, 28, 25], [805, 24, 20], [820, 51, 29], [822, 15, 19],
                    [826, 18, 17], [827, 11, 13], [835, 39, 25], [843, 30, 27], [845, 41, 33], [848, 23, 19],
                    [865, 72, 28], [871, 33, 19], [878, 7, 6], [882, 37, 27], [894, 25, 12], [913, 17, 17],
                    [915, 42, 31], [922, 29, 35], [926, 41, 19], [938, 11, 12], [940, 11, 13], [941, 34, 36],
                    [949, 47, 29], [950, 14, 17], [964, 11, 15], [969, 42, 34], [971, 17, 15], [979, 17, 17],
                    [985, 61, 30], [998, 38, 28], [1003, 8, 6], [1008, 34, 35], [1016, 11, 13], [1030, 9, 13],
                    [1048, 35, 34], [1056, 21, 33], [1059, 47, 46], [1095, 17, 17], [1097, 28, 17], [1106, 61, 31],
                    [1111, 39, 39], [1131, 40, 31], [1132, 11, 12], [1136, 33, 31], [1142, 22, 20], [1144, 24, 18],
                    [1145, 26, 21], [1150, 29, 21], [1155, 24, 25], [1156, 24, 17], [1157, 35, 31], [1159, 76, 28],
                    [1167, 20, 19], [1169, 25, 23], [1174, 26, 34], [1186, 15, 15], [1194, 72, 35], [1200, 17, 19],
                    [1203, 11, 17], [1213, 20, 16], [1219, 25, 16], [1221, 17, 16], [1226, 28, 23], [1234, 14, 15],
                    [1235, 23, 18], [1238, 14, 22], [1247, 40, 25], [1254, 45, 23], [1268, 31, 25], [1275, 27, 17],
                    [1281, 13, 16], [1295, 37, 35], [1302, 43, 48], [1303, 60, 32], [1320, 35, 30], [1334, 62, 38],
                    [1359, 31, 26], [1370, 13, 20], [1396, 13, 16], [1420, 51, 42], [1445, 65, 24], [1456, 24, 23],
                    [1466, 28, 24], [1473, 13, 17], [1475, 44, 22], [1476, 37, 31], [1477, 24, 17], [1481, 35, 23],
                    [1484, 37, 26], [1486, 13, 13], [1491, 11, 8], [1493, 24, 19], [1507, 33, 28], [1510, 16, 18],
                    [1511, 26, 25], [1515, 19, 15], [1522, 19, 18], [1525, 33, 32], [1527, 31, 26], [1530, 67, 43],
                    [1536, 15, 18], [1537, 52, 38], [1548, 32, 29], [1557, 39, 27], [1562, 38, 29], [1568, 28, 26],
                    [1577, 24, 17], [1580, 37, 30], [1582, 27, 22], [1587, 14, 15], [1589, 43, 24], [1598, 11, 8],
                    [1610, 24, 25], [1628, 29, 17], [1635, 17, 16], [1638, 41, 30], [1644, 87, 49], [1645, 48, 30],
                    [1659, 24, 21], [1673, 63, 34], [1680, 98, 38], [1685, 32, 29], [1704, 17, 15], [1717, 46, 32],
                    [1730, 14, 11], [1763, 21, 21], [1769, 45, 37], [1771, 18, 18], [1772, 10, 13], [1774, 21, 22],
                    [1794, 28, 25], [1795, 12, 9], [1797, 47, 30], [1798, 35, 37], [1804, 25, 17], [1812, 14, 15],
                    [1818, 17, 17], [1824, 63, 35], [1825, 18, 22], [1841, 35, 34], [1845, 33, 26], [1848, 40, 26],
                    [1864, 101, 60], [1866, 44, 26], [1882, 16, 17], [1891, 30, 22], [1894, 29, 15], [1903, 61, 29],
                    [1916, 19, 17], [1921, 13, 11], [1930, 10, 8], [1933, 11, 14], [1952, 144, 57], [1962, 12, 14],
                    [1965, 60, 36], [1995, 37, 25], [2000, 28, 25], [2006, 20, 18], [2011, 19, 18], [2017, 40, 30],
                    [2021, 25, 26], [2023, 11, 11], [2025, 50, 41], [2029, 34, 27], [2035, 45, 28], [2048, 15, 28],
                    [2056, 22, 40], [2057, 49, 27], [2064, 50, 27], [2081, 28, 17], [2084, 54, 25], [2098, 13, 16],
                    [2099, 29, 22], [2127, 15, 13], [2128, 27, 26], [2138, 21, 22], [2142, 9, 10], [2171, 23, 22],
                    [2178, 15, 14], [2180, 31, 25], [2190, 25, 19], [2198, 18, 15], [2201, 27, 27], [2208, 66, 35],
                    [2213, 38, 29], [2224, 31, 26], [2227, 16, 18], [2232, 25, 25], [2238, 30, 25], [2244, 21, 21],
                    [2250, 37, 25], [2258, 25, 25], [2277, 25, 18], [2280, 13, 10], [2282, 17, 45], [2300, 47, 37],
                    [2303, 24, 24], [2311, 31, 29], [2316, 44, 32], [2343, 36, 25], [2352, 36, 30], [2367, 36, 26],
                    [2371, 46, 28], [2384, 24, 28], [2404, 26, 25], [2429, 15, 16], [2433, 41, 20], [2435, 14, 16],
                    [2443, 44, 30], [2458, 28, 21], [2459, 21, 14], [2467, 14, 14], [2483, 40, 44], [2485, 18, 14],
                    [2488, 24, 22], [2494, 29, 26], [2497, 29, 18], [2500, 23, 17], [2501, 48, 30], [2505, 38, 25],
                    [2524, 10, 9], [2533, 10, 16], [2539, 76, 23], [2540, 16, 19], [2547, 15, 28], [2554, 11, 20],
                    [2562, 78, 30], [2564, 21, 18], [2574, 57, 33], [2576, 60, 33], [2585, 41, 28], [2595, 35, 29],
                    [2603, 49, 31], [2606, 18, 14], [2612, 31, 22], [2617, 30, 21], [2619, 11, 11], [2627, 43, 26],
                    [2635, 14, 15], [2647, 27, 23], [2656, 19, 18], [2670, 35, 24], [2671, 40, 40], [2687, 35, 21],
                    [2692, 39, 26], [2695, 17, 13], [2720, 28, 31], [2723, 34, 37], [2758, 30, 26], [2762, 45, 29],
                    [2775, 46, 28], [2785, 12, 13], [2798, 16, 17], [2822, 23, 18], [2823, 21, 17], [2827, 12, 16],
                    [2832, 16, 16], [2835, 24, 22], [2836, 24, 17], [2838, 29, 24], [2851, 19, 14], [2872, 17, 18],
                    [2879, 21, 18], [2880, 32, 23], [2883, 34, 37], [2910, 18, 18], [2914, 39, 26], [2922, 13, 14],
                    [2929, 40, 27], [2934, 18, 17], [2935, 44, 26], [2950, 32, 26], [2969, 20, 15], [2974, 30, 20],
                    [2978, 27, 26], [2991, 34, 28], [3016, 32, 25], [3019, 39, 21], [3027, 16, 17], [3033, 59, 44],
                    [3035, 18, 18], [3046, 49, 22], [3053, 59, 41], [3066, 43, 28], [3070, 36, 29], [3077, 43, 35],
                    [3086, 86, 29], [3091, 12, 13], [3092, 44, 28], [3098, 29, 24], [3112, 43, 25], [3114, 42, 29],
                    [3119, 11, 22], [3126, 36, 26], [3133, 32, 28], [3134, 31, 33], [3137, 26, 26], [3142, 26, 31],
                    [3148, 29, 22], [3155, 22, 19], [3158, 18, 21], [3161, 17, 17], [3164, 44, 31], [3167, 18, 23],
                    [3171, 30, 17], [3182, 115, 39], [3206, 41, 26], [3221, 38, 31], [3228, 39, 26], [3231, 17, 17],
                    [3234, 36, 22], [3246, 70, 26], [3252, 41, 26], [3254, 21, 25], [3256, 24, 19], [3264, 23, 23],
                    [3273, 54, 33], [3274, 21, 19], [3280, 29, 26], [3301, 35, 28], [3306, 18, 21], [3308, 49, 30],
                    [3309, 34, 35], [3321, 43, 26], [3326, 18, 19], [3327, 37, 28], [3331, 28, 18], [3346, 26, 29],
                    [3348, 44, 29], [3357, 12, 17], [3363, 45, 25], [3364, 11, 14], [3372, 43, 29], [3382, 28, 21],
                    [3418, 49, 28], [3434, 7, 7], [3438, 45, 25], [3439, 25, 21], [3451, 60, 42], [3454, 11, 10],
                    [3459, 24, 19], [3462, 44, 23], [3469, 24, 17], [3494, 11, 12], [3503, 91, 44], [3511, 18, 25],
                    [3515, 13, 34], [3517, 41, 28], [3531, 22, 17], [3541, 18, 23], [3557, 10, 13], [3559, 36, 28],
                    [3569, 47, 47], [3579, 18, 27], [3590, 18, 22], [3593, 49, 49], [3598, 16, 12], [3602, 18, 18],
                    [3608, 36, 24], [3653, 20, 18], [3659, 37, 27], [3661, 25, 25], [3669, 14, 19], [3679, 16, 24],
                    [3700, 17, 19], [3718, 44, 32], [3726, 13, 12], [3729, 98, 41], [3751, 29, 19], [3755, 29, 23],
                    [3765, 18, 16], [3777, 24, 20], [3782, 53, 27], [3796, 26, 25], [3827, 40, 25], [3828, 17, 20],
                    [3833, 59, 30], [3845, 41, 25], [3854, 25, 23], [3859, 11, 15], [3870, 41, 30], [3874, 35, 26],
                    [3884, 46, 27], [3889, 52, 24], [3905, 24, 24], [3915, 24, 24], [3921, 24, 26], [3925, 47, 30],
                    [3932, 21, 25], [3942, 27, 25], [3943, 23, 23], [3947, 33, 27], [3956, 39, 47], [3960, 48, 39],
                    [3969, 59, 36], [3970, 40, 29], [3972, 138, 66], [3976, 17, 17], [3985, 22, 20], [3992, 57, 30],
                    [3993, 15, 15], [4015, 45, 26], [4022, 43, 29], [4023, 26, 26], [4026, 25, 16], [4027, 56, 30],
                    [4028, 21, 20], [4031, 15, 14], [4034, 48, 38], [4038, 56, 30], [4043, 17, 16], [4074, 17, 23],
                    [4082, 52, 30], [4084, 11, 16], [4091, 34, 28], [4106, 35, 22], [4107, 55, 27], [4109, 17, 17],
                    [4111, 16, 13], [4124, 31, 27], [4125, 15, 16], [4152, 72, 38], [4156, 16, 17], [4165, 32, 31],
                    [4169, 25, 20], [4173, 15, 17], [4176, 10, 12], [4199, 63, 31], [4209, 36, 34], [4229, 23, 20],
                    [4242, 26, 25], [4246, 11, 18], [4272, 39, 26], [4283, 25, 19], [4285, 24, 29], [4299, 31, 22],
                    [4301, 46, 48], [4310, 28, 21], [4312, 40, 26], [4325, 47, 24], [4338, 25, 25], [4350, 18, 17],
                    [4353, 23, 22], [4358, 12, 13], [4362, 62, 41], [4380, 17, 19], [4382, 85, 29], [4386, 18, 20],
                    [4413, 11, 11], [4414, 16, 23], [4426, 15, 15], [4440, 37, 27], [4442, 16, 20], [4454, 17, 16],
                    [4464, 38, 24], [4470, 23, 23], [4471, 17, 17], [4477, 26, 28], [4487, 19, 24], [4491, 40, 27],
                    [4495, 24, 20], [4500, 17, 17], [4504, 47, 32], [4506, 16, 17], [4515, 43, 32], [4518, 40, 28],
                    [4521, 39, 26], [4524, 26, 26], [4532, 25, 18], [4536, 19, 18], [4545, 40, 30], [4552, 14, 16],
                    [4572, 26, 23], [4591, 30, 21], [4602, 20, 23], [4610, 53, 28], [4616, 21, 18], [4617, 91, 41],
                    [4618, 23, 20], [4623, 17, 19], [4626, 28, 17], [4634, 26, 24], [4638, 80, 29], [4643, 20, 19],
                    [4644, 13, 17], [4648, 34, 24], [4660, 52, 29], [4668, 45, 28], [4670, 46, 30], [4676, 13, 16],
                    [4684, 20, 16], [4689, 36, 25], [4703, 10, 13], [4710, 8, 6], [4717, 17, 17], [4724, 24, 18],
                    [4728, 22, 20], [4732, 54, 62], [4734, 14, 15], [4738, 33, 35], [4745, 20, 19], [4747, 45, 26],
                    [4749, 36, 27], [4762, 38, 35], [4764, 21, 26], [4777, 20, 20], [4789, 44, 25], [4791, 20, 25],
                    [4794, 21, 17], [4801, 14, 18], [4805, 12, 17], [4820, 42, 35], [4826, 16, 18], [4828, 61, 44],
                    [4832, 17, 20], [4835, 22, 21], [4839, 28, 18], [4840, 46, 28], [4849, 17, 17], [4863, 38, 31],
                    [4864, 18, 20], [4865, 27, 18], [4871, 14, 17], [4877, 22, 18], [4880, 17, 20], [4881, 29, 27],
                    [4888, 40, 32], [4897, 14, 18], [4912, 10, 15], [4914, 25, 18], [4915, 18, 16], [4918, 20, 23],
                    [4926, 47, 43], [4927, 16, 18], [4931, 16, 17], [4939, 21, 20], [4940, 34, 20], [4944, 15, 14],
                    [4950, 44, 26], [4951, 29, 29], [4955, 34, 26], [4957, 23, 18], [4960, 75, 38], [4973, 30, 30],
                    [4975, 25, 25], [4976, 11, 13], [4978, 52, 39], [4983, 17, 16], [4990, 31, 19], [4992, 22, 20],
                    [4997, 22, 20], [4998, 62, 26], [5006, 74, 34], [5009, 18, 18], [5011, 43, 32], [5012, 34, 37],
                    [5013, 16, 16], [5017, 25, 25], [5019, 57, 38], [5031, 10, 12], [5035, 26, 26], [5038, 14, 16],
                    [5046, 39, 26], [5048, 29, 25], [5050, 22, 18], [5051, 12, 15], [5053, 26, 21], [5062, 36, 21],
                    [5063, 20, 25], [5071, 24, 25], [5073, 52, 34], [5075, 21, 26], [5079, 16, 17], [5081, 34, 16],
                    [5091, 72, 31], [5092, 11, 14], [5095, 14, 15], [5107, 87, 28], [5108, 19, 24], [5116, 30, 27],
                    [5126, 20, 20], [5127, 16, 17], [5130, 47, 41], [5149, 19, 17], [5150, 44, 30], [5159, 55, 24],
                    [5162, 21, 20], [5173, 33, 21], [5181, 17, 18], [5184, 29, 18], [5185, 25, 14], [5186, 14, 15],
                    [5187, 14, 16], [5188, 16, 19], [5189, 16, 10], [5217, 43, 31], [5219, 17, 39], [5220, 15, 42],
                    [5221, 11, 30], [5222, 16, 20], [5223, 11, 26], [5224, 16, 37], [5225, 15, 40], [5226, 12, 42],
                    [5227, 27, 50], [5228, 19, 49], [5229, 11, 36], [5230, 15, 32], [5231, 12, 28], [5232, 18, 44],
                    [5233, 23, 59], [5234, 10, 21], [5235, 34, 35], [5236, 15, 33], [5237, 23, 42], [5238, 15, 30],
                    [5239, 22, 52], [5240, 19, 55], [5241, 25, 51], [5242, 18, 34], [5243, 24, 53], [5244, 20, 55],
                    [5245, 24, 53], [5247, 29, 13], [5248, 30, 18], [5273, 23, 15], [5276, 24, 33], [5279, 23, 22],
                    [5287, 12, 12], [5290, 22, 18], [5298, 14, 14], [5299, 22, 17], [5303, 28, 19], [5305, 21, 16],
                    [5314, 18, 20], [5315, 22, 22], [5317, 28, 36], [5321, 23, 25], [5323, 21, 21], [5328, 16, 15],
                    [5332, 17, 21], [5333, 15, 16], [5336, 16, 14], [5337, 15, 14], [5338, 26, 23], [5339, 21, 25],
                    [5340, 23, 23], [5343, 13, 11], [5344, 32, 30], [5347, 17, 18], [5349, 22, 22], [5350, 21, 22],
                    [5353, 23, 21], [5355, 16, 19], [5357, 21, 21], [5359, 16, 21], [5366, 22, 19], [5371, 28, 28],
                    [5372, 21, 18], [5375, 14, 14], [5377, 22, 21], [5383, 22, 28], [5385, 23, 22], [5387, 15, 13],
                    [5400, 14, 13], [5403, 26, 23], [5404, 19, 19], [5407, 17, 19], [5408, 21, 21], [5411, 21, 15],
                    [5412, 21, 21], [5414, 13, 13], [5415, 23, 21], [5418, 21, 25], [5420, 15, 14], [5421, 21, 15],
                    [5422, 29, 24], [5425, 16, 17], [5426, 16, 19], [5428, 19, 23], [5431, 20, 18], [5432, 21, 23],
                    [5434, 10, 11], [5436, 18, 17], [5437, 23, 19], [5440, 26, 23], [5441, 21, 24], [5444, 22, 28],
                    [5447, 18, 18], [5449, 21, 26], [5450, 21, 22], [5452, 21, 22], [5453, 23, 24], [5454, 14, 14],
                    [5455, 19, 16], [5457, 14, 21], [5459, 15, 15], [5462, 18, 21], [5463, 13, 14], [5464, 17, 18],
                    [5465, 23, 19], [5472, 24, 22], [5473, 21, 19], [5476, 15, 17], [5479, 16, 16], [5480, 25, 22],
                    [5482, 18, 16], [5486, 18, 18], [5489, 23, 31], [5492, 24, 27], [5494, 21, 22], [5495, 21, 18],
                    [5498, 31, 31], [5499, 18, 21], [5501, 25, 32], [5505, 21, 21], [5508, 23, 23], [5528, 13, 12],
                    [5532, 23, 19], [5534, 18, 14], [5539, 22, 17], [5541, 21, 18], [5544, 21, 21], [5545, 21, 21],
                    [5547, 31, 28], [5550, 17, 17], [5571, 24, 21], [5944, 7, 7], [5945, 8, 9], [5946, 6, 5],
                    [5962, 68, 76], [5989, 221, 171], [5990, 221, 171], [5991, 221, 171], [5992, 221, 179],
                    [5993, 221, 171], [5996, 42, 25], [6068, 40, 28], [6069, 42, 32], [6070, 42, 32], [6071, 27, 21],
                    [6073, 27, 25], [6074, 32, 24], [6075, 42, 32], [6076, 31, 26], [6077, 27, 23], [6078, 31, 30],
                    [6079, 34, 25], [6080, 31, 29], [6081, 22, 22], [6082, 32, 24], [6083, 30, 22], [6084, 38, 24],
                    [6085, 34, 26], [6087, 74, 23], [6088, 30, 26], [6089, 27, 23], [6090, 42, 27], [6091, 27, 22],
                    [6092, 30, 25], [6093, 32, 24], [6094, 32, 24], [6095, 22, 19], [6096, 30, 21], [6097, 34, 23],
                    [6098, 30, 22], [6099, 38, 24], [6100, 32, 24], [6101, 32, 21], [6102, 22, 20], [6103, 30, 22],
                    [6104, 34, 22], [6105, 38, 24], [6106, 25, 21], [6108, 32, 23], [6109, 20, 21], [6110, 30, 24],
                    [6111, 14, 19], [6112, 26, 24], [6113, 21, 21], [6114, 21, 21], [6115, 21, 23], [6116, 28, 24],
                    [6117, 23, 23], [6118, 28, 26], [6119, 26, 24], [6120, 19, 20], [6121, 25, 25], [6122, 26, 22],
                    [6123, 21, 21], [6124, 27, 23], [6125, 23, 23], [6126, 25, 25], [6127, 25, 25], [6128, 21, 25],
                    [6130, 26, 24], [6131, 30, 22], [6132, 32, 24], [6133, 30, 22], [6134, 30, 22], [6135, 59, 44],
                    [6136, 52, 40], [6137, 16, 19], [6138, 24, 25], [6139, 27, 24], [6140, 20, 22], [6141, 27, 26],
                    [6142, 21, 23], [6143, 23, 23], [6145, 27, 27], [6146, 14, 19], [6147, 18, 24], [6148, 18, 22],
                    [6149, 25, 25], [6150, 15, 19], [6151, 19, 19], [6152, 17, 19], [6153, 17, 20], [6154, 25, 25],
                    [6155, 20, 21], [6156, 22, 22], [6157, 29, 26], [6158, 22, 21], [6159, 29, 25], [6160, 19, 20],
                    [6161, 15, 19], [6162, 16, 19], [6163, 37, 31], [6164, 27, 25], [6165, 24, 22], [6166, 34, 24],
                    [6167, 37, 30], [6244, 54, 31], [6353, 39, 39], [6357, 39, 22], [6358, 82, 40], [6360, 120, 65],
                    [6361, 126, 60], [6371, 136, 123], [6374, 123, 150], [6375, 212, 72], [6380, 81, 44],
                    [6382, 79, 51], [6385, 110, 100], [6388, 180, 95], [6391, 64, 41], [6393, 200, 180], [6395, 94, 47],
                    [6400, 105, 68], [6405, 166, 50], [6408, 350, 100], [6411, 60, 47], [6412, 89, 104],
                    [6413, 118, 89], [6414, 144, 63], [6416, 150, 70], [6421, 64, 57], [6422, 85, 70], [6425, 84, 44],
                    [6426, 90, 78], [6430, 49, 67], [6431, 64, 69], [6432, 127, 114], [6433, 40, 36], [6436, 167, 62],
                    [6438, 76, 65], [6441, 49, 51], [6442, 47, 32], [6448, 71, 50], [6450, 172, 139], [6452, 200, 100],
                    [6462, 120, 94], [6463, 100, 100], [6467, 220, 216], [6469, 75, 98], [6471, 60, 48],
                    [6474, 140, 75], [6476, 78, 49], [6477, 225, 108], [6478, 143, 48], [6483, 96, 70], [6486, 214, 82],
                    [6489, 110, 50], [6492, 26, 30], [6494, 29, 25], [6495, 60, 48], [6496, 71, 50], [6499, 146, 115],
                    [6502, 39, 45], [6512, 60, 50], [6514, 171, 110], [6515, 150, 75], [6516, 110, 150], [6518, 87, 92],
                    [6519, 200, 200], [6521, 56, 35], [6524, 145, 130], [6527, 51, 50], [6529, 116, 127],
                    [6530, 55, 45], [6532, 58, 48], [6534, 62, 65], [6565, 150, 105], [6566, 58, 44], [6568, 64, 50],
                    [6570, 140, 80], [6576, 51, 50], [6581, 200, 119], [6584, 120, 50], [6585, 56, 53], [6587, 115, 80],
                    [6589, 170, 60], [6590, 219, 92], [6602, 104, 47], [6607, 129, 54], [6609, 82, 57], [6612, 96, 80],
                    [6614, 32, 32], [6615, 76, 56], [6616, 85, 111], [6621, 126, 50], [6623, 120, 90], [6630, 81, 100],
                    [6631, 34, 33], [6633, 25, 24], [6634, 29, 25], [6635, 34, 26], [6636, 45, 34], [6637, 38, 24],
                    [6638, 42, 28], [6639, 34, 30], [6640, 25, 59], [6643, 43, 25], [6649, 38, 25], [6650, 38, 24],
                    [6651, 27, 19], [6652, 33, 26], [6653, 36, 27], [6654, 26, 24], [6655, 27, 21], [6656, 28, 24],
                    [6657, 34, 26], [6660, 29, 20], [6661, 23, 23], [6662, 31, 26], [6663, 26, 24], [6664, 30, 26],
                    [6665, 25, 25], [6666, 25, 23], [6667, 26, 24], [6668, 26, 20], [6669, 34, 25], [6670, 27, 23],
                    [6671, 33, 24], [6672, 29, 21], [6673, 32, 22], [6674, 28, 26], [6675, 27, 23], [6676, 34, 30],
                    [6677, 25, 25], [6678, 27, 23], [6679, 52, 40], [6680, 25, 21], [6682, 24, 22], [6683, 25, 25],
                    [6684, 25, 26], [6685, 21, 23], [6686, 19, 21], [6687, 21, 23], [6688, 19, 21], [6689, 21, 23],
                    [6690, 19, 21], [6697, 33, 27], [6699, 25, 76], [6700, 78, 37], [6701, 68, 41], [6702, 35, 23],
                    [6704, 82, 44], [6715, 45, 35], [6716, 30, 31], [6718, 31, 53], [6722, 35, 31], [6723, 81, 48],
                    [6726, 45, 65], [6728, 53, 34], [6734, 59, 40], [6737, 31, 87], [6738, 70, 48], [6741, 14, 15],
                    [6748, 24, 22], [6749, 23, 23], [6750, 33, 31], [6752, 19, 21], [6753, 29, 27], [6754, 29, 25],
                    [6755, 32, 32], [6756, 29, 29], [6757, 25, 24], [6758, 29, 33], [6759, 19, 21], [6760, 32, 32],
                    [6761, 33, 31], [6762, 29, 29], [6763, 22, 19], [6764, 27, 29], [6766, 42, 32], [6767, 30, 24],
                    [6768, 28, 26], [6769, 32, 37], [6770, 30, 31], [6771, 30, 29], [6772, 23, 26], [6773, 35, 33],
                    [6777, 38, 32], [6778, 25, 25], [6779, 30, 31], [6780, 31, 29], [6781, 34, 30], [6782, 52, 37],
                    [6783, 38, 33], [6784, 29, 29], [6785, 30, 28], [6786, 30, 31], [6787, 28, 30], [6789, 33, 31],
                    [6790, 35, 104], [6791, 92, 87], [6794, 21, 40], [6795, 44, 68], [6798, 35, 28], [6803, 31, 79],
                    [6804, 50, 104], [6805, 78, 136], [6806, 30, 68], [6807, 35, 46], [6808, 21, 40], [6812, 171, 78],
                    [6813, 31, 65], [6814, 130, 107], [6816, 86, 95], [6818, 18, 20], [6819, 34, 43], [6820, 33, 33],
                    [6821, 35, 41], [6822, 45, 44], [6823, 32, 36], [6833, 68, 55], [6834, 155, 107], [6835, 295, 143],
                    [6836, 40, 65], [6837, 21, 28], [6838, 143, 95], [6841, 26, 20], [6845, 31, 63], [6846, 38, 58],
                    [6847, 40, 45], [6848, 40, 21], [6849, 74, 46], [6850, 45, 51], [6851, 21, 46], [6852, 87, 128],
                    [6853, 31, 54], [6854, 155, 81], [6855, 40, 40], [6856, 30, 55], [6857, 35, 76], [6858, 50, 54],
                    [6859, 60, 52], [6860, 25, 31], [6861, 30, 50], [6862, 35, 40], [6867, 14, 20], [6868, 15, 15],
                    [6869, 15, 15], [6870, 15, 17], [6871, 16, 17], [6872, 15, 17], [6873, 20, 16], [6874, 11, 16],
                    [6875, 14, 17], [6876, 11, 15], [6877, 19, 25], [6878, 14, 16], [6879, 16, 20], [6880, 19, 19],
                    [6881, 11, 13], [6882, 15, 17], [6883, 19, 21], [6910, 58, 46], [6911, 62, 49], [6912, 19, 11],
                    [6913, 55, 43], [6914, 12, 12], [6915, 37, 28], [6917, 27, 30], [6918, 29, 24], [6919, 34, 35],
                    [6920, 21, 20], [6921, 45, 32], [6922, 12, 11], [6923, 48, 34], [6925, 39, 35], [6926, 54, 29],
                    [6927, 63, 33], [6928, 18, 17], [6929, 52, 35], [6930, 25, 18], [6931, 37, 35], [6932, 18, 14],
                    [6933, 27, 24], [6934, 17, 15], [6935, 43, 36], [6936, 21, 22], [6937, 45, 35], [6938, 17, 14],
                    [6939, 46, 33], [6940, 12, 11], [6941, 27, 21], [6942, 19, 17], [6943, 71, 51], [6944, 11, 11],
                    [6945, 43, 30], [6946, 54, 30], [6947, 63, 42], [6948, 12, 11], [6949, 45, 33], [6950, 13, 11],
                    [6951, 47, 36], [6952, 49, 23], [6953, 56, 27], [6954, 26, 16], [6955, 45, 33], [6957, 63, 52],
                    [6958, 13, 11], [6959, 45, 35], [6960, 15, 15], [6961, 43, 23], [6962, 13, 11], [6965, 9, 10],
                    [6966, 21, 34], [6967, 17, 37], [6968, 35, 60], [6969, 19, 34], [6970, 22, 36], [7005, 14, 14],
                    [7006, 30, 29], [7007, 53, 26], [7008, 52, 26], [7011, 10, 10], [7012, 21, 24], [7013, 21, 18],
                    [7014, 14, 9], [7015, 8, 8], [7019, 11, 9], [7021, 12, 11], [7022, 25, 29], [7023, 16, 18],
                    [7024, 25, 29], [7026, 25, 19], [7027, 16, 16], [7028, 37, 35], [7029, 35, 26], [7030, 49, 34],
                    [7031, 15, 19], [7032, 29, 19], [7033, 24, 20], [7034, 31, 27], [7035, 11, 12], [7036, 29, 28],
                    [7037, 25, 25], [7038, 31, 33], [7039, 21, 14], [7040, 27, 25], [7042, 52, 29], [7043, 19, 25],
                    [7044, 27, 24], [7045, 32, 21], [7046, 48, 34], [7048, 26, 20], [7049, 47, 34], [7050, 16, 14],
                    [7051, 51, 37], [7052, 15, 18], [7053, 47, 37], [7054, 16, 15], [7055, 33, 24], [7056, 13, 14],
                    [7057, 55, 37], [7058, 26, 16], [7059, 51, 29], [7060, 26, 17], [7061, 47, 37], [7062, 16, 13],
                    [7063, 42, 26], [7064, 26, 18], [7065, 39, 39], [7066, 12, 12], [7067, 47, 38], [7068, 66, 27],
                    [7069, 74, 49], [7070, 33, 30], [7071, 55, 36], [7072, 10, 11], [7073, 27, 26], [7074, 15, 14],
                    [7075, 56, 51], [7076, 26, 20], [7077, 36, 27], [7078, 11, 11], [7079, 31, 20], [7080, 38, 32],
                    [7081, 65, 47], [7082, 20, 18], [7083, 46, 35], [7084, 50, 24], [7085, 57, 35], [7086, 12, 14],
                    [7087, 40, 32], [7088, 51, 28], [7089, 59, 35], [7090, 17, 12], [7091, 52, 35], [7092, 46, 33],
                    [7093, 65, 53], [7094, 44, 31], [7095, 53, 38], [7096, 25, 21], [7097, 38, 30], [7098, 24, 24],
                    [7099, 49, 36], [7100, 15, 13], [7101, 19, 17], [7156, 17, 18], [7259, 83, 52], [7260, 106, 82],
                    [7261, 84, 67], [7262, 70, 74], [7263, 96, 79], [7264, 84, 88], [7265, 88, 72], [7266, 112, 83],
                    [7267, 84, 68], [7268, 111, 82], [7269, 111, 82], [7270, 80, 50], [7271, 66, 61], [7272, 107, 79],
                    [7273, 86, 90], [7274, 105, 76], [7275, 91, 76], [7276, 59, 49], [7277, 86, 69], [7278, 71, 75],
                    [7279, 92, 65], [7280, 113, 84], [7281, 83, 66], [7282, 69, 72], [7283, 13, 19], [7284, 11, 10],
                    [7285, 12, 11], [7286, 15, 20], [7287, 13, 23], [7288, 28, 28], [7289, 26, 21], [7290, 45, 31],
                    [7291, 34, 28], [7292, 33, 34], [7293, 24, 21], [7294, 21, 20], [7295, 13, 14], [7296, 23, 20],
                    [7297, 25, 22], [7298, 15, 16], [7299, 16, 18], [7300, 18, 26], [7301, 13, 23], [7302, 39, 43],
                    [7303, 75, 72], [7304, 30, 32], [7305, 39, 39], [7306, 30, 33], [7307, 47, 50], [7308, 38, 41],
                    [7309, 31, 33], [7310, 79, 66], [7311, 66, 64], [7312, 37, 38], [7313, 99, 71], [7314, 80, 61],
                    [7315, 75, 57], [7316, 81, 61], [7317, 82, 62], [7318, 80, 62], [7319, 104, 75], [7320, 78, 59],
                    [7321, 101, 76], [7322, 80, 60], [7323, 94, 70], [7324, 99, 71], [7325, 83, 62], [7326, 81, 61],
                    [7327, 96, 71], [7328, 25, 29], [7329, 47, 44], [7330, 29, 29], [7331, 29, 29], [7332, 24, 27],
                    [7333, 50, 56], [7337, 15, 12], [7342, 13, 10], [7343, 15, 8], [7344, 11, 9], [7348, 15, 8],
                    [7352, 12, 11], [7354, 26, 15], [7356, 14, 13], [7357, 24, 15], [7358, 14, 10], [7359, 24, 15],
                    [7360, 16, 10], [7362, 17, 12], [7363, 12, 11], [7364, 14, 11], [7367, 15, 12], [7370, 11, 10],
                    [7371, 13, 11], [7372, 13, 10], [7373, 13, 10], [7374, 11, 8], [7375, 12, 8], [7376, 7, 8],
                    [7377, 11, 8], [7378, 20, 18], [7379, 30, 23], [7396, 28, 27], [7397, 45, 37], [7398, 28, 29],
                    [7399, 23, 26], [7400, 45, 41], [7401, 23, 26], [7402, 53, 60], [7403, 19, 22], [7404, 56, 43],
                    [7405, 27, 28], [7406, 43, 46], [7407, 29, 28], [7408, 45, 49], [7410, 20, 32], [7411, 51, 48],
                    [7413, 11, 14], [7414, 20, 30], [7415, 11, 15], [7416, 26, 32], [7417, 21, 19], [7420, 28, 31],
                    [7421, 26, 28], [7423, 55, 62], [7433, 78, 56], [7434, 95, 95], [7435, 42, 78], [7436, 58, 80],
                    [7437, 19, 18], [7438, 38, 31], [7441, 23, 15], [7442, 42, 21], [7443, 78, 112], [7444, 68, 112],
                    [7445, 35, 76], [7446, 46, 82], [7447, 20, 19], [7448, 38, 32], [7449, 23, 23], [7450, 21, 21],
                    [7451, 14, 14], [7452, 24, 21], [7453, 74, 48], [7454, 21, 16], [7455, 24, 22], [7456, 66, 48],
                    [7457, 53, 46], [7458, 34, 32], [7459, 53, 46], [7460, 53, 50], [7461, 34, 30], [7462, 39, 34],
                    [7463, 42, 39], [7464, 57, 42], [7465, 46, 34], [7466, 43, 31], [7467, 53, 46], [7468, 38, 34],
                    [7469, 48, 37], [7470, 62, 45], [7471, 72, 52], [7472, 27, 54], [7473, 34, 34], [7474, 53, 46],
                    [7475, 53, 46], [7476, 40, 35], [7477, 37, 32], [7478, 38, 35], [7479, 38, 34], [7480, 53, 41],
                    [7481, 34, 35], [7482, 43, 31], [7483, 53, 46], [7484, 43, 42], [7485, 74, 54], [7486, 53, 39],
                    [7487, 40, 35], [7488, 46, 34], [7489, 59, 39], [7490, 39, 34], [7491, 46, 35], [7492, 53, 39],
                    [7493, 42, 37], [7494, 42, 37], [7495, 53, 46], [7496, 74, 54], [7497, 46, 34], [7498, 34, 35],
                    [7499, 38, 30], [7500, 48, 42], [7501, 57, 42], [7502, 46, 34], [7503, 49, 38], [7504, 48, 35],
                    [7505, 42, 37], [7506, 57, 42], [7507, 41, 36], [7508, 46, 35], [7509, 53, 46], [7510, 53, 46],
                    [7511, 57, 42], [7512, 53, 46], [7513, 46, 34], [7514, 94, 71], [7515, 50, 36], [7516, 53, 46],
                    [7517, 74, 54], [7518, 57, 42], [7519, 42, 37], [7520, 43, 38], [7521, 35, 34], [7522, 62, 45],
                    [7523, 42, 39], [7524, 59, 52], [7525, 53, 46], [7526, 48, 35], [7527, 35, 34], [7528, 66, 48],
                    [7529, 74, 64], [7530, 62, 45], [7531, 43, 42], [7532, 53, 46], [7533, 66, 48], [7534, 74, 64],
                    [7535, 43, 38], [7536, 62, 45], [7537, 51, 38], [7538, 66, 48], [7539, 42, 39], [7540, 66, 48],
                    [7541, 50, 36], [7542, 66, 48], [7543, 49, 36], [7544, 51, 38], [7545, 40, 35], [7546, 46, 34],
                    [7547, 46, 34], [7548, 48, 42], [7549, 53, 46], [7550, 38, 34], [7551, 39, 34], [7552, 39, 34],
                    [7553, 43, 38], [7554, 70, 57], [7555, 66, 50], [7556, 53, 46], [7557, 74, 54], [7558, 35, 31],
                    [7559, 46, 34], [7560, 39, 34], [7561, 74, 54], [7562, 74, 54], [7563, 62, 45], [7564, 49, 36],
                    [7565, 42, 39], [7566, 42, 37], [7567, 53, 46], [7568, 43, 38], [7569, 43, 38], [7570, 42, 37],
                    [7571, 42, 37], [7572, 74, 54], [7573, 53, 42], [7574, 42, 37], [7575, 57, 42], [7576, 57, 42],
                    [7577, 62, 45], [7578, 42, 39], [7579, 62, 45], [7580, 62, 45], [7581, 49, 38], [7582, 50, 41],
                    [7583, 53, 46], [7584, 40, 35], [7585, 40, 37], [7586, 74, 54], [7587, 48, 42], [7588, 42, 39],
                    [7589, 74, 54], [7590, 53, 46], [7591, 46, 35], [7592, 62, 45], [7593, 51, 38], [7594, 42, 37],
                    [7595, 42, 39], [7596, 38, 34], [7597, 42, 39], [7598, 57, 42], [7599, 53, 46], [7600, 53, 46],
                    [7601, 39, 34], [7602, 37, 32], [7603, 53, 46], [7604, 53, 46], [7605, 53, 46], [7606, 53, 42],
                    [7607, 62, 45], [7608, 39, 34], [7609, 53, 46], [7610, 38, 36], [7611, 40, 46], [7612, 53, 45],
                    [7613, 42, 39], [7614, 46, 37], [7615, 62, 45], [7616, 50, 36], [7617, 46, 36], [7618, 50, 36],
                    [7619, 53, 46], [7620, 48, 42], [7621, 53, 46], [7622, 62, 45], [7623, 42, 37], [7624, 66, 48],
                    [7625, 38, 35], [7626, 50, 36], [7627, 41, 36], [7628, 62, 45], [7629, 38, 35], [7630, 40, 35],
                    [7631, 50, 44], [7632, 49, 36], [7633, 38, 35], [7634, 13, 20], [7635, 13, 17], [7636, 16, 21],
                    [7637, 28, 26], [7638, 54, 35], [7639, 11, 13], [7640, 10, 10], [7641, 15, 17], [7642, 31, 31],
                    [7643, 21, 18], [7644, 26, 33], [7645, 18, 19], [7646, 24, 23], [7647, 34, 23], [7648, 11, 11],
                    [7649, 11, 11], [7650, 17, 15], [7651, 12, 12], [7652, 14, 14], [7653, 37, 29], [7654, 11, 11],
                    [7655, 14, 14], [7656, 14, 14], [7657, 23, 27], [7658, 23, 27], [7659, 14, 18], [7661, 10, 10],
                    [7662, 17, 14], [7663, 16, 18], [7664, 21, 27], [7665, 27, 33], [7666, 13, 12], [7667, 17, 15],
                    [7668, 13, 12], [7669, 11, 8], [7672, 9, 9], [7673, 8, 7], [7674, 17, 16], [7676, 6, 7],
                    [7677, 5, 6], [7678, 10, 8], [7679, 11, 9], [7680, 34, 19], [7681, 5, 3], [7682, 16, 13],
                    [7683, 3, 3], [7684, 14, 13], [7685, 12, 11], [7686, 20, 18], [7687, 5, 4], [7688, 14, 14],
                    [7690, 7, 8], [7691, 24, 23], [7692, 10, 8], [7693, 9, 9], [7694, 9, 9], [7695, 25, 19],
                    [7696, 3, 3], [7697, 16, 12], [7698, 9, 8], [7699, 12, 14], [7700, 14, 10], [7701, 9, 8],
                    [7702, 22, 13], [7703, 12, 13], [7705, 23, 13], [7706, 11, 10], [7707, 12, 10], [7708, 9, 7],
                    [7709, 12, 13], [7710, 6, 5], [7711, 15, 11], [7713, 27, 12], [7714, 10, 9], [7715, 29, 33],
                    [7716, 27, 28], [7717, 49, 54], [7718, 29, 29], [7719, 24, 27], [7720, 54, 62], [7721, 30, 29],
                    [7722, 35, 30], [7723, 22, 25], [7724, 46, 49], [7725, 17, 21], [7726, 27, 30], [7727, 32, 32],
                    [7728, 48, 44], [7729, 31, 30], [7730, 21, 24], [7731, 48, 52], [7732, 26, 30], [7733, 45, 50],
                    [7734, 41, 34], [7735, 61, 57], [7736, 23, 26], [7737, 42, 38], [7738, 22, 25], [7739, 35, 40],
                    [7740, 23, 26], [7741, 42, 46], [7742, 44, 43], [7743, 29, 28], [7744, 47, 51], [7745, 49, 39],
                    [7746, 30, 29], [7747, 36, 42], [7748, 47, 44], [7749, 31, 32], [7750, 47, 52], [7751, 41, 34],
                    [7752, 60, 55], [7753, 44, 41], [7754, 31, 32], [7755, 24, 26], [7756, 61, 42], [7757, 36, 100],
                    [7758, 65, 107], [7759, 30, 28], [7760, 60, 44], [7761, 49, 59], [7762, 114, 87], [7763, 13, 17],
                    [7764, 11, 12], [7765, 14, 19], [7766, 9, 16], [7767, 24, 28], [7768, 10, 18], [7769, 31, 31],
                    [7770, 14, 16], [7771, 40, 32], [7772, 14, 16], [7773, 22, 24], [7774, 12, 20], [7775, 34, 33],
                    [7776, 14, 26], [7777, 23, 31], [7778, 9, 12], [7779, 15, 19], [7780, 17, 18], [7781, 24, 27],
                    [7782, 26, 24], [7783, 27, 23], [7784, 15, 27], [7785, 32, 36], [7786, 14, 16], [7787, 23, 27],
                    [7788, 18, 20], [7789, 20, 25], [7790, 19, 25], [7791, 37, 36], [7792, 16, 23], [7793, 33, 32],
                    [7795, 120, 85], [7796, 120, 74], [7797, 120, 83], [7798, 120, 32], [7799, 120, 75], [7800, 94, 37],
                    [7801, 120, 72], [7802, 40, 29], [7803, 120, 90], [7804, 120, 88], [7805, 120, 52], [7806, 120, 86],
                    [7807, 100, 29], [7808, 120, 42], [7809, 111, 75], [7810, 120, 90], [7811, 120, 90], [7812, 39, 31],
                    [7813, 87, 33], [7815, 86, 34], [7816, 120, 90], [7817, 56, 41], [7818, 83, 79], [7819, 43, 65],
                    [7820, 91, 43], [7821, 120, 69], [7822, 120, 70], [7823, 47, 39], [7824, 120, 70], [7825, 120, 73],
                    [7826, 111, 87], [7827, 120, 64], [7828, 120, 90], [7829, 97, 37], [7830, 120, 59], [7831, 120, 37],
                    [7832, 120, 90], [7833, 61, 30], [7834, 120, 87], [7835, 117, 33], [7836, 120, 83], [7837, 42, 32],
                    [7838, 120, 78], [7839, 112, 90], [7840, 120, 90], [7841, 120, 70], [7842, 40, 35], [7843, 40, 31],
                    [7844, 120, 63], [7845, 51, 48], [7846, 120, 90], [7847, 120, 90], [7848, 120, 90], [7849, 120, 90],
                    [7850, 97, 90], [7851, 120, 87], [7852, 96, 46], [7853, 88, 60], [7854, 31, 27], [7855, 32, 28],
                    [7856, 120, 90], [7857, 41, 31], [7858, 40, 32], [7859, 120, 72], [7860, 114, 77], [7861, 35, 27],
                    [7862, 120, 52], [7863, 120, 90], [7864, 39, 34], [7865, 46, 37], [7866, 120, 75], [7867, 53, 32],
                    [7868, 42, 31], [7869, 120, 70], [7870, 42, 31], [7871, 59, 35], [7872, 120, 90], [7873, 120, 90],
                    [7874, 42, 32], [7875, 120, 90], [7876, 120, 90], [7877, 111, 71], [7878, 120, 40], [7879, 120, 90],
                    [7880, 92, 71], [7881, 111, 64], [7882, 49, 39], [7883, 111, 89], [7884, 67, 62], [7885, 39, 34],
                    [7886, 73, 35], [7887, 42, 32], [7888, 120, 49], [7889, 120, 90], [7890, 120, 90], [7891, 74, 28],
                    [7892, 64, 33], [7893, 41, 31], [7894, 120, 90], [7895, 80, 37], [7896, 120, 87], [7897, 120, 60],
                    [7898, 111, 56], [7899, 120, 90], [7900, 120, 89], [7901, 111, 29], [7902, 120, 85],
                    [7903, 120, 90], [7904, 111, 31], [7905, 120, 69], [7906, 120, 90], [7907, 120, 42],
                    [7908, 120, 40], [7909, 111, 48], [7910, 114, 56], [7911, 120, 29], [7912, 120, 90],
                    [7913, 120, 58], [7914, 111, 65], [7915, 54, 40], [7916, 120, 42], [7917, 59, 43], [7918, 70, 30],
                    [7919, 111, 32], [7920, 87, 43], [7921, 59, 31], [7922, 111, 35], [7923, 120, 31], [7924, 41, 31],
                    [7925, 41, 31], [7926, 52, 42], [7927, 120, 52], [7928, 111, 51], [7929, 120, 90], [7930, 120, 52],
                    [7931, 58, 32], [7932, 42, 32], [7933, 103, 67], [7934, 120, 90], [7935, 120, 87], [7936, 120, 32],
                    [7937, 72, 31], [7938, 40, 31], [7939, 120, 90], [7940, 120, 83], [7941, 120, 90], [7942, 120, 90],
                    [7943, 43, 33], [7944, 111, 40], [7945, 120, 49], [7946, 114, 87], [7947, 95, 40], [7948, 111, 30],
                    [7949, 120, 90], [7950, 66, 49], [7951, 120, 65], [7952, 115, 87], [7953, 33, 30], [7954, 103, 32],
                    [7955, 120, 58], [7956, 120, 90], [7957, 49, 41], [7958, 120, 49], [7959, 120, 63], [7960, 103, 32],
                    [7961, 120, 90], [7962, 120, 90], [7963, 32, 27], [7964, 120, 90], [7965, 120, 38], [7966, 120, 90],
                    [7967, 120, 31], [7968, 120, 90], [7969, 120, 90], [7970, 120, 81], [7971, 32, 29], [7972, 70, 30],
                    [7974, 33, 30], [7975, 120, 90], [7976, 120, 43], [7977, 120, 90], [7978, 120, 40], [7979, 117, 71],
                    [7980, 120, 78], [7981, 120, 41], [7982, 80, 33], [7983, 111, 31], [7984, 120, 42], [7985, 87, 57],
                    [7986, 41, 31], [7987, 99, 35], [7988, 54, 39], [7989, 120, 94], [7990, 80, 28], [7992, 111, 73],
                    [7993, 120, 90], [7994, 111, 50], [7995, 120, 90], [7996, 120, 34], [7997, 120, 90],
                    [7998, 103, 32], [7999, 120, 90], [8000, 111, 29], [8001, 120, 90], [8002, 120, 90],
                    [8003, 111, 29], [8004, 120, 90], [8005, 21, 21], [8006, 13, 16], [8007, 24, 27], [8008, 22, 23],
                    [8009, 15, 15], [8010, 13, 15], [8011, 21, 21], [8012, 12, 13], [8013, 7, 6], [8014, 9, 9],
                    [8015, 10, 8], [8016, 6, 5], [8017, 11, 11], [8018, 7, 6], [8019, 14, 14], [8020, 11, 11],
                    [8021, 6, 5], [8022, 21, 24], [8023, 15, 15], [8024, 22, 18], [8025, 16, 19], [8026, 17, 18],
                    [8027, 14, 11], [8028, 13, 13], [8029, 20, 18], [8030, 21, 16], [8031, 12, 11], [8032, 18, 23],
                    [8033, 17, 17], [8034, 21, 25], [8035, 19, 25], [8036, 16, 17], [8037, 22, 23], [8038, 29, 28],
                    [8039, 28, 49], [8040, 20, 49], [8041, 7, 13], [8042, 7, 9], [8043, 10, 14], [8044, 10, 15],
                    [8045, 5, 3], [8046, 5, 3], [8047, 5, 5], [8048, 14, 19], [8049, 11, 15], [8050, 9, 10],
                    [8051, 19, 20], [8052, 31, 42], [8053, 21, 35], [8054, 17, 29], [8055, 29, 42], [8056, 41, 45],
                    [8057, 19, 29], [8058, 17, 24], [8059, 23, 25], [8060, 25, 29], [8061, 50, 55], [8062, 52, 68],
                    [8063, 10, 9], [8064, 13, 17], [8065, 13, 11], [8068, 11, 10], [8069, 13, 21], [8071, 34, 20],
                    [8073, 43, 23], [8074, 12, 12], [8075, 22, 14], [8076, 46, 31], [8086, 14, 36], [8087, 15, 27],
                    [8088, 17, 32], [8089, 20, 38], [8090, 19, 28], [8091, 21, 50], [8092, 18, 39], [8093, 21, 49],
                    [8094, 14, 49], [8095, 20, 25], [8096, 21, 32], [8097, 20, 28], [8098, 11, 30], [8099, 29, 29],
                    [8100, 28, 27], [8101, 29, 29], [8102, 23, 25], [8103, 29, 29], [8104, 28, 28], [8105, 43, 36],
                    [8106, 32, 32], [8107, 24, 27], [8108, 42, 39], [8109, 31, 30], [8110, 23, 26], [8111, 39, 36],
                    [8112, 28, 28], [8113, 43, 36], [8114, 23, 26], [8115, 55, 63], [8116, 32, 31], [8117, 43, 55],
                    [8118, 24, 28], [8119, 30, 29], [8120, 40, 37], [8121, 24, 26], [8122, 29, 29], [8123, 44, 37],
                    [8124, 30, 31], [8125, 44, 37], [8126, 24, 25], [8127, 31, 32], [8128, 67, 63], [8129, 29, 29],
                    [8130, 44, 37], [8131, 22, 25], [8132, 42, 39], [8133, 24, 27], [8134, 44, 41], [8135, 44, 36],
                    [8136, 19, 22], [8137, 29, 30], [8138, 32, 32], [8139, 51, 55], [8140, 32, 37], [8141, 28, 27],
                    [8142, 29, 29], [8143, 53, 60], [8144, 24, 27], [8145, 23, 25], [8146, 40, 43], [8147, 28, 27],
                    [8148, 31, 30], [8149, 25, 28], [8150, 58, 68], [8151, 22, 25], [8152, 49, 56], [8153, 29, 30],
                    [8154, 28, 27], [8155, 38, 32], [8156, 61, 73], [8157, 32, 31], [8158, 29, 29], [8159, 25, 26],
                    [8160, 29, 28], [8161, 44, 37], [8162, 46, 38], [8163, 44, 34], [8164, 27, 28], [8165, 31, 31],
                    [8166, 61, 47], [8167, 44, 37], [8168, 29, 30], [8169, 43, 35], [8170, 30, 30], [8171, 29, 30],
                    [8172, 62, 46], [8173, 29, 29], [8174, 30, 29], [8175, 24, 26], [8176, 23, 26], [8177, 25, 29],
                    [8178, 31, 32], [8179, 40, 36], [8180, 28, 28], [8181, 59, 46], [8182, 44, 37], [8183, 32, 32],
                    [8184, 28, 27], [8185, 28, 28], [8186, 31, 31], [8187, 25, 28], [8188, 18, 21], [8189, 41, 38],
                    [8190, 23, 25], [8191, 42, 42], [8192, 32, 31], [8193, 59, 44], [8194, 28, 27], [8195, 29, 29],
                    [8196, 25, 28], [8197, 32, 32], [8198, 25, 28], [8199, 49, 53], [8200, 23, 27], [8201, 63, 48],
                    [8202, 38, 37], [8203, 54, 36], [8204, 43, 36], [8205, 20, 23], [8206, 48, 46], [8207, 29, 28],
                    [8208, 23, 26], [8209, 62, 48], [8210, 31, 31], [8211, 53, 60], [8212, 23, 25], [8213, 31, 30],
                    [8214, 50, 55], [8215, 30, 29], [8216, 29, 29], [8217, 31, 31], [8218, 16, 21], [8219, 47, 45],
                    [8220, 22, 25], [8221, 41, 38], [8222, 20, 24], [8223, 23, 26], [8224, 39, 41], [8225, 31, 36],
                    [8226, 52, 58], [8227, 29, 29], [8228, 20, 23], [8229, 28, 27], [8230, 31, 30], [8231, 19, 22],
                    [8232, 50, 48], [8233, 29, 29], [8234, 21, 23], [8235, 49, 54], [8236, 23, 26], [8237, 47, 44],
                    [8238, 28, 28], [8239, 69, 53], [8240, 30, 29], [8241, 25, 28], [8242, 44, 41], [8245, 31, 30],
                    [8246, 32, 32], [8247, 44, 36], [8248, 20, 23], [8249, 42, 39], [8250, 27, 28], [8251, 30, 29],
                    [8252, 40, 37], [8253, 42, 34], [8254, 33, 37], [8255, 28, 28], [8256, 25, 27], [8257, 49, 55],
                    [8258, 29, 28], [8259, 28, 28], [8260, 31, 32], [8261, 48, 52], [8262, 46, 47], [8263, 54, 41],
                    [8264, 27, 31], [8265, 46, 61], [8267, 42, 35], [8268, 30, 29], [8269, 29, 29], [8270, 18, 22],
                    [8271, 24, 28], [8272, 41, 37], [8273, 29, 29], [8274, 28, 28], [8275, 26, 29], [8276, 28, 28],
                    [8277, 29, 22], [8278, 44, 37], [8279, 29, 29], [8280, 32, 32], [8281, 29, 28], [8282, 32, 32],
                    [8283, 31, 30], [8284, 30, 29], [8285, 32, 32], [8286, 32, 32], [8287, 31, 31], [8288, 24, 28],
                    [8289, 42, 39], [8290, 32, 32], [8291, 32, 32], [8292, 31, 30], [8293, 28, 28], [8294, 29, 28],
                    [8295, 44, 36], [8296, 43, 31], [8297, 30, 30], [8298, 29, 41], [8299, 19, 22], [8300, 62, 47],
                    [8301, 31, 31], [8302, 29, 28], [8303, 44, 37], [8304, 28, 28], [8305, 41, 34], [8306, 25, 28],
                    [8307, 18, 21], [8308, 29, 28], [8309, 15, 19], [8310, 42, 38], [8311, 13, 13], [8312, 12, 12],
                    [8313, 12, 11], [8314, 12, 12], [8315, 12, 12], [8316, 11, 11], [8317, 35, 35], [8318, 51, 39],
                    [8319, 18, 18], [8320, 44, 37], [8321, 32, 26], [8322, 31, 31], [8323, 25, 28], [8324, 56, 41],
                    [8325, 49, 40], [8326, 43, 36], [8327, 41, 34], [8328, 46, 38], [8329, 29, 28], [8330, 46, 38],
                    [8331, 41, 34], [8332, 44, 36], [8336, 20, 16], [8337, 12, 14], [8338, 12, 12], [8339, 32, 35],
                    [8340, 15, 17], [8341, 23, 25], [8342, 15, 15], [8343, 15, 14], [8344, 15, 14], [8345, 21, 22],
                    [8346, 18, 21], [8347, 15, 17], [8348, 21, 21], [8349, 22, 18], [8350, 18, 22], [8351, 14, 11],
                    [8352, 22, 27], [8353, 11, 12], [8354, 24, 27], [8355, 14, 14], [8356, 26, 25], [8357, 21, 14],
                    [8358, 22, 18], [8359, 31, 34], [8360, 27, 29], [8361, 13, 13], [8362, 22, 22], [8363, 28, 30],
                    [8364, 24, 22], [8365, 23, 21], [8366, 22, 21], [8367, 18, 16], [8368, 17, 23], [8369, 18, 21],
                    [8370, 22, 18], [8371, 19, 16], [8372, 20, 18], [8373, 23, 26], [8374, 18, 22], [8375, 16, 21],
                    [8376, 23, 23], [8377, 21, 17], [8378, 22, 17], [8379, 22, 22], [8380, 27, 23], [8381, 21, 21],
                    [8382, 16, 19], [8383, 23, 24], [8384, 21, 27], [8385, 18, 22], [8386, 15, 15], [8387, 22, 21],
                    [8388, 22, 18], [8389, 16, 18], [8390, 13, 14], [8391, 21, 18], [8392, 21, 20], [8393, 27, 34],
                    [8394, 23, 22], [8395, 18, 19], [8396, 47, 39], [8397, 55, 41], [8398, 40, 29], [8399, 51, 33],
                    [8400, 43, 40], [8401, 51, 31], [8402, 41, 31], [8403, 45, 30], [8404, 39, 34], [8405, 45, 30],
                    [8406, 40, 32], [8407, 47, 42], [8408, 38, 38], [8409, 34, 28], [8410, 40, 33], [8411, 74, 52],
                    [8412, 42, 39], [8413, 50, 38], [8414, 57, 31], [8415, 61, 42], [8416, 31, 29], [8417, 50, 34],
                    [8418, 26, 27], [8419, 52, 37], [8420, 44, 34], [8421, 53, 40], [8422, 33, 33], [8423, 50, 45],
                    [8424, 52, 51], [8425, 39, 45], [8426, 35, 30], [8427, 38, 32], [8428, 41, 33], [8429, 33, 30],
                    [8430, 50, 45], [8431, 51, 39], [8432, 51, 45], [8433, 48, 43], [8434, 52, 34], [8435, 70, 38],
                    [8436, 55, 41], [8438, 36, 30], [8439, 39, 35], [8440, 58, 38], [8441, 54, 36], [8442, 37, 34],
                    [8443, 47, 40], [8444, 50, 45], [8445, 27, 24], [8446, 35, 29], [8447, 46, 37], [8448, 38, 33],
                    [8449, 56, 27], [8450, 52, 37], [8451, 21, 27], [8452, 27, 36], [8453, 20, 24], [8454, 22, 27],
                    [8455, 23, 27], [8456, 23, 27], [8457, 50, 45], [8458, 38, 30], [8459, 47, 33], [8460, 41, 36],
                    [8461, 53, 33], [8462, 52, 36], [8463, 50, 42], [8464, 55, 40], [8465, 34, 25], [8466, 32, 37],
                    [8467, 36, 31], [8468, 42, 37], [8469, 39, 32], [8470, 55, 42], [8471, 35, 38], [8472, 54, 29],
                    [8473, 45, 40], [8474, 38, 35], [8475, 48, 37], [8476, 49, 38], [8477, 49, 38], [8478, 30, 30],
                    [8479, 39, 34], [8480, 54, 42], [8481, 46, 37], [8482, 42, 33], [8483, 41, 33], [8484, 47, 35],
                    [8485, 50, 41], [8486, 33, 27], [8487, 46, 33], [8488, 36, 30], [8489, 33, 47], [8490, 47, 37],
                    [8491, 39, 37], [8492, 41, 31], [8493, 47, 32], [8494, 33, 27], [8495, 51, 51], [8496, 26, 33],
                    [8497, 44, 43], [8498, 32, 33], [8499, 40, 32], [8500, 51, 36], [8501, 50, 55], [8502, 53, 35],
                    [8503, 51, 39], [8504, 40, 37], [8505, 52, 40], [8506, 55, 41], [8507, 54, 42], [8508, 34, 32],
                    [8509, 38, 33], [8510, 53, 39], [8511, 46, 35], [8512, 50, 45], [8513, 44, 40], [8514, 49, 45],
                    [8515, 41, 38], [8516, 90, 54], [8517, 52, 23], [8518, 58, 51], [8519, 38, 32], [8520, 41, 32],
                    [8521, 37, 32], [8522, 39, 35], [8523, 38, 33], [8524, 36, 31], [8525, 47, 33], [8526, 49, 38],
                    [8527, 47, 45], [8528, 48, 40], [8529, 58, 40], [8530, 35, 31], [8531, 56, 49], [8532, 48, 44],
                    [8533, 55, 49], [8534, 41, 39], [8535, 54, 52], [8536, 18, 30], [8537, 38, 27], [8538, 38, 26],
                    [8539, 35, 30], [8540, 28, 36], [8541, 35, 44], [8542, 29, 38], [8543, 19, 36], [8544, 27, 50],
                    [8546, 25, 37], [8547, 30, 50], [8548, 15, 18], [8549, 23, 29], [8550, 20, 27], [8551, 32, 28],
                    [8552, 29, 35], [8553, 40, 51], [8554, 21, 20], [8555, 34, 33], [8556, 38, 50], [8557, 50, 49],
                    [8558, 27, 30], [8559, 34, 31], [8560, 28, 33], [8561, 23, 28], [8562, 32, 32], [8563, 39, 41],
                    [8564, 67, 55], [8565, 10, 12], [8566, 22, 14], [8567, 21, 20], [8568, 15, 15], [8569, 19, 15],
                    [8570, 10, 10], [8571, 14, 11], [8572, 12, 12], [8573, 13, 11], [8574, 15, 13], [8575, 10, 10],
                    [8576, 29, 19], [8577, 14, 16], [8578, 23, 21], [8579, 14, 19], [8580, 18, 17], [8581, 14, 14],
                    [8582, 17, 16], [8583, 20, 18], [8584, 15, 14], [8719, 24, 24], [8720, 25, 26], [8721, 26, 27],
                    [8722, 24, 23], [8723, 26, 24], [8724, 24, 24], [8725, 26, 21], [8726, 25, 23], [8727, 22, 22],
                    [8728, 19, 21], [8729, 23, 21], [8730, 21, 20], [8731, 21, 20], [8732, 25, 22], [8733, 26, 22],
                    [8734, 26, 22], [8735, 21, 22], [8736, 21, 21], [8737, 20, 20], [8738, 21, 21], [8739, 21, 21],
                    [8740, 21, 21], [8741, 24, 21], [8742, 23, 21], [8743, 22, 22], [8744, 23, 22], [8745, 24, 22],
                    [8746, 27, 24], [8747, 27, 23], [8748, 28, 23], [8749, 23, 22], [8750, 22, 23], [8751, 22, 24],
                    [8752, 21, 21], [8753, 19, 20], [8754, 21, 21], [8755, 20, 21], [8756, 27, 22], [8757, 19, 20],
                    [8758, 21, 21], [8759, 22, 21], [8760, 29, 30], [8761, 22, 21], [8762, 27, 22], [8763, 19, 19],
                    [8764, 29, 23], [8765, 25, 21], [8766, 26, 22], [8767, 28, 24], [8768, 28, 23], [8769, 27, 23],
                    [8770, 28, 24], [8771, 28, 25], [8772, 29, 24], [8773, 21, 20], [8774, 21, 21], [8775, 21, 21],
                    [8776, 21, 21], [8777, 22, 22], [8778, 29, 24], [8779, 10, 11], [8780, 12, 9], [8781, 16, 13],
                    [8782, 14, 10], [8783, 10, 8], [8784, 12, 9], [8785, 7, 7], [8786, 9, 10], [8787, 11, 10],
                    [8788, 12, 10], [8790, 10, 8], [8791, 6, 6], [8792, 12, 10], [8793, 8, 8], [8794, 8, 7],
                    [8795, 9, 7], [8796, 13, 9], [8797, 15, 9], [8798, 9, 8], [8799, 15, 13], [8800, 10, 8],
                    [8801, 10, 9], [8802, 8, 7], [8803, 8, 8], [8804, 7, 8], [8805, 9, 8], [8806, 9, 10],
                    [8807, 12, 12], [8808, 9, 8], [8809, 6, 8], [8810, 10, 10], [8811, 7, 9], [8812, 11, 9],
                    [8814, 6, 7], [8815, 9, 9], [8816, 12, 7], [8817, 16, 10], [8818, 40, 33], [8819, 35, 32],
                    [8820, 47, 38], [8821, 39, 27], [8822, 45, 37], [8823, 31, 25], [8824, 22, 18], [8825, 34, 28],
                    [8826, 22, 21], [8827, 37, 28], [8828, 37, 28], [8829, 40, 32], [8830, 27, 28], [8831, 33, 25],
                    [8832, 19, 11], [8833, 30, 24], [8834, 35, 30], [8835, 28, 19], [8836, 43, 35], [8837, 30, 21],
                    [8838, 38, 31], [8839, 24, 13], [8840, 34, 24], [8841, 23, 13], [8842, 15, 18], [8843, 19, 12],
                    [8844, 27, 22], [8845, 14, 17], [8846, 33, 26], [8847, 18, 19], [8848, 41, 33], [8849, 27, 21],
                    [8850, 36, 30], [8851, 22, 22], [8852, 32, 25], [8853, 14, 17], [8854, 32, 27], [8855, 20, 14],
                    [8856, 30, 25], [8857, 23, 13], [8858, 27, 14], [8859, 40, 34], [8860, 27, 12], [8861, 33, 28],
                    [8862, 24, 21], [8863, 36, 31], [8864, 21, 21], [8865, 31, 25], [8866, 22, 21], [8867, 43, 36],
                    [8868, 37, 31], [8869, 45, 37], [8870, 43, 34], [8871, 32, 27], [8872, 35, 30], [8873, 26, 22],
                    [8874, 30, 25], [8875, 33, 28], [8876, 18, 18], [8877, 40, 31], [8878, 26, 23], [8879, 18, 11],
                    [8880, 30, 25], [8881, 45, 37], [8882, 28, 24], [8883, 45, 35], [8884, 17, 15], [8885, 48, 34],
                    [8886, 33, 25], [8887, 19, 11], [8888, 37, 32], [8889, 43, 34], [8890, 13, 16], [8891, 32, 28],
                    [8892, 14, 11], [8893, 33, 29], [8894, 19, 18], [8895, 15, 11], [8896, 24, 20], [8897, 15, 10],
                    [8898, 19, 18], [8899, 43, 37], [8900, 33, 28], [8901, 38, 29], [8902, 31, 26], [8903, 25, 21],
                    [8904, 33, 28], [8905, 23, 19], [8906, 30, 24], [8907, 19, 19], [8908, 28, 24], [8909, 21, 18],
                    [8910, 21, 12], [8911, 23, 13], [8912, 40, 35], [8913, 26, 23], [8914, 39, 31], [8915, 27, 23],
                    [8916, 41, 33], [8917, 32, 22], [8918, 42, 34], [8919, 30, 26], [8920, 32, 27], [8921, 33, 30],
                    [8922, 30, 24], [8923, 24, 20], [8924, 14, 13], [8925, 11, 10], [8926, 14, 12], [8927, 15, 15],
                    [8928, 13, 12], [8929, 10, 10], [8930, 9, 10], [8931, 13, 14], [8932, 16, 18], [8933, 23, 23],
                    [8934, 26, 24], [8935, 38, 32], [8936, 25, 19], [8937, 33, 28], [8938, 24, 19], [8939, 31, 24],
                    [8940, 18, 16], [8941, 30, 24], [8942, 18, 16], [8943, 26, 19], [8944, 31, 25], [8945, 22, 19],
                    [8946, 31, 25], [8947, 22, 18], [8948, 30, 25], [8949, 25, 20], [8950, 22, 19], [8951, 29, 25],
                    [8952, 23, 19], [8953, 35, 29], [8954, 24, 17], [8955, 39, 33], [8956, 26, 23], [8957, 26, 18],
                    [8958, 45, 37], [8959, 27, 19], [8960, 43, 35], [8961, 27, 19], [8962, 37, 33], [8963, 30, 26],
                    [8964, 19, 12], [8965, 40, 33], [8966, 36, 28], [8967, 39, 30], [8968, 30, 25], [8969, 18, 13],
                    [8970, 40, 33], [8971, 32, 28], [8972, 17, 13], [8973, 38, 30], [8974, 13, 18], [8975, 43, 35],
                    [8976, 45, 37], [8977, 26, 21], [8978, 14, 11], [8979, 37, 32], [8980, 30, 25], [8981, 29, 23],
                    [8983, 34, 28], [8984, 28, 20], [8985, 33, 28], [8986, 25, 20], [8987, 27, 25], [8988, 18, 26],
                    [8989, 34, 28], [8990, 23, 20], [8991, 32, 27], [8992, 18, 18], [8993, 33, 30], [8994, 40, 33],
                    [8995, 35, 27], [8996, 43, 34], [8997, 22, 21], [8998, 27, 20], [8999, 19, 11], [9000, 45, 37],
                    [9001, 40, 28], [9002, 38, 30], [9003, 23, 21], [9004, 43, 34], [9005, 20, 18], [9006, 34, 27],
                    [9007, 27, 19], [9008, 37, 24], [9009, 32, 24], [9010, 25, 20], [9011, 19, 11], [9012, 27, 25],
                    [9013, 20, 23], [9014, 36, 28], [9015, 19, 14], [9016, 19, 14], [9017, 39, 30], [9018, 26, 26],
                    [9019, 30, 28], [9020, 18, 18], [9021, 34, 29], [9022, 30, 23], [9023, 31, 25], [9024, 36, 29],
                    [9025, 30, 25], [9026, 33, 18], [9027, 27, 17], [9028, 38, 30], [9030, 39, 30], [9031, 32, 26],
                    [9032, 41, 29], [9033, 30, 26], [9034, 44, 34], [9035, 38, 32], [9036, 36, 30], [9037, 16, 14],
                    [9038, 27, 25], [9039, 15, 19], [9040, 34, 28], [9041, 23, 19], [9042, 38, 29], [9043, 33, 28],
                    [9044, 23, 14], [9045, 33, 25], [9046, 27, 20], [9047, 33, 27], [9048, 30, 21], [9049, 49, 34],
                    [9050, 28, 20], [9051, 40, 31], [9052, 43, 26], [9053, 31, 31], [9054, 35, 27], [9055, 43, 21],
                    [9056, 45, 25], [9057, 40, 29], [9058, 25, 19], [9059, 45, 32], [9060, 40, 28], [9061, 57, 45],
                    [9062, 21, 21], [9063, 33, 24], [9064, 16, 18], [9065, 22, 21], [9066, 16, 17], [9067, 30, 22],
                    [9068, 26, 18], [9069, 33, 35], [9070, 17, 17], [9071, 25, 30], [9072, 13, 16], [9073, 14, 16],
                    [9074, 29, 27], [9075, 20, 22], [9076, 23, 25], [9077, 34, 22], [9078, 26, 16], [9079, 35, 30],
                    [9080, 21, 18], [9081, 27, 22], [9082, 43, 30], [9083, 30, 24], [9084, 37, 27], [9085, 19, 19],
                    [9086, 36, 28], [9087, 40, 27], [9088, 28, 17], [9089, 17, 14], [9090, 23, 18], [9091, 23, 15],
                    [9092, 39, 25], [9093, 20, 19], [9094, 43, 36], [9095, 14, 12], [9096, 26, 30], [9097, 29, 21],
                    [9098, 36, 23], [9099, 19, 13], [9100, 33, 22], [9101, 15, 17], [9102, 37, 28], [9103, 24, 23],
                    [9104, 36, 28], [9105, 21, 14], [9106, 28, 15], [9107, 33, 25], [9108, 34, 25], [9109, 33, 26],
                    [9110, 36, 28], [9111, 25, 13], [9112, 42, 34], [9113, 32, 27], [9114, 45, 25], [9115, 14, 14],
                    [9116, 22, 15], [9117, 29, 12], [9118, 38, 28], [9119, 17, 12], [9120, 26, 21], [9121, 30, 25],
                    [9122, 37, 31], [9123, 26, 18], [9124, 38, 30], [9125, 16, 23], [9126, 39, 33], [9127, 28, 25],
                    [9128, 34, 28], [9129, 36, 30], [9130, 46, 36], [9131, 25, 25], [9132, 36, 32], [9133, 26, 18],
                    [9134, 32, 26], [9135, 43, 30], [9136, 37, 28], [9137, 16, 11], [9138, 19, 15], [9139, 27, 24],
                    [9140, 36, 32], [9141, 25, 23], [9142, 42, 37], [9143, 20, 20], [9144, 23, 26], [9145, 32, 26],
                    [9146, 40, 32], [9149, 21, 16], [9150, 21, 21], [9151, 21, 21], [9152, 23, 23], [9153, 12, 14],
                    [9154, 14, 14], [9155, 21, 21], [9156, 23, 23], [9157, 22, 24], [9158, 13, 14], [9159, 22, 23],
                    [9160, 16, 14], [9161, 17, 18], [9162, 23, 23], [9163, 21, 21], [9164, 21, 17], [9165, 21, 23],
                    [9166, 18, 19], [9167, 16, 16], [9168, 23, 23], [9169, 23, 22], [9170, 23, 26], [9171, 23, 22],
                    [9172, 21, 18], [9173, 19, 22], [9174, 16, 17], [9175, 17, 16], [9176, 11, 14], [9177, 21, 17],
                    [9178, 16, 20], [9179, 22, 23], [9180, 15, 15], [9181, 23, 22], [9182, 21, 21], [9183, 22, 23],
                    [9184, 23, 22], [9185, 21, 19], [9186, 13, 15], [9187, 23, 22], [9188, 22, 21], [9189, 22, 22],
                    [9190, 15, 15], [9191, 19, 18], [9192, 17, 19], [9193, 22, 23], [9194, 26, 28], [9195, 28, 31],
                    [9196, 29, 22], [9198, 28, 22], [9199, 26, 22], [9200, 26, 22], [9201, 32, 28], [9202, 32, 30],
                    [9203, 10, 12], [9204, 9, 10], [9209, 25, 23], [9211, 33, 32], [9214, 38, 35], [9218, 23, 20],
                    [9226, 38, 27], [9227, 41, 34], [9228, 38, 41], [9229, 34, 35], [9230, 33, 28], [9232, 34, 30],
                    [9233, 30, 32], [9234, 30, 32], [9235, 30, 32], [9237, 29, 20], [9238, 33, 33], [9242, 34, 33],
                    [9244, 38, 35], [9245, 24, 26], [9248, 32, 26], [9254, 87, 85], [9255, 43, 31], [9257, 60, 52],
                    [9258, 34, 45], [9259, 48, 48], [9260, 41, 34], [9261, 62, 74], [9263, 44, 47], [9264, 37, 39],
                    [9265, 41, 44], [9266, 68, 73], [9267, 59, 57], [9268, 52, 51], [9269, 76, 76], [9270, 68, 73],
                    [9271, 71, 77], [9272, 77, 85], [9273, 73, 80], [9274, 82, 75], [9275, 48, 46], [9276, 79, 73],
                    [9277, 65, 54], [9278, 72, 75], [9279, 69, 63], [9280, 50, 49], [9281, 76, 64], [9282, 83, 74],
                    [9283, 72, 72], [9284, 100, 105], [9285, 62, 67], [9286, 90, 98], [9287, 95, 95], [9288, 52, 41],
                    [9289, 85, 93], [9290, 59, 66], [9291, 83, 83], [9292, 82, 81], [9293, 59, 42], [9294, 51, 50],
                    [9295, 69, 63], [9296, 52, 39], [9297, 77, 53], [9298, 67, 76], [9299, 81, 86], [9300, 86, 88],
                    [9301, 70, 77], [9302, 95, 96], [9303, 71, 81], [9304, 59, 73], [9305, 74, 86], [9306, 97, 111],
                    [9307, 40, 53], [9308, 51, 64], [9309, 46, 55], [9310, 57, 60], [9311, 54, 61], [9312, 57, 60],
                    [9313, 53, 59], [9314, 71, 80], [9315, 33, 32], [9316, 37, 25], [9317, 12, 14], [9318, 13, 15],
                    [9319, 31, 35], [9320, 43, 40], [9327, 12, 14], [9328, 19, 21], [9329, 27, 29], [9330, 35, 36],
                    [9331, 22, 23], [9332, 24, 27], [9333, 11, 14], [9334, 11, 13], [9335, 22, 23], [9336, 20, 21],
                    [9337, 15, 17], [9338, 10, 13], [9339, 16, 18], [9340, 35, 35], [9341, 17, 22], [9342, 26, 26],
                    [9343, 8, 9], [9344, 16, 16], [9345, 17, 20], [9346, 12, 13], [9347, 10, 12], [9348, 22, 21],
                    [9349, 16, 19], [9350, 34, 37], [9351, 28, 25], [9352, 33, 33], [9353, 15, 19], [9354, 24, 27],
                    [9355, 17, 15], [9356, 30, 28], [9357, 15, 18], [9358, 21, 23], [9359, 16, 22], [9360, 24, 27],
                    [9361, 20, 18], [9362, 28, 27], [9363, 20, 21], [9364, 32, 24], [9365, 16, 20], [9366, 43, 44],
                    [9367, 19, 21], [9368, 54, 54], [9369, 27, 31], [9370, 15, 16], [9371, 22, 25], [9372, 43, 30],
                    [9373, 18, 18], [9374, 30, 29], [9375, 18, 21], [9376, 43, 41], [9377, 12, 13], [9378, 18, 21],
                    [9379, 25, 30], [9380, 22, 25], [9381, 50, 45], [9382, 23, 28], [9383, 43, 30], [9384, 16, 16],
                    [9385, 16, 17], [9386, 15, 16], [9387, 14, 14], [9388, 13, 14], [9389, 16, 15], [9390, 17, 19],
                    [9391, 21, 23], [9392, 18, 19], [9393, 21, 20], [9394, 13, 14], [9395, 18, 18], [9396, 18, 22],
                    [9397, 34, 35], [9398, 31, 36], [9399, 42, 43], [9400, 20, 23], [9401, 68, 64], [9402, 36, 27],
                    [9403, 97, 72], [9406, 102, 78], [9411, 94, 69], [9416, 50, 60], [9417, 98, 73], [9420, 96, 71],
                    [9423, 81, 65], [9428, 94, 72], [9431, 96, 71], [9436, 89, 71], [9443, 96, 72], [9444, 94, 69],
                    [9451, 102, 73], [9452, 96, 76], [9453, 82, 63], [9456, 89, 71], [9457, 82, 81], [9458, 96, 72],
                    [9465, 51, 44], [9470, 95, 70], [9473, 42, 54], [9474, 102, 83], [9477, 33, 39], [9478, 49, 53],
                    [9487, 25, 36], [9488, 42, 53], [9491, 38, 48], [9492, 56, 55], [9497, 40, 27], [9498, 101, 43],
                    [9509, 81, 78], [9519, 21, 25], [9520, 81, 53], [9525, 21, 20], [9526, 43, 43], [9529, 32, 30],
                    [9530, 54, 51], [9531, 37, 40], [9532, 74, 73], [9539, 47, 41], [9540, 68, 73], [9541, 36, 34],
                    [9542, 54, 47], [9543, 32, 37], [9544, 49, 49], [9547, 33, 38], [9548, 52, 52], [9549, 30, 30],
                    [9550, 53, 44], [9551, 32, 39], [9552, 74, 73], [9553, 38, 38], [9554, 51, 51], [9555, 50, 65],
                    [9556, 76, 83], [9557, 41, 40], [9558, 83, 73], [9561, 38, 47], [9562, 61, 79], [9581, 43, 46],
                    [9582, 48, 54], [9593, 32, 39], [9594, 52, 75], [9595, 35, 40], [9596, 53, 56], [9597, 25, 24],
                    [9598, 64, 68], [9609, 31, 31], [9610, 45, 45], [9611, 43, 39], [9612, 51, 48], [9613, 53, 65],
                    [9614, 79, 83], [9617, 17, 15], [9618, 51, 45], [9619, 21, 20], [9620, 21, 20], [9633, 45, 48],
                    [9634, 79, 72], [9639, 18, 22], [9640, 65, 53], [9641, 46, 34], [9642, 102, 65], [9643, 26, 36],
                    [9644, 49, 54], [9651, 87, 58], [9652, 87, 58], [9653, 49, 44], [9654, 57, 35], [9661, 76, 45],
                    [9662, 95, 42], [9663, 68, 44], [9664, 68, 44], [9665, 43, 36], [9666, 52, 36], [9667, 21, 18],
                    [9668, 35, 30], [9670, 87, 49], [9673, 37, 24], [9674, 45, 24], [9675, 30, 32], [9676, 51, 41],
                    [9677, 20, 21], [9678, 35, 25], [9681, 45, 35], [9682, 56, 35], [9687, 18, 25], [9689, 23, 21],
                    [9690, 39, 32], [9691, 49, 33], [9692, 39, 31], [9693, 37, 31], [9694, 40, 34], [9695, 36, 35],
                    [9696, 42, 33], [9699, 27, 30], [9700, 75, 42], [9701, 29, 25], [9702, 84, 40], [9704, 77, 39],
                    [9705, 34, 39], [9706, 83, 51], [9709, 21, 17], [9710, 25, 18], [9711, 25, 30], [9712, 25, 30],
                    [9713, 31, 31], [9714, 35, 48], [9715, 64, 49], [9716, 25, 25], [9717, 35, 33], [9718, 30, 28],
                    [9720, 50, 41], [9721, 62, 37], [9722, 38, 42], [9723, 53, 38], [9724, 62, 53], [9725, 70, 48],
                    [9726, 24, 27], [9727, 46, 31], [9728, 25, 25], [9729, 21, 23], [9730, 41, 49], [9731, 66, 53],
                    [9735, 44, 44], [9736, 49, 50], [9737, 33, 21], [9738, 37, 43], [9739, 46, 39], [9740, 87, 87],
                    [9741, 83, 69], [9742, 51, 43], [9743, 33, 29], [9744, 80, 51], [9745, 40, 23], [9746, 44, 28],
                    [9747, 39, 49], [9748, 39, 41], [9751, 38, 42], [9752, 38, 51], [9755, 35, 34], [9756, 35, 33],
                    [9757, 20, 17], [9758, 25, 18], [9759, 15, 14], [9760, 38, 28], [9761, 45, 35], [9762, 36, 28],
                    [9763, 25, 19], [9764, 35, 23], [9765, 39, 35], [9766, 32, 23], [9767, 50, 33], [9768, 33, 25],
                    [9769, 20, 21], [9770, 43, 35], [9771, 49, 43], [9772, 43, 31], [9773, 42, 34], [9774, 30, 22],
                    [9775, 29, 21], [9776, 45, 30], [9777, 38, 28], [9778, 42, 32], [9779, 36, 31], [9780, 42, 30],
                    [9781, 45, 30], [9782, 60, 37], [9783, 61, 48], [9784, 30, 21], [9785, 27, 20], [9786, 19, 14],
                    [9787, 37, 28], [9788, 50, 33], [9789, 34, 30], [9790, 40, 28], [9791, 81, 46], [9792, 46, 40],
                    [9793, 16, 12], [9794, 15, 13], [9795, 13, 12], [9796, 18, 18], [9797, 15, 12], [9798, 14, 14],
                    [9799, 45, 40], [9800, 22, 20], [9801, 18, 16], [9802, 18, 15], [9803, 10, 9], [9804, 17, 13],
                    [9805, 33, 25], [9806, 22, 18], [9807, 27, 16], [9808, 94, 55], [9809, 57, 32], [9811, 46, 26],
                    [9812, 56, 31], [9813, 70, 37], [9814, 23, 14], [9815, 45, 25], [9816, 55, 30], [9817, 30, 17],
                    [9818, 61, 26], [9819, 70, 54], [9820, 96, 57], [9821, 46, 34], [9822, 23, 19], [9823, 32, 21],
                    [9824, 37, 35], [9825, 18, 15], [9826, 47, 32], [9827, 49, 31], [9828, 42, 29], [9829, 39, 26],
                    [9830, 35, 26], [9831, 39, 25], [9832, 44, 28], [9833, 31, 23], [9834, 80, 47], [9835, 32, 28],
                    [9836, 65, 50], [9837, 33, 27], [9838, 65, 45], [9839, 17, 16], [9840, 78, 47], [9841, 74, 43],
                    [9842, 32, 20], [9843, 29, 25], [9844, 35, 28], [9845, 34, 27], [9846, 28, 18], [9847, 14, 11],
                    [9848, 28, 18], [9849, 30, 24], [9850, 25, 16], [9851, 24, 18], [9852, 21, 16], [9853, 25, 19],
                    [9854, 15, 12], [9855, 42, 32], [9856, 17, 18], [9857, 15, 13], [9858, 41, 38], [9859, 57, 35],
                    [9860, 70, 38], [9861, 54, 48], [9862, 31, 26], [9863, 42, 28], [9864, 61, 30], [9865, 38, 27],
                    [9866, 55, 33], [9867, 20, 16], [9868, 44, 29], [9869, 44, 32], [9870, 42, 42], [9871, 44, 28],
                    [9872, 29, 25], [9873, 49, 40], [9874, 42, 37], [9875, 29, 23], [9876, 27, 23], [9877, 38, 39],
                    [9878, 39, 30], [9879, 38, 34], [9880, 40, 50], [9881, 65, 54], [9882, 55, 45], [9883, 33, 24],
                    [9884, 33, 37], [9885, 41, 25], [9886, 40, 25], [9887, 37, 26], [9888, 47, 34], [9889, 44, 30],
                    [9890, 40, 30], [9891, 31, 22], [9892, 34, 26], [9893, 35, 18], [9894, 45, 30], [9895, 27, 17],
                    [9896, 11, 12], [9897, 36, 29], [9898, 35, 27], [9899, 25, 20], [9900, 55, 51], [9901, 46, 36],
                    [9902, 80, 59], [9903, 60, 45], [9904, 56, 40], [9905, 56, 48], [9906, 40, 26], [9907, 30, 28],
                    [9908, 58, 39], [9909, 16, 15], [9910, 52, 45], [9911, 69, 45], [9912, 51, 37], [9913, 23, 21],
                    [9914, 32, 24], [9915, 30, 26], [9916, 41, 28], [9917, 37, 37], [9918, 75, 40], [9919, 55, 38],
                    [9920, 88, 76], [9921, 28, 23], [9922, 26, 16], [9923, 32, 18], [9924, 43, 25], [9925, 52, 62],
                    [9926, 60, 45], [9927, 33, 35], [9928, 54, 30], [9929, 56, 40], [9930, 39, 26], [9931, 67, 38],
                    [9932, 90, 76], [9933, 51, 55], [9934, 47, 35], [9935, 40, 38], [9936, 37, 35], [9937, 30, 40],
                    [9938, 17, 15], [9939, 48, 57], [9940, 38, 38], [9941, 38, 22], [9942, 22, 18], [9943, 60, 40],
                    [9944, 47, 37], [9945, 70, 36], [9946, 45, 28], [9947, 50, 29], [9948, 120, 70], [9949, 75, 50],
                    [9950, 50, 33], [9951, 36, 31], [9952, 49, 26], [9953, 24, 22], [9954, 120, 70], [9955, 22, 22],
                    [9956, 42, 31], [9957, 77, 40], [9958, 35, 25], [9959, 99, 45], [9960, 50, 25], [9961, 42, 31],
                    [9962, 31, 32], [9963, 80, 36], [9964, 44, 30], [9965, 35, 17], [9966, 65, 30], [9967, 81, 32],
                    [9968, 39, 32], [9969, 28, 20], [9970, 60, 30], [9971, 35, 26], [9972, 92, 39], [9973, 50, 34],
                    [9974, 36, 21], [9975, 99, 37], [9976, 70, 40], [9977, 35, 19], [9978, 59, 23], [9979, 80, 37],
                    [9980, 53, 23], [9981, 30, 17], [9982, 17, 13], [9983, 60, 30], [9984, 38, 24], [9985, 39, 22],
                    [9986, 41, 25], [9987, 45, 36], [9988, 70, 45], [9989, 35, 28], [9990, 36, 29], [9991, 40, 31],
                    [9992, 42, 46], [9993, 33, 34], [9994, 27, 23], [9995, 39, 33], [9996, 34, 29], [9997, 17, 27],
                    [9998, 18, 15], [9999, 28, 29], [10000, 25, 20], [10001, 19, 15], [10002, 17, 14], [10003, 52, 29],
                    [10004, 36, 23], [10005, 22, 17], [10006, 33, 25], [10007, 32, 34], [10008, 47, 44],
                    [10009, 43, 28], [10010, 48, 28], [10011, 41, 26], [10012, 49, 23], [10013, 30, 24],
                    [10014, 36, 32], [10015, 29, 26], [10016, 33, 32], [10017, 39, 30], [10018, 38, 32],
                    [10019, 38, 29], [10020, 47, 38], [10021, 53, 37], [10022, 53, 40], [10023, 49, 36],
                    [10024, 72, 48], [10025, 63, 48], [10026, 57, 41], [10027, 48, 37], [10030, 47, 37],
                    [10031, 72, 60], [10032, 63, 46], [10033, 40, 29], [10034, 48, 31], [10035, 66, 37],
                    [10036, 72, 34], [10037, 67, 38], [10038, 29, 19], [10039, 20, 20], [10040, 27, 19],
                    [10041, 27, 16], [10042, 50, 33], [10043, 51, 27], [10044, 58, 27], [10045, 34, 21],
                    [10046, 47, 31], [10047, 44, 24], [10048, 41, 26], [10049, 31, 22], [10050, 40, 28],
                    [10051, 50, 34], [10052, 50, 41], [10053, 53, 39], [10054, 46, 39], [10055, 51, 42],
                    [10056, 45, 42], [10057, 53, 43], [10058, 30, 32], [10059, 55, 31], [10060, 45, 30],
                    [10061, 51, 45], [10063, 20, 20], [10064, 34, 27], [10065, 31, 34], [10066, 35, 30],
                    [10067, 48, 37], [10068, 58, 42], [10069, 49, 38], [10070, 38, 23], [10071, 46, 33],
                    [10072, 51, 21], [10073, 49, 25], [10074, 47, 25], [10075, 53, 31], [10076, 52, 31],
                    [10077, 48, 31], [10078, 61, 37], [10079, 38, 28], [10080, 37, 31], [10081, 57, 38],
                    [10082, 38, 40], [10083, 37, 33], [10084, 39, 28], [10085, 38, 21], [10086, 41, 25],
                    [10087, 38, 18], [10088, 50, 33], [10089, 51, 34], [10090, 40, 31], [10091, 51, 25],
                    [10092, 52, 27], [10093, 37, 31], [10094, 64, 41], [10095, 57, 38], [10096, 47, 30],
                    [10097, 42, 29], [10098, 47, 32], [10099, 59, 41], [10101, 58, 45], [10102, 49, 36],
                    [10103, 51, 45], [10104, 19, 18], [10105, 28, 20], [10106, 28, 25], [10107, 49, 43],
                    [10108, 54, 46], [10109, 100, 64], [10110, 46, 38], [10111, 63, 47], [10112, 63, 49],
                    [10113, 92, 74], [10114, 56, 36], [10115, 37, 27], [10116, 41, 33], [10117, 40, 35],
                    [10118, 43, 43], [10119, 24, 15], [10120, 29, 19], [10121, 56, 46], [10122, 55, 45],
                    [10123, 72, 59], [10124, 61, 56], [10125, 57, 34], [10126, 51, 32], [10127, 50, 30],
                    [10128, 51, 36], [10129, 77, 50], [10130, 72, 49], [10131, 39, 31], [10132, 40, 31],
                    [10133, 51, 29], [10134, 80, 56], [10135, 78, 61], [10136, 45, 25], [10137, 56, 38],
                    [10138, 46, 27], [10139, 47, 29], [10141, 43, 29], [10142, 47, 29], [10144, 57, 29],
                    [10145, 39, 36], [10146, 43, 38], [10148, 40, 24], [10149, 42, 42], [10150, 25, 28],
                    [10151, 41, 36], [10152, 52, 40], [10153, 58, 44], [10154, 22, 23], [10155, 50, 47],
                    [10156, 33, 28], [10157, 53, 39], [10158, 31, 32], [10159, 42, 32], [10160, 44, 28],
                    [10161, 60, 36], [10162, 48, 25], [10163, 68, 35], [10164, 47, 25], [10165, 53, 29],
                    [10166, 40, 24], [10167, 46, 34], [10168, 48, 37], [10169, 50, 36], [10170, 28, 31],
                    [10171, 43, 35], [10172, 34, 28], [10173, 42, 34], [10174, 42, 27], [10175, 48, 33],
                    [10176, 18, 19], [10177, 16, 18], [10178, 19, 19], [10179, 17, 19], [10180, 36, 28],
                    [10181, 22, 15], [10182, 34, 34], [10183, 41, 25], [10184, 51, 35], [10185, 30, 26],
                    [10186, 30, 25], [10187, 19, 15], [10188, 50, 35], [10189, 51, 30], [10190, 19, 14],
                    [10191, 44, 24], [10192, 31, 21], [10193, 19, 18], [10194, 15, 11], [10195, 14, 12],
                    [10234, 42, 33], [10235, 34, 29], [10236, 34, 30], [10237, 25, 24], [10238, 33, 30],
                    [10239, 47, 39], [10240, 28, 26], [10241, 23, 28], [10242, 29, 25], [10243, 33, 27],
                    [10244, 33, 34], [10245, 17, 22], [10246, 31, 27], [10247, 20, 22], [10248, 33, 24],
                    [10249, 20, 24], [10250, 32, 29], [10251, 31, 26], [10252, 32, 29], [10253, 32, 31],
                    [10255, 31, 29], [10256, 38, 34], [10257, 30, 26], [10258, 34, 31], [10259, 16, 23],
                    [10260, 33, 30], [10261, 35, 27], [10263, 19, 22], [10264, 34, 29], [10267, 23, 22],
                    [10268, 33, 26], [10269, 22, 23], [10270, 29, 29], [10271, 34, 27], [10272, 27, 25],
                    [10276, 27, 26], [10277, 35, 31], [10278, 21, 25], [10279, 32, 29], [10280, 20, 26],
                    [10281, 32, 33], [10283, 21, 23], [10284, 27, 27], [10285, 20, 21], [10286, 27, 24],
                    [10287, 27, 24], [10288, 28, 22], [10289, 32, 27], [10290, 29, 25], [10291, 29, 26],
                    [10292, 22, 24], [10293, 29, 29], [10294, 16, 22], [10295, 21, 25], [10296, 29, 28],
                    [10297, 21, 23], [10298, 28, 27], [10299, 21, 23], [10300, 29, 26], [10301, 29, 29],
                    [10302, 21, 24], [10303, 32, 31], [10304, 21, 25], [10305, 30, 29], [10306, 25, 28],
                    [10307, 25, 27], [10309, 27, 25], [10310, 21, 25], [10311, 31, 30], [10312, 25, 24],
                    [10313, 35, 27], [10314, 34, 28], [10315, 31, 24], [10317, 23, 23], [10318, 38, 30],
                    [10319, 23, 27], [10320, 46, 30], [10321, 24, 23], [10322, 32, 32], [10323, 22, 27],
                    [10326, 42, 33], [10327, 22, 24], [10329, 27, 23], [10330, 25, 27], [10332, 19, 22],
                    [10333, 30, 29], [10334, 31, 29], [10335, 30, 31], [10337, 22, 22], [10338, 35, 29],
                    [10339, 24, 25], [10340, 37, 29], [10341, 20, 21], [10342, 30, 25], [10343, 26, 24],
                    [10344, 25, 28], [10347, 20, 27], [10354, 19, 21], [10355, 32, 28], [10356, 23, 25],
                    [10357, 31, 31], [10358, 30, 26], [10360, 19, 22], [10361, 33, 27], [10362, 30, 29],
                    [10363, 42, 30], [10364, 50, 30], [10366, 33, 30], [10367, 40, 28], [10368, 48, 33],
                    [10369, 40, 29], [10370, 51, 35], [10371, 29, 34], [10372, 19, 22], [10374, 21, 24],
                    [10376, 20, 21], [10377, 25, 25], [10378, 27, 27], [10380, 24, 25], [10381, 42, 32],
                    [10382, 25, 26], [10383, 50, 32], [10384, 29, 28], [10385, 52, 33], [10388, 17, 24],
                    [10390, 23, 26], [10391, 28, 24], [10392, 27, 27], [10394, 20, 21], [10395, 30, 27],
                    [10396, 21, 23], [10398, 21, 25], [10399, 31, 28], [10400, 22, 24], [10402, 20, 26],
                    [10403, 35, 34], [10404, 24, 27], [10408, 20, 26], [10409, 31, 33], [10410, 22, 27],
                    [10411, 34, 31], [10412, 32, 21], [10413, 57, 36], [10417, 33, 33], [10418, 20, 22],
                    [10419, 28, 28], [10420, 33, 33], [10422, 26, 28], [10424, 36, 30], [10425, 20, 24],
                    [10426, 30, 30], [10427, 25, 24], [10428, 27, 29], [10431, 21, 25], [10432, 33, 29],
                    [10433, 19, 22], [10434, 33, 28], [10435, 31, 26], [10436, 24, 23], [10437, 29, 23],
                    [10438, 22, 24], [10439, 31, 32], [10440, 20, 25], [10441, 30, 27], [10442, 25, 26],
                    [10443, 20, 21], [10444, 32, 24], [10445, 35, 29], [10447, 19, 20], [10448, 31, 27],
                    [10450, 19, 23], [10453, 44, 26], [10454, 38, 25], [10455, 44, 29], [10456, 19, 22],
                    [10458, 20, 22], [10459, 27, 24], [10461, 21, 26], [10463, 17, 21], [10464, 26, 27],
                    [10467, 20, 26], [10469, 23, 23], [10471, 22, 21], [10474, 13, 11], [10475, 13, 11],
                    [10476, 15, 16], [10477, 17, 17], [10478, 23, 28], [10479, 32, 24], [10480, 19, 20],
                    [10482, 20, 23], [10483, 26, 28], [10484, 20, 23], [10485, 25, 29], [10486, 20, 23],
                    [10487, 25, 30], [10490, 18, 30], [10491, 9, 18], [10492, 8, 13], [10493, 33, 42], [10494, 11, 34],
                    [10495, 10, 27], [10496, 7, 16], [10497, 28, 44], [10498, 8, 16], [10499, 9, 39], [10500, 10, 40],
                    [10501, 10, 45], [10502, 30, 61], [10503, 11, 40], [10504, 12, 50], [10505, 32, 45],
                    [10506, 12, 28], [10507, 9, 20], [10508, 22, 49], [10509, 29, 35], [10510, 12, 35], [10511, 8, 18],
                    [10512, 19, 21], [10513, 29, 28], [10514, 15, 22], [10515, 15, 23], [10516, 14, 20],
                    [10517, 19, 25], [10518, 14, 14], [10519, 17, 14], [10520, 9, 9], [10521, 14, 18], [10522, 16, 18],
                    [10523, 14, 18], [10524, 22, 20], [10525, 15, 18], [10526, 14, 18], [10527, 11, 13],
                    [10528, 17, 18], [10529, 17, 18], [10530, 14, 18], [10531, 14, 16], [10532, 22, 21],
                    [10533, 32, 27], [10534, 20, 13], [10535, 31, 25], [10536, 16, 19], [10537, 22, 20],
                    [10538, 29, 24], [10539, 17, 17], [10540, 31, 25], [10541, 36, 31], [10542, 38, 28], [10543, 7, 7],
                    [10544, 11, 9], [10545, 7, 7], [10546, 10, 8], [10547, 8, 8], [10548, 12, 9], [10549, 8, 8],
                    [10550, 9, 11], [10551, 9, 8], [10552, 7, 7], [10553, 24, 16], [10554, 19, 13], [10555, 11, 8],
                    [10556, 20, 13], [10557, 10, 10], [10558, 30, 20], [10559, 14, 9], [10560, 20, 13], [10577, 21, 13],
                    [10578, 29, 32], [10579, 53, 37], [10580, 68, 40], [10581, 63, 53], [10582, 52, 39],
                    [10583, 49, 42], [10584, 49, 42], [10585, 40, 41], [10586, 52, 47], [10587, 47, 40],
                    [10588, 41, 38], [10589, 46, 42], [10590, 60, 47], [10591, 68, 63], [10592, 53, 31],
                    [10593, 48, 39], [10594, 53, 49], [10595, 39, 41], [10596, 40, 37], [10597, 46, 38],
                    [10598, 41, 31], [10602, 26, 29], [10603, 38, 35], [10604, 34, 24], [10605, 16, 12],
                    [10606, 14, 10], [10607, 18, 14], [10608, 14, 10], [10609, 14, 10], [10610, 21, 11],
                    [10611, 21, 14], [10612, 18, 14], [10613, 43, 30], [10614, 43, 24], [10615, 42, 30],
                    [10616, 37, 27], [10617, 46, 33], [10618, 48, 27], [10619, 34, 22], [10620, 28, 19],
                    [10621, 39, 26], [10622, 32, 18], [10623, 39, 25], [10624, 44, 24], [10625, 29, 20],
                    [10626, 42, 25], [10627, 42, 30], [10628, 46, 30], [10629, 46, 30], [10630, 42, 26],
                    [10631, 42, 24], [10632, 34, 21], [10633, 50, 38], [10634, 45, 30], [10635, 46, 32],
                    [10636, 38, 27], [10637, 50, 31], [10638, 22, 16], [10639, 47, 32], [10640, 45, 27],
                    [10641, 42, 28], [10642, 51, 30], [10643, 39, 25], [10644, 54, 33], [10645, 32, 28],
                    [10646, 44, 28], [10647, 46, 28], [10648, 40, 32], [10649, 42, 25], [10650, 44, 31],
                    [10651, 42, 31], [10652, 36, 23], [10653, 46, 29], [10654, 38, 28], [10655, 45, 32],
                    [10656, 45, 28], [10657, 37, 27], [10658, 48, 27], [10659, 19, 17], [10660, 48, 33],
                    [10661, 63, 28], [10662, 46, 28], [10663, 37, 26], [10664, 40, 29], [10665, 47, 32],
                    [10666, 66, 33], [10667, 56, 31], [10668, 40, 29], [10669, 20, 16], [10670, 38, 26],
                    [10671, 48, 28], [10672, 48, 26], [10673, 32, 22], [10674, 35, 21], [10675, 45, 34],
                    [10676, 39, 33], [10677, 35, 21], [10678, 38, 24], [10679, 51, 27], [10680, 35, 28],
                    [10681, 42, 32], [10682, 39, 24], [10683, 34, 23], [10684, 26, 19], [10685, 75, 37],
                    [10686, 41, 35], [10687, 39, 34], [10688, 53, 37], [10689, 53, 34], [10690, 54, 36],
                    [10691, 55, 36], [10692, 48, 32], [10693, 69, 34], [10694, 54, 31], [10695, 54, 30],
                    [10696, 47, 28], [10697, 31, 23], [10698, 36, 29], [10699, 42, 33], [10700, 20, 15],
                    [10701, 47, 29], [10702, 63, 26], [10703, 64, 26], [10704, 46, 25], [10705, 48, 23],
                    [10706, 46, 33], [10707, 40, 38], [10708, 51, 38], [10709, 46, 39], [10710, 60, 30],
                    [10711, 45, 30], [10712, 48, 35], [10713, 57, 35], [10714, 43, 27], [10715, 55, 31],
                    [10716, 46, 36], [10717, 46, 36], [10718, 42, 37], [10719, 54, 33], [10720, 56, 36],
                    [10721, 27, 20], [10722, 55, 35], [10723, 46, 34], [10724, 48, 35], [10725, 45, 36],
                    [10726, 35, 24], [10727, 46, 27], [10728, 46, 27], [10729, 50, 33], [10730, 57, 32],
                    [10731, 37, 31], [10732, 55, 35], [10733, 47, 32], [10734, 47, 30], [10735, 47, 26],
                    [10736, 47, 32], [10737, 69, 40], [10738, 48, 28], [10739, 27, 15], [10740, 45, 30],
                    [10741, 46, 35], [10742, 45, 30], [10743, 40, 27], [10744, 39, 24], [10745, 44, 27],
                    [10746, 45, 24], [10747, 27, 16], [10748, 38, 25], [10749, 43, 29], [10750, 46, 30],
                    [10751, 45, 30], [10752, 45, 32], [10753, 50, 33], [10754, 39, 25], [10755, 19, 15],
                    [10756, 75, 45], [10757, 20, 14], [10758, 28, 18], [10759, 49, 26], [10760, 50, 30],
                    [10761, 43, 28], [10762, 45, 35], [10763, 38, 25], [10764, 26, 21], [10765, 34, 23],
                    [10766, 55, 32], [10767, 47, 30], [10768, 42, 30], [10769, 44, 27], [10770, 46, 32],
                    [10771, 47, 34], [10772, 34, 38], [10773, 45, 41], [10774, 38, 23], [10775, 44, 23],
                    [10776, 38, 22], [10777, 29, 20], [10778, 66, 33], [10779, 35, 26], [10780, 44, 27],
                    [10781, 40, 27], [10782, 44, 30], [10783, 49, 33], [10784, 45, 29], [10785, 48, 26],
                    [10786, 42, 30], [10787, 48, 28], [10788, 43, 32], [10789, 42, 25], [10790, 48, 25],
                    [10791, 48, 25], [10792, 35, 28], [10793, 45, 28], [10794, 48, 32], [10795, 48, 30],
                    [10796, 46, 32], [10797, 43, 29], [10798, 38, 28], [10799, 21, 16], [10800, 44, 30],
                    [10801, 56, 33], [10802, 46, 25], [10803, 34, 20], [10804, 54, 30], [10805, 63, 31],
                    [10806, 41, 31], [10807, 45, 23], [10808, 35, 20], [10809, 29, 25], [10810, 46, 29],
                    [10811, 43, 26], [10812, 56, 41], [10814, 37, 27], [10815, 46, 29], [10816, 46, 30],
                    [10817, 46, 30], [10818, 47, 31], [10819, 46, 29], [10820, 46, 27], [10821, 41, 28],
                    [10822, 44, 29], [10823, 46, 27], [10824, 37, 26], [10825, 38, 32], [10826, 40, 24],
                    [10827, 38, 29], [10828, 33, 26], [10829, 46, 30], [10830, 45, 27], [10831, 46, 30],
                    [10832, 44, 26], [10833, 44, 26], [10834, 45, 27], [10835, 46, 28], [10836, 43, 27],
                    [10837, 49, 27], [10838, 44, 27], [10839, 36, 26], [10840, 27, 20], [10841, 60, 30],
                    [10842, 33, 30], [10843, 44, 29], [10844, 34, 25], [10845, 31, 23], [10846, 33, 25],
                    [10847, 40, 28], [10848, 44, 30], [10849, 46, 30], [10850, 40, 27], [10851, 45, 29],
                    [10852, 44, 28], [10853, 53, 36], [10854, 44, 31], [10855, 48, 27], [10856, 46, 30],
                    [10857, 47, 31], [10858, 43, 27], [10859, 48, 27], [10860, 55, 29], [10861, 51, 29],
                    [10862, 48, 27], [10863, 24, 19], [10864, 59, 29], [10865, 43, 30], [10866, 36, 22],
                    [10867, 44, 26], [10868, 45, 26], [10869, 61, 32], [10870, 55, 33], [10871, 47, 25],
                    [10872, 58, 28], [10873, 52, 31], [10874, 52, 32], [10875, 48, 30], [10876, 53, 26],
                    [10877, 56, 29], [10878, 46, 26], [10879, 48, 30], [10880, 49, 30], [10881, 35, 25],
                    [10882, 54, 30], [10883, 62, 33], [10884, 68, 33], [10885, 48, 31], [10886, 44, 24],
                    [10887, 38, 27], [10888, 56, 30], [10889, 45, 28], [10890, 37, 24], [10891, 29, 21],
                    [10892, 32, 20], [10893, 47, 36], [10894, 46, 36], [10895, 70, 35], [10896, 46, 33],
                    [10897, 48, 35], [10898, 44, 34], [10899, 53, 30], [10900, 44, 29], [10901, 41, 29],
                    [10902, 38, 23], [10903, 48, 32], [10904, 48, 30], [10905, 37, 23], [10906, 48, 33],
                    [10907, 46, 32], [10908, 45, 27], [10909, 54, 35], [10910, 43, 31], [10911, 54, 31],
                    [10912, 54, 40], [10913, 38, 32], [10914, 66, 33], [10915, 49, 38], [10916, 52, 37],
                    [10917, 56, 36], [10918, 35, 29], [10978, 44, 30], [10979, 43, 26], [10980, 39, 24], [11091, 8, 5],
                    [11092, 10, 8], [11093, 12, 7], [11094, 15, 12], [11095, 10, 7], [11096, 18, 12], [11097, 10, 8],
                    [11098, 9, 7], [11099, 32, 18], [11100, 13, 11], [11101, 11, 9], [11102, 12, 9], [11103, 14, 10],
                    [11104, 43, 22], [11105, 32, 22], [11106, 27, 15], [11107, 16, 10], [11108, 9, 6], [11109, 16, 12],
                    [11110, 15, 9], [11111, 12, 7], [11112, 23, 14], [11113, 26, 16], [11114, 45, 30], [11115, 7, 6],
                    [11116, 8, 6], [11117, 8, 5], [11118, 14, 9], [11119, 42, 24], [11120, 27, 16], [11121, 9, 6],
                    [11122, 12, 8], [11123, 18, 12], [11124, 9, 8], [11125, 25, 15], [11126, 13, 11], [11127, 7, 7],
                    [11128, 13, 7], [11129, 7, 6], [11130, 15, 10], [11131, 7, 6], [11132, 24, 14], [11133, 11, 8],
                    [11134, 6, 4], [11135, 53, 25], [11136, 10, 8], [11137, 6, 5], [11138, 19, 11], [11139, 10, 6],
                    [11140, 10, 9], [11141, 8, 6], [11142, 9, 7], [11143, 7, 6], [11144, 9, 8], [11145, 30, 19],
                    [11146, 7, 6], [11147, 5, 3], [11148, 37, 22], [11149, 18, 11], [11150, 18, 16], [11151, 22, 15],
                    [11152, 16, 11], [11153, 14, 9], [11154, 25, 18], [11155, 18, 10], [11156, 11, 10], [11157, 14, 10],
                    [11158, 14, 10], [11159, 20, 10], [11160, 29, 15], [11161, 12, 10], [11162, 18, 12],
                    [11163, 14, 12], [11164, 17, 15], [11165, 17, 12], [11166, 40, 26], [11167, 75, 43],
                    [11168, 26, 18], [11169, 8, 8], [11170, 10, 9], [11171, 12, 10], [11172, 10, 9], [11173, 12, 11],
                    [11174, 6, 6], [11175, 6, 6], [11176, 6, 6], [11177, 21, 18], [11178, 7, 7], [11179, 14, 12],
                    [11180, 13, 10], [11181, 16, 13], [11182, 14, 11], [11183, 14, 13], [11184, 97, 75],
                    [11185, 97, 75], [11186, 97, 75], [11187, 97, 75], [11188, 97, 75], [11189, 74, 76],
                    [11195, 18, 17], [11197, 81, 40], [11199, 45, 26], [11201, 10, 10], [11202, 44, 29],
                    [11203, 12, 13], [11204, 75, 49], [11205, 108, 74], [11206, 59, 52], [11207, 10, 11],
                    [11209, 221, 179], [11210, 741, 95], [11211, 102, 103], [11212, 741, 103], [11213, 741, 95],
                    [11214, 741, 95], [11215, 102, 103], [11216, 741, 103], [11217, 102, 103], [11218, 741, 103],
                    [11219, 102, 103], [11220, 741, 95], [11221, 102, 103], [11222, 102, 103], [11223, 102, 103],
                    [11224, 102, 103], [11225, 741, 103], [11226, 741, 103], [11228, 102, 103], [11229, 102, 103],
                    [11230, 102, 103], [11231, 102, 103], [11232, 102, 103], [11233, 102, 103], [11234, 102, 103],
                    [11235, 102, 103], [11236, 102, 103], [11237, 741, 103], [11238, 741, 103], [11239, 102, 103],
                    [11240, 102, 103], [11241, 102, 103], [11242, 102, 103], [11243, 741, 95], [11245, 102, 103],
                    [11246, 221, 171], [11247, 221, 171], [11248, 102, 103], [11249, 102, 103], [11250, 102, 103],
                    [11251, 102, 103], [11252, 102, 103], [11253, 102, 103], [11254, 102, 103], [11255, 102, 103],
                    [11256, 102, 103], [11257, 741, 103], [11258, 741, 103], [11259, 741, 95], [11260, 741, 103],
                    [11262, 102, 103], [11263, 102, 103], [11264, 102, 103], [11265, 102, 103], [11266, 102, 103],
                    [11267, 102, 103], [11268, 102, 103], [11269, 102, 103], [11270, 221, 171], [11271, 741, 103],
                    [11272, 741, 103], [11274, 102, 103], [11275, 102, 103], [11276, 102, 103], [11277, 102, 103],
                    [11278, 102, 103], [11279, 221, 171], [11280, 741, 103], [11281, 741, 103], [11283, 102, 103],
                    [11284, 102, 103], [11285, 102, 103], [11286, 102, 103], [11287, 102, 103], [11288, 102, 103],
                    [11289, 102, 103], [11290, 741, 103], [11291, 741, 103], [11292, 14, 18], [11293, 10, 12],
                    [11294, 12, 15], [11295, 12, 15], [11296, 31, 54], [11298, 23, 20], [11300, 40, 40],
                    [11303, 19, 17], [11304, 30, 20], [11305, 54, 43], [11306, 14, 20], [11307, 16, 20],
                    [11308, 16, 25], [11309, 25, 21], [11310, 19, 19], [11311, 20, 20], [11312, 22, 18],
                    [11313, 17, 19], [11314, 34, 35], [11315, 33, 29], [11316, 29, 32], [11317, 33, 32],
                    [11318, 19, 21], [11319, 21, 19], [11320, 20, 17], [11321, 45, 31], [11322, 55, 31],
                    [11323, 25, 26], [11324, 29, 20], [11325, 34, 22], [11326, 26, 28], [11327, 30, 23],
                    [11328, 28, 31], [11329, 22, 26], [11330, 34, 35], [11331, 32, 32], [11332, 20, 17],
                    [11333, 38, 27], [11334, 43, 28], [11335, 29, 22], [11336, 13, 14], [11337, 25, 26],
                    [11338, 26, 28], [11339, 33, 28], [11340, 33, 32], [11341, 37, 30], [11342, 33, 30],
                    [11343, 34, 35], [11344, 33, 33], [11345, 27, 31], [11346, 40, 30], [11347, 33, 28],
                    [11348, 44, 37], [11349, 21, 18], [11350, 33, 32], [11351, 29, 32], [11352, 29, 32],
                    [11353, 38, 35], [11354, 29, 23], [11355, 33, 28], [11356, 32, 26], [11357, 27, 24],
                    [11358, 25, 26], [11359, 40, 38], [11360, 36, 25], [11361, 44, 37], [11362, 28, 26], [11363, 9, 10],
                    [11364, 11, 12], [11365, 33, 23], [11366, 21, 21], [11367, 44, 41], [11368, 20, 21],
                    [11369, 43, 44], [11370, 20, 24], [11371, 30, 29], [11372, 32, 33], [11373, 50, 32],
                    [11374, 39, 37], [11375, 56, 42], [11376, 20, 20], [11377, 42, 38], [11378, 27, 28],
                    [11384, 48, 44], [11385, 67, 67], [11386, 65, 67], [11387, 88, 73], [11388, 67, 60],
                    [11389, 48, 40], [11390, 52, 46], [11391, 45, 37], [11392, 88, 73], [11393, 61, 53],
                    [11394, 94, 67], [11395, 88, 73], [11396, 87, 83], [11397, 87, 78], [11398, 56, 52],
                    [11399, 86, 83], [11400, 88, 73], [11401, 71, 33], [11402, 54, 53], [11403, 52, 55],
                    [11404, 93, 75], [11405, 64, 59], [11406, 80, 70], [11407, 39, 37], [11408, 81, 62],
                    [11409, 51, 42], [11410, 72, 55], [11411, 53, 45], [11412, 85, 83], [11413, 82, 75],
                    [11414, 56, 65], [11415, 88, 73], [11416, 38, 34], [11417, 52, 48], [11418, 60, 65],
                    [11419, 51, 48], [11420, 70, 57], [11421, 95, 71], [11422, 62, 62], [11423, 53, 61],
                    [11424, 52, 41], [11425, 22, 18], [11426, 9, 7], [11427, 8, 8], [11428, 52, 25], [11429, 15, 12],
                    [11430, 9, 10], [11431, 12, 10], [11432, 8, 8], [11433, 10, 12], [11434, 10, 9], [11435, 7, 8],
                    [11436, 20, 20], [11437, 12, 11], [11438, 10, 9], [11439, 11, 9], [11440, 16, 14], [11441, 45, 27],
                    [11442, 9, 8], [11443, 11, 11], [11444, 14, 9], [11445, 8, 8], [11446, 11, 9], [11447, 17, 14],
                    [11448, 12, 10], [11449, 12, 8], [11450, 12, 10], [11451, 9, 7], [11452, 10, 9], [11453, 30, 19],
                    [11454, 13, 11], [11455, 8, 8], [11456, 8, 8], [11457, 9, 9], [11458, 6, 7], [11459, 6, 6],
                    [11460, 7, 6], [11461, 9, 8], [11462, 7, 7], [11463, 10, 9], [11464, 9, 7], [11465, 18, 14],
                    [11466, 14, 9], [11467, 15, 11], [11468, 37, 24], [11469, 16, 12], [11470, 20, 16], [11471, 15, 14],
                    [11472, 27, 17], [11473, 10, 9], [11474, 8, 9], [11475, 9, 9], [11476, 12, 9], [11477, 24, 19],
                    [11478, 29, 19], [11479, 11, 9], [11480, 21, 17], [11481, 15, 14], [11482, 17, 14], [11483, 19, 15],
                    [11484, 20, 15], [11485, 25, 18], [11486, 22, 15], [11487, 17, 14], [11488, 24, 18],
                    [11489, 13, 11], [11490, 14, 13], [11491, 11, 9], [11492, 8, 7], [11493, 8, 8], [11494, 6, 7],
                    [11495, 6, 6], [11496, 7, 8], [11497, 9, 8], [11498, 9, 8], [11499, 9, 9], [11500, 22, 20],
                    [11501, 8, 8], [11502, 12, 10], [11503, 7, 8], [11504, 9, 9], [11505, 14, 11], [11506, 10, 10],
                    [11507, 11, 12], [11508, 7, 8], [11509, 27, 16], [11510, 11, 9], [11511, 12, 9], [11512, 19, 12],
                    [11513, 13, 11], [11514, 9, 9], [11515, 9, 9], [11516, 14, 11], [11517, 20, 18], [11518, 10, 15],
                    [11519, 22, 14], [11520, 32, 20], [11521, 8, 6], [11522, 10, 10], [11523, 11, 9], [11524, 8, 7],
                    [11525, 11, 8], [11526, 16, 11], [11527, 10, 10], [11528, 8, 7], [11529, 76, 75], [11530, 77, 83],
                    [11531, 65, 43], [11532, 68, 87], [11533, 40, 35], [11534, 86, 83], [11535, 96, 79],
                    [11536, 38, 50], [11537, 93, 65], [11538, 85, 69], [11539, 70, 53], [11540, 51, 39],
                    [11541, 96, 71], [11542, 89, 73], [11543, 99, 68], [11544, 44, 48], [11545, 49, 65],
                    [11546, 102, 73], [11547, 96, 73], [11548, 102, 73], [11549, 51, 41], [11550, 96, 72],
                    [11551, 61, 49], [11552, 89, 83], [11553, 95, 83], [11554, 34, 53], [11555, 57, 54],
                    [11556, 97, 72], [11557, 94, 72], [11558, 59, 83], [11559, 96, 72], [11560, 42, 54],
                    [11561, 90, 68], [11562, 94, 72], [11563, 101, 83], [11564, 81, 83], [11565, 102, 70],
                    [11566, 70, 83], [11567, 96, 72], [11568, 94, 67], [11569, 94, 82], [11570, 94, 72],
                    [11571, 10, 11], [11572, 17, 14], [11573, 120, 90], [11574, 12, 12], [11575, 31, 30],
                    [11576, 14, 14], [11577, 14, 14], [11578, 19, 19], [11579, 18, 24], [11580, 11, 13],
                    [11581, 14, 17], [11582, 18, 20], [11583, 35, 27], [11585, 29, 17], [11586, 49, 25],
                    [11587, 14, 13], [11588, 64, 32], [11589, 45, 27], [11590, 36, 25], [11591, 29, 21],
                    [11592, 60, 35], [11593, 53, 23], [11594, 82, 44], [11595, 43, 26], [11596, 28, 28],
                    [11597, 76, 44], [11598, 27, 14], [11599, 30, 23], [11600, 26, 23], [11601, 52, 32],
                    [11602, 57, 34], [11603, 60, 30], [11604, 16, 17], [11605, 23, 18], [11606, 37, 30],
                    [11607, 36, 27], [11608, 31, 30], [11609, 37, 22], [11610, 29, 33], [11611, 34, 24],
                    [11612, 39, 26], [11613, 36, 24], [11614, 26, 24], [11615, 28, 18], [11616, 26, 22],
                    [11617, 27, 23], [11618, 33, 32], [11619, 25, 21], [11620, 23, 21], [11621, 34, 24],
                    [11622, 25, 30], [11623, 22, 22], [11624, 35, 25], [11625, 22, 26], [11626, 22, 25],
                    [11627, 33, 20], [11628, 31, 26], [11629, 28, 29], [11630, 49, 26], [11631, 49, 36],
                    [11632, 30, 26], [11633, 21, 22], [11634, 36, 32], [11635, 25, 21], [11636, 23, 23],
                    [11637, 32, 25], [11638, 37, 25], [11639, 26, 26], [11640, 51, 34], [11641, 30, 20],
                    [11642, 22, 20], [11643, 35, 25], [11644, 29, 20], [11645, 32, 27], [11646, 16, 19],
                    [11647, 27, 23], [11648, 20, 21], [11649, 23, 20], [11650, 18, 19], [11651, 27, 27],
                    [11652, 30, 22], [11653, 45, 27], [11654, 38, 24], [11655, 39, 28], [11656, 43, 25],
                    [11657, 55, 35], [11658, 29, 23], [11659, 49, 38], [11660, 31, 29], [11661, 29, 22],
                    [11662, 42, 26], [11663, 31, 22], [11664, 26, 26], [11665, 57, 26], [11666, 43, 25],
                    [11667, 50, 32], [11668, 33, 24], [11669, 33, 22], [11670, 38, 28], [11671, 39, 26],
                    [11672, 34, 28], [11673, 42, 28], [11674, 34, 29], [11675, 43, 40], [11676, 41, 28],
                    [11677, 58, 43], [11678, 48, 31], [11679, 40, 24], [11680, 40, 25], [11681, 33, 26],
                    [11682, 55, 25], [11683, 25, 20], [11684, 35, 24], [11685, 24, 22], [11686, 42, 24],
                    [11687, 20, 20], [11688, 53, 38], [11689, 38, 24], [11690, 25, 21], [11691, 32, 25],
                    [11692, 36, 27], [11693, 20, 20], [11694, 19, 19], [11695, 22, 21], [11696, 24, 23],
                    [11697, 24, 24], [11698, 19, 19], [11699, 40, 32], [11700, 30, 25], [11701, 30, 29],
                    [11702, 35, 25], [11703, 19, 17], [11704, 21, 22], [11705, 46, 26], [11706, 128, 61],
                    [11707, 28, 22], [11708, 27, 23], [11709, 55, 27], [11710, 74, 34], [11712, 44, 34],
                    [11713, 77, 37], [11714, 36, 11], [11715, 58, 71], [11716, 58, 72], [11717, 33, 48],
                    [11718, 122, 60], [11719, 132, 50], [11720, 68, 80], [11721, 20, 25], [11722, 70, 70],
                    [11723, 111, 108], [11724, 65, 52], [11725, 150, 150], [11726, 72, 65], [11727, 150, 150],
                    [11728, 62, 50], [11729, 135, 103], [11730, 38, 28], [11731, 70, 70], [11732, 100, 100],
                    [11733, 150, 136], [11734, 74, 60], [11735, 155, 108], [11736, 110, 100], [11737, 46, 50],
                    [11738, 70, 70], [11739, 28, 22], [11741, 23, 29], [11742, 70, 70], [11743, 164, 66],
                    [11744, 120, 105], [11745, 76, 31], [11746, 31, 19], [11747, 92, 50], [11748, 120, 120],
                    [11749, 82, 63], [11750, 101, 50], [11751, 179, 130], [11752, 62, 50], [11753, 99, 50],
                    [11754, 61, 50], [11755, 19, 21], [11756, 70, 70], [11757, 90, 48], [11758, 52, 67],
                    [11759, 25, 21], [11760, 70, 70], [11761, 85, 60], [11762, 62, 50], [11763, 27, 30],
                    [11764, 76, 46], [11765, 158, 80], [11766, 60, 50], [11767, 173, 63], [11768, 102, 86],
                    [11769, 180, 142], [11770, 107, 66], [11771, 100, 50], [11772, 134, 143], [11773, 137, 104],
                    [11774, 120, 77], [11775, 47, 42], [11776, 65, 60], [11777, 35, 30], [11779, 75, 100],
                    [11780, 32, 19], [11781, 20, 22], [11782, 16, 19], [11783, 36, 26], [11784, 26, 22],
                    [11785, 32, 30], [11786, 67, 43], [11787, 39, 38], [11788, 44, 36], [11789, 42, 35],
                    [11790, 15, 18], [11791, 45, 21], [11792, 70, 70], [11793, 70, 70], [11794, 34, 25],
                    [11795, 25, 26], [11796, 49, 42], [11797, 47, 34], [11798, 38, 27], [11799, 38, 28],
                    [11800, 37, 30], [11801, 40, 27], [11802, 38, 32], [11803, 42, 31], [11804, 36, 30],
                    [11805, 39, 29], [11806, 47, 38], [11807, 29, 26], [11808, 30, 18], [11809, 22, 14],
                    [11810, 25, 17], [11811, 23, 17], [11812, 32, 23], [11813, 12, 13], [11814, 23, 21],
                    [11815, 22, 19], [11816, 24, 20], [11817, 18, 12], [11818, 19, 20], [11819, 29, 15],
                    [11820, 18, 14], [11821, 26, 17], [11822, 25, 16], [11823, 40, 22], [11824, 22, 19],
                    [11825, 26, 18], [11826, 21, 19], [11827, 21, 18], [11828, 16, 13], [11829, 24, 22],
                    [11830, 14, 12], [11831, 18, 17], [11832, 29, 19], [11833, 26, 15], [11834, 6, 6], [11835, 25, 13],
                    [11836, 27, 18], [11837, 11, 11], [11838, 7, 6], [11839, 12, 11], [11840, 8, 7], [11841, 6, 5],
                    [11842, 22, 17], [11843, 25, 21], [11844, 20, 21], [11845, 23, 19], [11846, 32, 21],
                    [11847, 23, 18], [11848, 15, 12], [11849, 23, 18], [11850, 17, 13], [11851, 24, 17],
                    [11852, 21, 18], [11853, 22, 15], [11854, 18, 20], [11855, 17, 16], [11856, 25, 25],
                    [11858, 75, 85], [11859, 75, 85], [11860, 65, 85]]],
            [2006, [[25, 12, 9], [48, 46, 31], [49, 26, 19], [62, 18, 24], [65, 18, 16], [82, 15, 16], [83, 28, 30],
                    [101, 42, 33], [119, 31, 22], [163, 31, 29], [200, 31, 23], [204, 15, 24], [220, 11, 14],
                    [226, 21, 19], [231, 44, 31], [233, 17, 18], [234, 12, 12], [240, 63, 37], [246, 31, 18],
                    [282, 37, 26], [310, 13, 15], [314, 17, 22], [324, 32, 27], [327, 35, 30], [346, 42, 34],
                    [355, 35, 27], [379, 13, 12], [389, 24, 24], [399, 46, 28], [425, 11, 17], [430, 18, 20],
                    [436, 41, 34], [479, 43, 34], [480, 50, 28], [503, 95, 27], [504, 9, 10], [541, 112, 41],
                    [585, 44, 31], [590, 43, 49], [593, 42, 34], [597, 31, 14], [604, 96, 52], [612, 27, 27],
                    [618, 20, 16], [662, 46, 39], [663, 54, 27], [669, 25, 17], [686, 17, 18], [694, 30, 24],
                    [700, 42, 33], [703, 15, 15], [716, 42, 35], [734, 19, 23], [751, 25, 20], [766, 77, 41],
                    [769, 46, 29], [803, 26, 24], [805, 22, 20], [820, 50, 29], [822, 14, 18], [827, 11, 13],
                    [845, 42, 37], [865, 70, 27], [871, 31, 19], [878, 7, 6], [882, 36, 27], [894, 18, 13],
                    [913, 17, 17], [922, 27, 31], [938, 11, 12], [940, 11, 13], [941, 33, 35], [964, 11, 15],
                    [969, 40, 33], [971, 11, 11], [985, 57, 36], [998, 36, 28], [1003, 8, 6], [1008, 33, 33],
                    [1016, 8, 10], [1030, 9, 12], [1048, 34, 32], [1056, 21, 30], [1059, 46, 45], [1106, 52, 29],
                    [1111, 38, 38], [1132, 11, 12], [1136, 32, 30], [1145, 25, 20], [1150, 26, 21], [1156, 23, 17],
                    [1157, 34, 31], [1159, 73, 28], [1174, 24, 31], [1186, 15, 15], [1203, 11, 17], [1213, 18, 16],
                    [1221, 15, 17], [1226, 28, 23], [1234, 14, 15], [1235, 23, 18], [1238, 14, 21], [1247, 34, 24],
                    [1254, 44, 23], [1268, 28, 24], [1275, 26, 17], [1281, 11, 11], [1295, 36, 33], [1302, 40, 43],
                    [1303, 51, 31], [1320, 34, 34], [1396, 13, 16], [1420, 49, 40], [1445, 63, 23], [1456, 22, 21],
                    [1466, 25, 22], [1473, 13, 10], [1481, 32, 22], [1491, 11, 8], [1507, 33, 28], [1515, 18, 15],
                    [1525, 33, 31], [1530, 65, 41], [1536, 17, 21], [1557, 38, 27], [1577, 23, 17], [1580, 35, 29],
                    [1587, 14, 15], [1589, 39, 23], [1598, 11, 8], [1628, 28, 17], [1635, 17, 13], [1638, 40, 30],
                    [1645, 48, 30], [1673, 74, 40], [1685, 30, 28], [1704, 16, 15], [1717, 44, 31], [1730, 14, 11],
                    [1769, 43, 36], [1772, 10, 12], [1774, 21, 18], [1794, 27, 25], [1795, 12, 9], [1797, 44, 28],
                    [1798, 34, 34], [1824, 61, 34], [1841, 32, 31], [1845, 21, 21], [1864, 98, 58], [1866, 37, 24],
                    [1891, 29, 22], [1894, 26, 15], [1903, 53, 28], [1921, 13, 11], [1930, 10, 8], [1952, 160, 59],
                    [1962, 12, 13], [1965, 58, 35], [2011, 19, 18], [2017, 36, 30], [2023, 7, 7], [2035, 39, 28],
                    [2048, 15, 26], [2056, 22, 39], [2064, 45, 28], [2098, 12, 15], [2142, 9, 10], [2178, 15, 14],
                    [2190, 25, 19], [2198, 17, 15], [2208, 70, 37], [2213, 36, 28], [2227, 15, 17], [2244, 20, 20],
                    [2250, 36, 25], [2277, 24, 18], [2280, 13, 10], [2282, 17, 39], [2300, 43, 34], [2311, 28, 26],
                    [2316, 42, 31], [2343, 35, 25], [2352, 36, 28], [2371, 44, 28], [2384, 22, 24], [2429, 15, 16],
                    [2435, 14, 16], [2443, 41, 28], [2458, 28, 21], [2459, 19, 18], [2467, 14, 14], [2483, 39, 42],
                    [2485, 18, 14], [2500, 23, 17], [2501, 44, 30], [2505, 38, 25], [2524, 10, 9], [2533, 10, 16],
                    [2539, 73, 23], [2547, 15, 28], [2554, 11, 20], [2576, 52, 30], [2585, 40, 28], [2595, 34, 29],
                    [2606, 13, 13], [2627, 37, 24], [2635, 14, 15], [2670, 34, 23], [2671, 39, 36], [2692, 30, 23],
                    [2695, 17, 13], [2720, 26, 28], [2723, 34, 34], [2758, 30, 25], [2775, 44, 28], [2785, 10, 11],
                    [2798, 16, 17], [2822, 22, 18], [2835, 23, 21], [2836, 17, 17], [2879, 20, 18], [2883, 33, 36],
                    [2914, 39, 26], [2922, 13, 14], [2991, 34, 26], [3019, 39, 21], [3033, 57, 43], [3046, 47, 22],
                    [3053, 51, 34], [3066, 41, 28], [3086, 124, 48], [3091, 12, 14], [3092, 40, 27], [3119, 11, 19],
                    [3126, 32, 24], [3134, 30, 31], [3142, 24, 29], [3158, 18, 20], [3164, 40, 30], [3171, 28, 17],
                    [3182, 107, 40], [3221, 38, 29], [3246, 77, 38], [3252, 39, 26], [3254, 21, 25], [3273, 48, 30],
                    [3274, 20, 18], [3301, 34, 28], [3308, 46, 29], [3309, 33, 33], [3321, 36, 24], [3327, 36, 28],
                    [3348, 41, 28], [3364, 11, 14], [3372, 40, 28], [3382, 26, 17], [3434, 7, 7], [3438, 44, 25],
                    [3451, 58, 41], [3454, 11, 11], [3459, 23, 19], [3462, 40, 23], [3494, 11, 12], [3503, 88, 43],
                    [3515, 13, 33], [3517, 37, 27], [3559, 34, 27], [3569, 43, 44], [3579, 16, 26], [3590, 17, 22],
                    [3593, 48, 49], [3659, 37, 27], [3669, 14, 18], [3700, 19, 17], [3718, 43, 31], [3726, 13, 12],
                    [3729, 134, 46], [3765, 14, 18], [3833, 30, 30], [3859, 11, 15], [3884, 42, 26], [3889, 45, 24],
                    [3925, 45, 30], [3943, 22, 22], [3956, 38, 46], [3972, 134, 64], [3976, 17, 17], [3985, 21, 19],
                    [3993, 15, 15], [4015, 41, 26], [4022, 42, 27], [4026, 24, 16], [4027, 47, 28], [4028, 21, 20],
                    [4043, 17, 16], [4074, 17, 23], [4091, 31, 28], [4107, 48, 26], [4125, 15, 16], [4165, 32, 30],
                    [4173, 15, 17], [4176, 10, 12], [4209, 36, 33], [4246, 12, 21], [4285, 24, 28], [4299, 31, 22],
                    [4301, 44, 46], [4310, 25, 25], [4312, 36, 26], [4325, 41, 22], [4353, 22, 14], [4358, 12, 13],
                    [4362, 67, 40], [4380, 16, 19], [4382, 83, 29], [4386, 18, 19], [4413, 11, 11], [4414, 16, 22],
                    [4426, 15, 15], [4440, 35, 27], [4442, 16, 20], [4454, 12, 11], [4464, 42, 24], [4470, 23, 22],
                    [4477, 26, 28], [4487, 19, 24], [4491, 38, 27], [4518, 48, 31], [4536, 18, 18], [4545, 37, 29],
                    [4610, 48, 28], [4617, 115, 44], [4618, 22, 19], [4623, 17, 19], [4626, 27, 17], [4634, 24, 23],
                    [4638, 76, 29], [4644, 13, 17], [4648, 32, 23], [4660, 45, 28], [4670, 42, 28], [4676, 12, 15],
                    [4689, 36, 25], [4710, 8, 6], [4724, 24, 17], [4732, 50, 58], [4734, 13, 14], [4738, 32, 34],
                    [4745, 20, 19], [4749, 34, 27], [4762, 37, 32], [4764, 21, 26], [4789, 43, 25], [4794, 20, 17],
                    [4801, 14, 18], [4805, 12, 17], [4820, 39, 32], [4828, 59, 44], [4832, 17, 20], [4840, 44, 27],
                    [4849, 17, 17], [4863, 37, 30], [4865, 26, 18], [4871, 12, 16], [4880, 17, 19], [4888, 39, 32],
                    [4897, 13, 17], [4912, 10, 20], [4914, 22, 17], [4918, 18, 16], [4926, 47, 43], [4939, 20, 17],
                    [4944, 15, 14], [4951, 28, 28], [4973, 29, 29], [4976, 11, 12], [4978, 48, 36], [4983, 15, 12],
                    [4992, 18, 17], [5006, 72, 33], [5019, 55, 37], [5031, 10, 12], [5038, 14, 16], [5048, 29, 25],
                    [5050, 22, 18], [5051, 12, 15], [5062, 35, 21], [5063, 19, 24], [5073, 51, 33], [5081, 31, 21],
                    [5091, 70, 31], [5092, 11, 14], [5095, 14, 15], [5107, 85, 28], [5108, 18, 23], [5130, 43, 37],
                    [5149, 19, 17], [5159, 55, 31], [5184, 28, 19], [5185, 24, 15], [5186, 14, 15], [5187, 14, 16],
                    [5188, 16, 19], [5189, 15, 10], [5217, 41, 31], [5219, 17, 34], [5220, 15, 37], [5221, 11, 25],
                    [5222, 16, 20], [5223, 11, 24], [5224, 16, 34], [5225, 15, 35], [5226, 12, 37], [5227, 27, 47],
                    [5228, 18, 45], [5229, 11, 31], [5230, 15, 29], [5231, 12, 26], [5232, 18, 38], [5233, 23, 50],
                    [5234, 10, 19], [5235, 33, 31], [5236, 15, 30], [5237, 23, 39], [5238, 15, 27], [5239, 21, 44],
                    [5240, 19, 50], [5241, 24, 44], [5242, 18, 30], [5243, 23, 48], [5244, 20, 50], [5245, 24, 48],
                    [5247, 27, 13], [5248, 29, 18], [5273, 22, 15], [5276, 23, 30], [5279, 21, 20], [5287, 12, 12],
                    [5290, 20, 18], [5298, 14, 14], [5299, 20, 17], [5303, 27, 19], [5305, 20, 16], [5314, 18, 19],
                    [5315, 20, 21], [5317, 27, 32], [5321, 23, 23], [5323, 19, 19], [5328, 15, 14], [5332, 17, 20],
                    [5333, 14, 14], [5336, 15, 13], [5337, 15, 14], [5338, 24, 21], [5339, 21, 23], [5340, 21, 22],
                    [5343, 13, 11], [5344, 30, 28], [5347, 17, 18], [5349, 20, 20], [5350, 20, 21], [5353, 21, 19],
                    [5355, 15, 16], [5357, 20, 19], [5359, 16, 20], [5366, 21, 18], [5371, 25, 25], [5372, 20, 18],
                    [5375, 14, 14], [5377, 20, 19], [5383, 20, 27], [5385, 22, 20], [5387, 14, 12], [5400, 14, 13],
                    [5403, 23, 21], [5404, 18, 18], [5407, 17, 19], [5408, 20, 20], [5411, 20, 14], [5412, 20, 20],
                    [5414, 13, 13], [5415, 21, 20], [5418, 20, 23], [5420, 15, 14], [5421, 19, 15], [5422, 25, 23],
                    [5425, 16, 17], [5426, 16, 18], [5428, 19, 22], [5431, 19, 17], [5432, 21, 23], [5434, 10, 11],
                    [5436, 16, 16], [5437, 22, 19], [5440, 24, 21], [5441, 20, 23], [5444, 22, 26], [5447, 17, 17],
                    [5449, 20, 23], [5450, 20, 21], [5452, 21, 21], [5453, 22, 22], [5454, 14, 14], [5455, 18, 16],
                    [5457, 13, 19], [5459, 15, 15], [5462, 18, 20], [5463, 13, 13], [5464, 17, 18], [5465, 21, 18],
                    [5472, 21, 20], [5473, 20, 17], [5476, 15, 17], [5479, 16, 16], [5480, 23, 21], [5482, 18, 16],
                    [5486, 18, 18], [5489, 22, 30], [5492, 22, 25], [5494, 21, 21], [5495, 20, 16], [5498, 29, 27],
                    [5499, 18, 20], [5501, 23, 28], [5505, 19, 20], [5508, 21, 22], [5528, 13, 12], [5532, 21, 18],
                    [5534, 17, 14], [5539, 21, 17], [5541, 20, 18], [5544, 20, 20], [5545, 20, 20], [5547, 29, 27],
                    [5550, 17, 17], [5571, 23, 19], [5944, 7, 7], [5945, 8, 9], [5946, 6, 5], [5962, 68, 73],
                    [5989, 210, 163], [5990, 210, 163], [5991, 210, 163], [5992, 210, 171], [5993, 210, 163],
                    [5996, 38, 25], [6068, 38, 29], [6069, 43, 35], [6070, 40, 32], [6071, 28, 23], [6073, 25, 27],
                    [6074, 33, 28], [6075, 30, 35], [6076, 31, 27], [6077, 29, 26], [6078, 31, 31], [6079, 35, 28],
                    [6080, 26, 32], [6081, 20, 23], [6082, 33, 28], [6083, 31, 25], [6084, 39, 27], [6085, 35, 29],
                    [6087, 28, 25], [6088, 25, 27], [6089, 28, 25], [6090, 43, 29], [6091, 20, 24], [6092, 31, 28],
                    [6093, 38, 34], [6094, 33, 28], [6095, 20, 20], [6096, 31, 23], [6097, 34, 25], [6098, 30, 24],
                    [6099, 28, 27], [6100, 25, 28], [6101, 25, 23], [6102, 23, 22], [6103, 31, 25], [6104, 35, 24],
                    [6105, 28, 27], [6106, 26, 23], [6108, 32, 26], [6109, 19, 22], [6110, 31, 28], [6111, 15, 19],
                    [6112, 23, 27], [6113, 23, 23], [6114, 30, 23], [6115, 22, 24], [6116, 24, 25], [6117, 26, 25],
                    [6118, 40, 28], [6119, 28, 27], [6120, 20, 21], [6121, 20, 24], [6122, 28, 24], [6123, 23, 23],
                    [6124, 30, 25], [6125, 26, 31], [6126, 27, 26], [6127, 24, 28], [6128, 24, 28], [6130, 28, 26],
                    [6131, 31, 25], [6132, 33, 28], [6133, 31, 25], [6134, 31, 25], [6135, 40, 35], [6136, 54, 45],
                    [6137, 17, 19], [6138, 24, 26], [6139, 28, 26], [6140, 20, 23], [6141, 23, 27], [6142, 18, 25],
                    [6143, 26, 25], [6145, 29, 28], [6146, 15, 19], [6147, 20, 26], [6148, 20, 23], [6149, 27, 28],
                    [6150, 16, 20], [6151, 21, 20], [6152, 18, 20], [6153, 19, 22], [6154, 23, 27], [6155, 20, 22],
                    [6156, 25, 23], [6157, 30, 26], [6158, 21, 22], [6159, 29, 26], [6160, 21, 22], [6161, 18, 19],
                    [6162, 20, 20], [6163, 35, 32], [6164, 30, 27], [6165, 24, 23], [6166, 37, 27], [6167, 31, 33],
                    [6244, 47, 29], [6353, 45, 39], [6357, 34, 34], [6358, 39, 35], [6360, 103, 59], [6361, 101, 53],
                    [6371, 117, 102], [6374, 107, 122], [6375, 173, 64], [6380, 75, 42], [6382, 71, 48], [6385, 97, 86],
                    [6388, 146, 82], [6391, 61, 40], [6393, 164, 143], [6395, 83, 44], [6400, 94, 61], [6405, 136, 47],
                    [6408, 272, 87], [6411, 58, 44], [6412, 79, 88], [6413, 98, 76], [6414, 123, 57], [6416, 121, 62],
                    [6421, 57, 53], [6422, 74, 62], [6425, 71, 40], [6426, 80, 69], [6430, 48, 60], [6431, 62, 63],
                    [6432, 110, 96], [6433, 39, 35], [6436, 140, 57], [6438, 71, 59], [6441, 47, 47], [6442, 47, 32],
                    [6448, 65, 47], [6450, 146, 115], [6452, 164, 86], [6462, 103, 81], [6463, 88, 85],
                    [6467, 181, 170], [6469, 64, 81], [6471, 54, 43], [6474, 117, 67], [6476, 68, 46], [6477, 178, 91],
                    [6478, 120, 45], [6483, 87, 63], [6486, 177, 73], [6489, 95, 47], [6492, 26, 30], [6494, 29, 25],
                    [6495, 58, 45], [6496, 63, 46], [6499, 127, 98], [6502, 36, 40], [6512, 54, 46], [6514, 140, 93],
                    [6515, 125, 67], [6516, 88, 115], [6518, 79, 80], [6519, 167, 159], [6521, 52, 34],
                    [6524, 126, 109], [6527, 49, 47], [6529, 104, 107], [6530, 53, 43], [6532, 56, 45], [6534, 58, 59],
                    [6565, 125, 89], [6566, 51, 40], [6568, 59, 47], [6570, 117, 70], [6576, 49, 47], [6581, 155, 98],
                    [6584, 107, 48], [6585, 53, 49], [6587, 99, 70], [6589, 139, 55], [6590, 168, 79], [6602, 93, 44],
                    [6607, 114, 51], [6609, 74, 52], [6612, 85, 70], [6614, 29, 29], [6615, 65, 50], [6616, 73, 94],
                    [6621, 103, 46], [6623, 103, 78], [6630, 72, 84], [6631, 36, 36], [6633, 23, 26], [6634, 30, 27],
                    [6635, 35, 29], [6636, 38, 38], [6637, 28, 27], [6638, 43, 31], [6639, 28, 33], [6640, 25, 56],
                    [6643, 37, 23], [6649, 39, 26], [6650, 39, 27], [6651, 29, 21], [6652, 28, 28], [6653, 37, 31],
                    [6654, 37, 26], [6655, 28, 23], [6656, 30, 27], [6657, 24, 29], [6660, 34, 22], [6661, 28, 25],
                    [6662, 28, 28], [6663, 28, 26], [6664, 40, 29], [6665, 27, 28], [6666, 27, 25], [6667, 28, 27],
                    [6668, 28, 21], [6669, 24, 29], [6670, 29, 26], [6671, 38, 27], [6672, 31, 24], [6673, 33, 25],
                    [6674, 30, 28], [6675, 28, 25], [6676, 38, 32], [6677, 27, 28], [6678, 28, 25], [6679, 54, 45],
                    [6680, 26, 23], [6682, 26, 24], [6683, 23, 24], [6684, 26, 28], [6685, 20, 23], [6686, 20, 23],
                    [6687, 20, 25], [6688, 20, 23], [6689, 22, 24], [6690, 20, 23], [6699, 25, 73], [6700, 75, 36],
                    [6701, 61, 38], [6702, 35, 23], [6704, 74, 40], [6715, 39, 32], [6716, 30, 29], [6718, 31, 50],
                    [6722, 35, 29], [6723, 77, 45], [6726, 45, 60], [6728, 51, 32], [6734, 50, 36], [6737, 31, 85],
                    [6738, 64, 44], [6741, 14, 15], [6748, 26, 24], [6749, 26, 25], [6750, 36, 35], [6752, 18, 23],
                    [6753, 31, 29], [6754, 31, 28], [6755, 38, 35], [6756, 28, 31], [6757, 28, 27], [6758, 28, 36],
                    [6759, 20, 23], [6760, 36, 35], [6761, 31, 34], [6762, 31, 32], [6763, 21, 20], [6764, 30, 32],
                    [6766, 43, 36], [6767, 31, 27], [6768, 30, 28], [6769, 35, 40], [6770, 32, 34], [6771, 24, 33],
                    [6772, 24, 28], [6773, 38, 36], [6777, 40, 37], [6778, 23, 26], [6779, 32, 33], [6780, 34, 33],
                    [6781, 37, 33], [6782, 53, 41], [6783, 32, 37], [6784, 26, 32], [6785, 40, 31], [6786, 32, 34],
                    [6787, 30, 33], [6789, 33, 33], [6790, 35, 101], [6791, 89, 85], [6794, 21, 40], [6795, 42, 62],
                    [6798, 35, 27], [6803, 31, 76], [6804, 50, 101], [6805, 75, 132], [6806, 30, 62], [6807, 35, 45],
                    [6808, 21, 40], [6812, 166, 75], [6813, 31, 60], [6814, 126, 103], [6816, 81, 90], [6818, 17, 18],
                    [6819, 31, 38], [6820, 31, 31], [6821, 48, 39], [6822, 44, 42], [6823, 30, 33], [6833, 61, 48],
                    [6834, 151, 103], [6835, 280, 135], [6836, 40, 60], [6837, 21, 28], [6838, 135, 90], [6841, 28, 21],
                    [6845, 31, 61], [6846, 38, 56], [6847, 40, 45], [6848, 40, 21], [6849, 70, 43], [6850, 45, 49],
                    [6851, 21, 46], [6852, 85, 124], [6853, 31, 53], [6854, 151, 79], [6855, 40, 40], [6856, 30, 54],
                    [6857, 35, 73], [6858, 50, 53], [6859, 57, 47], [6860, 25, 31], [6861, 30, 49], [6862, 35, 40],
                    [6867, 14, 20], [6868, 15, 15], [6869, 15, 15], [6870, 15, 17], [6871, 16, 17], [6872, 15, 17],
                    [6873, 20, 16], [6874, 11, 16], [6875, 14, 17], [6876, 11, 15], [6877, 18, 23], [6878, 14, 16],
                    [6879, 16, 20], [6880, 19, 19], [6881, 11, 13], [6882, 15, 17], [6883, 19, 21], [6910, 54, 43],
                    [6912, 19, 11], [6914, 12, 12], [6918, 28, 23], [6920, 20, 19], [6922, 12, 11], [6928, 17, 16],
                    [6930, 20, 16], [6931, 35, 33], [6934, 16, 15], [6938, 16, 14], [6940, 12, 11], [6942, 19, 17],
                    [6944, 11, 10], [6948, 12, 11], [6950, 13, 11], [6952, 47, 22], [6954, 25, 16], [6957, 62, 49],
                    [6958, 13, 11], [6960, 15, 15], [6962, 13, 11], [6965, 9, 10], [6966, 21, 34], [6967, 16, 35],
                    [6968, 33, 55], [6969, 19, 33], [6970, 21, 33], [7007, 49, 24], [7008, 60, 28], [7011, 10, 10],
                    [7013, 21, 17], [7014, 14, 9], [7015, 8, 8], [7019, 11, 9], [7021, 12, 11], [7027, 16, 16],
                    [7029, 31, 25], [7031, 15, 19], [7033, 22, 19], [7035, 11, 12], [7039, 20, 14], [7050, 16, 14],
                    [7052, 15, 18], [7054, 16, 15], [7056, 12, 14], [7057, 51, 35], [7058, 24, 16], [7062, 15, 13],
                    [7063, 43, 29], [7066, 11, 12], [7068, 59, 25], [7070, 31, 28], [7072, 10, 11], [7074, 15, 14],
                    [7076, 23, 18], [7078, 11, 11], [7080, 36, 31], [7082, 17, 16], [7084, 48, 23], [7086, 11, 13],
                    [7088, 45, 25], [7090, 15, 11], [7091, 50, 33], [7092, 42, 31], [7093, 65, 51], [7094, 42, 30],
                    [7098, 21, 22], [7156, 17, 18], [7259, 75, 49], [7260, 99, 76], [7261, 80, 63], [7262, 69, 70],
                    [7263, 91, 74], [7264, 81, 81], [7265, 88, 72], [7266, 107, 80], [7267, 81, 65], [7268, 110, 82],
                    [7269, 106, 79], [7270, 72, 47], [7271, 60, 55], [7272, 103, 76], [7273, 78, 78], [7274, 98, 71],
                    [7275, 89, 73], [7276, 56, 46], [7277, 86, 69], [7278, 71, 73], [7279, 79, 58], [7280, 108, 80],
                    [7281, 83, 66], [7282, 69, 70], [7283, 13, 19], [7284, 11, 10], [7285, 12, 11], [7286, 15, 20],
                    [7287, 13, 23], [7288, 28, 28], [7289, 26, 21], [7290, 42, 31], [7291, 33, 28], [7292, 32, 34],
                    [7293, 24, 21], [7294, 21, 20], [7295, 13, 14], [7296, 23, 20], [7297, 25, 22], [7298, 15, 16],
                    [7299, 16, 18], [7300, 18, 24], [7301, 13, 22], [7302, 36, 40], [7303, 73, 68], [7304, 29, 31],
                    [7305, 37, 37], [7306, 29, 32], [7307, 47, 50], [7308, 38, 40], [7309, 30, 32], [7310, 78, 65],
                    [7311, 66, 63], [7312, 34, 36], [7328, 20, 25], [7329, 37, 36], [7330, 21, 16], [7337, 15, 12],
                    [7342, 13, 10], [7343, 15, 8], [7344, 11, 9], [7348, 15, 8], [7352, 12, 11], [7354, 26, 15],
                    [7356, 14, 11], [7357, 24, 15], [7358, 14, 10], [7359, 24, 15], [7360, 14, 10], [7362, 17, 12],
                    [7363, 12, 10], [7364, 13, 11], [7367, 15, 12], [7370, 11, 10], [7371, 13, 10], [7372, 13, 10],
                    [7373, 13, 10], [7374, 11, 8], [7375, 11, 8], [7376, 7, 8], [7377, 11, 8], [7378, 20, 18],
                    [7379, 30, 23], [7398, 26, 39], [7399, 28, 30], [7401, 24, 34], [7403, 20, 26], [7405, 22, 28],
                    [7406, 32, 35], [7407, 34, 45], [7410, 19, 27], [7411, 50, 46], [7413, 11, 13], [7414, 18, 25],
                    [7415, 11, 14], [7416, 25, 31], [7417, 19, 17], [7420, 27, 30], [7421, 25, 29], [7423, 54, 60],
                    [7433, 75, 55], [7434, 90, 90], [7435, 42, 75], [7436, 56, 77], [7437, 19, 18], [7438, 38, 30],
                    [7441, 23, 15], [7442, 40, 21], [7443, 75, 108], [7444, 66, 108], [7445, 35, 73], [7446, 46, 80],
                    [7447, 19, 18], [7448, 37, 30], [7449, 21, 21], [7450, 21, 20], [7451, 13, 13], [7452, 22, 19],
                    [7453, 68, 45], [7454, 20, 15], [7455, 23, 21], [7456, 50, 46], [7457, 50, 39], [7458, 35, 32],
                    [7459, 53, 45], [7460, 61, 52], [7461, 36, 32], [7462, 42, 38], [7463, 55, 40], [7464, 57, 43],
                    [7465, 48, 36], [7466, 50, 34], [7467, 52, 46], [7468, 40, 36], [7469, 65, 38], [7470, 63, 46],
                    [7471, 67, 51], [7472, 75, 52], [7473, 40, 36], [7474, 55, 45], [7475, 50, 45], [7476, 43, 37],
                    [7477, 37, 34], [7478, 45, 36], [7479, 40, 36], [7480, 53, 43], [7481, 40, 37], [7482, 50, 36],
                    [7483, 50, 45], [7484, 44, 40], [7485, 75, 55], [7486, 54, 40], [7487, 44, 37], [7488, 48, 36],
                    [7489, 85, 40], [7490, 35, 34], [7491, 45, 37], [7492, 58, 43], [7493, 46, 39], [7494, 55, 39],
                    [7495, 51, 45], [7496, 75, 56], [7497, 47, 36], [7498, 36, 37], [7499, 40, 32], [7500, 49, 43],
                    [7501, 60, 47], [7502, 50, 38], [7503, 50, 39], [7504, 50, 33], [7505, 65, 39], [7506, 57, 43],
                    [7507, 50, 37], [7508, 48, 38], [7509, 52, 45], [7510, 50, 45], [7511, 54, 40], [7512, 50, 45],
                    [7513, 48, 36], [7514, 86, 65], [7515, 55, 40], [7516, 50, 45], [7517, 74, 55], [7518, 58, 43],
                    [7519, 41, 38], [7520, 45, 40], [7521, 35, 36], [7522, 63, 46], [7523, 45, 39], [7524, 61, 55],
                    [7525, 50, 45], [7526, 49, 36], [7527, 35, 36], [7528, 63, 46], [7529, 75, 67], [7530, 55, 46],
                    [7531, 38, 38], [7532, 50, 45], [7533, 70, 49], [7534, 69, 63], [7535, 46, 42], [7536, 50, 43],
                    [7537, 67, 42], [7538, 51, 39], [7539, 60, 40], [7540, 63, 36], [7541, 55, 40], [7542, 63, 47],
                    [7543, 51, 38], [7544, 53, 40], [7545, 47, 37], [7546, 47, 36], [7547, 47, 36], [7548, 46, 40],
                    [7549, 50, 45], [7550, 39, 36], [7551, 42, 38], [7552, 59, 43], [7553, 47, 40], [7554, 67, 58],
                    [7555, 67, 51], [7556, 51, 45], [7557, 74, 52], [7558, 41, 32], [7559, 47, 36], [7560, 42, 38],
                    [7561, 73, 52], [7562, 65, 55], [7563, 63, 46], [7564, 51, 38], [7565, 52, 40], [7566, 44, 39],
                    [7567, 75, 45], [7568, 43, 40], [7569, 43, 40], [7570, 43, 39], [7571, 43, 39], [7572, 43, 39],
                    [7573, 47, 38], [7574, 44, 39], [7575, 54, 40], [7576, 57, 43], [7577, 63, 46], [7578, 50, 40],
                    [7579, 59, 43], [7580, 63, 46], [7581, 45, 39], [7582, 55, 45], [7583, 60, 45], [7584, 41, 37],
                    [7585, 45, 40], [7586, 75, 56], [7587, 46, 40], [7588, 48, 40], [7589, 75, 56], [7590, 52, 46],
                    [7591, 48, 36], [7592, 46, 46], [7593, 55, 42], [7594, 43, 39], [7595, 58, 40], [7596, 40, 36],
                    [7597, 45, 40], [7598, 62, 43], [7599, 56, 45], [7600, 50, 45], [7601, 39, 36], [7602, 54, 34],
                    [7603, 55, 47], [7604, 55, 46], [7605, 50, 45], [7606, 50, 40], [7607, 50, 46], [7608, 42, 38],
                    [7609, 45, 45], [7610, 35, 36], [7611, 40, 37], [7612, 54, 46], [7613, 55, 40], [7614, 47, 39],
                    [7615, 63, 46], [7616, 51, 38], [7617, 47, 36], [7618, 54, 40], [7619, 51, 45], [7620, 48, 40],
                    [7621, 51, 45], [7622, 59, 43], [7623, 44, 39], [7624, 68, 46], [7625, 40, 36], [7626, 55, 40],
                    [7627, 45, 39], [7628, 63, 46], [7629, 35, 38], [7630, 43, 37], [7631, 47, 43], [7632, 56, 38],
                    [7633, 45, 36], [7634, 15, 20], [7635, 14, 18], [7636, 17, 22], [7637, 27, 25], [7638, 53, 35],
                    [7639, 11, 12], [7640, 10, 10], [7641, 15, 17], [7642, 29, 30], [7643, 21, 18], [7644, 24, 29],
                    [7645, 18, 19], [7646, 23, 22], [7647, 29, 22], [7648, 11, 11], [7649, 11, 11], [7650, 17, 15],
                    [7651, 12, 12], [7652, 14, 14], [7653, 33, 27], [7654, 11, 11], [7655, 13, 13], [7656, 13, 13],
                    [7657, 22, 24], [7658, 21, 24], [7659, 14, 18], [7661, 10, 10], [7662, 17, 14], [7663, 15, 17],
                    [7664, 20, 26], [7665, 25, 29], [7666, 13, 12], [7667, 15, 14], [7668, 13, 12], [7669, 11, 8],
                    [7672, 9, 9], [7673, 8, 7], [7674, 17, 15], [7676, 6, 7], [7677, 5, 6], [7678, 10, 8],
                    [7679, 11, 9], [7680, 30, 18], [7681, 5, 3], [7682, 16, 13], [7683, 3, 3], [7684, 13, 12],
                    [7685, 12, 11], [7686, 19, 17], [7687, 5, 4], [7688, 14, 13], [7690, 7, 8], [7691, 24, 22],
                    [7692, 10, 8], [7693, 9, 9], [7694, 9, 9], [7695, 25, 19], [7696, 3, 3], [7697, 16, 12],
                    [7698, 9, 8], [7699, 12, 14], [7700, 13, 10], [7701, 9, 8], [7702, 22, 13], [7703, 12, 12],
                    [7705, 23, 13], [7706, 11, 10], [7707, 12, 10], [7708, 9, 7], [7709, 12, 13], [7710, 6, 5],
                    [7711, 14, 11], [7713, 26, 12], [7714, 10, 9], [7716, 18, 23], [7717, 39, 31], [7718, 27, 39],
                    [7719, 18, 27], [7722, 28, 36], [7723, 20, 47], [7725, 20, 19], [7726, 25, 22], [7729, 28, 30],
                    [7730, 18, 23], [7731, 31, 27], [7734, 26, 32], [7736, 16, 27], [7737, 33, 29], [7738, 18, 23],
                    [7739, 60, 39], [7740, 43, 41], [7741, 76, 49], [7743, 25, 35], [7744, 55, 46], [7749, 28, 30],
                    [7753, 35, 34], [7754, 27, 37], [7755, 20, 32], [7757, 36, 97], [7758, 65, 104], [7759, 29, 27],
                    [7760, 55, 40], [7761, 47, 57], [7762, 111, 85], [7763, 14, 18], [7764, 13, 15], [7765, 15, 19],
                    [7766, 9, 15], [7767, 24, 26], [7768, 10, 17], [7769, 28, 28], [7770, 14, 16], [7771, 33, 28],
                    [7772, 13, 15], [7773, 22, 24], [7774, 12, 18], [7775, 32, 30], [7776, 13, 23], [7778, 9, 12],
                    [7780, 17, 18], [7781, 24, 26], [7784, 15, 25], [7785, 31, 33], [7786, 14, 16], [7787, 22, 25],
                    [7790, 19, 25], [7791, 34, 36], [7792, 16, 23], [7793, 31, 30], [7795, 120, 101], [7796, 105, 43],
                    [7797, 120, 73], [7798, 120, 38], [7799, 82, 53], [7800, 88, 34], [7801, 120, 66], [7802, 25, 31],
                    [7803, 187, 90], [7804, 120, 48], [7805, 88, 50], [7806, 120, 76], [7807, 92, 72], [7808, 120, 33],
                    [7809, 103, 70], [7810, 100, 86], [7811, 211, 108], [7812, 56, 39], [7813, 75, 37], [7815, 69, 40],
                    [7816, 120, 85], [7817, 38, 47], [7818, 62, 57], [7819, 54, 73], [7820, 72, 48], [7821, 148, 69],
                    [7822, 70, 51], [7823, 50, 22], [7824, 186, 92], [7825, 120, 41], [7826, 70, 50], [7827, 120, 37],
                    [7828, 120, 119], [7829, 80, 50], [7830, 120, 61], [7831, 80, 41], [7832, 128, 80], [7833, 60, 38],
                    [7834, 128, 70], [7835, 72, 36], [7836, 120, 75], [7837, 46, 36], [7838, 120, 30], [7839, 104, 80],
                    [7840, 154, 90], [7841, 80, 39], [7842, 37, 30], [7843, 47, 23], [7844, 120, 47], [7845, 48, 45],
                    [7846, 120, 56], [7847, 94, 36], [7848, 120, 58], [7849, 223, 90], [7850, 73, 97], [7851, 120, 74],
                    [7852, 66, 45], [7853, 40, 52], [7854, 31, 38], [7855, 60, 38], [7856, 151, 89], [7857, 89, 38],
                    [7858, 32, 39], [7859, 112, 65], [7860, 107, 69], [7861, 51, 36], [7862, 190, 62], [7863, 236, 87],
                    [7864, 36, 31], [7865, 47, 42], [7866, 120, 63], [7867, 52, 38], [7868, 50, 45], [7869, 120, 62],
                    [7870, 54, 38], [7871, 61, 40], [7872, 120, 90], [7873, 120, 73], [7874, 46, 38], [7875, 145, 73],
                    [7876, 120, 90], [7877, 120, 65], [7878, 170, 51], [7879, 126, 87], [7880, 80, 49], [7881, 55, 59],
                    [7882, 40, 34], [7883, 70, 58], [7884, 50, 57], [7885, 64, 47], [7886, 57, 39], [7887, 73, 42],
                    [7888, 119, 47], [7889, 188, 90], [7890, 58, 83], [7891, 63, 39], [7892, 42, 38], [7893, 35, 34],
                    [7894, 117, 79], [7895, 72, 41], [7896, 167, 78], [7897, 120, 56], [7898, 25, 33], [7899, 60, 86],
                    [7900, 129, 80], [7901, 120, 55], [7902, 120, 68], [7903, 107, 56], [7904, 89, 69], [7905, 63, 59],
                    [7906, 106, 75], [7907, 121, 57], [7908, 146, 55], [7909, 79, 47], [7910, 114, 53], [7911, 82, 56],
                    [7912, 121, 97], [7913, 120, 52], [7914, 90, 61], [7915, 103, 78], [7916, 120, 52], [7917, 80, 46],
                    [7918, 65, 38], [7919, 39, 36], [7920, 81, 47], [7921, 53, 15], [7922, 32, 40], [7923, 110, 38],
                    [7924, 50, 43], [7925, 59, 38], [7926, 285, 47], [7927, 38, 49], [7928, 23, 50], [7929, 120, 53],
                    [7930, 96, 49], [7931, 56, 36], [7932, 46, 36], [7933, 95, 60], [7934, 70, 69], [7935, 120, 61],
                    [7936, 112, 54], [7937, 68, 48], [7938, 20, 16], [7939, 120, 86], [7940, 120, 71], [7941, 120, 85],
                    [7942, 120, 71], [7943, 55, 36], [7944, 30, 42], [7945, 110, 40], [7946, 46, 78], [7947, 78, 55],
                    [7948, 39, 37], [7949, 66, 90], [7950, 55, 52], [7951, 120, 64], [7952, 58, 62], [7953, 42, 18],
                    [7954, 96, 30], [7955, 160, 54], [7956, 97, 40], [7957, 103, 47], [7958, 120, 48], [7959, 120, 37],
                    [7960, 53, 45], [7961, 120, 90], [7962, 190, 90], [7963, 22, 26], [7964, 65, 90], [7965, 120, 38],
                    [7966, 137, 97], [7967, 67, 36], [7968, 120, 85], [7969, 95, 72], [7970, 120, 72], [7971, 27, 39],
                    [7972, 40, 44], [7974, 70, 35], [7975, 178, 90], [7976, 179, 58], [7977, 49, 57], [7978, 120, 69],
                    [7979, 109, 65], [7980, 120, 52], [7981, 82, 30], [7982, 74, 42], [7983, 94, 36], [7984, 120, 90],
                    [7985, 56, 54], [7986, 85, 38], [7987, 73, 47], [7988, 33, 44], [7989, 120, 37], [7990, 86, 38],
                    [7992, 103, 53], [7993, 111, 70], [7994, 56, 43], [7995, 202, 90], [7996, 114, 54], [7997, 137, 90],
                    [7998, 57, 24], [7999, 136, 84], [8000, 103, 36], [8001, 127, 84], [8002, 96, 72], [8003, 30, 35],
                    [8004, 100, 70], [8005, 20, 19], [8006, 13, 15], [8007, 24, 25], [8008, 22, 23], [8009, 14, 14],
                    [8010, 13, 14], [8011, 19, 19], [8012, 12, 12], [8013, 7, 6], [8014, 9, 9], [8015, 10, 8],
                    [8016, 6, 5], [8017, 11, 11], [8018, 7, 6], [8019, 13, 13], [8020, 11, 11], [8021, 6, 5],
                    [8022, 20, 22], [8023, 15, 15], [8024, 20, 17], [8025, 16, 19], [8026, 17, 18], [8027, 14, 11],
                    [8028, 13, 12], [8029, 19, 17], [8030, 20, 16], [8031, 12, 11], [8032, 18, 22], [8033, 17, 17],
                    [8034, 20, 23], [8035, 18, 23], [8036, 16, 17], [8037, 20, 21], [8038, 30, 42], [8039, 26, 42],
                    [8040, 19, 42], [8041, 7, 12], [8042, 7, 9], [8043, 10, 13], [8044, 10, 15], [8045, 5, 3],
                    [8046, 5, 3], [8047, 5, 5], [8048, 14, 19], [8049, 11, 15], [8050, 9, 10], [8051, 18, 19],
                    [8052, 30, 41], [8053, 20, 33], [8054, 16, 28], [8055, 28, 40], [8056, 39, 43], [8057, 19, 27],
                    [8058, 16, 23], [8059, 22, 24], [8060, 24, 26], [8061, 47, 51], [8062, 50, 63], [8063, 10, 11],
                    [8064, 12, 17], [8065, 13, 13], [8068, 7, 10], [8069, 7, 11], [8071, 47, 19], [8073, 20, 14],
                    [8074, 11, 10], [8075, 20, 13], [8076, 48, 25], [8086, 14, 31], [8087, 15, 25], [8088, 17, 28],
                    [8089, 20, 34], [8090, 19, 26], [8091, 21, 43], [8092, 18, 34], [8093, 20, 42], [8094, 14, 42],
                    [8095, 19, 23], [8096, 20, 29], [8097, 19, 25], [8098, 11, 26], [8099, 22, 26], [8102, 18, 18],
                    [8103, 26, 34], [8107, 16, 20], [8109, 20, 26], [8110, 18, 22], [8116, 45, 60], [8117, 46, 62],
                    [8118, 23, 31], [8119, 15, 31], [8120, 28, 27], [8121, 23, 24], [8124, 24, 34], [8126, 22, 22],
                    [8127, 27, 31], [8131, 30, 38], [8133, 18, 22], [8134, 32, 35], [8136, 18, 22], [8137, 26, 32],
                    [8138, 29, 29], [8140, 38, 55], [8141, 35, 46], [8145, 22, 33], [8149, 17, 23], [8151, 18, 24],
                    [8153, 30, 32], [8154, 22, 28], [8155, 54, 44], [8159, 28, 30], [8160, 24, 29], [8164, 20, 26],
                    [8167, 40, 44], [8168, 39, 58], [8170, 20, 35], [8171, 27, 26], [8175, 16, 24], [8177, 27, 29],
                    [8178, 23, 25], [8184, 27, 24], [8185, 22, 22], [8187, 30, 35], [8188, 18, 20], [8194, 34, 34],
                    [8195, 20, 25], [8196, 15, 20], [8198, 33, 39], [8200, 20, 30], [8202, 38, 68], [8205, 34, 32],
                    [8208, 20, 30], [8210, 17, 28], [8217, 21, 35], [8218, 13, 18], [8219, 41, 34], [8220, 29, 25],
                    [8221, 52, 32], [8222, 25, 18], [8223, 20, 31], [8224, 49, 41], [8225, 13, 20], [8227, 25, 29],
                    [8228, 25, 55], [8231, 18, 22], [8232, 70, 48], [8234, 18, 25], [8236, 20, 20], [8238, 46, 38],
                    [8241, 14, 20], [8248, 15, 19], [8250, 23, 22], [8251, 22, 27], [8254, 32, 34], [8255, 60, 46],
                    [8256, 20, 27], [8259, 21, 27], [8260, 23, 27], [8262, 28, 32], [8264, 30, 39], [8265, 50, 45],
                    [8268, 18, 31], [8270, 16, 28], [8271, 28, 36], [8276, 27, 25], [8277, 20, 21], [8287, 20, 26],
                    [8288, 18, 20], [8294, 42, 60], [8298, 29, 41], [8299, 27, 21], [8300, 35, 30], [8302, 20, 19],
                    [8309, 12, 18], [8310, 25, 28], [8311, 12, 13], [8312, 12, 13], [8313, 11, 12], [8314, 12, 12],
                    [8315, 17, 15], [8316, 11, 11], [8317, 30, 23], [8319, 21, 17], [8322, 29, 25], [8323, 23, 20],
                    [8324, 40, 31], [8336, 19, 16], [8337, 12, 14], [8338, 12, 12], [8339, 30, 31], [8340, 15, 17],
                    [8341, 22, 23], [8342, 15, 15], [8343, 15, 14], [8344, 15, 14], [8345, 21, 21], [8346, 18, 20],
                    [8347, 15, 17], [8348, 20, 20], [8349, 21, 18], [8350, 18, 21], [8351, 14, 11], [8352, 20, 24],
                    [8353, 11, 12], [8354, 23, 25], [8355, 14, 14], [8356, 24, 23], [8357, 19, 14], [8358, 21, 18],
                    [8359, 29, 32], [8360, 26, 26], [8361, 13, 12], [8362, 20, 21], [8363, 27, 28], [8364, 23, 21],
                    [8365, 21, 20], [8366, 20, 20], [8367, 18, 16], [8368, 17, 22], [8369, 18, 20], [8370, 20, 17],
                    [8371, 18, 16], [8372, 19, 17], [8373, 22, 24], [8374, 18, 21], [8375, 16, 19], [8376, 23, 23],
                    [8377, 20, 17], [8378, 21, 17], [8379, 22, 21], [8380, 25, 21], [8381, 20, 20], [8382, 16, 18],
                    [8383, 21, 23], [8384, 20, 25], [8385, 18, 21], [8386, 15, 15], [8387, 21, 20], [8388, 21, 18],
                    [8389, 16, 17], [8390, 13, 13], [8391, 20, 18], [8392, 20, 19], [8393, 25, 30], [8394, 21, 20],
                    [8395, 17, 18], [8396, 46, 38], [8397, 55, 41], [8398, 38, 29], [8399, 48, 31], [8400, 43, 40],
                    [8401, 48, 31], [8402, 41, 31], [8403, 45, 30], [8404, 39, 34], [8405, 45, 30], [8406, 47, 32],
                    [8407, 70, 41], [8408, 60, 37], [8409, 34, 28], [8410, 65, 32], [8411, 60, 48], [8412, 42, 39],
                    [8413, 50, 37], [8414, 49, 31], [8415, 53, 41], [8416, 30, 29], [8417, 56, 34], [8418, 21, 27],
                    [8419, 63, 37], [8420, 63, 34], [8421, 53, 40], [8422, 38, 33], [8423, 57, 40], [8424, 70, 48],
                    [8425, 39, 44], [8426, 50, 30], [8427, 62, 32], [8428, 41, 33], [8429, 46, 35], [8430, 46, 35],
                    [8431, 64, 39], [8432, 61, 44], [8433, 48, 43], [8434, 51, 34], [8435, 60, 36], [8436, 54, 41],
                    [8438, 35, 30], [8439, 33, 34], [8440, 62, 38], [8441, 53, 36], [8442, 40, 37], [8443, 46, 40],
                    [8444, 49, 44], [8445, 45, 24], [8446, 46, 29], [8447, 46, 37], [8448, 38, 33], [8449, 48, 27],
                    [8450, 49, 36], [8451, 21, 27], [8452, 21, 32], [8453, 20, 24], [8454, 21, 25], [8455, 21, 27],
                    [8456, 21, 27], [8457, 49, 44], [8458, 38, 30], [8459, 46, 33], [8460, 39, 35], [8461, 48, 32],
                    [8462, 52, 36], [8463, 49, 41], [8464, 52, 40], [8465, 33, 35], [8466, 39, 37], [8467, 48, 31],
                    [8468, 57, 36], [8469, 64, 32], [8470, 48, 38], [8471, 35, 37], [8472, 53, 29], [8473, 46, 36],
                    [8474, 38, 35], [8475, 48, 37], [8476, 49, 38], [8477, 47, 37], [8478, 24, 29], [8479, 48, 34],
                    [8480, 53, 42], [8481, 46, 37], [8482, 39, 33], [8483, 46, 33], [8484, 47, 35], [8485, 47, 39],
                    [8486, 32, 27], [8487, 46, 33], [8488, 35, 30], [8489, 40, 45], [8490, 47, 37], [8491, 46, 37],
                    [8492, 55, 31], [8493, 47, 32], [8494, 32, 27], [8495, 49, 48], [8496, 26, 31], [8497, 46, 43],
                    [8498, 32, 33], [8499, 40, 32], [8500, 50, 36], [8501, 48, 51], [8502, 53, 35], [8503, 58, 38],
                    [8504, 39, 37], [8505, 49, 39], [8506, 54, 41], [8507, 48, 38], [8508, 45, 32], [8509, 38, 33],
                    [8510, 49, 37], [8511, 54, 34], [8512, 46, 43], [8513, 44, 40], [8514, 46, 44], [8515, 41, 38],
                    [8516, 58, 51], [8517, 46, 23], [8518, 57, 49], [8519, 38, 32], [8520, 41, 32], [8521, 37, 32],
                    [8522, 39, 35], [8523, 51, 33], [8524, 36, 31], [8525, 48, 33], [8526, 46, 37], [8527, 46, 44],
                    [8528, 47, 39], [8529, 54, 40], [8530, 35, 31], [8531, 53, 47], [8532, 59, 43], [8533, 54, 47],
                    [8534, 51, 39], [8535, 51, 49], [8536, 18, 29], [8537, 35, 26], [8538, 37, 25], [8539, 35, 29],
                    [8540, 27, 34], [8541, 35, 42], [8542, 28, 36], [8543, 18, 35], [8544, 26, 47], [8546, 25, 37],
                    [8547, 30, 47], [8548, 15, 18], [8549, 15, 27], [8550, 20, 25], [8551, 30, 27], [8552, 28, 33],
                    [8553, 28, 40], [8554, 35, 28], [8555, 31, 30], [8556, 28, 40], [8557, 35, 40], [8558, 26, 28],
                    [8559, 25, 29], [8560, 40, 31], [8561, 25, 27], [8562, 64, 38], [8563, 36, 38], [8564, 140, 98],
                    [8565, 10, 11], [8566, 22, 14], [8567, 20, 18], [8568, 14, 15], [8569, 19, 15], [8570, 10, 10],
                    [8571, 14, 11], [8572, 12, 12], [8573, 13, 11], [8574, 15, 13], [8575, 10, 10], [8576, 26, 19],
                    [8577, 14, 16], [8578, 22, 20], [8579, 14, 18], [8580, 18, 17], [8581, 13, 12], [8582, 16, 15],
                    [8583, 20, 18], [8584, 14, 14], [8719, 24, 23], [8720, 25, 24], [8721, 26, 25], [8722, 24, 23],
                    [8723, 26, 24], [8724, 24, 24], [8725, 26, 21], [8726, 25, 23], [8727, 22, 22], [8728, 19, 21],
                    [8729, 23, 21], [8730, 20, 20], [8731, 21, 20], [8732, 25, 22], [8733, 26, 22], [8734, 26, 22],
                    [8735, 21, 21], [8736, 21, 21], [8737, 20, 20], [8738, 21, 20], [8739, 21, 21], [8740, 21, 20],
                    [8741, 24, 21], [8742, 23, 21], [8743, 22, 22], [8744, 23, 22], [8745, 24, 22], [8746, 27, 23],
                    [8747, 27, 23], [8748, 27, 23], [8749, 23, 22], [8750, 22, 22], [8751, 22, 23], [8752, 21, 21],
                    [8753, 19, 20], [8754, 21, 21], [8755, 20, 21], [8756, 27, 22], [8757, 19, 20], [8758, 21, 21],
                    [8759, 22, 21], [8760, 29, 30], [8761, 22, 21], [8762, 27, 22], [8763, 18, 18], [8764, 29, 22],
                    [8765, 24, 20], [8766, 26, 22], [8767, 27, 23], [8768, 27, 23], [8769, 27, 23], [8770, 27, 23],
                    [8771, 27, 24], [8772, 28, 23], [8773, 21, 20], [8774, 21, 20], [8775, 21, 21], [8776, 21, 20],
                    [8777, 22, 22], [8778, 29, 23], [8779, 10, 10], [8780, 12, 9], [8781, 15, 13], [8782, 13, 10],
                    [8783, 10, 8], [8784, 12, 9], [8785, 7, 7], [8786, 9, 10], [8787, 11, 10], [8788, 12, 10],
                    [8790, 10, 8], [8791, 6, 6], [8792, 11, 10], [8793, 8, 8], [8794, 8, 7], [8795, 9, 7],
                    [8796, 13, 9], [8797, 15, 9], [8798, 9, 8], [8799, 14, 13], [8800, 10, 8], [8801, 10, 9],
                    [8802, 8, 7], [8803, 8, 8], [8804, 7, 8], [8805, 9, 8], [8806, 9, 10], [8807, 11, 11], [8808, 9, 8],
                    [8809, 6, 8], [8810, 10, 10], [8811, 7, 9], [8812, 11, 9], [8814, 6, 7], [8815, 9, 9],
                    [8816, 11, 7], [8817, 14, 10], [8818, 39, 32], [8819, 35, 31], [8820, 43, 35], [8821, 39, 27],
                    [8822, 42, 34], [8823, 31, 25], [8824, 22, 18], [8825, 34, 27], [8826, 22, 21], [8827, 37, 27],
                    [8828, 37, 27], [8829, 39, 31], [8830, 27, 28], [8831, 33, 25], [8832, 19, 11], [8833, 30, 24],
                    [8834, 34, 30], [8835, 27, 19], [8836, 41, 33], [8837, 30, 21], [8838, 38, 30], [8839, 24, 13],
                    [8840, 34, 24], [8841, 23, 13], [8842, 15, 18], [8843, 19, 12], [8844, 27, 22], [8845, 14, 16],
                    [8846, 32, 26], [8847, 18, 19], [8848, 40, 32], [8849, 27, 21], [8850, 34, 29], [8851, 22, 22],
                    [8852, 32, 25], [8853, 14, 17], [8854, 32, 27], [8855, 20, 14], [8856, 30, 25], [8857, 22, 13],
                    [8858, 27, 14], [8859, 39, 33], [8860, 27, 12], [8861, 32, 27], [8862, 24, 21], [8863, 34, 29],
                    [8864, 21, 21], [8865, 31, 25], [8866, 22, 21], [8867, 41, 34], [8868, 37, 31], [8869, 42, 34],
                    [8870, 41, 33], [8871, 32, 27], [8872, 35, 29], [8873, 26, 22], [8874, 30, 25], [8875, 32, 27],
                    [8876, 18, 18], [8877, 39, 29], [8878, 24, 21], [8879, 18, 11], [8880, 30, 25], [8881, 42, 34],
                    [8882, 27, 23], [8883, 42, 33], [8884, 17, 15], [8885, 44, 33], [8886, 33, 25], [8887, 19, 11],
                    [8888, 37, 31], [8889, 41, 33], [8890, 13, 16], [8891, 32, 28], [8892, 14, 11], [8893, 32, 28],
                    [8894, 19, 18], [8895, 15, 11], [8896, 24, 20], [8897, 15, 10], [8898, 19, 18], [8899, 41, 34],
                    [8900, 32, 27], [8901, 37, 29], [8902, 29, 24], [8903, 25, 21], [8904, 33, 27], [8905, 23, 19],
                    [8906, 30, 24], [8907, 19, 19], [8908, 28, 24], [8909, 21, 18], [8910, 21, 12], [8911, 22, 13],
                    [8912, 39, 33], [8913, 26, 23], [8914, 39, 29], [8915, 27, 22], [8916, 40, 32], [8917, 32, 22],
                    [8918, 41, 33], [8919, 30, 26], [8920, 32, 27], [8921, 33, 29], [8922, 30, 24], [8923, 24, 20],
                    [8924, 14, 13], [8925, 11, 10], [8926, 14, 12], [8927, 15, 15], [8928, 13, 12], [8929, 10, 10],
                    [8930, 9, 10], [8931, 13, 14], [8932, 16, 18], [8933, 23, 22], [8934, 26, 23], [8935, 35, 30],
                    [8936, 25, 18], [8937, 32, 27], [8938, 24, 18], [8939, 31, 24], [8940, 18, 16], [8941, 30, 24],
                    [8942, 18, 16], [8943, 26, 19], [8944, 31, 25], [8945, 22, 19], [8946, 31, 25], [8947, 22, 18],
                    [8948, 30, 25], [8949, 25, 20], [8950, 22, 19], [8951, 28, 25], [8952, 23, 19], [8953, 32, 26],
                    [8954, 24, 17], [8955, 39, 32], [8956, 26, 23], [8957, 26, 18], [8958, 42, 34], [8959, 27, 19],
                    [8960, 41, 33], [8961, 27, 19], [8962, 35, 32], [8963, 30, 26], [8964, 19, 12], [8965, 38, 31],
                    [8966, 36, 28], [8967, 39, 30], [8968, 30, 25], [8969, 18, 13], [8970, 39, 32], [8971, 30, 26],
                    [8972, 17, 13], [8973, 37, 29], [8974, 13, 17], [8975, 41, 33], [8976, 42, 34], [8977, 26, 21],
                    [8978, 14, 11], [8979, 37, 31], [8980, 30, 25], [8981, 29, 23], [8983, 34, 28], [8984, 27, 20],
                    [8985, 33, 27], [8986, 25, 20], [8987, 27, 25], [8988, 18, 26], [8989, 34, 28], [8990, 23, 20],
                    [8991, 32, 27], [8992, 18, 18], [8993, 33, 29], [8994, 38, 31], [8995, 35, 27], [8996, 41, 31],
                    [8997, 22, 21], [8998, 27, 20], [8999, 19, 11], [9000, 42, 34], [9001, 38, 28], [9002, 37, 29],
                    [9003, 23, 21], [9004, 41, 31], [9005, 20, 18], [9006, 34, 27], [9007, 27, 19], [9008, 36, 24],
                    [9009, 32, 24], [9010, 25, 20], [9011, 19, 11], [9012, 27, 25], [9013, 20, 22], [9014, 36, 28],
                    [9015, 19, 14], [9016, 19, 14], [9017, 39, 30], [9018, 26, 26], [9019, 30, 27], [9020, 18, 18],
                    [9021, 34, 29], [9022, 27, 22], [9023, 31, 25], [9024, 36, 29], [9025, 30, 25], [9026, 31, 18],
                    [9027, 27, 17], [9028, 37, 29], [9030, 38, 29], [9031, 32, 26], [9032, 41, 28], [9033, 30, 26],
                    [9034, 42, 31], [9035, 37, 31], [9036, 36, 29], [9037, 16, 14], [9038, 27, 24], [9039, 15, 18],
                    [9040, 34, 28], [9041, 23, 19], [9042, 37, 29], [9043, 33, 28], [9044, 22, 14], [9045, 33, 25],
                    [9046, 26, 20], [9047, 33, 27], [9048, 29, 21], [9049, 45, 33], [9050, 27, 20], [9051, 39, 29],
                    [9052, 41, 26], [9053, 31, 31], [9054, 35, 27], [9055, 41, 21], [9056, 42, 25], [9057, 39, 29],
                    [9058, 25, 18], [9059, 42, 31], [9060, 39, 28], [9061, 49, 39], [9062, 21, 21], [9063, 33, 24],
                    [9064, 16, 18], [9065, 22, 21], [9066, 16, 17], [9067, 29, 22], [9068, 26, 18], [9069, 33, 32],
                    [9070, 17, 17], [9071, 25, 29], [9072, 13, 16], [9073, 14, 16], [9074, 29, 27], [9075, 20, 21],
                    [9076, 23, 25], [9077, 34, 22], [9078, 26, 16], [9079, 34, 29], [9080, 21, 18], [9081, 27, 22],
                    [9082, 41, 30], [9083, 30, 24], [9084, 37, 27], [9085, 19, 19], [9086, 36, 28], [9087, 39, 27],
                    [9088, 27, 17], [9089, 17, 14], [9090, 22, 18], [9091, 22, 15], [9092, 39, 25], [9093, 20, 19],
                    [9094, 41, 34], [9095, 14, 12], [9096, 26, 30], [9097, 28, 21], [9098, 36, 23], [9099, 19, 13],
                    [9100, 33, 22], [9101, 15, 17], [9102, 36, 28], [9103, 24, 22], [9104, 36, 28], [9105, 21, 14],
                    [9106, 28, 15], [9107, 33, 25], [9108, 34, 25], [9109, 32, 26], [9110, 35, 28], [9111, 25, 13],
                    [9112, 41, 33], [9113, 32, 27], [9114, 41, 25], [9115, 14, 14], [9116, 22, 15], [9117, 28, 12],
                    [9118, 33, 27], [9119, 17, 12], [9120, 24, 20], [9121, 30, 25], [9122, 37, 29], [9123, 26, 18],
                    [9124, 38, 30], [9125, 16, 23], [9126, 38, 32], [9127, 28, 25], [9128, 34, 27], [9129, 34, 29],
                    [9130, 43, 32], [9131, 25, 25], [9132, 32, 30], [9133, 26, 18], [9134, 30, 26], [9135, 42, 29],
                    [9136, 33, 28], [9137, 16, 11], [9138, 18, 15], [9139, 27, 24], [9140, 32, 30], [9141, 25, 23],
                    [9142, 38, 34], [9143, 20, 20], [9144, 23, 26], [9145, 32, 26], [9146, 40, 31], [9149, 20, 16],
                    [9150, 20, 20], [9151, 20, 20], [9152, 21, 21], [9153, 12, 13], [9154, 14, 14], [9155, 20, 20],
                    [9156, 22, 22], [9157, 21, 22], [9158, 13, 13], [9159, 20, 22], [9160, 16, 14], [9161, 17, 17],
                    [9162, 21, 22], [9163, 20, 20], [9164, 20, 17], [9165, 19, 21], [9166, 17, 17], [9167, 15, 15],
                    [9168, 22, 21], [9169, 22, 21], [9170, 22, 25], [9171, 21, 20], [9172, 20, 18], [9173, 18, 20],
                    [9174, 16, 17], [9175, 17, 16], [9176, 11, 14], [9177, 19, 17], [9178, 16, 19], [9179, 20, 22],
                    [9180, 15, 15], [9181, 21, 20], [9182, 20, 20], [9183, 20, 21], [9184, 22, 21], [9185, 20, 19],
                    [9186, 13, 14], [9187, 21, 20], [9188, 21, 20], [9189, 21, 21], [9190, 14, 14], [9191, 19, 18],
                    [9192, 17, 18], [9193, 21, 22], [9194, 26, 28], [9195, 28, 30], [9196, 29, 22], [9198, 26, 22],
                    [9199, 25, 22], [9200, 25, 22], [9201, 32, 27], [9202, 32, 29], [9203, 10, 12], [9204, 9, 10],
                    [9209, 24, 22], [9211, 32, 31], [9214, 37, 32], [9218, 22, 20], [9226, 37, 26], [9227, 40, 33],
                    [9228, 35, 37], [9229, 33, 33], [9230, 32, 27], [9232, 33, 29], [9233, 29, 30], [9234, 29, 30],
                    [9235, 29, 30], [9237, 28, 19], [9238, 32, 30], [9242, 33, 30], [9244, 37, 32], [9245, 24, 24],
                    [9248, 32, 26], [9254, 70, 70], [9255, 43, 31], [9257, 53, 46], [9258, 33, 70], [9259, 43, 44],
                    [9260, 38, 33], [9261, 55, 64], [9263, 40, 40], [9264, 34, 36], [9265, 37, 39], [9266, 61, 64],
                    [9267, 56, 52], [9268, 52, 50], [9269, 72, 69], [9270, 66, 68], [9271, 68, 69], [9272, 68, 74],
                    [9273, 71, 75], [9274, 76, 67], [9275, 44, 43], [9276, 70, 67], [9277, 63, 51], [9278, 69, 68],
                    [9279, 69, 63], [9280, 46, 45], [9281, 73, 59], [9282, 70, 67], [9283, 64, 62], [9284, 92, 90],
                    [9285, 56, 58], [9286, 85, 88], [9287, 89, 85], [9288, 52, 38], [9289, 78, 81], [9290, 59, 66],
                    [9291, 82, 79], [9292, 70, 70], [9293, 59, 42], [9294, 48, 86], [9295, 62, 70], [9296, 65, 80],
                    [9297, 100, 95], [9298, 60, 65], [9299, 81, 86], [9300, 81, 80], [9301, 62, 66], [9302, 95, 90],
                    [9303, 71, 78], [9304, 75, 130], [9305, 74, 82], [9306, 97, 90], [9307, 40, 51], [9308, 51, 63],
                    [9309, 46, 104], [9310, 57, 100], [9311, 50, 54], [9312, 57, 60], [9313, 53, 59], [9314, 71, 77],
                    [9315, 31, 31], [9316, 37, 25], [9317, 12, 14], [9318, 13, 15], [9319, 28, 32], [9320, 38, 36],
                    [9327, 12, 14], [9328, 19, 20], [9329, 27, 28], [9330, 34, 34], [9331, 22, 22], [9332, 22, 25],
                    [9333, 11, 14], [9334, 11, 12], [9335, 22, 22], [9336, 20, 20], [9337, 13, 16], [9338, 10, 12],
                    [9339, 15, 17], [9340, 35, 32], [9341, 17, 20], [9342, 24, 24], [9343, 8, 9], [9344, 15, 15],
                    [9345, 16, 20], [9346, 12, 13], [9347, 10, 11], [9348, 21, 20], [9349, 16, 19], [9350, 33, 34],
                    [9351, 28, 23], [9352, 32, 30], [9353, 15, 18], [9354, 23, 24], [9355, 17, 15], [9356, 27, 25],
                    [9357, 15, 18], [9358, 20, 21], [9359, 16, 20], [9360, 22, 26], [9361, 20, 18], [9362, 27, 26],
                    [9363, 20, 20], [9364, 30, 22], [9365, 16, 19], [9366, 41, 38], [9367, 19, 21], [9368, 47, 43],
                    [9369, 26, 27], [9370, 15, 16], [9371, 22, 23], [9372, 41, 30], [9373, 18, 18], [9374, 29, 28],
                    [9375, 17, 19], [9376, 41, 37], [9377, 12, 12], [9378, 17, 19], [9379, 23, 28], [9380, 20, 23],
                    [9381, 45, 39], [9382, 21, 26], [9383, 41, 30], [9384, 15, 15], [9385, 15, 16], [9386, 14, 14],
                    [9387, 13, 13], [9388, 13, 14], [9389, 15, 14], [9390, 16, 18], [9391, 21, 21], [9392, 17, 17],
                    [9393, 21, 19], [9394, 12, 12], [9395, 17, 18], [9396, 17, 20], [9397, 34, 32], [9398, 29, 35],
                    [9399, 39, 37], [9400, 20, 21], [9401, 66, 64], [9402, 34, 25], [9403, 92, 69], [9406, 85, 73],
                    [9411, 90, 67], [9416, 50, 60], [9417, 92, 70], [9420, 91, 68], [9423, 73, 65], [9428, 90, 69],
                    [9431, 91, 68], [9436, 78, 69], [9443, 91, 69], [9444, 90, 67], [9451, 85, 70], [9452, 91, 71],
                    [9453, 82, 63], [9456, 78, 69], [9457, 76, 71], [9458, 91, 69], [9465, 45, 36], [9470, 90, 68],
                    [9473, 41, 43], [9474, 85, 76], [9477, 32, 35], [9478, 45, 42], [9487, 24, 29], [9488, 41, 42],
                    [9491, 37, 38], [9492, 47, 41], [9497, 39, 26], [9498, 84, 43], [9509, 73, 73], [9519, 21, 25],
                    [9520, 73, 53], [9525, 21, 20], [9526, 42, 37], [9529, 32, 28], [9530, 46, 39], [9531, 37, 34],
                    [9532, 69, 70], [9539, 43, 34], [9540, 66, 70], [9541, 34, 33], [9542, 46, 39], [9543, 32, 34],
                    [9544, 44, 38], [9547, 32, 35], [9548, 45, 39], [9549, 29, 29], [9550, 46, 36], [9551, 32, 34],
                    [9552, 69, 70], [9553, 37, 32], [9554, 45, 39], [9555, 44, 45], [9556, 70, 76], [9557, 39, 34],
                    [9558, 74, 70], [9561, 38, 40], [9562, 61, 74], [9581, 41, 39], [9582, 45, 42], [9593, 32, 34],
                    [9594, 52, 71], [9595, 34, 34], [9596, 45, 43], [9597, 25, 23], [9598, 54, 50], [9609, 31, 31],
                    [9610, 43, 38], [9611, 40, 33], [9612, 45, 38], [9613, 46, 45], [9614, 72, 76], [9617, 17, 15],
                    [9618, 44, 38], [9619, 21, 20], [9620, 21, 20], [9633, 41, 39], [9634, 72, 69], [9639, 17, 20],
                    [9640, 64, 53], [9641, 42, 30], [9642, 85, 65], [9643, 26, 30], [9644, 45, 42], [9651, 85, 56],
                    [9652, 85, 56], [9653, 47, 42], [9654, 50, 32], [9661, 72, 42], [9662, 90, 40], [9663, 66, 42],
                    [9664, 66, 42], [9665, 38, 33], [9666, 44, 33], [9667, 21, 18], [9668, 32, 28], [9670, 75, 44],
                    [9673, 34, 23], [9674, 44, 24], [9675, 26, 28], [9676, 45, 36], [9677, 20, 21], [9678, 35, 25],
                    [9681, 40, 32], [9682, 52, 33], [9687, 17, 23], [9689, 22, 21], [9690, 38, 30], [9691, 45, 28],
                    [9692, 38, 31], [9693, 33, 29], [9694, 40, 32], [9695, 33, 32], [9696, 40, 31], [9699, 23, 26],
                    [9700, 71, 40], [9701, 25, 22], [9702, 70, 35], [9704, 65, 34], [9705, 33, 38], [9706, 68, 44],
                    [9709, 21, 17], [9710, 24, 18], [9711, 25, 30], [9712, 25, 29], [9713, 31, 31], [9714, 35, 46],
                    [9715, 58, 44], [9716, 25, 24], [9717, 35, 31], [9718, 28, 26], [9720, 45, 36], [9721, 58, 35],
                    [9722, 37, 40], [9723, 51, 37], [9724, 57, 49], [9725, 64, 44], [9726, 24, 26], [9727, 45, 30],
                    [9728, 25, 24], [9729, 21, 23], [9730, 40, 47], [9731, 64, 52], [9735, 42, 40], [9736, 48, 45],
                    [9737, 30, 20], [9738, 35, 40], [9739, 45, 37], [9740, 85, 85], [9741, 73, 61], [9742, 49, 41],
                    [9743, 31, 27], [9744, 68, 44], [9745, 40, 23], [9746, 43, 28], [9747, 38, 44], [9748, 38, 38],
                    [9751, 34, 36], [9752, 37, 45], [9755, 33, 31], [9756, 35, 32], [9757, 18, 16], [9758, 25, 18],
                    [9759, 15, 14], [9760, 36, 27], [9761, 43, 33], [9762, 34, 26], [9763, 25, 19], [9764, 31, 21],
                    [9765, 35, 30], [9766, 28, 22], [9767, 48, 29], [9768, 28, 23], [9769, 18, 19], [9770, 40, 31],
                    [9771, 46, 38], [9772, 39, 29], [9773, 38, 29], [9774, 29, 19], [9775, 25, 20], [9776, 42, 27],
                    [9777, 36, 27], [9778, 40, 30], [9779, 34, 31], [9780, 37, 28], [9781, 42, 28], [9782, 57, 35],
                    [9783, 57, 42], [9784, 26, 20], [9785, 25, 20], [9786, 18, 13], [9787, 33, 26], [9788, 45, 30],
                    [9789, 32, 26], [9790, 34, 26], [9791, 70, 40], [9792, 45, 37], [9793, 15, 12], [9794, 14, 12],
                    [9795, 12, 12], [9796, 17, 17], [9797, 14, 11], [9798, 14, 13], [9799, 44, 40], [9800, 20, 19],
                    [9801, 18, 14], [9802, 17, 14], [9803, 9, 9], [9804, 16, 13], [9805, 31, 23], [9806, 22, 17],
                    [9807, 25, 15], [9808, 85, 53], [9809, 51, 28], [9811, 41, 24], [9812, 50, 30], [9813, 65, 37],
                    [9814, 20, 13], [9815, 39, 23], [9816, 50, 27], [9817, 28, 15], [9818, 54, 24], [9819, 65, 50],
                    [9820, 82, 52], [9821, 42, 32], [9822, 22, 18], [9823, 30, 20], [9824, 33, 35], [9825, 18, 15],
                    [9826, 43, 30], [9827, 44, 29], [9828, 39, 28], [9829, 36, 24], [9830, 32, 24], [9831, 36, 23],
                    [9832, 40, 26], [9833, 29, 22], [9834, 70, 44], [9835, 30, 26], [9836, 58, 46], [9837, 31, 25],
                    [9838, 56, 41], [9839, 16, 15], [9840, 72, 43], [9841, 66, 40], [9842, 30, 19], [9843, 27, 23],
                    [9844, 33, 26], [9845, 31, 25], [9846, 26, 18], [9847, 14, 11], [9848, 26, 17], [9849, 28, 22],
                    [9850, 23, 16], [9851, 22, 17], [9852, 20, 16], [9853, 24, 18], [9854, 14, 11], [9855, 38, 29],
                    [9856, 17, 17], [9857, 15, 13], [9858, 37, 35], [9859, 53, 34], [9860, 65, 36], [9861, 49, 44],
                    [9862, 28, 24], [9863, 38, 26], [9864, 55, 30], [9865, 36, 26], [9866, 53, 32], [9867, 19, 16],
                    [9868, 40, 27], [9869, 40, 30], [9870, 40, 38], [9871, 40, 26], [9872, 28, 23], [9873, 45, 37],
                    [9874, 38, 34], [9875, 26, 21], [9876, 25, 21], [9877, 33, 36], [9878, 35, 28], [9879, 36, 31],
                    [9880, 38, 41], [9881, 60, 47], [9882, 51, 41], [9883, 31, 23], [9884, 31, 33], [9885, 39, 24],
                    [9886, 36, 23], [9887, 35, 24], [9888, 44, 32], [9889, 42, 28], [9890, 37, 29], [9891, 28, 21],
                    [9892, 31, 24], [9893, 32, 17], [9894, 40, 28], [9895, 26, 16], [9896, 11, 11], [9897, 33, 27],
                    [9898, 31, 25], [9899, 24, 19], [9900, 51, 46], [9901, 43, 34], [9902, 78, 53], [9903, 56, 43],
                    [9904, 50, 38], [9905, 50, 44], [9906, 36, 23], [9907, 28, 26], [9908, 51, 36], [9909, 16, 14],
                    [9910, 48, 41], [9911, 60, 40], [9912, 45, 36], [9913, 22, 19], [9914, 30, 23], [9915, 27, 24],
                    [9916, 37, 26], [9917, 33, 34], [9918, 65, 38], [9919, 48, 37], [9920, 81, 62], [9921, 26, 23],
                    [9922, 24, 15], [9923, 31, 17], [9924, 39, 24], [9925, 47, 55], [9926, 53, 42], [9927, 30, 32],
                    [9928, 50, 29], [9929, 48, 36], [9930, 36, 26], [9931, 58, 36], [9932, 81, 68], [9933, 47, 49],
                    [9934, 43, 32], [9935, 37, 35], [9936, 34, 32], [9937, 28, 38], [9938, 16, 14], [9939, 44, 45],
                    [9940, 35, 36], [9941, 36, 21], [9942, 20, 17], [9943, 50, 39], [9944, 47, 36], [9945, 60, 33],
                    [9946, 41, 26], [9947, 50, 28], [9948, 100, 64], [9949, 70, 48], [9950, 50, 32], [9951, 33, 29],
                    [9952, 45, 25], [9953, 22, 19], [9954, 100, 63], [9955, 21, 20], [9956, 38, 29], [9957, 71, 37],
                    [9958, 31, 23], [9959, 85, 42], [9960, 44, 23], [9961, 39, 31], [9962, 29, 30], [9963, 70, 34],
                    [9964, 41, 28], [9965, 33, 17], [9966, 58, 29], [9967, 75, 30], [9968, 36, 30], [9969, 24, 19],
                    [9970, 54, 28], [9971, 34, 24], [9972, 85, 37], [9973, 47, 32], [9974, 33, 20], [9975, 80, 34],
                    [9976, 65, 37], [9977, 33, 19], [9978, 54, 23], [9979, 73, 34], [9980, 48, 22], [9981, 27, 16],
                    [9982, 16, 13], [9983, 55, 28], [9984, 35, 23], [9985, 36, 21], [9986, 37, 23], [9987, 42, 34],
                    [9988, 65, 42], [9989, 33, 26], [9990, 32, 26], [9991, 38, 29], [9992, 39, 39], [9993, 31, 31],
                    [9994, 25, 22], [9995, 37, 31], [9996, 32, 27], [9997, 16, 25], [9998, 17, 15], [9999, 26, 28],
                    [10000, 23, 18], [10001, 18, 15], [10002, 16, 13], [10003, 47, 27], [10004, 33, 22],
                    [10005, 22, 17], [10006, 29, 22], [10007, 47, 38], [10008, 45, 41], [10009, 45, 28],
                    [10017, 37, 27], [10018, 52, 32], [10032, 75, 42], [10037, 79, 35], [10038, 40, 25],
                    [10046, 58, 35], [10047, 42, 26], [10049, 35, 30], [10056, 56, 50], [10057, 60, 49],
                    [10058, 25, 29], [10059, 50, 31], [10065, 35, 50], [10066, 57, 65], [10071, 45, 35],
                    [10076, 45, 29], [10091, 46, 30], [10094, 60, 42], [10098, 54, 37], [10101, 77, 50],
                    [10102, 60, 38], [10103, 70, 48], [10109, 157, 57], [10110, 50, 45], [10111, 100, 48],
                    [10112, 95, 46], [10113, 105, 61], [10114, 80, 38], [10117, 73, 45], [10122, 87, 57],
                    [10125, 75, 44], [10127, 42, 30], [10128, 50, 40], [10131, 52, 38], [10132, 50, 31],
                    [10133, 78, 38], [10139, 55, 41], [10144, 50, 29], [10180, 40, 24], [10183, 37, 24],
                    [10184, 47, 31], [10185, 27, 22], [10186, 27, 22], [10187, 18, 15], [10188, 47, 30],
                    [10189, 45, 29], [10190, 18, 13], [10191, 40, 24], [10192, 29, 21], [10193, 18, 18],
                    [10194, 14, 11], [10195, 13, 11], [10490, 18, 26], [10491, 9, 18], [10492, 8, 13], [10493, 32, 38],
                    [10494, 11, 30], [10495, 10, 27], [10496, 7, 15], [10497, 28, 39], [10498, 8, 15], [10499, 9, 35],
                    [10500, 10, 33], [10501, 10, 39], [10502, 28, 51], [10503, 11, 35], [10504, 12, 45],
                    [10505, 31, 39], [10506, 12, 24], [10507, 9, 18], [10508, 22, 45], [10509, 29, 35], [10510, 12, 32],
                    [10511, 8, 17], [10514, 15, 21], [10515, 15, 22], [10516, 14, 19], [10518, 14, 14], [10519, 17, 14],
                    [10520, 9, 9], [10521, 14, 17], [10522, 16, 18], [10523, 14, 18], [10524, 21, 20], [10525, 15, 18],
                    [10526, 14, 17], [10527, 11, 13], [10528, 17, 18], [10529, 17, 18], [10530, 14, 18],
                    [10531, 14, 16], [10532, 22, 21], [10533, 32, 27], [10534, 20, 13], [10535, 31, 25],
                    [10536, 16, 19], [10537, 22, 20], [10538, 29, 24], [10539, 17, 17], [10540, 31, 25],
                    [10541, 34, 29], [10542, 35, 27], [10543, 7, 7], [10544, 11, 9], [10545, 7, 7], [10546, 10, 8],
                    [10547, 8, 8], [10548, 12, 9], [10549, 8, 8], [10550, 9, 11], [10551, 9, 8], [10552, 7, 7],
                    [10553, 24, 16], [10554, 19, 13], [10555, 11, 8], [10556, 20, 13], [10557, 10, 10], [10558, 29, 20],
                    [10559, 13, 9], [10560, 20, 13], [10577, 20, 13], [10578, 34, 34], [10579, 46, 34], [10580, 61, 38],
                    [10581, 60, 51], [10582, 52, 39], [10583, 46, 32], [10584, 47, 41], [10585, 40, 40],
                    [10586, 49, 45], [10587, 46, 39], [10588, 41, 38], [10589, 46, 41], [10590, 56, 45],
                    [10591, 74, 60], [10592, 47, 31], [10593, 46, 39], [10594, 51, 47], [10595, 41, 40],
                    [10596, 40, 37], [10597, 46, 38], [10598, 51, 31], [10603, 36, 33], [10604, 33, 24],
                    [10605, 14, 11], [10606, 13, 10], [10607, 15, 12], [10608, 14, 10], [10609, 13, 10],
                    [10610, 20, 11], [10611, 20, 14], [10612, 17, 14], [10613, 40, 28], [10614, 39, 23],
                    [10615, 42, 29], [10616, 32, 23], [10617, 43, 30], [10618, 43, 26], [10619, 28, 21],
                    [10620, 28, 19], [10621, 32, 24], [10622, 30, 18], [10623, 39, 25], [10624, 39, 24],
                    [10625, 28, 20], [10626, 36, 23], [10627, 39, 29], [10628, 42, 28], [10629, 44, 28],
                    [10630, 36, 24], [10631, 36, 23], [10632, 34, 21], [10633, 46, 32], [10634, 43, 28],
                    [10635, 43, 29], [10636, 36, 25], [10637, 43, 29], [10638, 21, 15], [10639, 45, 29],
                    [10640, 44, 26], [10641, 38, 27], [10642, 47, 28], [10643, 39, 25], [10644, 46, 30],
                    [10645, 30, 28], [10646, 41, 27], [10647, 44, 28], [10648, 40, 31], [10649, 41, 25],
                    [10650, 41, 29], [10651, 38, 30], [10652, 32, 22], [10653, 42, 28], [10654, 35, 28],
                    [10655, 44, 31], [10656, 42, 28], [10657, 37, 26], [10658, 45, 26], [10659, 18, 16],
                    [10660, 45, 30], [10661, 51, 27], [10662, 44, 27], [10663, 31, 24], [10664, 32, 26],
                    [10665, 43, 31], [10666, 53, 30], [10667, 47, 30], [10668, 35, 26], [10669, 20, 16],
                    [10670, 31, 23], [10671, 43, 27], [10672, 45, 25], [10673, 29, 21], [10674, 31, 20],
                    [10675, 39, 31], [10676, 39, 31], [10677, 32, 21], [10678, 36, 23], [10679, 46, 26],
                    [10680, 34, 27], [10681, 42, 31], [10682, 39, 24], [10683, 31, 22], [10684, 26, 19],
                    [10685, 70, 37], [10686, 37, 31], [10687, 39, 30], [10688, 48, 34], [10689, 48, 30],
                    [10690, 49, 31], [10691, 49, 31], [10692, 36, 27], [10693, 57, 30], [10694, 47, 29],
                    [10695, 46, 28], [10696, 45, 27], [10697, 30, 22], [10698, 32, 26], [10699, 38, 32],
                    [10700, 20, 15], [10701, 44, 28], [10702, 53, 26], [10703, 53, 26], [10704, 42, 25],
                    [10705, 39, 22], [10706, 42, 30], [10707, 38, 34], [10708, 47, 32], [10709, 43, 35],
                    [10710, 51, 28], [10711, 43, 28], [10712, 44, 33], [10713, 50, 32], [10714, 40, 26],
                    [10715, 49, 29], [10716, 42, 31], [10717, 44, 31], [10718, 39, 33], [10719, 47, 30],
                    [10720, 50, 31], [10721, 26, 19], [10722, 49, 31], [10723, 44, 30], [10724, 45, 31],
                    [10725, 42, 34], [10726, 34, 24], [10727, 44, 26], [10728, 42, 26], [10729, 43, 30],
                    [10730, 49, 29], [10731, 37, 29], [10732, 49, 31], [10733, 43, 31], [10734, 45, 28],
                    [10735, 43, 26], [10736, 45, 31], [10737, 56, 35], [10738, 45, 27], [10739, 26, 15],
                    [10740, 43, 28], [10741, 42, 32], [10742, 43, 28], [10743, 40, 26], [10744, 39, 24],
                    [10745, 42, 26], [10746, 44, 24], [10747, 26, 16], [10748, 33, 23], [10749, 40, 28],
                    [10750, 44, 28], [10751, 44, 28], [10752, 43, 31], [10753, 44, 30], [10754, 34, 23],
                    [10755, 18, 15], [10756, 70, 45], [10757, 20, 14], [10758, 27, 18], [10759, 45, 26],
                    [10760, 46, 28], [10761, 40, 27], [10762, 44, 33], [10763, 36, 25], [10764, 24, 20],
                    [10765, 34, 23], [10766, 49, 29], [10767, 45, 28], [10768, 39, 29], [10769, 41, 26],
                    [10770, 44, 30], [10771, 45, 30], [10772, 31, 33], [10773, 42, 37], [10774, 38, 23],
                    [10775, 43, 23], [10776, 35, 22], [10777, 25, 19], [10778, 54, 30], [10779, 31, 24],
                    [10780, 43, 26], [10781, 40, 26], [10782, 39, 29], [10783, 41, 32], [10784, 41, 28],
                    [10785, 45, 26], [10786, 40, 28], [10787, 45, 28], [10788, 40, 29], [10789, 42, 25],
                    [10790, 45, 25], [10791, 45, 25], [10792, 35, 27], [10793, 42, 28], [10794, 44, 31],
                    [10795, 43, 28], [10796, 40, 31], [10797, 40, 28], [10798, 38, 28], [10799, 19, 16],
                    [10800, 40, 29], [10801, 50, 30], [10802, 42, 25], [10803, 34, 20], [10804, 48, 28],
                    [10805, 54, 28], [10806, 40, 29], [10807, 44, 23], [10808, 34, 20], [10809, 28, 23],
                    [10810, 44, 28], [10811, 36, 24], [10812, 109, 44], [10814, 36, 25], [10815, 44, 28],
                    [10816, 43, 28], [10817, 44, 30], [10818, 45, 29], [10819, 44, 28], [10820, 42, 26],
                    [10821, 38, 28], [10822, 41, 28], [10823, 42, 26], [10824, 37, 26], [10825, 38, 31],
                    [10826, 37, 23], [10827, 36, 28], [10828, 33, 26], [10829, 42, 28], [10830, 44, 26],
                    [10831, 44, 28], [10832, 43, 26], [10833, 43, 26], [10834, 44, 26], [10835, 44, 28],
                    [10836, 40, 26], [10837, 46, 26], [10838, 41, 26], [10839, 34, 26], [10840, 26, 19],
                    [10841, 60, 30], [10842, 32, 30], [10843, 41, 28], [10844, 34, 24], [10845, 30, 22],
                    [10846, 30, 24], [10847, 40, 28], [10848, 41, 28], [10849, 44, 28], [10850, 38, 27],
                    [10851, 41, 28], [10852, 43, 28], [10853, 48, 31], [10854, 41, 30], [10855, 45, 26],
                    [10856, 42, 28], [10857, 45, 30], [10858, 40, 26], [10859, 45, 26], [10860, 48, 28],
                    [10861, 45, 28], [10862, 45, 26], [10863, 23, 19], [10864, 51, 27], [10865, 40, 28],
                    [10866, 36, 22], [10867, 41, 26], [10868, 44, 26], [10869, 53, 31], [10870, 48, 30],
                    [10871, 44, 25], [10872, 47, 26], [10873, 45, 30], [10874, 46, 31], [10875, 45, 28],
                    [10876, 47, 26], [10877, 42, 28], [10878, 43, 26], [10879, 45, 28], [10880, 45, 28],
                    [10881, 30, 23], [10882, 49, 28], [10883, 53, 30], [10884, 56, 29], [10885, 45, 29],
                    [10886, 40, 23], [10887, 36, 25], [10888, 50, 28], [10889, 43, 28], [10890, 33, 23],
                    [10891, 29, 21], [10892, 29, 19], [10893, 43, 31], [10894, 44, 31], [10895, 67, 35],
                    [10896, 44, 30], [10897, 45, 33], [10898, 43, 30], [10899, 48, 29], [10900, 41, 28],
                    [10901, 39, 28], [10902, 31, 22], [10903, 45, 31], [10904, 43, 28], [10905, 36, 23],
                    [10906, 45, 31], [10907, 42, 29], [10908, 44, 26], [10909, 48, 31], [10910, 39, 29],
                    [10911, 46, 30], [10912, 48, 35], [10913, 36, 28], [10914, 54, 30], [10915, 46, 35],
                    [10916, 48, 33], [10917, 49, 31], [10918, 34, 28], [10978, 41, 28], [10979, 42, 25],
                    [10980, 34, 23], [11091, 8, 5], [11092, 10, 8], [11093, 12, 7], [11094, 13, 11], [11095, 10, 7],
                    [11096, 17, 12], [11097, 10, 8], [11098, 9, 7], [11099, 32, 18], [11100, 12, 11], [11101, 11, 9],
                    [11102, 12, 9], [11103, 13, 10], [11104, 38, 22], [11105, 30, 22], [11106, 25, 15], [11107, 14, 10],
                    [11108, 9, 6], [11109, 16, 12], [11110, 13, 9], [11111, 11, 7], [11112, 22, 14], [11113, 23, 15],
                    [11114, 38, 26], [11115, 7, 6], [11116, 8, 6], [11117, 8, 5], [11118, 13, 9], [11119, 36, 23],
                    [11120, 26, 16], [11121, 9, 6], [11122, 12, 8], [11123, 15, 11], [11124, 9, 8], [11125, 23, 15],
                    [11126, 12, 11], [11127, 7, 7], [11128, 12, 7], [11129, 7, 6], [11130, 15, 10], [11131, 7, 6],
                    [11132, 24, 14], [11133, 11, 8], [11134, 6, 4], [11135, 42, 23], [11136, 10, 8], [11137, 6, 5],
                    [11138, 19, 11], [11139, 10, 6], [11140, 10, 9], [11141, 8, 6], [11142, 9, 7], [11143, 7, 6],
                    [11144, 9, 8], [11145, 29, 19], [11146, 7, 6], [11147, 5, 3], [11148, 31, 22], [11149, 17, 11],
                    [11150, 18, 15], [11151, 21, 14], [11152, 16, 11], [11153, 13, 9], [11154, 25, 18], [11155, 17, 10],
                    [11156, 11, 10], [11157, 14, 10], [11158, 13, 10], [11159, 20, 10], [11160, 28, 15],
                    [11161, 12, 10], [11162, 18, 12], [11163, 13, 12], [11164, 17, 14], [11165, 17, 12],
                    [11166, 35, 24], [11168, 24, 17], [11169, 8, 8], [11170, 10, 9], [11171, 11, 10], [11172, 10, 9],
                    [11173, 12, 10], [11174, 6, 6], [11175, 6, 6], [11176, 6, 6], [11177, 21, 16], [11178, 7, 7],
                    [11179, 13, 12], [11180, 13, 10], [11181, 16, 13], [11182, 14, 10], [11183, 12, 13],
                    [11184, 92, 71], [11185, 92, 71], [11186, 92, 71], [11187, 92, 71], [11188, 92, 71],
                    [11189, 70, 63], [11195, 17, 14], [11197, 106, 48], [11199, 69, 38], [11201, 10, 11],
                    [11202, 43, 27], [11203, 11, 13], [11204, 72, 47], [11205, 106, 74], [11206, 5