import unittest
import os, sys
from epanettools import pdd as pd
from epanettools.examples import simple
from tests import tools_for_testing as tt

class Test1(unittest.TestCase):
    
    
    def Error(self,e):
        if(e):
            s="Epanet Error: %d : %s" %(e,pd.ENgeterror(e,500)[1])
            raise Exception(s)  
        
    def setUp(self): 
        print("SETUP!")
        self.file = "E:\\Projects\\2016_Bdesh_training_with_dutch_waterboards\\Assela Pathirana\\risk_based\\Adjumani_network_simplified.inp"
        self.Error(pd.ENopen(self.file,self.file+".rpt",""))      
    
    def tearDown(self):
        self.Error(pd.ENclose())
        print("TEAR DOWN!")
        
    def test_alter_with_ENset_and_check_with_a_file(self):
        a,nnodes=pd.ENgetcount(pd.EN_NODECOUNT)
        self.Error(a)
        for i in range(nnodes):
            a,b=pd.ENgetnodevalue(i+1,pd.EN_BASEDEMAND)
            self.Error(a)
            self.Error(pd.ENsetnodevalue(i+1,pd.EN_BASEDEMAND,b*2))
        self.Error(pd.ENsaveinpfile(self.file+"2.inp"))

        
    #def test_alter_with_ENset_via_PDD_and_check_with_a_file(self):
        #self.Error(pd.ENopen(self.file,"t.rpt",""))   
        #self.Error(pd.ENsaveinpfile_wrap("1.inp"))
        #self.Error(pd.ENsetlinkvalue_wrap(81,0,788288))
        #self.Error(pd.ENsaveinpfile_wrap("2.inp"))
        #self.assertEqual(tt.compareFiles("1.inp","2.inp"),'16>7.88e+05')  
        #self.Error(pd.ENclose())
    

tc=Test1()
def clt(fn):
    tc.setUp()
    fn()
    tc.tearDown()   
    
def main():
    for a in dir(tc):
        if (a.startswith('test_')):
            b=getattr(tc,a)
            if(hasattr(b, '__call__')):
                print ("calling %s **********************************" % a )
                clt(b)
           


if __name__ == "__main__":
        main()    
        

