# -*- coding: utf-8 -*-
"""
著作權所有 (C) 民國102年 意傳文化科技
開發者：薛丞宏
網址：http://意傳.台灣
語料來源：請看各資料庫內說明

本程式乃自由軟體，您必須遵照SocialCalc設計的通用公共授權（Common Public Attribution License, CPAL)來修改和重新發佈這一程式，詳情請參閱條文。授權大略如下，若有歧異，以授權原文為主：
	１．得使用、修改、複製並發佈此程式碼，且必須以通用公共授權發行；
	２．任何以程式碼衍生的執行檔或網路服務，必須公開該程式碼；
	３．將此程式的原始碼當函式庫引用入商業軟體，且不需公開非關此函式庫的任何程式碼

此開放原始碼、共享軟體或說明文件之使用或散佈不負擔保責任，並拒絕負擔因使用上述軟體或說明文件所致任何及一切賠償責任或損害。

臺灣言語工具緣起於本土文化推廣與傳承，非常歡迎各界用於商業軟體，但希望在使用之餘，能夠提供建議、錯誤回報或修補，回饋給這塊土地。

感謝您的使用與推廣～～勞力！承蒙！
"""
from 毓哲語言辨識.第二步之產生通用點臺羅聲韻對照 import 臺羅聲韻轉辨識合成型
from 臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音

# a-b+c/tiau7:t1/su5:s1!s2@s3/ku3:k1^k2_k3
# 前音-此音+後音/調：調類/詞：第幾字!上尾第幾字@攏總字/句：第幾字^上尾第幾字_攏總字
class 臺羅轉合成標籤:
	安靜符號 = 'sil'
	安靜標籤 = 'x-sil+x/tiau3:x/su5:x!x@x/ku3:x^x_x'
	def 臺羅轉合成標籤佮聲韻資料(self, 臺羅音標):
		聲韻標籤 = [self.安靜符號]
		for 詞 in 臺羅音標.split(' '):
			for 字 in 詞.split('-'):
				臺羅拼音 = 臺灣閩南語羅馬字拼音(字)
				聲, 韻 = 臺羅聲韻轉辨識合成型(臺羅拼音.聲, 臺羅拼音.韻)
				if 聲!='':
					聲韻標籤.append(聲)
				聲韻標籤.append(韻)
		聲韻標籤.append(self.安靜符號)
		合成標籤 = [self.安靜標籤]
		這馬第幾標籤 = 1
		句攏總字數 = 臺羅音標.count(' ') + 臺羅音標.count('-') + 1
		句中第幾字 = 0
		for 詞 in 臺羅音標.split(' '):
			詞攏總字數 = 詞.count('-') + 1
			詞中第幾字 = 0
			for 字 in 詞.split('-'):
				臺羅拼音 = 臺灣閩南語羅馬字拼音(字)
				聲, 韻 = 臺羅聲韻轉辨識合成型(臺羅拼音.聲, 臺羅拼音.韻)
				if 聲!='':
					聲標籤=self.產生合成標籤(聲韻標籤[這馬第幾標籤-1], 聲韻標籤[這馬第幾標籤], 聲韻標籤[這馬第幾標籤+1],
						臺羅拼音.調, 詞中第幾字, 詞攏總字數, 句中第幾字, 句攏總字數)
					這馬第幾標籤+=1
					合成標籤.append(聲標籤)
				韻標籤=self.產生合成標籤(聲韻標籤[這馬第幾標籤-1], 聲韻標籤[這馬第幾標籤], 聲韻標籤[這馬第幾標籤+1],
					臺羅拼音.調, 詞中第幾字, 詞攏總字數, 句中第幾字, 句攏總字數)
				這馬第幾標籤+=1
				合成標籤.append(韻標籤)
				詞中第幾字 += 1
				句中第幾字 += 1
		合成標籤.append(self.安靜標籤)
		return (合成標籤,聲韻標籤)
	def 臺羅轉合成標籤(self, 臺羅音標):
		return self.臺羅轉合成標籤佮聲韻資料(臺羅音標)[0]
	def 臺羅轉聲韻資料(self, 臺羅音標):
		return self.臺羅轉合成標籤佮聲韻資料(臺羅音標)[1]
	def 臺羅聲韻轉辨識合成型(self, 聲, 韻):
		return 臺羅聲韻轉辨識合成型(聲, 韻)
	def 產生合成標籤(self, 前音, 此音, 後音, 調,
			詞中第幾字, 詞攏總字數, 句中第幾字, 句攏總字數):
		return '{0}-{1}+{2}/tiau7:{3}/su5:{4}!{5}@{6}/ku3:{7}^{8}_{9}'.format(
			前音, 此音, 後音, 調, 	詞中第幾字, 詞攏總字數 - 詞中第幾字, 詞攏總字數,
			句中第幾字, 句攏總字數 - 句中第幾字, 句攏總字數)


if __name__ == '__main__':
	合成標籤工具 = 臺羅轉合成標籤()
	#[我 gua2, 愛 ai3, 蔡 tshua3, 文 bun5, 莉 ni7, , ,]
	#[政 tsing3, 源 guan5, 足 tsiok4, 緣投 ian5-tau5, , ,]
	標籤=合成標籤工具.臺羅轉合成標籤佮聲韻資料('gua1 ai2 tshua3-bun7-le7')
# 	標籤=合成標籤工具.臺羅轉合成標籤佮聲韻資料('tsing2-guan7 tsiok8 ian7-tau5')
# 	標籤=合成標籤工具.臺羅轉合成標籤佮聲韻資料('lau3-pe7 bo7-si7-kan1')
	for 標籤 in 標籤[0]:
		print(標籤)
