from dexy.commands.utils import init_wrapper
from dexy.utils import defaults

def reset_command(
        __cli_options=False,
        artifactsdir=defaults['artifacts_dir'], # Where dexy should store working files.
        logdir=defaults['log_dir'] # DEPRECATED
        ):
    """
    Clean out the contents of dexy's cache and reports directories.
    """
    wrapper = init_wrapper(locals())
    wrapper.remove_dexy_dirs()
    wrapper.remove_reports_dirs(keep_empty_dir=True)
    wrapper.create_dexy_dirs()

def cleanup_command(
        __cli_options=False,
        artifactsdir=defaults['artifacts_dir'], # Where dexy should store working files.
        logdir=defaults['log_dir'], # DEPRECATED
        reports=True # Whether directories generated by reports should also be removed.
        ):
    """
    Remove the directories which dexy created, including working directories
    and reports.
    """
    wrapper = init_wrapper(locals())
    wrapper.remove_dexy_dirs()
    wrapper.remove_reports_dirs(reports)

def setup_command(
        __cli_options=False,
        artifactsdir=defaults['artifacts_dir'], # Where dexy should store working files.
        **kwargs):
    """
    Create the directories dexy needs to run.
    """
    wrapper = init_wrapper(locals())
    wrapper.create_dexy_dirs()

