# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RedisRebootParameters(Model):
    """Specifies which Redis node(s) to reboot.

    :param reboot_type: Which Redis node(s) to reboot. Depending on this
     value data loss is possible. Possible values include: 'PrimaryNode',
     'SecondaryNode', 'AllNodes'
    :type reboot_type: str or :class:`RebootType
     <azure.mgmt.redis.models.RebootType>`
    :param shard_id: If clustering is enabled, the ID of the shard to be
     rebooted.
    :type shard_id: int
    """ 

    _validation = {
        'reboot_type': {'required': True},
    }

    _attribute_map = {
        'reboot_type': {'key': 'rebootType', 'type': 'str'},
        'shard_id': {'key': 'shardId', 'type': 'int'},
    }

    def __init__(self, reboot_type, shard_id=None):
        self.reboot_type = reboot_type
        self.shard_id = shard_id
