#coding=utf-8

'''
作者：xjxfly
邮箱：xjxfly@qq.com

说明：
这是通用自定义函数形成的基础库

先引入配置文件及所有要用到的模块，这些模块已集中到 common_import.py中了
'''


from jxbase import common_config as cf 		# 引入自定义常量
from jxbase.common_import import * 			# 引入各通用模块


#########=====================================================



date_step = datetime.timedelta(days=1)
one_day_step = datetime.timedelta(days=1)



def os_charactor(s):
	'''
	功能说明：把输入的字符串s(utf-8格式)，转换成当前操作系统的字符集
	'''
	#获取系统字符集
	os_code=sys.getfilesystemencoding()
	return s.decode('utf-8').encode(os_code)









def get_current_path(script_name,style='UNIX'):
	'''
	功能说明：根据传入的脚本文件名，返回其所在的当前路径（LINUX 风格），并以 '/' 结尾
	参数：script_name, 脚本文件名
	返回值：当前脚本所在的路径名
	'''
	try:
		cur_path = os.path.split(os.path.realpath(script_name))[0] 		# 这句返回 当前脚本文件 所在路径（不含最后的文件名），路径分割符为 DOS 风格
	except:
		print('请传入脚本文件名 script_name = "脚本文件名"')
		return None

	if style in cf.DOS_STYLE_ARR:
		cur_path = cur_path + '\\'
	if style in cf.UNIX_STYLE_ARR:
		cur_path = cur_path.replace('\\','/') + '/' 				# 把 DOS 风格的路径分割符 \ 转换成Unix 风格的分割符 /，既然叫路径，那就要求以 '/'  结尾

	return cur_path








def change_path_style(xpath = None,style = 'DOS'):
	'''
	说明：改变路径风格
	参数：xpath 为待转换的路径, style 为目标风格，
	返回值：转换风格后的路径
	'''
	if xpath is None:
		print('没有输入路径')
		return None

	# -------------
	new_path = None 		# 预设返回路径值为 None

	if style in cf.DOS_STYLE_ARR:
		new_path = xpath.replace('/','\\')

	if style in cf.UNIX_STYLE_ARR:
		new_path = xpath.replace('\\','/')

	print('转换后的路径为：%s' % (new_path))

	return new_path








def convert_df_type(df,xtype=float,column_arr=[]):
	'''
	功能说明：对传入的 df ，根据传入的字段 column_arr （如果有的话，要是没有的话，则对 df 中所有字段转换），从 df 中找到对应的列，将其数据类型转换为 xtype 指定的类型  
	参数：df, 待转换字段类型的 df; xtype, 目标数据类型；column_arr，需要转换哪些列
	返回值：转换数据类型后的 df
	'''
	func_name = get_current_function_name() + ': '
	all_df = df.reset_index(drop=True)
	index1_arr = list(all_df.index)

	if len(column_arr) == 0:
		column_arr = list(df.columns)
	# 先把所有数值型的列转成数值表示（原先是字符串形式的），以便参与数学计算
	#for k,xfield in enumerate(list(set(list(all_df.columns)) - set(['code','name','date','time']))):
	for k,xfield in enumerate(column_arr):
		try:
			all_df[xfield] = all_df[xfield].astype(dtype=xtype)
		except:
			print('df 的 %s 列数据类型转换失败。' % (str(xfield)))
			pass
			'''
			for k,v in enumerate(index1_arr):
				if is_number(all_df.ix[v,xfield]) == False:
					#all_df = all_df.drop(v,axis=0) 			# axis=0 表示行操作，这里是删除一行
					all_df.ix[v,xfield] = 0 				# 非数值单元域，全部填上 0
			all_df = all_df.reset_index(drop=True) 			# 把不符合要求的行删完后，要重新编排索引（行号）
			index1_arr = list(all_df.index)
			'''

	all_df = all_df.reset_index(drop=True)

	return all_df








def get_percent(value1,value2):
	'''
	说明：计算 value2 相对于 value1 的增长幅度
	返回值：增长幅度
	'''
	func_name = get_current_function_name() + ': '
	if value1 == 0:
		print(func_name,'错误：请确保 value1 不为 0')
		return None

	xresult = (value2 - value1) / value1

	return xresult















def is_number(n):
	'''
	功能说明：测试输入的参数是否为数值型或数值型字符串，如是则返回 True，否则返回 False
	返回值：如是数字则返回 True，否则返回 False
	'''
	try:
		float(n)
		return True
	except ValueError:
		return False








def is_weekday(xdate = None):
	'''
	功能说明：该函数用于判断传入的日期（若没传入，则判断今天）是否为周一到周五
	返回值：如果是工作日，则返回True，否则返回 False
	'''
	if xdate is None:
		xdate = get_today()

	n = xdate.weekday()
	if n >=0 and n <=4:
		return True
	else:
		return False








def is_weekend(xdate = None):
	'''
	功能说明：该函数用于判断传入的日期（若没传入，则判断今天）是否为双休日
	返回值：若是双休日，则返回True，否则返回 False
	'''
	if xdate is None:
		xdate = get_today()

	n = xdate.weekday()
	if n == 5 or n == 6:
		return True
	else:
		return False








def get_year(xdate):
	'''
	功能说明：对传入的日期取年份以数值型返回，
	参数：xdate，表示传入日期，必须是YYYY-mm-dd格式，或用 python 构造的日期型，
	返回值：整型年份

	'''
	xyear = None
	xdate = str(xdate)
	date_arr = xdate.split('-')
	if len(date_arr)>=1:
		try:
			xyear = int(date_arr[0])
		except:
			pass

	return xyear







def get_month(xdate):
	'''
	功能说明：对传入的日期取月份以数值型返回，
	参数：xdate，表示传入日期，必须是YYYY-mm-dd格式，或用 python 构造的日期型，
	返回值：整型月份

	'''
	xmonth = None
	xdate = str(xdate)
	date_arr = xdate.split('-')
	if len(date_arr)>=2:
		try:
			xmonth = int(date_arr[1])
		except:
			pass

	return xmonth












def get_day(xdate):
	'''
	功能说明：对传入的日期取日份以数值型返回，
	参数：xdate，表示传入日期，必须是YYYY-mm-dd格式，或用 python 构造的日期型，
	返回值：整型日

	'''
	xday = None
	xdate = str(xdate)
	date_arr = xdate.split('-')
	if len(date_arr)>=3:
		try:
			xday = int(date_arr[2])
		except:
			pass

	return xday













def get_today():
	'''
	功能说明：获取今天日期

	'''
	#today=time.strftime(date_format,time.localtime(time.time()))
	today = datetime.date.today()
	return today







def get_yesterday():
	'''
	功能说明：获取明天
	'''
	#xstep=datetime.timedelta(days=1)
	yesterday = get_today() - one_day_step
	return yesterday





def get_tomorrow():
	'''
	功能说明：获取明天
	'''
	#xstep=datetime.timedelta(days=1)
	tomorrow = get_today() + one_day_step
	return tomorrow









def get_time(time_format=None,xtime=None):
	'''
	功能说明：获取当前时间戳，并转化成人类可读的时分秒格式
	'''

	if time_format is None:
		time_format = cf.TIME_FORMAT3
	if xtime is None:
		xtime=time.time()
	current_time=time.strftime(time_format,time.localtime(xtime))
	return str(current_time)








def get_current_time(time_format=None,xtime=None):
	'''
	用于取得当前时间。实际上，该函数可看成是上述 get_time() 的别名
	返回值，HH:MM:SS 格式的时间返回
	'''
	current_time = get_time(time_format=time_format,xtime=xtime)
	return current_time







def get_hh(xtime):
	'''
	说明：根据传入的时间 ，返回小时部分（整型）
	参数：xtime，是字符串，格式必须为 hh:mm:ss
	返回值：整型 hh
	'''

	time_str = None
	time_arr = xtime.split(':')
	if len(time_arr) >= 1:
		time_str = int(time_arr[0])

	return time_str
	






def get_mm(xtime):
	'''
	说明：根据传入的时间 ，返回分钟部分（整型）
	参数：xtime，是字符串，格式必须为 hh:mm:ss
	返回值：整型 mm
	'''

	time_str = None
	time_arr = xtime.split(':')
	if len(time_arr) >= 2:
		time_str = int(time_arr[1])

	return time_str
	





def get_ss(xtime):
	'''
	说明：根据传入的时间 ，返回秒部分（整型）
	参数：xtime，是字符串，格式必须为 hh:mm:ss
	返回值：整型 ss
	'''

	time_str = None
	time_arr = xtime.split(':')
	if len(time_arr) >= 3:
		time_str = int(time_arr[2])

	return time_str
	










def hms_to_minutes(xtime):
	'''
	功能说明：将 HH:MM:SS 转为分钟数
	参数：xtime，是字符串，格式必须为 hh:mm:ss
	返回值：分钟数
	'''	

	minutes = None

	hh=get_hh(xtime)
	mm=get_mm(xtime)
	if hh is not None and mm is not None:
		minutes=hh*60+mm
	
	return minutes









def hms_to_seconds(xtime):
	'''
	功能说明：将 HH:MM:SS 转为分秒数
	参数：xtime，是字符串，格式必须为 hh:mm:ss
	返回值：秒数
	'''		
	
	seconds = None

	hh=get_hh(xtime)
	mm=get_mm(xtime)
	ss=get_ss(xtime)

	if hh is not None and mm is not None and ss is not None:
		seconds=hh*60*60+mm*60+ss
	
	return seconds






def seconds_to_hms(seconds):
	'''
	说明：将秒数转为 hms 形式
	参数：seconds，秒数
	返回值：hms, 表示 HH:MM:SS 格式的时间
	'''

	hh = int(seconds / 3600)
	mm = int((seconds % 3600) / 60)
	ss = int((seconds % 3600) % 60)

	hh = char_fill(s = str(hh),bit = 2)
	mm = char_fill(s = str(mm),bit = 2)
	ss = char_fill(s = str(ss),bit = 2)

	hms = hh + ":" + mm + ":" + ss

	return hms









def timestamp_to_hms(timestamp):
	'''
	功能说明：将传入的时间戳转换为 HH:MM:SS 返回
	'''
	timestamp = int(timestamp)

	hhmmss = time.strftime(cf.TIME_FORMAT1,time.localtime(timestamp))

	return hhmmss





	


def hms_to_timestamp(xtime,xdate=None):
	'''
	功能说明：将输入的日期时间转成时间戳戳（timestamp），
	参数：xdate 可以是字符串形式，也可以是python date 格式，如果没有输入，则取今天
	xtime 必须是 hh:mm:ss 形式
	返回值： 转换后的时间戳
	'''
	if xdate is None:
		xdate = get_today()
	t = str(xdate) + ' ' + str(xtime)
	t_arr = time.strptime(t,cf.DATE_TIME_FORMAT)
	t_timestamp = time.mktime(t_arr) 				# 创建时间戳

	return t_timestamp










def timestamp_to_datetime(timestamp):
	'''
	功能说明：将时间戳转换为 YYYY-MM-DD HH:MM:SS 返回
	'''
	timestamp = int(timestamp)
	hhmmss = time.strftime(cf.DATE_TIME_FORMAT,time.localtime(timestamp))

	return hhmmss









def get_timestamp(xtime,xdate=None):
	'''
	将输入的日期时间转成时间戳戳（timestamp），
	参数：xdate 可以是字符串形式，也可以是python date 格式，如果没有输入，则取今天
	xtime 必须是 hh:mm:ss 形式
	返回值： 转换后的时间戳
	'''

	t_timestamp = hms_to_timestamp(xtime = xtime,xdate = xdate)

	return t_timestamp








def get_lastfile(data_dir):
	'''
	功能说明：从 data_dir 目录中找出修改时间为最新的一个文件，并返回给主调函数

	'''
	lst=os.listdir(data_dir)
	lst.sort(key=lambda fn: os.path.getmtime(data_dir+fn) if not os.path.isdir(data_dir+fn) else 0)
	d=datetime.datetime.fromtimestamp(os.path.getmtime(data_dir+lst[-1]))
	lastfile=lst[-1]
	#print('last file is '+lst[-1])
	time_end=time.mktime(d.timetuple())
	#print('time_end:',time_end)
	return lastfile








def ftp_open(host = None,port = None, username = None, password = None):
	'''
	功能说明：初始化 FTP 连接，返回指向 ftp 服务器的连接符。首先会尝试从传入的参数中读取信息，若没传入，则次选从用户的配置文件 user_config.ini 中读取FTP 服务器配置信息，若没有，则第3选择从 py 配置文件中读取，若还是没有，则返回 None

	'''
	if host is None or port is None or username is None or password is None:
		try:
			cfg = ConfigObj('user_config.ini')
		except:
			print('用户没有提供配置文件 user_config.ini，下面尝试从 common_config.py 中读取配置信息')
			try:
				host = cf.FTP_HOST
				port = cf.FTP_PORT
				username = cf.FTP_USERNAME
				password = cf.FTP_PASSWORD
			except:
				print('错误：common_config.py 配置文件中没有FTP服务器信息')	
				return None	
		else:		
			host = cfg['FTP_HOST']
			port = cfg['FTP_PORT']
			username = cfg['FTP_USERNAME']
			password = cfg['FTP_PASSWORD']	



	# --------------
	ftp=FTP()
	ftp.set_debuglevel(2)
	ftp.connect(host=host,port=port)
	ftp.login(username,password)

	return ftp










def ftp_close(ftp):
	'''
	功能说明：关闭FTP 连接
	'''

	ftp.set_debuglevel(0)
	ftp.quit()








def ftp_up(ftp,filename):
	'''
	功能说明：该函数用来上传文件到FTP 服务器，
	参数：ftp: 指向 FTP 服务器的连接符；filename: 待上传的文件，可以是windows 格式包含全路径的文件
	返回值：无
	'''
	#print(ftp.getwelcome())
	#ftp.cwd('xxx/www')
	file_handler=open(filename,'rb')
	ftp.storbinary('STOR %s' % (os.path.basename(filename)),file_handler)
	file_handler.close()

	print('FTP up OK.')










def ftp_down(ftp,filename):
	'''
	功能说明：该函数用来从 FTP 服务器下载文件，
	参数：ftp: 指向 FTP 服务器的连接符；filename: 待下载的文件，可以是windows 格式包含全路径的文件
	返回值：无
	'''	
	#print(ftp.getwelcome())
	#ftp.cwd('xxx/www')
	file_handler=open(filename,'wb')
	ftp.retrbinary('RETR %s' % (os.path.basename(filename)),file_handler)
	file_handler.close()

	print('FTP down OK.')









# 以下自定义函数的功能是将传入的 list 转成元组，包括只有一个元素的情形
def list_to_tuple(arr,quote_flag = False):
	'''
	功能说明：该函数用于将 list 转成 tuple，包括只有一个元素的情形
	参数：arr, 待转换的数组，quote_flag 表示是否给转换后的每个元组元素加上单引号，如果是 True 的话就加，加上去主要为了给数据库查询语句 select 用
	返回值：xtuple, 字符串形式的元组
	'''
	#判断只有一个元素时要单独处理，如果直接用 tuple()转，则会在末尾加一个逗号，导致不符合要求
	if len(arr) == 0:
		if quote_flag == True:
			xtuple="('')"

		if quote_flag == False:
			xtuple = "()"		

	if len(arr) == 1:	
		if quote_flag == True:
			xtuple="('" + str(arr[0]) + "')"

		if quote_flag == False:
			xtuple = "(" + str(arr[0]) + ")"

	if len(arr) > 1:
		if quote_flag == True:
			arr1 = [str(x) for x in arr]
			xtuple = tuple(arr1)

		if quote_flag == False:
			xtuple = tuple(arr)

	return str(xtuple)












def list2tuple(arr,quote_flag = False):
	'''
	功能说明：列表转成元组。实际上该函数与上述函数是一样的，是上述别名

	'''
	xtuple = list_to_tuple(arr=arr,quote_flag = quote_flag)
	return xtuple









def append_arr_to_df(df,arr):
	'''
	功能说明：把数组形式的 arr 追加到 DataFrame 形式的 df 末尾，并将 df 返回到主调函数，要求 arr 的元素个数及含意与 df 的列数及含义相同

	'''
	xcol=df.columns
	temp_df=pd.DataFrame(data=[arr],columns=xcol)
	result_df=pd.concat([df,temp_df])
	return result_df









def xround(f,bit = 2):
	'''
	功能说明：由于 python3 的  round() 函数返回的结果与我们中国人的常规认识不同，所以自定义一个 xround() 函数 来代替系统提供的 round()
	参数：f: 要进行四舍五入的目标数值；bit: 表示保留几位
	返回值：四舍五入后的数值

	'''

	if(type(bit)!=type(1) or bit<0):
		print('xround(f,bit) 的 bit 参数必须为正整数。')
		return None

	xresult = None			# 预设返回值为 None

	'''
	num_part_arr = list(math.modf(f)) 			# math.modf(f) 的作用是对传入的浮点数 f 分成小数部分与整数部分形成 tuple 返回，这个 tuple 只有两个元素，第1个是小数部分，第2个是整数部分
	decimal_part = num_part_arr[0] 			# 获取小数部分
	integer_part = num_part_arr[1] 			# 获取整数部分
	'''
	alittle=0.0000001 		# 小幅修正值

	# 只有传入的数值的小数部分的长度小于上面的修正值时，才能继续下去，否则返回 None
	if bit < len(str(alittle)):
		xresult=round(f + alittle, bit)
	else:
		print('错误：精度位数（%d 位）要求达到或超过 %d 位，本函数没法处理。' % (bit,len(str(alittle))))


	'''
	temp=int(f*pow(10,bit+1))
	if(temp%10==5):
		temp+=5
		xresult=temp/pow(10,bit+1)
	'''
	#xresult=decimal.Decimal(str(f)).quantize(round(decimal.Decimal('1'),bit),rounding=decimal.ROUND_HALF_UP)
	return xresult



	





def time_spend(t1):
	'''
	功能说明：该函数计算t1 到 t2 之间的时间差，并输出信息，一般在程序末尾调用，输出程序执行花了多少时间
	参数：t1： 表示起始时间，需时间戳形式，即秒数
	返回值：无
	'''
	t2=time.time()
	begin_time=get_time(time_format=cf.TIME_FORMAT3,xtime=t1)
	current_time=get_time(time_format=cf.TIME_FORMAT3,xtime=t2)
	#print('\n----------------------------')
	#print(get_today())
	print("Begin time:",begin_time)
	print("Current time:",current_time)
	#print('要判断上面代码执行花了多少时间，请查看上面最近两个 Current time 之间的时间差。')
	time_spend=seconds_to_hms(t2-t1)
	print("Time spend: ",time_spend,'\n')










def get_uuid():
	'''
	功能说明：该自定义函数用于获取一个 uuid()，并且以时间开头，方便需要时判断
	参数：无
	返回值：生成的十进制 uuid
	'''
	#return int(uuid.uuid1().hex,16) 	# 调用模块 uuid 的 uuid1()函数，生成一个 uuid ，并转成10进制数返回
	s=get_current_time(time_format=cf.TIME_FORMAT,xtime=time.time())
	t=str(int(uuid.uuid1().hex,16)) 	# 调用模块 uuid 的 uuid1()函数，生成一个 uuid ，并转成10进制数
	my_uuid=int(s+t)

	return my_uuid











def get_arr_add(arr1,arr2):
	'''
	功能说明：计算两个数组（相同维度）对应元素（必须数值型）的加法，把结果保留4位小数放在新的数组里返回
	'''
	result_arr = None

	if len(arr1) != len(arr2):
		print('错误！  %s 和 %s 维数不相等' % (str(arr1),str(arr2)))
		return None
	else:
		try:
			arr = list((np.array(arr1) + np.array(arr2)))
		except:
			print('错误！ 两数组对应元素相加出错，请确保数组元素为数值型。')
			return None
		else:
			result_arr = [xround(x,4) for x in arr]

	return result_arr	










def get_arr_sub(arr1,arr2):
	'''
	功能说明：计算两个数组（相同维度）对应元素（必须数值型）的减法，把结果保留4位小数放在新的数组里返回
	'''
	result_arr = None

	if len(arr1) != len(arr2):
		print('错误！  %s 和 %s 维数不相等' % (str(arr1),str(arr2)))
		return None
	else:
		try:
			arr = list((np.array(arr2) - np.array(arr1)))
		except:
			print('错误！ 两数组对应元素相加出错，请确保数组元素为数值型。')
			return None
		else:
			result_arr = [xround(x,4) for x in arr]

	return result_arr	











def get_arr_multiply(arr1,arr2):
	'''
	功能说明：计算两个数组（相同维度）对应元素（必须数值型）的乘积，把结果保留4位小数放在新的数组里返回
	'''
	result_arr = None

	if len(arr1) != len(arr2):
		print('错误！  %s 和 %s 维数不相等' % (str(arr1),str(arr2)))
		return None
	else:
		try:
			arr = list((np.array(arr1) * np.array(arr2)))
		except:
			print('错误！ 两数组对应元素相乘出错，请确保数组元素为数值型。')
			return None
		else:
			result_arr = [xround(x,4) for x in arr]

	return result_arr	










# 计算两个数组（相同维度）对应元素相除，把结果放在新的数组里
def get_arr_devide(arr1,arr2):
	'''
	功能说明：计算两个数组（相同维度）对应元素（必须数值型）的除法，把结果保留4位小数放在新的数组里返回
	'''
	result_arr = None

	if len(arr1)==0 or len(arr1) != len(arr2):
		print('错误！ %s 为空，或 %s 和 %s 维数不相等' % (str(arr1),str(arr1),str(arr2)))
		return None
	else:
		try:
			arr = list((np.array(arr2) / np.array(arr1)))
		except:
			print('计算出错，可能 %s 数组中含有 0 值' % (str(arr1)))
			return None
		else:
			result_arr = [xround(x,4) for x in arr]

	return result_arr












def get_arr_ratio(arr1,arr2):
	'''
	功能说明：计算两个等长数组 arr1 和 arr2 的各对应元素差值后的幅度，即 (arr2 - arr1 ) / arr1 这个意思，具体要用到 numpy ，python 的 list 无法直接这样计算，必须先转成 numpy 的 array 才行。

	'''

	if len(arr1)==0 or len(arr1) != len(arr2):
		print('错误！ %s 为空，或 %s 和 %s 维数不相等' % (str(arr1),str(arr1),str(arr2)))
		return None
	else:
		try:
			arr = list((np.array(arr2) - np.array(arr1)) / np.array(arr1))
		except:
			print('计算出错，可能 %s 数组中含有 0 值' % (str(arr1)))
			return None
		else:
			result_arr = [xround(x,4) for x in arr]

	return result_arr










def is_valid_date(xdate):
	'''
	功能说明：判断是否日期
	参数：xdate: 表示传入的日期
	返回值：True: 表示传入的的确是日期；False: 表示传入的不是日期

	'''

	try:
		time.strptime(xdate,cf.DATE_FORMAT1)
	except:
		return False
	else:
		return True












def str_to_pydate(xdate):
	'''
	功能说明：将字符串形的日期，转化成python datetime.date() 表示的日期
	参数：xdate: 字符串形式的日期
	返回值：py 形式的日期

	'''
	py_date='' 		# 如果传进来的日期是有效的，则转化成 datetime.date(y,m,d) 形式，并传递给变量 py_date

	if is_valid_date(xdate) == True:
		temp_arr=xdate.split('-')
		y=int(temp_arr[0]) 		# 获取并转化年
		m=int(temp_arr[1]) 		# 获取并转化月
		d=int(temp_arr[2]) 		# 获取并转化日
		py_date=datetime.date(y,m,d)

	return py_date













def str2pydate(xdate):
	'''
	功能说明：将字符串形的日期，转化成python datetime.date() 表示的日期。该函数和上面这个是一样的
	参数：xdate: 字符串形式的日期
	返回值：py 形式的日期

	'''
	py_date = str_to_pydate(xdate=xdate)
	return py_date









def df2list(df):
	'''
	功能说明：将 df 转成二维数组（包括列名）
	参数：df: pandas的 DataFrame数据
	返回值：二维数组

	'''
	col = list(df.columns)
	np_arr = df.as_matrix() 		# 把 df 转成 numpy 上的二维矩阵（即二维数组），二维数组中的每一行对应 df 中的一行
	d2_arr = [col]

	for i in np_arr:
		d2_arr.append(list(i))

	return d2_arr		













def df2tuple(df):
	'''
	功能说明：将 df 转成二维元组（包括列名），即整个是元组，里面每一行也是元组
	参数：df: pandas的 DataFrame数据
	返回值：二维元组

	'''	

	d2_tpl = []

	d2_arr = df2list(df=df)
	for i in d2_arr:
		d2_tpl.append(tuple(i))
	d2_tpl = tuple(d2_tpl)

	return d2_tpl










def df2table(df = None,align = 'center',color_flag = False,fore_color1 = None,fore_color2 = None,bgcolor1 = "#F5F5DC",bgcolor2 = "#A7EEFB"):
	'''
	功能说明：将DF 转成 html 的 table 形式，并以字符串形式返回，主要是为了发电子邮件用
	参数：df:待转换的 pandas DataFrame数据；align:对齐方式；color_flag:要不要用前景色背景色装饰表格；
		fore_color1: 前景色1（即定体颜色）；fore_color2:前景色2（字体颜色）；bgcolor1: 表格行背景色1；bgcolor2:表格行背景色2
	返回值：字符串形式的 html table

	'''
	if df is None:
		print('错误！ 没有传入 DataFrame.')
		print(' df2table(df) 函数功能是将 pandas 的 DataFrame 转成 html 下的 <table>形式。用法: 参数 df 必须是 pandas 的 DataFrame 格式，不能为空。返回值是字符串形式的 html 下的 <table>，可独立作网页使用，也可拼接到其他 html 页面使用。')
		return ''

	d2_arr = df2list(df=df)

	# 预设表格行的前景色为黑色（即字体为黑色）
	fore_color = 'black'

	if fore_color1 is None:
		fore_color1 = fore_color

	if fore_color2 is None:
		fore_color2 = fore_color

	s = '''
		<script src="https://cdn.bootcss.com/jquery/3.2.1/jquery.min.js"></script>
		<div style="text-align:%s;">
		<table width="500" border=1 style="word-break:norawp;">
		''' % (align)
		
	for k1,v1 in enumerate(d2_arr):
		# 设置前景色
		if color_flag == True:
			if k1 % 2 == 0:
				fore_color = fore_color1
			else:
				fore_color = fore_color2

		# 设置前景色
		s += '<tr style="color:%s;">' % (fore_color)
		for k2,v2 in enumerate(v1):
			s += '<td>' + str(v2) + '</td>'

		s += '</tr>'

	s += '</table></div>'

	# 设置背景色
	if color_flag == True:
		s += ''' 
			<script>
			$(document).ready(function(){
			//隔行表色
			$("tr:even").css("background-color", "%s"); //为双数行表格设置背颜色素
			$("tr:odd").css("background-color", "%s");})
			</script>
			''' % (bgcolor1,bgcolor2)


	return s











def df2webpage(df = None,align = 'center',color_flag = False,fore_color1 = None,fore_color2 = None,bgcolor1 = "#F5F5DC",bgcolor2 = "#A7EEFB"):
	'''
	功能说明：将DF 转成 html page 形式，并以字符串形式返回，主要是为了发电子邮件用
	参数：df:待转换的 pandas DataFrame数据；align:对齐方式；color_flag:要不要用前景色背景色装饰表格；
		fore_color1: 前景色1（即定体颜色）；fore_color2:前景色2（字体颜色）；bgcolor1: 表格行背景色1；bgcolor2:表格行背景色2
	返回值：字符串形式的 html page

	'''
	if df is None:
		print('错误！ 没有传入 DataFrame.')
		print(' df2table(df) 函数功能是将 pandas 的 DataFrame 转成 html 下的 <table>形式。用法: 参数 df 必须是 pandas 的 DataFrame 格式，不能为空。返回值是字符串形式的 html 下的 <table>，可独立作网页使用，也可拼接到其他 html 页面使用。')
		return ''

	d2_arr = df2list(df=df)

	# 预设表格行的前景色为黑色（即字体为黑色）
	fore_color = 'black'

	if fore_color1 is None:
		fore_color1 = fore_color

	if fore_color2 is None:
		fore_color2 = fore_color

	s = '''
		<html>
		<head>
		<style type="text/css">
		td
		{
			white-space: nowrap;
		}
		</style>
		<script src="https://cdn.bootcss.com/jquery/3.2.1/jquery.min.js"></script>

		</head>
		<body>
		<div style="text-align:%s;"><table width="500" border=1 style="word-break:norawp;">
		''' % (align)
		
	for k1,v1 in enumerate(d2_arr):
		# 设置前景色
		if color_flag == True:
			if k1 % 2 == 0:
				fore_color = fore_color1
			else:
				fore_color = fore_color2

		# 设置前景色
		s += '<tr style="color:%s;">' % (fore_color)
		for k2,v2 in enumerate(v1):
			s += '<td>' + str(v2) + '</td>'

		s += '</tr>'

	s += '</table></div>'

	# 设置背景色
	if color_flag == True:
		s += ''' 
			<script>
			$(document).ready(function(){
			//隔行表色
			$("tr:even").css("background-color", "%s"); //为双数行表格设置背颜色素
			$("tr:odd").css("background-color", "%s");})
			</script>
			''' % (bgcolor1,bgcolor2)

	s += '</body></html>'

	return s













def get_current_function_name():
	'''
	功能说明：当该函数被调用时，将返回上级函数（即主调函数）的函数名，所以一般用它放在函数内部来获取函数名 
	'''
	# return sys._getframe(0).f_code.co_name 		# 返回本函数名
	return sys._getframe(1).f_code.co_name 			# 返回上级函数名（或模块名）














# 
def start_app_by_pywinauto(app_path, retry_count = 5, wait_for_ready = 10):
	'''
	说明：调用 pywinauto 的 application.Application()功能来启动一个 app_path（一般是指 windows 下的 exe 程序），并返回指向这个 exe 程序的对象（句柄）到主调函数 
	参数：app_path, 要启动的应用程序全路径；retry_count: 启动失败的话最多尝试的次数；wait_for_ready，启动成功后最多等待的秒数，为了充分就绪
	返回值：若启动成功，则返回指向应用程序的句柄，否则返回 None
	'''
	func_name = get_current_function_name() + ': ' 		# 取得本函数名，即 start_app_by_pywinauto

	app = None

	xcount = 0
	while True:
		if xcount >= retry_count:
			return None 			# 如果尝试 retry_count 次后，仍失败，则返回 None 到主调函数

		try:
			app = application.Application().connect(path = app_path) 			# 尝试连接佣金宝客户端
		except:
			try:
				app = application.Application().start(app_path) 		# 尝试启动佣金宝客户端
			except:
				#raise Exception('pywinauto 找不到程序 ' + app_path)
				pass
			else:
				print(func_name + '%s 第一次启动。成功。' % (app_path))
				time.sleep(wait_for_ready) 	# 这个时间设长一点好，以便等待上述应用启动并准备就绪 ，8秒一般是够了，如果不够，则继续加大
				return app 		# 如果启动成功，则将 app 返回主调函数
		else:
			print(func_name + '%s 已启动在那里，无需重复启动。' % (app_path))
			return app 			# 如果连接成功，则将 app 返回主调函数

		xcount += 1
		print(func_name + '已尝试 %s 次（将总共尝试 %s 次）。' % (str(xcount),str(retry_count)))

	if app is None:
		print(func_name + '启动 %s 失败。' % (app_path))

	return app










# 该函数没有返回值，调用后将带致指定 app（应用程序，一般由 pywinauto 创建）下的 标题为 window_title 的窗口，并该窗口上方的杂七杂八各种弹出窗口都关掉，只留主窗口
def goto_window(app,window_title,retry_count=100):
	'''
	功能说明：该函数用于返回到程序为 app 的 window_title 窗口上，并强烈清除该窗口下弹出的所有子孙窗口
	'''
	func_name = get_current_function_name() + ': '

	if app==None:
		print(func_name + '目标应用程 app 还没启动，请先调用 start_app_by_pywinauto() 启动目标程序。')
		return None

	# 根据窗口标题来清除其上所有窗口
	xcount = 0
	while True:
		if xcount >= retry_count:
			break
		xtitle = app.top_window().texts()[0] 		# 取得程序顶层窗口（即最上面一层，top window）的标题
		if xtitle != window_title: 					# 如果顶层窗口标题和传入的不一致，则把该窗口关了
			app.top_window().close()
			xcount += 1			
			time.sleep(cf.TIME_GAP)						
		else:
			break












# 获取日志对象名，以便记录日志
def get_logname(log_file):
	'''
	说明：该函数用于获取一个日志对象名，以便主调函数用该对象名记录日志，日志将保存在传入的路径文件 log_file 上。
	参数：log_file: 用于保存日志的文件（必须带全路径名称）
	返回值：日志对象名
	'''
	logname = logging.getLogger('myloggernice') 			# 随意创建一个日志对象名
	logname.setLevel(logging.DEBUG)
	#logname.handlers.clear()  						# 每次创建 logging 对象后先清除各种句柄，防止重复输出
	 
	# 创建一个handler，用于写入日志文件
	'''
	if log_file is None:
		report_path = get_report_path()
		log_file = report_path + cf.LOG_FILE
	'''
	fh = logging.FileHandler(log_file)
	#fh.setLevel(logging.DEBUG)

	# 再创建一个handler，用于输出到控制台
	ch = logging.StreamHandler()
	#ch.setLevel(logging.DEBUG)
	# 定义handler的输出格式
	formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(funcName)s - %(message)s')
	fh.setFormatter(formatter)
	ch.setFormatter(formatter)

	# 给logger添加handler
	logname.addHandler(fh)
	logname.addHandler(ch)

	return logname












# 获取日志对象名，以便记录日志
def log_msg(logname,message):
	'''
	说明：该函数用于将传入的message 记录到传入的 logname 上去
	参数：logname:传入的logger对象名，由上面那个函数获取；message: 待记录的信息
	返回值：无
	'''	
	logname.info(message)


	# 添加下面一句，在记录日志之后移除句柄
	logname.removeHandler(fh)
	logname.removeHandler(ch)








def char_fill(s,bit=6,char='0',position='L'):
	'''
	功能说明：给传入的字符串 s 在 position （L代表左，即头部，R 代表右，即尾部）位置，用 字符（数字）c 填充，使之总长度为 bit 位
	参数：s: 待补齐前导字符或后导字符的字符串；bit: 补齐后的字符串位数; char: 要补什么字符；position: 补左边还是右边
	返回值：补齐后的字符串

	'''
	xresult = s
	if len(s)<bit:
		if position=='L' or position == 'l':
			xresult=char * (bit - len(s)) + s
		if position=='R' or position == 'r':
			xresult=s + char * (bit - len(s))

	return xresult











def attach_mail_image(msgRoot,fn_arr,mode='inline'):
	'''
	功能说明：msgRoot 是邮件基信息定义，一般由 email 包下的 Multipart() 函数的返回值得到，fn_arr 是个数组，每个元素是图片文件所在的全路径（含图片文件名），该函数的作用是把 fn_arr 数组中每条路径上的图片以邮件格式附加到 msgRoot，并把 msgRoot 带回主调函数，mode 表示图片内嵌到正文还是以附件形式
	# 首先要构造 Multipart，有3种参数类型，分别是 mixed, related, alternative. 有效范围依次递减，mixed 级别最大，可以发文件邮件，HTML邮件，内嵌图像，发附件等等 
	msgRoot = MIMEMultipart('mixed')  		# MIMEMultipart 表示允许附件在邮件正文件中直接显示

	'''
	#for k,img_file in enumerate(msg_dict['fn_arr']):
	for k,img_file in enumerate(fn_arr):
		img_pos = '<p><img src="cid:imgid%d" /></p>' % (k)
		
		msgRoot.attach(MIMEText(img_pos,'html','utf-8'))

		fp = open(img_file, 'rb')
		msgImage = MIMEImage(fp.read())
		fp.close()

		# 图片以内嵌方式发
		if mode == 'inline':
			msgImage.add_header('Content-ID', '<imgid%d>' % (k))
			#msgImage["Content-Disposition"] = 'inline; filename="imgid%s"' % (str(k))

		# 图片以附件方式发
		if mode == 'attachment':
			msgImage.add_header("Content-Disposition", "attachment", filename=os.path.split(img_file)[1])
			#msgImage["Content-Disposition"] = 'attachment; filename="%s"' % (os.path.split(img_file)[1])
			
		msgRoot.attach(msgImage)

	return msgRoot











def send_mail(msg_dict,smtp_server,smtp_port,sender_email,sender_password,receiver_arr,mode='inline'):
	'''
	功能说明：自定义发邮件函数，
	参数：msg_dict: 为邮件标题和内容构成的字典，只需包含content 和 subject 两项即可，有其他项数据也是可以的; 
		smtp_server: smtp 服务器IP或域名；smtp_port: smtp 服务器端口；
		sender_email: 邮件发送者的email 地址；sender_passwprd: 发送者的密码；
		receiver_arr: 邮件接收者email 构成的数组；mode 取值为 inline 或 attachment，表示对图片是内嵌方式发还是附件形式发
		注意，参数 receiver_arr 必须为数组形式，每个元素是字符串，内容是email 地址，如果有多个收件人，则在数组中以逗号分割; sender: 发件人的邮箱地址，字符串格式。
	返回值：无

	'''

	# 构造邮件信息 
	# 首先要构造 Multipart，有3种参数类型，分别是 mixed, related, alternative. 有效范围依次递减，mixed 级别最大，可以发文件邮件，HTML邮件，内嵌图像，发附件等等 
	msgRoot = MIMEMultipart('mixed')  		# MIMEMultipart 表示允许附件在邮件正文件中直接显示

	msgText = MIMEText(msg_dict['content'],'html','utf-8')			# 中文需参数‘utf-8’，单字节字符不需要 
	msgRoot.attach(msgText)

	msgRoot['Subject'] = msg_dict['subject']
	#msgRoot['From'] = formataddr(['清风',cf.MAIL_SENDER])
	#msgRoot['To'] = formataddr(['Friend',','.join(receiver_arr)])
	msgRoot['From'] = formataddr(['',sender_email])
	msgRoot['To'] = formataddr(['',','.join(receiver_arr)])


	# 如果存在图片要发送，则把图片附加到邮件上
	if 'fn_arr' in msg_dict.keys():
		msgRoot = attach_mail_image(msgRoot = msgRoot,fn_arr=msg_dict['fn_arr'],mode=mode)


	try:
		'''
		# 连接邮件服务器
		smtp = smtplib.SMTP_SSL(cf.SMTP_SERVER,cf.SMTP_PORT)  
		# 登录 
		smtp.login(cf.MAIL_SENDER, cf.MAIL_PASSWORD)  
		'''
		# 连接邮件服务器
		smtp = smtplib.SMTP_SSL(smtp_server,smtp_port)
		# 登录
		smtp.login(sender_email,sender_password)
		# 发送
		smtp.sendmail(sender_email, receiver_arr, msgRoot.as_string()) 
		print('Mail sent to %s successfully.' % (str(receiver_arr)))
		smtp.quit()  	
	except:
		print("邮件发送失败。")   










def handle_verify_code(code_image):
	'''
	功能说明：处理验证码，传入的参数 code_image 为待处理的验证码图片（不是图片文件，而是图片数据）
	参数：code_image: 待处理的验证码图片（不是图片文件，而是图片数据）
	返回值：文本验证码

	'''
	xresult = None
	image_path = tempfile.mktemp()+'.jpg'
	code_image.capture_as_image().save(image_path)
	time.sleep(cf.TIME_GAP)
	vcode = recognize_verify_code(image_path=image_path)
	if vcode is not None:
		xresult = ''.join(re.findall('[a-zA-Z0-9]+', vcode))

	return xresult










def recognize_verify_code(image_path):
	'''
	功能说明：识别验证码，其中具体调用下面的 recognize_code_by_tesseract() 来识别
	参数：image_path: 图片路径
	返回值：文件形式的验证码

	'''
	vcode = None
	img = Image.open(image_path)
	vcode = recognize_code_by_tesseract(img=img) 			# 调用 tesseract 识别

	return vcode









def recognize_code_by_tesseract(img):
	'''
	功能说明：调用 pytesseract 识别验证码。 pytesseract 识别准确率不是很高，但也够用了
	参数：img:传入的的图片文件路径
	返回值：对图片识别后的文件验证码字符返回

	'''
	try:
		res = pytesseract.image_to_string(img)
	except:
		print('pytesseract 未安装 或 tesseract-OCR 未安装，或已安装但传给 pytesseract 的参数有问题，验证码无法识别。')
		return None

	valid_chars_arr = re.findall('[0-9a-z]', res, re.IGNORECASE)
	vcode = ''.join(valid_chars_arr)

	return vcode












def num2words( change_number ):
	"""
	说明：转换数字为大写货币格式( format_word.__len__() - 3 + 2位小数 )
	change_number 支持 float, int, long, string
	"""
	format_word = ["分", "角", "元",
			   "拾","佰","仟","万",
			   "拾","佰","仟","亿",
			   "拾","佰","仟","万",
			   "拾","佰","仟","兆"]

	format_num = ["零","壹","贰","叁","肆","伍","陆","柒","捌","玖"]
	if type( change_number ) == str:
		# - 如果是字符串,先尝试转换成float或int.
		if '.' in change_number:
			try:
				change_number = float( change_number )
			except:
				print('无法转换 %s' % (str(change_number)))
				return None
		else:
			try:
				change_number = int( change_number )
			except:
				print('无法转换 %s' % (str(change_number)))
				return None

	if type( change_number ) == float:
		real_numbers = []
		for i in range( len( format_word ) - 3, -3, -1 ):
			if change_number >= 10 ** i or i < 1:
				real_numbers.append( int( round( change_number/( 10**i ), 2)%10 ) )

	elif isinstance( change_number, (int) ):
		real_numbers = [ int( i ) for i in str( change_number ) + '00' ]

	else:
		print('无法转换 %s' % (str(change_number)))
		return None

	zflag = 0                       #标记连续0次数，以删除万字，或适时插入零字
	start = len(real_numbers) - 3
	change_words = []
	for i in range(start, -3, -1):  #使i对应实际位数，负数为角分
		if 0 != real_numbers[start-i] or len(change_words) == 0:
			if zflag:
				change_words.append(format_num[0])
				zflag = 0
			change_words.append( format_num[ real_numbers[ start - i ] ] )
			change_words.append(format_word[i+2])

		elif 0 == i or (0 == i%4 and zflag < 3):    #控制 万/元
			change_words.append(format_word[i+2])
			zflag = 0
		else:
			zflag += 1

	if change_words[-1] not in ( format_word[0], format_word[1]):
		# - 最后两位非"角,分"则补"整"
		change_words.append("整")

	return ''.join(change_words)









# ----------------------
# 几个数据爬虫相关函数

def get_prefixed_code(code,c_index=False):
	'''
	对传入的股票代码 code 加前缀（0 代表上证交易所，1代表深圳交易所），以适应网易数据源（历史和实时都是这种格式）要求
	c_index 表示传入的是否为大盘指数，因为指数处理办法稍微有点不同，注意，传入的大盘指数，必须指数代码前面加上'sh' 或'sz'等前缀
	返回加了前缀后的股票代码
	'''
	func_name = get_current_function_name() + ': '	
	prefixed_code = None 			# 加前缀后的股票代码，预设 None
	code=str(code) 			# 转成字符串

	if c_index == False: 			# 如果不是指数，流程进入这里
		if len(code)!=6:
			print(func_name + '错误！股票代码必须为6位数，且为字符串形式')
			return None
		code_place='0' 		# 0 代表上证交易所，1代表深圳交易所
		if code[:2]=='60':
			code_place='0'
		if code[:2]=='00' or code[0:2]=='30':
			code_place='1'

	if c_index == True: 			# 如果是指数，则流程进入这里
		if len(code) != 8:
			print(func_name + '错误！ 指数代码请在代码前加前缀 sh(上证)，sz（深证）')
			return None
		if code in cf.SH_INDEX_ARR or code[:2].upper() == 'SH':
			code_place='0'
			code = code[-6:]
		if code in cf.SZ_INDEX_ARR or code[:2].upper() == 'SZ':
			code_place='1'
			code = code[-6:]

	prefixed_code = code_place + code

	return prefixed_code









# 用网易数据源生成 URL
# 生成一个指向数据源的 URL, c_index 表示是否大盘指数，即传入的代码是否表示大盘，默认为False ，即不是大盘，而是个股 code 
def get_url(code,xbegin='',xend='',c_index=False,ds=cf.URL_DICT['163']):

	func_name = get_current_function_name() + ': '	 			# 获取函数名
	if xbegin=='':
		xbegin=get_today()
	if xend=='':
		xend=get_today()

	url=''
	base_url=ds 		# 选择163数据源

	if (not is_valid_date(str(xbegin))) or (not is_valid_date(str(xend))):
		print(func_name + '输入的日期或格式有误')
		return None

	d1=''.join(str(xbegin).split('-')) 		# 调整日期格式，以适应163接口
	d2=''.join(str(xend).split('-'))

	prefixed_code = get_prefixed_code(code=code,c_index=c_index)

	'''
	# 下面的字段对应的中文名称为：开盘价，最高价，收盘价，最低价，昨收价，涨跌额，涨跌幅，成交量，成交金额，换手率，总市值，流通市值
	xfields="TOPEN;HIGH;LOW;TCLOSE;LCLOSE;CHG;PCHG;VOTURNOVER;VATURNOVER;TURNOVER;TCAP;MCAP"
	url=base_url+'code='+code_place+code+'&'+'start='+d1+'&'+'end='+d2+'&'+'fields='+xfields
	'''
	if prefixed_code is not None:
		url=base_url % (prefixed_code,d1,d2) 		# 将实际值（即 % 后面括号里的值）代入到 base_url 中去

	return url









# 所有到网上去取的功能函数都以 dl_ 开头
# 下载（获取）指定 URL 的页面源码
def dl_page(url):  #获取页面数据
	req=urllib.request.Request(url,headers={
		'Connection': 'Keep-Alive',
		'Accept': 'text/html, application/xhtml+xml, */*',
		'Accept-Language':'zh-CN,zh;q=0.8',
		'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko'
	})
	opener=urllib.request.urlopen(req)
	page=opener.read()
	return page  	# 不同网站返回的 page 可能编码不同，这点由主调函数来处理
















def dl_k_data(code,xbegin,xend,c_index=False,ds=cf.URL_DICT['163']):
	'''
	调用自定义函数从（网易）获取历史K线数据，如果是指数代码的话要加前缀，如上证综指：sh000001，深证成指：sz399001

	'''
	func_name = get_current_function_name() + ': '

	# 判断日期若是字符串类型，则先转成 py date 类型，因为后面要用 py date 类型处理
	if type(xbegin) == str:
		xbegin = str2pydate(xdate = xbegin)

	if type(xend) == str:
		xend = str2pydate(xdate = xend)

	# 判断起始日期是否为双休日，若是，则跳过双休，从下周一开始拉数据		
	n = xbegin.weekday()
	if n in [5,6]:
		xbegin = xbegin + (7 - n) * one_day_step 			# 这样处理后， xbegin 就是下周一了

	if (str(xbegin)>str(xend)):
		print(func_name + '错误！请确保起始日期小于或等于结束日期')
		return None
	
	k_df=[]

	url=get_url(code=code,xbegin=xbegin,xend=xend,c_index=c_index,ds=ds) 		# 根据指定的股票代码和日期范围，生成数据源 url （数据源暂定网易）
	#url=get_url(code=code)

	retry_count = 100 			# 计数器，表示尝试几次
	xcount = 0
	# 用循环和异常拉数据，因为拉数据时太频繁经常要被服务器踢，所以这里这样做加强稳定性，减少出错机会
	while True:
		if xcount > retry_count:
			return None
		try:
			page=dl_page(url=url) 				# 到指定的数据源网址下载数据（这里下载下来是包含数据的页面源码）
		except:
			xcount += 1

			s = random.randint(10,60)
			print(func_name,'\n由于被服务器踢，休息 %s 秒后将自动继续尝试拉数据。' % (str(s)))
			time.sleep(s) 			# 如果被服务器踢，则停止3秒再拉数据
			continue
		else:
			break
	#print(page)
	# 自动检测源码不太可靠，所以把下面这几行注释掉，强制认为源编码为 GBK，然后用 decode() 转为 unicode
	'''
	det=chardet.detect(page) 				# 检测页面源码的编码
	if(det['confidence']>=0.7): 			# 如果可信度大于70%，就相信检测结果，然后采用该编码进行 decode() ,使页面源码转化到 unicode （utf-8）
		page=page.decode(det['encoding'])   	# 顺便说明：decode('gb2312') 的意思就是把 gb2312 编码的内容转化成 unicode, 即 decode() 的结果就是把其他编码转成 unicode ，而encode('big5') 总是把
											# unicode 编码转成其他编码，如转成 big5 
	'''
	page=page.decode('gbk')

	page_arr=page.split('\r\n') 		# 返回的 page是一条长长的字符，以分割符 \r\n 将这长长的字符串切断，并把每段字符串保存到数组 page_arr 中

	col_arr=page_arr[0].split(',') 		# page_arr 中第一个元素（即字符串）为中文列名串接，提取这些列名到数组 col_arr 中

	if len(page_arr)>=2:
		k_data_arr=page_arr[1:] 			# 从 page_arr 中的第2个元素开始为真正的 k 线数据，但这里他们仍是字符串形式的，需要转化成数组

		k_data_arr=[x.replace("'",'') for x in k_data_arr] 		# 把上述 k_data_arr 中的所有 K线数据中的 ' 号替换为空，即去掉 ' 号
		k_data_arr=[x.split(',') for x in k_data_arr] 			# 将 k_data_arr 中每一行字符串形式的K线数据，转换成 list 形式，这样转换后， k_data_arr 中的每一个元素都成了数组
		k_data_arr=k_data_arr[:len(k_data_arr)-1] 				# 因为网易返回的数据最后一行全是 None ，所以要去掉

		k_df = pd.DataFrame(data=k_data_arr,columns=cf.K_COL_ARR)  	# 把数组形式的K线数据，转换成 DataFrame 形式，以便进一步操作
		k_df.code = code 			# 加这一句的目的是因为传入的指数代码与网易数据源所需的指数代码形式不同所致，从网易拿回数据后，将指数代码恢复成我们自己传入的指数代码形式

		if len(k_df)>0:
			k_df = k_df.sort_values(by = ['date'], ascending = True)
			k_df = k_df.reset_index(drop = True) 					# 用自然数行索引去替换原行索引
			k_df = wash_data(df=k_df,ds=ds,c_index=c_index) 		# 再调用自定义函数清洗
			
	return k_df








# 清洗数据的通用函数，内部调用各源的具体清洗函数
def wash_data(df,c_index=False,ds=cf.URL_DICT['163']):
	if len(df) > 0:
		# 如果是 163 的数据源，则用 163 的清洗函数来清洗
		if ds == cf.URL_DICT['163']:
			df=wash_163_data(df=df,c_index=c_index)

		else:
			print('警告：没有找到相应的数据清洗函数，原数据返回。')

	return df











# 对网易返回的K线数据进行清洗，这是基于分析返回的数据后作出的清洗办法，不具有通用性，只针对网易返回的数据
def wash_163_data(df,c_index=False):
	if len(df)==0:
		return df

	index1_arr=list(df.index)
	code=df.ix[index1_arr[0],'code']



	# 先遍历所有行，去掉 涨跌额为 'None' 的行
	for i in index1_arr:
		if c_index == True:
			# 指数进入这里
			if df.ix[i,'price_change'] == 'None':
				if df.ix[i,'last_close'] == 'None':
					df.ix[i,'last_close'] = df.ix[i,'open'] 			# 如果昨收价不存在，一般是首个交易日，则令其昨收价等于今天开盘价好了
				df.ix[i,'price_change']=str(float(df.ix[i,'close']) - float(df.ix[i,'last_close']))
				df.ix[i,'percent_change']=str((float(df.ix[i,'close']) - float(df.ix[i,'last_close'])) / float(df.ix[i,'last_close']))	

			# 发现中小板指在早期时，即2008-06-27 日及以前的成交额都是 'None', 故用 0 去替换
			if df.ix[i,'amount'] == 'None':
				df.ix[i,'amount'] = 0
		else:
			# 普通股进入这里，因为网易返回的普通股当 price_change 为'None' 时，则当天的 open,high,low.close等全为0 了，所以这行数据就不要了，直接 drop 掉
			if df.ix[i,'price_change'] == 'None':
				df=df.drop(i,axis=0)

	df = df.replace(['None'],[0]) 			# 把 raw 数据中剩余的所有'None' 都替换为 0


	if len(df)==0:
		return df


	# 下面这个 if 是判断指数的，由于指数没有换手率，总市值，流通值等概率，所以给他们置0
	if c_index == True:
		if code in cf.INDEX_ARR:
			df['turnover']=0
			df['total_value']=0
			df['circulation_value']=0


	index1_arr=list(df.index)

	# -------------------------------------
	# 这一节是特殊情况特殊处理

	# 1. 对于000046 这只股，在 1994/9/19，1994/9/16，1994/9/15，1994/9/14，1994/9/13，1994/9/12 这6 个交易日里，其换手率数据为 None，流通值也为 0，所以需要补全
	# 好在该股在这些天有总市值数据，并且根据上述日期附近的总市值和流通值之比（大概4倍），可以近似推算出上述6个交易日的，流通值，再利用成交额数据可近似算出换手率
	if code == '000046':
		temp_index_arr=[] 		# 临时数组，用于存放换手率为 None 的那些行标
		for i in index1_arr:
			if df.ix[i,'turnover'] == 'None':
				df.ix[i,'turnover'] = 0
				temp_index_arr.append(i)
		# 把这三列的数据类型先转换成 float （原先是 string 类型，这是网易返回的默认类型），以便下面进行数学计算
		df.amount=df.amount.astype(dtype=float)
		df.turnover=df.turnover.astype(dtype=float)
		df.total_value=df.total_value.astype(dtype=float)
		df.circulation_value=df.circulation_value.astype(dtype=float)
		# 下面计算缺失的换手率和流通值
		for i in temp_index_arr:
			df.ix[i,'circulation_value'] = df.ix[i,'total_value'] * 0.25 			# 先计算出流通值
			df.ix[i,'turnover'] = df.ix[i,'amount'] * 100 / df.ix[i,'circulation_value'] 		# 再计算出换手率


	if code == '600653':
		temp_index_arr=[] 		# 临时数组，用于存放换手率为 None 的那些行标
		for i in index1_arr:
			if df.ix[i,'turnover'] == 'None':
				df.ix[i,'turnover'] = 0
				temp_index_arr.append(i)
		# 把这三列的数据类型先转换成 float （原先是 string 类型，这是网易返回的默认类型），以便下面进行数学计算
		df.amount=df.amount.astype(dtype=float)
		df.turnover=df.turnover.astype(dtype=float)
		df.total_value=df.total_value.astype(dtype=float)
		df.circulation_value=df.circulation_value.astype(dtype=float)
		# 下面计算缺失的换手率和流通值
		for i in temp_index_arr:
			df.ix[i,'circulation_value'] = df.ix[i,'total_value'] * 0.682 			# 先计算出流通值
			df.ix[i,'turnover'] = df.ix[i,'amount'] * 100 / df.ix[i,'circulation_value'] 		# 再计算出换手率


	# 特殊处理到这里结束
	# =====================================


	# 然后，将所有数值列的值类型（网易返回默认全是 string 类型，包括数值），转换成 float。因 date, code, name 不是数值列，所以要用差集去掉
	for xfield in list(set(list(df.columns)) - set(['date','code','name'])):
		df[xfield]=df[xfield].astype(dtype=float)


	df=df.sort_values(by = ['date'], ascending = True)
	return df










def get_live_data(code_arr=None,xfrom=cf.SOURCE_DICT['sina'],c_index = False):
	'''
	说明：根据传入的股票代码列表，获取它们的实时数据，全部一起形成 df 返回 (列名，值，格式等都已全部规整好，返回即可用)
	参数：code_arr，待取实时数据的股票代码 list； from，表示取自哪个源，一般来自网易或新浪或腾讯； c_index, 表示是否是指数代码
	返回值：实时数据 all_df，df格式 
	'''
	func_name = get_current_function_name() + ': '

	if code_arr is None:
		print(func_name,'错误：请确保参数 code_arr 不为 None.')
		return None

	if len(code_arr) == 0:
		print(func_name,'错误：code_arr 为空数组')
		return None

	code_arr=[char_fill(s=str(x),bit=6) for x in code_arr] 		# 把股票代码补齐到6位

	#print(func_name,'实时数据来自 %s' % (xfrom))

	all_df = None 		# 用于存放返回的实时股票数据

	if xfrom == cf.SOURCE_DICT['netease']:
		package_size = 1000 		# 一次拿几只股的实时数据 (新浪一次性最大支持 800只，网易支持 1000 只)

	if xfrom == cf.SOURCE_DICT['sina']:
		package_size = 800 			# 一次拿几只股的实时数据 (新浪一次性最大支持 800只，网易支持 1000 只)

	count1 = math.ceil(len(code_arr) / package_size) 			# 共需几组才能拿完


	for i in range(count1):
		# 以下返回的实时 tick 数据，所有金额单位为元（注意不是万元），成交量单位为股（注意不是手）
		if xfrom == cf.SOURCE_DICT['netease']:
			df = get_126_live_data(code_arr = code_arr[i*package_size:(i+1)*package_size],c_index = c_index) 			# 允许的最大包为 1000 只左右，超过这个将出错
		if xfrom == cf.SOURCE_DICT['sina']:
			df = get_sina_live_data(code_arr = code_arr[i*package_size:(i+1)*package_size],c_index = c_index) 			# 允许的最大包为 800 只左右，超过这个值将出错

		if df is not None:
			if all_df is None:
				all_df = df.copy(deep=True)
			else:
				all_df = pd.concat([all_df,df])


	if all_df is not None:
		all_df = all_df.reset_index(drop=True) 		# 由于 pd.concat() 会拼接重复索引，所以这里要 reset_index() 一下，drop=True 表示删除原来的索引 

		# 给实时数据增加以下几列 
		all_df[cf.TICK_COL_DICT['max_price']] = xround(f=all_df[cf.TICK_COL_DICT['last_close']] * cf.UP_LIMIT,bit=2) 			# 每一只股当天的涨停价
		all_df[cf.TICK_COL_DICT['min_price']] = xround(f=all_df[cf.TICK_COL_DICT['last_close']] * cf.DOWN_LIMIT,bit=2) 			# 每一只股当天的跌停价
		all_df['bid1_amount'] = all_df[cf.TICK_COL_DICT['bidvol1']] * all_df[cf.TICK_COL_DICT['bid1']] 							# 计算撮合额，单位为元
		all_df['bid1_amount'] = all_df['bid1_amount'].astype(dtype=int) 		# 把撮合额列转化为整型		
		all_df['ask1_amount'] = all_df[cf.TICK_COL_DICT['askvol1']] * all_df[cf.TICK_COL_DICT['ask1']] 							# 计算撮合额，单位为元
		all_df['ask1_amount'] = all_df['ask1_amount'].astype(dtype=int) 		# 把撮合额列转化为整型

		# 计算买1和卖1 的幅度
		all_df['bid1_percent'] = (all_df[cf.TICK_COL_DICT['bid1']] - all_df[cf.TICK_COL_DICT['last_close']]) / all_df[cf.TICK_COL_DICT['last_close']]	
		all_df['ask1_percent'] = (all_df[cf.TICK_COL_DICT['ask1']] - all_df[cf.TICK_COL_DICT['last_close']]) / all_df[cf.TICK_COL_DICT['last_close']]

		# 计算开盘幅度
		all_df['open_percent'] = (all_df[cf.TICK_COL_DICT['open']] - all_df[cf.TICK_COL_DICT['last_close']]) / all_df[cf.TICK_COL_DICT['last_close']]	

		print(func_name,'共取到 %s 只股的实时数据' % (len(all_df)))

	return all_df









def get_126_live_data(code_arr,c_index = False):
	'''
	说明：根据传入的股票代码数组，根据经验最好一次性不超过 1000 只，到网易126 获取实时数据，以 df 形式返回
	参数：code_arr, 待取实时数据的股票代码列表，c_index 表示是否是指数，默认 False
	返回值：df, 相应股票的实时数据，df 格式
	'''
	func_name = get_current_function_name() + ': '
	if len(code_arr) > 1000:
		print(func_name,'错误：请确保单次取实时数据最大不超过 1000 只股。')
		return None

	url = get_126_live_url(code_arr = code_arr,c_index = c_index)
	retry_count = 100
	xcount = 0
	while True:
		if xcount > retry_count:
			return None
		try:
			page = dl_page(url = url) 		# 这个 url 返回的数据为字节流
		except:
			s = random.randint(10,60)
			print(func_name,'\n由于被服务器踢，休息 %s 秒后将自动继续尝试拉数据。' % (str(s)))
			time.sleep(s) 			# 如果被服务器踢，则停止3秒再拉数据
		else:
			break
		xcount += 1
		
	page = page.decode('utf8') 		# 将字节流解码为 utf8 字符串，以便后续处理

	data_json = page[21:-2] 		# 从网易返回的实时数据看，取这个范围可以得到 json 格式的股票实时数据
	df = pd.read_json(data_json,orient='index') 		# orient 取 'index' 也是从上面返回的 json 数据分析而来的，read_json() 的具体参数请查阅pandas
	df.pop('arrow') 		# 这列不知道干吗用的，去掉它

	df = df.reset_index(drop = True)
	df = netease_to_standard(df = df) 		# 将网易实时tick数据转成标准字段名且规范部分值

	return df









def get_sina_live_data(code_arr,c_index = False):
	'''
	说明：根据传入的股票代码数组，根据经验最好一次性不超过 800 只，到新浪 获取实时数据，以 df 形式返回
	参数：code_arr, 待取实时数据的股票代码列表，c_index 表示是否是指数，默认 False
	返回值：df, 相应股票的实时数据，df 格式
	'''	
	func_name = get_current_function_name() + ': '
	if len(code_arr) > 800:
		print(func_name,'错误：请确保单次取实时数据最大不超过 800 只股。')
		return None

	df = None
	
	retry_count = 100
	xcount = 0

	while True:
		if xcount > retry_count:
			return None
		try:
			if c_index == False:
				df = ts.get_realtime_quotes(code_arr)
			if c_index == True:
				if len(code_arr) == 1 and code_arr[0] == cf.SH_INDEX_DICT['shzz']: 		# 上证综指
					df = ts.get_realtime_quotes(['sh'])
				else:
					print(func_name,"错误：目前暂时只支持对上证综指的实时数据获取。请确保传入的 code_arr = ['sh000001']")
					return None
		except:
			s = random.randint(10,60)
			print(func_name,'\n由于被服务器踢，休息 %s 秒后将自动继续尝试拉数据。' % (str(s)))
			time.sleep(s) 			# 如果被服务器踢，则停止3秒再拉数据
		else:
			break
		xcount += 1

	if df is not None:
		df = df.reset_index(drop=True)
		df = sina_to_standard(df = df) 		# 将新浪实时tick数据转成标准字段名且规范部分值

	return df








def get_126_live_url(code_arr,c_index=False):
	'''
	该函数根据传入的股票代码数组，和数据源DS
	返回一个适合数据源（实际上是126的live 数据源）的URL
	'''
	func_name = get_current_function_name() + ': '

	if len(code_arr)==0:
		print(func_name + '错误！传入的数组 code_arr 不能为空。')
		return None

	url=''
	base_url=cf.URL_DICT['126live'] 			# 选择 126 实时数据源
	
	code_str=''

	for k,code in enumerate(code_arr):
		code_str += get_prefixed_code(code=code,c_index=c_index) + ','
	
	url=base_url % (code_str) 		# 将实际值（即 % 后面括号里的值）代入到 base_url 中去

	return url











def get_prefixed_code(code,c_index=False):
	'''
	对传入的股票代码 code 加前缀（0 代表上证交易所，1代表深圳交易所），以适应网易数据源（历史和实时都是这种格式）要求
	c_index 表示传入的是否为大盘指数，因为指数处理办法稍微有点不同，注意，传入的大盘指数，必须指数代码前面加上'sh' 或'sz'等前缀
	返回加了前缀后的股票代码
	'''
	func_name = get_current_function_name() + ': '	
	prefixed_code = None 			# 加前缀后的股票代码，预设 None
	code=str(code) 			# 转成字符串

	if c_index == False: 			# 如果不是指数，流程进入这里
		if len(code)!=6:
			print(func_name + '错误！股票代码必须为6位数，且为字符串形式')
			return None
		code_place='0' 		# 0 代表上证交易所，1代表深圳交易所
		if code[:2]=='60':
			code_place='0'
		if code[:2]=='00' or code[0:2]=='30':
			code_place='1'

	if c_index == True: 			# 如果是指数，则流程进入这里
		if len(code) != 8:
			print(func_name + '错误！ 指数代码请在代码前加前缀 sh(上证)，sz（深证）')
			return None
		if code in cf.SH_INDEX_ARR or code[:2].upper() == 'SH':
			code_place='0'
			code = code[-6:]
		if code in cf.SZ_INDEX_ARR or code[:2].upper() == 'SZ':
			code_place='1'
			code = code[-6:]

	prefixed_code = code_place + code

	return prefixed_code













def netease_to_standard(df=None):
	'''
	说明：将传入的 df 网易实时 tick 字段名转为标准字段名，其名称映射在配置文件 common_config.py 中 NETEASE_COL_DICT 中定义
	参数：df ，必须是网易实时 tick 数据
	返回值：netease_tick_df, 标准字段名的 tick DataFrame
	'''
	func_name = get_current_function_name() + ': '
	if df is None:
		print(func_name,'错误：没有来自网易的 tick DataFrame传入')
		return None

	netease_tick_df = df.rename(columns=cf.NETEASE_COL_DICT) 		# 转换列名称
	netease_tick_df = netease_tick_df.reset_index(drop = True) 		# 重建索引，从 0 开始自然增长

	netease_tick_df['code'] = netease_tick_df['code'].astype(dtype = str) 		# 将 code 列由 numpy.int64 类型转成 str 类型
	#netease_tick_df['symbol'] = netease_tick_df['symbol'].astype(dtype = str)

	date_arr = []
	time_arr = []
	# 实时数据的 code 列可能包含了前缀形了 7 位，所以必须转化成标准的 6 位股票代码
	for i in range(len(netease_tick_df)):
		netease_tick_df.ix[i,'code'] = char_fill(s = netease_tick_df.ix[i,'code'][-6:], bit = 6) 		# 将股票代码形成标准的 6 位
		
		dt = netease_tick_df.ix[i,'time']
		dt_arr = netease_datetime_split(dt = dt) 			# 获取网易实时数据返回的 time 字段格，该字段实际包含了日期和时间，下面做一下分离	
		date_arr.append(dt_arr[0])
		time_arr.append(dt_arr[1])

	netease_tick_df['date'] = date_arr 		# 拼接 date 列
	netease_tick_df['time'] = time_arr

	# str 类型的列数组，做一遍首尾去空格操作
	for column_name in cf.TICK_COL_STR_ARR:
		netease_tick_df[column_name] = netease_tick_df[column_name].str.strip()

	# 取网易列名与自定义标准列名的子集（ float 类型的那些列），以便对这些列进行4舍5入
	column_arr = list(set(netease_tick_df.columns) & set(cf.TICK_COL_FLOAT_ARR)) 		# 这个 TICK_COL_FLOAT_ARR 定义在 common_config.py ，表示这些字段名可转成 float
	# 将这些实数型的列，全部保留两位小数
	for i,column_name in enumerate(column_arr):
		if column_name == cf.TICK_COL_DICT['percent']: 		# 涨跌幅保留4位，其余保留 2 位
			bit = 4
		else:
			bit = 2
		netease_tick_df[column_name] = xround(f = netease_tick_df[column_name],bit=bit)

	# 先删除几个没用的列，即去掉标准字段以外的所有字段
	column_arr = list(set(list(netease_tick_df.columns)) - set(cf.TICK_COL_ARR))
	for column_name in column_arr:
		netease_tick_df.pop(column_name)

	return netease_tick_df







def netease_datetime_split(dt=None):
	'''
	说明：将网易实时数据中的 datetime （yyyy/mm/dd hh:mm:ss）进行分割，形成单独的 date 和 time 返回
	参数：dt , 表示需要传入网易的 datetime
	返回值：result_arr, 是一个 list, 由单独的 date 和 time 组成
	'''
	func_name = get_current_function_name() + ': '
	if dt is None:
		print(func_name,'错误：没有来自网易 tick DataFrame 的 datetime 字段数据传入')
		return None

	dt_arr = dt.split(' ') 		# 先按空格把日期和时间切开，形成两个元素放到 dt_arr 数组中 
	xdate = '-'.join(dt_arr[0].split('/')) 		# 把 yyyy/mm/dd 的日期格式转换为 yyyy-mm-dd 格式，因为在本项中所有地方将使用后者格式
	xdate = xdate.strip() 		# 去掉两头的空格
	xtime = dt_arr[1].strip() 	# 取得时间并去掉两头空格

	return [xdate,xtime]







def sina_to_standard(df=None):
	'''
	说明：将传入的 df 新浪实时 tick 数据字段名转为标准字段名，其名称映射在配置文件 common_config.py 中 SINA_COL_DICT 中定义
	参数：df ，必须是新浪实时 tick 数据
	返回值：sina_tick_df, 准标字段名的 tick DataFrame
	'''
	func_name = get_current_function_name() + ': '
	if df is None:
		print(func_name,'错误：没有来自网易的 tick DataFrame传入')
		return None

	# 转换新浪实时 tick 数据的列名到自定义的标准列名
	sina_tick_df = df.rename(columns=cf.SINA_COL_DICT) 		# 转换列名称
	sina_tick_df = sina_tick_df.reset_index(drop = True) 		# 重建索引，从 0 开始自然增长

	# 将所有股票代码补到 6 位
	for i in range(len(sina_tick_df)):
		sina_tick_df.ix[i,cf.TICK_COL_DICT['code']] = char_fill(s = sina_tick_df.ix[i,cf.TICK_COL_DICT['code']][-6:], bit = 6) 		# 将股票代码形成标准的 6 位

	# 由于新浪返回的实时 tick 全部是字符串类型，下面将 df 中大部分适合计算的字符串列全部转成 float，以便可以参加计算
	column_arr = list(set(list(sina_tick_df.columns)) & set(cf.TICK_COL_FLOAT_ARR)) 		# 这个 TICK_COL_FLOAT_ARR 定义在 common_config.py ，表示这些字段名可转成 float

	sina_tick_df = convert_df_type(df=sina_tick_df,xtype=float,column_arr = column_arr) 		# 将这些数值型的列，全部转成 float ，以便计算，注意，这步操作后，行数可能会减少，因为不符合要求的行会被 convert_df_type() 函数删掉

	# 获取市价。这个细节处理要注意，因为 9：25前没有 price ，但有 bid1 价格，
	# 所以判断当前时间，若已过了 9：25 ，则用 price 本身做市价，否则用 bid1 做市价
	if time.time() <= get_timestamp(xtime = cf.TIME_0925):
		price = sina_tick_df[cf.TICK_COL_DICT['bid1']]
		sina_tick_df[cf.TICK_COL_DICT['price']]	= sina_tick_df[cf.TICK_COL_DICT['bid1']] 			# 因为 9:25 前 price 可能为 0，这时 bid1=ask1 ，其实他们就是市价 price 的意思，也是动态开盘价的意思
		sina_tick_df[cf.TICK_COL_DICT['open']] 	= sina_tick_df[cf.TICK_COL_DICT['bid1']] 			# 因为 9:25 前 open 为 0，所以用 bid1 当作动态开盘价。
		sina_tick_df[cf.TICK_COL_DICT['high']] = sina_tick_df[cf.TICK_COL_DICT['bid1']]
		sina_tick_df[cf.TICK_COL_DICT['low']] = sina_tick_df[cf.TICK_COL_DICT['bid1']]
	else:
		price = sina_tick_df[cf.TICK_COL_DICT['price']]

	# 下面加两列，分别是涨跌额（计算方法是市价减去昨收价）和涨跌幅（用涨跌额/昨收价）
	sina_tick_df[cf.TICK_COL_DICT['change']] = price - sina_tick_df[cf.TICK_COL_DICT['last_close']] 		# 加一列即时涨跌额
	sina_tick_df[cf.TICK_COL_DICT['percent']] = sina_tick_df[cf.TICK_COL_DICT['change']] / sina_tick_df[cf.TICK_COL_DICT['last_close']] 		# 加一列即时涨幅
	#sina_tick_df[cf.TICK_COL_DICT['open_percent']] = (sina_tick_df[cf.TICK_COL_DICT['open']] - sina_tick_df[cf.TICK_COL_DICT['last_close']]) / sina_tick_df[cf.TICK_COL_DICT['last_close']] 

	#sina_tick_df[cf.TICK_COL_DICT['percent']] = xround(f=sina_tick_df[cf.TICK_COL_DICT['percent']],bit=4) 			# 这列要单独处理，因为要保留4 位小数
	column_arr += [cf.TICK_COL_DICT['change'],cf.TICK_COL_DICT['percent']]

	# 将这些实数型的列，全部保留两位小数
	for i,column_name in enumerate(column_arr):
		if column_name == cf.TICK_COL_DICT['percent']: 		# 涨跌幅保留4位，其余保留 2 位
			bit = 4
		else:
			bit = 2
		#sina_tick_df[column_name] = sina_tick_df[column_name].round(2) 	
		sina_tick_df[column_name] = xround(f = sina_tick_df[column_name],bit=bit)


	# ---------------
	# 将买一到买五及卖1到卖5的量（新浪返回的10档量的单位为手，而网易为股，相差100倍）乘以100，形成以股为单位，以便与网易返回的值保持一致。
	for i,column_name in enumerate(cf.TICK_COL_VOL_ARR):
		sina_tick_df[column_name] = sina_tick_df[column_name] * cf.ONE_HAND

	# str 类型的列数组，做一遍首尾去空格操作
	for column_name in cf.TICK_COL_STR_ARR:
		sina_tick_df[column_name] = sina_tick_df[column_name].str.strip()


	# 先删除几个没用的列，即去掉标准字段以外的所有字段
	column_arr = list(set(list(sina_tick_df.columns)) - set(cf.TICK_COL_ARR))
	for column_name in column_arr:
		sina_tick_df.pop(column_name)


	return sina_tick_df









