'''
说明：这个配置文件是 for jxbase 这个包的

'''

# jxbase 要用到的所有依赖包在列在这里，被 setup.py 中的 install_require 参数调用
MODULES_ARR = [
	'time',
	'datetime',
	'configobj',
	#'copy',
	#'csv',
	#'ctypes',
	#'decimal',
	#'getopt',
	#'inspect',
	#'io',
	#'itertools',
	#'json',
	'logging',
	'math',
	#'matplotlib',
	'multiprocessing',
	'numpy',
	'pandas',
	#'pickle',
	#'platform',
	#'pylab',
	#'queue',
	'random',
	're',
	#'reportlab',
	#'requests',
	#'subprocess',
	#'scipy',
	'smtplib',
	'sympy',
	'sys',
	'tempfile',
	#'threading',
	#'tkinter',
	'urllib',
	'uuid',
	#'win32gui',
	#'win32api',
	#'win32con',
	#'win32print',
	#'win32clipboard',
	#'xmlrpc',

	'email',
	#'binascii',
	#'sqlalchemy',
	'ftplib',
	#'lxml',
	#'bs4',
	'PIL',

	#'pymysql',
	'pytesseract',
	#'tushare',
	#'redis',
	#'django',
	'pywinauto',
	#'selenium',
	#'apscheduler',
	'os'
	]



# --------------
# DOS 风格
DOS_ARR = [
	'DOS',
	'dos'
	]


# WINDOWS 风格
WINDOWS_ARR = [
	'WINDOWS',
	'windows'
	]


# DOS 风格
LINUX_ARR = [
	'LINUX',
	'linux'
	]



# UNIX 风格
UNIX_ARR = [
	'UNIX',
	'unix'
	]


DOS_STYLE_ARR = DOS_ARR + WINDOWS_ARR
UNIX_STYLE_ARR = UNIX_ARR + LINUX_ARR



# --------------------------
# 程序中要用到的几种时间格式
TIME_FORMAT='%Y%m%d%H%M%S'
TIME_FORMAT1='%H:%M:%S'
TIME_FORMAT2='%Y%m%d-%H.%M.%S'
TIME_FORMAT3='%Y-%m-%d - %H:%M:%S'

DATE_FORMAT1='%Y-%m-%d'
DATE_FORMAT2='%d'
DATE_TIME_FORMAT = DATE_FORMAT1 + ' ' + TIME_FORMAT1


TIME_GAP = 0.05 			# UI操作间停留时间间隙，预设 0.1秒，主要用在 pywinauto 上，是为了等待前一个操作完成



# 定义数据源 URL 字典
URL_DICT={
	'163'		:'http://quotes.money.163.com/service/chddata.html?code=%s&start=%s&end=%s&fields=TOPEN;HIGH;LOW;TCLOSE;LCLOSE;CHG;PCHG;VOTURNOVER;VATURNOVER;TURNOVER;TCAP;MCAP', 		# 网易历史数据源
	'126live'	:'http://api.money.126.net/data/feed/%smoney.api' 			# 网易实时数据源
	}


# --------------------------------
# 指数 dict ，前面都加市场前缀，sh 表示上证指数， sz 表示深证指数
# 上海方面的指数dict，由于上证综指 000001 与深证市场平安银行代码 000001 冲突，故用 sh000001 代表上证综证，在向数据源拉数据时请自行转换
SH_INDEX_DICT = {
	'SHZZ':'sh000001',
	'shzz':'sh000001'
	}

# 深圳方面的指数，399001 是深证成指
SZ_INDEX_DICT = {
	'SZCZ':'sz399001', 			# 深证成指（大票集中度次于深证综指）
	'szcz':'sz399001',			
	'ZXBZ':'sz399005', 			# 中小板指（小票集中度次于创业板）
	'zxbz':'sz399005',
	'CYBZ':'sz399006', 			# 创业板指(小票最集中)
	'cybz':'sz399006',
	'SZZZ':'sz399106', 			# 深证综指（大票最集中）
	'szzz':'sz399106'
	}

# 这个数组存放大盘指数代码，包括上海和深圳的
INDEX_DICT=dict(list(SH_INDEX_DICT.items()) + list(SZ_INDEX_DICT.items())) 	# 两市指数DICT



# 各指数数组
SH_INDEX_ARR = list(set(SH_INDEX_DICT.values())) 			# set 是为了去除重复元素

SZ_INDEX_ARR = list(set(SZ_INDEX_DICT.values()))

# 指数数组
INDEX_ARR = list(set(INDEX_DICT.values()))




# --------------------------
# 定义数据源标志字典
SOURCE_DICT = {
	'netease' 	:'netease', 		# 表示网易源
	'sina' 		:'sina' 			# 表示新浪源
	}



# 要从网易拉取历史K线数据的各列名称：
# K线数据列头名称（有序），日期，股票代码，名称，开盘价，最高价，最低价，收盘价，昨收价，涨跌额，涨跌幅，成交量，成交额，换手率，总市值，流通值
K_COL_ARR=['date','code','name','open','high','low','close','last_close','price_change','percent_change','volume','amount','turnover','total_value','circulation_value']



# 自定义标准的字符串类型的实时 tick 列名
TICK_COL_STR_ARR = [
	'date', 			# 日期
	'time',				# 时间

	'name', 			# 股票名称
	'code'	 			# 股票代码
	]

# 自定义标准的浮点类型的实时 tick 列名
TICK_COL_FLOAT1_ARR = [
	'last_close', 		# 昨收价
	'open',
	'high',
	'low',
	'price', 			# 市价

	'bid1', 			# 买一价
	'bid2',
	'bid3',
	'bid4',
	'bid5',

	'ask1', 			# 卖一价
	'ask2',
	'ask3',
	'ask4',
	'ask5',

	'volume', 			# 成交量, 单位：股，不是手
	'amount', 			# 成交额，单位：元，不是万元
	'change', 			# 涨跌额
	'percent', 			# 涨跌幅

	'max_price', 		# 涨停价
	'min_price', 		# 跌停价
	'bid1_amount', 		# 买一额度，单位：元，自定义这个字段是为了察看实盘中买一承受资金的冲击能力。下同
	'ask1_amount' 		# 卖一额度
	]


# 自定义标准的浮点类型的实时 tick 列名，这些列是 10档挂买挂卖量，也需转换成可参与计算的整型或浮点型，
# 与上述 TICK_COL_FLOAT1_ARR 是一样的，这两个数组对应的列都需要转换成 float 型，本可合并成一个数组进行定义，
# 但由于新浪返回的买1到卖5这10档的量的单位是手，而网易是股，差100倍，所以把这10档的量的列名单独定义一个数组，方便对新浪数据的处理
TICK_COL_VOL_ARR = [
	'bidvol1', 			# 买一量，单位：股，不是手，下同
	'bidvol2',
	'bidvol3',
	'bidvol4',
	'bidvol5',

	'askvol1', 			# 卖一量
	'askvol2',
	'askvol3',
	'askvol4',
	'askvol5'
	]


# 这两个数组在这里合并掉。上面必须分开定义的原因是他们的处理办法只有部分交集
TICK_COL_FLOAT_ARR = TICK_COL_FLOAT1_ARR + TICK_COL_VOL_ARR

# 自定义标准实时 tick 数据字段名（无序）（所有数据源取回的数据，其字段名都要映射成如下名称，以便程序统一处理），
# 这个 list 非常重要，从各个数据源取回的数据，最终都必须且只需包含 tick_col_arr 所指出的字段，不能多不能少，要不然各个源取回的烽据没法合并
TICK_COL_ARR = TICK_COL_STR_ARR + TICK_COL_FLOAT_ARR

# 把上述实时 tick 数据的字段名做成字典，上层应用的列名都必须引用这个字典，防止出乱子
TICK_COL_DICT = {x:x for x in TICK_COL_ARR}

K_COL_DICT = {x:x for x in K_COL_ARR}

'''
NETEASE_COL_ONLY_ARR = ['share','status','symbol','type','update'] 		# 这是网易独有的字段，一般是没用的，在实时 tick 取来后，要把这些字段列删掉
SINA_COL_ONLY_ARR = ['bid','ask'] 			# 这是网易独有的字段，一般是没用的，在实时 tick 取来后，要把这些字段列删掉
'''
# ----------------------------------
# 下面是将网易实时 tick 数据字段名映射成上面定义的标准 tick 字段名，只针对名称不同的字段作映射
NETEASE_COL_DICT = {
	'turnover'	:TICK_COL_DICT['amount'], 		# 网易实时数据的成交额据然用 'turnover' 表示，可能是失误，这里给转成正确的名称 amount
	'updown'	:TICK_COL_DICT['change'], 		# 涨跌额
	'yestclose'	:TICK_COL_DICT['last_close'] 	# 昨收价
	}

# 下面是将新浪实时 tick 数据字段名映射成上面定义的标准 tick 字段名，只针对名称不同的字段作映射
SINA_COL_DICT = {
	'b1_p'	:TICK_COL_DICT['bid1'],
	'b2_p'	:TICK_COL_DICT['bid2'],
	'b3_p'	:TICK_COL_DICT['bid3'],
	'b4_p'	:TICK_COL_DICT['bid4'],
	'b5_p'	:TICK_COL_DICT['bid5'],
	'b1_v'	:TICK_COL_DICT['bidvol1'],
	'b2_v'	:TICK_COL_DICT['bidvol2'],
	'b3_v'	:TICK_COL_DICT['bidvol3'],
	'b4_v'	:TICK_COL_DICT['bidvol4'],
	'b5_v'	:TICK_COL_DICT['bidvol5'],

	'a1_p'	:TICK_COL_DICT['ask1'],
	'a2_p'	:TICK_COL_DICT['ask2'],
	'a3_p'	:TICK_COL_DICT['ask3'],
	'a4_p'	:TICK_COL_DICT['ask4'],
	'a5_p'	:TICK_COL_DICT['ask5'],
	'a1_v'	:TICK_COL_DICT['askvol1'],
	'a2_v'	:TICK_COL_DICT['askvol2'],
	'a3_v'	:TICK_COL_DICT['askvol3'],
	'a4_v'	:TICK_COL_DICT['askvol4'],
	'a5_v'	:TICK_COL_DICT['askvol5'],

	'pre_close'	:TICK_COL_DICT['last_close']
	}


# 对 tushare 的 get_today_all() 返回的字段名映射到自定义的一个字段表，以便把不同的源的字段名统一处理
TODAY_ALL_COL_DICT = {
	'changepercent'	:K_COL_DICT['percent_change'],
	'trade' 		:K_COL_DICT['close'],
	'settlement'	:K_COL_DICT['last_close'],
	'turnoverratio'	:K_COL_DICT['turnover'],
	'mktcap' 		:K_COL_DICT['total_value'],
	'nmc' 			:K_COL_DICT['circulation_value']
	}


# -------------------------
# 一些常量

ONE_HAND=100 	#一手为100股，因为买入必须是100股的整数倍

UP_LIMIT=1.1 	# 涨停乘数因子，就是把昨收价乘以这个因子，然后四舍五入后就是今天的涨停价
DOWN_LIMIT=0.9 	# 跌停乘数因子，就是把昨收价乘以这个因子，然后四舍五入后就是今天的跌停价

# --------------------------------
# 时间点相关的常量
TIME_0900 = '09:00:00' 			# 9 点，这个时间点股市开始新的一天，在这个时间点时间 用 tusahre 的 get_today_all() 将取到昨天的数据（程序里要求这样）。在这个时间点后，这个函数调取的是今天的数据

TIME_0915 = '09:15:00' 			# 开始集合竞价

TIME_0916 = '09:16:00' 			# xauto.py 程序启动时间点，暂时没使用。程序是根据上面的 9:15 这个时间建立后面各线程的相对启动时间的。

TIME_0920 = '09:20:00' 			# 集合竞价阶段不可撤单的申请时间点开始

TIME_0924 = '09:24:46' 			# 开盘前几秒钟，取数据起始时间，这个时间很重要！！这个时间要精准要秒。第1次取数据较慢，所以要定早一点 

TIME_0925 = '09:25:00' 			# 产生开盘价的时间

TIME_0933 = '09:33:00' 			# 

TIME_0945 = '09:45:00'

TIME_1000 = '10:00:00'

TIME_1455 = '14:55:00' 			# 最后5分钟

TIME_1459 = '14:59:50'			# 收盘前几秒



#一天中交易起止时间
OPEN_TIME='09:30:00'
CLOSE_TIME='15:00:00'

#一天中交易起止时间，分上下午
AM_OPEN_TIME='09:30:00'
AM_CLOSE_TIME='11:30:00'
PM_OPEN_TIME='13:00:00'
PM_CLOSE_TIME='15:00:00'


# ----------------------------
# 买卖方向设置
DIRECTION_BUY='buy' 			# 买的方向
DIRECTION_SELL='sell' 			# 卖的方向

