/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Finder;
import org.sikuli.script.IScreen;
import org.sikuli.script.Image;
import org.sikuli.script.ImageFind;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;

public class ImageFinder
extends Finder {
    static RunTime runTime = RunTime.get();
    private static String me = "ImageFinder: ";
    private static int lvl = 3;
    private boolean isImageFinder = true;
    protected boolean isImage = false;
    protected Region region = null;
    protected boolean isRegion = false;
    protected IScreen screen = null;
    protected boolean isScreen = false;
    protected int offX;
    protected int offY;
    protected long MaxTimePerScan;
    private Image bImage = null;
    protected Mat base = new Mat();
    private double waitingTime = Settings.AutoWaitTimeout;
    private int minChanges;
    private ImageFind firstFind = null;
    private boolean isReusable = false;
    protected boolean isMultiFinder = false;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public ImageFinder() {
        this.init(null, null, null);
    }

    public ImageFinder(Image base) {
        this.init(base, null, null);
    }

    public ImageFinder(IScreen scr) {
        this.init(null, scr, null);
    }

    public ImageFinder(Region reg) {
        this.init(null, null, reg);
    }

    protected ImageFinder(Mat base) {
        ImageFinder.log(3, "init", new Object[0]);
        this.reset();
        this.base = base;
        this.isImage = true;
        ImageFinder.log(3, "search in: \n%s", base);
    }

    private void init(Image base, IScreen scr, Region reg) {
        ImageFinder.log(3, "init", new Object[0]);
        if (base != null) {
            this.setImage(base);
        } else if (scr != null) {
            this.setScreen(scr);
        } else if (reg != null) {
            this.setRegion(reg);
        }
    }

    private void reset() {
        this.firstFind = null;
        this.isImage = false;
        this.isScreen = false;
        this.isRegion = false;
        this.screen = null;
        this.region = null;
        this.bImage = null;
        this.base = new Mat();
    }

    @Override
    public void destroy() {
        this.reset();
    }

    public void setIsMultiFinder() {
        this.base = new Mat();
        this.isMultiFinder = true;
    }

    public boolean setImage(Image base) {
        this.reset();
        if (base.isValid()) {
            this.bImage = base;
            this.base = Image.createMat(base.get());
            this.isImage = true;
            ImageFinder.log(3, "search in: \n%s", base.get());
        }
        return this.isImage;
    }

    public boolean isImage() {
        return this.isImage;
    }

    protected void setBase(BufferedImage bImg) {
        ImageFinder.log(3, "search in: \n%s", bImg);
        this.base = Image.createMat(bImg);
    }

    public boolean setScreen(IScreen scr) {
        this.reset();
        if (scr != null) {
            this.screen = scr;
            this.isScreen = true;
            this.setScreenOrRegion(scr);
        }
        return this.isScreen;
    }

    public boolean setRegion(Region reg) {
        this.reset();
        if (reg != null) {
            this.region = reg;
            this.isRegion = true;
            this.setScreenOrRegion(reg);
        }
        return this.isRegion;
    }

    private void setScreenOrRegion(Object reg) {
        Region r = (Region)reg;
        this.MaxTimePerScan = (int)(1000.0 / (double)r.getWaitScanRate());
        this.offX = r.x;
        this.offY = r.y;
        ImageFinder.log(3, "search in: \n%s", r);
    }

    public void setFindTimeout(double t) {
        this.waitingTime = t;
    }

    @Override
    public boolean isValid() {
        if (!(this.isImage || this.isScreen || this.isRegion)) {
            ImageFinder.log(-1, "not yet initialized (not valid Image, Screen nor Region)", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public String find(Image img) {
        if (null == this.imageFind(img, new Object[0])) {
            return null;
        }
        return "--fromImageFinder--";
    }

    @Override
    public String find(String filenameOrText) {
        if (null == this.imageFind(filenameOrText, new Object[0])) {
            return null;
        }
        return "--fromImageFinder--";
    }

    @Override
    public String find(Pattern pat) {
        if (null == this.imageFind(pat, new Object[0])) {
            return null;
        }
        return "--fromImageFinder--";
    }

    @Override
    public String findText(String text) {
        ImageFinder.log(-1, "findText: not yet implemented", new Object[0]);
        return null;
    }

    public <PSI> ImageFind search(PSI probe, Object ... args) {
        this.isReusable = true;
        return this.imageFind(probe, args);
    }

    protected <PSI> ImageFind findInner(PSI probe, double sim) {
        ImageFind newFind = new ImageFind();
        newFind.setIsInnerFind();
        newFind.setSimilarity(sim);
        if (!newFind.checkFind(this, probe, new Object[0])) {
            return null;
        }
        this.firstFind = newFind;
        if (newFind.isValid()) {
            return newFind.doFind();
        }
        return null;
    }

    private <PSI> ImageFind imageFind(PSI probe, Object ... args) {
        Debug.enter(me + ": find: %s", probe);
        ImageFind newFind = new ImageFind();
        newFind.setFindTimeout(this.waitingTime);
        if (!newFind.checkFind(this, probe, args)) {
            return null;
        }
        if (newFind.isValid() && !this.isReusable && this.firstFind == null) {
            this.firstFind = newFind;
        }
        ImageFind imgFind = newFind.doFind();
        ImageFinder.log(lvl, "find: success: %s", imgFind.get());
        return imgFind;
    }

    public <PSI> ImageFind searchAny(PSI probe, Object ... args) {
        Debug.enter(me + ": findAny: %s", probe);
        ImageFind newFind = new ImageFind();
        newFind.setFinding(0);
        this.isReusable = true;
        if (!newFind.checkFind(this, probe, args)) {
            return null;
        }
        if (newFind.isValid() && !this.isReusable && this.firstFind == null) {
            this.firstFind = newFind;
        }
        ImageFind imgFind = newFind.doFind();
        ImageFinder.log(lvl, "find: success: %s", imgFind.get());
        return imgFind;
    }

    public <PSI> ImageFind searchSome(PSI probe, Object ... args) {
        return this.searchSome(probe, ImageFind.SOME_COUNT, args);
    }

    public <PSI> ImageFind searchSome(PSI probe, int count, Object ... args) {
        this.isReusable = true;
        return this.imageFindAll(probe, 2, count, args);
    }

    @Override
    public String findAll(Image img) {
        if (null == this.imageFindAll(img, 2, 0, new Object[0])) {
            return null;
        }
        return "--fromImageFinder--";
    }

    @Override
    public String findAll(String filenameOrText) {
        if (null == this.imageFindAll(filenameOrText, 2, 0, new Object[0])) {
            return null;
        }
        return "--fromImageFinder--";
    }

    @Override
    public String findAll(Pattern pat) {
        if (null == this.imageFindAll(pat, 2, 0, new Object[0])) {
            return null;
        }
        return "--fromImageFinder--";
    }

    public <PSI> ImageFind searchAll(PSI probe, Object ... args) {
        this.isReusable = true;
        return this.imageFindAll(probe, 2, 0, args);
    }

    public <PSI> ImageFind searchAll(PSI probe, int sorted, Object ... args) {
        this.isReusable = true;
        return this.imageFindAll(probe, sorted, 0, args);
    }

    private <PSI> ImageFind imageFindAll(PSI probe, int sorted, int count, Object ... args) {
        Debug.enter(me + ": findAny: %s", probe);
        ImageFind newFind = new ImageFind();
        newFind.setFinding(2);
        newFind.setSorted(sorted);
        if (count > 0) {
            newFind.setCount(count);
        }
        if (!newFind.checkFind(this, probe, args)) {
            return null;
        }
        if (newFind.isValid() && !this.isReusable && this.firstFind == null) {
            this.firstFind = newFind;
        }
        ImageFind imgFind = newFind.doFind();
        ImageFinder.log(lvl, "find: success: %s", imgFind.get());
        return imgFind;
    }

    public boolean hasChanges(Mat current) {
        int PIXEL_DIFF_THRESHOLD = 5;
        int IMAGE_DIFF_THRESHOLD = 5;
        Mat bg = new Mat();
        Mat cg = new Mat();
        Mat diff = new Mat();
        Mat tdiff = new Mat();
        Imgproc.cvtColor(this.base, bg, 6);
        Imgproc.cvtColor(current, cg, 6);
        Core.absdiff(bg, cg, diff);
        Imgproc.threshold(diff, tdiff, PIXEL_DIFF_THRESHOLD, 0.0, 3);
        if (Core.countNonZero(tdiff) <= IMAGE_DIFF_THRESHOLD) {
            return false;
        }
        Imgproc.threshold(diff, diff, PIXEL_DIFF_THRESHOLD, 255.0, 0);
        Imgproc.dilate(diff, diff, new Mat());
        Mat se = Imgproc.getStructuringElement(2, new Size(5.0, 5.0));
        Imgproc.morphologyEx(diff, diff, 3, se);
        ArrayList<MatOfPoint> points = new ArrayList<MatOfPoint>();
        Mat contours = new Mat();
        Imgproc.findContours(diff, points, contours, 1, 2);
        int n = 0;
        for (Mat mat : points) {
            ImageFinder.log(lvl, "(%d) %s", n++, mat);
            ImageFinder.printMatI(mat);
        }
        ImageFinder.log(lvl, "contours: %s", contours);
        ImageFinder.printMatI(contours);
        return true;
    }

    private static void printMatI(Mat mat) {
        int[] data = new int[mat.channels()];
        for (int r = 0; r < mat.rows(); ++r) {
            for (int c = 0; c < mat.cols(); ++c) {
                mat.get(r, c, data);
                ImageFinder.log(lvl, "(%d, %d) %s", r, c, Arrays.toString(data));
            }
        }
    }

    public void setMinChanges(int min) {
        this.minChanges = min;
    }

    @Override
    public boolean hasNext() {
        if (null != this.firstFind) {
            return this.firstFind.hasNext();
        }
        return false;
    }

    @Override
    public Match next() {
        if (this.firstFind != null) {
            return this.firstFind.next();
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

