/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.apache.xmlrpc.webserver.XmlRpcServletServer;
import org.robotframework.remoteserver.context.RemoteServerContext;
import org.robotframework.remoteserver.library.DefaultRemoteLibraryFactory;
import org.robotframework.remoteserver.library.RemoteLibrary;
import org.robotframework.remoteserver.library.RemoteLibraryFactory;
import org.robotframework.remoteserver.servlet.IllegalPathException;
import org.robotframework.remoteserver.servlet.RemoteServerRequestProcessorFactoryFactory;
import org.robotframework.remoteserver.servlet.ServerMethods;
import org.robotframework.remoteserver.xmlrpc.ReflectiveHandlerMapping;
import org.robotframework.remoteserver.xmlrpc.TypeFactory;

public class RemoteServerServlet
extends XmlRpcServlet
implements RemoteServerContext {
    private static final long serialVersionUID = -7981676271855172976L;
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static final ThreadLocal<RemoteLibrary> currLibrary = new ThreadLocal();
    private Map<String, RemoteLibrary> libraryMap = new ConcurrentHashMap<String, RemoteLibrary>();
    private boolean allowStop = true;

    @Override
    public RemoteLibrary putLibrary(String path, Object library) {
        RemoteServerServlet.checkPath(path);
        RemoteLibraryFactory libraryFactory = this.createLibraryFactory();
        RemoteLibrary remoteLibrary = libraryFactory.createRemoteLibrary(library);
        return this.libraryMap.put(path, remoteLibrary);
    }

    @Override
    public RemoteLibrary removeLibrary(String path) {
        return this.libraryMap.remove(path);
    }

    @Override
    public Map<String, RemoteLibrary> getLibraryMap() {
        return new HashMap<String, RemoteLibrary>(this.libraryMap);
    }

    @Override
    public boolean getAllowStop() {
        return this.allowStop;
    }

    @Override
    public void setAllowStop(boolean allowed) {
        this.allowStop = allowed;
    }

    @Override
    protected XmlRpcServletServer newXmlRpcServer(ServletConfig pConfig) throws XmlRpcException {
        XmlRpcServletServer server = new XmlRpcServletServer();
        server.setTypeFactory(new TypeFactory(this.getXmlRpcServletServer()));
        return server;
    }

    @Override
    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        ReflectiveHandlerMapping map = new ReflectiveHandlerMapping();
        map.setRequestProcessorFactoryFactory(new RemoteServerRequestProcessorFactoryFactory(this));
        map.addHandler("keywords", ServerMethods.class);
        map.removePrefixes();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        request.set(req);
        try {
            super.service(req, resp);
        }
        finally {
            request.remove();
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo() == null ? req.getServletPath() : req.getPathInfo();
        if (this.libraryMap.containsKey(path = RemoteServerServlet.cleanPath(path))) {
            currLibrary.set(this.libraryMap.get(path));
            if ("HTTP/1.0".equals(req.getProtocol())) {
                resp.addHeader("Connection", "close");
            }
            super.doPost(req, resp);
        } else {
            resp.sendError(404, String.format("No library mapped to %s", path));
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        String body = this.getPage();
        resp.setContentLength(body.length());
        PrintWriter out = resp.getWriter();
        out.print(body);
    }

    @Override
    public HttpServletRequest getRequest() {
        return request.get();
    }

    private String getPage() {
        TreeMap<String, RemoteLibrary> map = new TreeMap<String, RemoteLibrary>(this.getLibraryMap());
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML><HEAD><TITLE>jrobotremoteserver</TITLE></HEAD><BODY><P>jrobotremoteserver serving:</P><TABLE border='1' cellspacing='0' cellpadding='5'><TR><TH>Path</TH><TH>Library</TH></TR>");
        if (map.isEmpty()) {
            sb.append("<TR><TD COLSPAN=\"2\">No libraries mapped</TD></TR>");
        } else {
            for (String path : map.keySet()) {
                sb.append("<TR><TD>");
                sb.append(path.toString());
                sb.append("</TD><TD>");
                sb.append(StringEscapeUtils.escapeHtml(((RemoteLibrary)map.get(path)).getName()));
                sb.append("</TD></TR>");
            }
        }
        sb.append("</TABLE></BODY></HTML>");
        return sb.toString();
    }

    public RemoteLibrary getLibrary() {
        return currLibrary.get();
    }

    protected RemoteLibraryFactory createLibraryFactory() {
        return new DefaultRemoteLibraryFactory();
    }

    private static String cleanPath(String path) {
        String string = path = path == null ? "/" : path;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((path = path.replaceAll("/+", "/")).length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static void checkPath(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new IllegalPathException(String.format("Path [%s] does not start with a /.", path));
        }
        if (path.contains("//")) {
            throw new IllegalPathException(String.format("Path [%s] contains repeated forward slashes.", path));
        }
        if (!path.equals("/") && path.endsWith("/")) {
            throw new IllegalPathException(String.format("Path [%s] ends with a /.", path));
        }
        if (!path.matches("[a-zA-Z0-9-._~/]+")) {
            throw new IllegalPathException(String.format("Path [%s] contains disallowed characters (must contain only alphanumeric or any of these: -._~/).", path));
        }
    }
}

