/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.cli;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CommandLineHelper {
    private Map<String, Object> libraryMap = new HashMap<String, Object>();
    private boolean allowStop = true;
    private String host = null;
    private String error = null;
    private boolean helpRequested = false;
    private String[] args;
    private int idx = 0;
    private int port = 0;
    private boolean usedOldLibraryOption = false;

    public boolean getAllowStop() {
        return this.allowStop;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, Object> getLibraryMap() {
        return this.libraryMap;
    }

    public String getError() {
        return this.error;
    }

    public boolean getHelpRequested() {
        return this.helpRequested;
    }

    public String getUsage() {
        return "Usage: org.robotframework.remoteserver.RemoteServer options\n\nOptions:\n    -l --library classname[:path] library to serve and path to map to. Path\n                                  has a default value of /. The library option\n                                  may be repeated to serve multiple libraries\n    -p --port port                port to bind to, defaults to 0 (ephemeral)\n    -a --allowstop true|false     whether to allow remote stop\n    -H --host hostname            hostname of the interface to bind to\n    -h -? --help                  print this help message\n\n For backwards compatibility, one library can be added using the form\n   --library classname:port\n";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandLineHelper(String[] clargs) {
        this.args = clargs;
        try {
            while (this.idx < this.args.length) {
                if (this.args[this.idx].equals("-l") || this.args[this.idx].equals("--library")) {
                    String[] parts = this.getValue("library").split(":", 2);
                    String className = parts[0];
                    String path = "/";
                    if (parts.length == 2) {
                        path = parts[1];
                    }
                    if (path.equals("") || path.matches("\\s+")) {
                        throw new RuntimeException("Missing path for library " + className);
                    }
                    this.putLibrary(path, className);
                } else if (this.args[this.idx].equals("-p") || this.args[this.idx].equals("--port")) {
                    String portString = this.getValue("port");
                    this.setPort(portString);
                } else if (this.args[this.idx].equals("-H") || this.args[this.idx].equals("--host")) {
                    this.host = this.getValue("host");
                } else if (this.args[this.idx].equals("-a") || this.args[this.idx].equals("--allowstop")) {
                    String value = this.getValue("allowstop");
                    if (value.equalsIgnoreCase("false")) {
                        this.allowStop = false;
                    } else {
                        if (!value.equalsIgnoreCase("true")) throw new RuntimeException("Value for option allowstop must be true or false");
                        this.allowStop = true;
                    }
                } else {
                    if (!Arrays.asList("-h", "-?", "--help").contains(this.args[this.idx])) throw new RuntimeException("Unkown option: " + this.args[this.idx]);
                    this.helpRequested = true;
                    return;
                }
                ++this.idx;
            }
            if (!this.libraryMap.isEmpty()) return;
            throw new RuntimeException("You must specify at least one library");
        }
        catch (Exception e) {
            this.error = e.getMessage();
        }
    }

    private String getValue(String name) {
        if (this.idx == this.args.length - 1 || this.args[this.idx + 1].startsWith("-")) {
            throw new RuntimeException("Missing value for option " + name);
        }
        return this.args[this.idx++ + 1];
    }

    private void putLibrary(String path, String className) {
        Object library;
        Class<?> clazz;
        className = className.trim();
        if (path.matches("\\d+")) {
            this.setPort(path);
            this.usedOldLibraryOption = true;
            path = "/";
        }
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load class with name " + className + ": " + e.toString());
        }
        try {
            library = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create library instance: " + e.toString());
        }
        if (this.libraryMap.containsKey(path)) {
            throw new RuntimeException(String.format("Duplicate path [%s]", path));
        }
        this.libraryMap.put(path, library);
    }

    private void setPort(String portString) {
        int port;
        if (this.usedOldLibraryOption) {
            throw new RuntimeException("Cannot use the port option or use multiple libraries when specifying libraries in the form classname:port");
        }
        try {
            port = Integer.valueOf(portString.trim());
            if (port < 1 || port > 65535) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Port must be 1-65535");
        }
        this.port = port;
    }
}

