/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.webserver.ServletWebServer;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private final Socket socket;
    private final ServletInputStream istream;
    private ServletInputStream sistream;
    private BufferedReader reader;
    private boolean postParametersParsed;
    private String method;
    private String protocol;
    private String uri;
    private String queryString;
    private String httpVersion;
    private final Map headers = new HashMap();
    private final Map attributes = new HashMap();
    private Map parameters;
    private String characterEncoding;
    private int contentBytesRemaining = -1;

    public HttpServletRequestImpl(Socket pSocket) throws IOException {
        this.socket = pSocket;
        final BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream()){

            public void close() throws IOException {
            }
        };
        this.istream = new ServletInputStream(){

            public int read() throws IOException {
                if (HttpServletRequestImpl.this.contentBytesRemaining == 0) {
                    return -1;
                }
                int c = bis.read();
                if (c != -1 && HttpServletRequestImpl.this.contentBytesRemaining > 0) {
                    --HttpServletRequestImpl.this.contentBytesRemaining;
                }
                return c;
            }
        };
    }

    public void readHttpHeaders() throws IOException, ServletWebServer.Exception {
        StringTokenizer tokens;
        byte[] buffer = new byte[2048];
        String line = this.readLine(buffer);
        StringTokenizer stringTokenizer = tokens = line != null ? new StringTokenizer(line) : null;
        if (tokens == null || !tokens.hasMoreTokens()) {
            throw new ServletWebServer.Exception(400, "Bad Request", "Unable to parse requests first line (should be 'METHOD uri HTTP/version', was empty.");
        }
        this.method = tokens.nextToken();
        if (!"POST".equalsIgnoreCase(this.method)) {
            throw new ServletWebServer.Exception(400, "Bad Request", "Expected 'POST' method, got " + this.method);
        }
        if (!tokens.hasMoreTokens()) {
            throw new ServletWebServer.Exception(400, "Bad Request", "Unable to parse requests first line (should be 'METHOD uri HTTP/version', was: " + line);
        }
        String u = tokens.nextToken();
        int offset = u.indexOf(63);
        if (offset >= 0) {
            this.uri = u.substring(0, offset);
            this.queryString = u.substring(offset + 1);
        } else {
            this.uri = u;
            this.queryString = null;
        }
        if (tokens.hasMoreTokens()) {
            String v = tokens.nextToken().toUpperCase();
            if (tokens.hasMoreTokens()) {
                throw new ServletWebServer.Exception(400, "Bad Request", "Unable to parse requests first line (should be 'METHOD uri HTTP/version', was: " + line);
            }
            int index = v.indexOf(47);
            if (index == -1) {
                throw new ServletWebServer.Exception(400, "Bad Request", "Unable to parse requests first line (should be 'METHOD uri HTTP/version', was: " + line);
            }
            this.protocol = v.substring(0, index).toUpperCase();
            this.httpVersion = v.substring(index + 1);
        } else {
            this.httpVersion = "1.0";
            this.protocol = "HTTP";
        }
        while ((line = HttpUtil.readLine(this.istream, buffer)) != null && line.length() != 0) {
            int off = line.indexOf(58);
            if (off > 0) {
                this.addHeader(line.substring(0, off), line.substring(off + 1).trim());
                continue;
            }
            throw new ServletWebServer.Exception(400, "Bad Request", "Unable to parse header line: " + line);
        }
        this.contentBytesRemaining = this.getIntHeader("content-length");
    }

    protected String readLine(byte[] pBuffer) throws IOException {
        int res = this.istream.readLine(pBuffer, 0, pBuffer.length);
        if (res == -1) {
            return null;
        }
        if (res == pBuffer.length && pBuffer[pBuffer.length] != 10) {
            throw new ServletWebServer.Exception(400, "Bad Request", "Maximum header size of " + pBuffer.length + " characters exceeded.");
        }
        return new String(pBuffer, 0, res, "US-ASCII");
    }

    protected void addHeader(String pHeader, String pValue) {
        String key = pHeader.toLowerCase();
        this.addParameter(this.headers, key, pValue);
    }

    public String getAuthType() {
        String s = this.getHeader("Authorization");
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s);
        if (st.hasMoreTokens()) {
            return st.nextToken().toUpperCase();
        }
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public Cookie[] getCookies() {
        throw new IllegalStateException("Not implemented");
    }

    public long getDateHeader(String arg0) {
        throw new IllegalStateException("Not implemented");
    }

    public String getHeader(String pHeader) {
        String key = pHeader.toLowerCase();
        Object o = this.headers.get(key);
        if (o instanceof List) {
            o = ((List)o).get(0);
        }
        return (String)o;
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration getHeaders(String pHeader) {
        String key = pHeader.toLowerCase();
        Object o = this.headers.get(key);
        List list = o instanceof List ? (List)o : Collections.singletonList(o);
        return Collections.enumeration(list);
    }

    public int getIntHeader(String pHeader) {
        String s = this.getHeader(pHeader);
        return s == null ? -1 : Integer.parseInt(s);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        throw new IllegalStateException("Not implemented");
    }

    public String getRequestURI() {
        return this.uri;
    }

    public StringBuffer getRequestURL() {
        boolean isDefaultPort;
        String scheme = this.getScheme().toLowerCase();
        StringBuffer sb = new StringBuffer(scheme);
        sb.append("://");
        String host = this.getHeader("host");
        if (host == null && (host = this.getLocalName()) == null) {
            host = this.getLocalAddr();
        }
        int port = this.getLocalPort();
        int offset = host.indexOf(58);
        if (offset != -1) {
            host = host.substring(0, offset);
            try {
                port = Integer.parseInt(host.substring(offset + 1));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!(isDefaultPort = "http".equalsIgnoreCase(scheme) ? port == 80 : ("https".equalsIgnoreCase(scheme) ? port == 443 : false))) {
            sb.append(':');
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    public String getRequestedSessionId() {
        throw new IllegalStateException("Not implemented");
    }

    public String getServletPath() {
        return this.uri;
    }

    public HttpSession getSession() {
        throw new IllegalStateException("Not implemented");
    }

    public HttpSession getSession(boolean pCreate) {
        throw new IllegalStateException("Not implemented");
    }

    public Principal getUserPrincipal() {
        throw new IllegalStateException("Not implemented");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new IllegalStateException("Not implemented");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new IllegalStateException("Not implemented");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new IllegalStateException("Not implemented");
    }

    public boolean isRequestedSessionIdValid() {
        throw new IllegalStateException("Not implemented");
    }

    public boolean isUserInRole(String pRole) {
        throw new IllegalStateException("Not implemented");
    }

    public Object getAttribute(String pKey) {
        return this.attributes.get(pKey);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            String contentType = this.getHeader("content-type");
            if (contentType != null) {
                StringTokenizer st = new StringTokenizer(contentType, ";");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken().trim();
                    if (!s.toLowerCase().startsWith("charset=")) continue;
                    return s.substring("charset=".length()).trim();
                }
            }
            return null;
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String pEncoding) {
        this.characterEncoding = pEncoding;
    }

    public int getContentLength() {
        try {
            return this.getIntHeader("content-length");
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader == null) {
            if (this.sistream == null) {
                if (this.postParametersParsed) {
                    throw new IllegalStateException("The method getInputStream() must not be called, after POST parameters have been parsed.");
                }
                this.sistream = this.istream;
            }
            return this.sistream;
        }
        throw new IllegalStateException("The method getReader() has already been invoked.");
    }

    public Locale getLocale() {
        throw new IllegalStateException("Not implemented");
    }

    public Enumeration getLocales() {
        throw new IllegalStateException("Not implemented");
    }

    private void addParameter(Map pParams, String pKey, String pValue) {
        Object o = pParams.get(pKey);
        if (o == null) {
            pParams.put(pKey, pValue);
        } else {
            ArrayList<Object> list;
            if (o instanceof String) {
                list = new ArrayList<Object>();
                list.add(o);
                pParams.put(pKey, list);
            } else {
                list = (ArrayList<Object>)o;
            }
            list.add(pParams);
        }
    }

    private void parseQueryString(Map pParams, String pQueryString, String pEncoding) throws UnsupportedEncodingException {
        StringTokenizer st = new StringTokenizer(pQueryString, "&");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            this.parseParameter(pParams, s, pEncoding);
        }
    }

    private void parseParameter(Map pParams, String pParam, String pEncoding) throws UnsupportedEncodingException {
        String value;
        String name;
        if (pParam.length() == 0) {
            return;
        }
        int offset = pParam.indexOf(61);
        if (offset == -1) {
            name = pParam;
            value = "";
        } else {
            name = pParam.substring(0, offset);
            value = pParam.substring(offset + 1);
        }
        this.addParameter(pParams, URLDecoder.decode(name, pEncoding), URLDecoder.decode(value, pEncoding));
    }

    private void parsePostData(Map pParams, InputStream pStream, String pEncoding) throws IOException {
        InputStreamReader r = new InputStreamReader(pStream, "US-ASCII");
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = ((Reader)r).read()) == -1 || c == 38) {
                this.parseParameter(pParams, sb.toString(), pEncoding);
                if (c == -1) break;
                sb.setLength(0);
                continue;
            }
            sb.append((char)c);
        }
    }

    protected void parseParameters() {
        if (this.parameters != null) {
            return;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        HashMap params = new HashMap();
        String s = this.getQueryString();
        if (s != null) {
            try {
                this.parseQueryString(params, s, encoding);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        if ("POST".equals(this.getMethod()) && "application/x-www-form-urlencoded".equals(this.getContentType())) {
            if (this.sistream != null || this.reader != null) {
                throw new IllegalStateException("POST parameters cannot be parsed, after getInputStream(), or getReader(), have been called.");
            }
            this.postParametersParsed = true;
            try {
                this.parsePostData(params, this.istream, encoding);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        this.parameters = params;
    }

    public String getParameter(String pName) {
        this.parseParameters();
        Object o = this.parameters.get(pName);
        if (o instanceof List) {
            o = ((List)o).get(0);
        }
        return (String)o;
    }

    public Map getParameterMap() {
        this.parseParameters();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Iterator iter = this.parameters.entrySet().iterator();
        while (iter.hasNext()) {
            String[] array;
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Object o = entry.getValue();
            if (o instanceof String) {
                array = new String[]{(String)o};
            } else if (o instanceof List) {
                List list = (List)o;
                array = list.toArray(new String[list.size()]);
            } else {
                throw new IllegalStateException("Invalid object: " + o.getClass().getName());
            }
            result.put(name, array);
        }
        return Collections.unmodifiableMap(result);
    }

    public Enumeration getParameterNames() {
        this.parseParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String pName) {
        this.parseParameters();
        Object o = this.parameters.get(pName);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        List list = (List)o;
        return list.toArray(new String[list.size()]);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this.sistream == null) {
            if (this.reader == null) {
                if (this.postParametersParsed) {
                    throw new IllegalStateException("The method getReader() must not be called, after POST parameters have been parsed.");
                }
                String encoding = this.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF8";
                }
                this.reader = new BufferedReader(new InputStreamReader((InputStream)this.istream, encoding));
            }
            return this.reader;
        }
        throw new IllegalStateException("The methods getInputStream(), and getReader(), are mutually exclusive.");
    }

    public String getRealPath(String pPath) {
        throw new IllegalStateException("Not implemented.");
    }

    public String getLocalAddr() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    public String getLocalName() {
        return this.socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public RequestDispatcher getRequestDispatcher(String pUri) {
        throw new IllegalStateException("Not implemented");
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return this.socket.getLocalAddress().getHostName();
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String pKey) {
        this.attributes.remove(pKey);
    }

    public void setAttribute(String pKey, Object pValue) {
        this.attributes.put(pKey, pValue);
    }

    protected String getHttpVersion() {
        return this.httpVersion;
    }
}

