/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.sikuli.basics.Debug;

public class FBConfig
extends GraphicsConfiguration {
    private int width = 0;
    private int height = 0;
    private int bitsPerPixel = 0;
    private int depth = 0;
    private int bigEndianFlag = 0;
    private int trueColorFlag = 0;
    private int redMax = 0;
    private int greenMax = 0;
    private int blueMax = 0;
    private int redShift = 0;
    private int greenShift = 0;
    private int blueShift = 0;
    private Rectangle bounds;
    private String desktopName = null;
    private int idnum;
    private ColorModel cm;
    private DataBuffer db;

    public FBConfig(int[] config, String name) {
        this.width = config[0];
        this.height = config[1];
        this.bitsPerPixel = config[2];
        this.depth = config[3];
        this.bigEndianFlag = config[4];
        this.trueColorFlag = config[5];
        this.redMax = config[6];
        this.greenMax = config[7];
        this.blueMax = config[8];
        this.redShift = config[9];
        this.greenShift = config[10];
        this.blueShift = config[11];
        this.desktopName = name;
        this.bounds = new Rectangle(0, 0, this.width, this.height);
        Debug.log(3, "VNC Server Response:", new Object[0]);
        for (int i : config) {
            Debug.log(3, "" + i, new Object[0]);
        }
        Debug.log(3, "Name: " + this.desktopName, new Object[0]);
        switch (this.bitsPerPixel) {
            case 8: {
                if (this.trueColorFlag != 0) {
                    this.idnum = 3;
                    Debug.log(3, "Error: Unsupported bits per pixel, setPixelFormatRequired", new Object[0]);
                    break;
                }
                this.idnum = 0;
                Debug.log(3, "Error: Unsupported bits per pixel, setPixelFormatRequired", new Object[0]);
                break;
            }
            case 16: {
                if (this.trueColorFlag != 0) {
                    this.idnum = 4;
                    Debug.log(3, "Error: Unsupported bits per pixel, setPixelFormatRequired", new Object[0]);
                    break;
                }
                this.idnum = 1;
                Debug.log(3, "Error: Unsupported bits per pixel, setPixelFormatRequired", new Object[0]);
                break;
            }
            case 32: {
                if (this.trueColorFlag != 0) {
                    this.idnum = 5;
                    int[] bitMasks = new int[]{0xFF0000, 65280, 255};
                    this.cm = new DirectColorModel(32, bitMasks[0], bitMasks[1], bitMasks[2]);
                    this.db = new DataBufferInt(this.width * this.height);
                    break;
                }
                this.idnum = 2;
                Debug.log(3, "Error: Unsupported bits per pixel, setPixelFormatRequired", new Object[0]);
                break;
            }
            default: {
                Debug.log(3, "Error: Unrecognized bits per pixel, setPixelFormatRequired", new Object[0]);
            }
        }
    }

    public Raster createCompatibleRaster() {
        switch (this.idnum) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                return null;
            }
            case 5: {
                int[] bitMasks = new int[]{0xFF0000, 65280, 255};
                return WritableRaster.createPackedRaster(this.db, this.width, this.height, this.width, bitMasks, null);
            }
        }
        return null;
    }

    public int getIdNum() {
        return this.idnum;
    }

    public String getName() {
        return this.desktopName;
    }

    @Override
    public GraphicsDevice getDevice() {
        return null;
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height) {
        switch (this.idnum) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                return new BufferedImage(width, height, 8);
            }
            case 5: {
                return new BufferedImage(width, height, 1);
            }
        }
        return new BufferedImage(width, height, 0);
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        return this.cm;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return null;
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        return null;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
}

