# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TriggerRun(Model):
    """Trigger runs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar trigger_run_id: Trigger run id.
    :vartype trigger_run_id: str
    :ivar trigger_name: Trigger name.
    :vartype trigger_name: str
    :ivar trigger_type: Trigger type.
    :vartype trigger_type: str
    :ivar trigger_run_timestamp: Trigger run start time.
    :vartype trigger_run_timestamp: datetime
    :ivar status: Trigger run status. Possible values include: 'Succeeded',
     'Failed', 'Inprogress'
    :vartype status: str or ~azure.mgmt.datafactory.models.TriggerRunStatus
    :ivar message: Trigger error message.
    :vartype message: str
    :ivar properties: List of property name and value related to trigger run.
     Name, value pair depends on type of trigger.
    :vartype properties: dict[str, str]
    :ivar triggered_pipelines: List of pipeline name and run Id triggered by
     the trigger run.
    :vartype triggered_pipelines: dict[str, str]
    """

    _validation = {
        'trigger_run_id': {'readonly': True},
        'trigger_name': {'readonly': True},
        'trigger_type': {'readonly': True},
        'trigger_run_timestamp': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
        'properties': {'readonly': True},
        'triggered_pipelines': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'trigger_run_id': {'key': 'triggerRunId', 'type': 'str'},
        'trigger_name': {'key': 'triggerName', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'trigger_run_timestamp': {'key': 'triggerRunTimestamp', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'triggered_pipelines': {'key': 'triggeredPipelines', 'type': '{str}'},
    }

    def __init__(self, additional_properties=None):
        self.additional_properties = additional_properties
        self.trigger_run_id = None
        self.trigger_name = None
        self.trigger_type = None
        self.trigger_run_timestamp = None
        self.status = None
        self.message = None
        self.properties = None
        self.triggered_pipelines = None
