# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .property_batch_operation import PropertyBatchOperation


class PutPropertyBatchOperation(PropertyBatchOperation):
    """Puts the specified property under the specified name.  Note that if one
    PropertyBatchOperation in a PropertyBatch fails,  the entire batch fails
    and cannot be committed in a transactional manner.
    .

    :param property_name:
    :type property_name: str
    :param kind: Polymorphic Discriminator
    :type kind: str
    :param value:
    :type value: :class:`PropertyValue
     <azure.servicefabric.models.PropertyValue>`
    :param custom_type_id:
    :type custom_type_id: str
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
        'custom_type_id': {'key': 'CustomTypeId', 'type': 'str'},
    }

    def __init__(self, property_name, value, custom_type_id=None):
        super(PutPropertyBatchOperation, self).__init__(property_name=property_name)
        self.value = value
        self.custom_type_id = custom_type_id
        self.kind = 'Put'
