# -*- coding: utf-8 -*-
"""
.. module:: data_structures.py
   :platform: Unix, Windows
   :synopsis: An implementation of data structures utilized in the project.

.. moduleauthor:: Sasha Petrenko <sap625@mst.edu>

"""

class SNode(object):
 
    def __init__(self, data, next):
        self.data = data
        self.next = next
 
 
class SingleList(object):
 
    head = None
    tail = None
 
    def show(self):
        print("Showing list data:")
        current_node = self.head
        while current_node is not None:
            print(current_node.data, " -> ",)
            current_node = current_node.next
        print(None)
 
    def append(self, data):
        node = SNode(data, None)
        if self.head is None:
            self.head = self.tail = node
        else:
            self.tail.next = node
        self.tail = node
 
    def remove(self, node_value):
        current_node = self.head
        previous_node = None
        while current_node is not None:
            if current_node.data == node_value:
                # if this is the first node (head)
                if previous_node is not None:
                    previous_node.next = current_node.next
                else:
                    self.head = current_node.next
 
            # needed for the next iteration
            previous_node = current_node
            current_node = current_node.next
            

class DNode(object):
    """A node class for doubly-linked lists
    """
    
    def __init__(self, data, prev, next):
        self.data = data
        self.prev = prev
        self.next = next
 
 
class DoubleList(object):
    """A class for doubly-linked lists 
    """
    
    head = None
    tail = None
 
    def append(self, data):
        new_node = DNode(data, None, None)
        if self.head is None:
            self.head = self.tail = new_node
        else:
            new_node.prev = self.tail
            new_node.next = None
            self.tail.next = new_node
            self.tail = new_node
 
    def remove(self, node_value):
        current_node = self.head
 
        while current_node is not None:
            if current_node.data == node_value:
                # if it's not the first element
                if current_node.prev is not None:
                    current_node.prev.next = current_node.next
                    current_node.next.prev = current_node.prev
                else:
                    # otherwise we have no prev (it's None), head is the next one, and prev becomes None
                    self.head = current_node.next
                    current_node.next.prev = None
 
            current_node = current_node.next
 
    def show(self):
        print("Show list data:")
        current_node = self.head
        while current_node is not None:
            print(current_node.prev.data if hasattr(current_node.prev, "data") else None,)
            print(current_node.data,)
            print(current_node.next.data if hasattr(current_node.next, "data") else None)
 
            current_node = current_node.next
        print("*"*50)
        
