# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class RegisteredServerCreateParameters(ProxyResource):
    """The parameters used when creating a registered server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param server_certificate: Registered Server Certificate
    :type server_certificate: str
    :param agent_version: Registered Server Agent Version
    :type agent_version: str
    :param server_os_version: Registered Server OS Version
    :type server_os_version: str
    :param last_heart_beat: Registered Server last heart beat
    :type last_heart_beat: str
    :param server_role: Registered Server serverRole
    :type server_role: str
    :param cluster_id: Registered Server clusterId
    :type cluster_id: str
    :param cluster_name: Registered Server clusterName
    :type cluster_name: str
    :param server_id: Registered Server serverId
    :type server_id: str
    :param friendly_name: Friendly Name
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_certificate': {'key': 'properties.serverCertificate', 'type': 'str'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'server_os_version': {'key': 'properties.serverOSVersion', 'type': 'str'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_name': {'key': 'properties.clusterName', 'type': 'str'},
        'server_id': {'key': 'properties.serverId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(self, *, server_certificate: str=None, agent_version: str=None, server_os_version: str=None, last_heart_beat: str=None, server_role: str=None, cluster_id: str=None, cluster_name: str=None, server_id: str=None, friendly_name: str=None, **kwargs) -> None:
        super(RegisteredServerCreateParameters, self).__init__(**kwargs)
        self.server_certificate = server_certificate
        self.agent_version = agent_version
        self.server_os_version = server_os_version
        self.last_heart_beat = last_heart_beat
        self.server_role = server_role
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.server_id = server_id
        self.friendly_name = friendly_name
