# Always prefer setuptools over distutils
from setuptools import setup 
from os import path

here = path.abspath(path.dirname(__file__))

install_requires = ["SQLAlchemy", "openpyxl"]
setup(
    name='buildmaster',
    version='0.9.0',
    description='web-based management system builder',

    # The project's main homepage.
    url='https://gitee.com/rushmore/buildmaster',

    # Author details
    author='Rushmore (Leiming Hong)',
    author_email='hong.leiming@qq.com',

    # Choose your license
    license='LGPL',
 
    classifiers=[  
        # Indicate who your project is intended for
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries :: Python Modules',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: MIT License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 3.7',
    ],
    install_requires=install_requires,
    keywords='DB',
    packages=['buildmaster'],
    package_dir={
        'buildmaster': 'buildmaster/db',
    }
)