# encoding=utf8

from openpyxl.styles import Font, Alignment, PatternFill, Border, Side
import string


def load_sheet(work_sheet):
    """
    从XLSX的sheet表格中读取出表数据（key-value列表）
    表格的第一行理解为字段属性描述，每个属性描述的格式为：<描述>-<后台需要的key>，例如：设备名-deviceName
    :param work_sheet: XLSX的sheet表
    :return:
    """
    is_first_line = True
    keys = []
    data = []
    for row in work_sheet.rows:
        if is_first_line:
            for c in row:
                name = c.value
                bb = name.split('-')
                if len(bb) > 1:
                    name = bb[1]
                else:
                    name = bb[0]
                keys.append(name)
            is_first_line = False
            continue
        j = 0
        r = {}
        for c in row:
            r[keys[j]] = c.value
            j += 1
        data.append(r)
    return data


def create_sheet(work_sheet, title, sheet_title, head_list, file_list, datas):

    # 水平居中, 垂直居中
    alignment_style = Alignment(vertical='center')
    # work_sheet['A1'].font = Font(size=16, bold=True)
    # work_sheet['A1'].alignment = Alignment(horizontal='center', vertical='center')
    work_sheet.title = sheet_title
    # 定义Border边框样式
    left, right, top, bottom = [Side(style='thin', color='000000')] * 4
    border_style = Border(left=left, right=right, top=top, bottom=bottom)
    # work_sheet.merge_cells(start_row=1, end_row=1, start_column=1, end_column=len(head_list))
    # work_sheet.cell(row=1, column=1).value = title
    # sheet的头部列表
    for index, item in enumerate(head_list):
        col = index + 1
        work_sheet.cell(row=1, column=col).value = item
        # 设置单元格样式文本水平居中、垂直居中、设置字体加粗、背景颜色、边框样式
        work_sheet.cell(row=1, column=col).alignment = alignment_style
        work_sheet.cell(row=1, column=col).font = Font(bold=True, size=9)
        work_sheet.cell(row=1, column=col).fill = PatternFill(fill_type='solid', fgColor='EE9A49')
        work_sheet.cell(row=1, column=col).border = border_style
        # 设置列宽、生成前26大写字母  ascii_uppercase生成所有大写字母
        upper_string = string.ascii_uppercase[:26]
    for col in upper_string:
        work_sheet.column_dimensions[col].width = 20
    row = 2
    for data in datas:
        for index, item in enumerate(file_list):
            col = index + 1
            work_sheet.cell(row, column=col).value = data[item]
            # 设置单元格样式文本水平居中、垂直居中、设置边框样式、设置字体大小
            work_sheet.cell(row, column=col).alignment = alignment_style
            work_sheet.cell(row, column=col).border = border_style
            work_sheet.cell(row, column=col).font = Font(size=9)
        row = row + 1
    return work_sheet
