########################################################################
# test/xslt/oc_20010315.py
# Olivier Cayrol reports output bug

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_output_oc_20010315(xslt_test):
    source = stringsource("<condition>car[@price &lt; 1000]</condition>")
    transform = stringsource("""\
<xsl:stylesheet version='1.0'
                xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:template match='condition'>
    <xsl:element name='template'>
      <xsl:attribute name='match'>
        <xsl:value-of select='.'/>
      </xsl:attribute>
      <xsl:text>This is a good one</xsl:text>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<template match='car[@price &lt; 1000]'>This is a good one</template>"""

if __name__ == '__main__':
    test_main()

