# -*- coding: iso-8859-1 -*-
########################################################################
# test/xslt/mg_20010530.py
#Matt Gushee had problems with xml:lang

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

commonsource = stringsource("""\
<?xml version="1.0" encoding="UTF-8"?>
<!--
<!DOCTYPE html PUBLIC
  "-//W3C//DTD XHTML 1.1//EN"
  "/usr/local/share/xml/xhtml/xhtml11.dtd"
>
-->
<html xmlns="http://www.w3.org/1999/xhtml"
  version="-//W3C//DTD XHTML 1.1//EN"
  xml:lang="en">
  <head>
    <title>Welcome</title>
  </head>

  <body xml:lang="en">
    <h1 xml:lang="en">Welcome</h1>
    <h1 xml:lang="ja">ようこそ</h1>
    <hr/>
    <p xml:lang="en">
The Kaiwa Club is an informal group for people who want to practice
Japanese conversation. We welcome members at all levels of
proficiency.
</p>
    <p xml:lang="ja">
会話倶楽部は日本語の会話を練習したい人のためのインフォーマルなグループで
ございます。レベルはかかわらず、新しい会員を大歓迎しております。
</p>
  </body>
</html>
""")

commontransform = stringsource("""\
<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="currentLanguage" select="'en'"/>

  <!-- Removed definition for charEncoding variable. -->

  <xsl:output method="html" encoding="utf-8"/>

  <xsl:template match="/">
  <!--
    <xsl:message><xsl:value-of select="$currentLanguage"/></xsl:message>
  -->
    <xsl:apply-templates select="*[lang($currentLanguage) or not(@xml:lang)]"/>
  </xsl:template>

  <xsl:template match="*">
  <!--
    <xsl:message>Processing: <xsl:value-of select="name()"/></xsl:message>
  -->
    <xsl:copy>
      <xsl:for-each select="@*[name() != 'id']">
	<xsl:copy/>
      </xsl:for-each>
      <xsl:apply-templates
	select="*[lang($currentLanguage) or not(@xml:lang)] | text()"/>
    </xsl:copy>
  </xsl:template>
    
</xsl:stylesheet>""")

class test_xslt_lang_1_mg_20010530(xslt_test):
    source = commonsource
    transform = commontransform
    parameters = {'currentLanguage' : 'en'}
    # output is xml-ish due to non-null namespace
    expected = """<html xmlns="http://www.w3.org/1999/xhtml" version="-//W3C//DTD XHTML 1.1//EN" xml:lang="en">\n  <head>\n    <title>Welcome</title>\n  </head>\n\n  <body xml:lang="en">\n    <h1 xml:lang="en">Welcome</h1>\n    \n    <hr/>\n    <p xml:lang="en">\nThe Kaiwa Club is an informal group for people who want to practice\nJapanese conversation. We welcome members at all levels of\nproficiency.\n</p>\n    \n  </body>\n</html>"""

class test_xslt_lang_2_mg_20010530(xslt_test):
    source = commonsource
    transform = commontransform
    parameters = {'currentLanguage' : 'ja'}
    expected = ""


class test_xslt_lang_3_mg_20010530(xslt_test):
    source = stringsource("""\
<?xml version="1.0" encoding="UTF-8"?>
<!--
<!DOCTYPE html PUBLIC
  "-//W3C//DTD XHTML 1.1//EN"
  "/usr/local/share/xml/xhtml/xhtml11.dtd"
>
-->
<html xmlns="http://www.w3.org/1999/xhtml"
  version="-//W3C//DTD XHTML 1.1//EN"
>
  <head>
    <title xml:lang="en">Welcome</title>
  </head>

  <body>
    <h1 xml:lang="en">Welcome</h1>
    <h1 xml:lang="ja">ようこそ</h1>
    <hr/>
    <p xml:lang="en">
The Kaiwa Club is an informal group for people who want to practice
Japanese conversation. We welcome members at all levels of
proficiency.
</p>
    <p xml:lang="ja">
会話倶楽部は日本語の会話を練習したい人のためのインフォーマルなグループで
ございます。レベルはかかわらず、新しい会員を大歓迎しております。
</p>
  </body>
</html>
""")
    transform = stringsource("""\
<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="currentLanguage" select="'en'"/>

  <xsl:output method="html" encoding="utf-8"/>

  <xsl:template match="*">
    <xsl:choose>
      <xsl:when test="@xml:lang">
        <!-- Don't shift context -->
        <xsl:apply-templates select="." mode="select-lang"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:for-each select="@*[name() != 'id']">
            <xsl:copy/>
          </xsl:for-each>
          <xsl:apply-templates/>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*" mode="select-lang">
    <xsl:if test="lang($currentLanguage)">
      <xsl:copy>
        <xsl:for-each select="@*[name() != 'id']">
          <xsl:copy/>
        </xsl:for-each>
        <xsl:apply-templates mode="select-lang"/>
      </xsl:copy>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>""")
    parameters = {'currentLanguage' : 'en'}
    # output is xml-ish because of non-null namespace
    expected = """<html xmlns="http://www.w3.org/1999/xhtml" version="-//W3C//DTD XHTML 1.1//EN">\n  <head>\n    <title xml:lang="en">Welcome</title>\n  </head>\n\n  <body>\n    <h1 xml:lang="en">Welcome</h1>\n    \n    <hr/>\n    <p xml:lang="en">\nThe Kaiwa Club is an informal group for people who want to practice\nJapanese conversation. We welcome members at all levels of\nproficiency.\n</p>\n    \n  </body>\n</html>"""

if __name__ == '__main__':
    test_main()

