########################################################################
# test/xslt/jt_20000808.py
# Jeni Tennison <jeni.tennison@epistemics.co.uk>'s implementation of 
# Oliver Becker's arbitrary sort/XPath conditionals trick.  Aug 8 2000.

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_sort_xpath_conditionals_jt_20000808(xslt_test):
    source = stringsource("""<items>
<item>MacBean</item>
<item>McBarlow</item>
<item>Re MacBart</item>
<item>Re McBeanie</item>
</items>""")
    transform = stringsource("""<xsl:stylesheet
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">

<xsl:output method="text"/>

<xsl:template match="items">
  <xsl:for-each select="item">
    <xsl:sort
      select="concat(
              substring(concat('Mac', substring-after(., 'Re Mc'), ', Re'),
                        1 div starts-with(., 'Re Mc')),
              substring(concat(substring-after(., 'Re '), ', Re'),
                        1 div (starts-with(., 'Re ') and
                        not(starts-with(., 'Re Mc')))),
              substring(concat('Mac', substring-after(., 'Mc')),
                        1 div (not(starts-with(., 'Re ')) and
                        starts-with(., 'Mc'))),
              substring(.,
                        1 div not(starts-with(.,'Mc') or
                        starts-with(., 'Re '))))" />
    <xsl:copy-of select="." />
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """McBarlowRe MacBartMacBeanRe McBeanie"""

if __name__ == '__main__':
    test_main()
    
