########################################################################
# test/xslt/js_20001012.py
# Jeremy J. Sydik <Jeremy.Sydik@iuniverse.com> found a bug in the 
# preceding-sibling axis

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_preceding_sibling_js_20001012(xslt_test):
    source = stringsource("""
<top>
    <prev val='1'/>
    <prev val='2'/>
    <prev val='3'/>
    <target/>
</top>
""")
    transform = stringsource("""
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template match='top'>
        <top><xsl:apply-templates/></top>
    </xsl:template>
    <xsl:template match='prev'>
        <prev val='{@val}'/>
    </xsl:template>
    <xsl:template match='target'>
        <output>
            <xsl:copy-of select='preceding-sibling::*[1]'/>
        </output>
    </xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<top>
    <prev val='1'/>
    <prev val='2'/>
    <prev val='3'/>
    <output><prev val='3'/></output>
</top>"""

if __name__ == '__main__':
    test_main()

    
